// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpprofiles "go.opentelemetry.io/proto/slim/otlp/profiles/v1development"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyScopeProfiles(t *testing.T) {
	for name, src := range genTestEncodingValuesScopeProfiles() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewScopeProfiles()
				CopyScopeProfiles(dest, src)
				assert.Equal(t, src, dest)
				CopyScopeProfiles(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyScopeProfilesSlice(t *testing.T) {
	src := []ScopeProfiles{}
	dest := []ScopeProfiles{}
	// Test CopyTo empty
	dest = CopyScopeProfilesSlice(dest, src)
	assert.Equal(t, []ScopeProfiles{}, dest)

	// Test CopyTo larger slice
	src = GenTestScopeProfilesSlice()
	dest = CopyScopeProfilesSlice(dest, src)
	assert.Equal(t, GenTestScopeProfilesSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyScopeProfilesSlice(dest, src)
	assert.Equal(t, GenTestScopeProfilesSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyScopeProfilesSlice(dest, []ScopeProfiles{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyScopeProfilesSlice(dest, src)
	assert.Equal(t, GenTestScopeProfilesSlice(), dest)
}

func TestCopyScopeProfilesPtrSlice(t *testing.T) {
	src := []*ScopeProfiles{}
	dest := []*ScopeProfiles{}
	// Test CopyTo empty
	dest = CopyScopeProfilesPtrSlice(dest, src)
	assert.Equal(t, []*ScopeProfiles{}, dest)

	// Test CopyTo larger slice
	src = GenTestScopeProfilesPtrSlice()
	dest = CopyScopeProfilesPtrSlice(dest, src)
	assert.Equal(t, GenTestScopeProfilesPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyScopeProfilesPtrSlice(dest, src)
	assert.Equal(t, GenTestScopeProfilesPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyScopeProfilesPtrSlice(dest, []*ScopeProfiles{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyScopeProfilesPtrSlice(dest, src)
	assert.Equal(t, GenTestScopeProfilesPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONScopeProfilesUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewScopeProfiles()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewScopeProfiles(), dest)
}

func TestMarshalAndUnmarshalJSONScopeProfiles(t *testing.T) {
	for name, src := range genTestEncodingValuesScopeProfiles() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewScopeProfiles()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteScopeProfiles(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoScopeProfilesFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesScopeProfiles() {
		t.Run(name, func(t *testing.T) {
			dest := NewScopeProfiles()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoScopeProfilesUnknown(t *testing.T) {
	dest := NewScopeProfiles()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewScopeProfiles(), dest)
}

func TestMarshalAndUnmarshalProtoScopeProfiles(t *testing.T) {
	for name, src := range genTestEncodingValuesScopeProfiles() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewScopeProfiles()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteScopeProfiles(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufScopeProfiles(t *testing.T) {
	for name, src := range genTestEncodingValuesScopeProfiles() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpprofiles.ScopeProfiles{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewScopeProfiles()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesScopeProfiles() map[string][]byte {
	return map[string][]byte{
		"invalid_field":             {0x02},
		"Scope/wrong_wire_type":     {0xc},
		"Scope/missing_value":       {0xa},
		"Profiles/wrong_wire_type":  {0x14},
		"Profiles/missing_value":    {0x12},
		"SchemaUrl/wrong_wire_type": {0x1c},
		"SchemaUrl/missing_value":   {0x1a},
	}
}

func genTestEncodingValuesScopeProfiles() map[string]*ScopeProfiles {
	return map[string]*ScopeProfiles{
		"empty":          NewScopeProfiles(),
		"Scope/test":     {Scope: *GenTestInstrumentationScope()},
		"Profiles/test":  {Profiles: []*Profile{{}, GenTestProfile()}},
		"SchemaUrl/test": {SchemaUrl: "test_schemaurl"},
	}
}
