// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpprofiles "go.opentelemetry.io/proto/slim/otlp/profiles/v1development"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyProfilesData(t *testing.T) {
	for name, src := range genTestEncodingValuesProfilesData() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewProfilesData()
				CopyProfilesData(dest, src)
				assert.Equal(t, src, dest)
				CopyProfilesData(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyProfilesDataSlice(t *testing.T) {
	src := []ProfilesData{}
	dest := []ProfilesData{}
	// Test CopyTo empty
	dest = CopyProfilesDataSlice(dest, src)
	assert.Equal(t, []ProfilesData{}, dest)

	// Test CopyTo larger slice
	src = GenTestProfilesDataSlice()
	dest = CopyProfilesDataSlice(dest, src)
	assert.Equal(t, GenTestProfilesDataSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyProfilesDataSlice(dest, src)
	assert.Equal(t, GenTestProfilesDataSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyProfilesDataSlice(dest, []ProfilesData{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyProfilesDataSlice(dest, src)
	assert.Equal(t, GenTestProfilesDataSlice(), dest)
}

func TestCopyProfilesDataPtrSlice(t *testing.T) {
	src := []*ProfilesData{}
	dest := []*ProfilesData{}
	// Test CopyTo empty
	dest = CopyProfilesDataPtrSlice(dest, src)
	assert.Equal(t, []*ProfilesData{}, dest)

	// Test CopyTo larger slice
	src = GenTestProfilesDataPtrSlice()
	dest = CopyProfilesDataPtrSlice(dest, src)
	assert.Equal(t, GenTestProfilesDataPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyProfilesDataPtrSlice(dest, src)
	assert.Equal(t, GenTestProfilesDataPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyProfilesDataPtrSlice(dest, []*ProfilesData{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyProfilesDataPtrSlice(dest, src)
	assert.Equal(t, GenTestProfilesDataPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONProfilesDataUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewProfilesData()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewProfilesData(), dest)
}

func TestMarshalAndUnmarshalJSONProfilesData(t *testing.T) {
	for name, src := range genTestEncodingValuesProfilesData() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewProfilesData()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteProfilesData(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoProfilesDataFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesProfilesData() {
		t.Run(name, func(t *testing.T) {
			dest := NewProfilesData()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoProfilesDataUnknown(t *testing.T) {
	dest := NewProfilesData()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewProfilesData(), dest)
}

func TestMarshalAndUnmarshalProtoProfilesData(t *testing.T) {
	for name, src := range genTestEncodingValuesProfilesData() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewProfilesData()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteProfilesData(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufProfilesData(t *testing.T) {
	for name, src := range genTestEncodingValuesProfilesData() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpprofiles.ProfilesData{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewProfilesData()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesProfilesData() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                    {0x02},
		"ResourceProfiles/wrong_wire_type": {0xc},
		"ResourceProfiles/missing_value":   {0xa},
		"Dictionary/wrong_wire_type":       {0x14},
		"Dictionary/missing_value":         {0x12},
	}
}

func genTestEncodingValuesProfilesData() map[string]*ProfilesData {
	return map[string]*ProfilesData{
		"empty":                 NewProfilesData(),
		"ResourceProfiles/test": {ResourceProfiles: []*ResourceProfiles{{}, GenTestResourceProfiles()}},
		"Dictionary/test":       {Dictionary: *GenTestProfilesDictionary()},
	}
}
