// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package deadline

import (
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
)

// WaitUntilFleetActive uses the AWSDeadlineCloud API operation
// GetFleet to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *Deadline) WaitUntilFleetActive(input *GetFleetInput) error {
	return c.WaitUntilFleetActiveWithContext(aws.BackgroundContext(), input)
}

// WaitUntilFleetActiveWithContext is an extended version of WaitUntilFleetActive.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) WaitUntilFleetActiveWithContext(ctx aws.Context, input *GetFleetInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilFleetActive",
		MaxAttempts: 180,
		Delay:       request.ConstantWaiterDelay(5 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "ACTIVE",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "CREATE_FAILED",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "UPDATE_FAILED",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *GetFleetInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetFleetRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilJobCreateComplete uses the AWSDeadlineCloud API operation
// GetJob to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *Deadline) WaitUntilJobCreateComplete(input *GetJobInput) error {
	return c.WaitUntilJobCreateCompleteWithContext(aws.BackgroundContext(), input)
}

// WaitUntilJobCreateCompleteWithContext is an extended version of WaitUntilJobCreateComplete.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) WaitUntilJobCreateCompleteWithContext(ctx aws.Context, input *GetJobInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilJobCreateComplete",
		MaxAttempts: 120,
		Delay:       request.ConstantWaiterDelay(1 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "lifecycleStatus",
				Expected: "CREATE_COMPLETE",
			},
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "lifecycleStatus",
				Expected: "UPDATE_IN_PROGRESS",
			},
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "lifecycleStatus",
				Expected: "UPDATE_FAILED",
			},
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "lifecycleStatus",
				Expected: "UPDATE_SUCCEEDED",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "lifecycleStatus",
				Expected: "UPLOAD_FAILED",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "lifecycleStatus",
				Expected: "CREATE_FAILED",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *GetJobInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetJobRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilLicenseEndpointDeleted uses the AWSDeadlineCloud API operation
// GetLicenseEndpoint to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *Deadline) WaitUntilLicenseEndpointDeleted(input *GetLicenseEndpointInput) error {
	return c.WaitUntilLicenseEndpointDeletedWithContext(aws.BackgroundContext(), input)
}

// WaitUntilLicenseEndpointDeletedWithContext is an extended version of WaitUntilLicenseEndpointDeleted.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) WaitUntilLicenseEndpointDeletedWithContext(ctx aws.Context, input *GetLicenseEndpointInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilLicenseEndpointDeleted",
		MaxAttempts: 234,
		Delay:       request.ConstantWaiterDelay(10 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:    request.SuccessWaiterState,
				Matcher:  request.ErrorWaiterMatch,
				Expected: "ResourceNotFoundException",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "NOT_READY",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *GetLicenseEndpointInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetLicenseEndpointRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilLicenseEndpointValid uses the AWSDeadlineCloud API operation
// GetLicenseEndpoint to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *Deadline) WaitUntilLicenseEndpointValid(input *GetLicenseEndpointInput) error {
	return c.WaitUntilLicenseEndpointValidWithContext(aws.BackgroundContext(), input)
}

// WaitUntilLicenseEndpointValidWithContext is an extended version of WaitUntilLicenseEndpointValid.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) WaitUntilLicenseEndpointValidWithContext(ctx aws.Context, input *GetLicenseEndpointInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilLicenseEndpointValid",
		MaxAttempts: 114,
		Delay:       request.ConstantWaiterDelay(10 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "READY",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "NOT_READY",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *GetLicenseEndpointInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetLicenseEndpointRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilQueueFleetAssociationStopped uses the AWSDeadlineCloud API operation
// GetQueueFleetAssociation to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *Deadline) WaitUntilQueueFleetAssociationStopped(input *GetQueueFleetAssociationInput) error {
	return c.WaitUntilQueueFleetAssociationStoppedWithContext(aws.BackgroundContext(), input)
}

// WaitUntilQueueFleetAssociationStoppedWithContext is an extended version of WaitUntilQueueFleetAssociationStopped.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) WaitUntilQueueFleetAssociationStoppedWithContext(ctx aws.Context, input *GetQueueFleetAssociationInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilQueueFleetAssociationStopped",
		MaxAttempts: 60,
		Delay:       request.ConstantWaiterDelay(10 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "STOPPED",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *GetQueueFleetAssociationInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetQueueFleetAssociationRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilQueueScheduling uses the AWSDeadlineCloud API operation
// GetQueue to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *Deadline) WaitUntilQueueScheduling(input *GetQueueInput) error {
	return c.WaitUntilQueueSchedulingWithContext(aws.BackgroundContext(), input)
}

// WaitUntilQueueSchedulingWithContext is an extended version of WaitUntilQueueScheduling.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) WaitUntilQueueSchedulingWithContext(ctx aws.Context, input *GetQueueInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilQueueScheduling",
		MaxAttempts: 70,
		Delay:       request.ConstantWaiterDelay(10 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "SCHEDULING",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *GetQueueInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetQueueRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilQueueSchedulingBlocked uses the AWSDeadlineCloud API operation
// GetQueue to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *Deadline) WaitUntilQueueSchedulingBlocked(input *GetQueueInput) error {
	return c.WaitUntilQueueSchedulingBlockedWithContext(aws.BackgroundContext(), input)
}

// WaitUntilQueueSchedulingBlockedWithContext is an extended version of WaitUntilQueueSchedulingBlocked.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) WaitUntilQueueSchedulingBlockedWithContext(ctx aws.Context, input *GetQueueInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilQueueSchedulingBlocked",
		MaxAttempts: 30,
		Delay:       request.ConstantWaiterDelay(10 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "SCHEDULING_BLOCKED",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *GetQueueInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetQueueRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}
