// Copyright 2026 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package merchantapi provides access to the Merchant API.
//
// For product documentation, see: https://developers.google.com/merchant/api
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/merchantapi/promotions_v1beta"
//	...
//	ctx := context.Background()
//	merchantapiService, err := merchantapi.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	merchantapiService, err := merchantapi.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	merchantapiService, err := merchantapi.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package merchantapi // import "google.golang.org/api/merchantapi/promotions_v1beta"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "merchantapi:promotions_v1beta"
const apiName = "merchantapi"
const apiVersion = "promotions_v1beta"
const basePath = "https://merchantapi.googleapis.com/"
const basePathTemplate = "https://merchantapi.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://merchantapi.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// Manage your product listings and accounts for Google Shopping
	ContentScope = "https://www.googleapis.com/auth/content"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/content",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Accounts = NewAccountsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Accounts *AccountsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewAccountsService(s *Service) *AccountsService {
	rs := &AccountsService{s: s}
	rs.Promotions = NewAccountsPromotionsService(s)
	return rs
}

type AccountsService struct {
	s *Service

	Promotions *AccountsPromotionsService
}

func NewAccountsPromotionsService(s *Service) *AccountsPromotionsService {
	rs := &AccountsPromotionsService{s: s}
	return rs
}

type AccountsPromotionsService struct {
	s *Service
}

// Attributes: Attributes.
type Attributes struct {
	// BrandExclusion: Optional. Product filter by brand exclusion
	// (https://support.google.com/merchants/answer/13861679?ref_topic=13773355&sjid=17642868584668136159-NC)
	// for the promotion. The product filter attributes only applies when the
	// products eligible for promotion product applicability
	// `product_applicability` attribute is set to specific_products
	// (https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
	BrandExclusion []string `json:"brandExclusion,omitempty"`
	// BrandInclusion: Optional. Product filter by brand for the promotion. The
	// product filter attributes only applies when the products eligible for
	// promotion product applicability `product_applicability` attribute is set to
	// specific_products
	// (https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
	BrandInclusion []string `json:"brandInclusion,omitempty"`
	// CouponValueType: Required. The [coupon value type]
	// (https://support.google.com/merchants/answer/13861986?ref_topic=13773355&sjid=17642868584668136159-NC)
	// attribute to signal the type of promotion that you are running. Depending on
	// type of the selected coupon value some attributes are required
	// (https://support.google.com/merchants/answer/6393006?ref_topic=7322920).
	//
	// Possible values:
	//   "COUPON_VALUE_TYPE_UNSPECIFIED" - Indicates that the coupon value type is
	// unspecified.
	//   "MONEY_OFF" - Money off coupon value type.
	//   "PERCENT_OFF" - Percent off coupon value type.
	//   "BUY_M_GET_N_MONEY_OFF" - Buy M quantity, get N money off coupon value
	// type. `minimum_purchase_quantity` and `get_this_quantity_discounted` must be
	// present. `money_off_amount` must also be present.
	//   "BUY_M_GET_N_PERCENT_OFF" - Buy M quantity, get N percent off coupon value
	// type. `minimum_purchase_quantity` and `get_this_quantity_discounted` must be
	// present. `percent_off_percentage` must also be present.
	//   "BUY_M_GET_MONEY_OFF" - Buy M quantity, get money off.
	// `minimum_purchase_quantity` and `money_off_amount` must be present.
	//   "BUY_M_GET_PERCENT_OFF" - Buy M quantity, get money off.
	// `minimum_purchase_quantity` and `percent_off_percentage` must be present.
	//   "FREE_GIFT" - Free gift with description only.
	//   "FREE_GIFT_WITH_VALUE" - Free gift with monetary value.
	//   "FREE_GIFT_WITH_ITEM_ID" - Free gift with item ID.
	//   "FREE_SHIPPING_STANDARD" - Standard free shipping coupon value type. Only
	// available for online promotions.
	//   "FREE_SHIPPING_OVERNIGHT" - Overnight free shipping coupon value type.
	// Only available for online promotions.
	//   "FREE_SHIPPING_TWO_DAY" - Two day free shipping coupon value type. Only
	// available for online promotions.
	CouponValueType string `json:"couponValueType,omitempty"`
	// CustomRedemptionRestriction: Optional. The custom redemption restriction for
	// the promotion. If the `redemption_restriction` field is set to `CUSTOM`,
	// this field must be set.
	CustomRedemptionRestriction string `json:"customRedemptionRestriction,omitempty"`
	// EventApplicability: Optional. Event applicability for this promotion. When
	// present, this field indicates you are creating a sales event
	// (https://support.google.com/merchants/answer/15523289?hl=en&sjid=11099988466404504696-NC)
	// and not a product promotion. Exactly one of `product_applicability` or
	// `event_applicability` must be set.
	//
	// Possible values:
	//   "EVENT_APPLICABILITY_UNSPECIFIED" - Indicates that the event applicability
	// is unspecified.
	//   "SITEWIDE" - Indicates that the promotion applies to the entire site.
	//   "SPECIFIC_CATEGORIES" - Indicates that the promotion applies to specific
	// categories. When this is set, the GoogleProductCategory field is required.
	EventApplicability string `json:"eventApplicability,omitempty"`
	// FreeGiftDescription: Optional. Free gift description
	// (https://support.google.com/merchants/answer/13847245?ref_topic=13773355&sjid=17642868584668136159-NC)
	// for the promotion.
	FreeGiftDescription string `json:"freeGiftDescription,omitempty"`
	// FreeGiftItemId: Optional. Free gift item ID
	// (https://support.google.com/merchants/answer/13857152?ref_topic=13773355&sjid=17642868584668136159-NC)
	// for the promotion.
	FreeGiftItemId string `json:"freeGiftItemId,omitempty"`
	// FreeGiftValue: Optional. Free gift value
	// (https://support.google.com/merchants/answer/13844477?ref_topic=13773355&sjid=17642868584668136159-NC)
	// for the promotion.
	FreeGiftValue *Price `json:"freeGiftValue,omitempty"`
	// GenericRedemptionCode: Optional. Generic redemption code for the promotion.
	// To be used with the `offerType` field and must meet the minimum requirements
	// (https://support.google.com/merchants/answer/13837405?ref_topic=13773355&sjid=17642868584668136159-NC).
	GenericRedemptionCode string `json:"genericRedemptionCode,omitempty"`
	// GetThisQuantityDiscounted: Optional. The number of items discounted in the
	// promotion. The attribute is set when `couponValueType` is equal to
	// `buy_m_get_n_money_off` or `buy_m_get_n_percent_off`.
	GetThisQuantityDiscounted int64 `json:"getThisQuantityDiscounted,omitempty,string"`
	// GoogleProductCategories: Optional. A list of Google product categories for
	// this promotion. Set if `EventApplicability` is `SPECIFIC_CATEGORIES`. Up to
	// 5 product categories can be specified. For more details on eligible values
	// for product categories, checkout the `google_product_category` attribute in
	// the Promotion data specification
	// (https://support.google.com/merchants/answer/2906014?hl=en).
	GoogleProductCategories []string `json:"googleProductCategories,omitempty"`
	// ItemGroupIdExclusion: Optional. Product filter by item group ID
	// (https://support.google.com/merchants/answer/13837298?ref_topic=13773355&sjid=17642868584668136159-NC).
	// The product filter attributes only applies when the products eligible for
	// promotion product applicability `product_applicability` attribute is set to
	// specific_products
	// (https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
	// exclusion for the promotion.
	ItemGroupIdExclusion []string `json:"itemGroupIdExclusion,omitempty"`
	// ItemGroupIdInclusion: Optional. Product filter by item group ID for the
	// promotion. The product filter attributes only applies when the products
	// eligible for promotion product applicability [product_applicability]
	// attribute is set to specific_products
	// (https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
	ItemGroupIdInclusion []string `json:"itemGroupIdInclusion,omitempty"`
	// ItemIdExclusion: Optional. Product filter by item ID exclusion
	// (https://support.google.com/merchants/answer/13863524?ref_topic=13773355&sjid=17642868584668136159-NC)
	// for the promotion. The product filter attributes only applies when the
	// products eligible for promotion product applicability
	// `product_applicability` attribute is set to specific_products
	// (https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
	ItemIdExclusion []string `json:"itemIdExclusion,omitempty"`
	// ItemIdInclusion: Optional. Product filter by item ID
	// (https://support.google.com/merchants/answer/13861565?ref_topic=13773355&sjid=17642868584668136159-NC)
	// for the promotion. The product filter attributes only applies when the
	// products eligible for promotion product applicability
	// `product_applicability` attribute is set to specific_products
	// (https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
	ItemIdInclusion []string `json:"itemIdInclusion,omitempty"`
	// LimitQuantity: Optional. Maximum purchase quantity
	// (https://support.google.com/merchants/answer/13861564?ref_topic=13773355&sjid=17642868584668136159-NC)
	// for the promotion.
	LimitQuantity int64 `json:"limitQuantity,omitempty,string"`
	// LimitValue: Optional. Maximum product price
	// (https://support.google.com/merchants/answer/2906014) for promotion.
	LimitValue *Price `json:"limitValue,omitempty"`
	// LongTitle: Required. Long title
	// (https://support.google.com/merchants/answer/13838102?ref_topic=13773355&sjid=17642868584668136159-NC)
	// for the promotion.
	LongTitle string `json:"longTitle,omitempty"`
	// MaxDiscountAmount: Optional. The maximum monetary discount a customer can
	// receive for the promotion. This field is only supported with the `Percent
	// off` coupon value type.
	MaxDiscountAmount *Price `json:"maxDiscountAmount,omitempty"`
	// MinimumPurchaseAmount: Optional. Minimum purchase amount
	// (https://support.google.com/merchants/answer/13837705?ref_topic=13773355&sjid=17642868584668136159-NC)
	// for the promotion.
	MinimumPurchaseAmount   *Price `json:"minimumPurchaseAmount,omitempty"`
	MinimumPurchaseQuantity int64  `json:"minimumPurchaseQuantity,omitempty,string"`
	// MoneyOffAmount: Optional. The money off amount
	// (https://support.google.com/merchants/answer/13838101?ref_topic=13773355&sjid=17642868584668136159-NC)
	// offered in the promotion.
	MoneyOffAmount *Price `json:"moneyOffAmount,omitempty"`
	// OfferType: Required. Type
	// (https://support.google.com/merchants/answer/13837405?ref_topic=13773355&sjid=17642868584668136159-NC)
	// of the promotion. Use this attribute to indicate whether or not customers
	// need a coupon code to redeem your promotion.
	//
	// Possible values:
	//   "OFFER_TYPE_UNSPECIFIED" - Unknown offer type.
	//   "NO_CODE" - Offer type without a code.
	//   "GENERIC_CODE" - Offer type with a code. Generic redemption code for the
	// promotion is required when `offerType` = `GENERIC_CODE`.
	OfferType string `json:"offerType,omitempty"`
	// PercentOff: Optional. The percentage discount
	// (https://support.google.com/merchants/answer/13837404?sjid=17642868584668136159-NC)
	// offered in the promotion.
	PercentOff int64 `json:"percentOff,omitempty,string"`
	// ProductApplicability: Optional. Applicability of the promotion to either all
	// products or only specific products
	// (https://support.google.com/merchants/answer/6396257?ref_topic=6396150&sjid=17642868584668136159-NC).
	// Exactly one of `product_applicability` or `event_applicability` must be set.
	//
	// Possible values:
	//   "PRODUCT_APPLICABILITY_UNSPECIFIED" - Which products the promotion applies
	// to is unknown.
	//   "ALL_PRODUCTS" - Applicable to all products.
	//   "SPECIFIC_PRODUCTS" - Applicable to only a single product or list of
	// products.
	ProductApplicability string `json:"productApplicability,omitempty"`
	// ProductTypeExclusion: Optional. Product filter by product type exclusion
	// (https://support.google.com/merchants/answer/13863746?ref_topic=13773355&sjid=17642868584668136159-NC)
	// for the promotion. The product filter attributes only applies when the
	// products eligible for promotion product applicability
	// `product_applicability` attribute is set to specific_products
	// (https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
	ProductTypeExclusion []string `json:"productTypeExclusion,omitempty"`
	// ProductTypeInclusion: Optional. Product filter by product type for the
	// promotion. The product filter attributes only applies when the products
	// eligible for promotion product applicability `product_applicability`
	// attribute is set to specific_products
	// (https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
	ProductTypeInclusion []string `json:"productTypeInclusion,omitempty"`
	// PromotionDestinations: Required. The list of destinations (also known as
	// Marketing methods (https://support.google.com/merchants/answer/15130232))
	// where the promotion applies to. If you don't specify a destination by
	// including a supported value in your data source, your promotion will display
	// in Shopping ads and free listings by default. You may have previously
	// submitted the following values as destinations for your products: Shopping
	// Actions, Surfaces across Google, Local surfaces across Google. To represent
	// these values use `FREE_LISTINGS`, `FREE_LOCAL_LISTINGS`,
	// `LOCAL_INVENTORY_ADS`. For more details see Promotion destination
	// (https://support.google.com/merchants/answer/13837465?sjid=5155774230887277618-NC)
	//
	// Possible values:
	//   "DESTINATION_ENUM_UNSPECIFIED" - Not specified.
	//   "SHOPPING_ADS" - [Shopping
	// ads](https://support.google.com/google-ads/answer/2454022).
	//   "DISPLAY_ADS" - [Display
	// ads](https://support.google.com/merchants/answer/6069387).
	//   "LOCAL_INVENTORY_ADS" - [Local inventory
	// ads](https://support.google.com/merchants/answer/3057972).
	//   "FREE_LISTINGS" - [Free
	// listings](https://support.google.com/merchants/answer/9199328).
	//   "FREE_LOCAL_LISTINGS" - [Free local product
	// listings](https://support.google.com/merchants/answer/9825611).
	//   "YOUTUBE_SHOPPING" - [YouTube
	// Shopping](https://support.google.com/merchants/answer/12362804).
	//   "YOUTUBE_SHOPPING_CHECKOUT" - Youtube shopping checkout.
	//   "YOUTUBE_AFFILIATE" - [Youtube
	// Affiliate](https://support.google.com/youtube/answer/13376398).
	//   "FREE_VEHICLE_LISTINGS" - [Free vehicle
	// listings](https://support.google.com/merchants/answer/11189169).
	//   "VEHICLE_ADS" - [Vehicle
	// ads](https://support.google.com/merchants/answer/11189169).
	//   "CLOUD_RETAIL" - [Cloud
	// retail](https://cloud.google.com/solutions/retail).
	//   "LOCAL_CLOUD_RETAIL" - [Local cloud
	// retail](https://cloud.google.com/solutions/retail).
	PromotionDestinations []string `json:"promotionDestinations,omitempty"`
	// PromotionDisplayTimePeriod: Optional. `TimePeriod` representation of the
	// promotion's display dates. This attribute specifies the date and time frame
	// when the promotion will be live on Google.com and Shopping ads. If the
	// display time period for promotion `promotion_display_time_period` attribute
	// is not specified, the promotion effective time period
	// `promotion_effective_time_period` determines the date and time frame when
	// the promotion will be live on Google.com and Shopping ads.
	PromotionDisplayTimePeriod *Interval `json:"promotionDisplayTimePeriod,omitempty"`
	// PromotionEffectiveTimePeriod: Required. `TimePeriod` representation of the
	// promotion's effective dates. This attribute specifies that the promotion can
	// be tested on your online store during this time period.
	PromotionEffectiveTimePeriod *Interval `json:"promotionEffectiveTimePeriod,omitempty"`
	// PromotionUrl: Optional. URL to the page on the merchant's site where the
	// promotion shows. Local Inventory ads promotions throw an error if no
	// `promotion_url` is included. URL is used to confirm that the promotion is
	// valid and can be redeemed.
	PromotionUrl string `json:"promotionUrl,omitempty"`
	// RedemptionRestriction: Optional. A restriction customers must meet before
	// they can redeem the promotion.
	//
	// Possible values:
	//   "REDEMPTION_RESTRICTION_UNSPECIFIED" - Indicates that the redemption
	// restriction is unspecified.
	//   "SUBSCRIBE" - The promotion can only be redeemed by signing up for a
	// subscription.
	//   "FIRST_ORDER" - The promotion can only be redeemed on the first order.
	//   "SIGNUP_FOR_EMAIL" - The promotion can only be redeemed by signing up for
	// email.
	//   "SIGNUP_FOR_TEXT" - The promotion can only be redeemed by signing up for
	// text message alerts.
	//   "CUSTOM" - The promotion can only be redeemed with a custom redemption
	// restriction. In this case, the `custom_redemption_restriction` field must be
	// set.
	RedemptionRestriction string `json:"redemptionRestriction,omitempty"`
	// StoreApplicability: Optional. Whether the promotion applies to all stores,
	// or only specified stores
	// (https://support.google.com/merchants/answer/13857563?sjid=17642868584668136159-NC).
	// Local Inventory ads promotions throw an error if no store applicability is
	// included. An `INVALID_ARGUMENT` error is thrown if `store_applicability` is
	// set to `ALL_STORES` and `store_codes_inclusion` or `score_code_exclusion` is
	// set to a value.
	//
	// Possible values:
	//   "STORE_APPLICABILITY_UNSPECIFIED" - Which store codes the promotion
	// applies to is unknown.
	//   "ALL_STORES" - Promotion applies to all stores.
	//   "SPECIFIC_STORES" - Promotion applies to only the specified stores.
	StoreApplicability string `json:"storeApplicability,omitempty"`
	// StoreCodesExclusion: Optional. Store codes to exclude
	// (https://support.google.com/merchants/answer/13859586?ref_topic=13773355&sjid=17642868584668136159-NC)
	// for the promotion. The store filter attributes only applies when the
	// `store_applicability` attribute is set to specific_stores
	// (https://support.google.com/merchants/answer/13857563?ref_topic=13773355&sjid=17642868584668136159-NC).
	StoreCodesExclusion []string `json:"storeCodesExclusion,omitempty"`
	// StoreCodesInclusion: Optional. Store codes to include
	// (https://support.google.com/merchants/answer/13857470?ref_topic=13773355&sjid=17642868584668136159-NC)
	// for the promotion. The store filter attributes only applies when the
	// `store_applicability` attribute is set to specific_stores
	// (https://support.google.com/merchants/answer/13857563?ref_topic=13773355&sjid=17642868584668136159-NC).
	// Store code (the store ID from your Business Profile) of the physical store
	// the product is sold in. See the Local product inventory data specification
	// (https://support.google.com/merchants/answer/3061342) for more information.
	StoreCodesInclusion []string `json:"storeCodesInclusion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BrandExclusion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BrandExclusion") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Attributes) MarshalJSON() ([]byte, error) {
	type NoMethod Attributes
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CustomAttribute: A message that represents custom attributes. Exactly one of
// `value` or `group_values` must not be empty.
type CustomAttribute struct {
	// GroupValues: Subattributes within this attribute group. If `group_values` is
	// not empty, `value` must be empty.
	GroupValues []*CustomAttribute `json:"groupValues,omitempty"`
	// Name: The name of the attribute.
	Name string `json:"name,omitempty"`
	// Value: The value of the attribute. If `value` is not empty, `group_values`
	// must be empty.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GroupValues") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GroupValues") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CustomAttribute) MarshalJSON() ([]byte, error) {
	type NoMethod CustomAttribute
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DestinationStatus: The status for the specified destination.
type DestinationStatus struct {
	// ReportingContext: Output only. The name of the promotion destination.
	//
	// Possible values:
	//   "REPORTING_CONTEXT_ENUM_UNSPECIFIED" - Not specified.
	//   "SHOPPING_ADS" - [Shopping
	// ads](https://support.google.com/merchants/answer/6149970).
	//   "DISCOVERY_ADS" - Deprecated: Use `DEMAND_GEN_ADS` instead. [Discovery and
	// Demand Gen ads](https://support.google.com/merchants/answer/13389785).
	//   "DEMAND_GEN_ADS" - [Demand Gen
	// ads](https://support.google.com/merchants/answer/13389785).
	//   "DEMAND_GEN_ADS_DISCOVER_SURFACE" - [Demand Gen ads on Discover
	// surface](https://support.google.com/merchants/answer/13389785).
	//   "VIDEO_ADS" - [Video
	// ads](https://support.google.com/google-ads/answer/6340491).
	//   "DISPLAY_ADS" - [Display
	// ads](https://support.google.com/merchants/answer/6069387).
	//   "LOCAL_INVENTORY_ADS" - [Local inventory
	// ads](https://support.google.com/merchants/answer/3271956).
	//   "VEHICLE_INVENTORY_ADS" - [Vehicle inventory
	// ads](https://support.google.com/merchants/answer/11544533).
	//   "FREE_LISTINGS" - [Free product
	// listings](https://support.google.com/merchants/answer/9199328).
	//   "FREE_LOCAL_LISTINGS" - [Free local product
	// listings](https://support.google.com/merchants/answer/9825611).
	//   "FREE_LOCAL_VEHICLE_LISTINGS" - [Free local vehicle
	// listings](https://support.google.com/merchants/answer/11544533).
	//   "YOUTUBE_AFFILIATE" - [Youtube
	// Affiliate](https://support.google.com/youtube/answer/13376398).
	//   "YOUTUBE_SHOPPING" - [YouTube
	// Shopping](https://support.google.com/merchants/answer/13478370).
	//   "CLOUD_RETAIL" - [Cloud
	// retail](https://cloud.google.com/solutions/retail).
	//   "LOCAL_CLOUD_RETAIL" - [Local cloud
	// retail](https://cloud.google.com/solutions/retail).
	//   "PRODUCT_REVIEWS" - [Product
	// Reviews](https://support.google.com/merchants/answer/14620732).
	//   "MERCHANT_REVIEWS" - [Merchant
	// Reviews](https://developers.google.com/merchant-review-feeds).
	//   "YOUTUBE_CHECKOUT" - YouTube Checkout .
	ReportingContext string `json:"reportingContext,omitempty"`
	// Status: Output only. The status for the specified destination.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unknown promotion state.
	//   "IN_REVIEW" - The promotion is under review.
	//   "REJECTED" - The promotion is disapproved.
	//   "LIVE" - The promotion is approved and active.
	//   "STOPPED" - The promotion is stopped by merchant.
	//   "EXPIRED" - The promotion is no longer active.
	//   "PENDING" - The promotion is not stopped, and all reviews are approved,
	// but the active date is in the future.
	Status string `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ReportingContext") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ReportingContext") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DestinationStatus) MarshalJSON() ([]byte, error) {
	type NoMethod DestinationStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InsertPromotionRequest: Request message for the `InsertPromotion` method.
type InsertPromotionRequest struct {
	// DataSource: Required. The data source of the promotion
	// (https://support.google.com/merchants/answer/6396268?sjid=5155774230887277618-NC)
	// Format: `accounts/{account}/dataSources/{datasource}`.
	DataSource string `json:"dataSource,omitempty"`
	// Promotion: Required. The promotion to insert.
	Promotion *Promotion `json:"promotion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataSource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InsertPromotionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InsertPromotionRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Interval: Represents a time interval, encoded as a Timestamp start
// (inclusive) and a Timestamp end (exclusive). The start must be less than or
// equal to the end. When the start equals the end, the interval is empty
// (matches no time). When both start and end are unspecified, the interval
// matches any time.
type Interval struct {
	// EndTime: Optional. Exclusive end of the interval. If specified, a Timestamp
	// matching this interval will have to be before the end.
	EndTime string `json:"endTime,omitempty"`
	// StartTime: Optional. Inclusive start of the interval. If specified, a
	// Timestamp matching this interval will have to be the same or after the
	// start.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Interval) MarshalJSON() ([]byte, error) {
	type NoMethod Interval
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ItemLevelIssue: The issue associated with the promotion.
type ItemLevelIssue struct {
	// ApplicableCountries: Output only. List of country codes (ISO 3166-1 alpha-2)
	// where issue applies to the offer.
	ApplicableCountries []string `json:"applicableCountries,omitempty"`
	// Attribute: Output only. The attribute's name, if the issue is caused by a
	// single attribute.
	Attribute string `json:"attribute,omitempty"`
	// Code: Output only. The error code of the issue.
	Code string `json:"code,omitempty"`
	// Description: Output only. A short issue description in English.
	Description string `json:"description,omitempty"`
	// Detail: Output only. A detailed issue description in English.
	Detail string `json:"detail,omitempty"`
	// Documentation: Output only. The URL of a web page to help with resolving
	// this issue.
	Documentation string `json:"documentation,omitempty"`
	// ReportingContext: Output only. The destination the issue applies to.
	//
	// Possible values:
	//   "REPORTING_CONTEXT_ENUM_UNSPECIFIED" - Not specified.
	//   "SHOPPING_ADS" - [Shopping
	// ads](https://support.google.com/merchants/answer/6149970).
	//   "DISCOVERY_ADS" - Deprecated: Use `DEMAND_GEN_ADS` instead. [Discovery and
	// Demand Gen ads](https://support.google.com/merchants/answer/13389785).
	//   "DEMAND_GEN_ADS" - [Demand Gen
	// ads](https://support.google.com/merchants/answer/13389785).
	//   "DEMAND_GEN_ADS_DISCOVER_SURFACE" - [Demand Gen ads on Discover
	// surface](https://support.google.com/merchants/answer/13389785).
	//   "VIDEO_ADS" - [Video
	// ads](https://support.google.com/google-ads/answer/6340491).
	//   "DISPLAY_ADS" - [Display
	// ads](https://support.google.com/merchants/answer/6069387).
	//   "LOCAL_INVENTORY_ADS" - [Local inventory
	// ads](https://support.google.com/merchants/answer/3271956).
	//   "VEHICLE_INVENTORY_ADS" - [Vehicle inventory
	// ads](https://support.google.com/merchants/answer/11544533).
	//   "FREE_LISTINGS" - [Free product
	// listings](https://support.google.com/merchants/answer/9199328).
	//   "FREE_LOCAL_LISTINGS" - [Free local product
	// listings](https://support.google.com/merchants/answer/9825611).
	//   "FREE_LOCAL_VEHICLE_LISTINGS" - [Free local vehicle
	// listings](https://support.google.com/merchants/answer/11544533).
	//   "YOUTUBE_AFFILIATE" - [Youtube
	// Affiliate](https://support.google.com/youtube/answer/13376398).
	//   "YOUTUBE_SHOPPING" - [YouTube
	// Shopping](https://support.google.com/merchants/answer/13478370).
	//   "CLOUD_RETAIL" - [Cloud
	// retail](https://cloud.google.com/solutions/retail).
	//   "LOCAL_CLOUD_RETAIL" - [Local cloud
	// retail](https://cloud.google.com/solutions/retail).
	//   "PRODUCT_REVIEWS" - [Product
	// Reviews](https://support.google.com/merchants/answer/14620732).
	//   "MERCHANT_REVIEWS" - [Merchant
	// Reviews](https://developers.google.com/merchant-review-feeds).
	//   "YOUTUBE_CHECKOUT" - YouTube Checkout .
	ReportingContext string `json:"reportingContext,omitempty"`
	// Resolution: Output only. Whether the issue can be resolved by the merchant.
	Resolution string `json:"resolution,omitempty"`
	// Severity: Output only. How this issue affects serving of the promotion.
	//
	// Possible values:
	//   "SEVERITY_UNSPECIFIED" - Not specified.
	//   "NOT_IMPACTED" - This issue represents a warning and does not have a
	// direct affect on the promotion.
	//   "DEMOTED" - The promotion is demoted and most likely have limited
	// performance in search results
	//   "DISAPPROVED" - Issue disapproves the promotion.
	Severity string `json:"severity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApplicableCountries") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApplicableCountries") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ItemLevelIssue) MarshalJSON() ([]byte, error) {
	type NoMethod ItemLevelIssue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListPromotionsResponse: Response message for the `ListPromotions` method.
type ListPromotionsResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Promotions: The processed promotions from the specified account.
	Promotions []*Promotion `json:"promotions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListPromotionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListPromotionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Price: The price represented as a number and currency.
type Price struct {
	// AmountMicros: The price represented as a number in micros (1 million micros
	// is an equivalent to one's currency standard unit, for example, 1 USD =
	// 1000000 micros).
	AmountMicros int64 `json:"amountMicros,omitempty,string"`
	// CurrencyCode: The currency of the price using three-letter acronyms
	// according to ISO 4217 (http://en.wikipedia.org/wiki/ISO_4217).
	CurrencyCode string `json:"currencyCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AmountMicros") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AmountMicros") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Price) MarshalJSON() ([]byte, error) {
	type NoMethod Price
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ProductChange: The change that happened to the product including old value,
// new value, country code as the region code and reporting context.
type ProductChange struct {
	// NewValue: The new value of the changed resource or attribute. If empty, it
	// means that the product was deleted. Will have one of these values :
	// (`approved`, `pending`, `disapproved`, ``)
	NewValue string `json:"newValue,omitempty"`
	// OldValue: The old value of the changed resource or attribute. If empty, it
	// means that the product was created. Will have one of these values :
	// (`approved`, `pending`, `disapproved`, ``)
	OldValue string `json:"oldValue,omitempty"`
	// RegionCode: Countries that have the change (if applicable). Represented in
	// the ISO 3166 format.
	RegionCode string `json:"regionCode,omitempty"`
	// ReportingContext: Reporting contexts that have the change (if applicable).
	// Currently this field supports only (`SHOPPING_ADS`, `LOCAL_INVENTORY_ADS`,
	// `YOUTUBE_SHOPPING`, `YOUTUBE_CHECKOUT`, `YOUTUBE_AFFILIATE`) from the enum
	// value ReportingContextEnum
	// (/merchant/api/reference/rest/Shared.Types/ReportingContextEnum)
	//
	// Possible values:
	//   "REPORTING_CONTEXT_ENUM_UNSPECIFIED" - Not specified.
	//   "SHOPPING_ADS" - [Shopping
	// ads](https://support.google.com/merchants/answer/6149970).
	//   "DISCOVERY_ADS" - Deprecated: Use `DEMAND_GEN_ADS` instead. [Discovery and
	// Demand Gen ads](https://support.google.com/merchants/answer/13389785).
	//   "DEMAND_GEN_ADS" - [Demand Gen
	// ads](https://support.google.com/merchants/answer/13389785).
	//   "DEMAND_GEN_ADS_DISCOVER_SURFACE" - [Demand Gen ads on Discover
	// surface](https://support.google.com/merchants/answer/13389785).
	//   "VIDEO_ADS" - [Video
	// ads](https://support.google.com/google-ads/answer/6340491).
	//   "DISPLAY_ADS" - [Display
	// ads](https://support.google.com/merchants/answer/6069387).
	//   "LOCAL_INVENTORY_ADS" - [Local inventory
	// ads](https://support.google.com/merchants/answer/3271956).
	//   "VEHICLE_INVENTORY_ADS" - [Vehicle inventory
	// ads](https://support.google.com/merchants/answer/11544533).
	//   "FREE_LISTINGS" - [Free product
	// listings](https://support.google.com/merchants/answer/9199328).
	//   "FREE_LOCAL_LISTINGS" - [Free local product
	// listings](https://support.google.com/merchants/answer/9825611).
	//   "FREE_LOCAL_VEHICLE_LISTINGS" - [Free local vehicle
	// listings](https://support.google.com/merchants/answer/11544533).
	//   "YOUTUBE_AFFILIATE" - [Youtube
	// Affiliate](https://support.google.com/youtube/answer/13376398).
	//   "YOUTUBE_SHOPPING" - [YouTube
	// Shopping](https://support.google.com/merchants/answer/13478370).
	//   "CLOUD_RETAIL" - [Cloud
	// retail](https://cloud.google.com/solutions/retail).
	//   "LOCAL_CLOUD_RETAIL" - [Local cloud
	// retail](https://cloud.google.com/solutions/retail).
	//   "PRODUCT_REVIEWS" - [Product
	// Reviews](https://support.google.com/merchants/answer/14620732).
	//   "MERCHANT_REVIEWS" - [Merchant
	// Reviews](https://developers.google.com/merchant-review-feeds).
	//   "YOUTUBE_CHECKOUT" - YouTube Checkout .
	ReportingContext string `json:"reportingContext,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NewValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NewValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductChange) MarshalJSON() ([]byte, error) {
	type NoMethod ProductChange
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ProductStatusChangeMessage: The message that the merchant will receive to
// notify about product status change event
type ProductStatusChangeMessage struct {
	// Account: The target account that owns the entity that changed. Format :
	// `accounts/{merchant_id}`
	Account string `json:"account,omitempty"`
	// Attribute: The attribute in the resource that changed, in this case it will
	// be always `Status`.
	//
	// Possible values:
	//   "ATTRIBUTE_UNSPECIFIED" - Unspecified attribute
	//   "STATUS" - Status of the changed entity
	Attribute string `json:"attribute,omitempty"`
	// Changes: A message to describe the change that happened to the product
	Changes []*ProductChange `json:"changes,omitempty"`
	// EventTime: The time at which the event was generated. If you want to order
	// the notification messages you receive you should rely on this field not on
	// the order of receiving the notifications.
	EventTime string `json:"eventTime,omitempty"`
	// ExpirationTime: Optional. The product expiration time. This field will not
	// be set if the notification is sent for a product deletion event.
	ExpirationTime string `json:"expirationTime,omitempty"`
	// ManagingAccount: The account that manages the merchant's account. can be the
	// same as merchant id if it is standalone account. Format :
	// `accounts/{service_provider_id}`
	ManagingAccount string `json:"managingAccount,omitempty"`
	// Resource: The product name. Format: `accounts/{account}/products/{product}`
	Resource string `json:"resource,omitempty"`
	// ResourceId: The product id.
	ResourceId string `json:"resourceId,omitempty"`
	// ResourceType: The resource that changed, in this case it will always be
	// `Product`.
	//
	// Possible values:
	//   "RESOURCE_UNSPECIFIED" - Unspecified resource
	//   "PRODUCT" - Resource type : product
	ResourceType string `json:"resourceType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Account") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Account") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductStatusChangeMessage) MarshalJSON() ([]byte, error) {
	type NoMethod ProductStatusChangeMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Promotion: Represents a promotion. See the following articles for more
// details. Required promotion input attributes to pass data validation checks
// are primarily defined below: * Promotions data specification
// (https://support.google.com/merchants/answer/2906014) * Local promotions
// data specification (https://support.google.com/merchants/answer/10146130)
// After inserting, updating a promotion input, it may take several minutes
// before the final promotion can be retrieved.
type Promotion struct {
	// Attributes: Optional. A list of promotion attributes.
	Attributes *Attributes `json:"attributes,omitempty"`
	// ContentLanguage: Required. The two-letter ISO 639-1
	// (http://en.wikipedia.org/wiki/ISO_639-1) language code for the promotion.
	// Promotions is only for selected languages
	// (https://support.google.com/merchants/answer/4588281?ref_topic=6396150&sjid=18314938579342094533-NC#option3&zippy=).
	ContentLanguage string `json:"contentLanguage,omitempty"`
	// CustomAttributes: Optional. A list of custom (merchant-provided) attributes.
	// It can also be used for submitting any attribute of the data specification
	// in its generic form (for example, `{ "name": "size type", "value": "regular"
	// }`). This is useful for submitting attributes not explicitly exposed by the
	// API.
	CustomAttributes []*CustomAttribute `json:"customAttributes,omitempty"`
	// DataSource: Output only. The primary data source of the promotion.
	DataSource string `json:"dataSource,omitempty"`
	// Name: Identifier. The name of the promotion. Format:
	// `accounts/{account}/promotions/{promotion}`
	Name string `json:"name,omitempty"`
	// PromotionId: Required. The user provided promotion ID to uniquely identify
	// the promotion. Follow minimum requirements
	// (https://support.google.com/merchants/answer/7050148?ref_topic=7322920&sjid=871860036916537104-NC#minimum_requirements)
	// to prevent promotion disapprovals.
	PromotionId string `json:"promotionId,omitempty"`
	// PromotionStatus: Output only. The status of a promotion
	// (https://support.google.com/merchants/answer/3398326?ref_topic=7322924&sjid=5155774230887277618-NC),
	// data validation issues, that is, information about a promotion computed
	// asynchronously.
	PromotionStatus *PromotionStatus `json:"promotionStatus,omitempty"`
	// RedemptionChannel: Required. Redemption channel
	// (https://support.google.com/merchants/answer/13837674?ref_topic=13773355&sjid=17642868584668136159-NC)
	// for the promotion. At least one channel is required.
	//
	// Possible values:
	//   "REDEMPTION_CHANNEL_UNSPECIFIED" - Indicates that the channel is
	// unspecified.
	//   "IN_STORE" - Indicates that the channel is in store. This is same as
	// `local` channel used for `products`.
	//   "ONLINE" - Indicates that the channel is online.
	RedemptionChannel []string `json:"redemptionChannel,omitempty"`
	// TargetCountry: Required. The target country used as part of the unique
	// identifier. Represented as a CLDR territory code
	// (https://github.com/unicode-org/cldr/blob/latest/common/main/en.xml).
	// Promotions are only available in selected countries, Free Listings and
	// Shopping ads (https://support.google.com/merchants/answer/4588460) [Local
	// Inventory ads](https://support.google.com/merchants/answer/10146326)
	TargetCountry string `json:"targetCountry,omitempty"`
	// VersionNumber: Optional. Represents the existing version (freshness) of the
	// promotion, which can be used to preserve the right order when multiple
	// updates are done at the same time. If set, the insertion is prevented when
	// version number is lower than the current version number of the existing
	// promotion. Re-insertion (for example, promotion refresh after 30 days) can
	// be performed with the current `version_number`. If the operation is
	// prevented, the aborted exception will be thrown.
	VersionNumber int64 `json:"versionNumber,omitempty,string"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Attributes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Attributes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Promotion) MarshalJSON() ([]byte, error) {
	type NoMethod Promotion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PromotionStatus: The status of the promotion.
type PromotionStatus struct {
	// CreationDate: Output only. Date on which the promotion has been created in
	// ISO 8601 (http://en.wikipedia.org/wiki/ISO_8601) format: Date, time, and
	// offset, for example `2020-01-02T09:00:00+01:00` or `2020-01-02T09:00:00Z`
	CreationDate string `json:"creationDate,omitempty"`
	// DestinationStatuses: Output only. The intended destinations for the
	// promotion.
	DestinationStatuses []*DestinationStatus `json:"destinationStatuses,omitempty"`
	// ItemLevelIssues: Output only. A list of issues associated with the
	// promotion.
	ItemLevelIssues []*ItemLevelIssue `json:"itemLevelIssues,omitempty"`
	// LastUpdateDate: Output only. Date on which the promotion status has been
	// last updated in ISO 8601 (http://en.wikipedia.org/wiki/ISO_8601) format:
	// Date, time, and offset, for example `2020-01-02T09:00:00+01:00` or
	// `2020-01-02T09:00:00Z`
	LastUpdateDate string `json:"lastUpdateDate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreationDate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreationDate") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PromotionStatus) MarshalJSON() ([]byte, error) {
	type NoMethod PromotionStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AccountsPromotionsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves the promotion from your Merchant Center account. After
// inserting or updating a promotion input, it may take several minutes before
// the updated promotion can be retrieved.
//
//   - name: The name of the promotion to retrieve. Format:
//     `accounts/{account}/promotions/{promotions}`.
func (r *AccountsPromotionsService) Get(name string) *AccountsPromotionsGetCall {
	c := &AccountsPromotionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsPromotionsGetCall) Fields(s ...googleapi.Field) *AccountsPromotionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *AccountsPromotionsGetCall) IfNoneMatch(entityTag string) *AccountsPromotionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsPromotionsGetCall) Context(ctx context.Context) *AccountsPromotionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsPromotionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsPromotionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "promotions/v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "merchantapi.accounts.promotions.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "merchantapi.accounts.promotions.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Promotion.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *AccountsPromotionsGetCall) Do(opts ...googleapi.CallOption) (*Promotion, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Promotion{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "merchantapi.accounts.promotions.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountsPromotionsInsertCall struct {
	s                      *Service
	parent                 string
	insertpromotionrequest *InsertPromotionRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Insert: Inserts a promotion for your Merchant Center account. If the
// promotion already exists, then it updates the promotion instead.
//
//   - parent: The account where the promotion will be inserted. Format:
//     accounts/{account}.
func (r *AccountsPromotionsService) Insert(parent string, insertpromotionrequest *InsertPromotionRequest) *AccountsPromotionsInsertCall {
	c := &AccountsPromotionsInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.insertpromotionrequest = insertpromotionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsPromotionsInsertCall) Fields(s ...googleapi.Field) *AccountsPromotionsInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsPromotionsInsertCall) Context(ctx context.Context) *AccountsPromotionsInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsPromotionsInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsPromotionsInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.insertpromotionrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "promotions/v1beta/{+parent}/promotions:insert")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "merchantapi.accounts.promotions.insert", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "merchantapi.accounts.promotions.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *Promotion.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *AccountsPromotionsInsertCall) Do(opts ...googleapi.CallOption) (*Promotion, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Promotion{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "merchantapi.accounts.promotions.insert", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountsPromotionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the promotions in your Merchant Center account. The response
// might contain fewer items than specified by `pageSize`. Rely on `pageToken`
// to determine if there are more items to be requested. After inserting or
// updating a promotion, it may take several minutes before the updated
// processed promotion can be retrieved.
//
//   - parent: The account to list processed promotions for. Format:
//     `accounts/{account}`.
func (r *AccountsPromotionsService) List(parent string) *AccountsPromotionsListCall {
	c := &AccountsPromotionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// promotions to return. The service may return fewer than this value. The
// maximum value is 250; values above 250 will be coerced to 250. If
// unspecified, the maximum number of promotions will be returned.
func (c *AccountsPromotionsListCall) PageSize(pageSize int64) *AccountsPromotionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListPromotions` call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// `ListPromotions` must match the call that provided the page token.
func (c *AccountsPromotionsListCall) PageToken(pageToken string) *AccountsPromotionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsPromotionsListCall) Fields(s ...googleapi.Field) *AccountsPromotionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *AccountsPromotionsListCall) IfNoneMatch(entityTag string) *AccountsPromotionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsPromotionsListCall) Context(ctx context.Context) *AccountsPromotionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsPromotionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsPromotionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "promotions/v1beta/{+parent}/promotions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "merchantapi.accounts.promotions.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "merchantapi.accounts.promotions.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListPromotionsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsPromotionsListCall) Do(opts ...googleapi.CallOption) (*ListPromotionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListPromotionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "merchantapi.accounts.promotions.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AccountsPromotionsListCall) Pages(ctx context.Context, f func(*ListPromotionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
