// Copyright 2026 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package merchantapi provides access to the Merchant API.
//
// For product documentation, see: https://developers.google.com/merchant/api
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/merchantapi/issueresolution/v1"
//	...
//	ctx := context.Background()
//	merchantapiService, err := merchantapi.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	merchantapiService, err := merchantapi.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	merchantapiService, err := merchantapi.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package merchantapi // import "google.golang.org/api/merchantapi/issueresolution/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "merchantapi:issueresolution_v1"
const apiName = "merchantapi"
const apiVersion = "issueresolution_v1"
const basePath = "https://merchantapi.googleapis.com/"
const basePathTemplate = "https://merchantapi.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://merchantapi.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// Manage your product listings and accounts for Google Shopping
	ContentScope = "https://www.googleapis.com/auth/content"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/content",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Accounts = NewAccountsService(s)
	s.Issueresolution = NewIssueresolutionService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Accounts *AccountsService

	Issueresolution *IssueresolutionService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewAccountsService(s *Service) *AccountsService {
	rs := &AccountsService{s: s}
	rs.AggregateProductStatuses = NewAccountsAggregateProductStatusesService(s)
	return rs
}

type AccountsService struct {
	s *Service

	AggregateProductStatuses *AccountsAggregateProductStatusesService
}

func NewAccountsAggregateProductStatusesService(s *Service) *AccountsAggregateProductStatusesService {
	rs := &AccountsAggregateProductStatusesService{s: s}
	return rs
}

type AccountsAggregateProductStatusesService struct {
	s *Service
}

func NewIssueresolutionService(s *Service) *IssueresolutionService {
	rs := &IssueresolutionService{s: s}
	return rs
}

type IssueresolutionService struct {
	s *Service
}

// Action: An actionable step that can be executed to solve the issue.
type Action struct {
	// BuiltinSimpleAction: Action implemented and performed in (your) third-party
	// application. The application should point the business to the place, where
	// they can access the corresponding functionality or provide instructions, if
	// the specific functionality is not available.
	BuiltinSimpleAction *BuiltInSimpleAction `json:"builtinSimpleAction,omitempty"`
	// BuiltinUserInputAction: Action implemented and performed in (your)
	// third-party application. The application needs to show an additional content
	// and input form to the business as specified for given action. They can
	// trigger the action only when they provided all required inputs.
	BuiltinUserInputAction *BuiltInUserInputAction `json:"builtinUserInputAction,omitempty"`
	// ButtonLabel: Label of the action button.
	ButtonLabel string `json:"buttonLabel,omitempty"`
	// ExternalAction: Action that is implemented and performed outside of (your)
	// third-party application. The application needs to redirect the business to
	// the external location where they can perform the action.
	ExternalAction *ExternalAction `json:"externalAction,omitempty"`
	// IsAvailable: Controlling whether the button is active or disabled. The value
	// is 'false' when the action was already requested or is not available. If the
	// action is not available then a reason will be present. If (your) third-party
	// application shows a disabled button for action that is not available, then
	// it should also show reasons.
	IsAvailable bool `json:"isAvailable,omitempty"`
	// Reasons: List of reasons why the action is not available. The list of
	// reasons is empty if the action is available. If there is only one reason, it
	// can be displayed next to the disabled button. If there are more reasons, all
	// of them should be displayed, for example in a pop-up dialog.
	Reasons []*Reason `json:"reasons,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BuiltinSimpleAction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BuiltinSimpleAction") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Action) MarshalJSON() ([]byte, error) {
	type NoMethod Action
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ActionFlow: Flow that can be selected for an action. When a business selects
// a flow, application should open a dialog with more information and input
// form.
type ActionFlow struct {
	// DialogButtonLabel: Label for the button to trigger the action from the
	// action dialog. For example: "Request review"
	DialogButtonLabel string `json:"dialogButtonLabel,omitempty"`
	// DialogCallout: Important message to be highlighted in the request dialog.
	// For example: "You can only request a review for disagreeing with this issue
	// once. If it's not approved, you'll need to fix the issue and wait a few days
	// before you can request another review."
	DialogCallout *Callout `json:"dialogCallout,omitempty"`
	// DialogMessage: Message displayed in the request dialog. For example: "Make
	// sure you've fixed all your country-specific issues. If not, you may have to
	// wait 7 days to request another review". There may be an more information to
	// be shown in a tooltip.
	DialogMessage *TextWithTooltip `json:"dialogMessage,omitempty"`
	// DialogTitle: Title of the request dialog. For example: "Before you request a
	// review"
	DialogTitle string `json:"dialogTitle,omitempty"`
	// Id: Not for display but need to be sent back for the selected action flow.
	Id string `json:"id,omitempty"`
	// Inputs: A list of input fields.
	Inputs []*InputField `json:"inputs,omitempty"`
	// Label: Text value describing the intent for the action flow. It can be used
	// as an input label if business needs to pick one of multiple flows. For
	// example: "I disagree with the issue"
	Label string `json:"label,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DialogButtonLabel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DialogButtonLabel") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ActionFlow) MarshalJSON() ([]byte, error) {
	type NoMethod ActionFlow
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ActionInput: Input provided by the business.
type ActionInput struct {
	// ActionFlowId: Required. Id of the selected action flow.
	ActionFlowId string `json:"actionFlowId,omitempty"`
	// InputValues: Required. Values for input fields.
	InputValues []*InputValue `json:"inputValues,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActionFlowId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActionFlowId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ActionInput) MarshalJSON() ([]byte, error) {
	type NoMethod ActionInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AdditionalContent: Long text from external source.
type AdditionalContent struct {
	// Paragraphs: Long text organized into paragraphs.
	Paragraphs []string `json:"paragraphs,omitempty"`
	// Title: Title of the additional content;
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Paragraphs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Paragraphs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AdditionalContent) MarshalJSON() ([]byte, error) {
	type NoMethod AdditionalContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AggregateProductStatus: Aggregate product statuses for a given reporting
// context and country.
type AggregateProductStatus struct {
	// Country: The country of the aggregate product statuses. Represented as a
	// CLDR territory code
	// (https://github.com/unicode-org/cldr/blob/latest/common/main/en.xml).
	Country string `json:"country,omitempty"`
	// ItemLevelIssues: The product issues that affect the given reporting context
	// and country.
	ItemLevelIssues []*ItemLevelIssue `json:"itemLevelIssues,omitempty"`
	// Name: Identifier. The name of the `AggregateProductStatuses` resource.
	// Format:
	// `accounts/{account}/aggregateProductStatuses/{aggregateProductStatuses}`
	Name string `json:"name,omitempty"`
	// ReportingContext: The reporting context of the aggregate product statuses.
	//
	// Possible values:
	//   "REPORTING_CONTEXT_ENUM_UNSPECIFIED" - Not specified.
	//   "SHOPPING_ADS" - [Shopping
	// ads](https://support.google.com/merchants/answer/6149970).
	//   "DISCOVERY_ADS" - Deprecated: Use `DEMAND_GEN_ADS` instead. [Discovery and
	// Demand Gen ads](https://support.google.com/merchants/answer/13389785).
	//   "DEMAND_GEN_ADS" - [Demand Gen
	// ads](https://support.google.com/merchants/answer/13389785).
	//   "DEMAND_GEN_ADS_DISCOVER_SURFACE" - [Demand Gen ads on Discover
	// surface](https://support.google.com/merchants/answer/13389785).
	//   "VIDEO_ADS" - [Video
	// ads](https://support.google.com/google-ads/answer/6340491).
	//   "DISPLAY_ADS" - [Display
	// ads](https://support.google.com/merchants/answer/6069387).
	//   "LOCAL_INVENTORY_ADS" - [Local inventory
	// ads](https://support.google.com/merchants/answer/3271956).
	//   "VEHICLE_INVENTORY_ADS" - [Vehicle inventory
	// ads](https://support.google.com/merchants/answer/11544533).
	//   "FREE_LISTINGS" - [Free product
	// listings](https://support.google.com/merchants/answer/9199328).
	//   "FREE_LOCAL_LISTINGS" - [Free local product
	// listings](https://support.google.com/merchants/answer/9825611).
	//   "FREE_LOCAL_VEHICLE_LISTINGS" - [Free local vehicle
	// listings](https://support.google.com/merchants/answer/11544533).
	//   "YOUTUBE_AFFILIATE" - [Youtube
	// Affiliate](https://support.google.com/youtube/answer/13376398).
	//   "YOUTUBE_SHOPPING" - [YouTube
	// Shopping](https://support.google.com/merchants/answer/13478370).
	//   "CLOUD_RETAIL" - [Cloud
	// retail](https://cloud.google.com/solutions/retail).
	//   "LOCAL_CLOUD_RETAIL" - [Local cloud
	// retail](https://cloud.google.com/solutions/retail).
	//   "PRODUCT_REVIEWS" - [Product
	// Reviews](https://support.google.com/merchants/answer/14620732).
	//   "MERCHANT_REVIEWS" - [Merchant
	// Reviews](https://developers.google.com/merchant-review-feeds).
	//   "YOUTUBE_CHECKOUT" - YouTube Checkout .
	ReportingContext string `json:"reportingContext,omitempty"`
	// Stats: Products statistics for the given reporting context and country.
	Stats *Stats `json:"stats,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Country") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Country") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AggregateProductStatus) MarshalJSON() ([]byte, error) {
	type NoMethod AggregateProductStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Breakdown: A detailed impact breakdown for a group of regions where the
// impact of the issue on different shopping destinations is the same.
type Breakdown struct {
	// Details: Human readable, localized description of issue's effect on
	// different targets. Should be rendered as a list. For example: * "Products
	// not showing in ads" * "Products not showing organically"
	Details []string `json:"details,omitempty"`
	// Regions: Lists of regions. Should be rendered as a title for this group of
	// details. The full list should be shown to the business. If the list is too
	// long, it is recommended to make it expandable.
	Regions []*Region `json:"regions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Details") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Details") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Breakdown) MarshalJSON() ([]byte, error) {
	type NoMethod Breakdown
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BuiltInSimpleAction: Action that is implemented and performed in (your)
// third-party application. Represents various functionality that is expected
// to be available to business and will help them with resolving the issue. The
// application should point the business to the place, where they can access
// the corresponding functionality. If the functionality is not supported, it
// is recommended to explain the situation to the business and provide them
// with instructions how to solve the issue.
type BuiltInSimpleAction struct {
	// AdditionalContent: Long text from an external source that should be
	// available to the business. Present when the type is
	// `SHOW_ADDITIONAL_CONTENT`.
	AdditionalContent *AdditionalContent `json:"additionalContent,omitempty"`
	// AttributeCode: The attribute that needs to be updated. Present when the type
	// is `EDIT_ITEM_ATTRIBUTE`. This field contains a code for attribute,
	// represented in snake_case. You can find a list of product's attributes, with
	// their codes here (https://support.google.com/merchants/answer/7052112).
	AttributeCode string `json:"attributeCode,omitempty"`
	// Type: The type of action that represents a functionality that is expected to
	// be available in third-party application.
	//
	// Possible values:
	//   "BUILT_IN_SIMPLE_ACTION_TYPE_UNSPECIFIED" - Default value. Will never be
	// provided by the API.
	//   "VERIFY_PHONE" - Redirect the business to the part of your application
	// where they can verify their phone.
	//   "CLAIM_WEBSITE" - Redirect the business to the part of your application
	// where they can claim their website.
	//   "ADD_PRODUCTS" - Redirect the business to the part of your application
	// where they can add products.
	//   "ADD_CONTACT_INFO" - Open a form where the business can edit their contact
	// information.
	//   "LINK_ADS_ACCOUNT" - Redirect the business to the part of your application
	// where they can link ads account.
	//   "ADD_BUSINESS_REGISTRATION_NUMBER" - Open a form where the business can
	// add their business registration number.
	//   "EDIT_ITEM_ATTRIBUTE" - Open a form where the business can edit an
	// attribute. The attribute that needs to be updated is specified in
	// attribute_code field of the action.
	//   "FIX_ACCOUNT_ISSUE" - Redirect the business from the product issues to the
	// diagnostic page with their account issues in your application. This action
	// will be returned only for product issues that are caused by an account issue
	// and thus the business should resolve the problem on the account level.
	//   "SHOW_ADDITIONAL_CONTENT" - Show additional content to the business. This
	// action will be used for example to deliver a justification from national
	// authority.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdditionalContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalContent") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BuiltInSimpleAction) MarshalJSON() ([]byte, error) {
	type NoMethod BuiltInSimpleAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BuiltInUserInputAction: Action that is implemented and performed in (your)
// third-party application. The application needs to show an additional content
// and input form to the business. They can start the action only when they
// provided all required inputs. The application will request processing of the
// action by calling the triggeraction method
// (https://developers.google.com/merchant/api/reference/rest/issueresolution_v1/issueresolution/triggeraction).
type BuiltInUserInputAction struct {
	// ActionContext: Contains the action's context that must be included as part
	// of the TriggerActionPayload.action_context in TriggerActionRequest.payload
	// to call the `triggeraction` method. The content should be treated as opaque
	// and must not be modified.
	ActionContext string `json:"actionContext,omitempty"`
	// Flows: Actions may provide multiple different flows. Business selects one
	// that fits best to their intent. Selecting the flow is the first step in
	// user's interaction with the action. It affects what input fields will be
	// available and required and also how the request will be processed.
	Flows []*ActionFlow `json:"flows,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActionContext") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActionContext") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BuiltInUserInputAction) MarshalJSON() ([]byte, error) {
	type NoMethod BuiltInUserInputAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Callout: An important message that should be highlighted. Usually displayed
// as a banner.
type Callout struct {
	// FullMessage: A full message that needs to be shown to the business.
	FullMessage *TextWithTooltip `json:"fullMessage,omitempty"`
	// StyleHint: Can be used to render messages with different severity in
	// different styles. Snippets off all types contain important information that
	// should be displayed to the business.
	//
	// Possible values:
	//   "CALLOUT_STYLE_HINT_UNSPECIFIED" - Default value. Will never be provided
	// by the API.
	//   "ERROR" - The most important type of information highlighting problems,
	// like an unsuccessful outcome of previously requested actions.
	//   "WARNING" - Information warning about pending problems, risks or
	// deadlines.
	//   "INFO" - Default severity for important information like pending status of
	// previously requested action or cooldown for re-review.
	StyleHint string `json:"styleHint,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FullMessage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FullMessage") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Callout) MarshalJSON() ([]byte, error) {
	type NoMethod Callout
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CheckboxInput: Checkbox input allows the business to provide a boolean
// value. Corresponds to the html input type=checkbox
// (https://www.w3.org/TR/2012/WD-html-markup-20121025/input.checkbox.html#input.checkbox).
// If the business checks the box, the input value for the field is `true`,
// otherwise it is `false`. This type of input is often used as a confirmation
// that the business completed required steps before they are allowed to start
// the action. In such a case, the input field is marked as required and the
// button to trigger the action should stay disabled until the business checks
// the box.
type CheckboxInput struct {
}

// CheckboxInputValue: Value for checkbox input field.
type CheckboxInputValue struct {
	// Value: Required. True if the business checked the box field. False
	// otherwise.
	Value bool `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Value") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Value") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CheckboxInputValue) MarshalJSON() ([]byte, error) {
	type NoMethod CheckboxInputValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ChoiceInput: Choice input allows the business to select one of the offered
// choices. Some choices may be linked to additional input fields that should
// be displayed under or next to the choice option. The value for the
// additional input field needs to be provided only when the specific choice is
// selected by the the business. For example, additional input field can be
// hidden or disabled until the business selects the specific choice.
type ChoiceInput struct {
	// Options: A list of choices. Only one option can be selected.
	Options []*ChoiceInputOption `json:"options,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Options") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Options") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ChoiceInput) MarshalJSON() ([]byte, error) {
	type NoMethod ChoiceInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ChoiceInputOption: A choice that the business can select.
type ChoiceInputOption struct {
	// AdditionalInput: Input that should be displayed when this option is
	// selected. The additional input will not contain a `ChoiceInput`.
	AdditionalInput *InputField `json:"additionalInput,omitempty"`
	// Id: Not for display but need to be sent back for the selected choice option.
	Id string `json:"id,omitempty"`
	// Label: Short description of the choice option. There may be more information
	// to be shown as a tooltip.
	Label *TextWithTooltip `json:"label,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdditionalInput") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalInput") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ChoiceInputOption) MarshalJSON() ([]byte, error) {
	type NoMethod ChoiceInputOption
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ChoiceInputValue: Value for choice input field.
type ChoiceInputValue struct {
	// ChoiceInputOptionId: Required. Id of the option that was selected by the
	// business.
	ChoiceInputOptionId string `json:"choiceInputOptionId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChoiceInputOptionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChoiceInputOptionId") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ChoiceInputValue) MarshalJSON() ([]byte, error) {
	type NoMethod ChoiceInputValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExternalAction: Action that is implemented and performed outside of the
// third-party application. It should redirect the business to the provided URL
// of an external system where they can perform the action. For example to
// request a review in the Merchant Center.
type ExternalAction struct {
	// Type: The type of external action.
	//
	// Possible values:
	//   "EXTERNAL_ACTION_TYPE_UNSPECIFIED" - Default value. Will never be provided
	// by the API.
	//   "REVIEW_PRODUCT_ISSUE_IN_MERCHANT_CENTER" - Redirect to Merchant Center
	// where the business can request a review for issue related to their product.
	//   "REVIEW_ACCOUNT_ISSUE_IN_MERCHANT_CENTER" - Redirect to Merchant Center
	// where the business can request a review for issue related to their account.
	//   "LEGAL_APPEAL_IN_HELP_CENTER" - Redirect to the form in Help Center where
	// the business can request a legal appeal for the issue.
	//   "VERIFY_IDENTITY_IN_MERCHANT_CENTER" - Redirect to Merchant Center where
	// the business can perform identity verification.
	//   "VERIFY_BUSINESS_VIDEO_IN_MERCHANT_CENTER" - Redirect to Merchant Center
	// where the business can perform business video verification.
	Type string `json:"type,omitempty"`
	// Uri: URL to external system, for example Merchant Center, where the business
	// can perform the action.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Type") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Type") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExternalAction) MarshalJSON() ([]byte, error) {
	type NoMethod ExternalAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Impact: Overall impact of the issue.
type Impact struct {
	// Breakdowns: Detailed impact breakdown. Explains the types of restriction the
	// issue has in different shopping destinations and territory. If present, it
	// should be rendered to the business. Can be shown as a mouse over dropdown or
	// a dialog. Each breakdown item represents a group of regions with the same
	// impact details.
	Breakdowns []*Breakdown `json:"breakdowns,omitempty"`
	// Message: Optional. Message summarizing the overall impact of the issue. If
	// present, it should be rendered to the business. For example: "Disapproves
	// 90k offers in 25 countries"
	Message string `json:"message,omitempty"`
	// Severity: The severity of the issue.
	//
	// Possible values:
	//   "SEVERITY_UNSPECIFIED" - Default value. Will never be provided by the API.
	//   "ERROR" - Causes either an account suspension or an item disapproval.
	// Errors should be resolved as soon as possible to ensure items are eligible
	// to appear in results again.
	//   "WARNING" - Warnings can negatively impact the performance of ads and can
	// lead to item or account suspensions in the future unless the issue is
	// resolved.
	//   "INFO" - Infos are suggested optimizations to increase data quality.
	// Resolving these issues is recommended, but not required.
	Severity string `json:"severity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Breakdowns") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Breakdowns") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Impact) MarshalJSON() ([]byte, error) {
	type NoMethod Impact
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InputField: Input field that needs to be available to the business. If the
// field is marked as required, then a value needs to be provided for a
// successful processing of the request.
type InputField struct {
	// CheckboxInput: Input field to provide a boolean value. Corresponds to the
	// html input type=checkbox
	// (https://www.w3.org/TR/2012/WD-html-markup-20121025/input.checkbox.html#input.checkbox).
	CheckboxInput *CheckboxInput `json:"checkboxInput,omitempty"`
	// ChoiceInput: Input field to select one of the offered choices. Corresponds
	// to the html input type=radio
	// (https://www.w3.org/TR/2012/WD-html-markup-20121025/input.radio.html#input.radio).
	ChoiceInput *ChoiceInput `json:"choiceInput,omitempty"`
	// Id: Not for display but need to be sent back for the given input field.
	Id string `json:"id,omitempty"`
	// Label: Input field label. There may be more information to be shown in a
	// tooltip.
	Label *TextWithTooltip `json:"label,omitempty"`
	// Required: Whether the field is required. The action button needs to stay
	// disabled till values for all required fields are provided.
	Required bool `json:"required,omitempty"`
	// TextInput: Input field to provide text information. Corresponds to the html
	// input type=text
	// (https://www.w3.org/TR/2012/WD-html-markup-20121025/input.text.html#input.text)
	// or html textarea
	// (https://www.w3.org/TR/2012/WD-html-markup-20121025/textarea.html#textarea).
	TextInput *TextInput `json:"textInput,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CheckboxInput") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CheckboxInput") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InputField) MarshalJSON() ([]byte, error) {
	type NoMethod InputField
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InputValue: Input provided by the business for input field.
type InputValue struct {
	// CheckboxInputValue: Value for checkbox input field.
	CheckboxInputValue *CheckboxInputValue `json:"checkboxInputValue,omitempty"`
	// ChoiceInputValue: Value for choice input field.
	ChoiceInputValue *ChoiceInputValue `json:"choiceInputValue,omitempty"`
	// InputFieldId: Required. Id of the corresponding input field.
	InputFieldId string `json:"inputFieldId,omitempty"`
	// TextInputValue: Value for text input field.
	TextInputValue *TextInputValue `json:"textInputValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CheckboxInputValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CheckboxInputValue") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InputValue) MarshalJSON() ([]byte, error) {
	type NoMethod InputValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ItemLevelIssue: The ItemLevelIssue of the product status.
type ItemLevelIssue struct {
	// Attribute: The attribute's name, if the issue is caused by a single
	// attribute.
	Attribute string `json:"attribute,omitempty"`
	// Code: The error code of the issue.
	Code string `json:"code,omitempty"`
	// Description: A short issue description in English.
	Description string `json:"description,omitempty"`
	// Detail: A detailed issue description in English.
	Detail string `json:"detail,omitempty"`
	// DocumentationUri: The URL of a web page to help with resolving this issue.
	DocumentationUri string `json:"documentationUri,omitempty"`
	// ProductCount: The number of products affected by this issue.
	ProductCount int64 `json:"productCount,omitempty,string"`
	// Resolution: Whether the issue can be resolved by the merchant.
	//
	// Possible values:
	//   "RESOLUTION_UNSPECIFIED" - Not specified.
	//   "MERCHANT_ACTION" - The issue can be resolved by the merchant.
	//   "PENDING_PROCESSING" - The issue will be resolved auomatically.
	Resolution string `json:"resolution,omitempty"`
	// Severity: How this issue affects serving of the offer.
	//
	// Possible values:
	//   "SEVERITY_UNSPECIFIED" - Not specified.
	//   "NOT_IMPACTED" - This issue represents a warning and does not have a
	// direct affect on the product.
	//   "DEMOTED" - The product is demoted and most likely have limited
	// performance in search results
	//   "DISAPPROVED" - Issue disapproves the product.
	Severity string `json:"severity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Attribute") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Attribute") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ItemLevelIssue) MarshalJSON() ([]byte, error) {
	type NoMethod ItemLevelIssue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListAggregateProductStatusesResponse: Response message for the
// `ListAggregateProductStatuses` method.
type ListAggregateProductStatusesResponse struct {
	// AggregateProductStatuses: The `AggregateProductStatuses` resources for the
	// given account.
	AggregateProductStatuses []*AggregateProductStatus `json:"aggregateProductStatuses,omitempty"`
	// NextPageToken: A token, which can be sent as `pageToken` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AggregateProductStatuses")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AggregateProductStatuses") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListAggregateProductStatusesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAggregateProductStatusesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ProductChange: The change that happened to the product including old value,
// new value, country code as the region code and reporting context.
type ProductChange struct {
	// NewValue: The new value of the changed resource or attribute. If empty, it
	// means that the product was deleted. Will have one of these values :
	// (`approved`, `pending`, `disapproved`, ``)
	NewValue string `json:"newValue,omitempty"`
	// OldValue: The old value of the changed resource or attribute. If empty, it
	// means that the product was created. Will have one of these values :
	// (`approved`, `pending`, `disapproved`, ``)
	OldValue string `json:"oldValue,omitempty"`
	// RegionCode: Countries that have the change (if applicable). Represented in
	// the ISO 3166 format.
	RegionCode string `json:"regionCode,omitempty"`
	// ReportingContext: Reporting contexts that have the change (if applicable).
	// Currently this field supports only (`SHOPPING_ADS`, `LOCAL_INVENTORY_ADS`,
	// `YOUTUBE_SHOPPING`, `YOUTUBE_CHECKOUT`, `YOUTUBE_AFFILIATE`) from the enum
	// value ReportingContextEnum
	// (/merchant/api/reference/rest/Shared.Types/ReportingContextEnum)
	//
	// Possible values:
	//   "REPORTING_CONTEXT_ENUM_UNSPECIFIED" - Not specified.
	//   "SHOPPING_ADS" - [Shopping
	// ads](https://support.google.com/merchants/answer/6149970).
	//   "DISCOVERY_ADS" - Deprecated: Use `DEMAND_GEN_ADS` instead. [Discovery and
	// Demand Gen ads](https://support.google.com/merchants/answer/13389785).
	//   "DEMAND_GEN_ADS" - [Demand Gen
	// ads](https://support.google.com/merchants/answer/13389785).
	//   "DEMAND_GEN_ADS_DISCOVER_SURFACE" - [Demand Gen ads on Discover
	// surface](https://support.google.com/merchants/answer/13389785).
	//   "VIDEO_ADS" - [Video
	// ads](https://support.google.com/google-ads/answer/6340491).
	//   "DISPLAY_ADS" - [Display
	// ads](https://support.google.com/merchants/answer/6069387).
	//   "LOCAL_INVENTORY_ADS" - [Local inventory
	// ads](https://support.google.com/merchants/answer/3271956).
	//   "VEHICLE_INVENTORY_ADS" - [Vehicle inventory
	// ads](https://support.google.com/merchants/answer/11544533).
	//   "FREE_LISTINGS" - [Free product
	// listings](https://support.google.com/merchants/answer/9199328).
	//   "FREE_LOCAL_LISTINGS" - [Free local product
	// listings](https://support.google.com/merchants/answer/9825611).
	//   "FREE_LOCAL_VEHICLE_LISTINGS" - [Free local vehicle
	// listings](https://support.google.com/merchants/answer/11544533).
	//   "YOUTUBE_AFFILIATE" - [Youtube
	// Affiliate](https://support.google.com/youtube/answer/13376398).
	//   "YOUTUBE_SHOPPING" - [YouTube
	// Shopping](https://support.google.com/merchants/answer/13478370).
	//   "CLOUD_RETAIL" - [Cloud
	// retail](https://cloud.google.com/solutions/retail).
	//   "LOCAL_CLOUD_RETAIL" - [Local cloud
	// retail](https://cloud.google.com/solutions/retail).
	//   "PRODUCT_REVIEWS" - [Product
	// Reviews](https://support.google.com/merchants/answer/14620732).
	//   "MERCHANT_REVIEWS" - [Merchant
	// Reviews](https://developers.google.com/merchant-review-feeds).
	//   "YOUTUBE_CHECKOUT" - YouTube Checkout .
	ReportingContext string `json:"reportingContext,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NewValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NewValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductChange) MarshalJSON() ([]byte, error) {
	type NoMethod ProductChange
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ProductStatusChangeMessage: The message that the merchant will receive to
// notify about product status change event
type ProductStatusChangeMessage struct {
	// Account: The target account that owns the entity that changed. Format :
	// `accounts/{merchant_id}`
	Account string `json:"account,omitempty"`
	// Attribute: The attribute in the resource that changed, in this case it will
	// be always `Status`.
	//
	// Possible values:
	//   "ATTRIBUTE_UNSPECIFIED" - Unspecified attribute
	//   "STATUS" - Status of the changed entity
	Attribute string `json:"attribute,omitempty"`
	// Changes: A message to describe the change that happened to the product
	Changes []*ProductChange `json:"changes,omitempty"`
	// EventTime: The time at which the event was generated. If you want to order
	// the notification messages you receive you should rely on this field not on
	// the order of receiving the notifications.
	EventTime string `json:"eventTime,omitempty"`
	// ExpirationTime: Optional. The product expiration time. This field will not
	// be set if the notification is sent for a product deletion event.
	ExpirationTime string `json:"expirationTime,omitempty"`
	// ManagingAccount: The account that manages the merchant's account. can be the
	// same as merchant id if it is standalone account. Format :
	// `accounts/{service_provider_id}`
	ManagingAccount string `json:"managingAccount,omitempty"`
	// Resource: The product name. Format: `accounts/{account}/products/{product}`
	Resource string `json:"resource,omitempty"`
	// ResourceId: The product id.
	ResourceId string `json:"resourceId,omitempty"`
	// ResourceType: The resource that changed, in this case it will always be
	// `Product`.
	//
	// Possible values:
	//   "RESOURCE_UNSPECIFIED" - Unspecified resource
	//   "PRODUCT" - Resource type : product
	ResourceType string `json:"resourceType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Account") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Account") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductStatusChangeMessage) MarshalJSON() ([]byte, error) {
	type NoMethod ProductStatusChangeMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Reason: A single reason why the action is not available.
type Reason struct {
	// Action: Optional. An action that needs to be performed to solve the problem
	// represented by this reason. This action will always be available. Should be
	// rendered as a link or button next to the summarizing message. For example,
	// the review may be available only once the business configure all required
	// attributes. In such a situation this action can be a link to the form, where
	// they can fill the missing attribute to unblock the main action.
	Action *Action `json:"action,omitempty"`
	// Detail: Detailed explanation of the reason. Should be displayed as a hint if
	// present.
	Detail string `json:"detail,omitempty"`
	// Message: Messages summarizing the reason, why the action is not available.
	// For example: "Review requested on Jan 03. Review requests can take a few
	// days to complete."
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Reason) MarshalJSON() ([]byte, error) {
	type NoMethod Reason
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Region: Region with code and localized name.
type Region struct {
	// Code: The [CLDR territory code]
	// (http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml)
	Code string `json:"code,omitempty"`
	// Name: The localized name of the region. For region with code='001' the value
	// is 'All countries' or the equivalent in other languages.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Region) MarshalJSON() ([]byte, error) {
	type NoMethod Region
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RenderAccountIssuesResponse: Response containing an issue resolution content
// and actions for listed account issues.
type RenderAccountIssuesResponse struct {
	// RenderedIssues: List of account issues for a given account. This list can be
	// shown with compressed, expandable items. In the compressed form, the title
	// and impact should be shown for each issue. Once the issue is expanded, the
	// detailed content and available actions should be rendered.
	RenderedIssues []*RenderedIssue `json:"renderedIssues,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "RenderedIssues") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RenderedIssues") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RenderAccountIssuesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod RenderAccountIssuesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RenderIssuesRequestPayload: The payload for configuring how the content
// should be rendered.
type RenderIssuesRequestPayload struct {
	// ContentOption: Optional. How the detailed content should be returned.
	// Default option is to return the content as a pre-rendered HTML text.
	//
	// Possible values:
	//   "CONTENT_OPTION_UNSPECIFIED" - Default value. Will never be provided by
	// the API.
	//   "PRE_RENDERED_HTML" - Returns the detail of the issue as a pre-rendered
	// HTML text.
	ContentOption string `json:"contentOption,omitempty"`
	// UserInputActionOption: Optional. How actions with user input form should be
	// handled. If not provided, actions will be returned as links that points the
	// business to Merchant Center where they can request the action.
	//
	// Possible values:
	//   "USER_INPUT_ACTION_RENDERING_OPTION_UNSPECIFIED" - Default value. Will
	// never be provided by the API.
	//   "REDIRECT_TO_MERCHANT_CENTER" - Actions that require user input are
	// represented only as links that points the business to Merchant Center where
	// they can request the action. Provides easier to implement alternative to
	// `BUILT_IN_USER_INPUT_ACTIONS`.
	//   "BUILT_IN_USER_INPUT_ACTIONS" - Returns content and input form definition
	// for each complex action. Your application needs to display this content and
	// input form to the business before they can request processing of the action.
	// To start the action, your application needs to call the `triggeraction`
	// method.
	UserInputActionOption string `json:"userInputActionOption,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContentOption") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentOption") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RenderIssuesRequestPayload) MarshalJSON() ([]byte, error) {
	type NoMethod RenderIssuesRequestPayload
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RenderProductIssuesResponse: Response containing an issue resolution content
// and actions for listed product issues.
type RenderProductIssuesResponse struct {
	// RenderedIssues: List of issues for a given product. This list can be shown
	// with compressed, expandable items. In the compressed form, the title and
	// impact should be shown for each issue. Once the issue is expanded, the
	// detailed content and available actions should be rendered.
	RenderedIssues []*RenderedIssue `json:"renderedIssues,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "RenderedIssues") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RenderedIssues") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RenderProductIssuesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod RenderProductIssuesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RenderedIssue: An issue affecting specific business or their product.
type RenderedIssue struct {
	// Actions: A list of actionable steps that can be executed to solve the issue.
	// An example is requesting a re-review or providing arguments when business
	// disagrees with the issue. Actions that are supported in (your) third-party
	// application can be rendered as buttons and should be available to the
	// business when they expand the issue.
	Actions []*Action `json:"actions,omitempty"`
	// Impact: Clarifies the severity of the issue. The summarizing message, if
	// present, should be shown right under the title for each issue. It helps
	// business to quickly understand the impact of the issue. The detailed
	// breakdown helps the business to fully understand the impact of the issue. It
	// can be rendered as dialog that opens when the business mouse over the
	// summarized impact statement. Issues with different severity can be styled
	// differently. They may use a different color or icon to signal the difference
	// between `ERROR`, `WARNING` and `INFO`.
	Impact *Impact `json:"impact,omitempty"`
	// PrerenderedContent: Details of the issue as a pre-rendered HTML. HTML
	// elements contain CSS classes that can be used to customize the style of the
	// content. Always sanitize the HTML before embedding it directly to your
	// application. The sanitizer needs to allow basic HTML tags, such as: `div`,
	// `span`, `p`, `a`, `ul`, `li`, `table`, `tr`, `td`. For example, you can use
	// DOMPurify (https://www.npmjs.com/package/dompurify). CSS classes: *
	// `issue-detail` - top level container for the detail of the issue *
	// `callout-banners` - section of the `issue-detail` with callout banners *
	// `callout-banner` - single callout banner, inside `callout-banners` *
	// `callout-banner-info` - callout with important information (default) *
	// `callout-banner-warning` - callout with a warning * `callout-banner-error` -
	// callout informing about an error (most severe) * `issue-content` - section
	// of the `issue-detail`, contains multiple `content-element` *
	// `content-element` - content element such as a list, link or paragraph,
	// inside `issue-content` * `root-causes` - unordered list with items
	// describing root causes of the issue, inside `issue-content` *
	// `root-causes-intro` - intro text before the `root-causes` list, inside
	// `issue-content` * `segment` - section of the text, `span` inside paragraph *
	// `segment-attribute` - section of the text that represents a product
	// attribute, for example 'image\_link' * `segment-literal` - section of the
	// text that contains a special value, for example '0-1000 kg' * `segment-bold`
	// - section of the text that should be rendered as bold * `segment-italic` -
	// section of the text that should be rendered as italic * `tooltip` - used on
	// paragraphs that should be rendered with a tooltip. A section of the text in
	// such a paragraph will have a class `tooltip-text` and is intended to be
	// shown in a mouse over dialog. If the style is not used, the `tooltip-text`
	// section would be shown on a new line, after the main part of the text. *
	// `tooltip-text` - marks a section of the text within a `tooltip`, that is
	// intended to be shown in a mouse over dialog. * `tooltip-icon` - marks a
	// section of the text within a `tooltip`, that can be replaced with a tooltip
	// icon, for example '?' or 'i'. By default, this section contains a `br` tag,
	// that is separating the main text and the tooltip text when the style is not
	// used. * `tooltip-style-question` - the tooltip shows helpful information,
	// can use the '?' as an icon. * `tooltip-style-info` - the tooltip adds
	// additional information fitting to the context, can use the 'i' as an icon. *
	// `content-moderation` - marks the paragraph that explains how the issue was
	// identified. * `new-element` - Present for new elements added to the
	// pre-rendered content in the future. To make sure that a new content element
	// does not break your style, you can hide everything with this class.
	PrerenderedContent string `json:"prerenderedContent,omitempty"`
	// PrerenderedOutOfCourtDisputeSettlement: Pre-rendered HTML that contains a
	// link to the external location where the ODS can be requested and
	// instructions for how to request it. HTML elements contain CSS classes that
	// can be used to customize the style of this snippet. Always sanitize the HTML
	// before embedding it directly to your application. The sanitizer needs to
	// allow basic HTML tags, such as: `div`, `span`, `p`, `a`, `ul`, `li`,
	// `table`, `tr`, `td`. For example, you can use DOMPurify
	// (https://www.npmjs.com/package/dompurify). CSS classes: * `ods-section`* -
	// wrapper around the out-of-court dispute resolution section *
	// `ods-description`* - intro text for the out-of-court dispute resolution. It
	// may contain multiple segments and a link. * `ods-param`* - wrapper around
	// the header-value pair for parameters that the business may need to provide
	// during the ODS process. * `ods-routing-id`* - ods param for the Routing ID.
	// * `ods-reference-id`* - ods param for the Routing ID. * `ods-param-header`*
	// - header for the ODS parameter * `ods-param-value`* - value of the ODS
	// parameter. This value should be rendered in a way that it is easy for the
	// user to identify and copy. * `segment` - section of the text, `span` inside
	// paragraph * `segment-attribute` - section of the text that represents a
	// product attribute, for example 'image\_link' * `segment-literal` - section
	// of the text that contains a special value, for example '0-1000 kg' *
	// `segment-bold` - section of the text that should be rendered as bold *
	// `segment-italic` - section of the text that should be rendered as italic *
	// `tooltip` - used on paragraphs that should be rendered with a tooltip. A
	// section of the text in such a paragraph will have a class `tooltip-text` and
	// is intended to be shown in a mouse over dialog. If the style is not used,
	// the `tooltip-text` section would be shown on a new line, after the main part
	// of the text. * `tooltip-text` - marks a section of the text within a
	// `tooltip`, that is intended to be shown in a mouse over dialog. *
	// `tooltip-icon` - marks a section of the text within a `tooltip`, that can be
	// replaced with a tooltip icon, for example '?' or 'i'. By default, this
	// section contains a `br` tag, that is separating the main text and the
	// tooltip text when the style is not used. * `tooltip-style-question` - the
	// tooltip shows helpful information, can use the '?' as an icon. *
	// `tooltip-style-info` - the tooltip adds additional information fitting to
	// the context, can use the 'i' as an icon.
	PrerenderedOutOfCourtDisputeSettlement string `json:"prerenderedOutOfCourtDisputeSettlement,omitempty"`
	// Title: Title of the issue.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Actions") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Actions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RenderedIssue) MarshalJSON() ([]byte, error) {
	type NoMethod RenderedIssue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Stats: Products statistics.
type Stats struct {
	// ActiveCount: The number of products that are active.
	ActiveCount int64 `json:"activeCount,omitempty,string"`
	// DisapprovedCount: The number of products that are disapproved.
	DisapprovedCount int64 `json:"disapprovedCount,omitempty,string"`
	// ExpiringCount: The number of products that are expiring.
	ExpiringCount int64 `json:"expiringCount,omitempty,string"`
	// PendingCount: The number of products that are pending.
	PendingCount int64 `json:"pendingCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ActiveCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActiveCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Stats) MarshalJSON() ([]byte, error) {
	type NoMethod Stats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TextInput: Text input allows the business to provide a text value.
type TextInput struct {
	// AdditionalInfo: Additional info regarding the field to be displayed to the
	// business. For example, warning to not include personal identifiable
	// information. There may be more information to be shown in a tooltip.
	AdditionalInfo *TextWithTooltip `json:"additionalInfo,omitempty"`
	// AriaLabel: Text to be used as the aria-label
	// (https://www.w3.org/TR/WCAG20-TECHS/ARIA14.html) for the input.
	AriaLabel string `json:"ariaLabel,omitempty"`
	// FormatInfo: Information about the required format. If present, it should be
	// shown close to the input field to help the business to provide a correct
	// value. For example: "VAT numbers should be in a format similar to
	// SK9999999999"
	FormatInfo string `json:"formatInfo,omitempty"`
	// Type: Type of the text input
	//
	// Possible values:
	//   "TEXT_INPUT_TYPE_UNSPECIFIED" - Default value. Will never be provided by
	// the API.
	//   "GENERIC_SHORT_TEXT" - Used when a short text is expected. The field can
	// be rendered as a [text
	// field](https://www.w3.org/TR/2012/WD-html-markup-20121025/input.text.html#inp
	// ut.text).
	//   "GENERIC_LONG_TEXT" - Used when a longer text is expected. The field
	// should be rendered as a
	// [textarea](https://www.w3.org/TR/2012/WD-html-markup-20121025/textarea.html#t
	// extarea).
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdditionalInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalInfo") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TextInput) MarshalJSON() ([]byte, error) {
	type NoMethod TextInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TextInputValue: Value for text input field.
type TextInputValue struct {
	// Value: Required. Text provided by the business.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Value") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Value") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TextInputValue) MarshalJSON() ([]byte, error) {
	type NoMethod TextInputValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TextWithTooltip: Block of text that may contain a tooltip with more
// information.
type TextWithTooltip struct {
	// SimpleTooltipValue: Value of the tooltip as a simple text.
	SimpleTooltipValue string `json:"simpleTooltipValue,omitempty"`
	// SimpleValue: Value of the message as a simple text.
	SimpleValue string `json:"simpleValue,omitempty"`
	// TooltipIconStyle: The suggested type of an icon for tooltip, if a tooltip is
	// present.
	//
	// Possible values:
	//   "TOOLTIP_ICON_STYLE_UNSPECIFIED" - Default value. Will never be provided
	// by the API.
	//   "INFO" - Used when the tooltip adds additional information to the context,
	// the 'i' can be used as an icon.
	//   "QUESTION" - Used when the tooltip shows helpful information, the '?' can
	// be used as an icon.
	TooltipIconStyle string `json:"tooltipIconStyle,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SimpleTooltipValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SimpleTooltipValue") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TextWithTooltip) MarshalJSON() ([]byte, error) {
	type NoMethod TextWithTooltip
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TriggerActionPayload: The payload for the triggered action.
type TriggerActionPayload struct {
	// ActionContext: Required. The context from the selected action. The value is
	// obtained from rendered issues and needs to be sent back to identify the
	// action that is being triggered.
	ActionContext string `json:"actionContext,omitempty"`
	// ActionInput: Required. Input provided by the business.
	ActionInput *ActionInput `json:"actionInput,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActionContext") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActionContext") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TriggerActionPayload) MarshalJSON() ([]byte, error) {
	type NoMethod TriggerActionPayload
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TriggerActionResponse: Response informing about the started action.
type TriggerActionResponse struct {
	// Message: The message for the business.
	Message string `json:"message,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Message") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Message") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TriggerActionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod TriggerActionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AccountsAggregateProductStatusesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the `AggregateProductStatuses` resources for your merchant
// account. The response might contain fewer items than specified by
// `pageSize`. If `pageToken` was returned in previous request, it can be used
// to obtain additional results.
//
//   - parent: The account to list aggregate product statuses for. Format:
//     `accounts/{account}`.
func (r *AccountsAggregateProductStatusesService) List(parent string) *AccountsAggregateProductStatusesListCall {
	c := &AccountsAggregateProductStatusesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// filters the aggregate product statuses. Filtering is only supported by the
// `reporting_context` and `country` field. For example: `reporting_context =
// "SHOPPING_ADS" AND country = "US".
func (c *AccountsAggregateProductStatusesListCall) Filter(filter string) *AccountsAggregateProductStatusesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// aggregate product statuses to return. The service may return fewer than this
// value. If unspecified, at most 25 aggregate product statuses are returned.
// The maximum value is 250; values above 250 are coerced to 250.
func (c *AccountsAggregateProductStatusesListCall) PageSize(pageSize int64) *AccountsAggregateProductStatusesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListAggregateProductStatuses` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters provided
// to `ListAggregateProductStatuses` must match the call that provided the page
// token.
func (c *AccountsAggregateProductStatusesListCall) PageToken(pageToken string) *AccountsAggregateProductStatusesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsAggregateProductStatusesListCall) Fields(s ...googleapi.Field) *AccountsAggregateProductStatusesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *AccountsAggregateProductStatusesListCall) IfNoneMatch(entityTag string) *AccountsAggregateProductStatusesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsAggregateProductStatusesListCall) Context(ctx context.Context) *AccountsAggregateProductStatusesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsAggregateProductStatusesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsAggregateProductStatusesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "issueresolution/v1/{+parent}/aggregateProductStatuses")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "merchantapi.accounts.aggregateProductStatuses.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "merchantapi.accounts.aggregateProductStatuses.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAggregateProductStatusesResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AccountsAggregateProductStatusesListCall) Do(opts ...googleapi.CallOption) (*ListAggregateProductStatusesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAggregateProductStatusesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "merchantapi.accounts.aggregateProductStatuses.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AccountsAggregateProductStatusesListCall) Pages(ctx context.Context, f func(*ListAggregateProductStatusesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type IssueresolutionRenderaccountissuesCall struct {
	s                          *Service
	name                       string
	renderissuesrequestpayload *RenderIssuesRequestPayload
	urlParams_                 gensupport.URLParams
	ctx_                       context.Context
	header_                    http.Header
}

// Renderaccountissues: Provide a list of business's account issues with an
// issue resolution content and available actions. This content and actions are
// meant to be rendered and shown in third-party applications.
//
// - name: The account to fetch issues for. Format: `accounts/{account}`.
func (r *IssueresolutionService) Renderaccountissues(name string, renderissuesrequestpayload *RenderIssuesRequestPayload) *IssueresolutionRenderaccountissuesCall {
	c := &IssueresolutionRenderaccountissuesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.renderissuesrequestpayload = renderissuesrequestpayload
	return c
}

// LanguageCode sets the optional parameter "languageCode": The IETF BCP-47
// (https://tools.ietf.org/html/bcp47) language code used to localize issue
// resolution content. If not set, the result will be in default language
// `en-US`.
func (c *IssueresolutionRenderaccountissuesCall) LanguageCode(languageCode string) *IssueresolutionRenderaccountissuesCall {
	c.urlParams_.Set("languageCode", languageCode)
	return c
}

// TimeZone sets the optional parameter "timeZone": The IANA
// (https://www.iana.org/time-zones) timezone used to localize times in an
// issue resolution content. For example 'America/Los_Angeles'. If not set,
// results will use as a default UTC.
func (c *IssueresolutionRenderaccountissuesCall) TimeZone(timeZone string) *IssueresolutionRenderaccountissuesCall {
	c.urlParams_.Set("timeZone", timeZone)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *IssueresolutionRenderaccountissuesCall) Fields(s ...googleapi.Field) *IssueresolutionRenderaccountissuesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *IssueresolutionRenderaccountissuesCall) Context(ctx context.Context) *IssueresolutionRenderaccountissuesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *IssueresolutionRenderaccountissuesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *IssueresolutionRenderaccountissuesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.renderissuesrequestpayload)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "issueresolution/v1/{+name}:renderaccountissues")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "merchantapi.issueresolution.renderaccountissues", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "merchantapi.issueresolution.renderaccountissues" call.
// Any non-2xx status code is an error. Response headers are in either
// *RenderAccountIssuesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *IssueresolutionRenderaccountissuesCall) Do(opts ...googleapi.CallOption) (*RenderAccountIssuesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RenderAccountIssuesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "merchantapi.issueresolution.renderaccountissues", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type IssueresolutionRenderproductissuesCall struct {
	s                          *Service
	nameid                     string
	renderissuesrequestpayload *RenderIssuesRequestPayload
	urlParams_                 gensupport.URLParams
	ctx_                       context.Context
	header_                    http.Header
}

// Renderproductissues: Provide a list of issues for business's product with an
// issue resolution content and available actions. This content and actions are
// meant to be rendered and shown in third-party applications.
//
//   - name: The name of the product. Format:
//     `accounts/{account}/products/{product}` The `{product}` segment is a
//     unique identifier for the product. This identifier must be unique within a
//     merchant account and generally follows the structure:
//     `content_language~feed_label~offer_id`. Example: `en~US~sku123` For legacy
//     local products, the structure is:
//     `local~content_language~feed_label~offer_id`. Example:
//     `local~en~US~sku123` The format of the `{product}` segment in the URL is
//     automatically detected by the server, supporting two options: 1. **Encoded
//     Format**: The `{product}` segment is an unpadded base64url encoded string
//     (RFC 4648 Section 5). The decoded string must result in the
//     `content_language~feed_label~offer_id` structure. This encoding MUST be
//     used if any part of the product identifier (like `offer_id`) contains
//     characters such as `/`, `%`, or `~`. * Example: To represent the product
//     ID `en~US~sku/123`, the `{product}` segment must be the base64url encoding
//     of this string, which is `ZW5-VVMtc2t1LzEyMw`. The full resource name for
//     the product would be `accounts/123/products/ZW5-VVMtc2t1LzEyMw`. 2.
//     **Plain Format**: The `{product}` segment is the tilde-separated string
//     `content_language~feed_label~offer_id`. This format is suitable only when
//     `content_language`, `feed_label`, and `offer_id` do not contain
//     URL-problematic characters like `/`, `%`, or `~`. We recommend using the
//     **Encoded Format** for all product IDs to ensure correct parsing,
//     especially those containing special characters. The presence of tilde
//     (`~`) characters in the `{product}` segment is used to differentiate
//     between the two formats. Note: For calls to the v1beta version, the plain
//     format is `channel~content_language~feed_label~offer_id`, for example:
//     `accounts/123/products/online~en~US~sku123`.
func (r *IssueresolutionService) Renderproductissues(nameid string, renderissuesrequestpayload *RenderIssuesRequestPayload) *IssueresolutionRenderproductissuesCall {
	c := &IssueresolutionRenderproductissuesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	c.renderissuesrequestpayload = renderissuesrequestpayload
	return c
}

// LanguageCode sets the optional parameter "languageCode": The IETF BCP-47
// (https://tools.ietf.org/html/bcp47) language code used to localize an issue
// resolution content. If not set, the result will be in default language
// `en-US`.
func (c *IssueresolutionRenderproductissuesCall) LanguageCode(languageCode string) *IssueresolutionRenderproductissuesCall {
	c.urlParams_.Set("languageCode", languageCode)
	return c
}

// TimeZone sets the optional parameter "timeZone": The IANA
// (https://www.iana.org/time-zones) timezone used to localize times in an
// issue resolution content. For example 'America/Los_Angeles'. If not set,
// results will use as a default UTC.
func (c *IssueresolutionRenderproductissuesCall) TimeZone(timeZone string) *IssueresolutionRenderproductissuesCall {
	c.urlParams_.Set("timeZone", timeZone)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *IssueresolutionRenderproductissuesCall) Fields(s ...googleapi.Field) *IssueresolutionRenderproductissuesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *IssueresolutionRenderproductissuesCall) Context(ctx context.Context) *IssueresolutionRenderproductissuesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *IssueresolutionRenderproductissuesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *IssueresolutionRenderproductissuesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.renderissuesrequestpayload)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "issueresolution/v1/{+name}:renderproductissues")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "merchantapi.issueresolution.renderproductissues", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "merchantapi.issueresolution.renderproductissues" call.
// Any non-2xx status code is an error. Response headers are in either
// *RenderProductIssuesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *IssueresolutionRenderproductissuesCall) Do(opts ...googleapi.CallOption) (*RenderProductIssuesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RenderProductIssuesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "merchantapi.issueresolution.renderproductissues", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type IssueresolutionTriggeractionCall struct {
	s                    *Service
	name                 string
	triggeractionpayload *TriggerActionPayload
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Triggeraction: Start an action. The action can be requested by a business in
// third-party application. Before the business can request the action, the
// third-party application needs to show them action specific content and
// display a user input form. Access to the `triggeraction` method is
// restricted to an allowlist. You can request access using Trigger action
// allowlist form
// (https://docs.google.com/forms/d/e/1FAIpQLSfeV_sBW9MBQv9BMTV6JZ1g11PGHLdHsrefca-9h0LmpU7CUg/viewform?usp=sharing).
// The action can be successfully started only once all `required` inputs are
// provided. If any `required` input is missing, or invalid value was provided,
// the service will return 400 error. Validation errors will contain Ids for
// all problematic field together with translated, human readable error
// messages that can be shown to the user.
//
//   - name: The business's account that is triggering the action. Format:
//     `accounts/{account}`.
func (r *IssueresolutionService) Triggeraction(name string, triggeractionpayload *TriggerActionPayload) *IssueresolutionTriggeractionCall {
	c := &IssueresolutionTriggeractionCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.triggeractionpayload = triggeractionpayload
	return c
}

// LanguageCode sets the optional parameter "languageCode": Language code IETF
// BCP 47 syntax (https://tools.ietf.org/html/bcp47) used to localize the
// response. If not set, the result will be in default language `en-US`.
func (c *IssueresolutionTriggeractionCall) LanguageCode(languageCode string) *IssueresolutionTriggeractionCall {
	c.urlParams_.Set("languageCode", languageCode)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *IssueresolutionTriggeractionCall) Fields(s ...googleapi.Field) *IssueresolutionTriggeractionCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *IssueresolutionTriggeractionCall) Context(ctx context.Context) *IssueresolutionTriggeractionCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *IssueresolutionTriggeractionCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *IssueresolutionTriggeractionCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.triggeractionpayload)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "issueresolution/v1/{+name}:triggeraction")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "merchantapi.issueresolution.triggeraction", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "merchantapi.issueresolution.triggeraction" call.
// Any non-2xx status code is an error. Response headers are in either
// *TriggerActionResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *IssueresolutionTriggeractionCall) Do(opts ...googleapi.CallOption) (*TriggerActionResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TriggerActionResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "merchantapi.issueresolution.triggeraction", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}
