// Copyright 2026 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package merchantapi provides access to the Merchant API.
//
// For product documentation, see: https://developers.google.com/merchant/api
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/merchantapi/inventories/v1"
//	...
//	ctx := context.Background()
//	merchantapiService, err := merchantapi.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	merchantapiService, err := merchantapi.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	merchantapiService, err := merchantapi.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package merchantapi // import "google.golang.org/api/merchantapi/inventories/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "merchantapi:inventories_v1"
const apiName = "merchantapi"
const apiVersion = "inventories_v1"
const basePath = "https://merchantapi.googleapis.com/"
const basePathTemplate = "https://merchantapi.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://merchantapi.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// Manage your product listings and accounts for Google Shopping
	ContentScope = "https://www.googleapis.com/auth/content"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/content",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Accounts = NewAccountsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Accounts *AccountsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewAccountsService(s *Service) *AccountsService {
	rs := &AccountsService{s: s}
	rs.Products = NewAccountsProductsService(s)
	return rs
}

type AccountsService struct {
	s *Service

	Products *AccountsProductsService
}

func NewAccountsProductsService(s *Service) *AccountsProductsService {
	rs := &AccountsProductsService{s: s}
	rs.LocalInventories = NewAccountsProductsLocalInventoriesService(s)
	rs.RegionalInventories = NewAccountsProductsRegionalInventoriesService(s)
	return rs
}

type AccountsProductsService struct {
	s *Service

	LocalInventories *AccountsProductsLocalInventoriesService

	RegionalInventories *AccountsProductsRegionalInventoriesService
}

func NewAccountsProductsLocalInventoriesService(s *Service) *AccountsProductsLocalInventoriesService {
	rs := &AccountsProductsLocalInventoriesService{s: s}
	return rs
}

type AccountsProductsLocalInventoriesService struct {
	s *Service
}

func NewAccountsProductsRegionalInventoriesService(s *Service) *AccountsProductsRegionalInventoriesService {
	rs := &AccountsProductsRegionalInventoriesService{s: s}
	return rs
}

type AccountsProductsRegionalInventoriesService struct {
	s *Service
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use it as
// the request or the response type of an API method. For instance: service Foo
// { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// Interval: Represents a time interval, encoded as a Timestamp start
// (inclusive) and a Timestamp end (exclusive). The start must be less than or
// equal to the end. When the start equals the end, the interval is empty
// (matches no time). When both start and end are unspecified, the interval
// matches any time.
type Interval struct {
	// EndTime: Optional. Exclusive end of the interval. If specified, a Timestamp
	// matching this interval will have to be before the end.
	EndTime string `json:"endTime,omitempty"`
	// StartTime: Optional. Inclusive start of the interval. If specified, a
	// Timestamp matching this interval will have to be the same or after the
	// start.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Interval) MarshalJSON() ([]byte, error) {
	type NoMethod Interval
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InventoryLoyaltyProgram: A message that represents loyalty program.
type InventoryLoyaltyProgram struct {
	// CashbackForFutureUse: The cashback that can be used for future purchases.
	CashbackForFutureUse *Price `json:"cashbackForFutureUse,omitempty"`
	// LoyaltyPoints: The amount of loyalty points earned on a purchase.
	LoyaltyPoints int64 `json:"loyaltyPoints,omitempty,string"`
	// MemberPriceEffectiveInterval: A date range during which the item is eligible
	// for member price. If not specified, the member price is always applicable.
	// The date range is represented by a pair of ISO 8601 dates separated by a
	// space, comma, or slash.
	MemberPriceEffectiveInterval *Interval `json:"memberPriceEffectiveInterval,omitempty"`
	// Price: The price for members of the given tier, that is, the instant
	// discount price. Must be smaller or equal to the regular price.
	Price *Price `json:"price,omitempty"`
	// ProgramLabel: The label of the loyalty program. This is an internal label
	// that uniquely identifies the relationship between a business entity and a
	// loyalty program entity. The label must be provided if there are multiple
	// loyalty programs available for the merchant, so that the system can
	// associate the assets below (for example, price and points) with the correct
	// business. The corresponding program must be linked to the Merchant Center
	// account.
	ProgramLabel string `json:"programLabel,omitempty"`
	// ShippingLabel: The label of the shipping benefit. If the field has value,
	// this offer has loyalty shipping benefit. If the field value isn't provided,
	// the item is not eligible for loyalty shipping for the given loyalty tier.
	ShippingLabel string `json:"shippingLabel,omitempty"`
	// TierLabel: The label of the tier within the loyalty program. Must match one
	// of the labels within the program.
	TierLabel string `json:"tierLabel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CashbackForFutureUse") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CashbackForFutureUse") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InventoryLoyaltyProgram) MarshalJSON() ([]byte, error) {
	type NoMethod InventoryLoyaltyProgram
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListLocalInventoriesResponse: Response message for the
// `ListLocalInventories` method.
type ListLocalInventoriesResponse struct {
	// LocalInventories: The `LocalInventory` resources for the given product from
	// the specified account.
	LocalInventories []*LocalInventory `json:"localInventories,omitempty"`
	// NextPageToken: A token, which can be sent as `pageToken` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "LocalInventories") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LocalInventories") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListLocalInventoriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListLocalInventoriesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListRegionalInventoriesResponse: Response message for the
// `ListRegionalInventories` method.
type ListRegionalInventoriesResponse struct {
	// NextPageToken: A token, which can be sent as `pageToken` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// RegionalInventories: The `RegionalInventory` resources for the given product
	// from the specified account.
	RegionalInventories []*RegionalInventory `json:"regionalInventories,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListRegionalInventoriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListRegionalInventoriesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LocalInventory: Local inventory information for the product. Represents
// in-store information for a specific product at the store specified by
// `storeCode`. For a list of all accepted attribute values, see the local
// product inventory data specification
// (https://support.google.com/merchants/answer/3061342).
type LocalInventory struct {
	// Account: Output only. The account that owns the product. This field will be
	// ignored if set by the client.
	Account int64 `json:"account,omitempty,string"`
	// LocalInventoryAttributes: Optional. A list of local inventory attributes.
	LocalInventoryAttributes *LocalInventoryAttributes `json:"localInventoryAttributes,omitempty"`
	// Name: Output only. The name of the `LocalInventory` resource. Format:
	// `accounts/{account}/products/{product}/localInventories/{store_code}` The
	// `{product}` segment is a unique identifier for the product. This identifier
	// must be unique within a merchant account and generally follows the
	// structure: `content_language~feed_label~offer_id`. Example: `en~US~sku123`
	// For legacy local products, the structure is:
	// `local~content_language~feed_label~offer_id`. Example: `local~en~US~sku123`
	// The format of the `{product}` segment in the URL is automatically detected
	// by the server, supporting two options: 1. **Encoded Format**: The
	// `{product}` segment is an unpadded base64url encoded string (RFC 4648
	// Section 5). The decoded string must result in the
	// `content_language~feed_label~offer_id` structure. This encoding MUST be used
	// if any part of the product identifier (like `offer_id`) contains characters
	// such as `/`, `%`, or `~`. * Example: To represent the product ID
	// `en~US~sku/123` for `store_code` "store123", the `{product}` segment must be
	// the base64url encoding of this string, which is `ZW5-VVMtc2t1LzEyMw`. The
	// full resource name for the local inventory would be
	// `accounts/123/products/ZW5-VVMtc2t1LzEyMw/localInventories/store123`. 2.
	// **Plain Format**: The `{product}` segment is the tilde-separated string
	// `content_language~feed_label~offer_id`. This format is suitable only when
	// `content_language`, `feed_label`, and `offer_id` do not contain
	// URL-problematic characters like `/`, `%`, or `~`. We recommend using the
	// **Encoded Format** for all product IDs to ensure correct parsing, especially
	// those containing special characters. The presence of tilde (`~`) characters
	// in the `{product}` segment is used to differentiate between the two formats.
	// Note: For calls to the v1beta version, the plain format for the product
	// segment is `channel~content_language~feed_label~offer_id`. For example, the
	// full resource name for a local inventory at `store_code` "store123" would
	// be: `accounts/123/products/online~en~US~sku123/localInventories/store123`.
	Name string `json:"name,omitempty"`
	// StoreCode: Required. Immutable. Store code (the store ID from your Business
	// Profile) of the physical store the product is sold in. See the Local product
	// inventory data specification
	// (https://support.google.com/merchants/answer/3061342) for more information.
	StoreCode string `json:"storeCode,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Account") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Account") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LocalInventory) MarshalJSON() ([]byte, error) {
	type NoMethod LocalInventory
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LocalInventoryAttributes: Local inventory attributes.
type LocalInventoryAttributes struct {
	// Availability: Availability
	// (https://support.google.com/merchants/answer/3061342) of the product at this
	// store.
	//
	// Possible values:
	//   "LOCAL_INVENTORY_AVAILABILITY_UNSPECIFIED" - Indicates that the
	// availability is unspecified.
	//   "IN_STOCK" - Indicates that the product is in stock.
	//   "LIMITED_AVAILABILITY" - Indicates that the product is out of stock.
	//   "ON_DISPLAY_TO_ORDER" - Indicates that the product is on display to order.
	//   "OUT_OF_STOCK" - Indicates that the product is out of stock.
	Availability string `json:"availability,omitempty"`
	// InstoreProductLocation: Optional. Location of the product inside the store.
	// Maximum length is 20 bytes.
	InstoreProductLocation string `json:"instoreProductLocation,omitempty"`
	// LoyaltyPrograms: Optional. An optional list of loyalty programs containing
	// applicable loyalty member prices for this product at this store. This field
	// is used to show store-specific member prices on Local Inventory Ads (LIA).
	// To use this, the loyalty program must be configured in Google Merchant
	// Center. The benefits provided must match the merchant's website and be clear
	// to members. This is only applicable for merchants in supported countries.
	// See Loyalty program (https://support.google.com/merchants/answer/12922446)
	// for details on supported countries and loyalty program configuration. For
	// local inventory specific details, see the Local inventory data specification
	// (https://support.google.com/merchants/answer/3061342).
	LoyaltyPrograms []*InventoryLoyaltyProgram `json:"loyaltyPrograms,omitempty"`
	// PickupMethod: Optional. Supported pickup method
	// (https://support.google.com/merchants/answer/3061342) for this product.
	// Unless the value is "not supported", this field must be submitted together
	// with `pickupSla`.
	//
	// Possible values:
	//   "PICKUP_METHOD_UNSPECIFIED" - Indicates that the pickup method is
	// unspecified.
	//   "BUY" - Indicates that the pickup method is Buy.
	//   "RESERVE" - Indicates that the pickup method is Reserve.
	//   "SHIP_TO_STORE" - Indicates that the pickup method is Ship to store.
	//   "NOT_SUPPORTED" - Indicates that the pickup method is not supported.
	PickupMethod string `json:"pickupMethod,omitempty"`
	// PickupSla: Optional. Relative time period from the order date for an order
	// for this product, from this store, to be ready for pickup. Must be submitted
	// with `pickupMethod`. See more details here
	// (https://support.google.com/merchants/answer/3061342).
	//
	// Possible values:
	//   "PICKUP_SLA_UNSPECIFIED" - Indicates that the pickup SLA is unspecified.
	//   "SAME_DAY" - Indicates that the pickup SLA is same day.
	//   "NEXT_DAY" - Indicates that the pickup SLA is next day.
	//   "TWO_DAY" - Indicates that the pickup SLA is two days.
	//   "THREE_DAY" - Indicates that the pickup SLA is three days.
	//   "FOUR_DAY" - Indicates that the pickup SLA is four days.
	//   "FIVE_DAY" - Indicates that the pickup SLA is five days.
	//   "SIX_DAY" - Indicates that the pickup SLA is six days.
	//   "SEVEN_DAY" - Indicates that the pickup SLA is seven days.
	//   "MULTI_WEEK" - Indicates that the pickup SLA is multi-week.
	PickupSla string `json:"pickupSla,omitempty"`
	// Price: Optional. Price of the product at this store.
	Price *Price `json:"price,omitempty"`
	// Quantity: Optional. Quantity of the product available at this store. Must be
	// greater than or equal to zero.
	Quantity int64 `json:"quantity,omitempty,string"`
	// SalePrice: Optional. Sale price of the product at this store. Mandatory if
	// `salePriceEffectiveDate` is defined.
	SalePrice *Price `json:"salePrice,omitempty"`
	// SalePriceEffectiveDate: Optional. The `TimePeriod` of the sale at this
	// store.
	SalePriceEffectiveDate *Interval `json:"salePriceEffectiveDate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Availability") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Availability") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LocalInventoryAttributes) MarshalJSON() ([]byte, error) {
	type NoMethod LocalInventoryAttributes
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Price: The price represented as a number and currency.
type Price struct {
	// AmountMicros: The price represented as a number in micros (1 million micros
	// is an equivalent to one's currency standard unit, for example, 1 USD =
	// 1000000 micros).
	AmountMicros int64 `json:"amountMicros,omitempty,string"`
	// CurrencyCode: The currency of the price using three-letter acronyms
	// according to ISO 4217 (http://en.wikipedia.org/wiki/ISO_4217).
	CurrencyCode string `json:"currencyCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AmountMicros") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AmountMicros") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Price) MarshalJSON() ([]byte, error) {
	type NoMethod Price
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ProductChange: The change that happened to the product including old value,
// new value, country code as the region code and reporting context.
type ProductChange struct {
	// NewValue: The new value of the changed resource or attribute. If empty, it
	// means that the product was deleted. Will have one of these values :
	// (`approved`, `pending`, `disapproved`, ``)
	NewValue string `json:"newValue,omitempty"`
	// OldValue: The old value of the changed resource or attribute. If empty, it
	// means that the product was created. Will have one of these values :
	// (`approved`, `pending`, `disapproved`, ``)
	OldValue string `json:"oldValue,omitempty"`
	// RegionCode: Countries that have the change (if applicable). Represented in
	// the ISO 3166 format.
	RegionCode string `json:"regionCode,omitempty"`
	// ReportingContext: Reporting contexts that have the change (if applicable).
	// Currently this field supports only (`SHOPPING_ADS`, `LOCAL_INVENTORY_ADS`,
	// `YOUTUBE_SHOPPING`, `YOUTUBE_CHECKOUT`, `YOUTUBE_AFFILIATE`) from the enum
	// value ReportingContextEnum
	// (/merchant/api/reference/rest/Shared.Types/ReportingContextEnum)
	//
	// Possible values:
	//   "REPORTING_CONTEXT_ENUM_UNSPECIFIED" - Not specified.
	//   "SHOPPING_ADS" - [Shopping
	// ads](https://support.google.com/merchants/answer/6149970).
	//   "DISCOVERY_ADS" - Deprecated: Use `DEMAND_GEN_ADS` instead. [Discovery and
	// Demand Gen ads](https://support.google.com/merchants/answer/13389785).
	//   "DEMAND_GEN_ADS" - [Demand Gen
	// ads](https://support.google.com/merchants/answer/13389785).
	//   "DEMAND_GEN_ADS_DISCOVER_SURFACE" - [Demand Gen ads on Discover
	// surface](https://support.google.com/merchants/answer/13389785).
	//   "VIDEO_ADS" - [Video
	// ads](https://support.google.com/google-ads/answer/6340491).
	//   "DISPLAY_ADS" - [Display
	// ads](https://support.google.com/merchants/answer/6069387).
	//   "LOCAL_INVENTORY_ADS" - [Local inventory
	// ads](https://support.google.com/merchants/answer/3271956).
	//   "VEHICLE_INVENTORY_ADS" - [Vehicle inventory
	// ads](https://support.google.com/merchants/answer/11544533).
	//   "FREE_LISTINGS" - [Free product
	// listings](https://support.google.com/merchants/answer/9199328).
	//   "FREE_LOCAL_LISTINGS" - [Free local product
	// listings](https://support.google.com/merchants/answer/9825611).
	//   "FREE_LOCAL_VEHICLE_LISTINGS" - [Free local vehicle
	// listings](https://support.google.com/merchants/answer/11544533).
	//   "YOUTUBE_AFFILIATE" - [Youtube
	// Affiliate](https://support.google.com/youtube/answer/13376398).
	//   "YOUTUBE_SHOPPING" - [YouTube
	// Shopping](https://support.google.com/merchants/answer/13478370).
	//   "CLOUD_RETAIL" - [Cloud
	// retail](https://cloud.google.com/solutions/retail).
	//   "LOCAL_CLOUD_RETAIL" - [Local cloud
	// retail](https://cloud.google.com/solutions/retail).
	//   "PRODUCT_REVIEWS" - [Product
	// Reviews](https://support.google.com/merchants/answer/14620732).
	//   "MERCHANT_REVIEWS" - [Merchant
	// Reviews](https://developers.google.com/merchant-review-feeds).
	//   "YOUTUBE_CHECKOUT" - YouTube Checkout .
	ReportingContext string `json:"reportingContext,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NewValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NewValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductChange) MarshalJSON() ([]byte, error) {
	type NoMethod ProductChange
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ProductStatusChangeMessage: The message that the merchant will receive to
// notify about product status change event
type ProductStatusChangeMessage struct {
	// Account: The target account that owns the entity that changed. Format :
	// `accounts/{merchant_id}`
	Account string `json:"account,omitempty"`
	// Attribute: The attribute in the resource that changed, in this case it will
	// be always `Status`.
	//
	// Possible values:
	//   "ATTRIBUTE_UNSPECIFIED" - Unspecified attribute
	//   "STATUS" - Status of the changed entity
	Attribute string `json:"attribute,omitempty"`
	// Changes: A message to describe the change that happened to the product
	Changes []*ProductChange `json:"changes,omitempty"`
	// EventTime: The time at which the event was generated. If you want to order
	// the notification messages you receive you should rely on this field not on
	// the order of receiving the notifications.
	EventTime string `json:"eventTime,omitempty"`
	// ExpirationTime: Optional. The product expiration time. This field will not
	// be set if the notification is sent for a product deletion event.
	ExpirationTime string `json:"expirationTime,omitempty"`
	// ManagingAccount: The account that manages the merchant's account. can be the
	// same as merchant id if it is standalone account. Format :
	// `accounts/{service_provider_id}`
	ManagingAccount string `json:"managingAccount,omitempty"`
	// Resource: The product name. Format: `accounts/{account}/products/{product}`
	Resource string `json:"resource,omitempty"`
	// ResourceId: The product id.
	ResourceId string `json:"resourceId,omitempty"`
	// ResourceType: The resource that changed, in this case it will always be
	// `Product`.
	//
	// Possible values:
	//   "RESOURCE_UNSPECIFIED" - Unspecified resource
	//   "PRODUCT" - Resource type : product
	ResourceType string `json:"resourceType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Account") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Account") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductStatusChangeMessage) MarshalJSON() ([]byte, error) {
	type NoMethod ProductStatusChangeMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RegionalInventory: Regional inventory information for the product.
// Represents specific information like price and availability for a given
// product in a specific `region`. For a list of all accepted attribute values,
// see the regional product inventory data specification
// (https://support.google.com/merchants/answer/9698880).
type RegionalInventory struct {
	// Account: Output only. The account that owns the product. This field will be
	// ignored if set by the client.
	Account int64 `json:"account,omitempty,string"`
	// Name: Output only. The name of the `RegionalInventory` resource. Format:
	// `accounts/{account}/products/{product}/regionalInventories/{region}` The
	// `{product}` segment is a unique identifier for the product. This identifier
	// must be unique within a merchant account and generally follows the
	// structure: `content_language~feed_label~offer_id`. Example: `en~US~sku123`
	// For legacy local products, the structure is:
	// `local~content_language~feed_label~offer_id`. Example: `local~en~US~sku123`
	// The format of the `{product}` segment in the URL is automatically detected
	// by the server, supporting two options: 1. **Encoded Format**: The
	// `{product}` segment is an unpadded base64url encoded string (RFC 4648
	// Section 5). The decoded string must result in the
	// `content_language~feed_label~offer_id` structure. This encoding MUST be used
	// if any part of the product identifier (like `offer_id`) contains characters
	// such as `/`, `%`, or `~`. * Example: To represent the product ID
	// `en~US~sku/123` for `region` "region123", the `{product}` segment must be
	// the base64url encoding of this string, which is `ZW5-VVMtc2t1LzEyMw`. The
	// full resource name for the regional inventory would be
	// `accounts/123/products/ZW5-VVMtc2t1LzEyMw/regionalInventories/region123`. 2.
	// **Plain Format**: The `{product}` segment is the tilde-separated string
	// `content_language~feed_label~offer_id`. This format is suitable only when
	// `content_language`, `feed_label`, and `offer_id` do not contain
	// URL-problematic characters like `/`, `%`, or `~`. We recommend using the
	// **Encoded Format** for all product IDs to ensure correct parsing, especially
	// those containing special characters. The presence of tilde (`~`) characters
	// in the `{product}` segment is used to differentiate between the two formats.
	// Note: For calls to the v1beta version, the plain format for the product
	// segment is `channel~content_language~feed_label~offer_id`. For example, the
	// full resource name for a regional inventory in `region` "region123" would
	// be:
	// `accounts/123/products/online~en~US~sku123/regionalInventories/region123`.
	Name string `json:"name,omitempty"`
	// Region: Required. Immutable. ID of the region for this `RegionalInventory`
	// resource. See the Regional availability and pricing
	// (https://support.google.com/merchants/answer/9698880) for more details.
	Region string `json:"region,omitempty"`
	// RegionalInventoryAttributes: Optional. A list of regional inventory
	// attributes.
	RegionalInventoryAttributes *RegionalInventoryAttributes `json:"regionalInventoryAttributes,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Account") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Account") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RegionalInventory) MarshalJSON() ([]byte, error) {
	type NoMethod RegionalInventory
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RegionalInventoryAttributes: Regional inventory attributes.
type RegionalInventoryAttributes struct {
	// Availability: Optional. Availability
	// (https://support.google.com/merchants/answer/14644124) of the product in
	// this region.
	//
	// Possible values:
	//   "REGIONAL_INVENTORY_AVAILABILITY_UNSPECIFIED" - Indicates that the
	// availability is unspecified.
	//   "IN_STOCK" - Indicates that the product is in stock.
	//   "OUT_OF_STOCK" - Indicates that the product is out of stock.
	Availability string `json:"availability,omitempty"`
	// LoyaltyPrograms: Optional. An optional list of loyalty programs containing
	// applicable loyalty member prices for this product in this region. This field
	// is used to show region-specific member prices on Product Listing Ads (PLA).
	// To use this, the loyalty program must be configured in Google Merchant
	// Center, and the merchant must be using the Regional Availability and Pricing
	// (RAAP) feature. The benefits provided must match the merchant's website and
	// be clear to members. This is only applicable for merchants in supported
	// countries. See Loyalty program
	// (https://support.google.com/merchants/answer/12922446) for details on
	// supported countries and loyalty program configuration. Also see Regional
	// availability and pricing
	// (https://support.google.com/merchants/answer/14644124) and How to set up
	// regional member pricing
	// (https://support.google.com/merchants/answer/16388178) for more information.
	LoyaltyPrograms []*InventoryLoyaltyProgram `json:"loyaltyPrograms,omitempty"`
	// Price: Optional. Price of the product in this region.
	Price *Price `json:"price,omitempty"`
	// SalePrice: Optional. Sale price of the product in this region. Mandatory if
	// `salePriceEffectiveDate` is defined.
	SalePrice *Price `json:"salePrice,omitempty"`
	// SalePriceEffectiveDate: Optional. The `TimePeriod` of the sale price in this
	// region.
	SalePriceEffectiveDate *Interval `json:"salePriceEffectiveDate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Availability") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Availability") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RegionalInventoryAttributes) MarshalJSON() ([]byte, error) {
	type NoMethod RegionalInventoryAttributes
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AccountsProductsLocalInventoriesDeleteCall struct {
	s          *Service
	nameid     string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified `LocalInventory` from the given product in
// your merchant account. It might take a up to an hour for the
// `LocalInventory` to be deleted from the specific product. Once you have
// received a successful delete response, wait for that period before
// attempting a delete again.
//
//   - name: The name of the local inventory for the given product to delete.
//     Format:
//     `accounts/{account}/products/{product}/localInventories/{store_code}` The
//     `{product}` segment is a unique identifier for the product. This
//     identifier must be unique within a merchant account and generally follows
//     the structure: `content_language~feed_label~offer_id`. Example:
//     `en~US~sku123` For legacy local products, the structure is:
//     `local~content_language~feed_label~offer_id`. Example:
//     `local~en~US~sku123` The format of the `{product}` segment in the URL is
//     automatically detected by the server, supporting two options: 1. **Encoded
//     Format**: The `{product}` segment is an unpadded base64url encoded string
//     (RFC 4648 Section 5). The decoded string must result in the
//     `content_language~feed_label~offer_id` structure. This encoding MUST be
//     used if any part of the product identifier (like `offer_id`) contains
//     characters such as `/`, `%`, or `~`. * Example: To represent the product
//     ID `en~US~sku/123` for `store_code` "store123", the `{product}` segment
//     must be the base64url encoding of this string, which is
//     `ZW5-VVMtc2t1LzEyMw`. The full resource name for the local inventory would
//     be `accounts/123/products/ZW5-VVMtc2t1LzEyMw/localInventories/store123`.
//     2. **Plain Format**: The `{product}` segment is the tilde-separated string
//     `content_language~feed_label~offer_id`. This format is suitable only when
//     `content_language`, `feed_label`, and `offer_id` do not contain
//     URL-problematic characters like `/`, `%`, or `~`. We recommend using the
//     **Encoded Format** for all product IDs to ensure correct parsing,
//     especially those containing special characters. The presence of tilde
//     (`~`) characters in the `{product}` segment is used to differentiate
//     between the two formats. Note: For calls to the v1beta version, the plain
//     format for the product segment is
//     `channel~content_language~feed_label~offer_id`. For example, the full
//     resource name for a local inventory at `store_code` "store123" would be:
//     `accounts/123/products/online~en~US~sku123/localInventories/store123`.
func (r *AccountsProductsLocalInventoriesService) Delete(nameid string) *AccountsProductsLocalInventoriesDeleteCall {
	c := &AccountsProductsLocalInventoriesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsProductsLocalInventoriesDeleteCall) Fields(s ...googleapi.Field) *AccountsProductsLocalInventoriesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsProductsLocalInventoriesDeleteCall) Context(ctx context.Context) *AccountsProductsLocalInventoriesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsProductsLocalInventoriesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsProductsLocalInventoriesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "inventories/v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "merchantapi.accounts.products.localInventories.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "merchantapi.accounts.products.localInventories.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *AccountsProductsLocalInventoriesDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "merchantapi.accounts.products.localInventories.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountsProductsLocalInventoriesInsertCall struct {
	s              *Service
	parentid       string
	localinventory *LocalInventory
	urlParams_     gensupport.URLParams
	ctx_           context.Context
	header_        http.Header
}

// Insert: Inserts a `LocalInventory` resource to a product in your merchant
// account. Replaces the full `LocalInventory` resource if an entry with the
// same `storeCode` already exists for the product. It might take up to 30
// minutes for the new or updated `LocalInventory` resource to appear in
// products.
//
//   - parent: The account and product where this inventory will be inserted.
//     Format: `accounts/{account}/products/{product}` The `{product}` segment is
//     a unique identifier for the product. This identifier must be unique within
//     a merchant account and generally follows the structure:
//     `content_language~feed_label~offer_id`. Example: `en~US~sku123` For legacy
//     local products, the structure is:
//     `local~content_language~feed_label~offer_id`. Example:
//     `local~en~US~sku123` The format of the `{product}` segment in the URL is
//     automatically detected by the server, supporting two options: 1. **Encoded
//     Format**: The `{product}` segment is an unpadded base64url encoded string
//     (RFC 4648 Section 5). The decoded string must result in the
//     `content_language~feed_label~offer_id` structure. This encoding MUST be
//     used if any part of the product identifier (like `offer_id`) contains
//     characters such as `/`, `%`, or `~`. * Example: To represent the product
//     ID `en~US~sku/123`, the `{product}` segment must be the base64url encoding
//     of this string, which is `ZW5-VVMtc2t1LzEyMw`. The full resource name for
//     the product would be `accounts/123/products/ZW5-VVMtc2t1LzEyMw`. 2.
//     **Plain Format**: The `{product}` segment is the tilde-separated string
//     `content_language~feed_label~offer_id`. This format is suitable only when
//     `content_language`, `feed_label`, and `offer_id` do not contain
//     URL-problematic characters like `/`, `%`, or `~`. We recommend using the
//     **Encoded Format** for all product IDs to ensure correct parsing,
//     especially those containing special characters. The presence of tilde
//     (`~`) characters in the `{product}` segment is used to differentiate
//     between the two formats. Note: For calls to the v1beta version, the plain
//     format is `channel~content_language~feed_label~offer_id`, for example:
//     `accounts/123/products/online~en~US~sku123`.
func (r *AccountsProductsLocalInventoriesService) Insert(parentid string, localinventory *LocalInventory) *AccountsProductsLocalInventoriesInsertCall {
	c := &AccountsProductsLocalInventoriesInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parentid = parentid
	c.localinventory = localinventory
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsProductsLocalInventoriesInsertCall) Fields(s ...googleapi.Field) *AccountsProductsLocalInventoriesInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsProductsLocalInventoriesInsertCall) Context(ctx context.Context) *AccountsProductsLocalInventoriesInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsProductsLocalInventoriesInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsProductsLocalInventoriesInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.localinventory)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "inventories/v1/{+parent}/localInventories:insert")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parentid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "merchantapi.accounts.products.localInventories.insert", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "merchantapi.accounts.products.localInventories.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *LocalInventory.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *AccountsProductsLocalInventoriesInsertCall) Do(opts ...googleapi.CallOption) (*LocalInventory, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LocalInventory{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "merchantapi.accounts.products.localInventories.insert", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountsProductsLocalInventoriesListCall struct {
	s            *Service
	parentid     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the `LocalInventory` resources for the given product in your
// merchant account. The response might contain fewer items than specified by
// `pageSize`. If `pageToken` was returned in previous request, it can be used
// to obtain additional results. `LocalInventory` resources are listed per
// product for a given account.
//
//   - parent: The `name` of the parent product to list local inventories for.
//     Format: `accounts/{account}/products/{product}` The `{product}` segment is
//     a unique identifier for the product. This identifier must be unique within
//     a merchant account and generally follows the structure:
//     `content_language~feed_label~offer_id`. Example: `en~US~sku123` For legacy
//     local products, the structure is:
//     `local~content_language~feed_label~offer_id`. Example:
//     `local~en~US~sku123` The format of the `{product}` segment in the URL is
//     automatically detected by the server, supporting two options: 1. **Encoded
//     Format**: The `{product}` segment is an unpadded base64url encoded string
//     (RFC 4648 Section 5). The decoded string must result in the
//     `content_language~feed_label~offer_id` structure. This encoding MUST be
//     used if any part of the product identifier (like `offer_id`) contains
//     characters such as `/`, `%`, or `~`. * Example: To represent the product
//     ID `en~US~sku/123`, the `{product}` segment must be the base64url encoding
//     of this string, which is `ZW5-VVMtc2t1LzEyMw`. The full resource name for
//     the product would be `accounts/123/products/ZW5-VVMtc2t1LzEyMw`. 2.
//     **Plain Format**: The `{product}` segment is the tilde-separated string
//     `content_language~feed_label~offer_id`. This format is suitable only when
//     `content_language`, `feed_label`, and `offer_id` do not contain
//     URL-problematic characters like `/`, `%`, or `~`. We recommend using the
//     **Encoded Format** for all product IDs to ensure correct parsing,
//     especially those containing special characters. The presence of tilde
//     (`~`) characters in the `{product}` segment is used to differentiate
//     between the two formats. Note: For calls to the v1beta version, the plain
//     format is `channel~content_language~feed_label~offer_id`, for example:
//     `accounts/123/products/online~en~US~sku123`.
func (r *AccountsProductsLocalInventoriesService) List(parentid string) *AccountsProductsLocalInventoriesListCall {
	c := &AccountsProductsLocalInventoriesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parentid = parentid
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// `LocalInventory` resources for the given product to return. The service
// returns fewer than this value if the number of inventories for the given
// product is less that than the `pageSize`. The default value is 25000. The
// maximum value is 25000; If a value higher than the maximum is specified,
// then the `pageSize` will default to the maximum
func (c *AccountsProductsLocalInventoriesListCall) PageSize(pageSize int64) *AccountsProductsLocalInventoriesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListLocalInventories` call. Provide the page token to
// retrieve the subsequent page. When paginating, all other parameters provided
// to `ListLocalInventories` must match the call that provided the page token.
// The token returned as nextPageToken in the response to the previous request.
func (c *AccountsProductsLocalInventoriesListCall) PageToken(pageToken string) *AccountsProductsLocalInventoriesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsProductsLocalInventoriesListCall) Fields(s ...googleapi.Field) *AccountsProductsLocalInventoriesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *AccountsProductsLocalInventoriesListCall) IfNoneMatch(entityTag string) *AccountsProductsLocalInventoriesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsProductsLocalInventoriesListCall) Context(ctx context.Context) *AccountsProductsLocalInventoriesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsProductsLocalInventoriesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsProductsLocalInventoriesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "inventories/v1/{+parent}/localInventories")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parentid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "merchantapi.accounts.products.localInventories.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "merchantapi.accounts.products.localInventories.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListLocalInventoriesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AccountsProductsLocalInventoriesListCall) Do(opts ...googleapi.CallOption) (*ListLocalInventoriesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListLocalInventoriesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "merchantapi.accounts.products.localInventories.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AccountsProductsLocalInventoriesListCall) Pages(ctx context.Context, f func(*ListLocalInventoriesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type AccountsProductsRegionalInventoriesDeleteCall struct {
	s          *Service
	nameid     string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified `RegionalInventory` resource from the given
// product in your merchant account. It might take up to an hour for the
// `RegionalInventory` to be deleted from the specific product. Once you have
// received a successful delete response, wait for that period before
// attempting a delete again.
//
//   - name: The name of the `RegionalInventory` resource to delete. Format:
//     `accounts/{account}/products/{product}/regionalInventories/{region}` The
//     `{product}` segment is a unique identifier for the product. This
//     identifier must be unique within a merchant account and generally follows
//     the structure: `content_language~feed_label~offer_id`. Example:
//     `en~US~sku123` For legacy local products, the structure is:
//     `local~content_language~feed_label~offer_id`. Example:
//     `local~en~US~sku123` The format of the `{product}` segment in the URL is
//     automatically detected by the server, supporting two options: 1. **Encoded
//     Format**: The `{product}` segment is an unpadded base64url encoded string
//     (RFC 4648 Section 5). The decoded string must result in the
//     `content_language~feed_label~offer_id` structure. This encoding MUST be
//     used if any part of the product identifier (like `offer_id`) contains
//     characters such as `/`, `%`, or `~`. * Example: To represent the product
//     ID `en~US~sku/123` for `region` "region123", the `{product}` segment must
//     be the base64url encoding of this string, which is `ZW5-VVMtc2t1LzEyMw`.
//     The full resource name for the regional inventory would be
//     `accounts/123/products/ZW5-VVMtc2t1LzEyMw/regionalInventories/region123`.
//     2. **Plain Format**: The `{product}` segment is the tilde-separated string
//     `content_language~feed_label~offer_id`. This format is suitable only when
//     `content_language`, `feed_label`, and `offer_id` do not contain
//     URL-problematic characters like `/`, `%`, or `~`. We recommend using the
//     **Encoded Format** for all product IDs to ensure correct parsing,
//     especially those containing special characters. The presence of tilde
//     (`~`) characters in the `{product}` segment is used to differentiate
//     between the two formats. Note: For calls to the v1beta version, the plain
//     format for the product segment is
//     `channel~content_language~feed_label~offer_id`. For example, the full
//     resource name for a regional inventory in `region` "region123" would be:
//     `accounts/123/products/online~en~US~sku123/regionalInventories/region123`.
func (r *AccountsProductsRegionalInventoriesService) Delete(nameid string) *AccountsProductsRegionalInventoriesDeleteCall {
	c := &AccountsProductsRegionalInventoriesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsProductsRegionalInventoriesDeleteCall) Fields(s ...googleapi.Field) *AccountsProductsRegionalInventoriesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsProductsRegionalInventoriesDeleteCall) Context(ctx context.Context) *AccountsProductsRegionalInventoriesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsProductsRegionalInventoriesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsProductsRegionalInventoriesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "inventories/v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "merchantapi.accounts.products.regionalInventories.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "merchantapi.accounts.products.regionalInventories.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *AccountsProductsRegionalInventoriesDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "merchantapi.accounts.products.regionalInventories.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountsProductsRegionalInventoriesInsertCall struct {
	s                 *Service
	parentid          string
	regionalinventory *RegionalInventory
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Insert: Inserts a `RegionalInventory` to a given product in your merchant
// account. Replaces the full `RegionalInventory` resource if an entry with the
// same `region` already exists for the product. It might take up to 30 minutes
// for the new or updated `RegionalInventory` resource to appear in products.
//
//   - parent: The account and product where this inventory will be inserted.
//     Format: `accounts/{account}/products/{product}` The `{product}` segment is
//     a unique identifier for the product. This identifier must be unique within
//     a merchant account and generally follows the structure:
//     `content_language~feed_label~offer_id`. Example: `en~US~sku123` For legacy
//     local products, the structure is:
//     `local~content_language~feed_label~offer_id`. Example:
//     `local~en~US~sku123` The format of the `{product}` segment in the URL is
//     automatically detected by the server, supporting two options: 1. **Encoded
//     Format**: The `{product}` segment is an unpadded base64url encoded string
//     (RFC 4648 Section 5). The decoded string must result in the
//     `content_language~feed_label~offer_id` structure. This encoding MUST be
//     used if any part of the product identifier (like `offer_id`) contains
//     characters such as `/`, `%`, or `~`. * Example: To represent the product
//     ID `en~US~sku/123`, the `{product}` segment must be the base64url encoding
//     of this string, which is `ZW5-VVMtc2t1LzEyMw`. The full resource name for
//     the product would be `accounts/123/products/ZW5-VVMtc2t1LzEyMw`. 2.
//     **Plain Format**: The `{product}` segment is the tilde-separated string
//     `content_language~feed_label~offer_id`. This format is suitable only when
//     `content_language`, `feed_label`, and `offer_id` do not contain
//     URL-problematic characters like `/`, `%`, or `~`. We recommend using the
//     **Encoded Format** for all product IDs to ensure correct parsing,
//     especially those containing special characters. The presence of tilde
//     (`~`) characters in the `{product}` segment is used to differentiate
//     between the two formats. Note: For calls to the v1beta version, the plain
//     format is `channel~content_language~feed_label~offer_id`, for example:
//     `accounts/123/products/online~en~US~sku123`.
func (r *AccountsProductsRegionalInventoriesService) Insert(parentid string, regionalinventory *RegionalInventory) *AccountsProductsRegionalInventoriesInsertCall {
	c := &AccountsProductsRegionalInventoriesInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parentid = parentid
	c.regionalinventory = regionalinventory
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsProductsRegionalInventoriesInsertCall) Fields(s ...googleapi.Field) *AccountsProductsRegionalInventoriesInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsProductsRegionalInventoriesInsertCall) Context(ctx context.Context) *AccountsProductsRegionalInventoriesInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsProductsRegionalInventoriesInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsProductsRegionalInventoriesInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.regionalinventory)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "inventories/v1/{+parent}/regionalInventories:insert")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parentid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "merchantapi.accounts.products.regionalInventories.insert", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "merchantapi.accounts.products.regionalInventories.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *RegionalInventory.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsProductsRegionalInventoriesInsertCall) Do(opts ...googleapi.CallOption) (*RegionalInventory, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RegionalInventory{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "merchantapi.accounts.products.regionalInventories.insert", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountsProductsRegionalInventoriesListCall struct {
	s            *Service
	parentid     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the `RegionalInventory` resources for the given product in your
// merchant account. The response might contain fewer items than specified by
// `pageSize`. If `pageToken` was returned in previous request, it can be used
// to obtain additional results. `RegionalInventory` resources are listed per
// product for a given account.
//
//   - parent: The `name` of the parent product to list `RegionalInventory`
//     resources for. Format: `accounts/{account}/products/{product}` The
//     `{product}` segment is a unique identifier for the product. This
//     identifier must be unique within a merchant account and generally follows
//     the structure: `content_language~feed_label~offer_id`. Example:
//     `en~US~sku123` For legacy local products, the structure is:
//     `local~content_language~feed_label~offer_id`. Example:
//     `local~en~US~sku123` The format of the `{product}` segment in the URL is
//     automatically detected by the server, supporting two options: 1. **Encoded
//     Format**: The `{product}` segment is an unpadded base64url encoded string
//     (RFC 4648 Section 5). The decoded string must result in the
//     `content_language~feed_label~offer_id` structure. This encoding MUST be
//     used if any part of the product identifier (like `offer_id`) contains
//     characters such as `/`, `%`, or `~`. * Example: To represent the product
//     ID `en~US~sku/123`, the `{product}` segment must be the base64url encoding
//     of this string, which is `ZW5-VVMtc2t1LzEyMw`. The full resource name for
//     the product would be `accounts/123/products/ZW5-VVMtc2t1LzEyMw`. 2.
//     **Plain Format**: The `{product}` segment is the tilde-separated string
//     `content_language~feed_label~offer_id`. This format is suitable only when
//     `content_language`, `feed_label`, and `offer_id` do not contain
//     URL-problematic characters like `/`, `%`, or `~`. We recommend using the
//     **Encoded Format** for all product IDs to ensure correct parsing,
//     especially those containing special characters. The presence of tilde
//     (`~`) characters in the `{product}` segment is used to differentiate
//     between the two formats. Note: For calls to the v1beta version, the plain
//     format is `channel~content_language~feed_label~offer_id`, for example:
//     `accounts/123/products/online~en~US~sku123`.
func (r *AccountsProductsRegionalInventoriesService) List(parentid string) *AccountsProductsRegionalInventoriesListCall {
	c := &AccountsProductsRegionalInventoriesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parentid = parentid
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// `RegionalInventory` resources for the given product to return. The service
// returns fewer than this value if the number of inventories for the given
// product is less that than the `pageSize`. The default value is 25000. The
// maximum value is 100000; If a value higher than the maximum is specified,
// then the `pageSize` will default to the maximum.
func (c *AccountsProductsRegionalInventoriesListCall) PageSize(pageSize int64) *AccountsProductsRegionalInventoriesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListRegionalInventories` call. Provide the page token to
// retrieve the subsequent page. When paginating, all other parameters provided
// to `ListRegionalInventories` must match the call that provided the page
// token. The token returned as nextPageToken in the response to the previous
// request.
func (c *AccountsProductsRegionalInventoriesListCall) PageToken(pageToken string) *AccountsProductsRegionalInventoriesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsProductsRegionalInventoriesListCall) Fields(s ...googleapi.Field) *AccountsProductsRegionalInventoriesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *AccountsProductsRegionalInventoriesListCall) IfNoneMatch(entityTag string) *AccountsProductsRegionalInventoriesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsProductsRegionalInventoriesListCall) Context(ctx context.Context) *AccountsProductsRegionalInventoriesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsProductsRegionalInventoriesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsProductsRegionalInventoriesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "inventories/v1/{+parent}/regionalInventories")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parentid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "merchantapi.accounts.products.regionalInventories.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "merchantapi.accounts.products.regionalInventories.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListRegionalInventoriesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AccountsProductsRegionalInventoriesListCall) Do(opts ...googleapi.CallOption) (*ListRegionalInventoriesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListRegionalInventoriesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "merchantapi.accounts.products.regionalInventories.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AccountsProductsRegionalInventoriesListCall) Pages(ctx context.Context, f func(*ListRegionalInventoriesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
