// Copyright 2026 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package gkehub provides access to the GKE Hub API.
//
// For product documentation, see: https://cloud.google.com/anthos/multicluster-management/connect/registering-a-cluster
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/gkehub/v1alpha"
//	...
//	ctx := context.Background()
//	gkehubService, err := gkehub.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	gkehubService, err := gkehub.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	gkehubService, err := gkehub.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package gkehub // import "google.golang.org/api/gkehub/v1alpha"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "gkehub:v1alpha"
const apiName = "gkehub"
const apiVersion = "v1alpha"
const basePath = "https://gkehub.googleapis.com/"
const basePathTemplate = "https://gkehub.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://gkehub.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Organizations = NewOrganizationsService(s)
	s.Projects = NewProjectsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Organizations *OrganizationsService

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewOrganizationsService(s *Service) *OrganizationsService {
	rs := &OrganizationsService{s: s}
	rs.Locations = NewOrganizationsLocationsService(s)
	return rs
}

type OrganizationsService struct {
	s *Service

	Locations *OrganizationsLocationsService
}

func NewOrganizationsLocationsService(s *Service) *OrganizationsLocationsService {
	rs := &OrganizationsLocationsService{s: s}
	rs.Fleets = NewOrganizationsLocationsFleetsService(s)
	return rs
}

type OrganizationsLocationsService struct {
	s *Service

	Fleets *OrganizationsLocationsFleetsService
}

func NewOrganizationsLocationsFleetsService(s *Service) *OrganizationsLocationsFleetsService {
	rs := &OrganizationsLocationsFleetsService{s: s}
	return rs
}

type OrganizationsLocationsFleetsService struct {
	s *Service
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.Features = NewProjectsLocationsFeaturesService(s)
	rs.Fleets = NewProjectsLocationsFleetsService(s)
	rs.Memberships = NewProjectsLocationsMembershipsService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	rs.RolloutSequences = NewProjectsLocationsRolloutSequencesService(s)
	rs.Rollouts = NewProjectsLocationsRolloutsService(s)
	rs.Scopes = NewProjectsLocationsScopesService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	Features *ProjectsLocationsFeaturesService

	Fleets *ProjectsLocationsFleetsService

	Memberships *ProjectsLocationsMembershipsService

	Operations *ProjectsLocationsOperationsService

	RolloutSequences *ProjectsLocationsRolloutSequencesService

	Rollouts *ProjectsLocationsRolloutsService

	Scopes *ProjectsLocationsScopesService
}

func NewProjectsLocationsFeaturesService(s *Service) *ProjectsLocationsFeaturesService {
	rs := &ProjectsLocationsFeaturesService{s: s}
	return rs
}

type ProjectsLocationsFeaturesService struct {
	s *Service
}

func NewProjectsLocationsFleetsService(s *Service) *ProjectsLocationsFleetsService {
	rs := &ProjectsLocationsFleetsService{s: s}
	return rs
}

type ProjectsLocationsFleetsService struct {
	s *Service
}

func NewProjectsLocationsMembershipsService(s *Service) *ProjectsLocationsMembershipsService {
	rs := &ProjectsLocationsMembershipsService{s: s}
	rs.Bindings = NewProjectsLocationsMembershipsBindingsService(s)
	rs.Rbacrolebindings = NewProjectsLocationsMembershipsRbacrolebindingsService(s)
	return rs
}

type ProjectsLocationsMembershipsService struct {
	s *Service

	Bindings *ProjectsLocationsMembershipsBindingsService

	Rbacrolebindings *ProjectsLocationsMembershipsRbacrolebindingsService
}

func NewProjectsLocationsMembershipsBindingsService(s *Service) *ProjectsLocationsMembershipsBindingsService {
	rs := &ProjectsLocationsMembershipsBindingsService{s: s}
	return rs
}

type ProjectsLocationsMembershipsBindingsService struct {
	s *Service
}

func NewProjectsLocationsMembershipsRbacrolebindingsService(s *Service) *ProjectsLocationsMembershipsRbacrolebindingsService {
	rs := &ProjectsLocationsMembershipsRbacrolebindingsService{s: s}
	return rs
}

type ProjectsLocationsMembershipsRbacrolebindingsService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

func NewProjectsLocationsRolloutSequencesService(s *Service) *ProjectsLocationsRolloutSequencesService {
	rs := &ProjectsLocationsRolloutSequencesService{s: s}
	return rs
}

type ProjectsLocationsRolloutSequencesService struct {
	s *Service
}

func NewProjectsLocationsRolloutsService(s *Service) *ProjectsLocationsRolloutsService {
	rs := &ProjectsLocationsRolloutsService{s: s}
	return rs
}

type ProjectsLocationsRolloutsService struct {
	s *Service
}

func NewProjectsLocationsScopesService(s *Service) *ProjectsLocationsScopesService {
	rs := &ProjectsLocationsScopesService{s: s}
	rs.Namespaces = NewProjectsLocationsScopesNamespacesService(s)
	rs.Rbacrolebindings = NewProjectsLocationsScopesRbacrolebindingsService(s)
	return rs
}

type ProjectsLocationsScopesService struct {
	s *Service

	Namespaces *ProjectsLocationsScopesNamespacesService

	Rbacrolebindings *ProjectsLocationsScopesRbacrolebindingsService
}

func NewProjectsLocationsScopesNamespacesService(s *Service) *ProjectsLocationsScopesNamespacesService {
	rs := &ProjectsLocationsScopesNamespacesService{s: s}
	return rs
}

type ProjectsLocationsScopesNamespacesService struct {
	s *Service
}

func NewProjectsLocationsScopesRbacrolebindingsService(s *Service) *ProjectsLocationsScopesRbacrolebindingsService {
	rs := &ProjectsLocationsScopesRbacrolebindingsService{s: s}
	return rs
}

type ProjectsLocationsScopesRbacrolebindingsService struct {
	s *Service
}

// AppDevExperienceFeatureSpec: Spec for App Dev Experience Feature.
type AppDevExperienceFeatureSpec struct {
}

// AppDevExperienceFeatureState: State for App Dev Exp Feature.
type AppDevExperienceFeatureState struct {
	// NetworkingInstallSucceeded: Status of subcomponent that detects configured
	// Service Mesh resources.
	NetworkingInstallSucceeded *Status `json:"networkingInstallSucceeded,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NetworkingInstallSucceeded")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NetworkingInstallSucceeded") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AppDevExperienceFeatureState) MarshalJSON() ([]byte, error) {
	type NoMethod AppDevExperienceFeatureState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ApplianceCluster: ApplianceCluster contains information specific to GDC Edge
// Appliance Clusters.
type ApplianceCluster struct {
	// ResourceLink: Immutable. Self-link of the Google Cloud resource for the
	// Appliance Cluster. For example:
	// //transferappliance.googleapis.com/projects/my-project/locations/us-west1-a/a
	// ppliances/my-appliance
	ResourceLink string `json:"resourceLink,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ResourceLink") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ResourceLink") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ApplianceCluster) MarshalJSON() ([]byte, error) {
	type NoMethod ApplianceCluster
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AuditConfig: Specifies the audit configuration for a service. The
// configuration determines which permission types are logged, and what
// identities, if any, are exempted from logging. An AuditConfig must have one
// or more AuditLogConfigs. If there are AuditConfigs for both `allServices`
// and a specific service, the union of the two AuditConfigs is used for that
// service: the log_types specified in each AuditConfig are enabled, and the
// exempted_members in each AuditLogConfig are exempted. Example Policy with
// multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
// "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
// "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
// "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
// "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
// "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
// sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
// logging. It also exempts `jose@example.com` from DATA_READ logging, and
// `aliya@example.com` from DATA_WRITE logging.
type AuditConfig struct {
	// AuditLogConfigs: The configuration for logging of each type of permission.
	AuditLogConfigs []*AuditLogConfig `json:"auditLogConfigs,omitempty"`
	// Service: Specifies a service that will be enabled for audit logging. For
	// example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices`
	// is a special value that covers all services.
	Service string `json:"service,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AuditLogConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuditLogConfigs") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuditConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AuditConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AuditLogConfig: Provides the configuration for logging a type of
// permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ",
// "exempted_members": [ "user:jose@example.com" ] }, { "log_type":
// "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while
// exempting jose@example.com from DATA_READ logging.
type AuditLogConfig struct {
	// ExemptedMembers: Specifies the identities that do not cause logging for this
	// type of permission. Follows the same format of Binding.members.
	ExemptedMembers []string `json:"exemptedMembers,omitempty"`
	// LogType: The log type that this config enables.
	//
	// Possible values:
	//   "LOG_TYPE_UNSPECIFIED" - Default case. Should never be this.
	//   "ADMIN_READ" - Admin reads. Example: CloudIAM getIamPolicy
	//   "DATA_WRITE" - Data writes. Example: CloudSQL Users create
	//   "DATA_READ" - Data reads. Example: CloudSQL Users list
	LogType string `json:"logType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExemptedMembers") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExemptedMembers") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuditLogConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AuditLogConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Authority: Authority encodes how Google will recognize identities from this
// Membership. See the workload identity documentation for more details:
// https://cloud.google.com/kubernetes-engine/docs/how-to/workload-identity
type Authority struct {
	// IdentityProvider: Output only. An identity provider that reflects the
	// `issuer` in the workload identity pool.
	IdentityProvider string `json:"identityProvider,omitempty"`
	// Issuer: Optional. A JSON Web Token (JWT) issuer URI. `issuer` must start
	// with `https://` and be a valid URL with length <2000 characters, it must use
	// `location` rather than `zone` for GKE clusters. If set, then Google will
	// allow valid OIDC tokens from this issuer to authenticate within the
	// workload_identity_pool. OIDC discovery will be performed on this URI to
	// validate tokens from the issuer. Clearing `issuer` disables Workload
	// Identity. `issuer` cannot be directly modified; it must be cleared (and
	// Workload Identity disabled) before using a new issuer (and re-enabling
	// Workload Identity).
	Issuer string `json:"issuer,omitempty"`
	// OidcJwks: Optional. OIDC verification keys for this Membership in JWKS
	// format (RFC 7517). When this field is set, OIDC discovery will NOT be
	// performed on `issuer`, and instead OIDC tokens will be validated using this
	// field.
	OidcJwks string `json:"oidcJwks,omitempty"`
	// ScopeTenancyIdentityProvider: Optional. Output only. The identity provider
	// for the scope-tenancy workload identity pool.
	ScopeTenancyIdentityProvider string `json:"scopeTenancyIdentityProvider,omitempty"`
	// ScopeTenancyWorkloadIdentityPool: Optional. Output only. The name of the
	// scope-tenancy workload identity pool. This pool is set in the fleet-level
	// feature.
	ScopeTenancyWorkloadIdentityPool string `json:"scopeTenancyWorkloadIdentityPool,omitempty"`
	// WorkloadIdentityPool: Output only. The name of the workload identity pool in
	// which `issuer` will be recognized. There is a single Workload Identity Pool
	// per Hub that is shared between all Memberships that belong to that Hub. For
	// a Hub hosted in {PROJECT_ID}, the workload pool format is
	// `{PROJECT_ID}.hub.id.goog`, although this is subject to change in newer
	// versions of this API.
	WorkloadIdentityPool string `json:"workloadIdentityPool,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IdentityProvider") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IdentityProvider") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Authority) MarshalJSON() ([]byte, error) {
	type NoMethod Authority
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BinaryAuthorizationConfig: BinaryAuthorizationConfig defines the fleet level
// configuration of binary authorization feature.
type BinaryAuthorizationConfig struct {
	// EvaluationMode: Optional. Mode of operation for binauthz policy evaluation.
	//
	// Possible values:
	//   "EVALUATION_MODE_UNSPECIFIED" - Default value
	//   "DISABLED" - Disable BinaryAuthorization
	//   "POLICY_BINDINGS" - Use Binary Authorization with the policies specified
	// in policy_bindings.
	EvaluationMode string `json:"evaluationMode,omitempty"`
	// PolicyBindings: Optional. Binauthz policies that apply to this cluster.
	PolicyBindings []*PolicyBinding `json:"policyBindings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EvaluationMode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EvaluationMode") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BinaryAuthorizationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BinaryAuthorizationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Binding: Associates `members`, or principals, with a `role`.
type Binding struct {
	// Condition: The condition that is associated with this binding. If the
	// condition evaluates to `true`, then this binding applies to the current
	// request. If the condition evaluates to `false`, then this binding does not
	// apply to the current request. However, a different role binding might grant
	// the same role to one or more of the principals in this binding. To learn
	// which resources support conditions in their IAM policies, see the IAM
	// documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Condition *Expr `json:"condition,omitempty"`
	// Members: Specifies the principals requesting access for a Google Cloud
	// resource. `members` can have the following values: * `allUsers`: A special
	// identifier that represents anyone who is on the internet; with or without a
	// Google account. * `allAuthenticatedUsers`: A special identifier that
	// represents anyone who is authenticated with a Google account or a service
	// account. Does not include identities that come from external identity
	// providers (IdPs) through identity federation. * `user:{emailid}`: An email
	// address that represents a specific Google account. For example,
	// `alice@example.com` . * `serviceAccount:{emailid}`: An email address that
	// represents a Google service account. For example,
	// `my-other-app@appspot.gserviceaccount.com`. *
	// `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An
	// identifier for a Kubernetes service account
	// (https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts).
	// For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. *
	// `group:{emailid}`: An email address that represents a Google group. For
	// example, `admins@example.com`. * `domain:{domain}`: The G Suite domain
	// (primary) that represents all the users of that domain. For example,
	// `google.com` or `example.com`. *
	// `principal://iam.googleapis.com/locations/global/workforcePools/{pool_id}/sub
	// ject/{subject_attribute_value}`: A single identity in a workforce identity
	// pool. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// group/{group_id}`: All workforce identities in a group. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// attribute.{attribute_name}/{attribute_value}`: All workforce identities with
	// a specific attribute value. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// *`: All identities in a workforce identity pool. *
	// `principal://iam.googleapis.com/projects/{project_number}/locations/global/wo
	// rkloadIdentityPools/{pool_id}/subject/{subject_attribute_value}`: A single
	// identity in a workload identity pool. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/group/{group_id}`: A workload identity pool
	// group. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/attribute.{attribute_name}/{attribute_value}
	// `: All identities in a workload identity pool with a certain attribute. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/*`: All identities in a workload identity
	// pool. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus
	// unique identifier) representing a user that has been recently deleted. For
	// example, `alice@example.com?uid=123456789012345678901`. If the user is
	// recovered, this value reverts to `user:{emailid}` and the recovered user
	// retains the role in the binding. *
	// `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus
	// unique identifier) representing a service account that has been recently
	// deleted. For example,
	// `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
	// service account is undeleted, this value reverts to
	// `serviceAccount:{emailid}` and the undeleted service account retains the
	// role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email
	// address (plus unique identifier) representing a Google group that has been
	// recently deleted. For example,
	// `admins@example.com?uid=123456789012345678901`. If the group is recovered,
	// this value reverts to `group:{emailid}` and the recovered group retains the
	// role in the binding. *
	// `deleted:principal://iam.googleapis.com/locations/global/workforcePools/{pool
	// _id}/subject/{subject_attribute_value}`: Deleted single identity in a
	// workforce identity pool. For example,
	// `deleted:principal://iam.googleapis.com/locations/global/workforcePools/my-po
	// ol-id/subject/my-subject-attribute-value`.
	Members []string `json:"members,omitempty"`
	// Role: Role that is assigned to the list of `members`, or principals. For
	// example, `roles/viewer`, `roles/editor`, or `roles/owner`. For an overview
	// of the IAM roles and permissions, see the IAM documentation
	// (https://cloud.google.com/iam/docs/roles-overview). For a list of the
	// available pre-defined roles, see here
	// (https://cloud.google.com/iam/docs/understanding-roles).
	Role string `json:"role,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Binding) MarshalJSON() ([]byte, error) {
	type NoMethod Binding
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CancelOperationRequest: The request message for Operations.CancelOperation.
type CancelOperationRequest struct {
}

// CloudAuditLoggingFeatureSpec: **Cloud Audit Logging**: Spec for Audit
// Logging Allowlisting.
type CloudAuditLoggingFeatureSpec struct {
	// AllowlistedServiceAccounts: Service account that should be allowlisted to
	// send the audit logs; eg
	// cloudauditlogging@gcp-project.iam.gserviceaccount.com. These accounts must
	// already exist, but do not need to have any permissions granted to them. The
	// customer's entitlements will be checked prior to allowlisting (i.e. the
	// customer must be an Anthos customer.)
	AllowlistedServiceAccounts []string `json:"allowlistedServiceAccounts,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowlistedServiceAccounts")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowlistedServiceAccounts") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAuditLoggingFeatureSpec) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAuditLoggingFeatureSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CloudBuildMembershipSpec: **Cloud Build**: Configurations for each Cloud
// Build enabled cluster.
type CloudBuildMembershipSpec struct {
	// SecurityPolicy: Whether it is allowed to run the privileged builds on the
	// cluster or not.
	//
	// Possible values:
	//   "SECURITY_POLICY_UNSPECIFIED" - Unspecified policy
	//   "NON_PRIVILEGED" - Privileged build pods are disallowed
	//   "PRIVILEGED" - Privileged build pods are allowed
	SecurityPolicy string `json:"securityPolicy,omitempty"`
	// Version: Version of the cloud build software on the cluster.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SecurityPolicy") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SecurityPolicy") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudBuildMembershipSpec) MarshalJSON() ([]byte, error) {
	type NoMethod CloudBuildMembershipSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ClusterSelector: Selector for clusters.
type ClusterSelector struct {
	// LabelSelector: Required. A valid CEL (Common Expression Language) expression
	// which evaluates `resource.labels`.
	LabelSelector string `json:"labelSelector,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LabelSelector") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LabelSelector") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ClusterSelector) MarshalJSON() ([]byte, error) {
	type NoMethod ClusterSelector
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ClusterUpgradeFleetSpec: **ClusterUpgrade**: The configuration for the
// fleet-level ClusterUpgrade feature.
type ClusterUpgradeFleetSpec struct {
	// GkeUpgradeOverrides: Allow users to override some properties of each GKE
	// upgrade.
	GkeUpgradeOverrides []*ClusterUpgradeGKEUpgradeOverride `json:"gkeUpgradeOverrides,omitempty"`
	// PostConditions: Required. Post conditions to evaluate to mark an upgrade
	// COMPLETE. Required.
	PostConditions *ClusterUpgradePostConditions `json:"postConditions,omitempty"`
	// UpstreamFleets: This fleet consumes upgrades that have COMPLETE status code
	// in the upstream fleets. See UpgradeStatus.Code for code definitions. The
	// fleet name should be either fleet project number or id. This is defined as
	// repeated for future proof reasons. Initial implementation will enforce at
	// most one upstream fleet.
	UpstreamFleets []string `json:"upstreamFleets,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GkeUpgradeOverrides") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GkeUpgradeOverrides") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ClusterUpgradeFleetSpec) MarshalJSON() ([]byte, error) {
	type NoMethod ClusterUpgradeFleetSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ClusterUpgradeFleetState: **ClusterUpgrade**: The state for the fleet-level
// ClusterUpgrade feature.
type ClusterUpgradeFleetState struct {
	// DownstreamFleets: This fleets whose upstream_fleets contain the current
	// fleet. The fleet name should be either fleet project number or id.
	DownstreamFleets []string `json:"downstreamFleets,omitempty"`
	// GkeState: Feature state for GKE clusters.
	GkeState *ClusterUpgradeGKEUpgradeFeatureState `json:"gkeState,omitempty"`
	// Ignored: A list of memberships ignored by the feature. For example, manually
	// upgraded clusters can be ignored if they are newer than the default versions
	// of its release channel. The membership resource is in the format:
	// `projects/{p}/locations/{l}/membership/{m}`.
	Ignored map[string]ClusterUpgradeIgnoredMembership `json:"ignored,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DownstreamFleets") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DownstreamFleets") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ClusterUpgradeFleetState) MarshalJSON() ([]byte, error) {
	type NoMethod ClusterUpgradeFleetState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ClusterUpgradeGKEUpgrade: GKEUpgrade represents a GKE provided upgrade,
// e.g., control plane upgrade.
type ClusterUpgradeGKEUpgrade struct {
	// Name: Name of the upgrade, e.g., "k8s_control_plane". It should be a valid
	// upgrade name. It must not exceet 99 characters.
	Name string `json:"name,omitempty"`
	// Version: Version of the upgrade, e.g., "1.22.1-gke.100". It should be a
	// valid version. It must not exceet 99 characters.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ClusterUpgradeGKEUpgrade) MarshalJSON() ([]byte, error) {
	type NoMethod ClusterUpgradeGKEUpgrade
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ClusterUpgradeGKEUpgradeFeatureCondition: GKEUpgradeFeatureCondition
// describes the condition of the feature for GKE clusters at a certain point
// of time.
type ClusterUpgradeGKEUpgradeFeatureCondition struct {
	// Reason: Reason why the feature is in this status.
	Reason string `json:"reason,omitempty"`
	// Status: Status of the condition, one of True, False, Unknown.
	Status string `json:"status,omitempty"`
	// Type: Type of the condition, for example, "ready".
	Type string `json:"type,omitempty"`
	// UpdateTime: Last timestamp the condition was updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Reason") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Reason") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ClusterUpgradeGKEUpgradeFeatureCondition) MarshalJSON() ([]byte, error) {
	type NoMethod ClusterUpgradeGKEUpgradeFeatureCondition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ClusterUpgradeGKEUpgradeFeatureState: GKEUpgradeFeatureState contains
// feature states for GKE clusters in the scope.
type ClusterUpgradeGKEUpgradeFeatureState struct {
	// Conditions: Current conditions of the feature.
	Conditions []*ClusterUpgradeGKEUpgradeFeatureCondition `json:"conditions,omitempty"`
	// UpgradeState: Upgrade state. It will eventually replace `state`.
	UpgradeState []*ClusterUpgradeGKEUpgradeState `json:"upgradeState,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conditions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conditions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ClusterUpgradeGKEUpgradeFeatureState) MarshalJSON() ([]byte, error) {
	type NoMethod ClusterUpgradeGKEUpgradeFeatureState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ClusterUpgradeGKEUpgradeOverride: Properties of a GKE upgrade that can be
// overridden by the user. For example, a user can skip soaking by overriding
// the soaking to 0.
type ClusterUpgradeGKEUpgradeOverride struct {
	// PostConditions: Required. Post conditions to override for the specified
	// upgrade (name + version). Required.
	PostConditions *ClusterUpgradePostConditions `json:"postConditions,omitempty"`
	// Upgrade: Required. Which upgrade to override. Required.
	Upgrade *ClusterUpgradeGKEUpgrade `json:"upgrade,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PostConditions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PostConditions") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ClusterUpgradeGKEUpgradeOverride) MarshalJSON() ([]byte, error) {
	type NoMethod ClusterUpgradeGKEUpgradeOverride
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ClusterUpgradeGKEUpgradeState: GKEUpgradeState is a GKEUpgrade and its state
// at the scope and fleet level.
type ClusterUpgradeGKEUpgradeState struct {
	// Stats: Number of GKE clusters in each status code.
	Stats map[string]string `json:"stats,omitempty"`
	// Status: Status of the upgrade.
	Status *ClusterUpgradeUpgradeStatus `json:"status,omitempty"`
	// Upgrade: Which upgrade to track the state.
	Upgrade *ClusterUpgradeGKEUpgrade `json:"upgrade,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Stats") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Stats") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ClusterUpgradeGKEUpgradeState) MarshalJSON() ([]byte, error) {
	type NoMethod ClusterUpgradeGKEUpgradeState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ClusterUpgradeIgnoredMembership: IgnoredMembership represents a membership
// ignored by the feature. A membership can be ignored because it was manually
// upgraded to a newer version than RC default.
type ClusterUpgradeIgnoredMembership struct {
	// IgnoredTime: Time when the membership was first set to ignored.
	IgnoredTime string `json:"ignoredTime,omitempty"`
	// Reason: Reason why the membership is ignored.
	Reason string `json:"reason,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IgnoredTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IgnoredTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ClusterUpgradeIgnoredMembership) MarshalJSON() ([]byte, error) {
	type NoMethod ClusterUpgradeIgnoredMembership
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ClusterUpgradeMembershipGKEUpgradeState: ScopeGKEUpgradeState is a
// GKEUpgrade and its state per-membership.
type ClusterUpgradeMembershipGKEUpgradeState struct {
	// Status: Status of the upgrade.
	Status *ClusterUpgradeUpgradeStatus `json:"status,omitempty"`
	// Upgrade: Which upgrade to track the state.
	Upgrade *ClusterUpgradeGKEUpgrade `json:"upgrade,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Status") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Status") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ClusterUpgradeMembershipGKEUpgradeState) MarshalJSON() ([]byte, error) {
	type NoMethod ClusterUpgradeMembershipGKEUpgradeState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ClusterUpgradeMembershipState: Per-membership state for this feature.
type ClusterUpgradeMembershipState struct {
	// Ignored: Whether this membership is ignored by the feature. For example,
	// manually upgraded clusters can be ignored if they are newer than the default
	// versions of its release channel.
	Ignored *ClusterUpgradeIgnoredMembership `json:"ignored,omitempty"`
	// Scopes: Fully qualified scope names that this clusters is bound to which
	// also have rollout sequencing enabled.
	Scopes []string `json:"scopes,omitempty"`
	// Upgrades: Actual upgrade state against desired.
	Upgrades []*ClusterUpgradeMembershipGKEUpgradeState `json:"upgrades,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Ignored") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Ignored") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ClusterUpgradeMembershipState) MarshalJSON() ([]byte, error) {
	type NoMethod ClusterUpgradeMembershipState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ClusterUpgradePostConditions: Post conditional checks after an upgrade has
// been applied on all eligible clusters.
type ClusterUpgradePostConditions struct {
	// Soaking: Required. Amount of time to "soak" after a rollout has been
	// finished before marking it COMPLETE. Cannot exceed 30 days. Required.
	Soaking string `json:"soaking,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Soaking") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Soaking") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ClusterUpgradePostConditions) MarshalJSON() ([]byte, error) {
	type NoMethod ClusterUpgradePostConditions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ClusterUpgradeScopeSpec: **ClusterUpgrade**: The configuration for the
// scope-level ClusterUpgrade feature.
type ClusterUpgradeScopeSpec struct {
	// GkeUpgradeOverrides: Allow users to override some properties of each GKE
	// upgrade.
	GkeUpgradeOverrides []*ClusterUpgradeGKEUpgradeOverride `json:"gkeUpgradeOverrides,omitempty"`
	// PostConditions: Required. Post conditions to evaluate to mark an upgrade
	// COMPLETE. Required.
	PostConditions *ClusterUpgradePostConditions `json:"postConditions,omitempty"`
	// UpstreamScopes: This scope consumes upgrades that have COMPLETE status code
	// in the upstream scopes. See UpgradeStatus.Code for code definitions. The
	// scope name should be in the form: `projects/{p}/locations/global/scopes/{s}`
	// Where {p} is the project, {s} is a valid Scope in this project. {p} WILL
	// match the Feature's project. This is defined as repeated for future proof
	// reasons. Initial implementation will enforce at most one upstream scope.
	UpstreamScopes []string `json:"upstreamScopes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GkeUpgradeOverrides") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GkeUpgradeOverrides") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ClusterUpgradeScopeSpec) MarshalJSON() ([]byte, error) {
	type NoMethod ClusterUpgradeScopeSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ClusterUpgradeScopeState: **ClusterUpgrade**: The state for the scope-level
// ClusterUpgrade feature.
type ClusterUpgradeScopeState struct {
	// DownstreamScopes: This scopes whose upstream_scopes contain the current
	// scope. The scope name should be in the form:
	// `projects/{p}/locations/gloobal/scopes/{s}` Where {p} is the project, {s} is
	// a valid Scope in this project. {p} WILL match the Feature's project.
	DownstreamScopes []string `json:"downstreamScopes,omitempty"`
	// GkeState: Feature state for GKE clusters.
	GkeState *ClusterUpgradeGKEUpgradeFeatureState `json:"gkeState,omitempty"`
	// Ignored: A list of memberships ignored by the feature. For example, manually
	// upgraded clusters can be ignored if they are newer than the default versions
	// of its release channel. The membership resource is in the format:
	// `projects/{p}/locations/{l}/membership/{m}`.
	Ignored map[string]ClusterUpgradeIgnoredMembership `json:"ignored,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DownstreamScopes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DownstreamScopes") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ClusterUpgradeScopeState) MarshalJSON() ([]byte, error) {
	type NoMethod ClusterUpgradeScopeState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ClusterUpgradeUpgradeStatus: UpgradeStatus provides status information for
// each upgrade.
type ClusterUpgradeUpgradeStatus struct {
	// Code: Status code of the upgrade.
	//
	// Possible values:
	//   "CODE_UNSPECIFIED" - Required by https://linter.aip.dev/126/unspecified.
	//   "INELIGIBLE" - The upgrade is ineligible. At the scope level, this means
	// the upgrade is ineligible for all the clusters in the scope.
	//   "PENDING" - The upgrade is pending. At the scope level, this means the
	// upgrade is pending for all the clusters in the scope.
	//   "IN_PROGRESS" - The upgrade is in progress. At the scope level, this means
	// the upgrade is in progress for at least one cluster in the scope.
	//   "SOAKING" - The upgrade has finished and is soaking until the soaking time
	// is up. At the scope level, this means at least one cluster is in soaking
	// while the rest are either soaking or complete.
	//   "FORCED_SOAKING" - A cluster will be forced to enter soaking if an upgrade
	// doesn't finish within a certain limit, despite it's actual status.
	//   "COMPLETE" - The upgrade has passed all post conditions (soaking). At the
	// scope level, this means all eligible clusters are in COMPLETE status.
	Code string `json:"code,omitempty"`
	// Reason: Reason for this status.
	Reason string `json:"reason,omitempty"`
	// UpdateTime: Last timestamp the status was updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ClusterUpgradeUpgradeStatus) MarshalJSON() ([]byte, error) {
	type NoMethod ClusterUpgradeUpgradeStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CommonFeatureSpec: CommonFeatureSpec contains Fleet-wide configuration
// information
type CommonFeatureSpec struct {
	// Appdevexperience: Appdevexperience specific spec.
	Appdevexperience *AppDevExperienceFeatureSpec `json:"appdevexperience,omitempty"`
	// Cloudauditlogging: Cloud Audit Logging-specific spec.
	Cloudauditlogging *CloudAuditLoggingFeatureSpec `json:"cloudauditlogging,omitempty"`
	// Clusterupgrade: ClusterUpgrade (fleet-based) feature spec.
	Clusterupgrade *ClusterUpgradeFleetSpec `json:"clusterupgrade,omitempty"`
	// Dataplanev2: DataplaneV2 feature spec.
	Dataplanev2 *DataplaneV2FeatureSpec `json:"dataplanev2,omitempty"`
	// Fleetobservability: FleetObservability feature spec.
	Fleetobservability *FleetObservabilityFeatureSpec `json:"fleetobservability,omitempty"`
	// Multiclusteringress: Multicluster Ingress-specific spec.
	Multiclusteringress *MultiClusterIngressFeatureSpec `json:"multiclusteringress,omitempty"`
	// Namespaceactuation: Namespace Actuation feature spec
	Namespaceactuation *NamespaceActuationFeatureSpec `json:"namespaceactuation,omitempty"`
	// Rbacrolebindingactuation: RBAC Role Binding Actuation feature spec
	Rbacrolebindingactuation *RBACRoleBindingActuationFeatureSpec `json:"rbacrolebindingactuation,omitempty"`
	// Workloadcertificate: Workload Certificate spec.
	Workloadcertificate *FeatureSpec `json:"workloadcertificate,omitempty"`
	// Workloadidentity: Workload Identity feature spec.
	Workloadidentity *WorkloadIdentityFeatureSpec `json:"workloadidentity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Appdevexperience") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Appdevexperience") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CommonFeatureSpec) MarshalJSON() ([]byte, error) {
	type NoMethod CommonFeatureSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CommonFeatureState: CommonFeatureState contains Fleet-wide Feature status
// information.
type CommonFeatureState struct {
	// Appdevexperience: Appdevexperience specific state.
	Appdevexperience *AppDevExperienceFeatureState `json:"appdevexperience,omitempty"`
	// Clusterupgrade: ClusterUpgrade fleet-level state.
	Clusterupgrade *ClusterUpgradeFleetState `json:"clusterupgrade,omitempty"`
	// Fleetobservability: FleetObservability feature state.
	Fleetobservability *FleetObservabilityFeatureState `json:"fleetobservability,omitempty"`
	// Namespaceactuation: Namespace Actuation feature state.
	Namespaceactuation *NamespaceActuationFeatureState `json:"namespaceactuation,omitempty"`
	// Rbacrolebindingactuation: RBAC Role Binding Actuation feature state
	Rbacrolebindingactuation *RBACRoleBindingActuationFeatureState `json:"rbacrolebindingactuation,omitempty"`
	// Servicemesh: Service Mesh-specific state.
	Servicemesh *ServiceMeshFeatureState `json:"servicemesh,omitempty"`
	// State: Output only. The "running state" of the Feature in this Fleet.
	State *FeatureState `json:"state,omitempty"`
	// Workloadidentity: WorkloadIdentity fleet-level state.
	Workloadidentity *WorkloadIdentityFeatureState `json:"workloadidentity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Appdevexperience") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Appdevexperience") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CommonFeatureState) MarshalJSON() ([]byte, error) {
	type NoMethod CommonFeatureState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CommonFleetDefaultMemberConfigSpec: CommonFleetDefaultMemberConfigSpec
// contains default configuration information for memberships of a fleet
type CommonFleetDefaultMemberConfigSpec struct {
	// Configmanagement: Config Management-specific spec.
	Configmanagement *ConfigManagementMembershipSpec `json:"configmanagement,omitempty"`
	// Identityservice: Identity Service-specific spec.
	Identityservice *IdentityServiceMembershipSpec `json:"identityservice,omitempty"`
	// Mesh: Anthos Service Mesh-specific spec
	Mesh *ServiceMeshMembershipSpec `json:"mesh,omitempty"`
	// Policycontroller: Policy Controller spec.
	Policycontroller *PolicyControllerMembershipSpec `json:"policycontroller,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Configmanagement") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Configmanagement") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CommonFleetDefaultMemberConfigSpec) MarshalJSON() ([]byte, error) {
	type NoMethod CommonFleetDefaultMemberConfigSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CompliancePostureConfig: CompliancePostureConfig defines the settings needed
// to enable/disable features for the Compliance Posture.
type CompliancePostureConfig struct {
	// ComplianceStandards: List of enabled compliance standards.
	ComplianceStandards []*ComplianceStandard `json:"complianceStandards,omitempty"`
	// Mode: Defines the enablement mode for Compliance Posture.
	//
	// Possible values:
	//   "MODE_UNSPECIFIED" - Default value not specified.
	//   "DISABLED" - Disables Compliance Posture features on the cluster.
	//   "ENABLED" - Enables Compliance Posture features on the cluster.
	Mode string `json:"mode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ComplianceStandards") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ComplianceStandards") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CompliancePostureConfig) MarshalJSON() ([]byte, error) {
	type NoMethod CompliancePostureConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ComplianceStandard struct {
	// Standard: Name of the compliance standard.
	Standard string `json:"standard,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Standard") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Standard") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ComplianceStandard) MarshalJSON() ([]byte, error) {
	type NoMethod ComplianceStandard
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConfigManagementBinauthzConfig: Configuration for Binauthz
type ConfigManagementBinauthzConfig struct {
	// Enabled: Whether binauthz is enabled in this cluster.
	Enabled bool `json:"enabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConfigManagementBinauthzConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigManagementBinauthzConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConfigManagementBinauthzState: State for Binauthz
type ConfigManagementBinauthzState struct {
	// Version: The version of binauthz that is installed.
	Version *ConfigManagementBinauthzVersion `json:"version,omitempty"`
	// Webhook: The state of the binauthz webhook.
	//
	// Possible values:
	//   "DEPLOYMENT_STATE_UNSPECIFIED" - Deployment's state cannot be determined
	//   "NOT_INSTALLED" - Deployment is not installed
	//   "INSTALLED" - Deployment is installed
	//   "ERROR" - Deployment was attempted to be installed, but has errors
	//   "PENDING" - Deployment is installing or terminating
	Webhook string `json:"webhook,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Version") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Version") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConfigManagementBinauthzState) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigManagementBinauthzState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConfigManagementBinauthzVersion: The version of binauthz.
type ConfigManagementBinauthzVersion struct {
	// WebhookVersion: The version of the binauthz webhook.
	WebhookVersion string `json:"webhookVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "WebhookVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "WebhookVersion") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConfigManagementBinauthzVersion) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigManagementBinauthzVersion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConfigManagementConfigSync: Configuration for Config Sync
type ConfigManagementConfigSync struct {
	// DeploymentOverrides: Optional. Configuration for deployment overrides.
	// Applies only to Config Sync deployments with containers that are not a root
	// or namespace reconciler: `reconciler-manager`, `otel-collector`,
	// `resource-group-controller-manager`, `admission-webhook`. To override a root
	// or namespace reconciler, use the rootsync or reposync fields at
	// https://docs.cloud.google.com/kubernetes-engine/config-sync/docs/reference/rootsync-reposync-fields#override-resources
	// instead.
	DeploymentOverrides []*ConfigManagementDeploymentOverride `json:"deploymentOverrides,omitempty"`
	// Enabled: Optional. Enables the installation of Config Sync. If set to true,
	// the Feature will manage Config Sync resources, and apply the other
	// ConfigSync fields if they exist. If set to false, the Feature will ignore
	// all other ConfigSync fields and delete the Config Sync resources. If
	// omitted, ConfigSync is considered enabled if the git or oci field is
	// present.
	Enabled bool `json:"enabled,omitempty"`
	// Git: Optional. Git repo configuration for the cluster.
	Git *ConfigManagementGitConfig `json:"git,omitempty"`
	// MetricsGcpServiceAccountEmail: Optional. The Email of the Google Cloud
	// Service Account (GSA) used for exporting Config Sync metrics to Cloud
	// Monitoring and Cloud Monarch when Workload Identity is enabled. The GSA
	// should have the Monitoring Metric Writer (roles/monitoring.metricWriter) IAM
	// role. The Kubernetes ServiceAccount `default` in the namespace
	// `config-management-monitoring` should be bound to the GSA. Deprecated: If
	// Workload Identity Federation for GKE is enabled, Google Cloud Service
	// Account is no longer needed for exporting Config Sync metrics:
	// https://cloud.google.com/kubernetes-engine/enterprise/config-sync/docs/how-to/monitor-config-sync-cloud-monitoring#custom-monitoring.
	MetricsGcpServiceAccountEmail string `json:"metricsGcpServiceAccountEmail,omitempty"`
	// Oci: Optional. OCI repo configuration for the cluster
	Oci *ConfigManagementOciConfig `json:"oci,omitempty"`
	// PreventDrift: Optional. Set to true to enable the Config Sync admission
	// webhook to prevent drifts. If set to false, disables the Config Sync
	// admission webhook and does not prevent drifts. Defaults to false. See
	// https://docs.cloud.google.com/kubernetes-engine/config-sync/docs/how-to/prevent-config-drift
	// for details.
	PreventDrift bool `json:"preventDrift,omitempty"`
	// SourceFormat: Optional. Specifies whether the Config Sync repo is in
	// `hierarchical` or `unstructured` mode. Defaults to `hierarchical`. See
	// https://docs.cloud.google.com/kubernetes-engine/config-sync/docs/concepts/configs#organize-configs
	// for an explanation.
	SourceFormat string `json:"sourceFormat,omitempty"`
	// StopSyncing: Optional. Set to true to stop syncing configs for a single
	// cluster. Default to false.
	StopSyncing bool `json:"stopSyncing,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeploymentOverrides") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeploymentOverrides") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConfigManagementConfigSync) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigManagementConfigSync
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConfigManagementConfigSyncDeploymentState: The state of ConfigSync's
// deployment on a cluster
type ConfigManagementConfigSyncDeploymentState struct {
	// AdmissionWebhook: Deployment state of admission-webhook
	//
	// Possible values:
	//   "DEPLOYMENT_STATE_UNSPECIFIED" - Deployment's state cannot be determined
	//   "NOT_INSTALLED" - Deployment is not installed
	//   "INSTALLED" - Deployment is installed
	//   "ERROR" - Deployment was attempted to be installed, but has errors
	//   "PENDING" - Deployment is installing or terminating
	AdmissionWebhook string `json:"admissionWebhook,omitempty"`
	// GitSync: Deployment state of the git-sync pod
	//
	// Possible values:
	//   "DEPLOYMENT_STATE_UNSPECIFIED" - Deployment's state cannot be determined
	//   "NOT_INSTALLED" - Deployment is not installed
	//   "INSTALLED" - Deployment is installed
	//   "ERROR" - Deployment was attempted to be installed, but has errors
	//   "PENDING" - Deployment is installing or terminating
	GitSync string `json:"gitSync,omitempty"`
	// Importer: Deployment state of the importer pod
	//
	// Possible values:
	//   "DEPLOYMENT_STATE_UNSPECIFIED" - Deployment's state cannot be determined
	//   "NOT_INSTALLED" - Deployment is not installed
	//   "INSTALLED" - Deployment is installed
	//   "ERROR" - Deployment was attempted to be installed, but has errors
	//   "PENDING" - Deployment is installing or terminating
	Importer string `json:"importer,omitempty"`
	// Monitor: Deployment state of the monitor pod
	//
	// Possible values:
	//   "DEPLOYMENT_STATE_UNSPECIFIED" - Deployment's state cannot be determined
	//   "NOT_INSTALLED" - Deployment is not installed
	//   "INSTALLED" - Deployment is installed
	//   "ERROR" - Deployment was attempted to be installed, but has errors
	//   "PENDING" - Deployment is installing or terminating
	Monitor string `json:"monitor,omitempty"`
	// OtelCollector: Deployment state of otel-collector
	//
	// Possible values:
	//   "DEPLOYMENT_STATE_UNSPECIFIED" - Deployment's state cannot be determined
	//   "NOT_INSTALLED" - Deployment is not installed
	//   "INSTALLED" - Deployment is installed
	//   "ERROR" - Deployment was attempted to be installed, but has errors
	//   "PENDING" - Deployment is installing or terminating
	OtelCollector string `json:"otelCollector,omitempty"`
	// ReconcilerManager: Deployment state of reconciler-manager pod
	//
	// Possible values:
	//   "DEPLOYMENT_STATE_UNSPECIFIED" - Deployment's state cannot be determined
	//   "NOT_INSTALLED" - Deployment is not installed
	//   "INSTALLED" - Deployment is installed
	//   "ERROR" - Deployment was attempted to be installed, but has errors
	//   "PENDING" - Deployment is installing or terminating
	ReconcilerManager string `json:"reconcilerManager,omitempty"`
	// ResourceGroupControllerManager: Deployment state of
	// resource-group-controller-manager
	//
	// Possible values:
	//   "DEPLOYMENT_STATE_UNSPECIFIED" - Deployment's state cannot be determined
	//   "NOT_INSTALLED" - Deployment is not installed
	//   "INSTALLED" - Deployment is installed
	//   "ERROR" - Deployment was attempted to be installed, but has errors
	//   "PENDING" - Deployment is installing or terminating
	ResourceGroupControllerManager string `json:"resourceGroupControllerManager,omitempty"`
	// RootReconciler: Deployment state of root-reconciler
	//
	// Possible values:
	//   "DEPLOYMENT_STATE_UNSPECIFIED" - Deployment's state cannot be determined
	//   "NOT_INSTALLED" - Deployment is not installed
	//   "INSTALLED" - Deployment is installed
	//   "ERROR" - Deployment was attempted to be installed, but has errors
	//   "PENDING" - Deployment is installing or terminating
	RootReconciler string `json:"rootReconciler,omitempty"`
	// Syncer: Deployment state of the syncer pod
	//
	// Possible values:
	//   "DEPLOYMENT_STATE_UNSPECIFIED" - Deployment's state cannot be determined
	//   "NOT_INSTALLED" - Deployment is not installed
	//   "INSTALLED" - Deployment is installed
	//   "ERROR" - Deployment was attempted to be installed, but has errors
	//   "PENDING" - Deployment is installing or terminating
	Syncer string `json:"syncer,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdmissionWebhook") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdmissionWebhook") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConfigManagementConfigSyncDeploymentState) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigManagementConfigSyncDeploymentState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConfigManagementConfigSyncError: Errors pertaining to the installation of
// Config Sync
type ConfigManagementConfigSyncError struct {
	// ErrorMessage: A string representing the user facing error message
	ErrorMessage string `json:"errorMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorMessage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorMessage") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConfigManagementConfigSyncError) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigManagementConfigSyncError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConfigManagementConfigSyncState: State information for ConfigSync
type ConfigManagementConfigSyncState struct {
	// ClusterLevelStopSyncingState: Output only. Whether syncing resources to the
	// cluster is stopped at the cluster level.
	//
	// Possible values:
	//   "STOP_SYNCING_STATE_UNSPECIFIED" - State cannot be determined
	//   "NOT_STOPPED" - Syncing resources to the cluster is not stopped at the
	// cluster level.
	//   "PENDING" - Some reconcilers stop syncing resources to the cluster, while
	// others are still syncing.
	//   "STOPPED" - Syncing resources to the cluster is stopped at the cluster
	// level.
	ClusterLevelStopSyncingState string `json:"clusterLevelStopSyncingState,omitempty"`
	// CrCount: Output only. The number of RootSync and RepoSync CRs in the
	// cluster.
	CrCount int64 `json:"crCount,omitempty"`
	// DeploymentState: Output only. Information about the deployment of
	// ConfigSync, including the version of the various Pods deployed
	DeploymentState *ConfigManagementConfigSyncDeploymentState `json:"deploymentState,omitempty"`
	// Errors: Output only. Errors pertaining to the installation of Config Sync.
	Errors []*ConfigManagementConfigSyncError `json:"errors,omitempty"`
	// ReposyncCrd: Output only. The state of the Reposync CRD
	//
	// Possible values:
	//   "CRD_STATE_UNSPECIFIED" - CRD's state cannot be determined
	//   "NOT_INSTALLED" - CRD is not installed
	//   "INSTALLED" - CRD is installed
	//   "TERMINATING" - CRD is terminating (i.e., it has been deleted and is
	// cleaning up)
	//   "INSTALLING" - CRD is installing
	ReposyncCrd string `json:"reposyncCrd,omitempty"`
	// RootsyncCrd: Output only. The state of the RootSync CRD
	//
	// Possible values:
	//   "CRD_STATE_UNSPECIFIED" - CRD's state cannot be determined
	//   "NOT_INSTALLED" - CRD is not installed
	//   "INSTALLED" - CRD is installed
	//   "TERMINATING" - CRD is terminating (i.e., it has been deleted and is
	// cleaning up)
	//   "INSTALLING" - CRD is installing
	RootsyncCrd string `json:"rootsyncCrd,omitempty"`
	// State: Output only. The state of CS This field summarizes the other fields
	// in this message.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - CS's state cannot be determined.
	//   "CONFIG_SYNC_NOT_INSTALLED" - CS is not installed.
	//   "CONFIG_SYNC_INSTALLED" - The expected CS version is installed
	// successfully.
	//   "CONFIG_SYNC_ERROR" - CS encounters errors.
	//   "CONFIG_SYNC_PENDING" - CS is installing or terminating.
	State string `json:"state,omitempty"`
	// SyncState: Output only. The state of ConfigSync's process to sync configs to
	// a cluster
	SyncState *ConfigManagementSyncState `json:"syncState,omitempty"`
	// Version: Output only. The version of ConfigSync deployed
	Version *ConfigManagementConfigSyncVersion `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "ClusterLevelStopSyncingState") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClusterLevelStopSyncingState") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConfigManagementConfigSyncState) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigManagementConfigSyncState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConfigManagementConfigSyncVersion: Specific versioning information
// pertaining to ConfigSync's Pods
type ConfigManagementConfigSyncVersion struct {
	// AdmissionWebhook: Version of the deployed admission-webhook pod
	AdmissionWebhook string `json:"admissionWebhook,omitempty"`
	// GitSync: Version of the deployed git-sync pod
	GitSync string `json:"gitSync,omitempty"`
	// Importer: Version of the deployed importer pod
	Importer string `json:"importer,omitempty"`
	// Monitor: Version of the deployed monitor pod
	Monitor string `json:"monitor,omitempty"`
	// OtelCollector: Version of the deployed otel-collector pod
	OtelCollector string `json:"otelCollector,omitempty"`
	// ReconcilerManager: Version of the deployed reconciler-manager pod
	ReconcilerManager string `json:"reconcilerManager,omitempty"`
	// ResourceGroupControllerManager: Version of the deployed
	// resource-group-controller-manager pod
	ResourceGroupControllerManager string `json:"resourceGroupControllerManager,omitempty"`
	// RootReconciler: Version of the deployed reconciler container in
	// root-reconciler pod
	RootReconciler string `json:"rootReconciler,omitempty"`
	// Syncer: Version of the deployed syncer pod
	Syncer string `json:"syncer,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdmissionWebhook") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdmissionWebhook") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConfigManagementConfigSyncVersion) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigManagementConfigSyncVersion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConfigManagementContainerOverride: Configuration for a container override.
type ConfigManagementContainerOverride struct {
	// ContainerName: Required. The name of the container.
	ContainerName string `json:"containerName,omitempty"`
	// CpuLimit: Optional. The cpu limit of the container. Use the following CPU
	// resource units:
	// https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/#meaning-of-cpu.
	CpuLimit string `json:"cpuLimit,omitempty"`
	// CpuRequest: Optional. The cpu request of the container. Use the following
	// CPU resource units:
	// https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/#meaning-of-cpu.
	CpuRequest string `json:"cpuRequest,omitempty"`
	// MemoryLimit: Optional. The memory limit of the container. Use the following
	// memory resource units:
	// https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/#meaning-of-memory.
	MemoryLimit string `json:"memoryLimit,omitempty"`
	// MemoryRequest: Optional. The memory request of the container. Use the
	// following memory resource units:
	// https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/#meaning-of-memory.
	MemoryRequest string `json:"memoryRequest,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContainerName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContainerName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConfigManagementContainerOverride) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigManagementContainerOverride
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConfigManagementDeploymentOverride: Configuration for a deployment override.
type ConfigManagementDeploymentOverride struct {
	// Containers: Optional. The containers of the deployment resource to be
	// overridden.
	Containers []*ConfigManagementContainerOverride `json:"containers,omitempty"`
	// DeploymentName: Required. The name of the deployment resource to be
	// overridden.
	DeploymentName string `json:"deploymentName,omitempty"`
	// DeploymentNamespace: Required. The namespace of the deployment resource to
	// be overridden.
	DeploymentNamespace string `json:"deploymentNamespace,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Containers") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Containers") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConfigManagementDeploymentOverride) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigManagementDeploymentOverride
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConfigManagementErrorResource: Model for a config file in the git repo with
// an associated Sync error
type ConfigManagementErrorResource struct {
	// ResourceGvk: Group/version/kind of the resource that is causing an error
	ResourceGvk *ConfigManagementGroupVersionKind `json:"resourceGvk,omitempty"`
	// ResourceName: Metadata name of the resource that is causing an error
	ResourceName string `json:"resourceName,omitempty"`
	// ResourceNamespace: Namespace of the resource that is causing an error
	ResourceNamespace string `json:"resourceNamespace,omitempty"`
	// SourcePath: Path in the git repo of the erroneous config
	SourcePath string `json:"sourcePath,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ResourceGvk") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ResourceGvk") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConfigManagementErrorResource) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigManagementErrorResource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConfigManagementGatekeeperDeploymentState: State of Policy Controller
// installation.
type ConfigManagementGatekeeperDeploymentState struct {
	// GatekeeperAudit: Status of gatekeeper-audit deployment.
	//
	// Possible values:
	//   "DEPLOYMENT_STATE_UNSPECIFIED" - Deployment's state cannot be determined
	//   "NOT_INSTALLED" - Deployment is not installed
	//   "INSTALLED" - Deployment is installed
	//   "ERROR" - Deployment was attempted to be installed, but has errors
	//   "PENDING" - Deployment is installing or terminating
	GatekeeperAudit string `json:"gatekeeperAudit,omitempty"`
	// GatekeeperControllerManagerState: Status of gatekeeper-controller-manager
	// pod.
	//
	// Possible values:
	//   "DEPLOYMENT_STATE_UNSPECIFIED" - Deployment's state cannot be determined
	//   "NOT_INSTALLED" - Deployment is not installed
	//   "INSTALLED" - Deployment is installed
	//   "ERROR" - Deployment was attempted to be installed, but has errors
	//   "PENDING" - Deployment is installing or terminating
	GatekeeperControllerManagerState string `json:"gatekeeperControllerManagerState,omitempty"`
	// GatekeeperMutation: Status of the pod serving the mutation webhook.
	//
	// Possible values:
	//   "DEPLOYMENT_STATE_UNSPECIFIED" - Deployment's state cannot be determined
	//   "NOT_INSTALLED" - Deployment is not installed
	//   "INSTALLED" - Deployment is installed
	//   "ERROR" - Deployment was attempted to be installed, but has errors
	//   "PENDING" - Deployment is installing or terminating
	GatekeeperMutation string `json:"gatekeeperMutation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GatekeeperAudit") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GatekeeperAudit") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConfigManagementGatekeeperDeploymentState) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigManagementGatekeeperDeploymentState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConfigManagementGitConfig: Git repo configuration for a single cluster.
type ConfigManagementGitConfig struct {
	// GcpServiceAccountEmail: Optional. The Google Cloud Service Account Email
	// used for auth when secret_type is `gcpserviceaccount`.
	GcpServiceAccountEmail string `json:"gcpServiceAccountEmail,omitempty"`
	// HttpsProxy: Optional. URL for the HTTPS proxy to be used when communicating
	// with the Git repo. Only specify when secret_type is `cookiefile`, `token`,
	// or `none`.
	HttpsProxy string `json:"httpsProxy,omitempty"`
	// PolicyDir: Optional. The path within the Git repository that represents the
	// top level of the repo to sync. Default: the root directory of the
	// repository.
	PolicyDir string `json:"policyDir,omitempty"`
	// SecretType: Required. Type of secret configured for access to the Git repo.
	// Must be one of `ssh`, `cookiefile`, `gcenode`, `token`, `gcpserviceaccount`,
	// `githubapp` or `none`. The validation of this is case-sensitive.
	SecretType string `json:"secretType,omitempty"`
	// SyncBranch: Optional. The branch of the repository to sync from. Default:
	// master.
	SyncBranch string `json:"syncBranch,omitempty"`
	// SyncRepo: Required. The URL of the Git repository to use as the source of
	// truth.
	SyncRepo string `json:"syncRepo,omitempty"`
	// SyncRev: Optional. Git revision (tag or hash) to check out. Default HEAD.
	SyncRev string `json:"syncRev,omitempty"`
	// SyncWaitSecs: Optional. Period in seconds between consecutive syncs.
	// Default: 15.
	SyncWaitSecs int64 `json:"syncWaitSecs,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "GcpServiceAccountEmail") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcpServiceAccountEmail") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConfigManagementGitConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigManagementGitConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConfigManagementGroupVersionKind: A Kubernetes object's GVK
type ConfigManagementGroupVersionKind struct {
	// Group: Kubernetes Group
	Group string `json:"group,omitempty"`
	// Kind: Kubernetes Kind
	Kind string `json:"kind,omitempty"`
	// Version: Kubernetes Version
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Group") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Group") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConfigManagementGroupVersionKind) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigManagementGroupVersionKind
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConfigManagementHierarchyControllerConfig: Configuration for Hierarchy
// Controller
type ConfigManagementHierarchyControllerConfig struct {
	// EnableHierarchicalResourceQuota: Whether hierarchical resource quota is
	// enabled in this cluster.
	EnableHierarchicalResourceQuota bool `json:"enableHierarchicalResourceQuota,omitempty"`
	// EnablePodTreeLabels: Whether pod tree labels are enabled in this cluster.
	EnablePodTreeLabels bool `json:"enablePodTreeLabels,omitempty"`
	// Enabled: Whether Hierarchy Controller is enabled in this cluster.
	Enabled bool `json:"enabled,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "EnableHierarchicalResourceQuota") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableHierarchicalResourceQuota")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConfigManagementHierarchyControllerConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigManagementHierarchyControllerConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConfigManagementHierarchyControllerDeploymentState: Deployment state for
// Hierarchy Controller
type ConfigManagementHierarchyControllerDeploymentState struct {
	// Extension: The deployment state for Hierarchy Controller extension (e.g.
	// v0.7.0-hc.1)
	//
	// Possible values:
	//   "DEPLOYMENT_STATE_UNSPECIFIED" - Deployment's state cannot be determined
	//   "NOT_INSTALLED" - Deployment is not installed
	//   "INSTALLED" - Deployment is installed
	//   "ERROR" - Deployment was attempted to be installed, but has errors
	//   "PENDING" - Deployment is installing or terminating
	Extension string `json:"extension,omitempty"`
	// Hnc: The deployment state for open source HNC (e.g. v0.7.0-hc.0)
	//
	// Possible values:
	//   "DEPLOYMENT_STATE_UNSPECIFIED" - Deployment's state cannot be determined
	//   "NOT_INSTALLED" - Deployment is not installed
	//   "INSTALLED" - Deployment is installed
	//   "ERROR" - Deployment was attempted to be installed, but has errors
	//   "PENDING" - Deployment is installing or terminating
	Hnc string `json:"hnc,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Extension") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Extension") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConfigManagementHierarchyControllerDeploymentState) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigManagementHierarchyControllerDeploymentState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConfigManagementHierarchyControllerState: State for Hierarchy Controller
type ConfigManagementHierarchyControllerState struct {
	// State: The deployment state for Hierarchy Controller
	State *ConfigManagementHierarchyControllerDeploymentState `json:"state,omitempty"`
	// Version: The version for Hierarchy Controller
	Version *ConfigManagementHierarchyControllerVersion `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "State") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "State") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConfigManagementHierarchyControllerState) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigManagementHierarchyControllerState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConfigManagementHierarchyControllerVersion: Version for Hierarchy Controller
type ConfigManagementHierarchyControllerVersion struct {
	// Extension: Version for Hierarchy Controller extension
	Extension string `json:"extension,omitempty"`
	// Hnc: Version for open source HNC
	Hnc string `json:"hnc,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Extension") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Extension") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConfigManagementHierarchyControllerVersion) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigManagementHierarchyControllerVersion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConfigManagementInstallError: Errors pertaining to the installation of ACM
type ConfigManagementInstallError struct {
	// ErrorMessage: A string representing the user facing error message
	ErrorMessage string `json:"errorMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorMessage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorMessage") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConfigManagementInstallError) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigManagementInstallError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConfigManagementMembershipSpec: **Anthos Config Management**: Configuration
// for a single cluster. Intended to parallel the ConfigManagement CR.
type ConfigManagementMembershipSpec struct {
	// Binauthz: Optional. Deprecated: Binauthz configuration will be ignored and
	// should not be set.
	Binauthz *ConfigManagementBinauthzConfig `json:"binauthz,omitempty"`
	// Cluster: Optional. User-specified cluster name used by the Config Sync
	// cluster-name-selector annotation or ClusterSelector object, for applying
	// configs to only a subset of clusters. Read more about the
	// cluster-name-selector annotation and ClusterSelector object at
	// https://docs.cloud.google.com/kubernetes-engine/config-sync/docs/how-to/cluster-scoped-objects#limiting-configs.
	// Only set this field if a name different from the cluster's fleet membership
	// name is used by the Config Sync cluster-name-selector annotation or
	// ClusterSelector.
	Cluster string `json:"cluster,omitempty"`
	// ConfigSync: Optional. Config Sync configuration for the cluster.
	ConfigSync *ConfigManagementConfigSync `json:"configSync,omitempty"`
	// HierarchyController: Optional. Hierarchy Controller configuration for the
	// cluster. Deprecated: Configuring Hierarchy Controller through the
	// configmanagement feature is no longer recommended. Use
	// https://github.com/kubernetes-sigs/hierarchical-namespaces instead.
	HierarchyController *ConfigManagementHierarchyControllerConfig `json:"hierarchyController,omitempty"`
	// Management: Optional. Deprecated: From version 1.21.0, automatic Feature
	// management is unavailable, and Config Sync only supports manual upgrades.
	//
	// Possible values:
	//   "MANAGEMENT_UNSPECIFIED" - Unspecified
	//   "MANAGEMENT_AUTOMATIC" - Google will manage the Feature for the cluster.
	//   "MANAGEMENT_MANUAL" - User will manually manage the Feature for the
	// cluster.
	Management string `json:"management,omitempty"`
	// PolicyController: Optional. Policy Controller configuration for the cluster.
	// Deprecated: Configuring Policy Controller through the configmanagement
	// feature is no longer recommended. Use the policycontroller feature instead.
	PolicyController *ConfigManagementPolicyController `json:"policyController,omitempty"`
	// Version: Optional. Version of Config Sync to install. Defaults to the latest
	// supported Config Sync version if the config_sync field is enabled. See
	// supported versions at
	// https://cloud.google.com/kubernetes-engine/config-sync/docs/get-support-config-sync#version_support_policy.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Binauthz") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Binauthz") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConfigManagementMembershipSpec) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigManagementMembershipSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConfigManagementMembershipState: **Anthos Config Management**: State for a
// single cluster.
type ConfigManagementMembershipState struct {
	// BinauthzState: Output only. Binauthz status
	BinauthzState *ConfigManagementBinauthzState `json:"binauthzState,omitempty"`
	// ClusterName: Output only. This field is set to the `cluster_name` field of
	// the Membership Spec if it is not empty. Otherwise, it is set to the
	// cluster's fleet membership name.
	ClusterName string `json:"clusterName,omitempty"`
	// ConfigSyncState: Output only. Current sync status
	ConfigSyncState *ConfigManagementConfigSyncState `json:"configSyncState,omitempty"`
	// HierarchyControllerState: Output only. Hierarchy Controller status
	HierarchyControllerState *ConfigManagementHierarchyControllerState `json:"hierarchyControllerState,omitempty"`
	// KubernetesApiServerVersion: Output only. The Kubernetes API server version
	// of the cluster.
	KubernetesApiServerVersion string `json:"kubernetesApiServerVersion,omitempty"`
	// MembershipSpec: Output only. Membership configuration in the cluster. This
	// represents the actual state in the cluster, while the MembershipSpec in the
	// FeatureSpec represents the intended state
	MembershipSpec *ConfigManagementMembershipSpec `json:"membershipSpec,omitempty"`
	// OperatorState: Output only. Current install status of ACM's Operator
	OperatorState *ConfigManagementOperatorState `json:"operatorState,omitempty"`
	// PolicyControllerState: Output only. PolicyController status
	PolicyControllerState *ConfigManagementPolicyControllerState `json:"policyControllerState,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BinauthzState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BinauthzState") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConfigManagementMembershipState) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigManagementMembershipState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConfigManagementOciConfig: OCI repo configuration for a single cluster
type ConfigManagementOciConfig struct {
	// GcpServiceAccountEmail: Optional. The Google Cloud Service Account Email
	// used for auth when secret_type is `gcpserviceaccount`.
	GcpServiceAccountEmail string `json:"gcpServiceAccountEmail,omitempty"`
	// PolicyDir: Optional. The absolute path of the directory that contains the
	// local resources. Default: the root directory of the image.
	PolicyDir string `json:"policyDir,omitempty"`
	// SecretType: Required. Type of secret configured for access to the OCI repo.
	// Must be one of `gcenode`, `gcpserviceaccount`, `k8sserviceaccount` or
	// `none`. The validation of this is case-sensitive.
	SecretType string `json:"secretType,omitempty"`
	// SyncRepo: Required. The OCI image repository URL for the package to sync
	// from. e.g.
	// `LOCATION-docker.pkg.dev/PROJECT_ID/REPOSITORY_NAME/PACKAGE_NAME`.
	SyncRepo string `json:"syncRepo,omitempty"`
	// SyncWaitSecs: Optional. Period in seconds between consecutive syncs.
	// Default: 15.
	SyncWaitSecs int64 `json:"syncWaitSecs,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "GcpServiceAccountEmail") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcpServiceAccountEmail") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConfigManagementOciConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigManagementOciConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConfigManagementOperatorState: State information for an ACM's Operator
type ConfigManagementOperatorState struct {
	// DeploymentState: The state of the Operator's deployment
	//
	// Possible values:
	//   "DEPLOYMENT_STATE_UNSPECIFIED" - Deployment's state cannot be determined
	//   "NOT_INSTALLED" - Deployment is not installed
	//   "INSTALLED" - Deployment is installed
	//   "ERROR" - Deployment was attempted to be installed, but has errors
	//   "PENDING" - Deployment is installing or terminating
	DeploymentState string `json:"deploymentState,omitempty"`
	// Errors: Install errors.
	Errors []*ConfigManagementInstallError `json:"errors,omitempty"`
	// Version: The semenatic version number of the operator
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeploymentState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeploymentState") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConfigManagementOperatorState) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigManagementOperatorState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConfigManagementPolicyController: Configuration for Policy Controller
type ConfigManagementPolicyController struct {
	// AuditIntervalSeconds: Sets the interval for Policy Controller Audit Scans
	// (in seconds). When set to 0, this disables audit functionality altogether.
	AuditIntervalSeconds int64 `json:"auditIntervalSeconds,omitempty,string"`
	// Enabled: Enables the installation of Policy Controller. If false, the rest
	// of PolicyController fields take no effect.
	Enabled bool `json:"enabled,omitempty"`
	// ExemptableNamespaces: The set of namespaces that are excluded from Policy
	// Controller checks. Namespaces do not need to currently exist on the cluster.
	ExemptableNamespaces []string `json:"exemptableNamespaces,omitempty"`
	// LogDeniesEnabled: Logs all denies and dry run failures.
	LogDeniesEnabled bool `json:"logDeniesEnabled,omitempty"`
	// Monitoring: Monitoring specifies the configuration of monitoring.
	Monitoring *ConfigManagementPolicyControllerMonitoring `json:"monitoring,omitempty"`
	// MutationEnabled: Enable or disable mutation in policy controller. If true,
	// mutation CRDs, webhook and controller deployment will be deployed to the
	// cluster.
	MutationEnabled bool `json:"mutationEnabled,omitempty"`
	// ReferentialRulesEnabled: Enables the ability to use Constraint Templates
	// that reference to objects other than the object currently being evaluated.
	ReferentialRulesEnabled bool `json:"referentialRulesEnabled,omitempty"`
	// TemplateLibraryInstalled: Installs the default template library along with
	// Policy Controller.
	TemplateLibraryInstalled bool `json:"templateLibraryInstalled,omitempty"`
	// UpdateTime: Output only. Last time this membership spec was updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AuditIntervalSeconds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuditIntervalSeconds") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConfigManagementPolicyController) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigManagementPolicyController
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConfigManagementPolicyControllerMigration: State for the migration of
// PolicyController from ACM -> PoCo Hub.
type ConfigManagementPolicyControllerMigration struct {
	// CopyTime: Last time this membership spec was copied to PoCo feature.
	CopyTime string `json:"copyTime,omitempty"`
	// Stage: Stage of the migration.
	//
	// Possible values:
	//   "STAGE_UNSPECIFIED" - Unknown state of migration.
	//   "ACM_MANAGED" - ACM Hub/Operator manages policycontroller. No migration
	// yet completed.
	//   "POCO_MANAGED" - All migrations steps complete; Poco Hub now manages
	// policycontroller.
	Stage string `json:"stage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CopyTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CopyTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConfigManagementPolicyControllerMigration) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigManagementPolicyControllerMigration
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConfigManagementPolicyControllerMonitoring: PolicyControllerMonitoring
// specifies the backends Policy Controller should export metrics to. For
// example, to specify metrics should be exported to Cloud Monitoring and
// Prometheus, specify backends: ["cloudmonitoring", "prometheus"]
type ConfigManagementPolicyControllerMonitoring struct {
	// Backends: Specifies the list of backends Policy Controller will export to.
	// An empty list would effectively disable metrics export.
	//
	// Possible values:
	//   "MONITORING_BACKEND_UNSPECIFIED" - Backend cannot be determined
	//   "PROMETHEUS" - Prometheus backend for monitoring
	//   "CLOUD_MONITORING" - Stackdriver/Cloud Monitoring backend for monitoring
	Backends []string `json:"backends,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Backends") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Backends") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConfigManagementPolicyControllerMonitoring) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigManagementPolicyControllerMonitoring
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConfigManagementPolicyControllerState: State for PolicyControllerState.
type ConfigManagementPolicyControllerState struct {
	// DeploymentState: The state about the policy controller installation.
	DeploymentState *ConfigManagementGatekeeperDeploymentState `json:"deploymentState,omitempty"`
	// Migration: Record state of ACM -> PoCo Hub migration for this feature.
	Migration *ConfigManagementPolicyControllerMigration `json:"migration,omitempty"`
	// Version: The version of Gatekeeper Policy Controller deployed.
	Version *ConfigManagementPolicyControllerVersion `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeploymentState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeploymentState") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConfigManagementPolicyControllerState) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigManagementPolicyControllerState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConfigManagementPolicyControllerVersion: The build version of Gatekeeper
// Policy Controller is using.
type ConfigManagementPolicyControllerVersion struct {
	// Version: The gatekeeper image tag that is composed of ACM version, git tag,
	// build number.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Version") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Version") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConfigManagementPolicyControllerVersion) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigManagementPolicyControllerVersion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConfigManagementSyncError: An ACM created error representing a problem
// syncing configurations
type ConfigManagementSyncError struct {
	// Code: An ACM defined error code
	Code string `json:"code,omitempty"`
	// ErrorMessage: A description of the error
	ErrorMessage string `json:"errorMessage,omitempty"`
	// ErrorResources: A list of config(s) associated with the error, if any
	ErrorResources []*ConfigManagementErrorResource `json:"errorResources,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConfigManagementSyncError) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigManagementSyncError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConfigManagementSyncState: State indicating an ACM's progress syncing
// configurations to a cluster
type ConfigManagementSyncState struct {
	// Code: Sync status code
	//
	// Possible values:
	//   "SYNC_CODE_UNSPECIFIED" - Config Sync cannot determine a sync code
	//   "SYNCED" - Config Sync successfully synced the git Repo with the cluster
	//   "PENDING" - Config Sync is in the progress of syncing a new change
	//   "ERROR" - Indicates an error configuring Config Sync, and user action is
	// required
	//   "NOT_CONFIGURED" - Config Sync has been installed but not configured
	//   "NOT_INSTALLED" - Config Sync has not been installed
	//   "UNAUTHORIZED" - Error authorizing with the cluster
	//   "UNREACHABLE" - Cluster could not be reached
	Code string `json:"code,omitempty"`
	// Errors: A list of errors resulting from problematic configs. This list will
	// be truncated after 100 errors, although it is unlikely for that many errors
	// to simultaneously exist.
	Errors []*ConfigManagementSyncError `json:"errors,omitempty"`
	// ImportToken: Token indicating the state of the importer.
	ImportToken string `json:"importToken,omitempty"`
	// LastSync: Deprecated: use last_sync_time instead. Timestamp of when ACM last
	// successfully synced the repo The time format is specified in
	// https://golang.org/pkg/time/#Time.String
	LastSync string `json:"lastSync,omitempty"`
	// LastSyncTime: Timestamp type of when ACM last successfully synced the repo
	LastSyncTime string `json:"lastSyncTime,omitempty"`
	// SourceToken: Token indicating the state of the repo.
	SourceToken string `json:"sourceToken,omitempty"`
	// SyncToken: Token indicating the state of the syncer.
	SyncToken string `json:"syncToken,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConfigManagementSyncState) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigManagementSyncState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConnectAgentResource: ConnectAgentResource represents a Kubernetes resource
// manifest for Connect Agent deployment.
type ConnectAgentResource struct {
	// Manifest: YAML manifest of the resource.
	Manifest string `json:"manifest,omitempty"`
	// Type: Kubernetes type of the resource.
	Type *TypeMeta `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Manifest") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Manifest") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConnectAgentResource) MarshalJSON() ([]byte, error) {
	type NoMethod ConnectAgentResource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DataplaneV2FeatureSpec: **Dataplane V2**: Spec
type DataplaneV2FeatureSpec struct {
	// EnableEncryption: Enable dataplane-v2 based encryption for multiple
	// clusters.
	EnableEncryption bool `json:"enableEncryption,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableEncryption") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableEncryption") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DataplaneV2FeatureSpec) MarshalJSON() ([]byte, error) {
	type NoMethod DataplaneV2FeatureSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DefaultClusterConfig: DefaultClusterConfig describes the default cluster
// configurations to be applied to all clusters born-in-fleet.
type DefaultClusterConfig struct {
	// BinaryAuthorizationConfig: Optional. Enable/Disable binary authorization
	// features for the cluster.
	BinaryAuthorizationConfig *BinaryAuthorizationConfig `json:"binaryAuthorizationConfig,omitempty"`
	// CompliancePostureConfig: Optional. Enable/Disable Compliance Posture
	// features for the cluster. Note that on UpdateFleet, only full replacement of
	// this field is allowed. Users are not allowed for partial updates through
	// field mask.
	CompliancePostureConfig *CompliancePostureConfig `json:"compliancePostureConfig,omitempty"`
	// SecurityPostureConfig: Enable/Disable Security Posture features for the
	// cluster.
	SecurityPostureConfig *SecurityPostureConfig `json:"securityPostureConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BinaryAuthorizationConfig")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BinaryAuthorizationConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DefaultClusterConfig) MarshalJSON() ([]byte, error) {
	type NoMethod DefaultClusterConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EdgeCluster: EdgeCluster contains information specific to Google Edge
// Clusters.
type EdgeCluster struct {
	// ResourceLink: Immutable. Self-link of the Google Cloud resource for the Edge
	// Cluster. For example:
	// //edgecontainer.googleapis.com/projects/my-project/locations/us-west1-a/clust
	// ers/my-cluster
	ResourceLink string `json:"resourceLink,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ResourceLink") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ResourceLink") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EdgeCluster) MarshalJSON() ([]byte, error) {
	type NoMethod EdgeCluster
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use it as
// the request or the response type of an API method. For instance: service Foo
// { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// ExcludedCluster: An excluded cluster from the rollout.
type ExcludedCluster struct {
	// Membership: Output only. The name of the fleet Membership resource
	// associated to the excluded cluster.
	Membership string `json:"membership,omitempty"`
	// Reason: Output only. The reason for excluding the cluster from the rollout.
	//
	// Possible values:
	//   "REASON_UNSPECIFIED" - Default value.
	//   "EXCLUDED_BY_FILTER" - The cluster was excluded by the rollout filter.
	//   "ALREADY_UPGRADED" - The cluster was already upgraded.
	//   "VERSION_TOO_OLD" - The cluster version is too old.
	Reason string `json:"reason,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Membership") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Membership") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExcludedCluster) MarshalJSON() ([]byte, error) {
	type NoMethod ExcludedCluster
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Expr: Represents a textual expression in the Common Expression Language
// (CEL) syntax. CEL is a C-like expression language. The syntax and semantics
// of CEL are documented at https://github.com/google/cel-spec. Example
// (Comparison): title: "Summary size limit" description: "Determines if a
// summary is less than 100 chars" expression: "document.summary.size() < 100"
// Example (Equality): title: "Requestor is owner" description: "Determines if
// requestor is the document owner" expression: "document.owner ==
// request.auth.claims.email" Example (Logic): title: "Public documents"
// description: "Determine whether the document should be publicly visible"
// expression: "document.type != 'private' && document.type != 'internal'"
// Example (Data Manipulation): title: "Notification string" description:
// "Create a notification string with a timestamp." expression: "'New message
// received at ' + string(document.create_time)" The exact variables and
// functions that may be referenced within an expression are determined by the
// service that evaluates it. See the service documentation for additional
// information.
type Expr struct {
	// Description: Optional. Description of the expression. This is a longer text
	// which describes the expression, e.g. when hovered over it in a UI.
	Description string `json:"description,omitempty"`
	// Expression: Textual representation of an expression in Common Expression
	// Language syntax.
	Expression string `json:"expression,omitempty"`
	// Location: Optional. String indicating the location of the expression for
	// error reporting, e.g. a file name and a position in the file.
	Location string `json:"location,omitempty"`
	// Title: Optional. Title for the expression, i.e. a short string describing
	// its purpose. This can be used e.g. in UIs which allow to enter the
	// expression.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Expr) MarshalJSON() ([]byte, error) {
	type NoMethod Expr
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Feature: Feature represents the settings and status of any Fleet Feature.
type Feature struct {
	// CreateTime: Output only. When the Feature resource was created.
	CreateTime string `json:"createTime,omitempty"`
	// DeleteTime: Output only. When the Feature resource was deleted.
	DeleteTime string `json:"deleteTime,omitempty"`
	// FleetDefaultMemberConfig: Optional. Feature configuration applicable to all
	// memberships of the fleet.
	FleetDefaultMemberConfig *CommonFleetDefaultMemberConfigSpec `json:"fleetDefaultMemberConfig,omitempty"`
	// Labels: Labels for this Feature.
	Labels map[string]string `json:"labels,omitempty"`
	// MembershipSpecs: Optional. Membership-specific configuration for this
	// Feature. If this Feature does not support any per-Membership configuration,
	// this field may be unused. The keys indicate which Membership the
	// configuration is for, in the form:
	// `projects/{p}/locations/{l}/memberships/{m}` Where {p} is the project, {l}
	// is a valid location and {m} is a valid Membership in this project at that
	// location. {p} WILL match the Feature's project. {p} will always be returned
	// as the project number, but the project ID is also accepted during input. If
	// the same Membership is specified in the map twice (using the project ID
	// form, and the project number form), exactly ONE of the entries will be
	// saved, with no guarantees as to which. For this reason, it is recommended
	// the same format be used for all entries when mutating a Feature.
	MembershipSpecs map[string]MembershipFeatureSpec `json:"membershipSpecs,omitempty"`
	// MembershipStates: Output only. Membership-specific Feature status. If this
	// Feature does report any per-Membership status, this field may be unused. The
	// keys indicate which Membership the state is for, in the form:
	// `projects/{p}/locations/{l}/memberships/{m}` Where {p} is the project
	// number, {l} is a valid location and {m} is a valid Membership in this
	// project at that location. {p} MUST match the Feature's project number.
	MembershipStates map[string]MembershipFeatureState `json:"membershipStates,omitempty"`
	// Name: Output only. The full, unique name of this Feature resource in the
	// format `projects/*/locations/*/features/*`.
	Name string `json:"name,omitempty"`
	// ResourceState: Output only. State of the Feature resource itself.
	ResourceState *FeatureResourceState `json:"resourceState,omitempty"`
	// ScopeSpecs: Optional. Scope-specific configuration for this Feature. If this
	// Feature does not support any per-Scope configuration, this field may be
	// unused. The keys indicate which Scope the configuration is for, in the form:
	// `projects/{p}/locations/global/scopes/{s}` Where {p} is the project, {s} is
	// a valid Scope in this project. {p} WILL match the Feature's project. {p}
	// will always be returned as the project number, but the project ID is also
	// accepted during input. If the same Scope is specified in the map twice
	// (using the project ID form, and the project number form), exactly ONE of the
	// entries will be saved, with no guarantees as to which. For this reason, it
	// is recommended the same format be used for all entries when mutating a
	// Feature.
	ScopeSpecs map[string]ScopeFeatureSpec `json:"scopeSpecs,omitempty"`
	// ScopeStates: Output only. Scope-specific Feature status. If this Feature
	// does report any per-Scope status, this field may be unused. The keys
	// indicate which Scope the state is for, in the form:
	// `projects/{p}/locations/global/scopes/{s}` Where {p} is the project, {s} is
	// a valid Scope in this project. {p} WILL match the Feature's project.
	ScopeStates map[string]ScopeFeatureState `json:"scopeStates,omitempty"`
	// Spec: Optional. Fleet-wide Feature configuration. If this Feature does not
	// support any Fleet-wide configuration, this field may be unused.
	Spec *CommonFeatureSpec `json:"spec,omitempty"`
	// State: Output only. The Fleet-wide Feature state.
	State *CommonFeatureState `json:"state,omitempty"`
	// Unreachable: Output only. List of locations that could not be reached while
	// fetching this feature.
	Unreachable []string `json:"unreachable,omitempty"`
	// UpdateTime: Output only. When the Feature resource was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Feature) MarshalJSON() ([]byte, error) {
	type NoMethod Feature
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FeatureResourceState: FeatureResourceState describes the state of a Feature
// *resource* in the GkeHub API. See `FeatureState` for the "running state" of
// the Feature in the Fleet and across Memberships.
type FeatureResourceState struct {
	// State: The current state of the Feature resource in the Hub API.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State is unknown or not set.
	//   "ENABLING" - The Feature is being enabled, and the Feature resource is
	// being created. Once complete, the corresponding Feature will be enabled in
	// this Fleet.
	//   "ACTIVE" - The Feature is enabled in this Fleet, and the Feature resource
	// is fully available.
	//   "DISABLING" - The Feature is being disabled in this Fleet, and the Feature
	// resource is being deleted.
	//   "UPDATING" - The Feature resource is being updated.
	//   "SERVICE_UPDATING" - The Feature resource is being updated by the Hub
	// Service.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "State") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "State") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FeatureResourceState) MarshalJSON() ([]byte, error) {
	type NoMethod FeatureResourceState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FeatureSpec: **Workload Certificate**: The Hub-wide input for the
// WorkloadCertificate feature.
type FeatureSpec struct {
	// DefaultConfig: Specifies default membership spec. Users can override the
	// default in the member_configs for each member.
	DefaultConfig *MembershipSpec `json:"defaultConfig,omitempty"`
	// ProvisionGoogleCa: Immutable. Specifies CA configuration.
	//
	// Possible values:
	//   "GOOGLE_CA_PROVISIONING_UNSPECIFIED" - Disable default Google managed CA.
	//   "DISABLED" - Disable default Google managed CA.
	//   "ENABLED" - Use default Google managed CA.
	//   "ENABLED_WITH_MANAGED_CA" - Workload certificate feature is enabled, and
	// the entire certificate provisioning process is managed by Google with
	// managed CAS which is more secure than the default CA.
	//   "ENABLED_WITH_DEFAULT_CA" - Workload certificate feature is enabled, and
	// the entire certificate provisioning process is using the default CA which is
	// free.
	ProvisionGoogleCa string `json:"provisionGoogleCa,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DefaultConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DefaultConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FeatureSpec) MarshalJSON() ([]byte, error) {
	type NoMethod FeatureSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FeatureState: FeatureState describes the high-level state of a Feature. It
// may be used to describe a Feature's state at the environ-level, or
// per-membershop, depending on the context.
type FeatureState struct {
	// Code: The high-level, machine-readable status of this Feature.
	//
	// Possible values:
	//   "CODE_UNSPECIFIED" - Unknown or not set.
	//   "OK" - The Feature is operating normally.
	//   "WARNING" - The Feature has encountered an issue, and is operating in a
	// degraded state. The Feature may need intervention to return to normal
	// operation. See the description and any associated Feature-specific details
	// for more information.
	//   "ERROR" - The Feature is not operating or is in a severely degraded state.
	// The Feature may need intervention to return to normal operation. See the
	// description and any associated Feature-specific details for more
	// information.
	Code string `json:"code,omitempty"`
	// Description: A human-readable description of the current status.
	Description string `json:"description,omitempty"`
	// UpdateTime: The time this status and any related Feature-specific details
	// were updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FeatureState) MarshalJSON() ([]byte, error) {
	type NoMethod FeatureState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FeatureUpdate: Feature config to use for Rollout.
type FeatureUpdate struct {
	// BinaryAuthorizationConfig: Optional. Configuration for Binary Authorization.
	BinaryAuthorizationConfig *BinaryAuthorizationConfig `json:"binaryAuthorizationConfig,omitempty"`
	// SecurityPostureConfig: Optional. Configuration for Security Posture.
	SecurityPostureConfig *SecurityPostureConfig `json:"securityPostureConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BinaryAuthorizationConfig")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BinaryAuthorizationConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FeatureUpdate) MarshalJSON() ([]byte, error) {
	type NoMethod FeatureUpdate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Fleet: Fleet contains the Fleet-wide metadata and configuration.
type Fleet struct {
	// CreateTime: Output only. When the Fleet was created.
	CreateTime string `json:"createTime,omitempty"`
	// DefaultClusterConfig: Optional. The default cluster configurations to apply
	// across the fleet.
	DefaultClusterConfig *DefaultClusterConfig `json:"defaultClusterConfig,omitempty"`
	// DeleteTime: Output only. When the Fleet was deleted.
	DeleteTime string `json:"deleteTime,omitempty"`
	// DisplayName: Optional. A user-assigned display name of the Fleet. When
	// present, it must be between 4 to 30 characters. Allowed characters are:
	// lowercase and uppercase letters, numbers, hyphen, single-quote,
	// double-quote, space, and exclamation point. Example: `Production Fleet`
	DisplayName string `json:"displayName,omitempty"`
	// Labels: Optional. Labels for this Fleet.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Output only. The full, unique resource name of this fleet in the
	// format of `projects/{project}/locations/{location}/fleets/{fleet}`. Each
	// Google Cloud project can have at most one fleet resource, named "default".
	Name string `json:"name,omitempty"`
	// State: Output only. State of the namespace resource.
	State *FleetLifecycleState `json:"state,omitempty"`
	// Uid: Output only. Google-generated UUID for this resource. This is unique
	// across all Fleet resources. If a Fleet resource is deleted and another
	// resource with the same name is created, it gets a different uid.
	Uid string `json:"uid,omitempty"`
	// UpdateTime: Output only. When the Fleet was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Fleet) MarshalJSON() ([]byte, error) {
	type NoMethod Fleet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FleetLifecycleState: FleetLifecycleState describes the state of a Fleet
// resource.
type FleetLifecycleState struct {
	// Code: Output only. The current state of the Fleet resource.
	//
	// Possible values:
	//   "CODE_UNSPECIFIED" - The code is not set.
	//   "CREATING" - The fleet is being created.
	//   "READY" - The fleet active.
	//   "DELETING" - The fleet is being deleted.
	//   "UPDATING" - The fleet is being updated.
	Code string `json:"code,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FleetLifecycleState) MarshalJSON() ([]byte, error) {
	type NoMethod FleetLifecycleState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FleetObservabilityFeatureError: All error details of the fleet observability
// feature.
type FleetObservabilityFeatureError struct {
	// Code: The code of the error.
	Code string `json:"code,omitempty"`
	// Description: A human-readable description of the current status.
	Description string `json:"description,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FleetObservabilityFeatureError) MarshalJSON() ([]byte, error) {
	type NoMethod FleetObservabilityFeatureError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FleetObservabilityFeatureSpec: **Fleet Observability**: The Hub-wide input
// for the FleetObservability feature.
type FleetObservabilityFeatureSpec struct {
	// LoggingConfig: Specified if fleet logging feature is enabled for the entire
	// fleet. If UNSPECIFIED, fleet logging feature is disabled for the entire
	// fleet.
	LoggingConfig *FleetObservabilityLoggingConfig `json:"loggingConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LoggingConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LoggingConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FleetObservabilityFeatureSpec) MarshalJSON() ([]byte, error) {
	type NoMethod FleetObservabilityFeatureSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FleetObservabilityFeatureState: **FleetObservability**: Hub-wide Feature for
// FleetObservability feature. state.
type FleetObservabilityFeatureState struct {
	// Logging: The feature state of default logging.
	Logging *FleetObservabilityFleetObservabilityLoggingState `json:"logging,omitempty"`
	// Monitoring: The feature state of fleet monitoring.
	Monitoring *FleetObservabilityFleetObservabilityMonitoringState `json:"monitoring,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Logging") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Logging") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FleetObservabilityFeatureState) MarshalJSON() ([]byte, error) {
	type NoMethod FleetObservabilityFeatureState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FleetObservabilityFleetObservabilityBaseFeatureState: Base state for fleet
// observability feature.
type FleetObservabilityFleetObservabilityBaseFeatureState struct {
	// Code: The high-level, machine-readable status of this Feature.
	//
	// Possible values:
	//   "CODE_UNSPECIFIED" - Unknown or not set.
	//   "OK" - The Feature is operating normally.
	//   "ERROR" - The Feature is encountering errors in the reconciliation. The
	// Feature may need intervention to return to normal operation. See the
	// description and any associated Feature-specific details for more
	// information.
	Code string `json:"code,omitempty"`
	// Errors: Errors after reconciling the monitoring and logging feature if the
	// code is not OK.
	Errors []*FleetObservabilityFeatureError `json:"errors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FleetObservabilityFleetObservabilityBaseFeatureState) MarshalJSON() ([]byte, error) {
	type NoMethod FleetObservabilityFleetObservabilityBaseFeatureState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FleetObservabilityFleetObservabilityLoggingState: Feature state for logging
// feature.
type FleetObservabilityFleetObservabilityLoggingState struct {
	// DefaultLog: The base feature state of fleet default log.
	DefaultLog *FleetObservabilityFleetObservabilityBaseFeatureState `json:"defaultLog,omitempty"`
	// ScopeLog: The base feature state of fleet scope log.
	ScopeLog *FleetObservabilityFleetObservabilityBaseFeatureState `json:"scopeLog,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DefaultLog") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DefaultLog") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FleetObservabilityFleetObservabilityLoggingState) MarshalJSON() ([]byte, error) {
	type NoMethod FleetObservabilityFleetObservabilityLoggingState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FleetObservabilityFleetObservabilityMonitoringState: Feature state for
// monitoring feature.
type FleetObservabilityFleetObservabilityMonitoringState struct {
	// State: The base feature state of fleet monitoring feature.
	State *FleetObservabilityFleetObservabilityBaseFeatureState `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "State") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "State") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FleetObservabilityFleetObservabilityMonitoringState) MarshalJSON() ([]byte, error) {
	type NoMethod FleetObservabilityFleetObservabilityMonitoringState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FleetObservabilityLoggingConfig: LoggingConfig defines the configuration for
// different types of logs.
type FleetObservabilityLoggingConfig struct {
	// DefaultConfig: Specified if applying the default routing config to logs not
	// specified in other configs.
	DefaultConfig *FleetObservabilityRoutingConfig `json:"defaultConfig,omitempty"`
	// FleetScopeLogsConfig: Specified if applying the routing config to all logs
	// for all fleet scopes.
	FleetScopeLogsConfig *FleetObservabilityRoutingConfig `json:"fleetScopeLogsConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DefaultConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DefaultConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FleetObservabilityLoggingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod FleetObservabilityLoggingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FleetObservabilityMembershipSpec: **FleetObservability**: The
// membership-specific input for FleetObservability feature.
type FleetObservabilityMembershipSpec struct {
}

// FleetObservabilityMembershipState: **FleetObservability**:
// Membership-specific Feature state for fleetobservability.
type FleetObservabilityMembershipState struct {
}

// FleetObservabilityRoutingConfig: RoutingConfig configures the behaviour of
// fleet logging feature.
type FleetObservabilityRoutingConfig struct {
	// Mode: mode configures the logs routing mode.
	//
	// Possible values:
	//   "MODE_UNSPECIFIED" - If UNSPECIFIED, fleet logging feature is disabled.
	//   "COPY" - logs will be copied to the destination project.
	//   "MOVE" - logs will be moved to the destination project.
	Mode string `json:"mode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Mode") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Mode") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FleetObservabilityRoutingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod FleetObservabilityRoutingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GenerateConnectManifestResponse: GenerateConnectManifestResponse contains
// manifest information for installing/upgrading a Connect agent.
type GenerateConnectManifestResponse struct {
	// Manifest: The ordered list of Kubernetes resources that need to be applied
	// to the cluster for GKE Connect agent installation/upgrade.
	Manifest []*ConnectAgentResource `json:"manifest,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Manifest") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Manifest") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GenerateConnectManifestResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GenerateConnectManifestResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GenerateExclusivityManifestResponse: The response of the exclusivity
// artifacts manifests for the client to apply.
type GenerateExclusivityManifestResponse struct {
	// CrManifest: The YAML manifest of the membership CR to apply if a new version
	// of the CR is available. Empty if no update needs to be applied.
	CrManifest string `json:"crManifest,omitempty"`
	// CrdManifest: The YAML manifest of the membership CRD to apply if a newer
	// version of the CRD is available. Empty if no update needs to be applied.
	CrdManifest string `json:"crdManifest,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CrManifest") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CrManifest") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GenerateExclusivityManifestResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GenerateExclusivityManifestResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GenerateMembershipRBACRoleBindingYAMLResponse: Response for
// GenerateRBACRoleBindingYAML.
type GenerateMembershipRBACRoleBindingYAMLResponse struct {
	// RoleBindingsYaml: a yaml text blob including the RBAC policies.
	RoleBindingsYaml string `json:"roleBindingsYaml,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "RoleBindingsYaml") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RoleBindingsYaml") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GenerateMembershipRBACRoleBindingYAMLResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GenerateMembershipRBACRoleBindingYAMLResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GkeCluster: GkeCluster contains information specific to GKE clusters.
type GkeCluster struct {
	// ClusterMissing: Output only. If cluster_missing is set then it denotes that
	// the GKE cluster no longer exists in the GKE Control Plane.
	ClusterMissing bool `json:"clusterMissing,omitempty"`
	// ResourceLink: Immutable. Self-link of the Google Cloud resource for the GKE
	// cluster. For example:
	// //container.googleapis.com/projects/my-project/locations/us-west1-a/clusters/
	// my-cluster Zonal clusters are also supported.
	ResourceLink string `json:"resourceLink,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClusterMissing") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClusterMissing") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GkeCluster) MarshalJSON() ([]byte, error) {
	type NoMethod GkeCluster
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleRpcStatus: The `Status` type defines a logical error model that is
// suitable for different programming environments, including REST APIs and RPC
// APIs. It is used by gRPC (https://github.com/grpc). Each `Status` message
// contains three pieces of data: error code, error message, and error details.
// You can find out more about this error model and how to work with it in the
// API Design Guide (https://cloud.google.com/apis/design/errors).
type GoogleRpcStatus struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleRpcStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleRpcStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IdentityServiceAuthMethod: Configuration of an auth method for a
// member/cluster. Only one authentication method (e.g., OIDC and LDAP) can be
// set per AuthMethod.
type IdentityServiceAuthMethod struct {
	// AzureadConfig: AzureAD specific Configuration.
	AzureadConfig *IdentityServiceAzureADConfig `json:"azureadConfig,omitempty"`
	// GoogleConfig: GoogleConfig specific configuration.
	GoogleConfig *IdentityServiceGoogleConfig `json:"googleConfig,omitempty"`
	// LdapConfig: LDAP specific configuration.
	LdapConfig *IdentityServiceLdapConfig `json:"ldapConfig,omitempty"`
	// Name: Identifier for auth config.
	Name string `json:"name,omitempty"`
	// OidcConfig: OIDC specific configuration.
	OidcConfig *IdentityServiceOidcConfig `json:"oidcConfig,omitempty"`
	// Proxy: Proxy server address to use for auth method.
	Proxy string `json:"proxy,omitempty"`
	// SamlConfig: SAML specific configuration.
	SamlConfig *IdentityServiceSamlConfig `json:"samlConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AzureadConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AzureadConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IdentityServiceAuthMethod) MarshalJSON() ([]byte, error) {
	type NoMethod IdentityServiceAuthMethod
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IdentityServiceAzureADConfig: Configuration for the AzureAD Auth flow.
type IdentityServiceAzureADConfig struct {
	// ClientId: ID for the registered client application that makes authentication
	// requests to the Azure AD identity provider.
	ClientId string `json:"clientId,omitempty"`
	// ClientSecret: Input only. Unencrypted AzureAD client secret will be passed
	// to the GKE Hub CLH.
	ClientSecret string `json:"clientSecret,omitempty"`
	// EncryptedClientSecret: Output only. Encrypted AzureAD client secret.
	EncryptedClientSecret string `json:"encryptedClientSecret,omitempty"`
	// GroupFormat: Optional. Format of the AzureAD groups that the client wants
	// for auth.
	GroupFormat string `json:"groupFormat,omitempty"`
	// KubectlRedirectUri: The redirect URL that kubectl uses for authorization.
	KubectlRedirectUri string `json:"kubectlRedirectUri,omitempty"`
	// Tenant: Kind of Azure AD account to be authenticated. Supported values are
	// or for accounts belonging to a specific tenant.
	Tenant string `json:"tenant,omitempty"`
	// UserClaim: Optional. Claim in the AzureAD ID Token that holds the user
	// details.
	UserClaim string `json:"userClaim,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClientId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClientId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IdentityServiceAzureADConfig) MarshalJSON() ([]byte, error) {
	type NoMethod IdentityServiceAzureADConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IdentityServiceDiagnosticInterface: Configuration options for the AIS
// diagnostic interface.
type IdentityServiceDiagnosticInterface struct {
	// Enabled: Determines whether to enable the diagnostic interface.
	Enabled bool `json:"enabled,omitempty"`
	// ExpirationTime: Determines the expiration time of the diagnostic interface
	// enablement. When reached, requests to the interface would be automatically
	// rejected.
	ExpirationTime string `json:"expirationTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IdentityServiceDiagnosticInterface) MarshalJSON() ([]byte, error) {
	type NoMethod IdentityServiceDiagnosticInterface
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IdentityServiceGoogleConfig: Configuration for the Google Plugin Auth flow.
type IdentityServiceGoogleConfig struct {
	// Disable: Disable automatic configuration of Google Plugin on supported
	// platforms.
	Disable bool `json:"disable,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Disable") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Disable") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IdentityServiceGoogleConfig) MarshalJSON() ([]byte, error) {
	type NoMethod IdentityServiceGoogleConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IdentityServiceGroupConfig: Contains the properties for locating and
// authenticating groups in the directory.
type IdentityServiceGroupConfig struct {
	// BaseDn: Required. The location of the subtree in the LDAP directory to
	// search for group entries.
	BaseDn string `json:"baseDn,omitempty"`
	// Filter: Optional. Optional filter to be used when searching for groups a
	// user belongs to. This can be used to explicitly match only certain groups in
	// order to reduce the amount of groups returned for each user. This defaults
	// to "(objectClass=Group)".
	Filter string `json:"filter,omitempty"`
	// IdAttribute: Optional. The identifying name of each group a user belongs to.
	// For example, if this is set to "distinguishedName" then RBACs and other
	// group expectations should be written as full DNs. This defaults to
	// "distinguishedName".
	IdAttribute string `json:"idAttribute,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BaseDn") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BaseDn") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IdentityServiceGroupConfig) MarshalJSON() ([]byte, error) {
	type NoMethod IdentityServiceGroupConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IdentityServiceIdentityServiceOptions: Holds non-protocol-related
// configuration options.
type IdentityServiceIdentityServiceOptions struct {
	// DiagnosticInterface: Configuration options for the AIS diagnostic interface.
	DiagnosticInterface *IdentityServiceDiagnosticInterface `json:"diagnosticInterface,omitempty"`
	// SessionDuration: Determines the lifespan of STS tokens issued by Anthos
	// Identity Service.
	SessionDuration string `json:"sessionDuration,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DiagnosticInterface") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DiagnosticInterface") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IdentityServiceIdentityServiceOptions) MarshalJSON() ([]byte, error) {
	type NoMethod IdentityServiceIdentityServiceOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IdentityServiceLdapConfig: Configuration for the LDAP Auth flow.
type IdentityServiceLdapConfig struct {
	// Group: Optional. Contains the properties for locating and authenticating
	// groups in the directory.
	Group *IdentityServiceGroupConfig `json:"group,omitempty"`
	// Server: Required. Server settings for the external LDAP server.
	Server *IdentityServiceServerConfig `json:"server,omitempty"`
	// ServiceAccount: Required. Contains the credentials of the service account
	// which is authorized to perform the LDAP search in the directory. The
	// credentials can be supplied by the combination of the DN and password or the
	// client certificate.
	ServiceAccount *IdentityServiceServiceAccountConfig `json:"serviceAccount,omitempty"`
	// User: Required. Defines where users exist in the LDAP directory.
	User *IdentityServiceUserConfig `json:"user,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Group") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Group") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IdentityServiceLdapConfig) MarshalJSON() ([]byte, error) {
	type NoMethod IdentityServiceLdapConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IdentityServiceMembershipSpec: **Anthos Identity Service**: Configuration
// for a single Membership.
type IdentityServiceMembershipSpec struct {
	// AuthMethods: A member may support multiple auth methods.
	AuthMethods []*IdentityServiceAuthMethod `json:"authMethods,omitempty"`
	// IdentityServiceOptions: Optional. non-protocol-related configuration
	// options.
	IdentityServiceOptions *IdentityServiceIdentityServiceOptions `json:"identityServiceOptions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AuthMethods") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuthMethods") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IdentityServiceMembershipSpec) MarshalJSON() ([]byte, error) {
	type NoMethod IdentityServiceMembershipSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IdentityServiceMembershipState: **Anthos Identity Service**: State for a
// single Membership.
type IdentityServiceMembershipState struct {
	// FailureReason: The reason of the failure.
	FailureReason string `json:"failureReason,omitempty"`
	// InstalledVersion: Installed AIS version. This is the AIS version installed
	// on this member. The values makes sense iff state is OK.
	InstalledVersion string `json:"installedVersion,omitempty"`
	// MemberConfig: Last reconciled membership configuration
	MemberConfig *IdentityServiceMembershipSpec `json:"memberConfig,omitempty"`
	// State: Deployment state on this member
	//
	// Possible values:
	//   "DEPLOYMENT_STATE_UNSPECIFIED" - Unspecified state
	//   "OK" - deployment succeeds
	//   "ERROR" - Failure with error.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FailureReason") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FailureReason") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IdentityServiceMembershipState) MarshalJSON() ([]byte, error) {
	type NoMethod IdentityServiceMembershipState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IdentityServiceOidcConfig: Configuration for OIDC Auth flow.
type IdentityServiceOidcConfig struct {
	// CertificateAuthorityData: PEM-encoded CA for OIDC provider.
	CertificateAuthorityData string `json:"certificateAuthorityData,omitempty"`
	// ClientId: ID for OIDC client application.
	ClientId string `json:"clientId,omitempty"`
	// ClientSecret: Input only. Unencrypted OIDC client secret will be passed to
	// the GKE Hub CLH.
	ClientSecret string `json:"clientSecret,omitempty"`
	// DeployCloudConsoleProxy: Flag to denote if reverse proxy is used to connect
	// to auth provider. This flag should be set to true when provider is not
	// reachable by Google Cloud Console.
	DeployCloudConsoleProxy bool `json:"deployCloudConsoleProxy,omitempty"`
	// EnableAccessToken: Enable access token.
	EnableAccessToken bool `json:"enableAccessToken,omitempty"`
	// EncryptedClientSecret: Output only. Encrypted OIDC Client secret
	EncryptedClientSecret string `json:"encryptedClientSecret,omitempty"`
	// ExtraParams: Comma-separated list of key-value pairs.
	ExtraParams string `json:"extraParams,omitempty"`
	// GroupPrefix: Prefix to prepend to group name.
	GroupPrefix string `json:"groupPrefix,omitempty"`
	// GroupsClaim: Claim in OIDC ID token that holds group information.
	GroupsClaim string `json:"groupsClaim,omitempty"`
	// IssuerUri: URI for the OIDC provider. This should point to the level below
	// .well-known/openid-configuration.
	IssuerUri string `json:"issuerUri,omitempty"`
	// KubectlRedirectUri: Registered redirect uri to redirect users going through
	// OAuth flow using kubectl plugin.
	KubectlRedirectUri string `json:"kubectlRedirectUri,omitempty"`
	// Scopes: Comma-separated list of identifiers.
	Scopes string `json:"scopes,omitempty"`
	// UserClaim: Claim in OIDC ID token that holds username.
	UserClaim string `json:"userClaim,omitempty"`
	// UserPrefix: Prefix to prepend to user name.
	UserPrefix string `json:"userPrefix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CertificateAuthorityData")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CertificateAuthorityData") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IdentityServiceOidcConfig) MarshalJSON() ([]byte, error) {
	type NoMethod IdentityServiceOidcConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IdentityServiceSamlConfig: Configuration for the SAML Auth flow.
type IdentityServiceSamlConfig struct {
	// AttributeMapping: Optional. The mapping of additional user attributes like
	// nickname, birthday and address etc.. `key` is the name of this additional
	// attribute. `value` is a string presenting as CEL(common expression language,
	// go/cel) used for getting the value from the resources. Take nickname as an
	// example, in this case, `key` is "attribute.nickname" and `value` is
	// "assertion.nickname".
	AttributeMapping map[string]string `json:"attributeMapping,omitempty"`
	// GroupPrefix: Optional. Prefix to prepend to group name.
	GroupPrefix string `json:"groupPrefix,omitempty"`
	// GroupsAttribute: Optional. The SAML attribute to read groups from. This
	// value is expected to be a string and will be passed along as-is (with the
	// option of being prefixed by the `group_prefix`).
	GroupsAttribute string `json:"groupsAttribute,omitempty"`
	// IdentityProviderCertificates: Required. The list of IdP certificates to
	// validate the SAML response against.
	IdentityProviderCertificates []string `json:"identityProviderCertificates,omitempty"`
	// IdentityProviderId: Required. The entity ID of the SAML IdP.
	IdentityProviderId string `json:"identityProviderId,omitempty"`
	// IdentityProviderSsoUri: Required. The URI where the SAML IdP exposes the SSO
	// service.
	IdentityProviderSsoUri string `json:"identityProviderSsoUri,omitempty"`
	// UserAttribute: Optional. The SAML attribute to read username from. If
	// unspecified, the username will be read from the NameID element of the
	// assertion in SAML response. This value is expected to be a string and will
	// be passed along as-is (with the option of being prefixed by the
	// `user_prefix`).
	UserAttribute string `json:"userAttribute,omitempty"`
	// UserPrefix: Optional. Prefix to prepend to user name.
	UserPrefix string `json:"userPrefix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AttributeMapping") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttributeMapping") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IdentityServiceSamlConfig) MarshalJSON() ([]byte, error) {
	type NoMethod IdentityServiceSamlConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IdentityServiceServerConfig: Server settings for the external LDAP server.
type IdentityServiceServerConfig struct {
	// CertificateAuthorityData: Optional. Contains a Base64 encoded, PEM formatted
	// certificate authority certificate for the LDAP server. This must be provided
	// for the "ldaps" and "startTLS" connections.
	CertificateAuthorityData string `json:"certificateAuthorityData,omitempty"`
	// ConnectionType: Optional. Defines the connection type to communicate with
	// the LDAP server. If `starttls` or `ldaps` is specified, the
	// certificate_authority_data should not be empty.
	ConnectionType string `json:"connectionType,omitempty"`
	// Host: Required. Defines the hostname or IP of the LDAP server. Port is
	// optional and will default to 389, if unspecified. For example,
	// "ldap.server.example" or "10.10.10.10:389".
	Host string `json:"host,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CertificateAuthorityData")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CertificateAuthorityData") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IdentityServiceServerConfig) MarshalJSON() ([]byte, error) {
	type NoMethod IdentityServiceServerConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IdentityServiceServiceAccountConfig: Contains the credentials of the service
// account which is authorized to perform the LDAP search in the directory. The
// credentials can be supplied by the combination of the DN and password or the
// client certificate.
type IdentityServiceServiceAccountConfig struct {
	// SimpleBindCredentials: Credentials for basic auth.
	SimpleBindCredentials *IdentityServiceSimpleBindCredentials `json:"simpleBindCredentials,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SimpleBindCredentials") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SimpleBindCredentials") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IdentityServiceServiceAccountConfig) MarshalJSON() ([]byte, error) {
	type NoMethod IdentityServiceServiceAccountConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IdentityServiceSimpleBindCredentials: The structure holds the LDAP simple
// binding credential.
type IdentityServiceSimpleBindCredentials struct {
	// Dn: Required. The distinguished name(DN) of the service account object/user.
	Dn string `json:"dn,omitempty"`
	// EncryptedPassword: Output only. The encrypted password of the service
	// account object/user.
	EncryptedPassword string `json:"encryptedPassword,omitempty"`
	// Password: Required. Input only. The password of the service account
	// object/user.
	Password string `json:"password,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dn") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dn") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IdentityServiceSimpleBindCredentials) MarshalJSON() ([]byte, error) {
	type NoMethod IdentityServiceSimpleBindCredentials
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IdentityServiceUserConfig: Defines where users exist in the LDAP directory.
type IdentityServiceUserConfig struct {
	// BaseDn: Required. The location of the subtree in the LDAP directory to
	// search for user entries.
	BaseDn string `json:"baseDn,omitempty"`
	// Filter: Optional. Filter to apply when searching for the user. This can be
	// used to further restrict the user accounts which are allowed to login. This
	// defaults to "(objectClass=User)".
	Filter string `json:"filter,omitempty"`
	// IdAttribute: Optional. Determines which attribute to use as the user's
	// identity after they are authenticated. This is distinct from the
	// loginAttribute field to allow users to login with a username, but then have
	// their actual identifier be an email address or full Distinguished Name (DN).
	// For example, setting loginAttribute to "sAMAccountName" and
	// identifierAttribute to "userPrincipalName" would allow a user to login as
	// "bsmith", but actual RBAC policies for the user would be written as
	// "bsmith@example.com". Using "userPrincipalName" is recommended since this
	// will be unique for each user. This defaults to "userPrincipalName".
	IdAttribute string `json:"idAttribute,omitempty"`
	// LoginAttribute: Optional. The name of the attribute which matches against
	// the input username. This is used to find the user in the LDAP database e.g.
	// "(=)" and is combined with the optional filter field. This defaults to
	// "userPrincipalName".
	LoginAttribute string `json:"loginAttribute,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BaseDn") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BaseDn") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IdentityServiceUserConfig) MarshalJSON() ([]byte, error) {
	type NoMethod IdentityServiceUserConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// KubernetesMetadata: KubernetesMetadata provides informational metadata for
// Memberships representing Kubernetes clusters.
type KubernetesMetadata struct {
	// KubernetesApiServerVersion: Output only. Kubernetes API server version
	// string as reported by `/version`.
	KubernetesApiServerVersion string `json:"kubernetesApiServerVersion,omitempty"`
	// MemoryMb: Output only. The total memory capacity as reported by the sum of
	// all Kubernetes nodes resources, defined in MB.
	MemoryMb int64 `json:"memoryMb,omitempty"`
	// NodeCount: Output only. Node count as reported by Kubernetes nodes
	// resources.
	NodeCount int64 `json:"nodeCount,omitempty"`
	// NodeProviderId: Output only. Node providerID as reported by the first node
	// in the list of nodes on the Kubernetes endpoint. On Kubernetes platforms
	// that support zero-node clusters (like GKE-on-GCP), the node_count will be
	// zero and the node_provider_id will be empty.
	NodeProviderId string `json:"nodeProviderId,omitempty"`
	// UpdateTime: Output only. The time at which these details were last updated.
	// This update_time is different from the Membership-level update_time since
	// EndpointDetails are updated internally for API consumers.
	UpdateTime string `json:"updateTime,omitempty"`
	// VcpuCount: Output only. vCPU count as reported by Kubernetes nodes
	// resources.
	VcpuCount int64 `json:"vcpuCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "KubernetesApiServerVersion")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "KubernetesApiServerVersion") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s KubernetesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod KubernetesMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// KubernetesResource: KubernetesResource contains the YAML manifests and
// configuration for Membership Kubernetes resources in the cluster. After
// CreateMembership or UpdateMembership, these resources should be re-applied
// in the cluster.
type KubernetesResource struct {
	// ConnectResources: Output only. The Kubernetes resources for installing the
	// GKE Connect agent This field is only populated in the Membership returned
	// from a successful long-running operation from CreateMembership or
	// UpdateMembership. It is not populated during normal GetMembership or
	// ListMemberships requests. To get the resource manifest after the initial
	// registration, the caller should make a UpdateMembership call with an empty
	// field mask.
	ConnectResources []*ResourceManifest `json:"connectResources,omitempty"`
	// MembershipCrManifest: Input only. The YAML representation of the Membership
	// CR. This field is ignored for GKE clusters where Hub can read the CR
	// directly. Callers should provide the CR that is currently present in the
	// cluster during CreateMembership or UpdateMembership, or leave this field
	// empty if none exists. The CR manifest is used to validate the cluster has
	// not been registered with another Membership.
	MembershipCrManifest string `json:"membershipCrManifest,omitempty"`
	// MembershipResources: Output only. Additional Kubernetes resources that need
	// to be applied to the cluster after Membership creation, and after every
	// update. This field is only populated in the Membership returned from a
	// successful long-running operation from CreateMembership or UpdateMembership.
	// It is not populated during normal GetMembership or ListMemberships requests.
	// To get the resource manifest after the initial registration, the caller
	// should make a UpdateMembership call with an empty field mask.
	MembershipResources []*ResourceManifest `json:"membershipResources,omitempty"`
	// ResourceOptions: Optional. Options for Kubernetes resource generation.
	ResourceOptions *ResourceOptions `json:"resourceOptions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConnectResources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConnectResources") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s KubernetesResource) MarshalJSON() ([]byte, error) {
	type NoMethod KubernetesResource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListAdminClusterMembershipsResponse: Response message for the
// `GkeHub.ListAdminClusterMemberships` method.
type ListAdminClusterMembershipsResponse struct {
	// AdminClusterMemberships: The list of matching Memberships of admin clusters.
	AdminClusterMemberships []*Membership `json:"adminClusterMemberships,omitempty"`
	// NextPageToken: A token to request the next page of resources from the
	// `ListAdminClusterMemberships` method. The value of an empty string means
	// that there are no more resources to return.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: List of locations that could not be reached while fetching this
	// list.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AdminClusterMemberships") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdminClusterMemberships") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListAdminClusterMembershipsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAdminClusterMembershipsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListBoundMembershipsResponse: List of Memberships bound to a Scope.
type ListBoundMembershipsResponse struct {
	// Memberships: The list of Memberships bound to the given Scope.
	Memberships []*Membership `json:"memberships,omitempty"`
	// NextPageToken: A token to request the next page of resources from the
	// `ListBoundMemberships` method. The value of an empty string means that there
	// are no more resources to return.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: List of locations that could not be reached while fetching this
	// list.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Memberships") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Memberships") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListBoundMembershipsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListBoundMembershipsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListFeaturesResponse: Response message for the `GkeHub.ListFeatures` method.
type ListFeaturesResponse struct {
	// NextPageToken: A token to request the next page of resources from the
	// `ListFeatures` method. The value of an empty string means that there are no
	// more resources to return.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Resources: The list of matching Features
	Resources []*Feature `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListFeaturesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListFeaturesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListFleetsResponse: Response message for the `GkeHub.ListFleetsResponse`
// method.
type ListFleetsResponse struct {
	// Fleets: The list of matching fleets.
	Fleets []*Fleet `json:"fleets,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages. The
	// token is only valid for 1h.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Fleets") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Fleets") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListFleetsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListFleetsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListLocationsResponse: The response message for Locations.ListLocations.
type ListLocationsResponse struct {
	// Locations: A list of locations that matches the specified filter in the
	// request.
	Locations []*Location `json:"locations,omitempty"`
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Locations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Locations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListLocationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListLocationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListMembershipBindingsResponse: List of MembershipBindings.
type ListMembershipBindingsResponse struct {
	// MembershipBindings: The list of membership_bindings
	MembershipBindings []*MembershipBinding `json:"membershipBindings,omitempty"`
	// NextPageToken: A token to request the next page of resources from the
	// `ListMembershipBindings` method. The value of an empty string means that
	// there are no more resources to return.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: List of locations that could not be reached while fetching this
	// list.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "MembershipBindings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MembershipBindings") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListMembershipBindingsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListMembershipBindingsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListMembershipRBACRoleBindingsResponse: List of Membership RBACRoleBindings.
type ListMembershipRBACRoleBindingsResponse struct {
	// NextPageToken: A token to request the next page of resources from the
	// `ListMembershipRBACRoleBindings` method. The value of an empty string means
	// that there are no more resources to return.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Rbacrolebindings: The list of Membership RBACRoleBindings.
	Rbacrolebindings []*RBACRoleBinding `json:"rbacrolebindings,omitempty"`
	// Unreachable: List of locations that could not be reached while fetching this
	// list.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListMembershipRBACRoleBindingsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListMembershipRBACRoleBindingsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListMembershipsResponse: Response message for the `GkeHub.ListMemberships`
// method.
type ListMembershipsResponse struct {
	// NextPageToken: A token to request the next page of resources from the
	// `ListMemberships` method. The value of an empty string means that there are
	// no more resources to return.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Resources: The list of matching Memberships.
	Resources []*Membership `json:"resources,omitempty"`
	// Unreachable: List of locations that could not be reached while fetching this
	// list.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListMembershipsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListMembershipsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListOperationsResponse: The response message for Operations.ListOperations.
type ListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Operations: A list of operations that matches the specified filter in the
	// request.
	Operations []*Operation `json:"operations,omitempty"`
	// Unreachable: Unordered list. Unreachable resources. Populated when the
	// request sets `ListOperationsRequest.return_partial_success` and reads across
	// collections. For example, when attempting to list all resources across all
	// supported locations.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListOperationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListPermittedScopesResponse: List of permitted Scopes.
type ListPermittedScopesResponse struct {
	// NextPageToken: A token to request the next page of resources from the
	// `ListPermittedScopes` method. The value of an empty string means that there
	// are no more resources to return.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Scopes: The list of permitted Scopes
	Scopes []*Scope `json:"scopes,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListPermittedScopesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListPermittedScopesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListRolloutSequencesResponse: Response message for listing rollout
// sequences.
type ListRolloutSequencesResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// RolloutSequences: The rollout sequences from the specified parent resource.
	RolloutSequences []*RolloutSequence `json:"rolloutSequences,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListRolloutSequencesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListRolloutSequencesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListRolloutsResponse: Response message for listing rollouts.
type ListRolloutsResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Rollouts: The rollouts from the specified parent resource.
	Rollouts []*Rollout `json:"rollouts,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListRolloutsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListRolloutsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListScopeNamespacesResponse: List of fleet namespaces.
type ListScopeNamespacesResponse struct {
	// NextPageToken: A token to request the next page of resources from the
	// `ListNamespaces` method. The value of an empty string means that there are
	// no more resources to return.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// ScopeNamespaces: The list of fleet namespaces
	ScopeNamespaces []*Namespace `json:"scopeNamespaces,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListScopeNamespacesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListScopeNamespacesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListScopeRBACRoleBindingsResponse: List of Scope RBACRoleBindings.
type ListScopeRBACRoleBindingsResponse struct {
	// NextPageToken: A token to request the next page of resources from the
	// `ListScopeRBACRoleBindings` method. The value of an empty string means that
	// there are no more resources to return.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Rbacrolebindings: The list of Scope RBACRoleBindings.
	Rbacrolebindings []*RBACRoleBinding `json:"rbacrolebindings,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListScopeRBACRoleBindingsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListScopeRBACRoleBindingsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListScopesResponse: List of Scopes.
type ListScopesResponse struct {
	// NextPageToken: A token to request the next page of resources from the
	// `ListScopes` method. The value of an empty string means that there are no
	// more resources to return.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Scopes: The list of Scopes
	Scopes []*Scope `json:"scopes,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListScopesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListScopesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Location: A resource that represents a Google Cloud location.
type Location struct {
	// DisplayName: The friendly name for this location, typically a nearby city
	// name. For example, "Tokyo".
	DisplayName string `json:"displayName,omitempty"`
	// Labels: Cross-service attributes for the location. For example
	// {"cloud.googleapis.com/region": "us-east1"}
	Labels map[string]string `json:"labels,omitempty"`
	// LocationId: The canonical id for this location. For example: "us-east1".
	LocationId string `json:"locationId,omitempty"`
	// Metadata: Service-specific metadata. For example the available capacity at
	// the given location.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: Resource name for the location, which may vary between
	// implementations. For example:
	// "projects/example-project/locations/us-east1"
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Location) MarshalJSON() ([]byte, error) {
	type NoMethod Location
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Membership: Membership contains information about a member cluster.
type Membership struct {
	// Authority: Optional. How to identify workloads from this Membership. See the
	// documentation on Workload Identity for more details:
	// https://cloud.google.com/kubernetes-engine/docs/how-to/workload-identity
	Authority *Authority `json:"authority,omitempty"`
	// ClusterTier: Output only. The tier of the cluster.
	//
	// Possible values:
	//   "CLUSTER_TIER_UNSPECIFIED" - The ClusterTier is not set.
	//   "STANDARD" - The ClusterTier is standard.
	//   "ENTERPRISE" - The ClusterTier is enterprise.
	ClusterTier string `json:"clusterTier,omitempty"`
	// CreateTime: Output only. When the Membership was created.
	CreateTime string `json:"createTime,omitempty"`
	// DeleteTime: Output only. When the Membership was deleted.
	DeleteTime string `json:"deleteTime,omitempty"`
	// Description: Output only. Description of this membership, limited to 63
	// characters. Must match the regex: `a-zA-Z0-9*` This field is present for
	// legacy purposes.
	Description string `json:"description,omitempty"`
	// Endpoint: Optional. Endpoint information to reach this member.
	Endpoint *MembershipEndpoint `json:"endpoint,omitempty"`
	// ExternalId: Optional. An externally-generated and managed ID for this
	// Membership. This ID may be modified after creation, but this is not
	// recommended. The ID must match the regex: `a-zA-Z0-9*` If this Membership
	// represents a Kubernetes cluster, this value should be set to the UID of the
	// `kube-system` namespace object.
	ExternalId string `json:"externalId,omitempty"`
	// Labels: Optional. Labels for this membership. These labels are not leveraged
	// by multi-cluster features, instead, we prefer cluster labels, which can be
	// set on GKE cluster or other cluster types.
	Labels map[string]string `json:"labels,omitempty"`
	// LastConnectionTime: Output only. For clusters using Connect, the timestamp
	// of the most recent connection established with Google Cloud. This time is
	// updated every several minutes, not continuously. For clusters that do not
	// use GKE Connect, or that have never connected successfully, this field will
	// be unset.
	LastConnectionTime string `json:"lastConnectionTime,omitempty"`
	// MembershipType: Output only. The type of the membership.
	//
	// Possible values:
	//   "MEMBERSHIP_TYPE_UNSPECIFIED" - The MembershipType is not set.
	//   "LIGHTWEIGHT" - The membership supports only lightweight compatible
	// features.
	MembershipType string `json:"membershipType,omitempty"`
	// MonitoringConfig: Optional. The monitoring config information for this
	// membership.
	MonitoringConfig *MonitoringConfig `json:"monitoringConfig,omitempty"`
	// Name: Output only. The full, unique name of this Membership resource in the
	// format `projects/*/locations/*/memberships/{membership_id}`, set during
	// creation. `membership_id` must be a valid RFC 1123 compliant DNS label: 1.
	// At most 63 characters in length 2. It must consist of lower case
	// alphanumeric characters or `-` 3. It must start and end with an alphanumeric
	// character Which can be expressed as the regex:
	// `[a-z0-9]([-a-z0-9]*[a-z0-9])?`, with a maximum length of 63 characters.
	Name string `json:"name,omitempty"`
	// State: Output only. State of the Membership resource.
	State *MembershipState `json:"state,omitempty"`
	// UniqueId: Output only. Google-generated UUID for this resource. This is
	// unique across all Membership resources. If a Membership resource is deleted
	// and another resource with the same name is created, it gets a different
	// unique_id.
	UniqueId string `json:"uniqueId,omitempty"`
	// UpdateTime: Output only. When the Membership was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Authority") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Authority") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Membership) MarshalJSON() ([]byte, error) {
	type NoMethod Membership
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MembershipBinding: MembershipBinding is a subresource of a Membership,
// representing what Fleet Scopes (or other, future Fleet resources) a
// Membership is bound to.
type MembershipBinding struct {
	// CreateTime: Output only. When the membership binding was created.
	CreateTime string `json:"createTime,omitempty"`
	// DeleteTime: Output only. When the membership binding was deleted.
	DeleteTime string `json:"deleteTime,omitempty"`
	// Labels: Optional. Labels for this MembershipBinding.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: The resource name for the membershipbinding itself
	// `projects/{project}/locations/{location}/memberships/{membership}/bindings/{m
	// embershipbinding}`
	Name string `json:"name,omitempty"`
	// Scope: A Scope resource name in the format
	// `projects/*/locations/*/scopes/*`.
	Scope string `json:"scope,omitempty"`
	// State: Output only. State of the membership binding resource.
	State *MembershipBindingLifecycleState `json:"state,omitempty"`
	// Uid: Output only. Google-generated UUID for this resource. This is unique
	// across all membershipbinding resources. If a membershipbinding resource is
	// deleted and another resource with the same name is created, it gets a
	// different uid.
	Uid string `json:"uid,omitempty"`
	// UpdateTime: Output only. When the membership binding was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MembershipBinding) MarshalJSON() ([]byte, error) {
	type NoMethod MembershipBinding
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MembershipBindingLifecycleState: MembershipBindingLifecycleState describes
// the state of a Binding resource.
type MembershipBindingLifecycleState struct {
	// Code: Output only. The current state of the MembershipBinding resource.
	//
	// Possible values:
	//   "CODE_UNSPECIFIED" - The code is not set.
	//   "CREATING" - The membershipbinding is being created.
	//   "READY" - The membershipbinding active.
	//   "DELETING" - The membershipbinding is being deleted.
	//   "UPDATING" - The membershipbinding is being updated.
	Code string `json:"code,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MembershipBindingLifecycleState) MarshalJSON() ([]byte, error) {
	type NoMethod MembershipBindingLifecycleState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MembershipEndpoint: MembershipEndpoint contains information needed to
// contact a Kubernetes API, endpoint and any additional Kubernetes metadata.
type MembershipEndpoint struct {
	// ApplianceCluster: Optional. Specific information for a GDC Edge Appliance
	// cluster.
	ApplianceCluster *ApplianceCluster `json:"applianceCluster,omitempty"`
	// EdgeCluster: Optional. Specific information for a Google Edge cluster.
	EdgeCluster *EdgeCluster `json:"edgeCluster,omitempty"`
	// GkeCluster: Optional. Specific information for a GKE-on-GCP cluster.
	GkeCluster *GkeCluster `json:"gkeCluster,omitempty"`
	// GoogleManaged: Output only. Whether the lifecycle of this membership is
	// managed by a google cluster platform service.
	GoogleManaged bool `json:"googleManaged,omitempty"`
	// KubernetesMetadata: Output only. Useful Kubernetes-specific metadata.
	KubernetesMetadata *KubernetesMetadata `json:"kubernetesMetadata,omitempty"`
	// KubernetesResource: Optional. The in-cluster Kubernetes Resources that
	// should be applied for a correctly registered cluster, in the steady state.
	// These resources: * Ensure that the cluster is exclusively registered to one
	// and only one Hub Membership. * Propagate Workload Pool Information available
	// in the Membership Authority field. * Ensure proper initial configuration of
	// default Hub Features.
	KubernetesResource *KubernetesResource `json:"kubernetesResource,omitempty"`
	// MultiCloudCluster: Optional. Specific information for a GKE Multi-Cloud
	// cluster.
	MultiCloudCluster *MultiCloudCluster `json:"multiCloudCluster,omitempty"`
	// OnPremCluster: Optional. Specific information for a GKE On-Prem cluster. An
	// onprem user-cluster who has no resourceLink is not allowed to use this
	// field, it should have a nil "type" instead.
	OnPremCluster *OnPremCluster `json:"onPremCluster,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApplianceCluster") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApplianceCluster") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MembershipEndpoint) MarshalJSON() ([]byte, error) {
	type NoMethod MembershipEndpoint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MembershipFeatureSpec: MembershipFeatureSpec contains configuration
// information for a single Membership.
type MembershipFeatureSpec struct {
	// Cloudbuild: Cloud Build-specific spec
	Cloudbuild *CloudBuildMembershipSpec `json:"cloudbuild,omitempty"`
	// Configmanagement: Config Management-specific spec.
	Configmanagement *ConfigManagementMembershipSpec `json:"configmanagement,omitempty"`
	// Fleetobservability: Fleet observability membership spec
	Fleetobservability *FleetObservabilityMembershipSpec `json:"fleetobservability,omitempty"`
	// Identityservice: Identity Service-specific spec.
	Identityservice *IdentityServiceMembershipSpec `json:"identityservice,omitempty"`
	// Mesh: Anthos Service Mesh-specific spec
	Mesh *ServiceMeshMembershipSpec `json:"mesh,omitempty"`
	// Namespaceactuation: FNS Actuation membership spec
	Namespaceactuation *NamespaceActuationMembershipSpec `json:"namespaceactuation,omitempty"`
	// Origin: Whether this per-Membership spec was inherited from a fleet-level
	// default. This field can be updated by users by either overriding a
	// Membership config (updated to USER implicitly) or setting to FLEET
	// explicitly.
	Origin *Origin `json:"origin,omitempty"`
	// Policycontroller: Policy Controller spec.
	Policycontroller *PolicyControllerMembershipSpec `json:"policycontroller,omitempty"`
	// Workloadcertificate: Workload Certificate spec.
	Workloadcertificate *MembershipSpec `json:"workloadcertificate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cloudbuild") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cloudbuild") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MembershipFeatureSpec) MarshalJSON() ([]byte, error) {
	type NoMethod MembershipFeatureSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MembershipFeatureState: MembershipFeatureState contains Feature status
// information for a single Membership.
type MembershipFeatureState struct {
	// Appdevexperience: Appdevexperience specific state.
	Appdevexperience *AppDevExperienceFeatureState `json:"appdevexperience,omitempty"`
	// Clusterupgrade: ClusterUpgrade state.
	Clusterupgrade *ClusterUpgradeMembershipState `json:"clusterupgrade,omitempty"`
	// Configmanagement: Config Management-specific state.
	Configmanagement *ConfigManagementMembershipState `json:"configmanagement,omitempty"`
	// Fleetobservability: Fleet observability membership state.
	Fleetobservability *FleetObservabilityMembershipState `json:"fleetobservability,omitempty"`
	// Identityservice: Identity Service-specific state.
	Identityservice *IdentityServiceMembershipState `json:"identityservice,omitempty"`
	// Metering: Metering-specific state.
	Metering *MeteringMembershipState `json:"metering,omitempty"`
	// Namespaceactuation: FNS Actuation membership state
	Namespaceactuation *NamespaceActuationMembershipState `json:"namespaceactuation,omitempty"`
	// Policycontroller: Policycontroller-specific state.
	Policycontroller *PolicyControllerMembershipState `json:"policycontroller,omitempty"`
	// Servicemesh: Service Mesh-specific state.
	Servicemesh *ServiceMeshMembershipState `json:"servicemesh,omitempty"`
	// State: The high-level state of this Feature for a single membership.
	State *FeatureState `json:"state,omitempty"`
	// Workloadidentity: Workload Identity membership specific state.
	Workloadidentity *WorkloadIdentityMembershipState `json:"workloadidentity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Appdevexperience") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Appdevexperience") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MembershipFeatureState) MarshalJSON() ([]byte, error) {
	type NoMethod MembershipFeatureState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MembershipSpec: **Workload Certificate**: The membership-specific input for
// WorkloadCertificate feature.
type MembershipSpec struct {
	// CertificateManagement: Specifies workload certificate management.
	//
	// Possible values:
	//   "CERTIFICATE_MANAGEMENT_UNSPECIFIED" - Disable workload certificate
	// feature.
	//   "DISABLED" - Disable workload certificate feature.
	//   "ENABLED" - Enable workload certificate feature.
	CertificateManagement string `json:"certificateManagement,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CertificateManagement") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CertificateManagement") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MembershipSpec) MarshalJSON() ([]byte, error) {
	type NoMethod MembershipSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MembershipState: MembershipState describes the state of a Membership
// resource.
type MembershipState struct {
	// Code: Output only. The current state of the Membership resource.
	//
	// Possible values:
	//   "CODE_UNSPECIFIED" - The code is not set.
	//   "CREATING" - The cluster is being registered.
	//   "READY" - The cluster is registered.
	//   "DELETING" - The cluster is being unregistered.
	//   "UPDATING" - The Membership is being updated.
	//   "SERVICE_UPDATING" - The Membership is being updated by the Hub Service.
	Code string `json:"code,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MembershipState) MarshalJSON() ([]byte, error) {
	type NoMethod MembershipState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MeteringMembershipState: **Metering**: Per-Membership Feature State.
type MeteringMembershipState struct {
	// LastMeasurementTime: The time stamp of the most recent measurement of the
	// number of vCPUs in the cluster.
	LastMeasurementTime string `json:"lastMeasurementTime,omitempty"`
	// PreciseLastMeasuredClusterVcpuCapacity: The vCPUs capacity in the cluster
	// according to the most recent measurement (1/1000 precision).
	PreciseLastMeasuredClusterVcpuCapacity float64 `json:"preciseLastMeasuredClusterVcpuCapacity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LastMeasurementTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LastMeasurementTime") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MeteringMembershipState) MarshalJSON() ([]byte, error) {
	type NoMethod MeteringMembershipState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *MeteringMembershipState) UnmarshalJSON(data []byte) error {
	type NoMethod MeteringMembershipState
	var s1 struct {
		PreciseLastMeasuredClusterVcpuCapacity gensupport.JSONFloat64 `json:"preciseLastMeasuredClusterVcpuCapacity"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.PreciseLastMeasuredClusterVcpuCapacity = float64(s1.PreciseLastMeasuredClusterVcpuCapacity)
	return nil
}

// MonitoringConfig: MonitoringConfig informs Fleet-based
// applications/services/UIs how the metrics for the underlying cluster is
// reported to cloud monitoring services. It can be set from empty to
// non-empty, but can't be mutated directly to prevent accidentally breaking
// the constinousty of metrics.
type MonitoringConfig struct {
	// Cluster: Optional. Cluster name used to report metrics. For Anthos on
	// VMWare/Baremetal/MultiCloud clusters, it would be in format
	// {cluster_type}/{cluster_name}, e.g., "awsClusters/cluster_1".
	Cluster string `json:"cluster,omitempty"`
	// ClusterHash: Optional. For GKE and Multicloud clusters, this is the UUID of
	// the cluster resource. For VMWare and Baremetal clusters, this is the
	// kube-system UID.
	ClusterHash string `json:"clusterHash,omitempty"`
	// KubernetesMetricsPrefix: Optional. Kubernetes system metrics, if available,
	// are written to this prefix. This defaults to kubernetes.io for GKE, and
	// kubernetes.io/anthos for Anthos eventually. Noted: Anthos MultiCloud will
	// have kubernetes.io prefix today but will migration to be under
	// kubernetes.io/anthos.
	KubernetesMetricsPrefix string `json:"kubernetesMetricsPrefix,omitempty"`
	// Location: Optional. Location used to report Metrics
	Location string `json:"location,omitempty"`
	// ProjectId: Optional. Project used to report Metrics
	ProjectId string `json:"projectId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cluster") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cluster") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MonitoringConfig) MarshalJSON() ([]byte, error) {
	type NoMethod MonitoringConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MultiCloudCluster: MultiCloudCluster contains information specific to GKE
// Multi-Cloud clusters.
type MultiCloudCluster struct {
	// ClusterMissing: Output only. If cluster_missing is set then it denotes that
	// API(gkemulticloud.googleapis.com) resource for this GKE Multi-Cloud cluster
	// no longer exists.
	ClusterMissing bool `json:"clusterMissing,omitempty"`
	// ResourceLink: Immutable. Self-link of the Google Cloud resource for the GKE
	// Multi-Cloud cluster. For example:
	// //gkemulticloud.googleapis.com/projects/my-project/locations/us-west1-a/awsCl
	// usters/my-cluster
	// //gkemulticloud.googleapis.com/projects/my-project/locations/us-west1-a/azure
	// Clusters/my-cluster
	// //gkemulticloud.googleapis.com/projects/my-project/locations/us-west1-a/attac
	// hedClusters/my-cluster
	ResourceLink string `json:"resourceLink,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClusterMissing") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClusterMissing") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MultiCloudCluster) MarshalJSON() ([]byte, error) {
	type NoMethod MultiCloudCluster
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MultiClusterIngressFeatureSpec: **Multi-cluster Ingress**: The configuration
// for the MultiClusterIngress feature.
type MultiClusterIngressFeatureSpec struct {
	// Billing: Deprecated: This field will be ignored and should not be set.
	// Customer's billing structure.
	//
	// Possible values:
	//   "BILLING_UNSPECIFIED" - Unknown
	//   "PAY_AS_YOU_GO" - User pays a fee per-endpoint.
	//   "ANTHOS_LICENSE" - User is paying for Anthos as a whole.
	Billing string `json:"billing,omitempty"`
	// ConfigMembership: Fully-qualified Membership name which hosts the
	// MultiClusterIngress CRD. Example:
	// `projects/foo-proj/locations/global/memberships/bar`
	ConfigMembership string `json:"configMembership,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Billing") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Billing") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MultiClusterIngressFeatureSpec) MarshalJSON() ([]byte, error) {
	type NoMethod MultiClusterIngressFeatureSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Namespace: Namespace represents a namespace across the Fleet
type Namespace struct {
	// CreateTime: Output only. When the namespace was created.
	CreateTime string `json:"createTime,omitempty"`
	// DeleteTime: Output only. When the namespace was deleted.
	DeleteTime string `json:"deleteTime,omitempty"`
	// Labels: Optional. Labels for this Namespace.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: The resource name for the namespace
	// `projects/{project}/locations/{location}/namespaces/{namespace}`
	Name string `json:"name,omitempty"`
	// NamespaceLabels: Optional. Namespace-level cluster namespace labels. These
	// labels are applied to the related namespace of the member clusters bound to
	// the parent Scope. Scope-level labels (`namespace_labels` in the Fleet Scope
	// resource) take precedence over Namespace-level labels if they share a key.
	// Keys and values must be Kubernetes-conformant.
	NamespaceLabels map[string]string `json:"namespaceLabels,omitempty"`
	// Scope: Required. Scope associated with the namespace
	Scope string `json:"scope,omitempty"`
	// State: Output only. State of the namespace resource.
	State *NamespaceLifecycleState `json:"state,omitempty"`
	// Uid: Output only. Google-generated UUID for this resource. This is unique
	// across all namespace resources. If a namespace resource is deleted and
	// another resource with the same name is created, it gets a different uid.
	Uid string `json:"uid,omitempty"`
	// UpdateTime: Output only. When the namespace was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Namespace) MarshalJSON() ([]byte, error) {
	type NoMethod Namespace
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NamespaceActuationFeatureSpec: An empty spec for actuation feature. This is
// required since Feature proto requires a spec.
type NamespaceActuationFeatureSpec struct {
	// ActuationMode: actuation_mode controls the behavior of the controller
	//
	// Possible values:
	//   "ACTUATION_MODE_UNSPECIFIED" - ACTUATION_MODE_UNSPECIFIED is similar to
	// CREATE_AND_DELETE_IF_CREATED in the default controller behavior.
	//   "ACTUATION_MODE_CREATE_AND_DELETE_IF_CREATED" -
	// ACTUATION_MODE_CREATE_AND_DELETE_IF_CREATED has the controller create
	// cluster namespaces for each fleet namespace and it deletes only the ones it
	// created, which are identified by a label.
	//   "ACTUATION_MODE_ADD_AND_REMOVE_FLEET_LABELS" -
	// ACTUATION_MODE_ADD_AND_REMOVE_FLEET_LABELS has the controller only apply
	// labels to cluster namespaces to signal fleet namespace enablement. It
	// doesn't create or delete cluster namespaces.
	ActuationMode string `json:"actuationMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActuationMode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActuationMode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NamespaceActuationFeatureSpec) MarshalJSON() ([]byte, error) {
	type NoMethod NamespaceActuationFeatureSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NamespaceActuationFeatureState: NamespaceActuation Feature State.
type NamespaceActuationFeatureState struct {
}

// NamespaceActuationMembershipSpec: **Namespace Actuation**: The
// membership-specific input for NamespaceActuation feature.
type NamespaceActuationMembershipSpec struct {
}

// NamespaceActuationMembershipState: **Namespace Actuation**: An empty state
// left as an example membership-specific Feature state.
type NamespaceActuationMembershipState struct {
}

// NamespaceLifecycleState: NamespaceLifecycleState describes the state of a
// Namespace resource.
type NamespaceLifecycleState struct {
	// Code: Output only. The current state of the Namespace resource.
	//
	// Possible values:
	//   "CODE_UNSPECIFIED" - The code is not set.
	//   "CREATING" - The namespace is being created.
	//   "READY" - The namespace active.
	//   "DELETING" - The namespace is being deleted.
	//   "UPDATING" - The namespace is being updated.
	Code string `json:"code,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NamespaceLifecycleState) MarshalJSON() ([]byte, error) {
	type NoMethod NamespaceLifecycleState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OnPremCluster: OnPremCluster contains information specific to GKE On-Prem
// clusters.
type OnPremCluster struct {
	// AdminCluster: Immutable. Whether the cluster is an admin cluster.
	AdminCluster bool `json:"adminCluster,omitempty"`
	// ClusterMissing: Output only. If cluster_missing is set then it denotes that
	// API(gkeonprem.googleapis.com) resource for this GKE On-Prem cluster no
	// longer exists.
	ClusterMissing bool `json:"clusterMissing,omitempty"`
	// ClusterType: Immutable. The on prem cluster's type.
	//
	// Possible values:
	//   "CLUSTERTYPE_UNSPECIFIED" - The ClusterType is not set.
	//   "BOOTSTRAP" - The ClusterType is bootstrap cluster.
	//   "HYBRID" - The ClusterType is baremetal hybrid cluster.
	//   "STANDALONE" - The ClusterType is baremetal standalone cluster.
	//   "USER" - The ClusterType is user cluster.
	ClusterType string `json:"clusterType,omitempty"`
	// ResourceLink: Immutable. Self-link of the Google Cloud resource for the GKE
	// On-Prem cluster. For example:
	// //gkeonprem.googleapis.com/projects/my-project/locations/us-west1-a/vmwareClu
	// sters/my-cluster
	// //gkeonprem.googleapis.com/projects/my-project/locations/us-west1-a/bareMetal
	// Clusters/my-cluster
	ResourceLink string `json:"resourceLink,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdminCluster") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdminCluster") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OnPremCluster) MarshalJSON() ([]byte, error) {
	type NoMethod OnPremCluster
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Operation: This resource represents a long-running operation that is the
// result of a network API call.
type Operation struct {
	// Done: If the value is `false`, it means the operation is still in progress.
	// If `true`, the operation is completed, and either `error` or `response` is
	// available.
	Done bool `json:"done,omitempty"`
	// Error: The error result of the operation in case of failure or cancellation.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as create
	// time. Some services might not provide such metadata. Any method that returns
	// a long-running operation should document the metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: The server-assigned name, which is only unique within the same service
	// that originally returns it. If you use the default HTTP mapping, the `name`
	// should be a resource name ending with `operations/{unique_id}`.
	Name string `json:"name,omitempty"`
	// Response: The normal, successful response of the operation. If the original
	// method returns no data on success, such as `Delete`, the response is
	// `google.protobuf.Empty`. If the original method is standard
	// `Get`/`Create`/`Update`, the response should be the resource. For other
	// methods, the response should have the type `XxxResponse`, where `Xxx` is the
	// original method name. For example, if the original method name is
	// `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Operation) MarshalJSON() ([]byte, error) {
	type NoMethod Operation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OperationMetadata: Represents the metadata of the long-running operation.
type OperationMetadata struct {
	// ApiVersion: Output only. API version used to start the operation.
	ApiVersion string `json:"apiVersion,omitempty"`
	// CancelRequested: Output only. Identifies whether the user has requested
	// cancellation of the operation. Operations that have successfully been
	// cancelled have google.longrunning.Operation.error value with a
	// google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
	CancelRequested bool `json:"cancelRequested,omitempty"`
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// StatusDetail: Output only. Human-readable status of the operation, if any.
	StatusDetail string `json:"statusDetail,omitempty"`
	// Target: Output only. Server-defined resource path for the target of the
	// operation.
	Target string `json:"target,omitempty"`
	// Verb: Output only. Name of the verb executed by the operation.
	Verb string `json:"verb,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod OperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Origin: Origin defines where this MembershipFeatureSpec originated from.
type Origin struct {
	// Type: Type specifies which type of origin is set.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Type is unknown or not set.
	//   "FLEET" - Per-Membership spec was inherited from the fleet-level default.
	//   "FLEET_OUT_OF_SYNC" - Per-Membership spec was inherited from the
	// fleet-level default but is now out of sync with the current default.
	//   "USER" - Per-Membership spec was inherited from a user specification.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Type") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Type") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Origin) MarshalJSON() ([]byte, error) {
	type NoMethod Origin
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Policy: An Identity and Access Management (IAM) policy, which specifies
// access controls for Google Cloud resources. A `Policy` is a collection of
// `bindings`. A `binding` binds one or more `members`, or principals, to a
// single `role`. Principals can be user accounts, service accounts, Google
// groups, and domains (such as G Suite). A `role` is a named list of
// permissions; each `role` can be an IAM predefined role or a user-created
// custom role. For some types of Google Cloud resources, a `binding` can also
// specify a `condition`, which is a logical expression that allows access to a
// resource only if the expression evaluates to `true`. A condition can add
// constraints based on attributes of the request, the resource, or both. To
// learn which resources support conditions in their IAM policies, see the IAM
// documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies). **JSON
// example:** ``` { "bindings": [ { "role":
// "roles/resourcemanager.organizationAdmin", "members": [
// "user:mike@example.com", "group:admins@example.com", "domain:google.com",
// "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
// "roles/resourcemanager.organizationViewer", "members": [
// "user:eve@example.com" ], "condition": { "title": "expirable access",
// "description": "Does not grant access after Sep 2020", "expression":
// "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
// "BwWWja0YfJA=", "version": 3 } ``` **YAML example:** ``` bindings: -
// members: - user:mike@example.com - group:admins@example.com -
// domain:google.com - serviceAccount:my-project-id@appspot.gserviceaccount.com
// role: roles/resourcemanager.organizationAdmin - members: -
// user:eve@example.com role: roles/resourcemanager.organizationViewer
// condition: title: expirable access description: Does not grant access after
// Sep 2020 expression: request.time < timestamp('2020-10-01T00:00:00.000Z')
// etag: BwWWja0YfJA= version: 3 ``` For a description of IAM and its features,
// see the IAM documentation (https://cloud.google.com/iam/docs/).
type Policy struct {
	// AuditConfigs: Specifies cloud audit logging configuration for this policy.
	AuditConfigs []*AuditConfig `json:"auditConfigs,omitempty"`
	// Bindings: Associates a list of `members`, or principals, with a `role`.
	// Optionally, may specify a `condition` that determines how and when the
	// `bindings` are applied. Each of the `bindings` must contain at least one
	// principal. The `bindings` in a `Policy` can refer to up to 1,500 principals;
	// up to 250 of these principals can be Google groups. Each occurrence of a
	// principal counts towards these limits. For example, if the `bindings` grant
	// 50 different roles to `user:alice@example.com`, and not to any other
	// principal, then you can add another 1,450 principals to the `bindings` in
	// the `Policy`.
	Bindings []*Binding `json:"bindings,omitempty"`
	// Etag: `etag` is used for optimistic concurrency control as a way to help
	// prevent simultaneous updates of a policy from overwriting each other. It is
	// strongly suggested that systems make use of the `etag` in the
	// read-modify-write cycle to perform policy updates in order to avoid race
	// conditions: An `etag` is returned in the response to `getIamPolicy`, and
	// systems are expected to put that etag in the request to `setIamPolicy` to
	// ensure that their change will be applied to the same version of the policy.
	// **Important:** If you use IAM Conditions, you must include the `etag` field
	// whenever you call `setIamPolicy`. If you omit this field, then IAM allows
	// you to overwrite a version `3` policy with a version `1` policy, and all of
	// the conditions in the version `3` policy are lost.
	Etag string `json:"etag,omitempty"`
	// Version: Specifies the format of the policy. Valid values are `0`, `1`, and
	// `3`. Requests that specify an invalid value are rejected. Any operation that
	// affects conditional role bindings must specify version `3`. This requirement
	// applies to the following operations: * Getting a policy that includes a
	// conditional role binding * Adding a conditional role binding to a policy *
	// Changing a conditional role binding in a policy * Removing any role binding,
	// with or without a condition, from a policy that includes conditions
	// **Important:** If you use IAM Conditions, you must include the `etag` field
	// whenever you call `setIamPolicy`. If you omit this field, then IAM allows
	// you to overwrite a version `3` policy with a version `1` policy, and all of
	// the conditions in the version `3` policy are lost. If a policy does not
	// include any conditions, operations on that policy may specify any valid
	// version or leave the field unset. To learn which resources support
	// conditions in their IAM policies, see the IAM documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Version int64 `json:"version,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AuditConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuditConfigs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Policy) MarshalJSON() ([]byte, error) {
	type NoMethod Policy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PolicyBinding: Binauthz policy that applies to this cluster.
type PolicyBinding struct {
	// Name: The relative resource name of the binauthz platform policy to audit.
	// GKE platform policies have the following format:
	// `projects/{project_number}/platforms/gke/policies/{policy_id}`.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PolicyBinding) MarshalJSON() ([]byte, error) {
	type NoMethod PolicyBinding
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PolicyControllerBundleInstallSpec: BundleInstallSpec is the specification
// configuration for a single managed bundle.
type PolicyControllerBundleInstallSpec struct {
	// ExemptedNamespaces: The set of namespaces to be exempted from the bundle.
	ExemptedNamespaces []string `json:"exemptedNamespaces,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExemptedNamespaces") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExemptedNamespaces") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PolicyControllerBundleInstallSpec) MarshalJSON() ([]byte, error) {
	type NoMethod PolicyControllerBundleInstallSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PolicyControllerHubConfig: Configuration for Policy Controller
type PolicyControllerHubConfig struct {
	// AuditIntervalSeconds: Sets the interval for Policy Controller Audit Scans
	// (in seconds). When set to 0, this disables audit functionality altogether.
	AuditIntervalSeconds int64 `json:"auditIntervalSeconds,omitempty,string"`
	// ConstraintViolationLimit: The maximum number of audit violations to be
	// stored in a constraint. If not set, the internal default (currently 20) will
	// be used.
	ConstraintViolationLimit int64 `json:"constraintViolationLimit,omitempty,string"`
	// DeploymentConfigs: Map of deployment configs to deployments ("admission",
	// "audit", "mutation').
	DeploymentConfigs map[string]PolicyControllerPolicyControllerDeploymentConfig `json:"deploymentConfigs,omitempty"`
	// ExemptableNamespaces: The set of namespaces that are excluded from Policy
	// Controller checks. Namespaces do not need to currently exist on the cluster.
	ExemptableNamespaces []string `json:"exemptableNamespaces,omitempty"`
	// InstallSpec: The install_spec represents the intended state specified by the
	// latest request that mutated install_spec in the feature spec, not the
	// lifecycle state of the feature observed by the Hub feature controller that
	// is reported in the feature state.
	//
	// Possible values:
	//   "INSTALL_SPEC_UNSPECIFIED" - Spec is unknown.
	//   "INSTALL_SPEC_NOT_INSTALLED" - Request to uninstall Policy Controller.
	//   "INSTALL_SPEC_ENABLED" - Request to install and enable Policy Controller.
	//   "INSTALL_SPEC_SUSPENDED" - Request to suspend Policy Controller i.e. its
	// webhooks. If Policy Controller is not installed, it will be installed but
	// suspended.
	//   "INSTALL_SPEC_DETACHED" - Request to stop all reconciliation actions by
	// PoCo Hub controller. This is a breakglass mechanism to stop PoCo Hub from
	// affecting cluster resources.
	InstallSpec string `json:"installSpec,omitempty"`
	// LogDeniesEnabled: Logs all denies and dry run failures.
	LogDeniesEnabled bool `json:"logDeniesEnabled,omitempty"`
	// Monitoring: Monitoring specifies the configuration of monitoring.
	Monitoring *PolicyControllerMonitoringConfig `json:"monitoring,omitempty"`
	// MutationEnabled: Enables the ability to mutate resources using Policy
	// Controller.
	MutationEnabled bool `json:"mutationEnabled,omitempty"`
	// PolicyContent: Specifies the desired policy content on the cluster
	PolicyContent *PolicyControllerPolicyContentSpec `json:"policyContent,omitempty"`
	// ReferentialRulesEnabled: Enables the ability to use Constraint Templates
	// that reference to objects other than the object currently being evaluated.
	ReferentialRulesEnabled bool `json:"referentialRulesEnabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AuditIntervalSeconds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuditIntervalSeconds") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PolicyControllerHubConfig) MarshalJSON() ([]byte, error) {
	type NoMethod PolicyControllerHubConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PolicyControllerMembershipSpec: **Policy Controller**: Configuration for a
// single cluster. Intended to parallel the PolicyController CR.
type PolicyControllerMembershipSpec struct {
	// PolicyControllerHubConfig: Policy Controller configuration for the cluster.
	PolicyControllerHubConfig *PolicyControllerHubConfig `json:"policyControllerHubConfig,omitempty"`
	// Version: Version of Policy Controller installed.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PolicyControllerHubConfig")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PolicyControllerHubConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PolicyControllerMembershipSpec) MarshalJSON() ([]byte, error) {
	type NoMethod PolicyControllerMembershipSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PolicyControllerMembershipState: **Policy Controller**: State for a single
// cluster.
type PolicyControllerMembershipState struct {
	// ComponentStates: Currently these include (also serving as map keys): 1.
	// "admission" 2. "audit" 3. "mutation"
	ComponentStates map[string]PolicyControllerOnClusterState `json:"componentStates,omitempty"`
	// PolicyContentState: The overall content state observed by the Hub Feature
	// controller.
	PolicyContentState *PolicyControllerPolicyContentState `json:"policyContentState,omitempty"`
	// State: The overall Policy Controller lifecycle state observed by the Hub
	// Feature controller.
	//
	// Possible values:
	//   "LIFECYCLE_STATE_UNSPECIFIED" - The lifecycle state is unspecified.
	//   "NOT_INSTALLED" - The PC does not exist on the given cluster, and no k8s
	// resources of any type that are associated with the PC should exist there.
	// The cluster does not possess a membership with the PCH.
	//   "INSTALLING" - The PCH possesses a Membership, however the PC is not fully
	// installed on the cluster. In this state the hub can be expected to be taking
	// actions to install the PC on the cluster.
	//   "ACTIVE" - The PC is fully installed on the cluster and in an operational
	// mode. In this state PCH will be reconciling state with the PC, and the PC
	// will be performing it's operational tasks per that software. Entering a
	// READY state requires that the hub has confirmed the PC is installed and its
	// pods are operational with the version of the PC the PCH expects.
	//   "UPDATING" - The PC is fully installed, but in the process of changing the
	// configuration (including changing the version of PC either up and down, or
	// modifying the manifests of PC) of the resources running on the cluster. The
	// PCH has a Membership, is aware of the version the cluster should be running
	// in, but has not confirmed for itself that the PC is running with that
	// version.
	//   "DECOMMISSIONING" - The PC may have resources on the cluster, but the PCH
	// wishes to remove the Membership. The Membership still exists.
	//   "CLUSTER_ERROR" - The PC is not operational, and the PCH is unable to act
	// to make it operational. Entering a CLUSTER_ERROR state happens automatically
	// when the PCH determines that a PC installed on the cluster is non-operative
	// or that the cluster does not meet requirements set for the PCH to administer
	// the cluster but has nevertheless been given an instruction to do so (such as
	// 'install').
	//   "HUB_ERROR" - In this state, the PC may still be operational, and only the
	// PCH is unable to act. The hub should not issue instructions to change the PC
	// state, or otherwise interfere with the on-cluster resources. Entering a
	// HUB_ERROR state happens automatically when the PCH determines the hub is in
	// an unhealthy state and it wishes to 'take hands off' to avoid corrupting the
	// PC or other data.
	//   "SUSPENDED" - Policy Controller (PC) is installed but suspended. This
	// means that the policies are not enforced, but violations are still recorded
	// (through audit).
	//   "DETACHED" - PoCo Hub is not taking any action to reconcile cluster
	// objects. Changes to those objects will not be overwritten by PoCo Hub.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ComponentStates") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ComponentStates") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PolicyControllerMembershipState) MarshalJSON() ([]byte, error) {
	type NoMethod PolicyControllerMembershipState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PolicyControllerMonitoringConfig: MonitoringConfig specifies the backends
// Policy Controller should export metrics to. For example, to specify metrics
// should be exported to Cloud Monitoring and Prometheus, specify backends:
// ["cloudmonitoring", "prometheus"]
type PolicyControllerMonitoringConfig struct {
	// Backends: Specifies the list of backends Policy Controller will export to.
	// An empty list would effectively disable metrics export.
	//
	// Possible values:
	//   "MONITORING_BACKEND_UNSPECIFIED" - Backend cannot be determined
	//   "PROMETHEUS" - Prometheus backend for monitoring
	//   "CLOUD_MONITORING" - Stackdriver/Cloud Monitoring backend for monitoring
	Backends []string `json:"backends,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Backends") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Backends") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PolicyControllerMonitoringConfig) MarshalJSON() ([]byte, error) {
	type NoMethod PolicyControllerMonitoringConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PolicyControllerOnClusterState: OnClusterState represents the state of a
// sub-component of Policy Controller.
type PolicyControllerOnClusterState struct {
	// Details: Surface potential errors or information logs.
	Details string `json:"details,omitempty"`
	// State: The lifecycle state of this component.
	//
	// Possible values:
	//   "LIFECYCLE_STATE_UNSPECIFIED" - The lifecycle state is unspecified.
	//   "NOT_INSTALLED" - The PC does not exist on the given cluster, and no k8s
	// resources of any type that are associated with the PC should exist there.
	// The cluster does not possess a membership with the PCH.
	//   "INSTALLING" - The PCH possesses a Membership, however the PC is not fully
	// installed on the cluster. In this state the hub can be expected to be taking
	// actions to install the PC on the cluster.
	//   "ACTIVE" - The PC is fully installed on the cluster and in an operational
	// mode. In this state PCH will be reconciling state with the PC, and the PC
	// will be performing it's operational tasks per that software. Entering a
	// READY state requires that the hub has confirmed the PC is installed and its
	// pods are operational with the version of the PC the PCH expects.
	//   "UPDATING" - The PC is fully installed, but in the process of changing the
	// configuration (including changing the version of PC either up and down, or
	// modifying the manifests of PC) of the resources running on the cluster. The
	// PCH has a Membership, is aware of the version the cluster should be running
	// in, but has not confirmed for itself that the PC is running with that
	// version.
	//   "DECOMMISSIONING" - The PC may have resources on the cluster, but the PCH
	// wishes to remove the Membership. The Membership still exists.
	//   "CLUSTER_ERROR" - The PC is not operational, and the PCH is unable to act
	// to make it operational. Entering a CLUSTER_ERROR state happens automatically
	// when the PCH determines that a PC installed on the cluster is non-operative
	// or that the cluster does not meet requirements set for the PCH to administer
	// the cluster but has nevertheless been given an instruction to do so (such as
	// 'install').
	//   "HUB_ERROR" - In this state, the PC may still be operational, and only the
	// PCH is unable to act. The hub should not issue instructions to change the PC
	// state, or otherwise interfere with the on-cluster resources. Entering a
	// HUB_ERROR state happens automatically when the PCH determines the hub is in
	// an unhealthy state and it wishes to 'take hands off' to avoid corrupting the
	// PC or other data.
	//   "SUSPENDED" - Policy Controller (PC) is installed but suspended. This
	// means that the policies are not enforced, but violations are still recorded
	// (through audit).
	//   "DETACHED" - PoCo Hub is not taking any action to reconcile cluster
	// objects. Changes to those objects will not be overwritten by PoCo Hub.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Details") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Details") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PolicyControllerOnClusterState) MarshalJSON() ([]byte, error) {
	type NoMethod PolicyControllerOnClusterState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PolicyControllerPolicyContentSpec: PolicyContentSpec defines the user's
// desired content configuration on the cluster.
type PolicyControllerPolicyContentSpec struct {
	// Bundles: map of bundle name to BundleInstallSpec. The bundle name maps to
	// the `bundleName` key in the `policycontroller.gke.io/constraintData`
	// annotation on a constraint.
	Bundles map[string]PolicyControllerBundleInstallSpec `json:"bundles,omitempty"`
	// TemplateLibrary: Configures the installation of the Template Library.
	TemplateLibrary *PolicyControllerTemplateLibraryConfig `json:"templateLibrary,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Bundles") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Bundles") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PolicyControllerPolicyContentSpec) MarshalJSON() ([]byte, error) {
	type NoMethod PolicyControllerPolicyContentSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PolicyControllerPolicyContentState: The state of the policy controller
// policy content
type PolicyControllerPolicyContentState struct {
	// BundleStates: The state of the any bundles included in the chosen version of
	// the manifest
	BundleStates map[string]PolicyControllerOnClusterState `json:"bundleStates,omitempty"`
	// ReferentialSyncConfigState: The state of the referential data sync
	// configuration. This could represent the state of either the syncSet
	// object(s) or the config object, depending on the version of PoCo configured
	// by the user.
	ReferentialSyncConfigState *PolicyControllerOnClusterState `json:"referentialSyncConfigState,omitempty"`
	// TemplateLibraryState: The state of the template library
	TemplateLibraryState *PolicyControllerOnClusterState `json:"templateLibraryState,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BundleStates") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BundleStates") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PolicyControllerPolicyContentState) MarshalJSON() ([]byte, error) {
	type NoMethod PolicyControllerPolicyContentState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PolicyControllerPolicyControllerDeploymentConfig: Deployment-specific
// configuration.
type PolicyControllerPolicyControllerDeploymentConfig struct {
	// ContainerResources: Container resource requirements.
	ContainerResources *PolicyControllerResourceRequirements `json:"containerResources,omitempty"`
	// PodAffinity: Pod affinity configuration.
	//
	// Possible values:
	//   "AFFINITY_UNSPECIFIED" - No affinity configuration has been specified.
	//   "NO_AFFINITY" - Affinity configurations will be removed from the
	// deployment.
	//   "ANTI_AFFINITY" - Anti-affinity configuration will be applied to this
	// deployment. Default for admissions deployment.
	PodAffinity string `json:"podAffinity,omitempty"`
	// PodAntiAffinity: Pod anti-affinity enablement. Deprecated: use
	// `pod_affinity` instead.
	PodAntiAffinity bool `json:"podAntiAffinity,omitempty"`
	// PodTolerations: Pod tolerations of node taints.
	PodTolerations []*PolicyControllerToleration `json:"podTolerations,omitempty"`
	// ReplicaCount: Pod replica count.
	ReplicaCount int64 `json:"replicaCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ContainerResources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContainerResources") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PolicyControllerPolicyControllerDeploymentConfig) MarshalJSON() ([]byte, error) {
	type NoMethod PolicyControllerPolicyControllerDeploymentConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PolicyControllerResourceList: ResourceList contains container resource
// requirements.
type PolicyControllerResourceList struct {
	// Cpu: CPU requirement expressed in Kubernetes resource units.
	Cpu string `json:"cpu,omitempty"`
	// Memory: Memory requirement expressed in Kubernetes resource units.
	Memory string `json:"memory,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cpu") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cpu") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PolicyControllerResourceList) MarshalJSON() ([]byte, error) {
	type NoMethod PolicyControllerResourceList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PolicyControllerResourceRequirements: ResourceRequirements describes the
// compute resource requirements.
type PolicyControllerResourceRequirements struct {
	// Limits: Limits describes the maximum amount of compute resources allowed for
	// use by the running container.
	Limits *PolicyControllerResourceList `json:"limits,omitempty"`
	// Requests: Requests describes the amount of compute resources reserved for
	// the container by the kube-scheduler.
	Requests *PolicyControllerResourceList `json:"requests,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Limits") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Limits") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PolicyControllerResourceRequirements) MarshalJSON() ([]byte, error) {
	type NoMethod PolicyControllerResourceRequirements
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PolicyControllerTemplateLibraryConfig: The config specifying which default
// library templates to install.
type PolicyControllerTemplateLibraryConfig struct {
	// Installation: Configures the manner in which the template library is
	// installed on the cluster.
	//
	// Possible values:
	//   "INSTALLATION_UNSPECIFIED" - No installation strategy has been specified.
	//   "NOT_INSTALLED" - Do not install the template library.
	//   "ALL" - Install the entire template library.
	Installation string `json:"installation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Installation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Installation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PolicyControllerTemplateLibraryConfig) MarshalJSON() ([]byte, error) {
	type NoMethod PolicyControllerTemplateLibraryConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PolicyControllerToleration: Toleration of a node taint.
type PolicyControllerToleration struct {
	// Effect: Matches a taint effect.
	Effect string `json:"effect,omitempty"`
	// Key: Matches a taint key (not necessarily unique).
	Key string `json:"key,omitempty"`
	// Operator: Matches a taint operator.
	Operator string `json:"operator,omitempty"`
	// Value: Matches a taint value.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Effect") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Effect") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PolicyControllerToleration) MarshalJSON() ([]byte, error) {
	type NoMethod PolicyControllerToleration
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RBACRoleBinding: RBACRoleBinding represents a rbacrolebinding across the
// Fleet
type RBACRoleBinding struct {
	// CreateTime: Output only. When the rbacrolebinding was created.
	CreateTime string `json:"createTime,omitempty"`
	// DeleteTime: Output only. When the rbacrolebinding was deleted.
	DeleteTime string `json:"deleteTime,omitempty"`
	// Group: group is the group, as seen by the kubernetes cluster.
	Group string `json:"group,omitempty"`
	// Labels: Optional. Labels for this RBACRolebinding.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: The resource name for the rbacrolebinding
	// `projects/{project}/locations/{location}/scopes/{scope}/rbacrolebindings/{rba
	// crolebinding}` or
	// `projects/{project}/locations/{location}/memberships/{membership}/rbacrolebin
	// dings/{rbacrolebinding}`
	Name string `json:"name,omitempty"`
	// Role: Required. Role to bind to the principal
	Role *Role `json:"role,omitempty"`
	// State: Output only. State of the rbacrolebinding resource.
	State *RBACRoleBindingLifecycleState `json:"state,omitempty"`
	// Uid: Output only. Google-generated UUID for this resource. This is unique
	// across all rbacrolebinding resources. If a rbacrolebinding resource is
	// deleted and another resource with the same name is created, it gets a
	// different uid.
	Uid string `json:"uid,omitempty"`
	// UpdateTime: Output only. When the rbacrolebinding was last updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// User: user is the name of the user as seen by the kubernetes cluster,
	// example "alice" or "alice@domain.tld"
	User string `json:"user,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RBACRoleBinding) MarshalJSON() ([]byte, error) {
	type NoMethod RBACRoleBinding
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RBACRoleBindingActuationFeatureSpec: **RBAC RoleBinding Actuation**: The
// Hub-wide input for the RBACRoleBindingActuation feature.
type RBACRoleBindingActuationFeatureSpec struct {
	// AllowedCustomRoles: The list of allowed custom roles (ClusterRoles). If a
	// ClusterRole is not part of this list, it cannot be used in a Scope
	// RBACRoleBinding. If a ClusterRole in this list is in use, it cannot be
	// removed from the list.
	AllowedCustomRoles []string `json:"allowedCustomRoles,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowedCustomRoles") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowedCustomRoles") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RBACRoleBindingActuationFeatureSpec) MarshalJSON() ([]byte, error) {
	type NoMethod RBACRoleBindingActuationFeatureSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RBACRoleBindingActuationFeatureState: **RBAC RoleBinding Actuation**: An
// empty state left as an example Hub-wide Feature state.
type RBACRoleBindingActuationFeatureState struct {
}

// RBACRoleBindingLifecycleState: RBACRoleBindingLifecycleState describes the
// state of a RbacRoleBinding resource.
type RBACRoleBindingLifecycleState struct {
	// Code: Output only. The current state of the rbacrolebinding resource.
	//
	// Possible values:
	//   "CODE_UNSPECIFIED" - The code is not set.
	//   "CREATING" - The rbacrolebinding is being created.
	//   "READY" - The rbacrolebinding active.
	//   "DELETING" - The rbacrolebinding is being deleted.
	//   "UPDATING" - The rbacrolebinding is being updated.
	Code string `json:"code,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RBACRoleBindingLifecycleState) MarshalJSON() ([]byte, error) {
	type NoMethod RBACRoleBindingLifecycleState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ResourceManifest: ResourceManifest represents a single Kubernetes resource
// to be applied to the cluster.
type ResourceManifest struct {
	// ClusterScoped: Output only. Whether the resource provided in the manifest is
	// `cluster_scoped`. If unset, the manifest is assumed to be namespace scoped.
	// This field is used for REST mapping when applying the resource in a cluster.
	ClusterScoped bool `json:"clusterScoped,omitempty"`
	// Manifest: Output only. YAML manifest of the resource.
	Manifest string `json:"manifest,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClusterScoped") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClusterScoped") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ResourceManifest) MarshalJSON() ([]byte, error) {
	type NoMethod ResourceManifest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ResourceOptions: ResourceOptions represent options for Kubernetes resource
// generation.
type ResourceOptions struct {
	// ConnectVersion: Optional. The Connect agent version to use for
	// connect_resources. Defaults to the latest GKE Connect version. The version
	// must be a currently supported version, obsolete versions will be rejected.
	ConnectVersion string `json:"connectVersion,omitempty"`
	// K8sGitVersion: Optional. Git version of the Kubernetes cluster. This is only
	// used to gate the Connect Agent migration to svc.id.goog on GDC-SO 1.33.100
	// patch and above.
	K8sGitVersion string `json:"k8sGitVersion,omitempty"`
	// K8sVersion: Optional. Major and minor version of the Kubernetes cluster.
	// This is only used to determine which version to use for the
	// CustomResourceDefinition resources, `apiextensions/v1beta1`
	// or`apiextensions/v1`.
	K8sVersion string `json:"k8sVersion,omitempty"`
	// V1beta1Crd: Optional. Use `apiextensions/v1beta1` instead of
	// `apiextensions/v1` for CustomResourceDefinition resources. This option
	// should be set for clusters with Kubernetes apiserver versions <1.16.
	V1beta1Crd bool `json:"v1beta1Crd,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConnectVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConnectVersion") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ResourceOptions) MarshalJSON() ([]byte, error) {
	type NoMethod ResourceOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Role: Role is the type for Kubernetes roles
type Role struct {
	// CustomRole: Optional. custom_role is the name of a custom
	// KubernetesClusterRole to use.
	CustomRole string `json:"customRole,omitempty"`
	// PredefinedRole: predefined_role is the Kubernetes default role to use
	//
	// Possible values:
	//   "UNKNOWN" - UNKNOWN
	//   "ADMIN" - ADMIN has EDIT and RBAC permissions
	//   "EDIT" - EDIT can edit all resources except RBAC
	//   "VIEW" - VIEW can only read resources
	//   "ANTHOS_SUPPORT" - ANTHOS_SUPPORT gives Google Support read-only access to
	// a number of cluster resources.
	PredefinedRole string `json:"predefinedRole,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CustomRole") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CustomRole") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Role) MarshalJSON() ([]byte, error) {
	type NoMethod Role
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Rollout: Rollout contains the Rollout metadata and configuration.
type Rollout struct {
	// CompleteTime: Output only. The timestamp at which the Rollout was completed.
	CompleteTime string `json:"completeTime,omitempty"`
	// CreateTime: Output only. The timestamp at which the Rollout was created.
	CreateTime string `json:"createTime,omitempty"`
	// DeleteTime: Output only. The timestamp at the Rollout was deleted.
	DeleteTime string `json:"deleteTime,omitempty"`
	// DisplayName: Optional. Human readable display name of the Rollout.
	DisplayName string `json:"displayName,omitempty"`
	// Etag: Output only. etag of the Rollout Ex. abc1234
	Etag string `json:"etag,omitempty"`
	// ExcludedClusters: Optional. Output only. The excluded clusters from the
	// rollout.
	ExcludedClusters []*ExcludedCluster `json:"excludedClusters,omitempty"`
	// Feature: Optional. Feature config to use for Rollout.
	Feature *FeatureUpdate `json:"feature,omitempty"`
	// Labels: Optional. Labels for this Rollout.
	Labels map[string]string `json:"labels,omitempty"`
	// MembershipStates: Output only. States of upgrading control plane or node
	// pool targets of a single cluster (GKE Hub membership) that's part of this
	// Rollout. The key is the membership name of the cluster. The value is the
	// state of the cluster.
	MembershipStates map[string]RolloutMembershipState `json:"membershipStates,omitempty"`
	// Name: Identifier. The full, unique resource name of this Rollout in the
	// format of `projects/{project}/locations/global/rollouts/{rollout}`.
	Name string `json:"name,omitempty"`
	// RolloutSequence: Optional. Immutable. The full, unique resource name of the
	// rollout sequence that initiatied this Rollout. In the format of
	// `projects/{project}/locations/global/rolloutSequences/{rollout_sequence}`.
	RolloutSequence string `json:"rolloutSequence,omitempty"`
	// Schedule: Output only. The schedule of the Rollout.
	Schedule *Schedule `json:"schedule,omitempty"`
	// Stages: Output only. The stages of the Rollout.
	Stages []*RolloutStage `json:"stages,omitempty"`
	// State: Output only. State specifies various states of the Rollout.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified state.
	//   "RUNNING" - The Rollout is running.
	//   "PAUSED" - The Rollout is paused.
	//   "CANCELLED" - The Rollout is in a failure terminal state.
	//   "COMPLETED" - The Rollout is in a terminal state.
	//   "SCHEDULED" - The Rollout is scheduled to start.
	State string `json:"state,omitempty"`
	// StateReason: Output only. A human-readable description explaining the reason
	// for the current state.
	StateReason string `json:"stateReason,omitempty"`
	// Uid: Output only. Google-generated UUID for this resource. This is unique
	// across all Rollout resources. If a Rollout resource is deleted and another
	// resource with the same name is created, it gets a different uid.
	Uid string `json:"uid,omitempty"`
	// UpdateTime: Output only. The timestamp at which the Rollout was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// VersionUpgrade: Optional. Config for version upgrade of clusters.
	VersionUpgrade *VersionUpgrade `json:"versionUpgrade,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CompleteTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompleteTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Rollout) MarshalJSON() ([]byte, error) {
	type NoMethod Rollout
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RolloutMembershipState: Metadata about single cluster (GKE Hub membership)
// that's part of this Rollout.
type RolloutMembershipState struct {
	// LastUpdateTime: Optional. Output only. The time this status and any related
	// Rollout-specific details for the membership were updated.
	LastUpdateTime string `json:"lastUpdateTime,omitempty"`
	// StageAssignment: Output only. The stage assignment of this cluster in this
	// rollout.
	StageAssignment int64 `json:"stageAssignment,omitempty"`
	// Targets: Output only. The targets of the rollout - clusters or node pools
	// that are being upgraded. All targets belongs to the same cluster, identified
	// by the membership name (key of membership_states map).
	Targets []*RolloutTarget `json:"targets,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LastUpdateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LastUpdateTime") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RolloutMembershipState) MarshalJSON() ([]byte, error) {
	type NoMethod RolloutMembershipState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RolloutSequence: RolloutSequence defines the desired order of upgrades.
type RolloutSequence struct {
	// CreateTime: Output only. The timestamp at which the Rollout Sequence was
	// created.
	CreateTime string `json:"createTime,omitempty"`
	// DeleteTime: Output only. The timestamp at the Rollout Sequence was deleted.
	DeleteTime string `json:"deleteTime,omitempty"`
	// DisplayName: Optional. Human readable display name of the Rollout Sequence.
	DisplayName string `json:"displayName,omitempty"`
	// Etag: Output only. etag of the Rollout Sequence Ex. abc1234
	Etag string `json:"etag,omitempty"`
	// Labels: Optional. Labels for this Rollout Sequence.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. Name of the rollout sequence in the format of:
	// projects/{PROJECT_ID}/locations/global/rolloutSequences/{NAME}
	Name string `json:"name,omitempty"`
	// Stages: Required. Ordered list of stages that constitutes this Rollout.
	Stages []*Stage `json:"stages,omitempty"`
	// Uid: Output only. Google-generated UUID for this resource. This is unique
	// across all Rollout Sequence resources. If a Rollout Sequence resource is
	// deleted and another resource with the same name is created, it gets a
	// different uid.
	Uid string `json:"uid,omitempty"`
	// UpdateTime: Output only. The timestamp at which the Rollout Sequence was
	// last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RolloutSequence) MarshalJSON() ([]byte, error) {
	type NoMethod RolloutSequence
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RolloutStage: Stage represents a single stage in the Rollout.
type RolloutStage struct {
	// EndTime: Optional. Output only. The time at which the wave ended.
	EndTime string `json:"endTime,omitempty"`
	// SoakDuration: Optional. Duration to soak after this wave before starting the
	// next wave.
	SoakDuration string `json:"soakDuration,omitempty"`
	// StageNumber: Output only. The wave number to which this status applies.
	StageNumber int64 `json:"stageNumber,omitempty"`
	// StartTime: Optional. Output only. The time at which the wave started.
	StartTime string `json:"startTime,omitempty"`
	// State: Output only. The state of the wave.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default value.
	//   "PENDING" - The wave is pending.
	//   "RUNNING" - The wave is running.
	//   "SOAKING" - The wave is soaking.
	//   "COMPLETED" - The wave is completed.
	//   "FORCED_SOAKING" - The wave is force soaking.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RolloutStage) MarshalJSON() ([]byte, error) {
	type NoMethod RolloutStage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RolloutTarget: Metadata about the status of targets (clusters or node pools)
// involved in the Rollout.
type RolloutTarget struct {
	// Cluster: Optional. Output only. The resource link of the Cluster resource
	// upgraded in this Rollout. It is formatted as:
	// `//{api_service}/projects/{project_number}/locations/{location}/clusters/{clu
	// ster_name}`. .
	Cluster string `json:"cluster,omitempty"`
	// NodePool: Optional. Output only. The resource link of the NodePool resource
	// upgraded in this Rollout. It is formatted as:
	// `//{api_service}/projects/{project_number}/locations/{location}/clusters/{clu
	// ster_name}/nodePools/{node_pool_name}`.
	NodePool string `json:"nodePool,omitempty"`
	// Operation: Optional. Output only. The operation resource name performing the
	// mutation.
	Operation string `json:"operation,omitempty"`
	// Reason: Optional. Output only. A human-readable description of the current
	// status.
	Reason string `json:"reason,omitempty"`
	// State: Output only. The high-level, machine-readable status of this Rollout
	// for the target.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified state.
	//   "PENDING" - The Rollout is pending for the target.
	//   "RUNNING" - The Rollout is running for the target.
	//   "FAILED" - The Rollout failed for the target.
	//   "SUCCEEDED" - The Rollout succeeded for the target.
	//   "PAUSED" - The Rollout is paused for the target.
	//   "REMOVED" - The target was removed from the Rollout.
	//   "INELIGIBLE" - The target is ineligible for the Rollout.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cluster") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cluster") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RolloutTarget) MarshalJSON() ([]byte, error) {
	type NoMethod RolloutTarget
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Schedule: Schedule represents the schedule of the Rollout.
type Schedule struct {
	// Waves: Output only. The schedule of each wave in the Rollout.
	Waves []*WaveSchedule `json:"waves,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Waves") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Waves") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Schedule) MarshalJSON() ([]byte, error) {
	type NoMethod Schedule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Scope: Scope represents a Scope in a Fleet.
type Scope struct {
	// CreateTime: Output only. When the scope was created.
	CreateTime string `json:"createTime,omitempty"`
	// DeleteTime: Output only. When the scope was deleted.
	DeleteTime string `json:"deleteTime,omitempty"`
	// Labels: Optional. Labels for this Scope.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: The resource name for the scope
	// `projects/{project}/locations/{location}/scopes/{scope}`
	Name string `json:"name,omitempty"`
	// NamespaceLabels: Optional. Scope-level cluster namespace labels. For the
	// member clusters bound to the Scope, these labels are applied to each
	// namespace under the Scope. Scope-level labels take precedence over
	// Namespace-level labels (`namespace_labels` in the Fleet Namespace resource)
	// if they share a key. Keys and values must be Kubernetes-conformant.
	NamespaceLabels map[string]string `json:"namespaceLabels,omitempty"`
	// State: Output only. State of the scope resource.
	State *ScopeLifecycleState `json:"state,omitempty"`
	// Uid: Output only. Google-generated UUID for this resource. This is unique
	// across all scope resources. If a scope resource is deleted and another
	// resource with the same name is created, it gets a different uid.
	Uid string `json:"uid,omitempty"`
	// UpdateTime: Output only. When the scope was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Scope) MarshalJSON() ([]byte, error) {
	type NoMethod Scope
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ScopeFeatureSpec: ScopeFeatureSpec contains feature specs for a fleet scope.
type ScopeFeatureSpec struct {
	// Clusterupgrade: Spec for the ClusterUpgrade feature at the scope level
	Clusterupgrade *ClusterUpgradeScopeSpec `json:"clusterupgrade,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Clusterupgrade") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Clusterupgrade") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ScopeFeatureSpec) MarshalJSON() ([]byte, error) {
	type NoMethod ScopeFeatureSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ScopeFeatureState: ScopeFeatureState contains Scope-wide Feature status
// information.
type ScopeFeatureState struct {
	// Clusterupgrade: State for the ClusterUpgrade feature at the scope level
	Clusterupgrade *ClusterUpgradeScopeState `json:"clusterupgrade,omitempty"`
	// State: Output only. The "running state" of the Feature in this Scope.
	State *FeatureState `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Clusterupgrade") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Clusterupgrade") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ScopeFeatureState) MarshalJSON() ([]byte, error) {
	type NoMethod ScopeFeatureState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ScopeLifecycleState: ScopeLifecycleState describes the state of a Scope
// resource.
type ScopeLifecycleState struct {
	// Code: Output only. The current state of the scope resource.
	//
	// Possible values:
	//   "CODE_UNSPECIFIED" - The code is not set.
	//   "CREATING" - The scope is being created.
	//   "READY" - The scope active.
	//   "DELETING" - The scope is being deleted.
	//   "UPDATING" - The scope is being updated.
	Code string `json:"code,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ScopeLifecycleState) MarshalJSON() ([]byte, error) {
	type NoMethod ScopeLifecycleState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SecurityPostureConfig: SecurityPostureConfig defines the flags needed to
// enable/disable features for the Security Posture API.
type SecurityPostureConfig struct {
	// Mode: Sets which mode to use for Security Posture features.
	//
	// Possible values:
	//   "MODE_UNSPECIFIED" - Default value not specified.
	//   "DISABLED" - Disables Security Posture features on the cluster.
	//   "BASIC" - Applies Security Posture features on the cluster.
	//   "ENTERPRISE" - Applies the Security Posture off cluster Enterprise level
	// features.
	Mode string `json:"mode,omitempty"`
	// VulnerabilityMode: Sets which mode to use for vulnerability scanning.
	//
	// Possible values:
	//   "VULNERABILITY_MODE_UNSPECIFIED" - Default value not specified.
	//   "VULNERABILITY_DISABLED" - Disables vulnerability scanning on the cluster.
	//   "VULNERABILITY_BASIC" - Applies basic vulnerability scanning on the
	// cluster.
	//   "VULNERABILITY_ENTERPRISE" - Applies the Security Posture's vulnerability
	// on cluster Enterprise level features.
	VulnerabilityMode string `json:"vulnerabilityMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Mode") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Mode") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SecurityPostureConfig) MarshalJSON() ([]byte, error) {
	type NoMethod SecurityPostureConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ServiceMeshAnalysisMessage: AnalysisMessage is a single message produced by
// an analyzer, and it used to communicate to the end user about the state of
// their Service Mesh configuration.
type ServiceMeshAnalysisMessage struct {
	// Args: A UI can combine these args with a template (based on
	// message_base.type) to produce an internationalized message.
	Args googleapi.RawMessage `json:"args,omitempty"`
	// Description: A human readable description of what the error means. It is
	// suitable for non-internationalize display purposes.
	Description string `json:"description,omitempty"`
	// MessageBase: Details common to all types of Istio and ServiceMesh analysis
	// messages.
	MessageBase *ServiceMeshAnalysisMessageBase `json:"messageBase,omitempty"`
	// ResourcePaths: A list of strings specifying the resource identifiers that
	// were the cause of message generation. A "path" here may be: * MEMBERSHIP_ID
	// if the cause is a specific member cluster *
	// MEMBERSHIP_ID/(NAMESPACE\/)?RESOURCETYPE/NAME if the cause is a resource in
	// a cluster
	ResourcePaths []string `json:"resourcePaths,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Args") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Args") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ServiceMeshAnalysisMessage) MarshalJSON() ([]byte, error) {
	type NoMethod ServiceMeshAnalysisMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ServiceMeshAnalysisMessageBase: AnalysisMessageBase describes some common
// information that is needed for all messages.
type ServiceMeshAnalysisMessageBase struct {
	// DocumentationUrl: A url pointing to the Service Mesh or Istio documentation
	// for this specific error type.
	DocumentationUrl string `json:"documentationUrl,omitempty"`
	// Level: Represents how severe a message is.
	//
	// Possible values:
	//   "LEVEL_UNSPECIFIED" - Illegal. Same
	// istio.analysis.v1alpha1.AnalysisMessageBase.Level.UNKNOWN.
	//   "ERROR" - ERROR represents a misconfiguration that must be fixed.
	//   "WARNING" - WARNING represents a misconfiguration that should be fixed.
	//   "INFO" - INFO represents an informational finding.
	Level string `json:"level,omitempty"`
	// Type: Represents the specific type of a message.
	Type *ServiceMeshType `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocumentationUrl") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentationUrl") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ServiceMeshAnalysisMessageBase) MarshalJSON() ([]byte, error) {
	type NoMethod ServiceMeshAnalysisMessageBase
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ServiceMeshCondition: Condition being reported.
type ServiceMeshCondition struct {
	// Code: Unique identifier of the condition which describes the condition
	// recognizable to the user.
	//
	// Possible values:
	//   "CODE_UNSPECIFIED" - Default Unspecified code
	//   "MESH_IAM_PERMISSION_DENIED" - Mesh IAM permission denied error code
	//   "MESH_IAM_CROSS_PROJECT_PERMISSION_DENIED" - Permission denied error code
	// for cross-project
	//   "CNI_CONFIG_UNSUPPORTED" - CNI config unsupported error code
	//   "GKE_SANDBOX_UNSUPPORTED" - GKE sandbox unsupported error code
	//   "NODEPOOL_WORKLOAD_IDENTITY_FEDERATION_REQUIRED" - Nodepool workload
	// identity federation required error code
	//   "CNI_INSTALLATION_FAILED" - CNI installation failed error code
	//   "CNI_POD_UNSCHEDULABLE" - CNI pod unschedulable error code
	//   "CLUSTER_HAS_ZERO_NODES" - Cluster has zero node code
	//   "CANONICAL_SERVICE_ERROR" - Failure to reconcile CanonicalServices
	//   "UNSUPPORTED_MULTIPLE_CONTROL_PLANES" - Multiple control planes
	// unsupported error code
	//   "VPCSC_GA_SUPPORTED" - VPC-SC GA is supported for this control plane.
	//   "DEPRECATED_SPEC_CONTROL_PLANE_MANAGEMENT" - User is using deprecated
	// ControlPlaneManagement and they have not yet set Management.
	//   "DEPRECATED_SPEC_CONTROL_PLANE_MANAGEMENT_SAFE" - User is using deprecated
	// ControlPlaneManagement and they have already set Management.
	//   "CONFIG_APPLY_INTERNAL_ERROR" - Configuration (Istio/k8s resources) failed
	// to apply due to internal error.
	//   "CONFIG_VALIDATION_ERROR" - Configuration failed to be applied due to
	// being invalid.
	//   "CONFIG_VALIDATION_WARNING" - Encountered configuration(s) with possible
	// unintended behavior or invalid configuration. These configs may not have
	// been applied.
	//   "QUOTA_EXCEEDED_BACKEND_SERVICES" - BackendService quota exceeded error
	// code.
	//   "QUOTA_EXCEEDED_HEALTH_CHECKS" - HealthCheck quota exceeded error code.
	//   "QUOTA_EXCEEDED_HTTP_ROUTES" - HTTPRoute quota exceeded error code.
	//   "QUOTA_EXCEEDED_TCP_ROUTES" - TCPRoute quota exceeded error code.
	//   "QUOTA_EXCEEDED_TLS_ROUTES" - TLS routes quota exceeded error code.
	//   "QUOTA_EXCEEDED_TRAFFIC_POLICIES" - TrafficPolicy quota exceeded error
	// code.
	//   "QUOTA_EXCEEDED_ENDPOINT_POLICIES" - EndpointPolicy quota exceeded error
	// code.
	//   "QUOTA_EXCEEDED_GATEWAYS" - Gateway quota exceeded error code.
	//   "QUOTA_EXCEEDED_MESHES" - Mesh quota exceeded error code.
	//   "QUOTA_EXCEEDED_SERVER_TLS_POLICIES" - ServerTLSPolicy quota exceeded
	// error code.
	//   "QUOTA_EXCEEDED_CLIENT_TLS_POLICIES" - ClientTLSPolicy quota exceeded
	// error code.
	//   "QUOTA_EXCEEDED_SERVICE_LB_POLICIES" - ServiceLBPolicy quota exceeded
	// error code.
	//   "QUOTA_EXCEEDED_HTTP_FILTERS" - HTTPFilter quota exceeded error code.
	//   "QUOTA_EXCEEDED_TCP_FILTERS" - TCPFilter quota exceeded error code.
	//   "QUOTA_EXCEEDED_NETWORK_ENDPOINT_GROUPS" - NetworkEndpointGroup quota
	// exceeded error code.
	//   "LEGACY_MC_SECRETS" - Legacy istio secrets found for multicluster error
	// code
	//   "WORKLOAD_IDENTITY_REQUIRED" - Workload identity required error code
	//   "NON_STANDARD_BINARY_USAGE" - Non-standard binary usage error code
	//   "UNSUPPORTED_GATEWAY_CLASS" - Unsupported gateway class error code
	//   "MANAGED_CNI_NOT_ENABLED" - Managed CNI not enabled error code
	//   "MODERNIZATION_SCHEDULED" - Modernization is scheduled for a cluster.
	//   "MODERNIZATION_IN_PROGRESS" - Modernization is in progress for a cluster.
	//   "MODERNIZATION_COMPLETED" - Modernization is completed for a cluster.
	//   "MODERNIZATION_ABORTED" - Modernization is aborted for a cluster.
	//   "MODERNIZATION_PREPARING" - Preparing cluster so that its workloads can be
	// migrated.
	//   "MODERNIZATION_STALLED" - Modernization is stalled for a cluster.
	//   "MODERNIZATION_PREPARED" - Cluster has been prepared for its workloads to
	// be migrated.
	//   "MODERNIZATION_MIGRATING_WORKLOADS" - Migrating the cluster's workloads to
	// the new implementation.
	//   "MODERNIZATION_ROLLING_BACK_CLUSTER" - Rollback is in progress for
	// modernization of a cluster.
	//   "MODERNIZATION_WILL_BE_SCHEDULED" - Modernization will be scheduled for a
	// fleet.
	//   "MODERNIZATION_MANUAL" - Fleet is opted out from automated modernization.
	//   "MODERNIZATION_ELIGIBLE" - Fleet is eligible for modernization.
	//   "MODERNIZATION_MODERNIZING" - Modernization of one or more clusters in a
	// fleet is in progress.
	//   "MODERNIZATION_MODERNIZED_SOAKING" - Modernization of all the fleet's
	// clusters is complete. Soaking before finalizing the modernization.
	//   "MODERNIZATION_FINALIZED" - Modernization is finalized for all clusters in
	// a fleet. Rollback is no longer allowed.
	//   "MODERNIZATION_ROLLING_BACK_FLEET" - Rollback is in progress for
	// modernization of all clusters in a fleet.
	Code string `json:"code,omitempty"`
	// Details: A short summary about the issue.
	Details string `json:"details,omitempty"`
	// DocumentationLink: Links contains actionable information.
	DocumentationLink string `json:"documentationLink,omitempty"`
	// Severity: Severity level of the condition.
	//
	// Possible values:
	//   "SEVERITY_UNSPECIFIED" - Unspecified severity
	//   "ERROR" - Indicates an issue that prevents the mesh from operating
	// correctly
	//   "WARNING" - Indicates a setting is likely wrong, but the mesh is still
	// able to operate
	//   "INFO" - An informational message, not requiring any action
	Severity string `json:"severity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ServiceMeshCondition) MarshalJSON() ([]byte, error) {
	type NoMethod ServiceMeshCondition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ServiceMeshControlPlaneManagement: Status of control plane management.
type ServiceMeshControlPlaneManagement struct {
	// Details: Explanation of state.
	Details []*ServiceMeshStatusDetails `json:"details,omitempty"`
	// Implementation: Output only. Implementation of managed control plane.
	//
	// Possible values:
	//   "IMPLEMENTATION_UNSPECIFIED" - Unspecified
	//   "ISTIOD" - A Google build of istiod is used for the managed control plane.
	//   "TRAFFIC_DIRECTOR" - Traffic director is used for the managed control
	// plane.
	//   "UPDATING" - The control plane implementation is being updated.
	Implementation string `json:"implementation,omitempty"`
	// State: LifecycleState of control plane management.
	//
	// Possible values:
	//   "LIFECYCLE_STATE_UNSPECIFIED" - Unspecified
	//   "DISABLED" - DISABLED means that the component is not enabled.
	//   "FAILED_PRECONDITION" - FAILED_PRECONDITION means that provisioning cannot
	// proceed because of some characteristic of the member cluster.
	//   "PROVISIONING" - PROVISIONING means that provisioning is in progress.
	//   "ACTIVE" - ACTIVE means that the component is ready for use.
	//   "STALLED" - STALLED means that provisioning could not be done.
	//   "NEEDS_ATTENTION" - NEEDS_ATTENTION means that the component is ready, but
	// some user intervention is required. (For example that the user should
	// migrate workloads to a new control plane revision.)
	//   "DEGRADED" - DEGRADED means that the component is ready, but operating in
	// a degraded state.
	//   "DEPROVISIONING" - DEPROVISIONING means that deprovisioning is in
	// progress.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Details") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Details") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ServiceMeshControlPlaneManagement) MarshalJSON() ([]byte, error) {
	type NoMethod ServiceMeshControlPlaneManagement
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ServiceMeshDataPlaneManagement: Status of data plane management. Only
// reported per-member.
type ServiceMeshDataPlaneManagement struct {
	// Details: Explanation of the status.
	Details []*ServiceMeshStatusDetails `json:"details,omitempty"`
	// State: Lifecycle status of data plane management.
	//
	// Possible values:
	//   "LIFECYCLE_STATE_UNSPECIFIED" - Unspecified
	//   "DISABLED" - DISABLED means that the component is not enabled.
	//   "FAILED_PRECONDITION" - FAILED_PRECONDITION means that provisioning cannot
	// proceed because of some characteristic of the member cluster.
	//   "PROVISIONING" - PROVISIONING means that provisioning is in progress.
	//   "ACTIVE" - ACTIVE means that the component is ready for use.
	//   "STALLED" - STALLED means that provisioning could not be done.
	//   "NEEDS_ATTENTION" - NEEDS_ATTENTION means that the component is ready, but
	// some user intervention is required. (For example that the user should
	// migrate workloads to a new control plane revision.)
	//   "DEGRADED" - DEGRADED means that the component is ready, but operating in
	// a degraded state.
	//   "DEPROVISIONING" - DEPROVISIONING means that deprovisioning is in
	// progress.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Details") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Details") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ServiceMeshDataPlaneManagement) MarshalJSON() ([]byte, error) {
	type NoMethod ServiceMeshDataPlaneManagement
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ServiceMeshFeatureCondition: Condition being reported.
type ServiceMeshFeatureCondition struct {
	// Code: Unique identifier of the condition which describes the condition
	// recognizable to the user.
	//
	// Possible values:
	//   "CODE_UNSPECIFIED" - Default Unspecified code
	//   "MESH_IAM_PERMISSION_DENIED" - Mesh IAM permission denied error code
	//   "MESH_IAM_CROSS_PROJECT_PERMISSION_DENIED" - Permission denied error code
	// for cross-project
	//   "CNI_CONFIG_UNSUPPORTED" - CNI config unsupported error code
	//   "GKE_SANDBOX_UNSUPPORTED" - GKE sandbox unsupported error code
	//   "NODEPOOL_WORKLOAD_IDENTITY_FEDERATION_REQUIRED" - Nodepool workload
	// identity federation required error code
	//   "CNI_INSTALLATION_FAILED" - CNI installation failed error code
	//   "CNI_POD_UNSCHEDULABLE" - CNI pod unschedulable error code
	//   "CLUSTER_HAS_ZERO_NODES" - Cluster has zero node code
	//   "CANONICAL_SERVICE_ERROR" - Failure to reconcile CanonicalServices
	//   "UNSUPPORTED_MULTIPLE_CONTROL_PLANES" - Multiple control planes
	// unsupported error code
	//   "VPCSC_GA_SUPPORTED" - VPC-SC GA is supported for this control plane.
	//   "DEPRECATED_SPEC_CONTROL_PLANE_MANAGEMENT" - User is using deprecated
	// ControlPlaneManagement and they have not yet set Management.
	//   "DEPRECATED_SPEC_CONTROL_PLANE_MANAGEMENT_SAFE" - User is using deprecated
	// ControlPlaneManagement and they have already set Management.
	//   "CONFIG_APPLY_INTERNAL_ERROR" - Configuration (Istio/k8s resources) failed
	// to apply due to internal error.
	//   "CONFIG_VALIDATION_ERROR" - Configuration failed to be applied due to
	// being invalid.
	//   "CONFIG_VALIDATION_WARNING" - Encountered configuration(s) with possible
	// unintended behavior or invalid configuration. These configs may not have
	// been applied.
	//   "QUOTA_EXCEEDED_BACKEND_SERVICES" - BackendService quota exceeded error
	// code.
	//   "QUOTA_EXCEEDED_HEALTH_CHECKS" - HealthCheck quota exceeded error code.
	//   "QUOTA_EXCEEDED_HTTP_ROUTES" - HTTPRoute quota exceeded error code.
	//   "QUOTA_EXCEEDED_TCP_ROUTES" - TCPRoute quota exceeded error code.
	//   "QUOTA_EXCEEDED_TLS_ROUTES" - TLS routes quota exceeded error code.
	//   "QUOTA_EXCEEDED_TRAFFIC_POLICIES" - TrafficPolicy quota exceeded error
	// code.
	//   "QUOTA_EXCEEDED_ENDPOINT_POLICIES" - EndpointPolicy quota exceeded error
	// code.
	//   "QUOTA_EXCEEDED_GATEWAYS" - Gateway quota exceeded error code.
	//   "QUOTA_EXCEEDED_MESHES" - Mesh quota exceeded error code.
	//   "QUOTA_EXCEEDED_SERVER_TLS_POLICIES" - ServerTLSPolicy quota exceeded
	// error code.
	//   "QUOTA_EXCEEDED_CLIENT_TLS_POLICIES" - ClientTLSPolicy quota exceeded
	// error code.
	//   "QUOTA_EXCEEDED_SERVICE_LB_POLICIES" - ServiceLBPolicy quota exceeded
	// error code.
	//   "QUOTA_EXCEEDED_HTTP_FILTERS" - HTTPFilter quota exceeded error code.
	//   "QUOTA_EXCEEDED_TCP_FILTERS" - TCPFilter quota exceeded error code.
	//   "QUOTA_EXCEEDED_NETWORK_ENDPOINT_GROUPS" - NetworkEndpointGroup quota
	// exceeded error code.
	//   "LEGACY_MC_SECRETS" - Legacy istio secrets found for multicluster error
	// code.
	//   "WORKLOAD_IDENTITY_REQUIRED" - Workload identity required error code.
	//   "NON_STANDARD_BINARY_USAGE" - Non-standard binary usage error code.
	//   "UNSUPPORTED_GATEWAY_CLASS" - Unsupported gateway class error code.
	//   "MANAGED_CNI_NOT_ENABLED" - Managed CNI not enabled error code.
	//   "MODERNIZATION_SCHEDULED" - Modernization is scheduled for a cluster.
	//   "MODERNIZATION_IN_PROGRESS" - Modernization is in progress for a cluster.
	//   "MODERNIZATION_COMPLETED" - Modernization is completed for a cluster.
	//   "MODERNIZATION_ABORTED" - Modernization is aborted for a cluster.
	//   "MODERNIZATION_PREPARING" - Preparing cluster so that its workloads can be
	// migrated.
	//   "MODERNIZATION_STALLED" - Modernization is stalled for a cluster.
	//   "MODERNIZATION_PREPARED" - Cluster has been prepared for its workloads to
	// be migrated.
	//   "MODERNIZATION_MIGRATING_WORKLOADS" - Migrating the cluster's workloads to
	// the new implementation.
	//   "MODERNIZATION_ROLLING_BACK_CLUSTER" - Rollback is in progress for
	// modernization of a cluster.
	//   "MODERNIZATION_WILL_BE_SCHEDULED" - Modernization will be scheduled for a
	// fleet.
	//   "MODERNIZATION_MANUAL" - Fleet is opted out from automated modernization.
	//   "MODERNIZATION_ELIGIBLE" - Fleet is eligible for modernization.
	//   "MODERNIZATION_MODERNIZING" - Modernization of one or more clusters in a
	// fleet is in progress.
	//   "MODERNIZATION_MODERNIZED_SOAKING" - Modernization of all the fleet's
	// clusters is complete. Soaking before finalizing the modernization.
	//   "MODERNIZATION_FINALIZED" - Modernization is finalized for all clusters in
	// a fleet. Rollback is no longer allowed.
	//   "MODERNIZATION_ROLLING_BACK_FLEET" - Rollback is in progress for
	// modernization of all clusters in a fleet.
	Code string `json:"code,omitempty"`
	// Details: A short summary about the issue.
	Details string `json:"details,omitempty"`
	// DocumentationLink: Links contains actionable information.
	DocumentationLink string `json:"documentationLink,omitempty"`
	// Severity: Severity level of the condition.
	//
	// Possible values:
	//   "SEVERITY_UNSPECIFIED" - Unspecified severity
	//   "ERROR" - Indicates an issue that prevents the mesh from operating
	// correctly
	//   "WARNING" - Indicates a setting is likely wrong, but the mesh is still
	// able to operate
	//   "INFO" - An informational message, not requiring any action
	Severity string `json:"severity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ServiceMeshFeatureCondition) MarshalJSON() ([]byte, error) {
	type NoMethod ServiceMeshFeatureCondition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ServiceMeshFeatureState: **Service Mesh**: State for the whole Hub, as
// analyzed by the Service Mesh Hub Controller.
type ServiceMeshFeatureState struct {
	// AnalysisMessages: Output only. Results of running Service Mesh analyzers.
	AnalysisMessages []*ServiceMeshAnalysisMessage `json:"analysisMessages,omitempty"`
	// Conditions: Output only. List of conditions reported for this feature.
	Conditions []*ServiceMeshFeatureCondition `json:"conditions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnalysisMessages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalysisMessages") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ServiceMeshFeatureState) MarshalJSON() ([]byte, error) {
	type NoMethod ServiceMeshFeatureState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ServiceMeshMembershipSpec: **Service Mesh**: Spec for a single Membership
// for the servicemesh feature
type ServiceMeshMembershipSpec struct {
	// ConfigApi: Optional. Specifies the API that will be used for configuring the
	// mesh workloads.
	//
	// Possible values:
	//   "CONFIG_API_UNSPECIFIED" - Unspecified
	//   "CONFIG_API_ISTIO" - Use the Istio API for configuration.
	//   "CONFIG_API_GATEWAY" - Use the K8s Gateway API for configuration.
	ConfigApi string `json:"configApi,omitempty"`
	// ControlPlane: Deprecated: use `management` instead Enables automatic control
	// plane management.
	//
	// Possible values:
	//   "CONTROL_PLANE_MANAGEMENT_UNSPECIFIED" - Unspecified
	//   "AUTOMATIC" - Google should provision a control plane revision and make it
	// available in the cluster. Google will enroll this revision in a release
	// channel and keep it up to date. The control plane revision may be a managed
	// service, or a managed install.
	//   "MANUAL" - User will manually configure the control plane (e.g. via CLI,
	// or via the ControlPlaneRevision KRM API)
	ControlPlane string `json:"controlPlane,omitempty"`
	// DefaultChannel: Determines which release channel to use for default
	// injection and service mesh APIs.
	//
	// Possible values:
	//   "CHANNEL_UNSPECIFIED" - Unspecified
	//   "RAPID" - RAPID channel is offered on an early access basis for customers
	// who want to test new releases.
	//   "REGULAR" - REGULAR channel is intended for production users who want to
	// take advantage of new features.
	//   "STABLE" - STABLE channel includes versions that are known to be stable
	// and reliable in production.
	DefaultChannel string `json:"defaultChannel,omitempty"`
	// Management: Optional. Enables automatic Service Mesh management.
	//
	// Possible values:
	//   "MANAGEMENT_UNSPECIFIED" - Unspecified
	//   "MANAGEMENT_AUTOMATIC" - Google should manage my Service Mesh for the
	// cluster.
	//   "MANAGEMENT_MANUAL" - User will manually configure their service mesh
	// components.
	//   "MANAGEMENT_NOT_INSTALLED" - Google should remove any managed Service Mesh
	// components from this cluster and deprovision any resources.
	Management string `json:"management,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfigApi") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfigApi") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ServiceMeshMembershipSpec) MarshalJSON() ([]byte, error) {
	type NoMethod ServiceMeshMembershipSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ServiceMeshMembershipState: **Service Mesh**: State for a single Membership,
// as analyzed by the Service Mesh Hub Controller.
type ServiceMeshMembershipState struct {
	// AnalysisMessages: Output only. Results of running Service Mesh analyzers.
	AnalysisMessages []*ServiceMeshAnalysisMessage `json:"analysisMessages,omitempty"`
	// Conditions: Output only. List of conditions reported for this membership.
	Conditions []*ServiceMeshCondition `json:"conditions,omitempty"`
	// ConfigApiVersion: The API version (i.e. Istio CRD version) for configuring
	// service mesh in this cluster. This version is influenced by the
	// `default_channel` field.
	ConfigApiVersion string `json:"configApiVersion,omitempty"`
	// ControlPlaneManagement: Output only. Status of control plane management
	ControlPlaneManagement *ServiceMeshControlPlaneManagement `json:"controlPlaneManagement,omitempty"`
	// DataPlaneManagement: Output only. Status of data plane management.
	DataPlaneManagement *ServiceMeshDataPlaneManagement `json:"dataPlaneManagement,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnalysisMessages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalysisMessages") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ServiceMeshMembershipState) MarshalJSON() ([]byte, error) {
	type NoMethod ServiceMeshMembershipState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ServiceMeshStatusDetails: Structured and human-readable details for a
// status.
type ServiceMeshStatusDetails struct {
	// Code: A machine-readable code that further describes a broad status.
	Code string `json:"code,omitempty"`
	// Details: Human-readable explanation of code.
	Details string `json:"details,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ServiceMeshStatusDetails) MarshalJSON() ([]byte, error) {
	type NoMethod ServiceMeshStatusDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ServiceMeshType: A unique identifier for the type of message. Display_name
// is intended to be human-readable, code is intended to be machine readable.
// There should be a one-to-one mapping between display_name and code. (i.e. do
// not re-use display_names or codes between message types.) See
// istio.analysis.v1alpha1.AnalysisMessageBase.Type
type ServiceMeshType struct {
	// Code: A 7 character code matching `^IST[0-9]{4}$` or `^ASM[0-9]{4}$`,
	// intended to uniquely identify the message type. (e.g. "IST0001" is mapped to
	// the "InternalError" message type.)
	Code string `json:"code,omitempty"`
	// DisplayName: A human-readable name for the message type. e.g.
	// "InternalError", "PodMissingProxy". This should be the same for all messages
	// of the same type. (This corresponds to the `name` field in open-source
	// Istio.)
	DisplayName string `json:"displayName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ServiceMeshType) MarshalJSON() ([]byte, error) {
	type NoMethod ServiceMeshType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SetIamPolicyRequest: Request message for `SetIamPolicy` method.
type SetIamPolicyRequest struct {
	// Policy: REQUIRED: The complete policy to be applied to the `resource`. The
	// size of the policy is limited to a few 10s of KB. An empty policy is a valid
	// policy but certain Google Cloud services (such as Projects) might reject
	// them.
	Policy *Policy `json:"policy,omitempty"`
	// UpdateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
	// modify. Only the fields in the mask will be modified. If no mask is
	// provided, the following default mask is used: `paths: "bindings, etag"
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Policy") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Policy") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SetIamPolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SetIamPolicyRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Stage: Rollout stage.
type Stage struct {
	// ClusterSelector: Optional. Filter members of fleets (above) to a subset of
	// clusters. If not specified, all clusters in the fleets are selected.
	ClusterSelector *ClusterSelector `json:"clusterSelector,omitempty"`
	// FleetProjects: Required. List of Fleet projects to select the clusters from.
	// Expected format: projects/{project}
	FleetProjects []string `json:"fleetProjects,omitempty"`
	// SoakDuration: Optional. Soak time after upgrading all the clusters in the
	// stage.
	SoakDuration string `json:"soakDuration,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClusterSelector") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClusterSelector") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Stage) MarshalJSON() ([]byte, error) {
	type NoMethod Stage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Status: Status specifies state for the subcomponent.
type Status struct {
	// Code: Code specifies AppDevExperienceFeature's subcomponent ready state.
	//
	// Possible values:
	//   "CODE_UNSPECIFIED" - Not set.
	//   "OK" - AppDevExperienceFeature's specified subcomponent is ready.
	//   "FAILED" - AppDevExperienceFeature's specified subcomponent ready state is
	// false. This means AppDevExperienceFeature has encountered an issue that
	// blocks all, or a portion, of its normal operation. See the `description` for
	// more details.
	//   "UNKNOWN" - AppDevExperienceFeature's specified subcomponent has a pending
	// or unknown state.
	Code string `json:"code,omitempty"`
	// Description: Description is populated if Code is Failed, explaining why it
	// has failed.
	Description string `json:"description,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TestIamPermissionsRequest: Request message for `TestIamPermissions` method.
type TestIamPermissionsRequest struct {
	// Permissions: The set of permissions to check for the `resource`. Permissions
	// with wildcards (such as `*` or `storage.*`) are not allowed. For more
	// information see IAM Overview
	// (https://cloud.google.com/iam/docs/overview#permissions).
	Permissions []string `json:"permissions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Permissions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TestIamPermissionsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod TestIamPermissionsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TestIamPermissionsResponse: Response message for `TestIamPermissions`
// method.
type TestIamPermissionsResponse struct {
	// Permissions: A subset of `TestPermissionsRequest.permissions` that the
	// caller is allowed.
	Permissions []string `json:"permissions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Permissions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TestIamPermissionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod TestIamPermissionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TypeMeta: TypeMeta is the type information needed for content unmarshalling
// of Kubernetes resources in the manifest.
type TypeMeta struct {
	// ApiVersion: APIVersion of the resource (e.g. v1).
	ApiVersion string `json:"apiVersion,omitempty"`
	// Kind: Kind of the resource (e.g. Deployment).
	Kind string `json:"kind,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TypeMeta) MarshalJSON() ([]byte, error) {
	type NoMethod TypeMeta
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ValidateCreateMembershipRequest: Request message for the
// `GkeHub.ValidateCreateMembership` method.
type ValidateCreateMembershipRequest struct {
	// Membership: Required. Membership resource to be created.
	Membership *Membership `json:"membership,omitempty"`
	// MembershipId: Required. Client chosen membership id.
	MembershipId string `json:"membershipId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Membership") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Membership") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ValidateCreateMembershipRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ValidateCreateMembershipRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ValidateCreateMembershipResponse: Response message for the
// `GkeHub.ValidateCreateMembership` method.
type ValidateCreateMembershipResponse struct {
	// ValidationResults: Wraps all the validator results.
	ValidationResults []*ValidationResult `json:"validationResults,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ValidationResults") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ValidationResults") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ValidateCreateMembershipResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ValidateCreateMembershipResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ValidateExclusivityResponse: The response of exclusivity artifacts
// validation result status.
type ValidateExclusivityResponse struct {
	// Status: The validation result. * `OK` means that exclusivity is validated,
	// assuming the manifest produced by GenerateExclusivityManifest is
	// successfully applied. * `ALREADY_EXISTS` means that the Membership CRD is
	// already owned by another Hub. See `status.message` for more information.
	Status *GoogleRpcStatus `json:"status,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Status") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Status") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ValidateExclusivityResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ValidateExclusivityResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ValidationResult: ValidationResults are results set by each validator
// running during ValidateCreateMembership.
type ValidationResult struct {
	// Result: Additional information for the validation.
	Result string `json:"result,omitempty"`
	// Success: Whether the validation is passed or not.
	Success bool `json:"success,omitempty"`
	// Validator: Validator type to validate membership with.
	//
	// Possible values:
	//   "VALIDATOR_TYPE_UNSPECIFIED" - UNSPECIFIED validator.
	//   "MEMBERSHIP_ID" - MEMBERSHIP_ID validator validates that the membership_id
	// is still available.
	//   "CROSS_PROJECT_PERMISSION" - CROSS_PROJECT_PERMISSION validator validates
	// that the cross-project role binding for the service agent is in place.
	//   "FLEET_ALLOWED_FOR_PROJECT_GUARDRAIL" -
	// FLEET_ALLOWED_FOR_PROJECT_GUARDRAIL validator validates that the fleet
	// project is allowed for the project guardrail.
	Validator string `json:"validator,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Result") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Result") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ValidationResult) MarshalJSON() ([]byte, error) {
	type NoMethod ValidationResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// VersionUpgrade: Config for version upgrade of clusters.
type VersionUpgrade struct {
	// DesiredVersion: Optional. Desired version of the component.
	DesiredVersion string `json:"desiredVersion,omitempty"`
	// Type: Optional. Type of version upgrade specifies which component should be
	// upgraded.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Default value.
	//   "TYPE_CONTROL_PLANE" - Control plane upgrade.
	//   "TYPE_NODE_POOL" - Node pool upgrade.
	//   "TYPE_CONFIG_SYNC" - Config Sync upgrade.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DesiredVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DesiredVersion") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VersionUpgrade) MarshalJSON() ([]byte, error) {
	type NoMethod VersionUpgrade
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WaveSchedule: WaveSchedule represents the schedule of a single rollout wave.
type WaveSchedule struct {
	// WaveEndTime: Output only. The time at which the wave ends.
	WaveEndTime string `json:"waveEndTime,omitempty"`
	// WaveNumber: Output only. The wave number to which this schedule applies.
	WaveNumber int64 `json:"waveNumber,omitempty"`
	// WaveStartTime: Output only. The time at which the wave starts.
	WaveStartTime string `json:"waveStartTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "WaveEndTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "WaveEndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WaveSchedule) MarshalJSON() ([]byte, error) {
	type NoMethod WaveSchedule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WorkloadIdentityFeatureSpec: **WorkloadIdentity**: Global feature
// specification.
type WorkloadIdentityFeatureSpec struct {
	// ScopeTenancyPool: Pool to be used for Workload Identity. This pool in
	// trust-domain mode is used with Fleet Tenancy, so that sameness can be
	// enforced. ex:
	// projects/example/locations/global/workloadidentitypools/custompool
	ScopeTenancyPool string `json:"scopeTenancyPool,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ScopeTenancyPool") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ScopeTenancyPool") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WorkloadIdentityFeatureSpec) MarshalJSON() ([]byte, error) {
	type NoMethod WorkloadIdentityFeatureSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WorkloadIdentityFeatureState: **WorkloadIdentity**: Global feature state.
type WorkloadIdentityFeatureState struct {
	// NamespaceStateDetails: The state of the IAM namespaces for the fleet.
	NamespaceStateDetails map[string]WorkloadIdentityNamespaceStateDetail `json:"namespaceStateDetails,omitempty"`
	// NamespaceStates: Deprecated, this field will be erased after code is changed
	// to use the new field.
	NamespaceStates map[string]string `json:"namespaceStates,omitempty"`
	// ScopeTenancyWorkloadIdentityPool: The full name of the scope-tenancy pool
	// for the fleet.
	ScopeTenancyWorkloadIdentityPool string `json:"scopeTenancyWorkloadIdentityPool,omitempty"`
	// WorkloadIdentityPool: The full name of the svc.id.goog pool for the fleet.
	WorkloadIdentityPool string `json:"workloadIdentityPool,omitempty"`
	// WorkloadIdentityPoolStateDetails: The state of the Workload Identity Pools
	// for the fleet.
	WorkloadIdentityPoolStateDetails map[string]WorkloadIdentityWorkloadIdentityPoolStateDetail `json:"workloadIdentityPoolStateDetails,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NamespaceStateDetails") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NamespaceStateDetails") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WorkloadIdentityFeatureState) MarshalJSON() ([]byte, error) {
	type NoMethod WorkloadIdentityFeatureState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WorkloadIdentityIdentityProviderStateDetail: IdentityProviderStateDetail
// represents the state of an Identity Provider.
type WorkloadIdentityIdentityProviderStateDetail struct {
	// Code: The state of the Identity Provider.
	//
	// Possible values:
	//   "IDENTITY_PROVIDER_STATE_UNSPECIFIED" - Unknown state.
	//   "IDENTITY_PROVIDER_STATE_OK" - The Identity Provider was created/updated
	// successfully.
	//   "IDENTITY_PROVIDER_STATE_ERROR" - The Identity Provider was not
	// created/updated successfully. The error message is in the description field.
	Code string `json:"code,omitempty"`
	// Description: A human-readable description of the current state or returned
	// error.
	Description string `json:"description,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WorkloadIdentityIdentityProviderStateDetail) MarshalJSON() ([]byte, error) {
	type NoMethod WorkloadIdentityIdentityProviderStateDetail
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WorkloadIdentityMembershipState: **WorkloadIdentity**: The
// membership-specific state for WorkloadIdentity feature.
type WorkloadIdentityMembershipState struct {
	// Description: Deprecated, this field will be erased after code is changed to
	// use the new field.
	Description string `json:"description,omitempty"`
	// IdentityProviderStateDetails: The state of the Identity Providers
	// corresponding to the membership.
	IdentityProviderStateDetails map[string]WorkloadIdentityIdentityProviderStateDetail `json:"identityProviderStateDetails,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WorkloadIdentityMembershipState) MarshalJSON() ([]byte, error) {
	type NoMethod WorkloadIdentityMembershipState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WorkloadIdentityNamespaceStateDetail: NamespaceStateDetail represents the
// state of a IAM namespace.
type WorkloadIdentityNamespaceStateDetail struct {
	// Code: The state of the IAM namespace.
	//
	// Possible values:
	//   "NAMESPACE_STATE_UNSPECIFIED" - Unknown state.
	//   "NAMESPACE_STATE_OK" - The Namespace was created/updated successfully.
	//   "NAMESPACE_STATE_ERROR" - The Namespace was not created/updated
	// successfully. The error message is in the description field.
	Code string `json:"code,omitempty"`
	// Description: A human-readable description of the current state or returned
	// error.
	Description string `json:"description,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WorkloadIdentityNamespaceStateDetail) MarshalJSON() ([]byte, error) {
	type NoMethod WorkloadIdentityNamespaceStateDetail
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WorkloadIdentityWorkloadIdentityPoolStateDetail:
// WorkloadIdentityPoolStateDetail represents the state of the Workload
// Identity Pools for the fleet.
type WorkloadIdentityWorkloadIdentityPoolStateDetail struct {
	// Code: The state of the Workload Identity Pool.
	//
	// Possible values:
	//   "WORKLOAD_IDENTITY_POOL_STATE_UNSPECIFIED" - Unknown state.
	//   "WORKLOAD_IDENTITY_POOL_STATE_OK" - The Workload Identity Pool was
	// created/updated successfully.
	//   "WORKLOAD_IDENTITY_POOL_STATE_ERROR" - The Workload Identity Pool was not
	// created/updated successfully. The error message is in the description field.
	Code string `json:"code,omitempty"`
	// Description: A human-readable description of the current state or returned
	// error.
	Description string `json:"description,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WorkloadIdentityWorkloadIdentityPoolStateDetail) MarshalJSON() ([]byte, error) {
	type NoMethod WorkloadIdentityWorkloadIdentityPoolStateDetail
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type OrganizationsLocationsFleetsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns all fleets within an organization or a project that the caller
// has access to.
//
//   - parent: The organization or project to list for Fleets under, in the
//     format `organizations/*/locations/*` or `projects/*/locations/*`.
func (r *OrganizationsLocationsFleetsService) List(parent string) *OrganizationsLocationsFleetsListCall {
	c := &OrganizationsLocationsFleetsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// fleets to return. The service may return fewer than this value. If
// unspecified, at most 200 fleets will be returned. The maximum value is 1000;
// values above 1000 will be coerced to 1000.
func (c *OrganizationsLocationsFleetsListCall) PageSize(pageSize int64) *OrganizationsLocationsFleetsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListFleets` call. Provide this to retrieve the subsequent
// page. When paginating, all other parameters provided to `ListFleets` must
// match the call that provided the page token.
func (c *OrganizationsLocationsFleetsListCall) PageToken(pageToken string) *OrganizationsLocationsFleetsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsFleetsListCall) Fields(s ...googleapi.Field) *OrganizationsLocationsFleetsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsFleetsListCall) IfNoneMatch(entityTag string) *OrganizationsLocationsFleetsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsFleetsListCall) Context(ctx context.Context) *OrganizationsLocationsFleetsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsFleetsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsFleetsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/fleets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.organizations.locations.fleets.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.organizations.locations.fleets.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListFleetsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsLocationsFleetsListCall) Do(opts ...googleapi.CallOption) (*ListFleetsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListFleetsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.organizations.locations.fleets.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsFleetsListCall) Pages(ctx context.Context, f func(*ListFleetsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a location.
//
// - name: Resource name for the location.
func (r *ProjectsLocationsService) Get(name string) *ProjectsLocationsGetCall {
	c := &ProjectsLocationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGetCall) Context(ctx context.Context) *ProjectsLocationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Location.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGetCall) Do(opts ...googleapi.CallOption) (*Location, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Location{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists information about the supported locations for this service. This
// method can be called in two ways: * **List all public locations:** Use the
// path `GET /v1/locations`. * **List project-visible locations:** Use the path
// `GET /v1/projects/{project_id}/locations`. This may include public locations
// as well as private or other locations specifically visible to the project.
//
// - name: The resource that owns the locations collection, if applicable.
func (r *ProjectsLocationsService) List(name string) *ProjectsLocationsListCall {
	c := &ProjectsLocationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ExtraLocationTypes sets the optional parameter "extraLocationTypes": Do not
// use this field. It is unsupported and is ignored unless explicitly
// documented otherwise. This is primarily for internal usage.
func (c *ProjectsLocationsListCall) ExtraLocationTypes(extraLocationTypes ...string) *ProjectsLocationsListCall {
	c.urlParams_.SetMulti("extraLocationTypes", append([]string{}, extraLocationTypes...))
	return c
}

// Filter sets the optional parameter "filter": A filter to narrow down results
// to a preferred subset. The filtering language accepts strings like
// "displayName=tokyo", and is documented in more detail in AIP-160
// (https://google.aip.dev/160).
func (c *ProjectsLocationsListCall) Filter(filter string) *ProjectsLocationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return. If not set, the service selects a default.
func (c *ProjectsLocationsListCall) PageSize(pageSize int64) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from the `next_page_token` field in the response. Send that page token to
// receive the subsequent page.
func (c *ProjectsLocationsListCall) PageToken(pageToken string) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsListCall) Context(ctx context.Context) *ProjectsLocationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}/locations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListLocationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsListCall) Do(opts ...googleapi.CallOption) (*ListLocationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListLocationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsListCall) Pages(ctx context.Context, f func(*ListLocationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsFeaturesCreateCall struct {
	s          *Service
	parent     string
	feature    *Feature
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Adds a new Feature.
//
//   - parent: The parent (project and location) where the Feature will be
//     created. Specified in the format `projects/*/locations/*`.
func (r *ProjectsLocationsFeaturesService) Create(parent string, feature *Feature) *ProjectsLocationsFeaturesCreateCall {
	c := &ProjectsLocationsFeaturesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.feature = feature
	return c
}

// FeatureId sets the optional parameter "featureId": The ID of the feature to
// create.
func (c *ProjectsLocationsFeaturesCreateCall) FeatureId(featureId string) *ProjectsLocationsFeaturesCreateCall {
	c.urlParams_.Set("featureId", featureId)
	return c
}

// RequestId sets the optional parameter "requestId": A request ID to identify
// requests. Specify a unique request ID so that if you must retry your
// request, the server will know to ignore the request if it has already been
// completed. The server will guarantee that for at least 60 minutes after the
// first request. For example, consider a situation where you make an initial
// request and the request times out. If you make the request again with the
// same request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request. This
// prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsFeaturesCreateCall) RequestId(requestId string) *ProjectsLocationsFeaturesCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsFeaturesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsFeaturesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsFeaturesCreateCall) Context(ctx context.Context) *ProjectsLocationsFeaturesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsFeaturesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsFeaturesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.feature)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/features")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.features.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.features.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsFeaturesCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.features.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsFeaturesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Removes a Feature.
//
//   - name: The Feature resource name in the format
//     `projects/*/locations/*/features/*`.
func (r *ProjectsLocationsFeaturesService) Delete(name string) *ProjectsLocationsFeaturesDeleteCall {
	c := &ProjectsLocationsFeaturesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Force sets the optional parameter "force": If set to true, the delete will
// ignore any outstanding resources for this Feature (that is,
// `FeatureState.has_resources` is set to true). These resources will NOT be
// cleaned up or modified in any way.
func (c *ProjectsLocationsFeaturesDeleteCall) Force(force bool) *ProjectsLocationsFeaturesDeleteCall {
	c.urlParams_.Set("force", fmt.Sprint(force))
	return c
}

// RequestId sets the optional parameter "requestId": A request ID to identify
// requests. Specify a unique request ID so that if you must retry your
// request, the server will know to ignore the request if it has already been
// completed. The server will guarantee that for at least 60 minutes after the
// first request. For example, consider a situation where you make an initial
// request and the request times out. If you make the request again with the
// same request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request. This
// prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsFeaturesDeleteCall) RequestId(requestId string) *ProjectsLocationsFeaturesDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsFeaturesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsFeaturesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsFeaturesDeleteCall) Context(ctx context.Context) *ProjectsLocationsFeaturesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsFeaturesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsFeaturesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.features.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.features.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsFeaturesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.features.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsFeaturesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single Feature.
//
//   - name: The Feature resource name in the format
//     `projects/*/locations/*/features/*`.
func (r *ProjectsLocationsFeaturesService) Get(name string) *ProjectsLocationsFeaturesGetCall {
	c := &ProjectsLocationsFeaturesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess": If
// set to true, the response will return partial results when some regions are
// unreachable and the unreachable field in Feature proto will be populated. If
// set to false, the request will fail when some regions are unreachable.
func (c *ProjectsLocationsFeaturesGetCall) ReturnPartialSuccess(returnPartialSuccess bool) *ProjectsLocationsFeaturesGetCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsFeaturesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsFeaturesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsFeaturesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsFeaturesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsFeaturesGetCall) Context(ctx context.Context) *ProjectsLocationsFeaturesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsFeaturesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsFeaturesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.features.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.features.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Feature.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsFeaturesGetCall) Do(opts ...googleapi.CallOption) (*Feature, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Feature{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.features.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsFeaturesGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns an
// empty policy if the resource exists and does not have a policy set.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsFeaturesService) GetIamPolicy(resource string) *ProjectsLocationsFeaturesGetIamPolicyCall {
	c := &ProjectsLocationsFeaturesGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that will be
// used to format the policy. Valid values are 0, 1, and 3. Requests specifying
// an invalid value will be rejected. Requests for policies with any
// conditional role bindings must specify version 3. Policies with no
// conditional role bindings may specify any valid value or leave the field
// unset. The policy in the response might use the policy version that you
// specified, or it might use a lower policy version. For example, if you
// specify version 3, but the policy has no conditional role bindings, the
// response uses version 1. To learn which resources support conditions in
// their IAM policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsFeaturesGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsFeaturesGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsFeaturesGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsFeaturesGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsFeaturesGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsFeaturesGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsFeaturesGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsFeaturesGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsFeaturesGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsFeaturesGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.features.getIamPolicy", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.features.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsFeaturesGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.features.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsFeaturesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists Features in a given project and location.
//
//   - parent: The parent (project and location) where the Features will be
//     listed. Specified in the format `projects/*/locations/*`.
func (r *ProjectsLocationsFeaturesService) List(parent string) *ProjectsLocationsFeaturesListCall {
	c := &ProjectsLocationsFeaturesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Lists Features that match the
// filter expression, following the syntax outlined in
// https://google.aip.dev/160. Examples: - Feature with the name "servicemesh"
// in project "foo-proj": name =
// "projects/foo-proj/locations/global/features/servicemesh" - Features that
// have a label called `foo`: labels.foo:* - Features that have a label called
// `foo` whose value is `bar`: labels.foo = bar
func (c *ProjectsLocationsFeaturesListCall) Filter(filter string) *ProjectsLocationsFeaturesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": One or more fields to compare
// and use to sort the output. See https://google.aip.dev/132#ordering.
func (c *ProjectsLocationsFeaturesListCall) OrderBy(orderBy string) *ProjectsLocationsFeaturesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": When requesting a 'page' of
// resources, `page_size` specifies number of resources to return. If
// unspecified or set to 0, all resources will be returned.
func (c *ProjectsLocationsFeaturesListCall) PageSize(pageSize int64) *ProjectsLocationsFeaturesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token returned by
// previous call to `ListFeatures` which specifies the position in the list
// from where to continue listing the resources.
func (c *ProjectsLocationsFeaturesListCall) PageToken(pageToken string) *ProjectsLocationsFeaturesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess": If
// set to true, the response will return partial results when some regions are
// unreachable and the unreachable field in Feature proto will be populated. If
// set to false, the request will fail when some regions are unreachable.
func (c *ProjectsLocationsFeaturesListCall) ReturnPartialSuccess(returnPartialSuccess bool) *ProjectsLocationsFeaturesListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsFeaturesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsFeaturesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsFeaturesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsFeaturesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsFeaturesListCall) Context(ctx context.Context) *ProjectsLocationsFeaturesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsFeaturesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsFeaturesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/features")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.features.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.features.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListFeaturesResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsFeaturesListCall) Do(opts ...googleapi.CallOption) (*ListFeaturesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListFeaturesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.features.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsFeaturesListCall) Pages(ctx context.Context, f func(*ListFeaturesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsFeaturesPatchCall struct {
	s          *Service
	name       string
	feature    *Feature
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates an existing Feature.
//
//   - name: The Feature resource name in the format
//     `projects/*/locations/*/features/*`.
func (r *ProjectsLocationsFeaturesService) Patch(name string, feature *Feature) *ProjectsLocationsFeaturesPatchCall {
	c := &ProjectsLocationsFeaturesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.feature = feature
	return c
}

// RequestId sets the optional parameter "requestId": A request ID to identify
// requests. Specify a unique request ID so that if you must retry your
// request, the server will know to ignore the request if it has already been
// completed. The server will guarantee that for at least 60 minutes after the
// first request. For example, consider a situation where you make an initial
// request and the request times out. If you make the request again with the
// same request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request. This
// prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsFeaturesPatchCall) RequestId(requestId string) *ProjectsLocationsFeaturesPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Mask of fields to
// update.
func (c *ProjectsLocationsFeaturesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsFeaturesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsFeaturesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsFeaturesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsFeaturesPatchCall) Context(ctx context.Context) *ProjectsLocationsFeaturesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsFeaturesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsFeaturesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.feature)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.features.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.features.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsFeaturesPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.features.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsFeaturesSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the access control policy on the specified resource.
// Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`,
// and `PERMISSION_DENIED` errors.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsFeaturesService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsLocationsFeaturesSetIamPolicyCall {
	c := &ProjectsLocationsFeaturesSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsFeaturesSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsFeaturesSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsFeaturesSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsFeaturesSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsFeaturesSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsFeaturesSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.features.setIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.features.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsFeaturesSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.features.setIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsFeaturesTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource. If the resource does not exist, this will return an empty set of
// permissions, not a `NOT_FOUND` error. Note: This operation is designed to be
// used for building permission-aware UIs and command-line tools, not for
// authorization checking. This operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *ProjectsLocationsFeaturesService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *ProjectsLocationsFeaturesTestIamPermissionsCall {
	c := &ProjectsLocationsFeaturesTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsFeaturesTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsFeaturesTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsFeaturesTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsFeaturesTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsFeaturesTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsFeaturesTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.features.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.features.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsFeaturesTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.features.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsFleetsCreateCall struct {
	s          *Service
	parent     string
	fleet      *Fleet
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a fleet.
//
//   - parent: The parent (project and location) where the Fleet will be created.
//     Specified in the format `projects/*/locations/*`.
func (r *ProjectsLocationsFleetsService) Create(parent string, fleet *Fleet) *ProjectsLocationsFleetsCreateCall {
	c := &ProjectsLocationsFleetsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.fleet = fleet
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsFleetsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsFleetsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsFleetsCreateCall) Context(ctx context.Context) *ProjectsLocationsFleetsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsFleetsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsFleetsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.fleet)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/fleets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.fleets.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.fleets.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsFleetsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.fleets.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsFleetsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Removes a Fleet. There must be no memberships remaining in the
// Fleet.
//
//   - name: The Fleet resource name in the format
//     `projects/*/locations/*/fleets/*`.
func (r *ProjectsLocationsFleetsService) Delete(name string) *ProjectsLocationsFleetsDeleteCall {
	c := &ProjectsLocationsFleetsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsFleetsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsFleetsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsFleetsDeleteCall) Context(ctx context.Context) *ProjectsLocationsFleetsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsFleetsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsFleetsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.fleets.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.fleets.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsFleetsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.fleets.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsFleetsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns the details of a fleet.
//
//   - name: The Fleet resource name in the format
//     `projects/*/locations/*/fleets/*`.
func (r *ProjectsLocationsFleetsService) Get(name string) *ProjectsLocationsFleetsGetCall {
	c := &ProjectsLocationsFleetsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsFleetsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsFleetsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsFleetsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsFleetsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsFleetsGetCall) Context(ctx context.Context) *ProjectsLocationsFleetsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsFleetsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsFleetsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.fleets.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.fleets.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Fleet.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsFleetsGetCall) Do(opts ...googleapi.CallOption) (*Fleet, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Fleet{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.fleets.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsFleetsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns all fleets within an organization or a project that the caller
// has access to.
//
//   - parent: The organization or project to list for Fleets under, in the
//     format `organizations/*/locations/*` or `projects/*/locations/*`.
func (r *ProjectsLocationsFleetsService) List(parent string) *ProjectsLocationsFleetsListCall {
	c := &ProjectsLocationsFleetsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// fleets to return. The service may return fewer than this value. If
// unspecified, at most 200 fleets will be returned. The maximum value is 1000;
// values above 1000 will be coerced to 1000.
func (c *ProjectsLocationsFleetsListCall) PageSize(pageSize int64) *ProjectsLocationsFleetsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListFleets` call. Provide this to retrieve the subsequent
// page. When paginating, all other parameters provided to `ListFleets` must
// match the call that provided the page token.
func (c *ProjectsLocationsFleetsListCall) PageToken(pageToken string) *ProjectsLocationsFleetsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsFleetsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsFleetsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsFleetsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsFleetsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsFleetsListCall) Context(ctx context.Context) *ProjectsLocationsFleetsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsFleetsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsFleetsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/fleets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.fleets.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.fleets.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListFleetsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsFleetsListCall) Do(opts ...googleapi.CallOption) (*ListFleetsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListFleetsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.fleets.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsFleetsListCall) Pages(ctx context.Context, f func(*ListFleetsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsFleetsPatchCall struct {
	s          *Service
	name       string
	fleet      *Fleet
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates a fleet.
//
//   - name: Output only. The full, unique resource name of this fleet in the
//     format of `projects/{project}/locations/{location}/fleets/{fleet}`. Each
//     Google Cloud project can have at most one fleet resource, named "default".
func (r *ProjectsLocationsFleetsService) Patch(name string, fleet *Fleet) *ProjectsLocationsFleetsPatchCall {
	c := &ProjectsLocationsFleetsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.fleet = fleet
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The fields to
// be updated;
func (c *ProjectsLocationsFleetsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsFleetsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsFleetsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsFleetsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsFleetsPatchCall) Context(ctx context.Context) *ProjectsLocationsFleetsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsFleetsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsFleetsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.fleet)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.fleets.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.fleets.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsFleetsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.fleets.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsMembershipsCreateCall struct {
	s          *Service
	parent     string
	membership *Membership
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new Membership. **This is currently only supported for GKE
// clusters on Google Cloud**. To register other clusters, follow the
// instructions at
// https://cloud.google.com/anthos/multicluster-management/connect/registering-a-cluster.
//
//   - parent: The parent (project and location) where the Memberships will be
//     created. Specified in the format `projects/*/locations/*`.
func (r *ProjectsLocationsMembershipsService) Create(parent string, membership *Membership) *ProjectsLocationsMembershipsCreateCall {
	c := &ProjectsLocationsMembershipsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.membership = membership
	return c
}

// MembershipId sets the optional parameter "membershipId": Required. Client
// chosen ID for the membership. `membership_id` must be a valid RFC 1123
// compliant DNS label: 1. At most 63 characters in length 2. It must consist
// of lower case alphanumeric characters or `-` 3. It must start and end with
// an alphanumeric character Which can be expressed as the regex:
// `[a-z0-9]([-a-z0-9]*[a-z0-9])?`, with a maximum length of 63 characters.
func (c *ProjectsLocationsMembershipsCreateCall) MembershipId(membershipId string) *ProjectsLocationsMembershipsCreateCall {
	c.urlParams_.Set("membershipId", membershipId)
	return c
}

// RequestId sets the optional parameter "requestId": A request ID to identify
// requests. Specify a unique request ID so that if you must retry your
// request, the server will know to ignore the request if it has already been
// completed. The server will guarantee that for at least 60 minutes after the
// first request. For example, consider a situation where you make an initial
// request and the request times out. If you make the request again with the
// same request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request. This
// prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsMembershipsCreateCall) RequestId(requestId string) *ProjectsLocationsMembershipsCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMembershipsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsMembershipsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMembershipsCreateCall) Context(ctx context.Context) *ProjectsLocationsMembershipsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMembershipsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMembershipsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.membership)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/memberships")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.memberships.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsMembershipsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsMembershipsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Removes a Membership. **This is currently only supported for GKE
// clusters on Google Cloud**. To unregister other clusters, follow the
// instructions at
// https://cloud.google.com/anthos/multicluster-management/connect/unregistering-a-cluster.
//
//   - name: The Membership resource name in the format
//     `projects/*/locations/*/memberships/*`.
func (r *ProjectsLocationsMembershipsService) Delete(name string) *ProjectsLocationsMembershipsDeleteCall {
	c := &ProjectsLocationsMembershipsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Force sets the optional parameter "force": If set to true, any subresource
// from this Membership will also be deleted. Otherwise, the request will only
// work if the Membership has no subresource.
func (c *ProjectsLocationsMembershipsDeleteCall) Force(force bool) *ProjectsLocationsMembershipsDeleteCall {
	c.urlParams_.Set("force", fmt.Sprint(force))
	return c
}

// RequestId sets the optional parameter "requestId": A request ID to identify
// requests. Specify a unique request ID so that if you must retry your
// request, the server will know to ignore the request if it has already been
// completed. The server will guarantee that for at least 60 minutes after the
// first request. For example, consider a situation where you make an initial
// request and the request times out. If you make the request again with the
// same request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request. This
// prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsMembershipsDeleteCall) RequestId(requestId string) *ProjectsLocationsMembershipsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMembershipsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsMembershipsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMembershipsDeleteCall) Context(ctx context.Context) *ProjectsLocationsMembershipsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMembershipsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMembershipsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.memberships.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsMembershipsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsMembershipsGenerateConnectManifestCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GenerateConnectManifest: Generates the manifest for deployment of the GKE
// connect agent. **This method is used internally by Google-provided
// libraries.** Most clients should not need to call this method directly.
//
//   - name: The Membership resource name the Agent will associate with, in the
//     format `projects/*/locations/*/memberships/*`.
func (r *ProjectsLocationsMembershipsService) GenerateConnectManifest(name string) *ProjectsLocationsMembershipsGenerateConnectManifestCall {
	c := &ProjectsLocationsMembershipsGenerateConnectManifestCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ImagePullSecretContent sets the optional parameter "imagePullSecretContent":
// The image pull secret content for the registry, if not public.
func (c *ProjectsLocationsMembershipsGenerateConnectManifestCall) ImagePullSecretContent(imagePullSecretContent string) *ProjectsLocationsMembershipsGenerateConnectManifestCall {
	c.urlParams_.Set("imagePullSecretContent", imagePullSecretContent)
	return c
}

// IsUpgrade sets the optional parameter "isUpgrade": If true, generate the
// resources for upgrade only. Some resources generated only for installation
// (e.g. secrets) will be excluded.
func (c *ProjectsLocationsMembershipsGenerateConnectManifestCall) IsUpgrade(isUpgrade bool) *ProjectsLocationsMembershipsGenerateConnectManifestCall {
	c.urlParams_.Set("isUpgrade", fmt.Sprint(isUpgrade))
	return c
}

// Namespace sets the optional parameter "namespace": Namespace for GKE Connect
// agent resources. Defaults to `gke-connect`. The Connect Agent is authorized
// automatically when run in the default namespace. Otherwise, explicit
// authorization must be granted with an additional IAM binding.
func (c *ProjectsLocationsMembershipsGenerateConnectManifestCall) Namespace(namespace string) *ProjectsLocationsMembershipsGenerateConnectManifestCall {
	c.urlParams_.Set("namespace", namespace)
	return c
}

// Proxy sets the optional parameter "proxy": URI of a proxy if connectivity
// from the agent to gkeconnect.googleapis.com requires the use of a proxy.
// Format must be in the form `http(s)://{proxy_address}`, depending on the
// HTTP/HTTPS protocol supported by the proxy. This will direct the connect
// agent's outbound traffic through a HTTP(S) proxy.
func (c *ProjectsLocationsMembershipsGenerateConnectManifestCall) Proxy(proxy string) *ProjectsLocationsMembershipsGenerateConnectManifestCall {
	c.urlParams_.Set("proxy", proxy)
	return c
}

// Registry sets the optional parameter "registry": The registry to fetch the
// connect agent image from. Defaults to gcr.io/gkeconnect.
func (c *ProjectsLocationsMembershipsGenerateConnectManifestCall) Registry(registry string) *ProjectsLocationsMembershipsGenerateConnectManifestCall {
	c.urlParams_.Set("registry", registry)
	return c
}

// Version sets the optional parameter "version": The Connect agent version to
// use. Defaults to the most current version.
func (c *ProjectsLocationsMembershipsGenerateConnectManifestCall) Version(version string) *ProjectsLocationsMembershipsGenerateConnectManifestCall {
	c.urlParams_.Set("version", version)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMembershipsGenerateConnectManifestCall) Fields(s ...googleapi.Field) *ProjectsLocationsMembershipsGenerateConnectManifestCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsMembershipsGenerateConnectManifestCall) IfNoneMatch(entityTag string) *ProjectsLocationsMembershipsGenerateConnectManifestCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMembershipsGenerateConnectManifestCall) Context(ctx context.Context) *ProjectsLocationsMembershipsGenerateConnectManifestCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMembershipsGenerateConnectManifestCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMembershipsGenerateConnectManifestCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}:generateConnectManifest")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.generateConnectManifest", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.memberships.generateConnectManifest" call.
// Any non-2xx status code is an error. Response headers are in either
// *GenerateConnectManifestResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsMembershipsGenerateConnectManifestCall) Do(opts ...googleapi.CallOption) (*GenerateConnectManifestResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GenerateConnectManifestResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.generateConnectManifest", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsMembershipsGenerateExclusivityManifestCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GenerateExclusivityManifest: GenerateExclusivityManifest generates the
// manifests to update the exclusivity artifacts in the cluster if needed.
// Exclusivity artifacts include the Membership custom resource definition
// (CRD) and the singleton Membership custom resource (CR). Combined with
// ValidateExclusivity, exclusivity artifacts guarantee that a Kubernetes
// cluster is only registered to a single GKE Hub. The Membership CRD is
// versioned, and may require conversion when the GKE Hub API server begins
// serving a newer version of the CRD and corresponding CR. The response will
// be the converted CRD and CR if there are any differences between the
// versions.
//
//   - name: The Membership resource name in the format
//     `projects/*/locations/*/memberships/*`.
func (r *ProjectsLocationsMembershipsService) GenerateExclusivityManifest(name string) *ProjectsLocationsMembershipsGenerateExclusivityManifestCall {
	c := &ProjectsLocationsMembershipsGenerateExclusivityManifestCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// CrManifest sets the optional parameter "crManifest": The YAML manifest of
// the membership CR retrieved by `kubectl get memberships membership`. Leave
// empty if the resource does not exist.
func (c *ProjectsLocationsMembershipsGenerateExclusivityManifestCall) CrManifest(crManifest string) *ProjectsLocationsMembershipsGenerateExclusivityManifestCall {
	c.urlParams_.Set("crManifest", crManifest)
	return c
}

// CrdManifest sets the optional parameter "crdManifest": The YAML manifest of
// the membership CRD retrieved by `kubectl get customresourcedefinitions
// membership`. Leave empty if the resource does not exist.
func (c *ProjectsLocationsMembershipsGenerateExclusivityManifestCall) CrdManifest(crdManifest string) *ProjectsLocationsMembershipsGenerateExclusivityManifestCall {
	c.urlParams_.Set("crdManifest", crdManifest)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMembershipsGenerateExclusivityManifestCall) Fields(s ...googleapi.Field) *ProjectsLocationsMembershipsGenerateExclusivityManifestCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsMembershipsGenerateExclusivityManifestCall) IfNoneMatch(entityTag string) *ProjectsLocationsMembershipsGenerateExclusivityManifestCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMembershipsGenerateExclusivityManifestCall) Context(ctx context.Context) *ProjectsLocationsMembershipsGenerateExclusivityManifestCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMembershipsGenerateExclusivityManifestCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMembershipsGenerateExclusivityManifestCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}:generateExclusivityManifest")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.generateExclusivityManifest", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.memberships.generateExclusivityManifest" call.
// Any non-2xx status code is an error. Response headers are in either
// *GenerateExclusivityManifestResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsMembershipsGenerateExclusivityManifestCall) Do(opts ...googleapi.CallOption) (*GenerateExclusivityManifestResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GenerateExclusivityManifestResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.generateExclusivityManifest", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsMembershipsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the details of a Membership.
//
//   - name: The Membership resource name in the format
//     `projects/*/locations/*/memberships/*`.
func (r *ProjectsLocationsMembershipsService) Get(name string) *ProjectsLocationsMembershipsGetCall {
	c := &ProjectsLocationsMembershipsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMembershipsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsMembershipsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsMembershipsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsMembershipsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMembershipsGetCall) Context(ctx context.Context) *ProjectsLocationsMembershipsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMembershipsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMembershipsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.memberships.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Membership.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsMembershipsGetCall) Do(opts ...googleapi.CallOption) (*Membership, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Membership{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsMembershipsGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns an
// empty policy if the resource exists and does not have a policy set.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsMembershipsService) GetIamPolicy(resource string) *ProjectsLocationsMembershipsGetIamPolicyCall {
	c := &ProjectsLocationsMembershipsGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that will be
// used to format the policy. Valid values are 0, 1, and 3. Requests specifying
// an invalid value will be rejected. Requests for policies with any
// conditional role bindings must specify version 3. Policies with no
// conditional role bindings may specify any valid value or leave the field
// unset. The policy in the response might use the policy version that you
// specified, or it might use a lower policy version. For example, if you
// specify version 3, but the policy has no conditional role bindings, the
// response uses version 1. To learn which resources support conditions in
// their IAM policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsMembershipsGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsMembershipsGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMembershipsGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsMembershipsGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsMembershipsGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsMembershipsGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMembershipsGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsMembershipsGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMembershipsGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMembershipsGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.getIamPolicy", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.memberships.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsMembershipsGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsMembershipsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists Memberships in a given project and location.
//
//   - parent: The parent (project and location) where the Memberships will be
//     listed. Specified in the format `projects/*/locations/*`.
//     `projects/*/locations/-` list memberships in all the regions.
func (r *ProjectsLocationsMembershipsService) List(parent string) *ProjectsLocationsMembershipsListCall {
	c := &ProjectsLocationsMembershipsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Lists Memberships that match
// the filter expression, following the syntax outlined in
// https://google.aip.dev/160. Examples: - Name is `bar` in project `foo-proj`
// and location `global`: name =
// "projects/foo-proj/locations/global/membership/bar" - Memberships that have
// a label called `foo`: labels.foo:* - Memberships that have a label called
// `foo` whose value is `bar`: labels.foo = bar - Memberships in the CREATING
// state: state = CREATING
func (c *ProjectsLocationsMembershipsListCall) Filter(filter string) *ProjectsLocationsMembershipsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": One or more fields to compare
// and use to sort the output. See https://google.aip.dev/132#ordering.
func (c *ProjectsLocationsMembershipsListCall) OrderBy(orderBy string) *ProjectsLocationsMembershipsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": When requesting a 'page' of
// resources, `page_size` specifies number of resources to return. If
// unspecified or set to 0, all resources will be returned.
func (c *ProjectsLocationsMembershipsListCall) PageSize(pageSize int64) *ProjectsLocationsMembershipsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token returned by
// previous call to `ListMemberships` which specifies the position in the list
// from where to continue listing the resources.
func (c *ProjectsLocationsMembershipsListCall) PageToken(pageToken string) *ProjectsLocationsMembershipsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMembershipsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsMembershipsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsMembershipsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsMembershipsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMembershipsListCall) Context(ctx context.Context) *ProjectsLocationsMembershipsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMembershipsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMembershipsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/memberships")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.memberships.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListMembershipsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsMembershipsListCall) Do(opts ...googleapi.CallOption) (*ListMembershipsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListMembershipsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsMembershipsListCall) Pages(ctx context.Context, f func(*ListMembershipsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsMembershipsListAdminCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ListAdmin: Lists Memberships of admin clusters in a given project and
// location. **This method is only used internally**.
//
//   - parent: The parent (project and location) where the Memberships of admin
//     cluster will be listed. Specified in the format `projects/*/locations/*`.
func (r *ProjectsLocationsMembershipsService) ListAdmin(parent string) *ProjectsLocationsMembershipsListAdminCall {
	c := &ProjectsLocationsMembershipsListAdminCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Lists Memberships of admin
// clusters that match the filter expression.
func (c *ProjectsLocationsMembershipsListAdminCall) Filter(filter string) *ProjectsLocationsMembershipsListAdminCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": One or more fields to compare
// and use to sort the output. See https://google.aip.dev/132#ordering.
func (c *ProjectsLocationsMembershipsListAdminCall) OrderBy(orderBy string) *ProjectsLocationsMembershipsListAdminCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": When requesting a 'page' of
// resources, `page_size` specifies number of resources to return. If
// unspecified or set to 0, all resources will be returned.
func (c *ProjectsLocationsMembershipsListAdminCall) PageSize(pageSize int64) *ProjectsLocationsMembershipsListAdminCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token returned by
// previous call to `ListAdminClusterMemberships` which specifies the position
// in the list from where to continue listing the resources.
func (c *ProjectsLocationsMembershipsListAdminCall) PageToken(pageToken string) *ProjectsLocationsMembershipsListAdminCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMembershipsListAdminCall) Fields(s ...googleapi.Field) *ProjectsLocationsMembershipsListAdminCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsMembershipsListAdminCall) IfNoneMatch(entityTag string) *ProjectsLocationsMembershipsListAdminCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMembershipsListAdminCall) Context(ctx context.Context) *ProjectsLocationsMembershipsListAdminCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMembershipsListAdminCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMembershipsListAdminCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/memberships:listAdmin")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.listAdmin", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.memberships.listAdmin" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAdminClusterMembershipsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsMembershipsListAdminCall) Do(opts ...googleapi.CallOption) (*ListAdminClusterMembershipsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAdminClusterMembershipsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.listAdmin", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsMembershipsListAdminCall) Pages(ctx context.Context, f func(*ListAdminClusterMembershipsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsMembershipsPatchCall struct {
	s          *Service
	name       string
	membership *Membership
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates an existing Membership.
//
//   - name: The Membership resource name in the format
//     `projects/*/locations/*/memberships/*`.
func (r *ProjectsLocationsMembershipsService) Patch(name string, membership *Membership) *ProjectsLocationsMembershipsPatchCall {
	c := &ProjectsLocationsMembershipsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.membership = membership
	return c
}

// RequestId sets the optional parameter "requestId": A request ID to identify
// requests. Specify a unique request ID so that if you must retry your
// request, the server will know to ignore the request if it has already been
// completed. The server will guarantee that for at least 60 minutes after the
// first request. For example, consider a situation where you make an initial
// request and the request times out. If you make the request again with the
// same request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request. This
// prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsMembershipsPatchCall) RequestId(requestId string) *ProjectsLocationsMembershipsPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Mask of
// fields to update.
func (c *ProjectsLocationsMembershipsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsMembershipsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMembershipsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsMembershipsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMembershipsPatchCall) Context(ctx context.Context) *ProjectsLocationsMembershipsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMembershipsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMembershipsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.membership)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.memberships.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsMembershipsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsMembershipsSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the access control policy on the specified resource.
// Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`,
// and `PERMISSION_DENIED` errors.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsMembershipsService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsLocationsMembershipsSetIamPolicyCall {
	c := &ProjectsLocationsMembershipsSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMembershipsSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsMembershipsSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMembershipsSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsMembershipsSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMembershipsSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMembershipsSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.setIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.memberships.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsMembershipsSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.setIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsMembershipsTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource. If the resource does not exist, this will return an empty set of
// permissions, not a `NOT_FOUND` error. Note: This operation is designed to be
// used for building permission-aware UIs and command-line tools, not for
// authorization checking. This operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *ProjectsLocationsMembershipsService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *ProjectsLocationsMembershipsTestIamPermissionsCall {
	c := &ProjectsLocationsMembershipsTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMembershipsTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsMembershipsTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMembershipsTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsMembershipsTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMembershipsTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMembershipsTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.memberships.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsMembershipsTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsMembershipsValidateCreateCall struct {
	s                               *Service
	parent                          string
	validatecreatemembershiprequest *ValidateCreateMembershipRequest
	urlParams_                      gensupport.URLParams
	ctx_                            context.Context
	header_                         http.Header
}

// ValidateCreate: ValidateCreateMembership is a preflight check for
// CreateMembership. It checks the following: 1. Caller has the required
// `gkehub.memberships.create` permission. 2. The membership_id is still
// available.
//
//   - parent: The parent (project and location) where the Memberships will be
//     created. Specified in the format `projects/*/locations/*`.
func (r *ProjectsLocationsMembershipsService) ValidateCreate(parent string, validatecreatemembershiprequest *ValidateCreateMembershipRequest) *ProjectsLocationsMembershipsValidateCreateCall {
	c := &ProjectsLocationsMembershipsValidateCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.validatecreatemembershiprequest = validatecreatemembershiprequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMembershipsValidateCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsMembershipsValidateCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMembershipsValidateCreateCall) Context(ctx context.Context) *ProjectsLocationsMembershipsValidateCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMembershipsValidateCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMembershipsValidateCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.validatecreatemembershiprequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/memberships:validateCreate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.validateCreate", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.memberships.validateCreate" call.
// Any non-2xx status code is an error. Response headers are in either
// *ValidateCreateMembershipResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsMembershipsValidateCreateCall) Do(opts ...googleapi.CallOption) (*ValidateCreateMembershipResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ValidateCreateMembershipResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.validateCreate", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsMembershipsValidateExclusivityCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ValidateExclusivity: ValidateExclusivity validates the state of exclusivity
// in the cluster. The validation does not depend on an existing Hub membership
// resource.
//
//   - parent: The parent (project and location) where the Memberships will be
//     created. Specified in the format `projects/*/locations/*`.
func (r *ProjectsLocationsMembershipsService) ValidateExclusivity(parent string) *ProjectsLocationsMembershipsValidateExclusivityCall {
	c := &ProjectsLocationsMembershipsValidateExclusivityCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// CrManifest sets the optional parameter "crManifest": The YAML of the
// membership CR in the cluster. Empty if the membership CR does not exist.
func (c *ProjectsLocationsMembershipsValidateExclusivityCall) CrManifest(crManifest string) *ProjectsLocationsMembershipsValidateExclusivityCall {
	c.urlParams_.Set("crManifest", crManifest)
	return c
}

// IntendedMembership sets the optional parameter "intendedMembership":
// Required. The intended membership name under the `parent`. This method only
// does validation in anticipation of a CreateMembership call with the same
// name.
func (c *ProjectsLocationsMembershipsValidateExclusivityCall) IntendedMembership(intendedMembership string) *ProjectsLocationsMembershipsValidateExclusivityCall {
	c.urlParams_.Set("intendedMembership", intendedMembership)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMembershipsValidateExclusivityCall) Fields(s ...googleapi.Field) *ProjectsLocationsMembershipsValidateExclusivityCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsMembershipsValidateExclusivityCall) IfNoneMatch(entityTag string) *ProjectsLocationsMembershipsValidateExclusivityCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMembershipsValidateExclusivityCall) Context(ctx context.Context) *ProjectsLocationsMembershipsValidateExclusivityCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMembershipsValidateExclusivityCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMembershipsValidateExclusivityCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/memberships:validateExclusivity")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.validateExclusivity", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.memberships.validateExclusivity" call.
// Any non-2xx status code is an error. Response headers are in either
// *ValidateExclusivityResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsMembershipsValidateExclusivityCall) Do(opts ...googleapi.CallOption) (*ValidateExclusivityResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ValidateExclusivityResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.validateExclusivity", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsMembershipsBindingsCreateCall struct {
	s                 *Service
	parent            string
	membershipbinding *MembershipBinding
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Create: Creates a MembershipBinding.
//
//   - parent: The parent (project and location) where the MembershipBinding will
//     be created. Specified in the format
//     `projects/*/locations/*/memberships/*`.
func (r *ProjectsLocationsMembershipsBindingsService) Create(parent string, membershipbinding *MembershipBinding) *ProjectsLocationsMembershipsBindingsCreateCall {
	c := &ProjectsLocationsMembershipsBindingsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.membershipbinding = membershipbinding
	return c
}

// MembershipBindingId sets the optional parameter "membershipBindingId":
// Required. The ID to use for the MembershipBinding.
func (c *ProjectsLocationsMembershipsBindingsCreateCall) MembershipBindingId(membershipBindingId string) *ProjectsLocationsMembershipsBindingsCreateCall {
	c.urlParams_.Set("membershipBindingId", membershipBindingId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMembershipsBindingsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsMembershipsBindingsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMembershipsBindingsCreateCall) Context(ctx context.Context) *ProjectsLocationsMembershipsBindingsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMembershipsBindingsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMembershipsBindingsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.membershipbinding)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/bindings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.bindings.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.memberships.bindings.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsMembershipsBindingsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.bindings.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsMembershipsBindingsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a MembershipBinding.
//
//   - name: The MembershipBinding resource name in the format
//     `projects/*/locations/*/memberships/*/bindings/*`.
func (r *ProjectsLocationsMembershipsBindingsService) Delete(name string) *ProjectsLocationsMembershipsBindingsDeleteCall {
	c := &ProjectsLocationsMembershipsBindingsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMembershipsBindingsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsMembershipsBindingsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMembershipsBindingsDeleteCall) Context(ctx context.Context) *ProjectsLocationsMembershipsBindingsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMembershipsBindingsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMembershipsBindingsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.bindings.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.memberships.bindings.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsMembershipsBindingsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.bindings.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsMembershipsBindingsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns the details of a MembershipBinding.
//
//   - name: The MembershipBinding resource name in the format
//     `projects/*/locations/*/memberships/*/bindings/*`.
func (r *ProjectsLocationsMembershipsBindingsService) Get(name string) *ProjectsLocationsMembershipsBindingsGetCall {
	c := &ProjectsLocationsMembershipsBindingsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMembershipsBindingsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsMembershipsBindingsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsMembershipsBindingsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsMembershipsBindingsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMembershipsBindingsGetCall) Context(ctx context.Context) *ProjectsLocationsMembershipsBindingsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMembershipsBindingsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMembershipsBindingsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.bindings.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.memberships.bindings.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *MembershipBinding.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsMembershipsBindingsGetCall) Do(opts ...googleapi.CallOption) (*MembershipBinding, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &MembershipBinding{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.bindings.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsMembershipsBindingsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists MembershipBindings.
//
//   - parent: The parent Membership for which the MembershipBindings will be
//     listed. Specified in the format `projects/*/locations/*/memberships/*`.
func (r *ProjectsLocationsMembershipsBindingsService) List(parent string) *ProjectsLocationsMembershipsBindingsListCall {
	c := &ProjectsLocationsMembershipsBindingsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Lists MembershipBindings that
// match the filter expression, following the syntax outlined in
// https://google.aip.dev/160.
func (c *ProjectsLocationsMembershipsBindingsListCall) Filter(filter string) *ProjectsLocationsMembershipsBindingsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": When requesting a 'page' of
// resources, `page_size` specifies number of resources to return. If
// unspecified or set to 0, all resources will be returned.
func (c *ProjectsLocationsMembershipsBindingsListCall) PageSize(pageSize int64) *ProjectsLocationsMembershipsBindingsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token returned by
// previous call to `ListMembershipBindings` which specifies the position in
// the list from where to continue listing the resources.
func (c *ProjectsLocationsMembershipsBindingsListCall) PageToken(pageToken string) *ProjectsLocationsMembershipsBindingsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMembershipsBindingsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsMembershipsBindingsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsMembershipsBindingsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsMembershipsBindingsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMembershipsBindingsListCall) Context(ctx context.Context) *ProjectsLocationsMembershipsBindingsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMembershipsBindingsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMembershipsBindingsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/bindings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.bindings.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.memberships.bindings.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListMembershipBindingsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsMembershipsBindingsListCall) Do(opts ...googleapi.CallOption) (*ListMembershipBindingsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListMembershipBindingsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.bindings.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsMembershipsBindingsListCall) Pages(ctx context.Context, f func(*ListMembershipBindingsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsMembershipsBindingsPatchCall struct {
	s                 *Service
	name              string
	membershipbinding *MembershipBinding
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Patch: Updates a MembershipBinding.
//
//   - name: The resource name for the membershipbinding itself
//     `projects/{project}/locations/{location}/memberships/{membership}/bindings/
//     {membershipbinding}`.
func (r *ProjectsLocationsMembershipsBindingsService) Patch(name string, membershipbinding *MembershipBinding) *ProjectsLocationsMembershipsBindingsPatchCall {
	c := &ProjectsLocationsMembershipsBindingsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.membershipbinding = membershipbinding
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The fields to
// be updated.
func (c *ProjectsLocationsMembershipsBindingsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsMembershipsBindingsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMembershipsBindingsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsMembershipsBindingsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMembershipsBindingsPatchCall) Context(ctx context.Context) *ProjectsLocationsMembershipsBindingsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMembershipsBindingsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMembershipsBindingsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.membershipbinding)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.bindings.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.memberships.bindings.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsMembershipsBindingsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.bindings.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsMembershipsRbacrolebindingsCreateCall struct {
	s               *Service
	parent          string
	rbacrolebinding *RBACRoleBinding
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Create: Creates a Membership RBACRoleBinding.
//
//   - parent: The parent (project and location) where the RBACRoleBinding will
//     be created. Specified in the format
//     `projects/*/locations/*/memberships/*`.
func (r *ProjectsLocationsMembershipsRbacrolebindingsService) Create(parent string, rbacrolebinding *RBACRoleBinding) *ProjectsLocationsMembershipsRbacrolebindingsCreateCall {
	c := &ProjectsLocationsMembershipsRbacrolebindingsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.rbacrolebinding = rbacrolebinding
	return c
}

// RbacrolebindingId sets the optional parameter "rbacrolebindingId": Required.
// Client chosen ID for the RBACRoleBinding. `rbacrolebinding_id` must be a
// valid RFC 1123 compliant DNS label: 1. At most 63 characters in length 2. It
// must consist of lower case alphanumeric characters or `-` 3. It must start
// and end with an alphanumeric character Which can be expressed as the regex:
// `[a-z0-9]([-a-z0-9]*[a-z0-9])?`, with a maximum length of 63 characters.
func (c *ProjectsLocationsMembershipsRbacrolebindingsCreateCall) RbacrolebindingId(rbacrolebindingId string) *ProjectsLocationsMembershipsRbacrolebindingsCreateCall {
	c.urlParams_.Set("rbacrolebindingId", rbacrolebindingId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMembershipsRbacrolebindingsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsMembershipsRbacrolebindingsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMembershipsRbacrolebindingsCreateCall) Context(ctx context.Context) *ProjectsLocationsMembershipsRbacrolebindingsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMembershipsRbacrolebindingsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMembershipsRbacrolebindingsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.rbacrolebinding)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/rbacrolebindings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.rbacrolebindings.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.memberships.rbacrolebindings.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsMembershipsRbacrolebindingsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.rbacrolebindings.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsMembershipsRbacrolebindingsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a Membership RBACRoleBinding.
//
//   - name: The RBACRoleBinding resource name in the format
//     `projects/*/locations/*/memberships/*/rbacrolebindings/*`.
func (r *ProjectsLocationsMembershipsRbacrolebindingsService) Delete(name string) *ProjectsLocationsMembershipsRbacrolebindingsDeleteCall {
	c := &ProjectsLocationsMembershipsRbacrolebindingsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMembershipsRbacrolebindingsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsMembershipsRbacrolebindingsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMembershipsRbacrolebindingsDeleteCall) Context(ctx context.Context) *ProjectsLocationsMembershipsRbacrolebindingsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMembershipsRbacrolebindingsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMembershipsRbacrolebindingsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.rbacrolebindings.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.memberships.rbacrolebindings.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsMembershipsRbacrolebindingsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.rbacrolebindings.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsMembershipsRbacrolebindingsGenerateMembershipRBACRoleBindingYAMLCall struct {
	s               *Service
	parent          string
	rbacrolebinding *RBACRoleBinding
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// GenerateMembershipRBACRoleBindingYAML: Generates a YAML of the RBAC policies
// for the specified RoleBinding and its associated impersonation resources.
//
//   - parent: The parent (project and location) where the RBACRoleBinding will
//     be created. Specified in the format
//     `projects/*/locations/*/memberships/*`.
func (r *ProjectsLocationsMembershipsRbacrolebindingsService) GenerateMembershipRBACRoleBindingYAML(parent string, rbacrolebinding *RBACRoleBinding) *ProjectsLocationsMembershipsRbacrolebindingsGenerateMembershipRBACRoleBindingYAMLCall {
	c := &ProjectsLocationsMembershipsRbacrolebindingsGenerateMembershipRBACRoleBindingYAMLCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.rbacrolebinding = rbacrolebinding
	return c
}

// RbacrolebindingId sets the optional parameter "rbacrolebindingId": Required.
// Client chosen ID for the RBACRoleBinding. `rbacrolebinding_id` must be a
// valid RFC 1123 compliant DNS label: 1. At most 63 characters in length 2. It
// must consist of lower case alphanumeric characters or `-` 3. It must start
// and end with an alphanumeric character Which can be expressed as the regex:
// `[a-z0-9]([-a-z0-9]*[a-z0-9])?`, with a maximum length of 63 characters.
func (c *ProjectsLocationsMembershipsRbacrolebindingsGenerateMembershipRBACRoleBindingYAMLCall) RbacrolebindingId(rbacrolebindingId string) *ProjectsLocationsMembershipsRbacrolebindingsGenerateMembershipRBACRoleBindingYAMLCall {
	c.urlParams_.Set("rbacrolebindingId", rbacrolebindingId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMembershipsRbacrolebindingsGenerateMembershipRBACRoleBindingYAMLCall) Fields(s ...googleapi.Field) *ProjectsLocationsMembershipsRbacrolebindingsGenerateMembershipRBACRoleBindingYAMLCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMembershipsRbacrolebindingsGenerateMembershipRBACRoleBindingYAMLCall) Context(ctx context.Context) *ProjectsLocationsMembershipsRbacrolebindingsGenerateMembershipRBACRoleBindingYAMLCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMembershipsRbacrolebindingsGenerateMembershipRBACRoleBindingYAMLCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMembershipsRbacrolebindingsGenerateMembershipRBACRoleBindingYAMLCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.rbacrolebinding)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/rbacrolebindings:generateMembershipRBACRoleBindingYAML")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.rbacrolebindings.generateMembershipRBACRoleBindingYAML", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.memberships.rbacrolebindings.generateMembershipRBACRoleBindingYAML" call.
// Any non-2xx status code is an error. Response headers are in either
// *GenerateMembershipRBACRoleBindingYAMLResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsMembershipsRbacrolebindingsGenerateMembershipRBACRoleBindingYAMLCall) Do(opts ...googleapi.CallOption) (*GenerateMembershipRBACRoleBindingYAMLResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GenerateMembershipRBACRoleBindingYAMLResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.rbacrolebindings.generateMembershipRBACRoleBindingYAML", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsMembershipsRbacrolebindingsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns the details of a Membership RBACRoleBinding.
//
//   - name: The RBACRoleBinding resource name in the format
//     `projects/*/locations/*/memberships/*/rbacrolebindings/*`.
func (r *ProjectsLocationsMembershipsRbacrolebindingsService) Get(name string) *ProjectsLocationsMembershipsRbacrolebindingsGetCall {
	c := &ProjectsLocationsMembershipsRbacrolebindingsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMembershipsRbacrolebindingsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsMembershipsRbacrolebindingsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsMembershipsRbacrolebindingsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsMembershipsRbacrolebindingsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMembershipsRbacrolebindingsGetCall) Context(ctx context.Context) *ProjectsLocationsMembershipsRbacrolebindingsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMembershipsRbacrolebindingsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMembershipsRbacrolebindingsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.rbacrolebindings.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.memberships.rbacrolebindings.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *RBACRoleBinding.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsMembershipsRbacrolebindingsGetCall) Do(opts ...googleapi.CallOption) (*RBACRoleBinding, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RBACRoleBinding{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.rbacrolebindings.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsMembershipsRbacrolebindingsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all Membership RBACRoleBindings.
//
//   - parent: The parent (project and location) where the Features will be
//     listed. Specified in the format `projects/*/locations/*/memberships/*`.
func (r *ProjectsLocationsMembershipsRbacrolebindingsService) List(parent string) *ProjectsLocationsMembershipsRbacrolebindingsListCall {
	c := &ProjectsLocationsMembershipsRbacrolebindingsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": When requesting a 'page' of
// resources, `page_size` specifies number of resources to return. If
// unspecified or set to 0, all resources will be returned.
func (c *ProjectsLocationsMembershipsRbacrolebindingsListCall) PageSize(pageSize int64) *ProjectsLocationsMembershipsRbacrolebindingsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token returned by
// previous call to `ListMembershipRBACRoleBindings` which specifies the
// position in the list from where to continue listing the resources.
func (c *ProjectsLocationsMembershipsRbacrolebindingsListCall) PageToken(pageToken string) *ProjectsLocationsMembershipsRbacrolebindingsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMembershipsRbacrolebindingsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsMembershipsRbacrolebindingsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsMembershipsRbacrolebindingsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsMembershipsRbacrolebindingsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMembershipsRbacrolebindingsListCall) Context(ctx context.Context) *ProjectsLocationsMembershipsRbacrolebindingsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMembershipsRbacrolebindingsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMembershipsRbacrolebindingsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/rbacrolebindings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.rbacrolebindings.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.memberships.rbacrolebindings.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListMembershipRBACRoleBindingsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsMembershipsRbacrolebindingsListCall) Do(opts ...googleapi.CallOption) (*ListMembershipRBACRoleBindingsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListMembershipRBACRoleBindingsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.rbacrolebindings.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsMembershipsRbacrolebindingsListCall) Pages(ctx context.Context, f func(*ListMembershipRBACRoleBindingsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsMembershipsRbacrolebindingsPatchCall struct {
	s               *Service
	name            string
	rbacrolebinding *RBACRoleBinding
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Patch: Updates a Membership RBACRoleBinding.
//
//   - name: The resource name for the rbacrolebinding
//     `projects/{project}/locations/{location}/scopes/{scope}/rbacrolebindings/{r
//     bacrolebinding}` or
//     `projects/{project}/locations/{location}/memberships/{membership}/rbacroleb
//     indings/{rbacrolebinding}`.
func (r *ProjectsLocationsMembershipsRbacrolebindingsService) Patch(name string, rbacrolebinding *RBACRoleBinding) *ProjectsLocationsMembershipsRbacrolebindingsPatchCall {
	c := &ProjectsLocationsMembershipsRbacrolebindingsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.rbacrolebinding = rbacrolebinding
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The fields to
// be updated.
func (c *ProjectsLocationsMembershipsRbacrolebindingsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsMembershipsRbacrolebindingsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMembershipsRbacrolebindingsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsMembershipsRbacrolebindingsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMembershipsRbacrolebindingsPatchCall) Context(ctx context.Context) *ProjectsLocationsMembershipsRbacrolebindingsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMembershipsRbacrolebindingsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMembershipsRbacrolebindingsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.rbacrolebinding)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.rbacrolebindings.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.memberships.rbacrolebindings.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsMembershipsRbacrolebindingsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.memberships.rbacrolebindings.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsCancelCall struct {
	s                      *Service
	name                   string
	canceloperationrequest *CancelOperationRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Cancel: Starts asynchronous cancellation on a long-running operation. The
// server makes a best effort to cancel the operation, but success is not
// guaranteed. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or
// other methods to check whether the cancellation succeeded or whether the
// operation completed despite cancellation. On successful cancellation, the
// operation is not deleted; instead, it becomes an operation with an
// Operation.error value with a google.rpc.Status.code of `1`, corresponding to
// `Code.CANCELLED`.
//
// - name: The name of the operation resource to be cancelled.
func (r *ProjectsLocationsOperationsService) Cancel(name string, canceloperationrequest *CancelOperationRequest) *ProjectsLocationsOperationsCancelCall {
	c := &ProjectsLocationsOperationsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.canceloperationrequest = canceloperationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsCancelCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsCancelCall) Context(ctx context.Context) *ProjectsLocationsOperationsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.canceloperationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.operations.cancel", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.operations.cancel" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsCancelCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.operations.cancel", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a long-running operation. This method indicates that the
// client is no longer interested in the operation result. It does not cancel
// the operation. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`.
//
// - name: The name of the operation resource to be deleted.
func (r *ProjectsLocationsOperationsService) Delete(name string) *ProjectsLocationsOperationsDeleteCall {
	c := &ProjectsLocationsOperationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsDeleteCall) Context(ctx context.Context) *ProjectsLocationsOperationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.operations.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.operations.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.operations.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsOperationsService) Get(name string) *ProjectsLocationsOperationsGetCall {
	c := &ProjectsLocationsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsGetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the request. If
// the server doesn't support this method, it returns `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsOperationsService) List(name string) *ProjectsLocationsOperationsListCall {
	c := &ProjectsLocationsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list filter.
func (c *ProjectsLocationsOperationsListCall) Filter(filter string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list page
// size.
func (c *ProjectsLocationsOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list page
// token.
func (c *ProjectsLocationsOperationsListCall) PageToken(pageToken string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// When set to `true`, operations that are reachable are returned as normal,
// and those that are unreachable are returned in the
// ListOperationsResponse.unreachable field. This can only be `true` when
// reading across collections. For example, when `parent` is set to
// "projects/example/locations/-". This field is not supported by default and
// will result in an `UNIMPLEMENTED` error if set unless explicitly documented
// otherwise in service or product specific documentation.
func (c *ProjectsLocationsOperationsListCall) ReturnPartialSuccess(returnPartialSuccess bool) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsListCall) Context(ctx context.Context) *ProjectsLocationsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.operations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListOperationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsOperationsListCall) Do(opts ...googleapi.CallOption) (*ListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.operations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsOperationsListCall) Pages(ctx context.Context, f func(*ListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsRolloutSequencesCreateCall struct {
	s               *Service
	parent          string
	rolloutsequence *RolloutSequence
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Create: Create a new rollout sequence resource.
//
//   - parent: The parent resource where this rollout sequence will be created.
//     projects/{project}/locations/{location}.
func (r *ProjectsLocationsRolloutSequencesService) Create(parent string, rolloutsequence *RolloutSequence) *ProjectsLocationsRolloutSequencesCreateCall {
	c := &ProjectsLocationsRolloutSequencesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.rolloutsequence = rolloutsequence
	return c
}

// RolloutSequenceId sets the optional parameter "rolloutSequenceId": Required.
// User provided identifier that is used as part of the resource name; must
// conform to RFC-1034 and additionally restrict to lower-cased letters. This
// comes out roughly to: /^a-z+[a-z0-9]$/
func (c *ProjectsLocationsRolloutSequencesCreateCall) RolloutSequenceId(rolloutSequenceId string) *ProjectsLocationsRolloutSequencesCreateCall {
	c.urlParams_.Set("rolloutSequenceId", rolloutSequenceId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRolloutSequencesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsRolloutSequencesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRolloutSequencesCreateCall) Context(ctx context.Context) *ProjectsLocationsRolloutSequencesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRolloutSequencesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRolloutSequencesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.rolloutsequence)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/rolloutSequences")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.rolloutSequences.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.rolloutSequences.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsRolloutSequencesCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.rolloutSequences.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsRolloutSequencesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Remove a RolloutSequence.
//
//   - name: The name of the rollout sequence to delete.
//     projects/{project}/locations/{location}/rolloutSequences/{rollout_sequence}.
func (r *ProjectsLocationsRolloutSequencesService) Delete(name string) *ProjectsLocationsRolloutSequencesDeleteCall {
	c := &ProjectsLocationsRolloutSequencesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRolloutSequencesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsRolloutSequencesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRolloutSequencesDeleteCall) Context(ctx context.Context) *ProjectsLocationsRolloutSequencesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRolloutSequencesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRolloutSequencesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.rolloutSequences.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.rolloutSequences.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsRolloutSequencesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.rolloutSequences.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsRolloutSequencesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieve a single rollout sequence.
//
//   - name: The name of the rollout sequence to retrieve.
//     projects/{project}/locations/{location}/rolloutSequences/{rollout_sequence}.
func (r *ProjectsLocationsRolloutSequencesService) Get(name string) *ProjectsLocationsRolloutSequencesGetCall {
	c := &ProjectsLocationsRolloutSequencesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRolloutSequencesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsRolloutSequencesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsRolloutSequencesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsRolloutSequencesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRolloutSequencesGetCall) Context(ctx context.Context) *ProjectsLocationsRolloutSequencesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRolloutSequencesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRolloutSequencesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.rolloutSequences.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.rolloutSequences.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *RolloutSequence.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsRolloutSequencesGetCall) Do(opts ...googleapi.CallOption) (*RolloutSequence, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RolloutSequence{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.rolloutSequences.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsRolloutSequencesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieve the list of all rollout sequences.
//
//   - parent: The parent, which owns this collection of rollout sequences.
//     Format: projects/{project}/locations/{location}.
func (r *ProjectsLocationsRolloutSequencesService) List(parent string) *ProjectsLocationsRolloutSequencesListCall {
	c := &ProjectsLocationsRolloutSequencesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Lists Rollout Sequences that
// match the filter expression, following the syntax outlined in
// https://google.aip.dev/160.
func (c *ProjectsLocationsRolloutSequencesListCall) Filter(filter string) *ProjectsLocationsRolloutSequencesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// rollout sequences to return. The service may return fewer than this value.
// If unspecified, at most 50 rollout sequences will be returned. The maximum
// value is 1000; values above 1000 will be coerced to 1000.
func (c *ProjectsLocationsRolloutSequencesListCall) PageSize(pageSize int64) *ProjectsLocationsRolloutSequencesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListRolloutSequences` call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// `ListRolloutSequences` must match the call that provided the page token.
func (c *ProjectsLocationsRolloutSequencesListCall) PageToken(pageToken string) *ProjectsLocationsRolloutSequencesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRolloutSequencesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsRolloutSequencesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsRolloutSequencesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsRolloutSequencesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRolloutSequencesListCall) Context(ctx context.Context) *ProjectsLocationsRolloutSequencesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRolloutSequencesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRolloutSequencesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/rolloutSequences")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.rolloutSequences.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.rolloutSequences.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListRolloutSequencesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsRolloutSequencesListCall) Do(opts ...googleapi.CallOption) (*ListRolloutSequencesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListRolloutSequencesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.rolloutSequences.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsRolloutSequencesListCall) Pages(ctx context.Context, f func(*ListRolloutSequencesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsRolloutSequencesPatchCall struct {
	s               *Service
	name            string
	rolloutsequence *RolloutSequence
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Patch: Update a rollout sequence.
//
//   - name: Identifier. Name of the rollout sequence in the format of:
//     projects/{PROJECT_ID}/locations/global/rolloutSequences/{NAME}.
func (r *ProjectsLocationsRolloutSequencesService) Patch(name string, rolloutsequence *RolloutSequence) *ProjectsLocationsRolloutSequencesPatchCall {
	c := &ProjectsLocationsRolloutSequencesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.rolloutsequence = rolloutsequence
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of fields to
// update.
func (c *ProjectsLocationsRolloutSequencesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsRolloutSequencesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRolloutSequencesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsRolloutSequencesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRolloutSequencesPatchCall) Context(ctx context.Context) *ProjectsLocationsRolloutSequencesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRolloutSequencesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRolloutSequencesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.rolloutsequence)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.rolloutSequences.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.rolloutSequences.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsRolloutSequencesPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.rolloutSequences.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsRolloutsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieve a single rollout.
//
//   - name: The name of the rollout to retrieve.
//     projects/{project}/locations/{location}/rollouts/{rollout}.
func (r *ProjectsLocationsRolloutsService) Get(name string) *ProjectsLocationsRolloutsGetCall {
	c := &ProjectsLocationsRolloutsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRolloutsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsRolloutsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsRolloutsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsRolloutsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRolloutsGetCall) Context(ctx context.Context) *ProjectsLocationsRolloutsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRolloutsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRolloutsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.rollouts.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.rollouts.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Rollout.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsRolloutsGetCall) Do(opts ...googleapi.CallOption) (*Rollout, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Rollout{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.rollouts.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsRolloutsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieve the list of all rollouts.
//
//   - parent: The parent, which owns this collection of rollout. Format:
//     projects/{project}/locations/{location}.
func (r *ProjectsLocationsRolloutsService) List(parent string) *ProjectsLocationsRolloutsListCall {
	c := &ProjectsLocationsRolloutsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Lists Rollouts that match the
// filter expression, following the syntax outlined in
// https://google.aip.dev/160.
func (c *ProjectsLocationsRolloutsListCall) Filter(filter string) *ProjectsLocationsRolloutsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// rollout to return. The service may return fewer than this value. If
// unspecified, at most 50 rollouts will be returned. The maximum value is
// 1000; values above 1000 will be coerced to 1000.
func (c *ProjectsLocationsRolloutsListCall) PageSize(pageSize int64) *ProjectsLocationsRolloutsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListRollouts` call. Provide this to retrieve the subsequent
// page. When paginating, all other parameters provided to `ListRollouts` must
// match the call that provided the page token.
func (c *ProjectsLocationsRolloutsListCall) PageToken(pageToken string) *ProjectsLocationsRolloutsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRolloutsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsRolloutsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsRolloutsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsRolloutsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRolloutsListCall) Context(ctx context.Context) *ProjectsLocationsRolloutsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRolloutsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRolloutsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/rollouts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.rollouts.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.rollouts.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListRolloutsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsRolloutsListCall) Do(opts ...googleapi.CallOption) (*ListRolloutsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListRolloutsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.rollouts.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsRolloutsListCall) Pages(ctx context.Context, f func(*ListRolloutsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsScopesCreateCall struct {
	s          *Service
	parent     string
	scope      *Scope
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a Scope.
//
//   - parent: The parent (project and location) where the Scope will be created.
//     Specified in the format `projects/*/locations/*`.
func (r *ProjectsLocationsScopesService) Create(parent string, scope *Scope) *ProjectsLocationsScopesCreateCall {
	c := &ProjectsLocationsScopesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.scope = scope
	return c
}

// ScopeId sets the optional parameter "scopeId": Required. Client chosen ID
// for the Scope. `scope_id` must be a ????
func (c *ProjectsLocationsScopesCreateCall) ScopeId(scopeId string) *ProjectsLocationsScopesCreateCall {
	c.urlParams_.Set("scopeId", scopeId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsScopesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsScopesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsScopesCreateCall) Context(ctx context.Context) *ProjectsLocationsScopesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsScopesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsScopesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.scope)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/scopes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.scopes.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.scopes.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsScopesCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.scopes.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsScopesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a Scope.
//
//   - name: The Scope resource name in the format
//     `projects/*/locations/*/scopes/*`.
func (r *ProjectsLocationsScopesService) Delete(name string) *ProjectsLocationsScopesDeleteCall {
	c := &ProjectsLocationsScopesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsScopesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsScopesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsScopesDeleteCall) Context(ctx context.Context) *ProjectsLocationsScopesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsScopesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsScopesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.scopes.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.scopes.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsScopesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.scopes.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsScopesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns the details of a Scope.
//
//   - name: The Scope resource name in the format
//     `projects/*/locations/*/scopes/*`.
func (r *ProjectsLocationsScopesService) Get(name string) *ProjectsLocationsScopesGetCall {
	c := &ProjectsLocationsScopesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsScopesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsScopesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsScopesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsScopesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsScopesGetCall) Context(ctx context.Context) *ProjectsLocationsScopesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsScopesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsScopesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.scopes.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.scopes.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Scope.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsScopesGetCall) Do(opts ...googleapi.CallOption) (*Scope, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Scope{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.scopes.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsScopesGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns an
// empty policy if the resource exists and does not have a policy set.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsScopesService) GetIamPolicy(resource string) *ProjectsLocationsScopesGetIamPolicyCall {
	c := &ProjectsLocationsScopesGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that will be
// used to format the policy. Valid values are 0, 1, and 3. Requests specifying
// an invalid value will be rejected. Requests for policies with any
// conditional role bindings must specify version 3. Policies with no
// conditional role bindings may specify any valid value or leave the field
// unset. The policy in the response might use the policy version that you
// specified, or it might use a lower policy version. For example, if you
// specify version 3, but the policy has no conditional role bindings, the
// response uses version 1. To learn which resources support conditions in
// their IAM policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsScopesGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsScopesGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsScopesGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsScopesGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsScopesGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsScopesGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsScopesGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsScopesGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsScopesGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsScopesGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.scopes.getIamPolicy", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.scopes.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsScopesGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.scopes.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsScopesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists Scopes.
//
//   - parent: The parent (project and location) where the Scope will be listed.
//     Specified in the format `projects/*/locations/*`.
func (r *ProjectsLocationsScopesService) List(parent string) *ProjectsLocationsScopesListCall {
	c := &ProjectsLocationsScopesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": When requesting a 'page' of
// resources, `page_size` specifies number of resources to return. If
// unspecified or set to 0, all resources will be returned.
func (c *ProjectsLocationsScopesListCall) PageSize(pageSize int64) *ProjectsLocationsScopesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token returned by
// previous call to `ListScopes` which specifies the position in the list from
// where to continue listing the resources.
func (c *ProjectsLocationsScopesListCall) PageToken(pageToken string) *ProjectsLocationsScopesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsScopesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsScopesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsScopesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsScopesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsScopesListCall) Context(ctx context.Context) *ProjectsLocationsScopesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsScopesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsScopesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/scopes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.scopes.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.scopes.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListScopesResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsScopesListCall) Do(opts ...googleapi.CallOption) (*ListScopesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListScopesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.scopes.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsScopesListCall) Pages(ctx context.Context, f func(*ListScopesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsScopesListMembershipsCall struct {
	s            *Service
	scopeName    string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ListMemberships: Lists Memberships bound to a Scope. The response includes
// relevant Memberships from all regions.
//
//   - scopeName: Name of the Scope, in the format
//     `projects/*/locations/global/scopes/*`, to which the Memberships are
//     bound.
func (r *ProjectsLocationsScopesService) ListMemberships(scopeName string) *ProjectsLocationsScopesListMembershipsCall {
	c := &ProjectsLocationsScopesListMembershipsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.scopeName = scopeName
	return c
}

// Filter sets the optional parameter "filter": Lists Memberships that match
// the filter expression, following the syntax outlined in
// https://google.aip.dev/160. Currently, filtering can be done only based on
// Memberships's `name`, `labels`, `create_time`, `update_time`, and
// `unique_id`.
func (c *ProjectsLocationsScopesListMembershipsCall) Filter(filter string) *ProjectsLocationsScopesListMembershipsCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": When requesting a 'page' of
// resources, `page_size` specifies number of resources to return. If
// unspecified or set to 0, all resources will be returned. Pagination is
// currently not supported; therefore, setting this field does not have any
// impact for now.
func (c *ProjectsLocationsScopesListMembershipsCall) PageSize(pageSize int64) *ProjectsLocationsScopesListMembershipsCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token returned by
// previous call to `ListBoundMemberships` which specifies the position in the
// list from where to continue listing the resources.
func (c *ProjectsLocationsScopesListMembershipsCall) PageToken(pageToken string) *ProjectsLocationsScopesListMembershipsCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsScopesListMembershipsCall) Fields(s ...googleapi.Field) *ProjectsLocationsScopesListMembershipsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsScopesListMembershipsCall) IfNoneMatch(entityTag string) *ProjectsLocationsScopesListMembershipsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsScopesListMembershipsCall) Context(ctx context.Context) *ProjectsLocationsScopesListMembershipsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsScopesListMembershipsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsScopesListMembershipsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+scopeName}:listMemberships")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"scopeName": c.scopeName,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.scopes.listMemberships", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.scopes.listMemberships" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListBoundMembershipsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsScopesListMembershipsCall) Do(opts ...googleapi.CallOption) (*ListBoundMembershipsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListBoundMembershipsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.scopes.listMemberships", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsScopesListMembershipsCall) Pages(ctx context.Context, f func(*ListBoundMembershipsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsScopesListPermittedCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ListPermitted: Lists permitted Scopes.
//
//   - parent: The parent (project and location) where the Scope will be listed.
//     Specified in the format `projects/*/locations/*`.
func (r *ProjectsLocationsScopesService) ListPermitted(parent string) *ProjectsLocationsScopesListPermittedCall {
	c := &ProjectsLocationsScopesListPermittedCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": When requesting a 'page' of
// resources, `page_size` specifies number of resources to return. If
// unspecified or set to 0, all resources will be returned.
func (c *ProjectsLocationsScopesListPermittedCall) PageSize(pageSize int64) *ProjectsLocationsScopesListPermittedCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token returned by
// previous call to `ListPermittedScopes` which specifies the position in the
// list from where to continue listing the resources.
func (c *ProjectsLocationsScopesListPermittedCall) PageToken(pageToken string) *ProjectsLocationsScopesListPermittedCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsScopesListPermittedCall) Fields(s ...googleapi.Field) *ProjectsLocationsScopesListPermittedCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsScopesListPermittedCall) IfNoneMatch(entityTag string) *ProjectsLocationsScopesListPermittedCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsScopesListPermittedCall) Context(ctx context.Context) *ProjectsLocationsScopesListPermittedCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsScopesListPermittedCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsScopesListPermittedCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/scopes:listPermitted")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.scopes.listPermitted", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.scopes.listPermitted" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListPermittedScopesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsScopesListPermittedCall) Do(opts ...googleapi.CallOption) (*ListPermittedScopesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListPermittedScopesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.scopes.listPermitted", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsScopesListPermittedCall) Pages(ctx context.Context, f func(*ListPermittedScopesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsScopesPatchCall struct {
	s          *Service
	name       string
	scope      *Scope
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates a scopes.
//
//   - name: The resource name for the scope
//     `projects/{project}/locations/{location}/scopes/{scope}`.
func (r *ProjectsLocationsScopesService) Patch(name string, scope *Scope) *ProjectsLocationsScopesPatchCall {
	c := &ProjectsLocationsScopesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.scope = scope
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The fields to
// be updated.
func (c *ProjectsLocationsScopesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsScopesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsScopesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsScopesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsScopesPatchCall) Context(ctx context.Context) *ProjectsLocationsScopesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsScopesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsScopesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.scope)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.scopes.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.scopes.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsScopesPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.scopes.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsScopesSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the access control policy on the specified resource.
// Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`,
// and `PERMISSION_DENIED` errors.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsScopesService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsLocationsScopesSetIamPolicyCall {
	c := &ProjectsLocationsScopesSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsScopesSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsScopesSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsScopesSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsScopesSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsScopesSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsScopesSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.scopes.setIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.scopes.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsScopesSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.scopes.setIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsScopesTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource. If the resource does not exist, this will return an empty set of
// permissions, not a `NOT_FOUND` error. Note: This operation is designed to be
// used for building permission-aware UIs and command-line tools, not for
// authorization checking. This operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *ProjectsLocationsScopesService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *ProjectsLocationsScopesTestIamPermissionsCall {
	c := &ProjectsLocationsScopesTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsScopesTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsScopesTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsScopesTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsScopesTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsScopesTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsScopesTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.scopes.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.scopes.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsScopesTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.scopes.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsScopesNamespacesCreateCall struct {
	s          *Service
	parent     string
	namespace  *Namespace
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a fleet namespace.
//
//   - parent: The parent (project and location) where the Namespace will be
//     created. Specified in the format `projects/*/locations/*/scopes/*`.
func (r *ProjectsLocationsScopesNamespacesService) Create(parent string, namespace *Namespace) *ProjectsLocationsScopesNamespacesCreateCall {
	c := &ProjectsLocationsScopesNamespacesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.namespace = namespace
	return c
}

// ScopeNamespaceId sets the optional parameter "scopeNamespaceId": Required.
// Client chosen ID for the Namespace. `namespace_id` must be a valid RFC 1123
// compliant DNS label: 1. At most 63 characters in length 2. It must consist
// of lower case alphanumeric characters or `-` 3. It must start and end with
// an alphanumeric character Which can be expressed as the regex:
// `[a-z0-9]([-a-z0-9]*[a-z0-9])?`, with a maximum length of 63 characters.
func (c *ProjectsLocationsScopesNamespacesCreateCall) ScopeNamespaceId(scopeNamespaceId string) *ProjectsLocationsScopesNamespacesCreateCall {
	c.urlParams_.Set("scopeNamespaceId", scopeNamespaceId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsScopesNamespacesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsScopesNamespacesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsScopesNamespacesCreateCall) Context(ctx context.Context) *ProjectsLocationsScopesNamespacesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsScopesNamespacesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsScopesNamespacesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.namespace)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/namespaces")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.scopes.namespaces.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.scopes.namespaces.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsScopesNamespacesCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.scopes.namespaces.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsScopesNamespacesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a fleet namespace.
//
//   - name: The Namespace resource name in the format
//     `projects/*/locations/*/scopes/*/namespaces/*`.
func (r *ProjectsLocationsScopesNamespacesService) Delete(name string) *ProjectsLocationsScopesNamespacesDeleteCall {
	c := &ProjectsLocationsScopesNamespacesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsScopesNamespacesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsScopesNamespacesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsScopesNamespacesDeleteCall) Context(ctx context.Context) *ProjectsLocationsScopesNamespacesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsScopesNamespacesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsScopesNamespacesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.scopes.namespaces.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.scopes.namespaces.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsScopesNamespacesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.scopes.namespaces.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsScopesNamespacesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns the details of a fleet namespace.
//
//   - name: The Namespace resource name in the format
//     `projects/*/locations/*/scopes/*/namespaces/*`.
func (r *ProjectsLocationsScopesNamespacesService) Get(name string) *ProjectsLocationsScopesNamespacesGetCall {
	c := &ProjectsLocationsScopesNamespacesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsScopesNamespacesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsScopesNamespacesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsScopesNamespacesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsScopesNamespacesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsScopesNamespacesGetCall) Context(ctx context.Context) *ProjectsLocationsScopesNamespacesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsScopesNamespacesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsScopesNamespacesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.scopes.namespaces.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.scopes.namespaces.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Namespace.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsScopesNamespacesGetCall) Do(opts ...googleapi.CallOption) (*Namespace, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Namespace{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.scopes.namespaces.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsScopesNamespacesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists fleet namespaces.
//
//   - parent: The parent (project and location) where the Features will be
//     listed. Specified in the format `projects/*/locations/*/scopes/*`.
func (r *ProjectsLocationsScopesNamespacesService) List(parent string) *ProjectsLocationsScopesNamespacesListCall {
	c := &ProjectsLocationsScopesNamespacesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": When requesting a 'page' of
// resources, `page_size` specifies number of resources to return. If
// unspecified or set to 0, all resources will be returned.
func (c *ProjectsLocationsScopesNamespacesListCall) PageSize(pageSize int64) *ProjectsLocationsScopesNamespacesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token returned by
// previous call to `ListFeatures` which specifies the position in the list
// from where to continue listing the resources.
func (c *ProjectsLocationsScopesNamespacesListCall) PageToken(pageToken string) *ProjectsLocationsScopesNamespacesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsScopesNamespacesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsScopesNamespacesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsScopesNamespacesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsScopesNamespacesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsScopesNamespacesListCall) Context(ctx context.Context) *ProjectsLocationsScopesNamespacesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsScopesNamespacesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsScopesNamespacesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/namespaces")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.scopes.namespaces.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.scopes.namespaces.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListScopeNamespacesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsScopesNamespacesListCall) Do(opts ...googleapi.CallOption) (*ListScopeNamespacesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListScopeNamespacesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.scopes.namespaces.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsScopesNamespacesListCall) Pages(ctx context.Context, f func(*ListScopeNamespacesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsScopesNamespacesPatchCall struct {
	s          *Service
	name       string
	namespace  *Namespace
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates a fleet namespace.
//
//   - name: The resource name for the namespace
//     `projects/{project}/locations/{location}/namespaces/{namespace}`.
func (r *ProjectsLocationsScopesNamespacesService) Patch(name string, namespace *Namespace) *ProjectsLocationsScopesNamespacesPatchCall {
	c := &ProjectsLocationsScopesNamespacesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.namespace = namespace
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The fields to
// be updated.
func (c *ProjectsLocationsScopesNamespacesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsScopesNamespacesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsScopesNamespacesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsScopesNamespacesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsScopesNamespacesPatchCall) Context(ctx context.Context) *ProjectsLocationsScopesNamespacesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsScopesNamespacesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsScopesNamespacesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.namespace)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.scopes.namespaces.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.scopes.namespaces.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsScopesNamespacesPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.scopes.namespaces.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsScopesRbacrolebindingsCreateCall struct {
	s               *Service
	parent          string
	rbacrolebinding *RBACRoleBinding
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Create: Creates a Scope RBACRoleBinding.
//
//   - parent: The parent (project and location) where the RBACRoleBinding will
//     be created. Specified in the format `projects/*/locations/*/scopes/*`.
func (r *ProjectsLocationsScopesRbacrolebindingsService) Create(parent string, rbacrolebinding *RBACRoleBinding) *ProjectsLocationsScopesRbacrolebindingsCreateCall {
	c := &ProjectsLocationsScopesRbacrolebindingsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.rbacrolebinding = rbacrolebinding
	return c
}

// RbacrolebindingId sets the optional parameter "rbacrolebindingId": Required.
// Client chosen ID for the RBACRoleBinding. `rbacrolebinding_id` must be a
// valid RFC 1123 compliant DNS label: 1. At most 63 characters in length 2. It
// must consist of lower case alphanumeric characters or `-` 3. It must start
// and end with an alphanumeric character Which can be expressed as the regex:
// `[a-z0-9]([-a-z0-9]*[a-z0-9])?`, with a maximum length of 63 characters.
func (c *ProjectsLocationsScopesRbacrolebindingsCreateCall) RbacrolebindingId(rbacrolebindingId string) *ProjectsLocationsScopesRbacrolebindingsCreateCall {
	c.urlParams_.Set("rbacrolebindingId", rbacrolebindingId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsScopesRbacrolebindingsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsScopesRbacrolebindingsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsScopesRbacrolebindingsCreateCall) Context(ctx context.Context) *ProjectsLocationsScopesRbacrolebindingsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsScopesRbacrolebindingsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsScopesRbacrolebindingsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.rbacrolebinding)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/rbacrolebindings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.scopes.rbacrolebindings.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.scopes.rbacrolebindings.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsScopesRbacrolebindingsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.scopes.rbacrolebindings.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsScopesRbacrolebindingsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a Scope RBACRoleBinding.
//
//   - name: The RBACRoleBinding resource name in the format
//     `projects/*/locations/*/scopes/*/rbacrolebindings/*`.
func (r *ProjectsLocationsScopesRbacrolebindingsService) Delete(name string) *ProjectsLocationsScopesRbacrolebindingsDeleteCall {
	c := &ProjectsLocationsScopesRbacrolebindingsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsScopesRbacrolebindingsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsScopesRbacrolebindingsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsScopesRbacrolebindingsDeleteCall) Context(ctx context.Context) *ProjectsLocationsScopesRbacrolebindingsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsScopesRbacrolebindingsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsScopesRbacrolebindingsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.scopes.rbacrolebindings.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.scopes.rbacrolebindings.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsScopesRbacrolebindingsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.scopes.rbacrolebindings.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsScopesRbacrolebindingsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns the details of a Scope RBACRoleBinding.
//
//   - name: The RBACRoleBinding resource name in the format
//     `projects/*/locations/*/scopes/*/rbacrolebindings/*`.
func (r *ProjectsLocationsScopesRbacrolebindingsService) Get(name string) *ProjectsLocationsScopesRbacrolebindingsGetCall {
	c := &ProjectsLocationsScopesRbacrolebindingsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsScopesRbacrolebindingsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsScopesRbacrolebindingsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsScopesRbacrolebindingsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsScopesRbacrolebindingsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsScopesRbacrolebindingsGetCall) Context(ctx context.Context) *ProjectsLocationsScopesRbacrolebindingsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsScopesRbacrolebindingsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsScopesRbacrolebindingsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.scopes.rbacrolebindings.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.scopes.rbacrolebindings.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *RBACRoleBinding.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsScopesRbacrolebindingsGetCall) Do(opts ...googleapi.CallOption) (*RBACRoleBinding, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RBACRoleBinding{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.scopes.rbacrolebindings.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsScopesRbacrolebindingsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all Scope RBACRoleBindings.
//
//   - parent: The parent (project and location) where the Features will be
//     listed. Specified in the format `projects/*/locations/*/scopes/*`.
func (r *ProjectsLocationsScopesRbacrolebindingsService) List(parent string) *ProjectsLocationsScopesRbacrolebindingsListCall {
	c := &ProjectsLocationsScopesRbacrolebindingsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": When requesting a 'page' of
// resources, `page_size` specifies number of resources to return. If
// unspecified or set to 0, all resources will be returned.
func (c *ProjectsLocationsScopesRbacrolebindingsListCall) PageSize(pageSize int64) *ProjectsLocationsScopesRbacrolebindingsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token returned by
// previous call to `ListScopeRBACRoleBindings` which specifies the position in
// the list from where to continue listing the resources.
func (c *ProjectsLocationsScopesRbacrolebindingsListCall) PageToken(pageToken string) *ProjectsLocationsScopesRbacrolebindingsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsScopesRbacrolebindingsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsScopesRbacrolebindingsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsScopesRbacrolebindingsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsScopesRbacrolebindingsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsScopesRbacrolebindingsListCall) Context(ctx context.Context) *ProjectsLocationsScopesRbacrolebindingsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsScopesRbacrolebindingsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsScopesRbacrolebindingsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/rbacrolebindings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.scopes.rbacrolebindings.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.scopes.rbacrolebindings.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListScopeRBACRoleBindingsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsScopesRbacrolebindingsListCall) Do(opts ...googleapi.CallOption) (*ListScopeRBACRoleBindingsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListScopeRBACRoleBindingsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.scopes.rbacrolebindings.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsScopesRbacrolebindingsListCall) Pages(ctx context.Context, f func(*ListScopeRBACRoleBindingsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsScopesRbacrolebindingsPatchCall struct {
	s               *Service
	name            string
	rbacrolebinding *RBACRoleBinding
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Patch: Updates a Scope RBACRoleBinding.
//
//   - name: The resource name for the rbacrolebinding
//     `projects/{project}/locations/{location}/scopes/{scope}/rbacrolebindings/{r
//     bacrolebinding}` or
//     `projects/{project}/locations/{location}/memberships/{membership}/rbacroleb
//     indings/{rbacrolebinding}`.
func (r *ProjectsLocationsScopesRbacrolebindingsService) Patch(name string, rbacrolebinding *RBACRoleBinding) *ProjectsLocationsScopesRbacrolebindingsPatchCall {
	c := &ProjectsLocationsScopesRbacrolebindingsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.rbacrolebinding = rbacrolebinding
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The fields to
// be updated.
func (c *ProjectsLocationsScopesRbacrolebindingsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsScopesRbacrolebindingsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsScopesRbacrolebindingsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsScopesRbacrolebindingsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsScopesRbacrolebindingsPatchCall) Context(ctx context.Context) *ProjectsLocationsScopesRbacrolebindingsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsScopesRbacrolebindingsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsScopesRbacrolebindingsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.rbacrolebinding)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "gkehub.projects.locations.scopes.rbacrolebindings.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkehub.projects.locations.scopes.rbacrolebindings.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsScopesRbacrolebindingsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "gkehub.projects.locations.scopes.rbacrolebindings.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}
