// Copyright 2026 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package contactcenterinsights provides access to the Contact Center AI Insights API.
//
// For product documentation, see: https://cloud.google.com/contact-center/insights/docs
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/contactcenterinsights/v1"
//	...
//	ctx := context.Background()
//	contactcenterinsightsService, err := contactcenterinsights.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	contactcenterinsightsService, err := contactcenterinsights.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	contactcenterinsightsService, err := contactcenterinsights.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package contactcenterinsights // import "google.golang.org/api/contactcenterinsights/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "contactcenterinsights:v1"
const apiName = "contactcenterinsights"
const apiVersion = "v1"
const basePath = "https://contactcenterinsights.googleapis.com/"
const basePathTemplate = "https://contactcenterinsights.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://contactcenterinsights.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Projects = NewProjectsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.AnalysisRules = NewProjectsLocationsAnalysisRulesService(s)
	rs.AssessmentRules = NewProjectsLocationsAssessmentRulesService(s)
	rs.AuthorizedViewSets = NewProjectsLocationsAuthorizedViewSetsService(s)
	rs.AutoLabelingRules = NewProjectsLocationsAutoLabelingRulesService(s)
	rs.Conversations = NewProjectsLocationsConversationsService(s)
	rs.Dashboards = NewProjectsLocationsDashboardsService(s)
	rs.Datasets = NewProjectsLocationsDatasetsService(s)
	rs.EncryptionSpec = NewProjectsLocationsEncryptionSpecService(s)
	rs.Insightsdata = NewProjectsLocationsInsightsdataService(s)
	rs.IssueModels = NewProjectsLocationsIssueModelsService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	rs.PhraseMatchers = NewProjectsLocationsPhraseMatchersService(s)
	rs.QaQuestionTags = NewProjectsLocationsQaQuestionTagsService(s)
	rs.QaScorecards = NewProjectsLocationsQaScorecardsService(s)
	rs.Views = NewProjectsLocationsViewsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	AnalysisRules *ProjectsLocationsAnalysisRulesService

	AssessmentRules *ProjectsLocationsAssessmentRulesService

	AuthorizedViewSets *ProjectsLocationsAuthorizedViewSetsService

	AutoLabelingRules *ProjectsLocationsAutoLabelingRulesService

	Conversations *ProjectsLocationsConversationsService

	Dashboards *ProjectsLocationsDashboardsService

	Datasets *ProjectsLocationsDatasetsService

	EncryptionSpec *ProjectsLocationsEncryptionSpecService

	Insightsdata *ProjectsLocationsInsightsdataService

	IssueModels *ProjectsLocationsIssueModelsService

	Operations *ProjectsLocationsOperationsService

	PhraseMatchers *ProjectsLocationsPhraseMatchersService

	QaQuestionTags *ProjectsLocationsQaQuestionTagsService

	QaScorecards *ProjectsLocationsQaScorecardsService

	Views *ProjectsLocationsViewsService
}

func NewProjectsLocationsAnalysisRulesService(s *Service) *ProjectsLocationsAnalysisRulesService {
	rs := &ProjectsLocationsAnalysisRulesService{s: s}
	return rs
}

type ProjectsLocationsAnalysisRulesService struct {
	s *Service
}

func NewProjectsLocationsAssessmentRulesService(s *Service) *ProjectsLocationsAssessmentRulesService {
	rs := &ProjectsLocationsAssessmentRulesService{s: s}
	return rs
}

type ProjectsLocationsAssessmentRulesService struct {
	s *Service
}

func NewProjectsLocationsAuthorizedViewSetsService(s *Service) *ProjectsLocationsAuthorizedViewSetsService {
	rs := &ProjectsLocationsAuthorizedViewSetsService{s: s}
	rs.AuthorizedViews = NewProjectsLocationsAuthorizedViewSetsAuthorizedViewsService(s)
	return rs
}

type ProjectsLocationsAuthorizedViewSetsService struct {
	s *Service

	AuthorizedViews *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsService
}

func NewProjectsLocationsAuthorizedViewSetsAuthorizedViewsService(s *Service) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsService {
	rs := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsService{s: s}
	rs.Conversations = NewProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsService(s)
	rs.Operations = NewProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsService(s)
	return rs
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsService struct {
	s *Service

	Conversations *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsService

	Operations *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsService
}

func NewProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsService(s *Service) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsService {
	rs := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsService{s: s}
	rs.Assessments = NewProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsService(s)
	rs.FeedbackLabels = NewProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsService(s)
	return rs
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsService struct {
	s *Service

	Assessments *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsService

	FeedbackLabels *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsService
}

func NewProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsService(s *Service) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsService {
	rs := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsService{s: s}
	rs.Notes = NewProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesService(s)
	return rs
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsService struct {
	s *Service

	Notes *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesService
}

func NewProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesService(s *Service) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesService {
	rs := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesService{s: s}
	return rs
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesService struct {
	s *Service
}

func NewProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsService(s *Service) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsService {
	rs := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsService{s: s}
	return rs
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsService struct {
	s *Service
}

func NewProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsService(s *Service) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsService {
	rs := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsService{s: s}
	return rs
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsService struct {
	s *Service
}

func NewProjectsLocationsAutoLabelingRulesService(s *Service) *ProjectsLocationsAutoLabelingRulesService {
	rs := &ProjectsLocationsAutoLabelingRulesService{s: s}
	return rs
}

type ProjectsLocationsAutoLabelingRulesService struct {
	s *Service
}

func NewProjectsLocationsConversationsService(s *Service) *ProjectsLocationsConversationsService {
	rs := &ProjectsLocationsConversationsService{s: s}
	rs.Analyses = NewProjectsLocationsConversationsAnalysesService(s)
	rs.Assessments = NewProjectsLocationsConversationsAssessmentsService(s)
	rs.FeedbackLabels = NewProjectsLocationsConversationsFeedbackLabelsService(s)
	rs.Segments = NewProjectsLocationsConversationsSegmentsService(s)
	return rs
}

type ProjectsLocationsConversationsService struct {
	s *Service

	Analyses *ProjectsLocationsConversationsAnalysesService

	Assessments *ProjectsLocationsConversationsAssessmentsService

	FeedbackLabels *ProjectsLocationsConversationsFeedbackLabelsService

	Segments *ProjectsLocationsConversationsSegmentsService
}

func NewProjectsLocationsConversationsAnalysesService(s *Service) *ProjectsLocationsConversationsAnalysesService {
	rs := &ProjectsLocationsConversationsAnalysesService{s: s}
	return rs
}

type ProjectsLocationsConversationsAnalysesService struct {
	s *Service
}

func NewProjectsLocationsConversationsAssessmentsService(s *Service) *ProjectsLocationsConversationsAssessmentsService {
	rs := &ProjectsLocationsConversationsAssessmentsService{s: s}
	rs.Notes = NewProjectsLocationsConversationsAssessmentsNotesService(s)
	return rs
}

type ProjectsLocationsConversationsAssessmentsService struct {
	s *Service

	Notes *ProjectsLocationsConversationsAssessmentsNotesService
}

func NewProjectsLocationsConversationsAssessmentsNotesService(s *Service) *ProjectsLocationsConversationsAssessmentsNotesService {
	rs := &ProjectsLocationsConversationsAssessmentsNotesService{s: s}
	return rs
}

type ProjectsLocationsConversationsAssessmentsNotesService struct {
	s *Service
}

func NewProjectsLocationsConversationsFeedbackLabelsService(s *Service) *ProjectsLocationsConversationsFeedbackLabelsService {
	rs := &ProjectsLocationsConversationsFeedbackLabelsService{s: s}
	return rs
}

type ProjectsLocationsConversationsFeedbackLabelsService struct {
	s *Service
}

func NewProjectsLocationsConversationsSegmentsService(s *Service) *ProjectsLocationsConversationsSegmentsService {
	rs := &ProjectsLocationsConversationsSegmentsService{s: s}
	return rs
}

type ProjectsLocationsConversationsSegmentsService struct {
	s *Service
}

func NewProjectsLocationsDashboardsService(s *Service) *ProjectsLocationsDashboardsService {
	rs := &ProjectsLocationsDashboardsService{s: s}
	rs.Charts = NewProjectsLocationsDashboardsChartsService(s)
	return rs
}

type ProjectsLocationsDashboardsService struct {
	s *Service

	Charts *ProjectsLocationsDashboardsChartsService
}

func NewProjectsLocationsDashboardsChartsService(s *Service) *ProjectsLocationsDashboardsChartsService {
	rs := &ProjectsLocationsDashboardsChartsService{s: s}
	return rs
}

type ProjectsLocationsDashboardsChartsService struct {
	s *Service
}

func NewProjectsLocationsDatasetsService(s *Service) *ProjectsLocationsDatasetsService {
	rs := &ProjectsLocationsDatasetsService{s: s}
	rs.Conversations = NewProjectsLocationsDatasetsConversationsService(s)
	rs.Insightsdata = NewProjectsLocationsDatasetsInsightsdataService(s)
	return rs
}

type ProjectsLocationsDatasetsService struct {
	s *Service

	Conversations *ProjectsLocationsDatasetsConversationsService

	Insightsdata *ProjectsLocationsDatasetsInsightsdataService
}

func NewProjectsLocationsDatasetsConversationsService(s *Service) *ProjectsLocationsDatasetsConversationsService {
	rs := &ProjectsLocationsDatasetsConversationsService{s: s}
	rs.FeedbackLabels = NewProjectsLocationsDatasetsConversationsFeedbackLabelsService(s)
	return rs
}

type ProjectsLocationsDatasetsConversationsService struct {
	s *Service

	FeedbackLabels *ProjectsLocationsDatasetsConversationsFeedbackLabelsService
}

func NewProjectsLocationsDatasetsConversationsFeedbackLabelsService(s *Service) *ProjectsLocationsDatasetsConversationsFeedbackLabelsService {
	rs := &ProjectsLocationsDatasetsConversationsFeedbackLabelsService{s: s}
	return rs
}

type ProjectsLocationsDatasetsConversationsFeedbackLabelsService struct {
	s *Service
}

func NewProjectsLocationsDatasetsInsightsdataService(s *Service) *ProjectsLocationsDatasetsInsightsdataService {
	rs := &ProjectsLocationsDatasetsInsightsdataService{s: s}
	return rs
}

type ProjectsLocationsDatasetsInsightsdataService struct {
	s *Service
}

func NewProjectsLocationsEncryptionSpecService(s *Service) *ProjectsLocationsEncryptionSpecService {
	rs := &ProjectsLocationsEncryptionSpecService{s: s}
	return rs
}

type ProjectsLocationsEncryptionSpecService struct {
	s *Service
}

func NewProjectsLocationsInsightsdataService(s *Service) *ProjectsLocationsInsightsdataService {
	rs := &ProjectsLocationsInsightsdataService{s: s}
	return rs
}

type ProjectsLocationsInsightsdataService struct {
	s *Service
}

func NewProjectsLocationsIssueModelsService(s *Service) *ProjectsLocationsIssueModelsService {
	rs := &ProjectsLocationsIssueModelsService{s: s}
	rs.Issues = NewProjectsLocationsIssueModelsIssuesService(s)
	return rs
}

type ProjectsLocationsIssueModelsService struct {
	s *Service

	Issues *ProjectsLocationsIssueModelsIssuesService
}

func NewProjectsLocationsIssueModelsIssuesService(s *Service) *ProjectsLocationsIssueModelsIssuesService {
	rs := &ProjectsLocationsIssueModelsIssuesService{s: s}
	return rs
}

type ProjectsLocationsIssueModelsIssuesService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

func NewProjectsLocationsPhraseMatchersService(s *Service) *ProjectsLocationsPhraseMatchersService {
	rs := &ProjectsLocationsPhraseMatchersService{s: s}
	return rs
}

type ProjectsLocationsPhraseMatchersService struct {
	s *Service
}

func NewProjectsLocationsQaQuestionTagsService(s *Service) *ProjectsLocationsQaQuestionTagsService {
	rs := &ProjectsLocationsQaQuestionTagsService{s: s}
	return rs
}

type ProjectsLocationsQaQuestionTagsService struct {
	s *Service
}

func NewProjectsLocationsQaScorecardsService(s *Service) *ProjectsLocationsQaScorecardsService {
	rs := &ProjectsLocationsQaScorecardsService{s: s}
	rs.Revisions = NewProjectsLocationsQaScorecardsRevisionsService(s)
	return rs
}

type ProjectsLocationsQaScorecardsService struct {
	s *Service

	Revisions *ProjectsLocationsQaScorecardsRevisionsService
}

func NewProjectsLocationsQaScorecardsRevisionsService(s *Service) *ProjectsLocationsQaScorecardsRevisionsService {
	rs := &ProjectsLocationsQaScorecardsRevisionsService{s: s}
	rs.QaQuestions = NewProjectsLocationsQaScorecardsRevisionsQaQuestionsService(s)
	return rs
}

type ProjectsLocationsQaScorecardsRevisionsService struct {
	s *Service

	QaQuestions *ProjectsLocationsQaScorecardsRevisionsQaQuestionsService
}

func NewProjectsLocationsQaScorecardsRevisionsQaQuestionsService(s *Service) *ProjectsLocationsQaScorecardsRevisionsQaQuestionsService {
	rs := &ProjectsLocationsQaScorecardsRevisionsQaQuestionsService{s: s}
	return rs
}

type ProjectsLocationsQaScorecardsRevisionsQaQuestionsService struct {
	s *Service
}

func NewProjectsLocationsViewsService(s *Service) *ProjectsLocationsViewsService {
	rs := &ProjectsLocationsViewsService{s: s}
	return rs
}

type ProjectsLocationsViewsService struct {
	s *Service
}

// GoogleCloudContactcenterinsightsV1Analysis: The analysis resource.
type GoogleCloudContactcenterinsightsV1Analysis struct {
	// AnalysisResult: Output only. The result of the analysis, which is populated
	// when the analysis finishes.
	AnalysisResult *GoogleCloudContactcenterinsightsV1AnalysisResult `json:"analysisResult,omitempty"`
	// AnnotatorSelector: To select the annotators to run and the phrase matchers
	// to use (if any). If not specified, all annotators will be run.
	AnnotatorSelector *GoogleCloudContactcenterinsightsV1AnnotatorSelector `json:"annotatorSelector,omitempty"`
	// CreateTime: Output only. The time at which the analysis was created, which
	// occurs when the long-running operation completes.
	CreateTime string `json:"createTime,omitempty"`
	// Name: Immutable. The resource name of the analysis. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}/analyses
	// /{analysis}
	Name string `json:"name,omitempty"`
	// RequestTime: Output only. The time at which the analysis was requested.
	RequestTime string `json:"requestTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AnalysisResult") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalysisResult") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1Analysis) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1Analysis
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1AnalysisResult: The result of an analysis.
type GoogleCloudContactcenterinsightsV1AnalysisResult struct {
	// CallAnalysisMetadata: Call-specific metadata created by the analysis.
	CallAnalysisMetadata *GoogleCloudContactcenterinsightsV1AnalysisResultCallAnalysisMetadata `json:"callAnalysisMetadata,omitempty"`
	// EndTime: The time at which the analysis ended.
	EndTime string `json:"endTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CallAnalysisMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CallAnalysisMetadata") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1AnalysisResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1AnalysisResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1AnalysisResultCallAnalysisMetadata:
// Call-specific metadata created during analysis.
type GoogleCloudContactcenterinsightsV1AnalysisResultCallAnalysisMetadata struct {
	// Annotations: A list of call annotations that apply to this call.
	Annotations []*GoogleCloudContactcenterinsightsV1CallAnnotation `json:"annotations,omitempty"`
	// Entities: All the entities in the call.
	Entities map[string]GoogleCloudContactcenterinsightsV1Entity `json:"entities,omitempty"`
	// Intents: All the matched intents in the call.
	Intents map[string]GoogleCloudContactcenterinsightsV1Intent `json:"intents,omitempty"`
	// IssueModelResult: Overall conversation-level issue modeling result.
	IssueModelResult *GoogleCloudContactcenterinsightsV1IssueModelResult `json:"issueModelResult,omitempty"`
	// PhraseMatchers: All the matched phrase matchers in the call.
	PhraseMatchers map[string]GoogleCloudContactcenterinsightsV1PhraseMatchData `json:"phraseMatchers,omitempty"`
	// QaScorecardResults: Results of scoring QaScorecards.
	QaScorecardResults []*GoogleCloudContactcenterinsightsV1QaScorecardResult `json:"qaScorecardResults,omitempty"`
	// Sentiments: Overall conversation-level sentiment for each channel of the
	// call.
	Sentiments []*GoogleCloudContactcenterinsightsV1ConversationLevelSentiment `json:"sentiments,omitempty"`
	// Silence: Overall conversation-level silence during the call.
	Silence *GoogleCloudContactcenterinsightsV1ConversationLevelSilence `json:"silence,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1AnalysisResultCallAnalysisMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1AnalysisResultCallAnalysisMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1AnalysisRule: The CCAI Insights project
// wide analysis rule. This rule will be applied to all conversations that
// match the filter defined in the rule. For a conversation matches the filter,
// the annotators specified in the rule will be run. If a conversation matches
// multiple rules, a union of all the annotators will be run. One project can
// have multiple analysis rules.
type GoogleCloudContactcenterinsightsV1AnalysisRule struct {
	// Active: If true, apply this rule to conversations. Otherwise, this rule is
	// inactive and saved as a draft.
	Active bool `json:"active,omitempty"`
	// AnalysisPercentage: Percentage of conversations that we should apply this
	// analysis setting automatically, between [0, 1]. For example, 0.1 means 10%.
	// Conversations are sampled in a determenestic way. The original
	// runtime_percentage & upload percentage will be replaced by defining filters
	// on the conversation.
	AnalysisPercentage float64 `json:"analysisPercentage,omitempty"`
	// AnnotatorSelector: Selector of annotators to run and the phrase matchers to
	// use for conversations that matches the conversation_filter. If not
	// specified, NO annotators will be run.
	AnnotatorSelector *GoogleCloudContactcenterinsightsV1AnnotatorSelector `json:"annotatorSelector,omitempty"`
	// ConversationFilter: Filter for the conversations that should apply this
	// analysis rule. An empty filter means this analysis rule applies to all
	// conversations. Refer to
	// https://cloud.google.com/contact-center/insights/docs/filtering for details.
	ConversationFilter string `json:"conversationFilter,omitempty"`
	// CreateTime: Output only. The time at which this analysis rule was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Display Name of the analysis rule.
	DisplayName string `json:"displayName,omitempty"`
	// Name: Identifier. The resource name of the analysis rule. Format:
	// projects/{project}/locations/{location}/analysisRules/{analysis_rule}
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. The most recent time at which this analysis rule
	// was updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Active") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Active") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1AnalysisRule) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1AnalysisRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1AnalysisRule) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1AnalysisRule
	var s1 struct {
		AnalysisPercentage gensupport.JSONFloat64 `json:"analysisPercentage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AnalysisPercentage = float64(s1.AnalysisPercentage)
	return nil
}

// GoogleCloudContactcenterinsightsV1AnnotationBoundary: A point in a
// conversation that marks the start or the end of an annotation.
type GoogleCloudContactcenterinsightsV1AnnotationBoundary struct {
	// TranscriptIndex: The index in the sequence of transcribed pieces of the
	// conversation where the boundary is located. This index starts at zero.
	TranscriptIndex int64 `json:"transcriptIndex,omitempty"`
	// WordIndex: The word index of this boundary with respect to the first word in
	// the transcript piece. This index starts at zero.
	WordIndex int64 `json:"wordIndex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TranscriptIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TranscriptIndex") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1AnnotationBoundary) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1AnnotationBoundary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1AnnotatorSelector: Selector of all
// available annotators and phrase matchers to run.
type GoogleCloudContactcenterinsightsV1AnnotatorSelector struct {
	// IssueModels: The issue model to run. If not provided, the most recently
	// deployed topic model will be used. The provided issue model will only be
	// used for inference if the issue model is deployed and if
	// run_issue_model_annotator is set to true. If more than one issue model is
	// provided, only the first provided issue model will be used for inference.
	IssueModels []string `json:"issueModels,omitempty"`
	// PhraseMatchers: The list of phrase matchers to run. If not provided, all
	// active phrase matchers will be used. If inactive phrase matchers are
	// provided, they will not be used. Phrase matchers will be run only if
	// run_phrase_matcher_annotator is set to true. Format:
	// projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}
	PhraseMatchers []string `json:"phraseMatchers,omitempty"`
	// QaConfig: Configuration for the QA annotator.
	QaConfig *GoogleCloudContactcenterinsightsV1AnnotatorSelectorQaConfig `json:"qaConfig,omitempty"`
	// RunEntityAnnotator: Whether to run the entity annotator.
	RunEntityAnnotator bool `json:"runEntityAnnotator,omitempty"`
	// RunIntentAnnotator: Whether to run the intent annotator.
	RunIntentAnnotator bool `json:"runIntentAnnotator,omitempty"`
	// RunInterruptionAnnotator: Whether to run the interruption annotator.
	RunInterruptionAnnotator bool `json:"runInterruptionAnnotator,omitempty"`
	// RunIssueModelAnnotator: Whether to run the issue model annotator. A model
	// should have already been deployed for this to take effect.
	RunIssueModelAnnotator bool `json:"runIssueModelAnnotator,omitempty"`
	// RunPhraseMatcherAnnotator: Whether to run the active phrase matcher
	// annotator(s).
	RunPhraseMatcherAnnotator bool `json:"runPhraseMatcherAnnotator,omitempty"`
	// RunQaAnnotator: Whether to run the QA annotator.
	RunQaAnnotator bool `json:"runQaAnnotator,omitempty"`
	// RunSentimentAnnotator: Whether to run the sentiment annotator.
	RunSentimentAnnotator bool `json:"runSentimentAnnotator,omitempty"`
	// RunSilenceAnnotator: Whether to run the silence annotator.
	RunSilenceAnnotator bool `json:"runSilenceAnnotator,omitempty"`
	// RunSummarizationAnnotator: Whether to run the summarization annotator.
	RunSummarizationAnnotator bool `json:"runSummarizationAnnotator,omitempty"`
	// SummarizationConfig: Configuration for the summarization annotator.
	SummarizationConfig *GoogleCloudContactcenterinsightsV1AnnotatorSelectorSummarizationConfig `json:"summarizationConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IssueModels") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IssueModels") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1AnnotatorSelector) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1AnnotatorSelector
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1AnnotatorSelectorQaConfig: Configuration
// for the QA feature.
type GoogleCloudContactcenterinsightsV1AnnotatorSelectorQaConfig struct {
	// ScorecardList: A manual list of scorecards to score.
	ScorecardList *GoogleCloudContactcenterinsightsV1AnnotatorSelectorQaConfigScorecardList `json:"scorecardList,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ScorecardList") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ScorecardList") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1AnnotatorSelectorQaConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1AnnotatorSelectorQaConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1AnnotatorSelectorQaConfigScorecardList:
// Container for a list of scorecards.
type GoogleCloudContactcenterinsightsV1AnnotatorSelectorQaConfigScorecardList struct {
	// QaScorecardRevisions: List of QaScorecardRevisions.
	QaScorecardRevisions []string `json:"qaScorecardRevisions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QaScorecardRevisions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QaScorecardRevisions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1AnnotatorSelectorQaConfigScorecardList) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1AnnotatorSelectorQaConfigScorecardList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1AnnotatorSelectorSummarizationConfig:
// Configuration for summarization.
type GoogleCloudContactcenterinsightsV1AnnotatorSelectorSummarizationConfig struct {
	// ConversationProfile: Resource name of the Dialogflow conversation profile.
	// Format:
	// projects/{project}/locations/{location}/conversationProfiles/{conversation_pr
	// ofile}
	ConversationProfile string `json:"conversationProfile,omitempty"`
	// Generator: The resource name of the existing created generator. Format:
	// projects//locations//generators/
	Generator string `json:"generator,omitempty"`
	// SummarizationModel: Default summarization model to be used.
	//
	// Possible values:
	//   "SUMMARIZATION_MODEL_UNSPECIFIED" - Unspecified summarization model.
	//   "BASELINE_MODEL" - The CCAI baseline model. This model is deprecated and
	// will be removed in the future. We recommend using `generator` instead.
	//   "BASELINE_MODEL_V2_0" - The CCAI baseline model, V2.0. This model is
	// deprecated and will be removed in the future. We recommend using `generator`
	// instead.
	SummarizationModel string `json:"summarizationModel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationProfile") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationProfile") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1AnnotatorSelectorSummarizationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1AnnotatorSelectorSummarizationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1AnswerFeedback: The feedback that the
// customer has about a certain answer in the conversation.
type GoogleCloudContactcenterinsightsV1AnswerFeedback struct {
	// Clicked: Indicates whether an answer or item was clicked by the human agent.
	Clicked bool `json:"clicked,omitempty"`
	// CorrectnessLevel: The correctness level of an answer.
	//
	// Possible values:
	//   "CORRECTNESS_LEVEL_UNSPECIFIED" - Correctness level unspecified.
	//   "NOT_CORRECT" - Answer is totally wrong.
	//   "PARTIALLY_CORRECT" - Answer is partially correct.
	//   "FULLY_CORRECT" - Answer is fully correct.
	CorrectnessLevel string `json:"correctnessLevel,omitempty"`
	// Displayed: Indicates whether an answer or item was displayed to the human
	// agent in the agent desktop UI.
	Displayed bool `json:"displayed,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Clicked") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Clicked") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1AnswerFeedback) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1AnswerFeedback
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1AppealAssessmentRequest: The message to
// appeal an assessment.
type GoogleCloudContactcenterinsightsV1AppealAssessmentRequest struct {
}

// GoogleCloudContactcenterinsightsV1ArticleSuggestionData: Agent Assist
// Article Suggestion data.
type GoogleCloudContactcenterinsightsV1ArticleSuggestionData struct {
	// ConfidenceScore: The system's confidence score that this article is a good
	// match for this conversation, ranging from 0.0 (completely uncertain) to 1.0
	// (completely certain).
	ConfidenceScore float64 `json:"confidenceScore,omitempty"`
	// Metadata: Map that contains metadata about the Article Suggestion and the
	// document that it originates from.
	Metadata map[string]string `json:"metadata,omitempty"`
	// QueryRecord: The name of the answer record. Format:
	// projects/{project}/locations/{location}/answerRecords/{answer_record}
	QueryRecord string `json:"queryRecord,omitempty"`
	// Source: The knowledge document that this answer was extracted from. Format:
	// projects/{project}/knowledgeBases/{knowledge_base}/documents/{document}
	Source string `json:"source,omitempty"`
	// Title: Article title.
	Title string `json:"title,omitempty"`
	// Uri: Article URI.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfidenceScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfidenceScore") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ArticleSuggestionData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ArticleSuggestionData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1ArticleSuggestionData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1ArticleSuggestionData
	var s1 struct {
		ConfidenceScore gensupport.JSONFloat64 `json:"confidenceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceScore = float64(s1.ConfidenceScore)
	return nil
}

// GoogleCloudContactcenterinsightsV1Assessment: The assessment resource.
type GoogleCloudContactcenterinsightsV1Assessment struct {
	// AgentInfo: Information about the agent the assessment is for.
	AgentInfo *GoogleCloudContactcenterinsightsV1ConversationQualityMetadataAgentInfo `json:"agentInfo,omitempty"`
	// CreateTime: Output only. The time at which the assessment was created.
	CreateTime string `json:"createTime,omitempty"`
	// Name: Identifier. The resource name of the assessment. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}/assessme
	// nts/{assessment}
	Name string `json:"name,omitempty"`
	// State: Output only. The state of the assessment.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The state is unspecified. This value should not be
	// used.
	//   "DRAFT" - The default state of all new assessments.
	//   "PUBLISHED" - The assessment has been published.
	//   "APPEALED" - The assessment has been appealed.
	//   "FINALIZED" - The assessment has been finalized.
	State string `json:"state,omitempty"`
	// UpdateTime: Output only. The time at which the assessment was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AgentInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1Assessment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1Assessment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1AssessmentRule: The CCAI Insights project
// wide assessment rule. This assessment rule will be applied to all
// conversations from the previous sampling cycle that match the sample rule
// defined in the assessment rule. One project can have multiple assessment
// rules.
type GoogleCloudContactcenterinsightsV1AssessmentRule struct {
	// Active: If true, apply this rule to conversations. Otherwise, this rule is
	// inactive.
	Active bool `json:"active,omitempty"`
	// CreateTime: Output only. The time at which this assessment rule was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Display Name of the assessment rule.
	DisplayName string `json:"displayName,omitempty"`
	// Name: Identifier. The resource name of the assessment rule. Format:
	// projects/{project}/locations/{location}/assessmentRules/{assessment_rule}
	Name string `json:"name,omitempty"`
	// SampleRule: The sample rule for the assessment rule.
	SampleRule *GoogleCloudContactcenterinsightsV1SampleRule `json:"sampleRule,omitempty"`
	// ScheduleInfo: Schedule info for the assessment rule.
	ScheduleInfo *GoogleCloudContactcenterinsightsV1ScheduleInfo `json:"scheduleInfo,omitempty"`
	// UpdateTime: Output only. The most recent time at which this assessment rule
	// was updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Active") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Active") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1AssessmentRule) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1AssessmentRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1AuthorizedView: An AuthorizedView
// represents a view of accessible Insights resources (for example,
// Conversation and Scorecard). Who have read access to the AuthorizedView
// resource will have access to these Insight resources as well.
type GoogleCloudContactcenterinsightsV1AuthorizedView struct {
	// ConversationFilter: A filter to reduce conversation results to a specific
	// subset. The AuthorizedView's assigned permission (read/write) could be
	// applied to the subset of conversations. If conversation_filter is empty,
	// there is no restriction on the conversations that the AuthorizedView can
	// access. Having *authorizedViews.get* access to the AuthorizedView means
	// having the same read/write access to the Conversations (as well as
	// metadata/annotations linked to the conversation) that this AuthorizedView
	// has.
	ConversationFilter string `json:"conversationFilter,omitempty"`
	// CreateTime: Output only. The time at which the authorized view was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Display Name. Limit 64 characters.
	DisplayName string `json:"displayName,omitempty"`
	// Name: Identifier. The resource name of the AuthorizedView. Format:
	// projects/{project}/locations/{location}/authorizedViewSets/{authorized_view_s
	// et}/authorizedViews/{authorized_view}
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. The most recent time at which the authorized view
	// was updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ConversationFilter") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationFilter") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1AuthorizedView) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1AuthorizedView
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1AuthorizedViewSet: An AuthorizedViewSet
// contains a set of AuthorizedView resources.
type GoogleCloudContactcenterinsightsV1AuthorizedViewSet struct {
	// CreateTime: Output only. Create time.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Display Name. Limit 64 characters.
	DisplayName string `json:"displayName,omitempty"`
	// Name: Identifier. The resource name of the AuthorizedViewSet. Format:
	// projects/{project}/locations/{location}/authorizedViewSets/{authorized_view_s
	// et}
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. Update time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1AuthorizedViewSet) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1AuthorizedViewSet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1AutoLabelingRule: Rule for auto-labeling
// conversations.
type GoogleCloudContactcenterinsightsV1AutoLabelingRule struct {
	// Active: Whether the rule is active.
	Active bool `json:"active,omitempty"`
	// Conditions: Conditions to apply for auto-labeling the label_key.
	// Representing sequential block of if .. else if .. else statements. The value
	// of the first matching condition will be used.
	Conditions []*GoogleCloudContactcenterinsightsV1AutoLabelingRuleLabelingCondition `json:"conditions,omitempty"`
	// CreateTime: Output only. The time at which this rule was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: The description of the rule.
	Description string `json:"description,omitempty"`
	// DisplayName: The user-provided display name of the rule.
	DisplayName string `json:"displayName,omitempty"`
	// LabelKey: The label key. This is also the {auto_labeling_rule} in the
	// resource name. Only settable if label_key_type is LABEL_KEY_TYPE_CUSTOM.
	LabelKey string `json:"labelKey,omitempty"`
	// LabelKeyType: The type of the label key.
	//
	// Possible values:
	//   "LABEL_KEY_TYPE_UNSPECIFIED" - Unspecified label key type.
	//   "LABEL_KEY_TYPE_CUSTOM" - The label key is custom defined by the user.
	LabelKeyType string `json:"labelKeyType,omitempty"`
	// Name: Identifier. The resource name of the auto-labeling rule. Format:
	// projects/{project}/locations/{location}/autoLabelingRules/{auto_labeling_rule
	// }
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. The most recent time at which the rule was updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Active") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Active") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1AutoLabelingRule) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1AutoLabelingRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1AutoLabelingRuleLabelingCondition:
// Condition for auto-labeling conversations.
type GoogleCloudContactcenterinsightsV1AutoLabelingRuleLabelingCondition struct {
	// Condition: A optional CEL expression to be evaluated as a boolean value.
	// Once evaluated as true, then we will proceed with the value evaluation. An
	// empty condition will be auto evaluated as true.
	Condition string `json:"condition,omitempty"`
	// Value: CEL expression to be evaluated as the value.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1AutoLabelingRuleLabelingCondition) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1AutoLabelingRuleLabelingCondition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsMetadata: The
// metadata for a bulk analyze conversations operation.
type GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsMetadata struct {
	// CompletedAnalysesCount: The number of requested analyses that have completed
	// successfully so far.
	CompletedAnalysesCount int64 `json:"completedAnalysesCount,omitempty"`
	// CreateTime: The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// FailedAnalysesCount: The number of requested analyses that have failed so
	// far.
	FailedAnalysesCount int64 `json:"failedAnalysesCount,omitempty"`
	// PartialErrors: Output only. Partial errors during bulk analyze operation
	// that might cause the operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: The original request for bulk analyze.
	Request *GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsRequest `json:"request,omitempty"`
	// TotalRequestedAnalysesCount: Total number of analyses requested. Computed by
	// the number of conversations returned by `filter` multiplied by
	// `analysis_percentage` in the request.
	TotalRequestedAnalysesCount int64 `json:"totalRequestedAnalysesCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompletedAnalysesCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompletedAnalysesCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsRequest: The
// request to analyze conversations in bulk.
type GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsRequest struct {
	// AnalysisPercentage: Required. Percentage of selected conversation to
	// analyze, between [0, 100].
	AnalysisPercentage float64 `json:"analysisPercentage,omitempty"`
	// AnnotatorSelector: To select the annotators to run and the phrase matchers
	// to use (if any). If not specified, all annotators will be run.
	AnnotatorSelector *GoogleCloudContactcenterinsightsV1AnnotatorSelector `json:"annotatorSelector,omitempty"`
	// Filter: Required. Filter used to select the subset of conversations to
	// analyze.
	Filter string `json:"filter,omitempty"`
	// Parent: Required. The parent resource to create analyses in.
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnalysisPercentage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalysisPercentage") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsRequest) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsRequest
	var s1 struct {
		AnalysisPercentage gensupport.JSONFloat64 `json:"analysisPercentage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AnalysisPercentage = float64(s1.AnalysisPercentage)
	return nil
}

// GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsResponse: The
// response for a bulk analyze conversations operation.
type GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsResponse struct {
	// FailedAnalysisCount: Count of failed analyses.
	FailedAnalysisCount int64 `json:"failedAnalysisCount,omitempty"`
	// SuccessfulAnalysisCount: Count of successful analyses.
	SuccessfulAnalysisCount int64 `json:"successfulAnalysisCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FailedAnalysisCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FailedAnalysisCount") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1BulkDeleteConversationsMetadata: The
// metadata for a bulk delete conversations operation.
type GoogleCloudContactcenterinsightsV1BulkDeleteConversationsMetadata struct {
	// CreateTime: The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// PartialErrors: Partial errors during bulk delete conversations operation
	// that might cause the operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: The original request for bulk delete.
	Request *GoogleCloudContactcenterinsightsV1BulkDeleteConversationsRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1BulkDeleteConversationsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1BulkDeleteConversationsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1BulkDeleteConversationsRequest: The
// request to delete conversations in bulk.
type GoogleCloudContactcenterinsightsV1BulkDeleteConversationsRequest struct {
	// Filter: Filter used to select the subset of conversations to delete.
	Filter string `json:"filter,omitempty"`
	// Force: If set to true, all of this conversation's analyses will also be
	// deleted. Otherwise, the request will only succeed if the conversation has no
	// analyses.
	Force bool `json:"force,omitempty"`
	// MaxDeleteCount: Maximum number of conversations to delete.
	MaxDeleteCount int64 `json:"maxDeleteCount,omitempty"`
	// Parent: Required. The parent resource to delete conversations from. Format:
	// projects/{project}/locations/{location}
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1BulkDeleteConversationsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1BulkDeleteConversationsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1BulkDeleteConversationsResponse: The
// response for a bulk delete conversations operation.
type GoogleCloudContactcenterinsightsV1BulkDeleteConversationsResponse struct {
}

// GoogleCloudContactcenterinsightsV1BulkDeleteFeedbackLabelsMetadata: Metadata
// for the BulkDeleteFeedbackLabels endpoint.
type GoogleCloudContactcenterinsightsV1BulkDeleteFeedbackLabelsMetadata struct {
	// PartialErrors: Partial errors during deletion operation that might cause the
	// operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: Output only. The original request for delete.
	Request *GoogleCloudContactcenterinsightsV1BulkDeleteFeedbackLabelsRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PartialErrors") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PartialErrors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1BulkDeleteFeedbackLabelsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1BulkDeleteFeedbackLabelsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1BulkDeleteFeedbackLabelsRequest: Request
// for the BulkDeleteFeedbackLabels endpoint.
type GoogleCloudContactcenterinsightsV1BulkDeleteFeedbackLabelsRequest struct {
	// Filter: Optional. A filter to reduce results to a specific subset. Supports
	// disjunctions (OR) and conjunctions (AND). Supported fields: *
	// `issue_model_id` * `qa_question_id` * `qa_scorecard_id` * `min_create_time`
	// * `max_create_time` * `min_update_time` * `max_update_time` *
	// `feedback_label_type`: QUALITY_AI, TOPIC_MODELING
	Filter string `json:"filter,omitempty"`
	// Parent: Required. The parent resource for new feedback labels.
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1BulkDeleteFeedbackLabelsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1BulkDeleteFeedbackLabelsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1BulkDeleteFeedbackLabelsResponse: Response
// for the BulkDeleteFeedbackLabels endpoint.
type GoogleCloudContactcenterinsightsV1BulkDeleteFeedbackLabelsResponse struct {
}

// GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsMetadata:
// Metadata for the BulkDownloadFeedbackLabel endpoint.
type GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// DownloadStats: Output only. Statistics for BulkDownloadFeedbackLabels
	// operation.
	DownloadStats *GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsMetadataDownloadStats `json:"downloadStats,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// PartialErrors: Partial errors during ingest operation that might cause the
	// operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: Output only. The original request for download.
	Request *GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsMetadataDownloadS
// tats: Statistics for BulkDownloadFeedbackLabels operation.
type GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsMetadataDownloadStats struct {
	// FileNames: Output only. Full name of the files written to Cloud storage.
	FileNames []string `json:"fileNames,omitempty"`
	// ProcessedObjectCount: The number of objects processed during the download
	// operation.
	ProcessedObjectCount int64 `json:"processedObjectCount,omitempty"`
	// SuccessfulDownloadCount: The number of new feedback labels downloaded during
	// this operation. Different from "processed" because some labels might not be
	// downloaded because an error.
	SuccessfulDownloadCount int64 `json:"successfulDownloadCount,omitempty"`
	// TotalFilesWritten: Total number of files written to the provided Cloud
	// Storage bucket.
	TotalFilesWritten int64 `json:"totalFilesWritten,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FileNames") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FileNames") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsMetadataDownloadStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsMetadataDownloadStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequest: Request
// for the BulkDownloadFeedbackLabel endpoint.
type GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequest struct {
	// ConversationFilter: Optional. Filter parent conversations to download
	// feedback labels for. When specified, the feedback labels will be downloaded
	// for the conversations that match the filter. If `template_qa_scorecard_id`
	// is set, all the conversations that match the filter will be paired with the
	// questions under the scorecard for labeling.
	ConversationFilter string `json:"conversationFilter,omitempty"`
	// FeedbackLabelType: Optional. The type of feedback labels that will be
	// downloaded.
	//
	// Possible values:
	//   "FEEDBACK_LABEL_TYPE_UNSPECIFIED" - Unspecified format
	//   "QUALITY_AI" - Downloaded file will contain all Quality AI labels from the
	// latest scorecard revision.
	//   "TOPIC_MODELING" - Downloaded file will contain only Topic Modeling
	// labels.
	//   "AGENT_ASSIST_SUMMARY" - Agent Assist Summarization labels.
	FeedbackLabelType string `json:"feedbackLabelType,omitempty"`
	// Filter: Optional. A filter to reduce results to a specific subset. Supports
	// disjunctions (OR) and conjunctions (AND). Supported fields: *
	// `issue_model_id` * `qa_question_id` * `qa_scorecard_id` * `min_create_time`
	// * `max_create_time` * `min_update_time` * `max_update_time` *
	// `feedback_label_type`: QUALITY_AI, TOPIC_MODELING
	Filter string `json:"filter,omitempty"`
	// GcsDestination: A cloud storage bucket destination.
	GcsDestination *GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequestGcsDestination `json:"gcsDestination,omitempty"`
	// MaxDownloadCount: Optional. Limits the maximum number of feedback labels
	// that will be downloaded. The first `N` feedback labels will be downloaded.
	MaxDownloadCount int64 `json:"maxDownloadCount,omitempty"`
	// Parent: Required. The parent resource for new feedback labels.
	Parent string `json:"parent,omitempty"`
	// SheetsDestination: A sheets document destination.
	SheetsDestination *GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequestSheetsDestination `json:"sheetsDestination,omitempty"`
	// TemplateQaScorecardId: Optional. If set, a template for labeling
	// conversations and scorecard questions will be created from the
	// conversation_filter and the questions under the scorecard(s). The feedback
	// label `filter` will be ignored.
	TemplateQaScorecardId []string `json:"templateQaScorecardId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationFilter") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationFilter") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequestGcsDestina
// tion: Google Cloud Storage Object details to write the feedback labels to.
type GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequestGcsDestination struct {
	// AddWhitespace: Optional. Add whitespace to the JSON file. Makes easier to
	// read, but increases file size. Only applicable for JSON format.
	AddWhitespace bool `json:"addWhitespace,omitempty"`
	// AlwaysPrintEmptyFields: Optional. Always print fields with no presence. This
	// is useful for printing fields that are not set, like implicit 0 value or
	// empty lists/maps. Only applicable for JSON format.
	AlwaysPrintEmptyFields bool `json:"alwaysPrintEmptyFields,omitempty"`
	// Format: Required. File format in which the labels will be exported.
	//
	// Possible values:
	//   "FORMAT_UNSPECIFIED" - Unspecified format.
	//   "CSV" - CSV format. 1,000 labels are stored per CSV file by default.
	//   "JSON" - JSON format. 1 label stored per JSON file by default.
	Format string `json:"format,omitempty"`
	// ObjectUri: Required. The Google Cloud Storage URI to write the feedback
	// labels to. The file name will be used as a prefix for the files written to
	// the bucket if the output needs to be split across multiple files, otherwise
	// it will be used as is. The file extension will be appended to the file name
	// based on the format selected. E.g. `gs://bucket_name/object_uri_prefix`
	ObjectUri string `json:"objectUri,omitempty"`
	// RecordsPerFileCount: Optional. The number of records per file. Applicable
	// for either format.
	RecordsPerFileCount int64 `json:"recordsPerFileCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "AddWhitespace") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AddWhitespace") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequestGcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequestGcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequestSheetsDest
// ination: Google Sheets document details to write the feedback labels to.
type GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequestSheetsDestination struct {
	// SheetTitle: Optional. The title of the new sheet to write the feedback
	// labels to.
	SheetTitle string `json:"sheetTitle,omitempty"`
	// SpreadsheetUri: Required. The Google Sheets document to write the feedback
	// labels to. Retrieved from Google Sheets URI. E.g.
	// `https://docs.google.com/spreadsheets/d/1234567890` The spreadsheet must be
	// shared with the Insights P4SA. The spreadsheet ID written to will be
	// returned as `file_names` in the BulkDownloadFeedbackLabelsMetadata.
	SpreadsheetUri string `json:"spreadsheetUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SheetTitle") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SheetTitle") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequestSheetsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequestSheetsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsResponse:
// Response for the BulkDownloadFeedbackLabel endpoint.
type GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsResponse struct {
}

// GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequest: The
// request for bulk uploading feedback labels.
type GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequest struct {
	// GcsSource: A cloud storage bucket source.
	GcsSource *GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequestGcsSource `json:"gcsSource,omitempty"`
	// SheetsSource: A sheets document source.
	SheetsSource *GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequestSheetsSource `json:"sheetsSource,omitempty"`
	// ValidateOnly: Optional. If set, upload will not happen and the labels will
	// be validated. If not set, then default behavior will be to upload the labels
	// after validation is complete.
	ValidateOnly bool `json:"validateOnly,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsSource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequestGcsSource:
// Google Cloud Storage Object details to get the feedback label file from.
type GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequestGcsSource struct {
	// Format: Required. File format which will be ingested.
	//
	// Possible values:
	//   "FORMAT_UNSPECIFIED" - Unspecified format.
	//   "CSV" - CSV format.
	//   "JSON" - JSON format.
	Format string `json:"format,omitempty"`
	// ObjectUri: Required. The Google Cloud Storage URI of the file to import.
	// Format: `gs://bucket_name/object_name`
	ObjectUri string `json:"objectUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Format") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Format") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequestGcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequestGcsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequestSheetsSource
// : Google Sheets document details to get the feedback label file from.
type GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequestSheetsSource struct {
	// SpreadsheetUri: Required. The Google Sheets document to write the feedback
	// labels to. Retrieved from Google Sheets URI. E.g.
	// `https://docs.google.com/spreadsheets/d/1234567890` The spreadsheet must be
	// shared with the Insights P4SA.
	SpreadsheetUri string `json:"spreadsheetUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SpreadsheetUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SpreadsheetUri") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequestSheetsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequestSheetsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1CalculateIssueModelStatsResponse: Response
// of querying an issue model's statistics.
type GoogleCloudContactcenterinsightsV1CalculateIssueModelStatsResponse struct {
	// CurrentStats: The latest label statistics for the queried issue model.
	// Includes results on both training data and data labeled after deployment.
	CurrentStats *GoogleCloudContactcenterinsightsV1IssueModelLabelStats `json:"currentStats,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CurrentStats") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrentStats") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1CalculateIssueModelStatsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1CalculateIssueModelStatsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1CalculateStatsRequest: The request for
// calculating conversation statistics.
type GoogleCloudContactcenterinsightsV1CalculateStatsRequest struct {
	// Filter: A filter to reduce results to a specific subset. This field is
	// useful for getting statistics about conversations with specific properties.
	Filter string `json:"filter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1CalculateStatsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1CalculateStatsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1CalculateStatsResponse: The response for
// calculating conversation statistics.
type GoogleCloudContactcenterinsightsV1CalculateStatsResponse struct {
	// AverageDuration: The average duration of all conversations. The average is
	// calculated using only conversations that have a time duration.
	AverageDuration string `json:"averageDuration,omitempty"`
	// AverageTurnCount: The average number of turns per conversation.
	AverageTurnCount int64 `json:"averageTurnCount,omitempty"`
	// ConversationCount: The total number of conversations.
	ConversationCount int64 `json:"conversationCount,omitempty"`
	// ConversationCountTimeSeries: A time series representing the count of
	// conversations created over time that match that requested filter criteria.
	ConversationCountTimeSeries *GoogleCloudContactcenterinsightsV1CalculateStatsResponseTimeSeries `json:"conversationCountTimeSeries,omitempty"`
	// CustomHighlighterMatches: A map associating each custom highlighter resource
	// name with its respective number of matches in the set of conversations.
	CustomHighlighterMatches map[string]int64 `json:"customHighlighterMatches,omitempty"`
	// IssueMatches: A map associating each issue resource name with its respective
	// number of matches in the set of conversations. Key has the format:
	// `projects//locations//issueModels//issues/` Deprecated, use
	// `issue_matches_stats` field instead.
	IssueMatches map[string]int64 `json:"issueMatches,omitempty"`
	// IssueMatchesStats: A map associating each issue resource name with its
	// respective number of matches in the set of conversations. Key has the
	// format: `projects//locations//issueModels//issues/`
	IssueMatchesStats map[string]GoogleCloudContactcenterinsightsV1IssueModelLabelStatsIssueStats `json:"issueMatchesStats,omitempty"`
	// SmartHighlighterMatches: A map associating each smart highlighter display
	// name with its respective number of matches in the set of conversations.
	SmartHighlighterMatches map[string]int64 `json:"smartHighlighterMatches,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AverageDuration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AverageDuration") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1CalculateStatsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1CalculateStatsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1CalculateStatsResponseTimeSeries: A time
// series representing conversations over time.
type GoogleCloudContactcenterinsightsV1CalculateStatsResponseTimeSeries struct {
	// IntervalDuration: The duration of each interval.
	IntervalDuration string `json:"intervalDuration,omitempty"`
	// Points: An ordered list of intervals from earliest to latest, where each
	// interval represents the number of conversations that transpired during the
	// time window.
	Points []*GoogleCloudContactcenterinsightsV1CalculateStatsResponseTimeSeriesInterval `json:"points,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IntervalDuration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IntervalDuration") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1CalculateStatsResponseTimeSeries) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1CalculateStatsResponseTimeSeries
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1CalculateStatsResponseTimeSeriesInterval:
// A single interval in a time series.
type GoogleCloudContactcenterinsightsV1CalculateStatsResponseTimeSeriesInterval struct {
	// ConversationCount: The number of conversations created in this interval.
	ConversationCount int64 `json:"conversationCount,omitempty"`
	// StartTime: The start time of this interval.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1CalculateStatsResponseTimeSeriesInterval) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1CalculateStatsResponseTimeSeriesInterval
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1CallAnnotation: A piece of metadata that
// applies to a window of a call.
type GoogleCloudContactcenterinsightsV1CallAnnotation struct {
	// AnnotationEndBoundary: The boundary in the conversation where the annotation
	// ends, inclusive.
	AnnotationEndBoundary *GoogleCloudContactcenterinsightsV1AnnotationBoundary `json:"annotationEndBoundary,omitempty"`
	// AnnotationStartBoundary: The boundary in the conversation where the
	// annotation starts, inclusive.
	AnnotationStartBoundary *GoogleCloudContactcenterinsightsV1AnnotationBoundary `json:"annotationStartBoundary,omitempty"`
	// ChannelTag: The channel of the audio where the annotation occurs. For
	// single-channel audio, this field is not populated.
	ChannelTag int64 `json:"channelTag,omitempty"`
	// EntityMentionData: Data specifying an entity mention.
	EntityMentionData *GoogleCloudContactcenterinsightsV1EntityMentionData `json:"entityMentionData,omitempty"`
	// HoldData: Data specifying a hold.
	HoldData *GoogleCloudContactcenterinsightsV1HoldData `json:"holdData,omitempty"`
	// IntentMatchData: Data specifying an intent match.
	IntentMatchData *GoogleCloudContactcenterinsightsV1IntentMatchData `json:"intentMatchData,omitempty"`
	// InterruptionData: Data specifying an interruption.
	InterruptionData *GoogleCloudContactcenterinsightsV1InterruptionData `json:"interruptionData,omitempty"`
	// IssueMatchData: Data specifying an issue match.
	IssueMatchData *GoogleCloudContactcenterinsightsV1IssueMatchData `json:"issueMatchData,omitempty"`
	// PhraseMatchData: Data specifying a phrase match.
	PhraseMatchData *GoogleCloudContactcenterinsightsV1PhraseMatchData `json:"phraseMatchData,omitempty"`
	// SentimentData: Data specifying sentiment.
	SentimentData *GoogleCloudContactcenterinsightsV1SentimentData `json:"sentimentData,omitempty"`
	// SilenceData: Data specifying silence.
	SilenceData *GoogleCloudContactcenterinsightsV1SilenceData `json:"silenceData,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationEndBoundary") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationEndBoundary") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1CallAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1CallAnnotation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1Chart: Configurable dashboard's widget
// that displays data as a chart.
type GoogleCloudContactcenterinsightsV1Chart struct {
	// ChartType: Output only. Chart type.
	//
	// Possible values:
	//   "CHART_TYPE_UNSPECIFIED" - Unspecified chart type.
	//   "SYSTEM_DEFINED" - Pre-defined chart type.
	//   "USER_DEFINED" - Configurable chart type.
	ChartType string `json:"chartType,omitempty"`
	// ChartVisualizationType: Chart visualization type.
	//
	// Possible values:
	//   "CHART_VISUALIZATION_TYPE_UNSPECIFIED" - Unspecified chart visualization
	// type.
	//   "BAR" - Bar chart.
	//   "LINE" - Line chart.
	//   "AREA" - Area chart.
	//   "PIE" - Pie chart.
	//   "SCATTER" - Scatter chart.
	//   "TABLE" - Table chart.
	//   "SCORE_CARD" - Score card chart.
	//   "SUNBURST" - Sunburst chart.
	//   "GAUGE" - Gauge chart.
	//   "SANKEY" - Sankey chart.
	ChartVisualizationType string `json:"chartVisualizationType,omitempty"`
	// CreateTime: Output only. Chart create time.
	CreateTime string                                             `json:"createTime,omitempty"`
	DataSource *GoogleCloudContactcenterinsightsV1ChartDataSource `json:"dataSource,omitempty"`
	// DateRangeConfig: Date range config applied to the chart.
	DateRangeConfig *GoogleCloudContactcenterinsightsV1DateRangeConfig `json:"dateRangeConfig,omitempty"`
	// Description: Chart description
	Description string `json:"description,omitempty"`
	// DisplayName: User provided display name of the chart.
	DisplayName string `json:"displayName,omitempty"`
	// Filter: Filter applied to all charts in the container. Should support scope
	// later.
	Filter string `json:"filter,omitempty"`
	// Height: The height of the chart in grid units.
	Height int64 `json:"height,omitempty"`
	// Name: Identifier. Chart resource name. Format:
	// projects/{project}/locations/{location}/dashboards/{dashboard}/charts/{chart}
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. Chart last update time.
	UpdateTime string `json:"updateTime,omitempty"`
	// Width: The width of the chart in grid units.
	Width int64 `json:"width,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ChartType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChartType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1Chart) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1Chart
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ChartDataSource: The request data for
// visualizing the dataset in the chart.
type GoogleCloudContactcenterinsightsV1ChartDataSource struct {
	// GenerativeInsights: Use natural language query to generate the chart.
	GenerativeInsights *GoogleCloudContactcenterinsightsV1GenerativeInsights `json:"generativeInsights,omitempty"`
	// QueryMetrics: Use the existing QueryMetrics to generate the chart.
	QueryMetrics *GoogleCloudContactcenterinsightsV1QueryMetrics `json:"queryMetrics,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenerativeInsights") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenerativeInsights") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ChartDataSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ChartDataSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ConstraintEvaluationResult: The result of
// testing a constraint expression on a pair of conversations.
type GoogleCloudContactcenterinsightsV1ConstraintEvaluationResult struct {
	// ConversationA: The first conversation resource name.
	ConversationA string `json:"conversationA,omitempty"`
	// ConversationB: The second conversation resource name.
	ConversationB string `json:"conversationB,omitempty"`
	// RuleConstraintResults: The results for each applicable constraint rule.
	RuleConstraintResults []*GoogleCloudContactcenterinsightsV1ConstraintEvaluationResultRuleConstraintResult `json:"ruleConstraintResults,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationA") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationA") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ConstraintEvaluationResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConstraintEvaluationResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ConstraintEvaluationResultRuleConstraintRes
// ult: The result of a single constraint rule on the pair of conversations.
type GoogleCloudContactcenterinsightsV1ConstraintEvaluationResultRuleConstraintResult struct {
	// ConstraintMet: Whether the constraint expression evaluated to true for (A,
	// B) or (B, A).
	ConstraintMet bool `json:"constraintMet,omitempty"`
	// Error: The error status if the constraint expression failed to evaluate.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// RuleId: The rule ID.
	RuleId string `json:"ruleId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConstraintMet") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConstraintMet") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ConstraintEvaluationResultRuleConstraintResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConstraintEvaluationResultRuleConstraintResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1Container: Configurable dashboard's
// container. Container can contain multiple widgets.
type GoogleCloudContactcenterinsightsV1Container struct {
	// ContainerId: Output only. Unique ID for the container.
	ContainerId string `json:"containerId,omitempty"`
	// DateRangeConfig: Date range config applied to all charts in the container.
	DateRangeConfig *GoogleCloudContactcenterinsightsV1DateRangeConfig `json:"dateRangeConfig,omitempty"`
	// Description: Container description
	Description string `json:"description,omitempty"`
	// DisplayName: User provided display name of the Container.
	DisplayName string `json:"displayName,omitempty"`
	// Filter: Filter applied to all charts in the container. Should support scope
	// later.
	Filter string `json:"filter,omitempty"`
	// Height: The height of the container in grid units.
	Height int64 `json:"height,omitempty"`
	// Widgets: Widgets in the Container.
	Widgets []*GoogleCloudContactcenterinsightsV1Widget `json:"widgets,omitempty"`
	// Width: The width of the container in grid units.
	Width int64 `json:"width,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContainerId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContainerId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1Container) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1Container
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1Conversation: The conversation resource.
type GoogleCloudContactcenterinsightsV1Conversation struct {
	// AgentId: An opaque, user-specified string representing the human agent who
	// handled the conversation.
	AgentId string `json:"agentId,omitempty"`
	// CallMetadata: Call-specific metadata.
	CallMetadata *GoogleCloudContactcenterinsightsV1ConversationCallMetadata `json:"callMetadata,omitempty"`
	// CorrelationInfo: Output only. Info for correlating across conversations.
	CorrelationInfo *GoogleCloudContactcenterinsightsV1ConversationCorrelationInfo `json:"correlationInfo,omitempty"`
	// CreateTime: Output only. The time at which the conversation was created.
	CreateTime string `json:"createTime,omitempty"`
	// DataSource: The source of the audio and transcription for the conversation.
	DataSource *GoogleCloudContactcenterinsightsV1ConversationDataSource `json:"dataSource,omitempty"`
	// DialogflowIntents: Output only. All the matched Dialogflow intents in the
	// call. The key corresponds to a Dialogflow intent, format:
	// projects/{project}/agent/{agent}/intents/{intent}
	DialogflowIntents map[string]GoogleCloudContactcenterinsightsV1DialogflowIntent `json:"dialogflowIntents,omitempty"`
	// Duration: Output only. The duration of the conversation.
	Duration string `json:"duration,omitempty"`
	// ExpireTime: The time at which this conversation should expire. After this
	// time, the conversation data and any associated analyses will be deleted.
	ExpireTime string `json:"expireTime,omitempty"`
	// Labels: A map for the user to specify any custom fields. A maximum of 100
	// labels per conversation is allowed, with a maximum of 256 characters per
	// entry.
	Labels map[string]string `json:"labels,omitempty"`
	// LanguageCode: A user-specified language code for the conversation.
	LanguageCode string `json:"languageCode,omitempty"`
	// LatestAnalysis: Output only. The conversation's latest analysis, if one
	// exists.
	LatestAnalysis *GoogleCloudContactcenterinsightsV1Analysis `json:"latestAnalysis,omitempty"`
	// LatestSummary: Output only. Latest summary of the conversation.
	LatestSummary *GoogleCloudContactcenterinsightsV1ConversationSummarizationSuggestionData `json:"latestSummary,omitempty"`
	// Medium: Immutable. The conversation medium.
	//
	// Possible values:
	//   "MEDIUM_UNSPECIFIED" - Default value for unspecified.
	//   "PHONE_CALL" - The format for conversations that took place over the
	// phone.
	//   "CHAT" - The format for conversations that took place over chat.
	Medium string `json:"medium,omitempty"`
	// MetadataJson: Input only. JSON metadata encoded as a string. This field is
	// primarily used by Insights integrations with various telephony systems and
	// must be in one of Insight's supported formats.
	MetadataJson string `json:"metadataJson,omitempty"`
	// Name: Immutable. The resource name of the conversation. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}
	Name string `json:"name,omitempty"`
	// ObfuscatedUserId: Obfuscated user ID which the customer sent to us.
	ObfuscatedUserId string `json:"obfuscatedUserId,omitempty"`
	// QualityMetadata: Conversation metadata related to quality management.
	QualityMetadata *GoogleCloudContactcenterinsightsV1ConversationQualityMetadata `json:"qualityMetadata,omitempty"`
	// RuntimeAnnotations: Output only. The annotations that were generated during
	// the customer and agent interaction.
	RuntimeAnnotations []*GoogleCloudContactcenterinsightsV1RuntimeAnnotation `json:"runtimeAnnotations,omitempty"`
	// StartTime: The time at which the conversation started.
	StartTime string `json:"startTime,omitempty"`
	// Transcript: Output only. The conversation transcript.
	Transcript *GoogleCloudContactcenterinsightsV1ConversationTranscript `json:"transcript,omitempty"`
	// Ttl: Input only. The TTL for this resource. If specified, then this TTL will
	// be used to calculate the expire time.
	Ttl string `json:"ttl,omitempty"`
	// TurnCount: Output only. The number of turns in the conversation.
	TurnCount int64 `json:"turnCount,omitempty"`
	// UpdateTime: Output only. The most recent time at which the conversation was
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AgentId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1Conversation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1Conversation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ConversationCallMetadata: Call-specific
// metadata.
type GoogleCloudContactcenterinsightsV1ConversationCallMetadata struct {
	// AgentChannel: The audio channel that contains the agent.
	AgentChannel int64 `json:"agentChannel,omitempty"`
	// CustomerChannel: The audio channel that contains the customer.
	CustomerChannel int64 `json:"customerChannel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentChannel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentChannel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ConversationCallMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationCallMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ConversationCorrelationInfo: Info for
// correlating across conversations.
type GoogleCloudContactcenterinsightsV1ConversationCorrelationInfo struct {
	// CorrelationTypes: Output only. The correlation types of this conversation. A
	// single conversation can have multiple correlation types. For example a
	// conversation that only has a single segment is both a SEGMENT and a
	// FULL_CONVERSATION.
	//
	// Possible values:
	//   "CORRELATION_TYPE_UNSPECIFIED" - Default value for unspecified.
	//   "SEGMENT" - This conversation represents a segment of a full conversation.
	// The lowest level of granularity.
	//   "PARTIAL" - This conversation represents a partial conversation of
	// potentially multiple segments but is not a full conversation.
	//   "FULL" - This conversation represents a full conversation of potentially
	// multiple segments.
	//   "SYNTHETIC" - This conversation represents a synthetic conversation.
	CorrelationTypes []string `json:"correlationTypes,omitempty"`
	// FullConversationCorrelationId: Output only. The full conversation
	// correlation id this conversation is a segment of.
	FullConversationCorrelationId string `json:"fullConversationCorrelationId,omitempty"`
	// MergedFullConversationCorrelationId: Output only. The full conversation
	// correlation id this conversation is a merged conversation of.
	MergedFullConversationCorrelationId string `json:"mergedFullConversationCorrelationId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CorrelationTypes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CorrelationTypes") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ConversationCorrelationInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationCorrelationInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ConversationCorrelationResult: The result
// of testing correlation config on a single conversation.
type GoogleCloudContactcenterinsightsV1ConversationCorrelationResult struct {
	// Conversation: The conversation resource name.
	Conversation string `json:"conversation,omitempty"`
	// RuleResults: The results for each correlation rule.
	RuleResults []*GoogleCloudContactcenterinsightsV1ConversationCorrelationResultRuleCorrelationResult `json:"ruleResults,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conversation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conversation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ConversationCorrelationResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationCorrelationResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ConversationCorrelationResultRuleCorrelatio
// nResult: The result of a single correlation rule.
type GoogleCloudContactcenterinsightsV1ConversationCorrelationResultRuleCorrelationResult struct {
	// CorrelationId: The correlation ID generated by the join key expression.
	CorrelationId string `json:"correlationId,omitempty"`
	// Error: The error status if the join key expression failed to evaluate.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// RuleId: The rule ID.
	RuleId string `json:"ruleId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CorrelationId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CorrelationId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ConversationCorrelationResultRuleCorrelationResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationCorrelationResultRuleCorrelationResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ConversationDataOptions: Options for
// configuring what metadata is included in the conversation data used in QAI
// and Discovery Engine.
type GoogleCloudContactcenterinsightsV1ConversationDataOptions struct {
	// IncludeDialogflowInteractionData: Whether to include the per turn Dialogflow
	// interaction data in conversation transcript.
	IncludeDialogflowInteractionData bool `json:"includeDialogflowInteractionData,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "IncludeDialogflowInteractionData") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "IncludeDialogflowInteractionData") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields for
	// more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ConversationDataOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationDataOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ConversationDataSource: The conversation
// source, which is a combination of transcript and audio.
type GoogleCloudContactcenterinsightsV1ConversationDataSource struct {
	// DialogflowSource: The source when the conversation comes from Dialogflow.
	DialogflowSource *GoogleCloudContactcenterinsightsV1DialogflowSource `json:"dialogflowSource,omitempty"`
	// GcsSource: A Cloud Storage location specification for the audio and
	// transcript.
	GcsSource *GoogleCloudContactcenterinsightsV1GcsSource `json:"gcsSource,omitempty"`
	// MetadataUri: Cloud Storage URI that points to a file that contains the
	// conversation metadata.
	MetadataUri string `json:"metadataUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DialogflowSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DialogflowSource") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ConversationDataSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationDataSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ConversationDataSourceTurnLevelAudio: A
// wrapper for holding the audio for any given turn.
type GoogleCloudContactcenterinsightsV1ConversationDataSourceTurnLevelAudio struct {
	// AudioDuration: The duration of the audio.
	AudioDuration string `json:"audioDuration,omitempty"`
	// AudioGcsUri: The Cloud Storage URI of the audio for any given turn.
	AudioGcsUri string `json:"audioGcsUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioDuration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioDuration") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ConversationDataSourceTurnLevelAudio) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationDataSourceTurnLevelAudio
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ConversationLevelSentiment: One channel of
// conversation-level sentiment data.
type GoogleCloudContactcenterinsightsV1ConversationLevelSentiment struct {
	// ChannelTag: The channel of the audio that the data applies to.
	ChannelTag int64 `json:"channelTag,omitempty"`
	// SentimentData: Data specifying sentiment.
	SentimentData *GoogleCloudContactcenterinsightsV1SentimentData `json:"sentimentData,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChannelTag") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChannelTag") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ConversationLevelSentiment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationLevelSentiment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ConversationLevelSilence:
// Conversation-level silence data.
type GoogleCloudContactcenterinsightsV1ConversationLevelSilence struct {
	// SilenceDuration: Amount of time calculated to be in silence.
	SilenceDuration string `json:"silenceDuration,omitempty"`
	// SilencePercentage: Percentage of the total conversation spent in silence.
	SilencePercentage float64 `json:"silencePercentage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SilenceDuration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SilenceDuration") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ConversationLevelSilence) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationLevelSilence
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1ConversationLevelSilence) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationLevelSilence
	var s1 struct {
		SilencePercentage gensupport.JSONFloat64 `json:"silencePercentage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SilencePercentage = float64(s1.SilencePercentage)
	return nil
}

// GoogleCloudContactcenterinsightsV1ConversationParticipant: The call
// participant speaking for a given utterance.
type GoogleCloudContactcenterinsightsV1ConversationParticipant struct {
	// DialogflowParticipant: Deprecated. Use `dialogflow_participant_name`
	// instead. The name of the Dialogflow participant. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}/particip
	// ants/{participant}
	DialogflowParticipant string `json:"dialogflowParticipant,omitempty"`
	// DialogflowParticipantName: The name of the participant provided by
	// Dialogflow. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}/particip
	// ants/{participant}
	DialogflowParticipantName string `json:"dialogflowParticipantName,omitempty"`
	// ObfuscatedExternalUserId: Obfuscated user ID from Dialogflow.
	ObfuscatedExternalUserId string `json:"obfuscatedExternalUserId,omitempty"`
	// Role: The role of the participant.
	//
	// Possible values:
	//   "ROLE_UNSPECIFIED" - Participant's role is not set.
	//   "HUMAN_AGENT" - Participant is a human agent.
	//   "AUTOMATED_AGENT" - Participant is an automated agent.
	//   "END_USER" - Participant is an end user who conversed with the contact
	// center.
	//   "ANY_AGENT" - Participant is either a human or automated agent.
	Role string `json:"role,omitempty"`
	// UserId: A user-specified ID representing the participant.
	UserId string `json:"userId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DialogflowParticipant") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DialogflowParticipant") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ConversationParticipant) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationParticipant
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ConversationQualityMetadata: Conversation
// metadata related to quality management.
type GoogleCloudContactcenterinsightsV1ConversationQualityMetadata struct {
	// AgentInfo: Information about agents involved in the call.
	AgentInfo []*GoogleCloudContactcenterinsightsV1ConversationQualityMetadataAgentInfo `json:"agentInfo,omitempty"`
	// CustomerSatisfactionRating: An arbitrary integer value indicating the
	// customer's satisfaction rating.
	CustomerSatisfactionRating int64 `json:"customerSatisfactionRating,omitempty"`
	// FeedbackLabels: Input only. The feedback labels associated with the
	// conversation.
	FeedbackLabels []*GoogleCloudContactcenterinsightsV1FeedbackLabel `json:"feedbackLabels,omitempty"`
	// MenuPath: An arbitrary string value specifying the menu path the customer
	// took.
	MenuPath string `json:"menuPath,omitempty"`
	// WaitDuration: The amount of time the customer waited to connect with an
	// agent.
	WaitDuration string `json:"waitDuration,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ConversationQualityMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationQualityMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ConversationQualityMetadataAgentInfo:
// Information about an agent involved in the conversation.
type GoogleCloudContactcenterinsightsV1ConversationQualityMetadataAgentInfo struct {
	// AgentId: A user-specified string representing the agent.
	AgentId string `json:"agentId,omitempty"`
	// AgentType: The agent type, e.g. HUMAN_AGENT.
	//
	// Possible values:
	//   "ROLE_UNSPECIFIED" - Participant's role is not set.
	//   "HUMAN_AGENT" - Participant is a human agent.
	//   "AUTOMATED_AGENT" - Participant is an automated agent.
	//   "END_USER" - Participant is an end user who conversed with the contact
	// center.
	//   "ANY_AGENT" - Participant is either a human or automated agent.
	AgentType string `json:"agentType,omitempty"`
	// DeploymentDisplayName: The agent's deployment display name. Only applicable
	// to automated agents.
	DeploymentDisplayName string `json:"deploymentDisplayName,omitempty"`
	// DeploymentId: The agent's deployment ID. Only applicable to automated
	// agents.
	DeploymentId string `json:"deploymentId,omitempty"`
	// DisplayName: The agent's name.
	DisplayName string `json:"displayName,omitempty"`
	// DispositionCode: A user-provided string indicating the outcome of the
	// agent's segment of the call.
	DispositionCode string `json:"dispositionCode,omitempty"`
	// Location: The agent's location.
	Location string `json:"location,omitempty"`
	// Team: A user-specified string representing the agent's team. Deprecated in
	// favor of the `teams` field.
	Team string `json:"team,omitempty"`
	// Teams: User-specified strings representing the agent's teams.
	Teams []string `json:"teams,omitempty"`
	// VersionDisplayName: The agent's version display name. Only applicable to
	// automated agents.
	VersionDisplayName string `json:"versionDisplayName,omitempty"`
	// VersionId: The agent's version ID. Only applicable to automated agents.
	VersionId string `json:"versionId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ConversationQualityMetadataAgentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationQualityMetadataAgentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ConversationSummarizationSuggestionData:
// Conversation summarization suggestion data.
type GoogleCloudContactcenterinsightsV1ConversationSummarizationSuggestionData struct {
	// AnswerRecord: The name of the answer record. Format:
	// projects/{project}/locations/{location}/answerRecords/{answer_record}
	AnswerRecord string `json:"answerRecord,omitempty"`
	// Confidence: The confidence score of the summarization.
	Confidence float64 `json:"confidence,omitempty"`
	// ConversationModel: The name of the model that generates this summary.
	// Format:
	// projects/{project}/locations/{location}/conversationModels/{conversation_mode
	// l}
	ConversationModel string `json:"conversationModel,omitempty"`
	// GeneratorId: Agent Assist generator ID.
	GeneratorId string `json:"generatorId,omitempty"`
	// Metadata: A map that contains metadata about the summarization and the
	// document from which it originates.
	Metadata map[string]string `json:"metadata,omitempty"`
	// Text: The summarization content that is concatenated into one string.
	Text string `json:"text,omitempty"`
	// TextSections: The summarization content that is divided into sections. The
	// key is the section's name and the value is the section's content. There is
	// no specific format for the key or value.
	TextSections map[string]string `json:"textSections,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ConversationSummarizationSuggestionData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationSummarizationSuggestionData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1ConversationSummarizationSuggestionData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationSummarizationSuggestionData
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudContactcenterinsightsV1ConversationTranscript: A message
// representing the transcript of a conversation.
type GoogleCloudContactcenterinsightsV1ConversationTranscript struct {
	// TranscriptSegments: A list of sequential transcript segments that comprise
	// the conversation.
	TranscriptSegments []*GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegment `json:"transcriptSegments,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TranscriptSegments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TranscriptSegments") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ConversationTranscript) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationTranscript
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegment: A
// segment of a full transcript.
type GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegment struct {
	// ChannelTag: For conversations derived from multi-channel audio, this is the
	// channel number corresponding to the audio from that channel. For
	// audioChannelCount = N, its output values can range from '1' to 'N'. A
	// channel tag of 0 indicates that the audio is mono.
	ChannelTag int64 `json:"channelTag,omitempty"`
	// Confidence: A confidence estimate between 0.0 and 1.0 of the fidelity of
	// this segment. A default value of 0.0 indicates that the value is unset.
	Confidence float64 `json:"confidence,omitempty"`
	// DialogflowSegmentMetadata: CCAI metadata relating to the current transcript
	// segment.
	DialogflowSegmentMetadata *GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentDialogflowSegmentMetadata `json:"dialogflowSegmentMetadata,omitempty"`
	// LanguageCode: The language code of this segment as a BCP-47
	// (https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag. Example:
	// "en-US".
	LanguageCode string `json:"languageCode,omitempty"`
	// MessageTime: The time that the message occurred, if provided.
	MessageTime string `json:"messageTime,omitempty"`
	// SegmentParticipant: The participant of this segment.
	SegmentParticipant *GoogleCloudContactcenterinsightsV1ConversationParticipant `json:"segmentParticipant,omitempty"`
	// Sentiment: The sentiment for this transcript segment.
	Sentiment *GoogleCloudContactcenterinsightsV1SentimentData `json:"sentiment,omitempty"`
	// Text: The text of this segment.
	Text string `json:"text,omitempty"`
	// Words: A list of the word-specific information for each word in the segment.
	Words []*GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentWordInfo `json:"words,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChannelTag") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChannelTag") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegment) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegment
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentDial
// ogflowSegmentMetadata: Metadata from Dialogflow relating to the current
// transcript segment.
type GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentDialogflowSegmentMetadata struct {
	// SmartReplyAllowlistCovered: Whether the transcript segment was covered under
	// the configured smart reply allowlist in Agent Assist.
	SmartReplyAllowlistCovered bool `json:"smartReplyAllowlistCovered,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SmartReplyAllowlistCovered")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SmartReplyAllowlistCovered") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentDialogflowSegmentMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentDialogflowSegmentMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentWord
// Info: Word-level info for words in a transcript.
type GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentWordInfo struct {
	// Confidence: A confidence estimate between 0.0 and 1.0 of the fidelity of
	// this word. A default value of 0.0 indicates that the value is unset.
	Confidence float64 `json:"confidence,omitempty"`
	// EndOffset: Time offset of the end of this word relative to the beginning of
	// the total conversation.
	EndOffset string `json:"endOffset,omitempty"`
	// StartOffset: Time offset of the start of this word relative to the beginning
	// of the total conversation.
	StartOffset string `json:"startOffset,omitempty"`
	// Word: The word itself. Includes punctuation marks that surround the word.
	Word string `json:"word,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentWordInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentWordInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentWordInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentWordInfo
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudContactcenterinsightsV1CorrelationConfig: A configuration that
// defines how to correlate conversations for a given a given project.
type GoogleCloudContactcenterinsightsV1CorrelationConfig struct {
	// CreateTime: Output only. The time at which the correlation config was
	// created.
	CreateTime string `json:"createTime,omitempty"`
	// FullConversationConfig: The correlation type config for full conversations.
	FullConversationConfig *GoogleCloudContactcenterinsightsV1CorrelationTypeConfig `json:"fullConversationConfig,omitempty"`
	// Name: Immutable. Identifier. The resource name of the correlation config.
	// Format: projects/{project}/locations/{location}/correlationConfig
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. The time at which the correlation config was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1CorrelationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1CorrelationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1CorrelationRule: A correlation rule that
// defines how to join conversations for a given correlation type.
type GoogleCloudContactcenterinsightsV1CorrelationRule struct {
	// Active: Optional. Whether the config is active to be evaluated.
	Active bool `json:"active,omitempty"`
	// ConstraintExpression: Optional. A cel expression (go/cel) to be evaluated as
	// a boolean value. Two variables conversation_a and conversation_b will be
	// available for evaluation. This expression should evaluate to true if
	// conversation_a and conversation_b should be joined. This is used as an extra
	// constraint on top of the join_key_expression to further refine the group of
	// conversations that are joined together and will be evaluated in both
	// directions. for two conversations c1 and c2 and the result will be OR'd. We
	// will evaluate: f(c1, c2) OR f(c2, c1)
	ConstraintExpression string `json:"constraintExpression,omitempty"`
	// JoinKeyExpression: Optional. A cel expression (go/cel) to be evaluated as a
	// string value. This string value will be used as the join key for the
	// correlation.
	JoinKeyExpression string `json:"joinKeyExpression,omitempty"`
	// RuleId: Required. The unique identifier of the rule.
	RuleId string `json:"ruleId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Active") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Active") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1CorrelationRule) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1CorrelationRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1CorrelationTypeConfig: A list of
// correlation rules for a given correlation type.
type GoogleCloudContactcenterinsightsV1CorrelationTypeConfig struct {
	// CorrelationRules: A list of correlation rules to be evaluated for
	// correlation.
	CorrelationRules []*GoogleCloudContactcenterinsightsV1CorrelationRule `json:"correlationRules,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CorrelationRules") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CorrelationRules") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1CorrelationTypeConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1CorrelationTypeConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1CreateAnalysisOperationMetadata: Metadata
// for a create analysis operation.
type GoogleCloudContactcenterinsightsV1CreateAnalysisOperationMetadata struct {
	// AnnotatorSelector: Output only. The annotator selector used for the analysis
	// (if any).
	AnnotatorSelector *GoogleCloudContactcenterinsightsV1AnnotatorSelector `json:"annotatorSelector,omitempty"`
	// Conversation: Output only. The Conversation that this Analysis Operation
	// belongs to.
	Conversation string `json:"conversation,omitempty"`
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotatorSelector") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotatorSelector") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1CreateAnalysisOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1CreateAnalysisOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1CreateIssueMetadata: Metadata for creating
// an issue.
type GoogleCloudContactcenterinsightsV1CreateIssueMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original request for creation.
	Request *GoogleCloudContactcenterinsightsV1CreateIssueRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1CreateIssueMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1CreateIssueMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1CreateIssueModelMetadata: Metadata for
// creating an issue model.
type GoogleCloudContactcenterinsightsV1CreateIssueModelMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original request for creation.
	Request *GoogleCloudContactcenterinsightsV1CreateIssueModelRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1CreateIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1CreateIssueModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1CreateIssueModelRequest: The request to
// create an issue model.
type GoogleCloudContactcenterinsightsV1CreateIssueModelRequest struct {
	// IssueModel: Required. The issue model to create.
	IssueModel *GoogleCloudContactcenterinsightsV1IssueModel `json:"issueModel,omitempty"`
	// Parent: Required. The parent resource of the issue model.
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IssueModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IssueModel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1CreateIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1CreateIssueModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1CreateIssueRequest: The request to create
// an issue.
type GoogleCloudContactcenterinsightsV1CreateIssueRequest struct {
	// Issue: Required. The values for the new issue.
	Issue *GoogleCloudContactcenterinsightsV1Issue `json:"issue,omitempty"`
	// Parent: Required. The parent resource of the issue.
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Issue") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Issue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1CreateIssueRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1CreateIssueRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1Dashboard: Configurable dashboard
type GoogleCloudContactcenterinsightsV1Dashboard struct {
	// CreateTime: Output only. Dashboard creation time.
	CreateTime string `json:"createTime,omitempty"`
	// DateRangeConfig: Date range config applied to all charts in the dashboard.
	DateRangeConfig *GoogleCloudContactcenterinsightsV1DateRangeConfig `json:"dateRangeConfig,omitempty"`
	// Description: Dashboard description
	Description string `json:"description,omitempty"`
	// DisplayName: User provided display name of the dashboard.
	DisplayName string `json:"displayName,omitempty"`
	// Filter: Filter applied to all charts in the dashboard. Should support scope
	// later.
	Filter string `json:"filter,omitempty"`
	// Name: Identifier. Dashboard resource name. Format:
	// projects/{project}/locations/{location}/dashboards/{dashboard}
	Name string `json:"name,omitempty"`
	// ReadOnly: Output only. Whether the dashboard is read-only. All predefined
	// dashboards are read-only and cannot be modified by the user.
	ReadOnly bool `json:"readOnly,omitempty"`
	// RootContainer: The dashboard's root widget container. We want to display the
	// dashboard layout in a tree-like structure, where the root container contains
	// other widgets (containers or charts) as children.
	RootContainer *GoogleCloudContactcenterinsightsV1Container `json:"rootContainer,omitempty"`
	// UpdateTime: Output only. Dashboard last update time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1Dashboard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1Dashboard
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1Dataset: Dataset resource represents a
// collection of conversations that may be bounded (Static Dataset, e.g. golden
// dataset for training), or unbounded (Dynamic Dataset, e.g. live traffic, or
// agent training traffic)
type GoogleCloudContactcenterinsightsV1Dataset struct {
	// CreateTime: Output only. Dataset create time.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Dataset description.
	Description string `json:"description,omitempty"`
	// DisplayName: Display name for the dataaset
	DisplayName string `json:"displayName,omitempty"`
	// Name: Immutable. Identifier. Resource name of the dataset. Format:
	// projects/{project}/locations/{location}/datasets/{dataset}
	Name string `json:"name,omitempty"`
	// Ttl: Optional. Option TTL for the dataset.
	Ttl string `json:"ttl,omitempty"`
	// Type: Dataset usage type.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Default value for unspecified.
	//   "EVAL" - For evals only.
	//   "LIVE" - Dataset with new conversations coming in regularly (Insights
	// legacy conversations and AI trainer)
	Type string `json:"type,omitempty"`
	// UpdateTime: Output only. Dataset update time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1Dataset) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1Dataset
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DateRangeConfig: Date range configuration
// for dashboard charts.
type GoogleCloudContactcenterinsightsV1DateRangeConfig struct {
	// AbsoluteDateRange: An absolute date range.
	AbsoluteDateRange *GoogleCloudContactcenterinsightsV1QueryInterval `json:"absoluteDateRange,omitempty"`
	// RelativeDateRange: A relative date range.
	RelativeDateRange *GoogleCloudContactcenterinsightsV1DateRangeConfigRelativeDateRange `json:"relativeDateRange,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AbsoluteDateRange") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AbsoluteDateRange") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DateRangeConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DateRangeConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DateRangeConfigRelativeDateRange: Relative
// date range configuration.
type GoogleCloudContactcenterinsightsV1DateRangeConfigRelativeDateRange struct {
	// Quantity: Required. The quantity of units in the past.
	Quantity int64 `json:"quantity,omitempty,string"`
	// Unit: Required. The unit of time.
	//
	// Possible values:
	//   "TIME_UNIT_UNSPECIFIED" - Unspecified.
	//   "DAY" - Day.
	//   "WEEK" - Week.
	//   "MONTH" - Month.
	//   "QUARTER" - Quarter.
	//   "YEAR" - Year.
	Unit string `json:"unit,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Quantity") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Quantity") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DateRangeConfigRelativeDateRange) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DateRangeConfigRelativeDateRange
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DeleteIssueModelMetadata: Metadata for
// deleting an issue model.
type GoogleCloudContactcenterinsightsV1DeleteIssueModelMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original request for deletion.
	Request *GoogleCloudContactcenterinsightsV1DeleteIssueModelRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DeleteIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DeleteIssueModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DeleteIssueModelRequest: The request to
// delete an issue model.
type GoogleCloudContactcenterinsightsV1DeleteIssueModelRequest struct {
	// Name: Required. The name of the issue model to delete.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DeleteIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DeleteIssueModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DeleteQaQuestionTagMetadata: The metadata
// for deleting a QaQuestionTag Resource.
type GoogleCloudContactcenterinsightsV1DeleteQaQuestionTagMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: Output only. The original request.
	Request *GoogleCloudContactcenterinsightsV1DeleteQaQuestionTagRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DeleteQaQuestionTagMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DeleteQaQuestionTagMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DeleteQaQuestionTagRequest: The request
// for deleting a QaQuestionTag.
type GoogleCloudContactcenterinsightsV1DeleteQaQuestionTagRequest struct {
	// Name: Required. The name of the QaQuestionTag to delete.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DeleteQaQuestionTagRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DeleteQaQuestionTagRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DeployIssueModelMetadata: Metadata for
// deploying an issue model.
type GoogleCloudContactcenterinsightsV1DeployIssueModelMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original request for deployment.
	Request *GoogleCloudContactcenterinsightsV1DeployIssueModelRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DeployIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DeployIssueModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DeployIssueModelRequest: The request to
// deploy an issue model.
type GoogleCloudContactcenterinsightsV1DeployIssueModelRequest struct {
	// Name: Required. The issue model to deploy.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DeployIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DeployIssueModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DeployIssueModelResponse: The response to
// deploy an issue model.
type GoogleCloudContactcenterinsightsV1DeployIssueModelResponse struct {
}

// GoogleCloudContactcenterinsightsV1DeployQaScorecardRevisionRequest: The
// request to deploy a QaScorecardRevision
type GoogleCloudContactcenterinsightsV1DeployQaScorecardRevisionRequest struct {
}

// GoogleCloudContactcenterinsightsV1DialogflowIntent: The data for a
// Dialogflow intent. Represents a detected intent in the conversation, e.g.
// MAKES_PROMISE.
type GoogleCloudContactcenterinsightsV1DialogflowIntent struct {
	// DisplayName: The human-readable name of the intent.
	DisplayName string `json:"displayName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DialogflowIntent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DialogflowIntent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DialogflowInteractionData: Dialogflow
// interaction data.
type GoogleCloudContactcenterinsightsV1DialogflowInteractionData struct {
	// Confidence: The confidence of the match ranging from 0.0 (completely
	// uncertain) to 1.0 (completely certain).
	Confidence float64 `json:"confidence,omitempty"`
	// DialogflowIntentId: The Dialogflow intent resource path. Format:
	// projects/{project}/agent/{agent}/intents/{intent}
	DialogflowIntentId string `json:"dialogflowIntentId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DialogflowInteractionData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DialogflowInteractionData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1DialogflowInteractionData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1DialogflowInteractionData
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudContactcenterinsightsV1DialogflowSource: A Dialogflow source of
// conversation data.
type GoogleCloudContactcenterinsightsV1DialogflowSource struct {
	// AudioUri: Cloud Storage URI that points to a file that contains the
	// conversation audio.
	AudioUri string `json:"audioUri,omitempty"`
	// DialogflowConversation: Output only. The name of the Dialogflow conversation
	// that this conversation resource is derived from. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}
	DialogflowConversation string `json:"dialogflowConversation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DialogflowSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DialogflowSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1Dimension: A dimension determines the
// grouping key for the query. In SQL terms, these would be part of both the
// "SELECT" and "GROUP BY" clauses.
type GoogleCloudContactcenterinsightsV1Dimension struct {
	// AgentDimensionMetadata: Output only. Metadata about the agent dimension.
	AgentDimensionMetadata *GoogleCloudContactcenterinsightsV1DimensionAgentDimensionMetadata `json:"agentDimensionMetadata,omitempty"`
	// ClientSentimentCategoryDimensionMetadata: Output only. Metadata about the
	// client sentiment category dimension.
	ClientSentimentCategoryDimensionMetadata *GoogleCloudContactcenterinsightsV1DimensionClientSentimentCategoryDimensionMetadata `json:"clientSentimentCategoryDimensionMetadata,omitempty"`
	// ConversationProfileDimensionMetadata: Output only. Metadata about the
	// conversation profile dimension.
	ConversationProfileDimensionMetadata *GoogleCloudContactcenterinsightsV1DimensionConversationProfileDimensionMetadata `json:"conversationProfileDimensionMetadata,omitempty"`
	// ConversationalAgentsPlaybookDimensionMetadata: Output only. Metadata about
	// the Conversational Agents playbook dimension.
	ConversationalAgentsPlaybookDimensionMetadata *GoogleCloudContactcenterinsightsV1DimensionConversationalAgentsPlaybookDimensionMetadata `json:"conversationalAgentsPlaybookDimensionMetadata,omitempty"`
	// ConversationalAgentsToolDimensionMetadata: Output only. Metadata about the
	// Conversational Agents tool dimension.
	ConversationalAgentsToolDimensionMetadata *GoogleCloudContactcenterinsightsV1DimensionConversationalAgentsToolDimensionMetadata `json:"conversationalAgentsToolDimensionMetadata,omitempty"`
	// DimensionKey: The key of the dimension.
	//
	// Possible values:
	//   "DIMENSION_KEY_UNSPECIFIED" - The key of the dimension is unspecified.
	//   "ISSUE" - The dimension is keyed by issues.
	//   "ISSUE_NAME" - The dimension is keyed by issue names.
	//   "AGENT" - The dimension is keyed by agents.
	//   "AGENT_TEAM" - The dimension is keyed by agent teams.
	//   "QA_QUESTION_ID" - The dimension is keyed by QaQuestionIds. Note that: We
	// only group by the QuestionId and not the revision-id of the scorecard this
	// question is a part of. This allows for showing stats for the same question
	// across different scorecard revisions.
	//   "QA_QUESTION_ANSWER_VALUE" - The dimension is keyed by
	// QaQuestionIds-Answer value pairs. Note that: We only group by the QuestionId
	// and not the revision-id of the scorecard this question is a part of. This
	// allows for showing distribution of answers per question across different
	// scorecard revisions.
	//   "QA_SCORECARD_ID" - The dimension is keyed by QaScorecardIds. Note that:
	// We only group by the ScorecardId and not the revision-id of the scorecard.
	// This allows for showing stats for the same scorecard across different
	// revisions. This metric is mostly only useful if querying the average
	// normalized score per scorecard.
	//   "CONVERSATION_PROFILE_ID" - The dimension is keyed by the conversation
	// profile ID.
	//   "MEDIUM" - The dimension is keyed by the conversation medium.
	//   "CONVERSATIONAL_AGENTS_PLAYBOOK_ID" - The dimension is keyed by the
	// Conversational Agents playbook ID.
	//   "CONVERSATIONAL_AGENTS_PLAYBOOK_NAME" - The dimension is keyed by the
	// Conversational Agents playbook display name.
	//   "CONVERSATIONAL_AGENTS_TOOL_ID" - The dimension is keyed by the
	// Conversational Agents tool ID.
	//   "CONVERSATIONAL_AGENTS_TOOL_NAME" - The dimension is keyed by the
	// Conversational Agents tool display name.
	//   "CLIENT_SENTIMENT_CATEGORY" - The dimension is keyed by the client
	// sentiment category.
	//   "AGENT_VERSION_ID" - The dimension is keyed by the agent version ID.
	//   "AGENT_DEPLOYMENT_ID" - The dimension is keyed by the agent deployment ID.
	//   "AGENT_ASSIST_SUPERVISOR_ID" - The dimension is keyed by the supervisor ID
	// of the assigned human supervisor for virtual agents.
	//   "LABEL_KEY" - The dimension is keyed by label keys.
	//   "LABEL_VALUE" - The dimension is keyed by label values.
	//   "LABEL_KEY_AND_VALUE" - The dimension is keyed by label key-value pairs.
	DimensionKey string `json:"dimensionKey,omitempty"`
	// IssueDimensionMetadata: Output only. Metadata about the issue dimension.
	IssueDimensionMetadata *GoogleCloudContactcenterinsightsV1DimensionIssueDimensionMetadata `json:"issueDimensionMetadata,omitempty"`
	// LabelDimensionMetadata: Output only. Metadata about conversation labels.
	LabelDimensionMetadata *GoogleCloudContactcenterinsightsV1DimensionLabelDimensionMetadata `json:"labelDimensionMetadata,omitempty"`
	// MediumDimensionMetadata: Output only. Metadata about the conversation medium
	// dimension.
	MediumDimensionMetadata *GoogleCloudContactcenterinsightsV1DimensionMediumDimensionMetadata `json:"mediumDimensionMetadata,omitempty"`
	// QaQuestionAnswerDimensionMetadata: Output only. Metadata about the QA
	// question-answer dimension.
	QaQuestionAnswerDimensionMetadata *GoogleCloudContactcenterinsightsV1DimensionQaQuestionAnswerDimensionMetadata `json:"qaQuestionAnswerDimensionMetadata,omitempty"`
	// QaQuestionDimensionMetadata: Output only. Metadata about the QA question
	// dimension.
	QaQuestionDimensionMetadata *GoogleCloudContactcenterinsightsV1DimensionQaQuestionDimensionMetadata `json:"qaQuestionDimensionMetadata,omitempty"`
	// QaScorecardDimensionMetadata: Output only. Metadata about the QA scorecard
	// dimension.
	QaScorecardDimensionMetadata *GoogleCloudContactcenterinsightsV1DimensionQaScorecardDimensionMetadata `json:"qaScorecardDimensionMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentDimensionMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentDimensionMetadata") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1Dimension) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1Dimension
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DimensionAgentDimensionMetadata: Metadata
// about the agent dimension.
type GoogleCloudContactcenterinsightsV1DimensionAgentDimensionMetadata struct {
	// AgentDeploymentDisplayName: Optional. The agent's deployment display name.
	// Only applicable to automated agents. This will be populated for
	// AGENT_DEPLOYMENT_ID dimensions.
	AgentDeploymentDisplayName string `json:"agentDeploymentDisplayName,omitempty"`
	// AgentDeploymentId: Optional. The agent's deployment ID. Only applicable to
	// automated agents. This will be populated for AGENT and AGENT_DEPLOYMENT_ID
	// dimensions.
	AgentDeploymentId string `json:"agentDeploymentId,omitempty"`
	// AgentDisplayName: Optional. The agent's name This will be populated for
	// AGENT, AGENT_TEAM, AGENT_VERSION_ID, and AGENT_DEPLOYMENT_ID dimensions.
	AgentDisplayName string `json:"agentDisplayName,omitempty"`
	// AgentId: Optional. A user-specified string representing the agent. This will
	// be populated for AGENT, AGENT_TEAM, AGENT_VERSION_ID, and
	// AGENT_DEPLOYMENT_ID dimensions.
	AgentId string `json:"agentId,omitempty"`
	// AgentTeam: Optional. A user-specified string representing the agent's team.
	AgentTeam string `json:"agentTeam,omitempty"`
	// AgentVersionDisplayName: Optional. The agent's version display name. Only
	// applicable to automated agents. This will be populated for AGENT_VERSION_ID,
	// and AGENT_DEPLOYMENT_ID dimensions.
	AgentVersionDisplayName string `json:"agentVersionDisplayName,omitempty"`
	// AgentVersionId: Optional. The agent's version ID. Only applicable to
	// automated agents. This will be populated for AGENT_VERSION_ID, and
	// AGENT_DEPLOYMENT_ID dimensions.
	AgentVersionId string `json:"agentVersionId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentDeploymentDisplayName")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentDeploymentDisplayName") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DimensionAgentDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DimensionAgentDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DimensionClientSentimentCategoryDimensionMe
// tadata: Metadata about the client sentiment category dimension.
type GoogleCloudContactcenterinsightsV1DimensionClientSentimentCategoryDimensionMetadata struct {
	// SentimentCategory: Optional. The client sentiment category.
	SentimentCategory string `json:"sentimentCategory,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SentimentCategory") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SentimentCategory") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DimensionClientSentimentCategoryDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DimensionClientSentimentCategoryDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DimensionConversationProfileDimensionMetada
// ta: Metadata about the conversation profile dimension.
type GoogleCloudContactcenterinsightsV1DimensionConversationProfileDimensionMetadata struct {
	// ConversationProfileId: Optional. The conversation profile ID.
	ConversationProfileId string `json:"conversationProfileId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationProfileId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationProfileId") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DimensionConversationProfileDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DimensionConversationProfileDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DimensionConversationalAgentsPlaybookDimens
// ionMetadata: Metadata about the Conversational Agents playbook dimension.
type GoogleCloudContactcenterinsightsV1DimensionConversationalAgentsPlaybookDimensionMetadata struct {
	// PlaybookDisplayName: Optional. The dialogflow playbook display name.
	PlaybookDisplayName string `json:"playbookDisplayName,omitempty"`
	// PlaybookId: Optional. The dialogflow playbook ID.
	PlaybookId string `json:"playbookId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PlaybookDisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PlaybookDisplayName") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DimensionConversationalAgentsPlaybookDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DimensionConversationalAgentsPlaybookDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DimensionConversationalAgentsToolDimensionM
// etadata: Metadata about the Conversational Agents tool dimension.
type GoogleCloudContactcenterinsightsV1DimensionConversationalAgentsToolDimensionMetadata struct {
	// ToolDisplayName: Optional. The dialogflow tool display name.
	ToolDisplayName string `json:"toolDisplayName,omitempty"`
	// ToolId: Optional. The dialogflow tool ID.
	ToolId string `json:"toolId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ToolDisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ToolDisplayName") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DimensionConversationalAgentsToolDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DimensionConversationalAgentsToolDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DimensionIssueDimensionMetadata: Metadata
// about the issue dimension.
type GoogleCloudContactcenterinsightsV1DimensionIssueDimensionMetadata struct {
	// IssueDisplayName: The issue display name.
	IssueDisplayName string `json:"issueDisplayName,omitempty"`
	// IssueId: The issue ID.
	IssueId string `json:"issueId,omitempty"`
	// IssueModelId: The parent issue model ID.
	IssueModelId string `json:"issueModelId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IssueDisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IssueDisplayName") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DimensionIssueDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DimensionIssueDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DimensionLabelDimensionMetadata: Metadata
// about conversation labels.
type GoogleCloudContactcenterinsightsV1DimensionLabelDimensionMetadata struct {
	// LabelKey: Optional. The label key.
	LabelKey string `json:"labelKey,omitempty"`
	// LabelValue: Optional. The label value.
	LabelValue string `json:"labelValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LabelKey") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LabelKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DimensionLabelDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DimensionLabelDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DimensionMediumDimensionMetadata: Metadata
// about the conversation medium dimension.
type GoogleCloudContactcenterinsightsV1DimensionMediumDimensionMetadata struct {
	// Medium: Optional. The conversation medium. Currently supports : PHONE_CALL,
	// CHAT.
	Medium string `json:"medium,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Medium") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Medium") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DimensionMediumDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DimensionMediumDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DimensionQaQuestionAnswerDimensionMetadata:
//
//	Metadata about the QA question-answer dimension. This is useful for showing
//
// the answer distribution for questions for a given scorecard.
type GoogleCloudContactcenterinsightsV1DimensionQaQuestionAnswerDimensionMetadata struct {
	// AnswerValue: Optional. The full body of the question.
	AnswerValue string `json:"answerValue,omitempty"`
	// QaQuestionId: Optional. The QA question ID.
	QaQuestionId string `json:"qaQuestionId,omitempty"`
	// QaScorecardId: Optional. The QA scorecard ID.
	QaScorecardId string `json:"qaScorecardId,omitempty"`
	// QuestionBody: Optional. The full body of the question.
	QuestionBody string `json:"questionBody,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DimensionQaQuestionAnswerDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DimensionQaQuestionAnswerDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DimensionQaQuestionDimensionMetadata:
// Metadata about the QA question dimension.
type GoogleCloudContactcenterinsightsV1DimensionQaQuestionDimensionMetadata struct {
	// QaQuestionId: Optional. The QA question ID.
	QaQuestionId string `json:"qaQuestionId,omitempty"`
	// QaScorecardId: Optional. The QA scorecard ID.
	QaScorecardId string `json:"qaScorecardId,omitempty"`
	// QuestionBody: Optional. The full body of the question.
	QuestionBody string `json:"questionBody,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QaQuestionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QaQuestionId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DimensionQaQuestionDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DimensionQaQuestionDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DimensionQaScorecardDimensionMetadata:
// Metadata about the QA scorecard dimension.
type GoogleCloudContactcenterinsightsV1DimensionQaScorecardDimensionMetadata struct {
	// QaScorecardId: Optional. The QA scorecard ID.
	QaScorecardId string `json:"qaScorecardId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QaScorecardId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QaScorecardId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DimensionQaScorecardDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DimensionQaScorecardDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1EncryptionSpec: A customer-managed
// encryption key specification that can be applied to all created resources
// (e.g. `Conversation`).
type GoogleCloudContactcenterinsightsV1EncryptionSpec struct {
	// KmsKey: Required. The name of customer-managed encryption key that is used
	// to secure a resource and its sub-resources. If empty, the resource is
	// secured by our default encryption key. Only the key in the same location as
	// this resource is allowed to be used for encryption. Format:
	// `projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{key}`
	KmsKey string `json:"kmsKey,omitempty"`
	// Name: Immutable. The resource name of the encryption key specification
	// resource. Format: projects/{project}/locations/{location}/encryptionSpec
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "KmsKey") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "KmsKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1EncryptionSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1EncryptionSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1Entity: The data for an entity annotation.
// Represents a phrase in the conversation that is a known entity, such as a
// person, an organization, or location.
type GoogleCloudContactcenterinsightsV1Entity struct {
	// DisplayName: The representative name for the entity.
	DisplayName string `json:"displayName,omitempty"`
	// Metadata: Metadata associated with the entity. For most entity types, the
	// metadata is a Wikipedia URL (`wikipedia_url`) and Knowledge Graph MID
	// (`mid`), if they are available. For the metadata associated with other
	// entity types, see the Type table below.
	Metadata map[string]string `json:"metadata,omitempty"`
	// Salience: The salience score associated with the entity in the [0, 1.0]
	// range. The salience score for an entity provides information about the
	// importance or centrality of that entity to the entire document text. Scores
	// closer to 0 are less salient, while scores closer to 1.0 are highly salient.
	Salience float64 `json:"salience,omitempty"`
	// Sentiment: The aggregate sentiment expressed for this entity in the
	// conversation.
	Sentiment *GoogleCloudContactcenterinsightsV1SentimentData `json:"sentiment,omitempty"`
	// Type: The entity type.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unspecified.
	//   "PERSON" - Person.
	//   "LOCATION" - Location.
	//   "ORGANIZATION" - Organization.
	//   "EVENT" - Event.
	//   "WORK_OF_ART" - Artwork.
	//   "CONSUMER_GOOD" - Consumer product.
	//   "OTHER" - Other types of entities.
	//   "PHONE_NUMBER" - Phone number. The metadata lists the phone number
	// (formatted according to local convention), plus whichever additional
	// elements appear in the text: * `number` - The actual number, broken down
	// into sections according to local convention. * `national_prefix` - Country
	// code, if detected. * `area_code` - Region or area code, if detected. *
	// `extension` - Phone extension (to be dialed after connection), if detected.
	//   "ADDRESS" - Address. The metadata identifies the street number and
	// locality plus whichever additional elements appear in the text: *
	// `street_number` - Street number. * `locality` - City or town. *
	// `street_name` - Street/route name, if detected. * `postal_code` - Postal
	// code, if detected. * `country` - Country, if detected. * `broad_region` -
	// Administrative area, such as the state, if detected. * `narrow_region` -
	// Smaller administrative area, such as county, if detected. * `sublocality` -
	// Used in Asian addresses to demark a district within a city, if detected.
	//   "DATE" - Date. The metadata identifies the components of the date: *
	// `year` - Four digit year, if detected. * `month` - Two digit month number,
	// if detected. * `day` - Two digit day number, if detected.
	//   "NUMBER" - Number. The metadata is the number itself.
	//   "PRICE" - Price. The metadata identifies the `value` and `currency`.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1Entity) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1Entity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1Entity) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1Entity
	var s1 struct {
		Salience gensupport.JSONFloat64 `json:"salience"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Salience = float64(s1.Salience)
	return nil
}

// GoogleCloudContactcenterinsightsV1EntityMentionData: The data for an entity
// mention annotation. This represents a mention of an `Entity` in the
// conversation.
type GoogleCloudContactcenterinsightsV1EntityMentionData struct {
	// EntityUniqueId: The key of this entity in conversation entities. Can be used
	// to retrieve the exact `Entity` this mention is attached to.
	EntityUniqueId string `json:"entityUniqueId,omitempty"`
	// Sentiment: Sentiment expressed for this mention of the entity.
	Sentiment *GoogleCloudContactcenterinsightsV1SentimentData `json:"sentiment,omitempty"`
	// Type: The type of the entity mention.
	//
	// Possible values:
	//   "MENTION_TYPE_UNSPECIFIED" - Unspecified.
	//   "PROPER" - Proper noun.
	//   "COMMON" - Common noun (or noun compound).
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityUniqueId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityUniqueId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1EntityMentionData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1EntityMentionData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ExactMatchConfig: Exact match
// configuration.
type GoogleCloudContactcenterinsightsV1ExactMatchConfig struct {
	// CaseSensitive: Whether to consider case sensitivity when performing an exact
	// match.
	CaseSensitive bool `json:"caseSensitive,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CaseSensitive") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CaseSensitive") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ExactMatchConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ExactMatchConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ExportInsightsDataMetadata: Metadata for
// an export insights operation.
type GoogleCloudContactcenterinsightsV1ExportInsightsDataMetadata struct {
	// CompletedExportCount: The number of conversations that were exported
	// successfully.
	CompletedExportCount int64 `json:"completedExportCount,omitempty"`
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// FailedExportCount: The number of conversations that failed to be exported.
	FailedExportCount int64 `json:"failedExportCount,omitempty"`
	// PartialErrors: Partial errors during export operation that might cause the
	// operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: The original request for export.
	Request *GoogleCloudContactcenterinsightsV1ExportInsightsDataRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompletedExportCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompletedExportCount") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ExportInsightsDataMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ExportInsightsDataMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ExportInsightsDataRequest: The request to
// export insights.
type GoogleCloudContactcenterinsightsV1ExportInsightsDataRequest struct {
	// BigQueryDestination: Specified if sink is a BigQuery table.
	BigQueryDestination *GoogleCloudContactcenterinsightsV1ExportInsightsDataRequestBigQueryDestination `json:"bigQueryDestination,omitempty"`
	// ExportSchemaVersion: Optional. Version of the export schema.
	//
	// Possible values:
	//   "EXPORT_SCHEMA_VERSION_UNSPECIFIED" - Unspecified. Defaults to EXPORT_V3.
	//   "EXPORT_V1" - Export schema version 1.
	//   "EXPORT_V2" - Export schema version 2.
	//   "EXPORT_V3" - Export schema version 3.
	//   "EXPORT_V4" - Export schema version 4.
	//   "EXPORT_V5" - Export schema version 5.
	//   "EXPORT_V6" - Export schema version 6.
	//   "EXPORT_V7" - Export schema version 7.
	//   "EXPORT_V8" - Export schema version 8.
	//   "EXPORT_V9" - Export schema version 9.
	//   "EXPORT_V10" - Export schema version 10.
	//   "EXPORT_V11" - Export schema version 11.
	//   "EXPORT_V12" - Export schema version 12.
	//   "EXPORT_V13" - Export schema version 13.
	//   "EXPORT_V14" - Export schema version 14.
	//   "EXPORT_V15" - Export schema version 15.
	//   "EXPORT_V16" - Export schema version 16.
	//   "EXPORT_V17" - Export schema version 17.
	//   "EXPORT_VERSION_LATEST_AVAILABLE" - Export schema version latest
	// available.
	ExportSchemaVersion string `json:"exportSchemaVersion,omitempty"`
	// Filter: A filter to reduce results to a specific subset. Useful for
	// exporting conversations with specific properties.
	Filter string `json:"filter,omitempty"`
	// KmsKey: A fully qualified KMS key name for BigQuery tables protected by
	// CMEK. Format:
	// projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}/c
	// ryptoKeyVersions/{version}
	KmsKey string `json:"kmsKey,omitempty"`
	// Parent: Required. The parent resource to export data from.
	Parent string `json:"parent,omitempty"`
	// WriteDisposition: Options for what to do if the destination table already
	// exists.
	//
	// Possible values:
	//   "WRITE_DISPOSITION_UNSPECIFIED" - Write disposition is not specified.
	// Defaults to WRITE_TRUNCATE.
	//   "WRITE_TRUNCATE" - If the table already exists, BigQuery will overwrite
	// the table data and use the schema from the load.
	//   "WRITE_APPEND" - If the table already exists, BigQuery will append data to
	// the table.
	WriteDisposition string `json:"writeDisposition,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigQueryDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigQueryDestination") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ExportInsightsDataRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ExportInsightsDataRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ExportInsightsDataRequestBigQueryDestinatio
// n: A BigQuery Table Reference.
type GoogleCloudContactcenterinsightsV1ExportInsightsDataRequestBigQueryDestination struct {
	// Dataset: Required. The name of the BigQuery dataset that the snapshot result
	// should be exported to. If this dataset does not exist, the export call
	// returns an INVALID_ARGUMENT error.
	Dataset string `json:"dataset,omitempty"`
	// ProjectId: A project ID or number. If specified, then export will attempt to
	// write data to this project instead of the resource project. Otherwise, the
	// resource project will be used.
	ProjectId string `json:"projectId,omitempty"`
	// Table: The BigQuery table name to which the insights data should be written.
	// If this table does not exist, the export call returns an INVALID_ARGUMENT
	// error.
	Table string `json:"table,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dataset") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dataset") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ExportInsightsDataRequestBigQueryDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ExportInsightsDataRequestBigQueryDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ExportInsightsDataResponse: Response for
// an export insights operation.
type GoogleCloudContactcenterinsightsV1ExportInsightsDataResponse struct {
}

// GoogleCloudContactcenterinsightsV1ExportIssueModelMetadata: Metadata used
// for export issue model.
type GoogleCloudContactcenterinsightsV1ExportIssueModelMetadata struct {
	// CreateTime: The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original export request.
	Request *GoogleCloudContactcenterinsightsV1ExportIssueModelRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ExportIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ExportIssueModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ExportIssueModelRequest: Request to export
// an issue model.
type GoogleCloudContactcenterinsightsV1ExportIssueModelRequest struct {
	// GcsDestination: Google Cloud Storage URI to export the issue model to.
	GcsDestination *GoogleCloudContactcenterinsightsV1ExportIssueModelRequestGcsDestination `json:"gcsDestination,omitempty"`
	// Name: Required. The issue model to export.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsDestination") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ExportIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ExportIssueModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ExportIssueModelRequestGcsDestination:
// Google Cloud Storage Object URI to save the issue model to.
type GoogleCloudContactcenterinsightsV1ExportIssueModelRequestGcsDestination struct {
	// ObjectUri: Required. Format: `gs:///`
	ObjectUri string `json:"objectUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ObjectUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ObjectUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ExportIssueModelRequestGcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ExportIssueModelRequestGcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ExportIssueModelResponse: Response from
// export issue model
type GoogleCloudContactcenterinsightsV1ExportIssueModelResponse struct {
}

// GoogleCloudContactcenterinsightsV1FaqAnswerData: Agent Assist
// frequently-asked-question answer data.
type GoogleCloudContactcenterinsightsV1FaqAnswerData struct {
	// Answer: The piece of text from the `source` knowledge base document.
	Answer string `json:"answer,omitempty"`
	// ConfidenceScore: The system's confidence score that this answer is a good
	// match for this conversation, ranging from 0.0 (completely uncertain) to 1.0
	// (completely certain).
	ConfidenceScore float64 `json:"confidenceScore,omitempty"`
	// Metadata: Map that contains metadata about the FAQ answer and the document
	// that it originates from.
	Metadata map[string]string `json:"metadata,omitempty"`
	// QueryRecord: The name of the answer record. Format:
	// projects/{project}/locations/{location}/answerRecords/{answer_record}
	QueryRecord string `json:"queryRecord,omitempty"`
	// Question: The corresponding FAQ question.
	Question string `json:"question,omitempty"`
	// Source: The knowledge document that this answer was extracted from. Format:
	// projects/{project}/knowledgeBases/{knowledge_base}/documents/{document}.
	Source string `json:"source,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Answer") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Answer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1FaqAnswerData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1FaqAnswerData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1FaqAnswerData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1FaqAnswerData
	var s1 struct {
		ConfidenceScore gensupport.JSONFloat64 `json:"confidenceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceScore = float64(s1.ConfidenceScore)
	return nil
}

// GoogleCloudContactcenterinsightsV1FeedbackLabel: Represents a conversation,
// resource, and label provided by the user. Can take the form of a string
// label or a QaAnswer label. QaAnswer labels are used for Quality AI example
// conversations. String labels are used for Topic Modeling. AgentAssistSummary
// labels are used for Agent Assist Summarization.
type GoogleCloudContactcenterinsightsV1FeedbackLabel struct {
	// CreateTime: Output only. Create time of the label.
	CreateTime string `json:"createTime,omitempty"`
	// Label: String label used for Topic Modeling.
	Label string `json:"label,omitempty"`
	// LabeledResource: Name of the resource to be labeled. Supported resources
	// are: *
	// `projects/{project}/locations/{location}/qaScorecards/{scorecard}/revisions/{
	// revision}/qaQuestions/{question}` *
	// `projects/{project}/locations/{location}/issueModels/{issue_model}` *
	// `projects/{project}/locations/{location}/generators/{generator_id}`
	LabeledResource string `json:"labeledResource,omitempty"`
	// Name: Immutable. Resource name of the FeedbackLabel. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}/feedback
	// Labels/{feedback_label}
	Name string `json:"name,omitempty"`
	// QaAnswerLabel: QaAnswer label used for Quality AI example conversations.
	QaAnswerLabel *GoogleCloudContactcenterinsightsV1QaAnswerAnswerValue `json:"qaAnswerLabel,omitempty"`
	// UpdateTime: Output only. Update time of the label.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1FeedbackLabel) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1FeedbackLabel
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1FinalizeAssessmentRequest: The message to
// finalize an assessment. Finalizing makes an assessment and its notes
// immutable.
type GoogleCloudContactcenterinsightsV1FinalizeAssessmentRequest struct {
}

// GoogleCloudContactcenterinsightsV1GcsSource: A Cloud Storage source of
// conversation data.
type GoogleCloudContactcenterinsightsV1GcsSource struct {
	// AudioUri: Cloud Storage URI that points to a file that contains the
	// conversation audio.
	AudioUri string `json:"audioUri,omitempty"`
	// TranscriptUri: Immutable. Cloud Storage URI that points to a file that
	// contains the conversation transcript.
	TranscriptUri string `json:"transcriptUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1GcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1GcsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1GenerateConversationSignedAudioResponse:
// The response from a GenerateConversationSignedAudio request.
type GoogleCloudContactcenterinsightsV1GenerateConversationSignedAudioResponse struct {
	// SignedAudioUris: The signed uris for the audio.
	SignedAudioUris *GoogleCloudContactcenterinsightsV1SignedAudioUris `json:"signedAudioUris,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "SignedAudioUris") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SignedAudioUris") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1GenerateConversationSignedAudioResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1GenerateConversationSignedAudioResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1GenerativeInsightConversationTranscript:
// The conversation transcript for the chart.
type GoogleCloudContactcenterinsightsV1GenerativeInsightConversationTranscript struct {
	// ConversationId: The conversation id of the chart.
	ConversationId string `json:"conversationId,omitempty"`
	// CreateTime: Output only. The create time of the conversation.
	CreateTime string `json:"createTime,omitempty"`
	// Messages: Ordered list of messages, including user inputs and system
	// responses.
	Messages []*GoogleCloudContactcenterinsightsV1GenerativeInsightConversationTranscriptMessage `json:"messages,omitempty"`
	// UpdateTime: Output only. The update time of the conversation.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1GenerativeInsightConversationTranscript) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1GenerativeInsightConversationTranscript
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1GenerativeInsightConversationTranscriptMess
// age: The message in the conversation.
type GoogleCloudContactcenterinsightsV1GenerativeInsightConversationTranscriptMessage struct {
	// CreateTime: Output only. For user messages, this is the time at which the
	// system received the message. For system messages, this is the time at which
	// the system generated the message.
	CreateTime string `json:"createTime,omitempty"`
	// MessageId: The message id of the message.
	MessageId string `json:"messageId,omitempty"`
	// SystemMessageWrapper: A wrapper for system messages per turn.
	SystemMessageWrapper *GoogleCloudContactcenterinsightsV1GenerativeInsightConversationTranscriptMessageSystemMessages `json:"systemMessageWrapper,omitempty"`
	// UserMessage: A message from the user that is interacting with the system.
	UserMessage *GoogleCloudContactcenterinsightsV1GenerativeInsightConversationTranscriptMessageUserMessage `json:"userMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1GenerativeInsightConversationTranscriptMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1GenerativeInsightConversationTranscriptMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1GenerativeInsightConversationTranscriptMess
// ageSystemMessage: A message from the system in response to the user. This
// message can also be a message from the user as historical context for
// multiturn conversations with the system.
type GoogleCloudContactcenterinsightsV1GenerativeInsightConversationTranscriptMessageSystemMessage struct {
	// ChartSpec: Chart spec from LLM
	ChartSpec googleapi.RawMessage `json:"chartSpec,omitempty"`
	// GeneratedSqlQuery: Raw SQL from LLM, before templatization
	GeneratedSqlQuery string `json:"generatedSqlQuery,omitempty"`
	// TextMessage: A direct natural language response to the user message.
	TextMessage *GoogleCloudContactcenterinsightsV1GenerativeInsightConversationTranscriptMessageSystemMessageTextOutput `json:"textMessage,omitempty"`
	// UserProvidedChartSpec: Optional. User provided chart spec
	UserProvidedChartSpec googleapi.RawMessage `json:"userProvidedChartSpec,omitempty"`
	// UserProvidedSqlQuery: Optional. User provided SQL query
	UserProvidedSqlQuery string `json:"userProvidedSqlQuery,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChartSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChartSpec") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1GenerativeInsightConversationTranscriptMessageSystemMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1GenerativeInsightConversationTranscriptMessageSystemMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1GenerativeInsightConversationTranscriptMess
// ageSystemMessageTextOutput: A text output message from the system.
type GoogleCloudContactcenterinsightsV1GenerativeInsightConversationTranscriptMessageSystemMessageTextOutput struct {
	// Text: The parts of the message.
	Text []string `json:"text,omitempty"`
	// TextType: The type of the text message.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - The default text type.
	//   "THOUGHT" - The text is a thinking plan generated by the thinking tool.
	//   "FINAL_RESPONSE" - The text is a final response to the user question.
	//   "PROGRESS" - The text is an informational message about the agent's
	// progress, such as a tool being invoked. This is distinct from the agent's
	// internal thought process (`THOUGHT`) and the final answer to the user
	// (`FINAL_RESPONSE`). These messages provide insight into the agent's actions.
	TextType string `json:"textType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1GenerativeInsightConversationTranscriptMessageSystemMessageTextOutput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1GenerativeInsightConversationTranscriptMessageSystemMessageTextOutput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1GenerativeInsightConversationTranscriptMess
// ageSystemMessages: A wrapper for system messages per turn.
type GoogleCloudContactcenterinsightsV1GenerativeInsightConversationTranscriptMessageSystemMessages struct {
	// SystemMessages: A message from the system in response to the user.
	SystemMessages []*GoogleCloudContactcenterinsightsV1GenerativeInsightConversationTranscriptMessageSystemMessage `json:"systemMessages,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SystemMessages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SystemMessages") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1GenerativeInsightConversationTranscriptMessageSystemMessages) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1GenerativeInsightConversationTranscriptMessageSystemMessages
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1GenerativeInsightConversationTranscriptMess
// ageUserMessage: The user message.
type GoogleCloudContactcenterinsightsV1GenerativeInsightConversationTranscriptMessageUserMessage struct {
	// Text: A message from the user that is interacting with the system.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1GenerativeInsightConversationTranscriptMessageUserMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1GenerativeInsightConversationTranscriptMessageUserMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1GenerativeInsights: Request that use
// natural language query to generate the chart.
type GoogleCloudContactcenterinsightsV1GenerativeInsights struct {
	// ChartCheckpoint: The chart checkpoint used to generate the chart.
	ChartCheckpoint *GoogleCloudContactcenterinsightsV1GenerativeInsightsChartCheckpoint `json:"chartCheckpoint,omitempty"`
	// ChartConversations: Output only. The chart conversations used to generate
	// the chart.
	ChartConversations []*GoogleCloudContactcenterinsightsV1GenerativeInsightsChartConversation `json:"chartConversations,omitempty"`
	// ChartSpec: Chart spec for the chart.
	ChartSpec googleapi.RawMessage `json:"chartSpec,omitempty"`
	Request   googleapi.RawMessage `json:"request,omitempty"`
	// SqlComparisonKey: Optional. For charts with comparison, this key will
	// determine the metric that will be compared between the current and another
	// dataset.
	SqlComparisonKey string `json:"sqlComparisonKey,omitempty"`
	// SqlQuery: SQL query used to generate the chart.
	SqlQuery string `json:"sqlQuery,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChartCheckpoint") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChartCheckpoint") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1GenerativeInsights) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1GenerativeInsights
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1GenerativeInsightsChartCheckpoint: The
// current chart checkpoint state.
type GoogleCloudContactcenterinsightsV1GenerativeInsightsChartCheckpoint struct {
	// RevisionId: The revision id of the chart.
	RevisionId string `json:"revisionId,omitempty"`
	// SessionId: The session id of the chart.
	SessionId string `json:"sessionId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RevisionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RevisionId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1GenerativeInsightsChartCheckpoint) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1GenerativeInsightsChartCheckpoint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1GenerativeInsightsChartConversation: The
// conversation used to generate the chart.
type GoogleCloudContactcenterinsightsV1GenerativeInsightsChartConversation struct {
	// ConversationId: The conversation id of the chart.
	ConversationId string `json:"conversationId,omitempty"`
	// CreateTime: The create time of the conversation.
	CreateTime string `json:"createTime,omitempty"`
	// Messages: Ordered list of messages, including user inputs and system
	// responses.
	Messages []*GoogleCloudContactcenterinsightsV1GenerativeInsightsChartConversationMessage `json:"messages,omitempty"`
	// UpdateTime: The update time of the conversation.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1GenerativeInsightsChartConversation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1GenerativeInsightsChartConversation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1GenerativeInsightsChartConversationMessage:
//
//	The message in the conversation.
type GoogleCloudContactcenterinsightsV1GenerativeInsightsChartConversationMessage struct {
	// CreateTime: For user messages, this is the time at which the system received
	// the message. For system messages, this is the time at which the system
	// generated the message.
	CreateTime string `json:"createTime,omitempty"`
	// MessageId: The message id of the message.
	MessageId string `json:"messageId,omitempty"`
	// SystemMessage: A message from the system in response to the user.
	SystemMessage *GoogleCloudContactcenterinsightsV1GenerativeInsightsChartConversationMessageSystemMessage `json:"systemMessage,omitempty"`
	// UserMessage: A message from the user that is interacting with the system.
	UserMessage *GoogleCloudContactcenterinsightsV1GenerativeInsightsChartConversationMessageUserMessage `json:"userMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1GenerativeInsightsChartConversationMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1GenerativeInsightsChartConversationMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1GenerativeInsightsChartConversationMessageS
// ystemMessage: A message from the system in response to the user. This
// message can also be a message from the user as historical context for
// multiturn conversations with the system.
type GoogleCloudContactcenterinsightsV1GenerativeInsightsChartConversationMessageSystemMessage struct {
	// ChartSpec: Chart spec from LLM
	ChartSpec googleapi.RawMessage `json:"chartSpec,omitempty"`
	// GeneratedSqlQuery: Raw SQL from LLM, before templatization
	GeneratedSqlQuery string `json:"generatedSqlQuery,omitempty"`
	// TextOutput: A direct natural language response to the user message.
	TextOutput *GoogleCloudContactcenterinsightsV1GenerativeInsightsChartConversationMessageSystemMessageTextOutput `json:"textOutput,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChartSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChartSpec") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1GenerativeInsightsChartConversationMessageSystemMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1GenerativeInsightsChartConversationMessageSystemMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1GenerativeInsightsChartConversationMessageS
// ystemMessageTextOutput: A text output message from the system.
type GoogleCloudContactcenterinsightsV1GenerativeInsightsChartConversationMessageSystemMessageTextOutput struct {
	// Texts: The parts of the message.
	Texts []string `json:"texts,omitempty"`
	// Type: The type of the text message.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - The default text type.
	//   "THOUGHT" - The text is a thinking plan generated by the thinking tool.
	//   "FINAL_RESPONSE" - The text is a final response to the user question.
	//   "PROGRESS" - The text is an informational message about the agent's
	// progress, such as a tool being invoked. This is distinct from the agent's
	// internal thought process (`THOUGHT`) and the final answer to the user
	// (`FINAL_RESPONSE`). These messages provide insight into the agent's actions.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Texts") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Texts") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1GenerativeInsightsChartConversationMessageSystemMessageTextOutput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1GenerativeInsightsChartConversationMessageSystemMessageTextOutput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1GenerativeInsightsChartConversationMessageU
// serMessage: The user message.
type GoogleCloudContactcenterinsightsV1GenerativeInsightsChartConversationMessageUserMessage struct {
	// Text: A message from the user that is interacting with the system.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1GenerativeInsightsChartConversationMessageUserMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1GenerativeInsightsChartConversationMessageUserMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1GenerativeInsightsMetadata: The metadata
// for generative insights.
type GoogleCloudContactcenterinsightsV1GenerativeInsightsMetadata struct {
	// ErrorMessages: The error message when the generative insights request fails.
	ErrorMessages []*GoogleRpcStatus `json:"errorMessages,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorMessages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorMessages") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1GenerativeInsightsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1GenerativeInsightsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1GenerativeInsightsRequest: The request for
// generative insights.
type GoogleCloudContactcenterinsightsV1GenerativeInsightsRequest struct {
	// Chart: The full name of the chart resource this request corresponds to.
	// Format:
	// projects/{project}/locations/{location}/dashboards/{dashboard}/charts/{chart}
	Chart string `json:"chart,omitempty"`
	// ComparisonFilter: Optional. Filter for the data that can be specified in
	// addition to the natural language query. This `filter` is specifically used
	// for charts where comparisons are possible. For example, "compare to last
	// month" or "compare to previous quarter".
	ComparisonFilter string `json:"comparisonFilter,omitempty"`
	// Filter: Filter for the data that can be specified in addition to the natural
	// language query. Users are encouraged to use this field to populate
	// time-windows.
	Filter string `json:"filter,omitempty"`
	// NaturalLanguageQuery: The natural language query specified by the user. If
	// this field is specified, `sql_query` will be ignored.
	NaturalLanguageQuery string `json:"naturalLanguageQuery,omitempty"`
	// RevisionId: Optional. The revision id that maps to the state of the chart
	// state revision. When specified, the backend will reload the chart with the
	// sql and visual spec from that revision.
	RevisionId string `json:"revisionId,omitempty"`
	// SessionId: Optional. The session id of the conversation. If the session id
	// is not specified, backend will generate a random session id. If the session
	// id is specified, will associate user-provided user_query with the provided
	// session id.
	SessionId string `json:"sessionId,omitempty"`
	// SqlComparisonKey: Optional. For charts with comparison, this key will
	// determine the metric that will be compared between the current and another
	// dataset.
	SqlComparisonKey string `json:"sqlComparisonKey,omitempty"`
	// SqlQuery: Optional. The SQL query specified by the user. This query must be
	// in BigQuery SQL dialect. The `filter` field will also be ignored, as it is
	// assumed that any filtering is already included in the SQL query.
	SqlQuery string `json:"sqlQuery,omitempty"`
	// UserProvidedChartSpec: Optional. The user provided chart spec for the chart.
	// This will be used to override the visual spec generated by the LLM.
	UserProvidedChartSpec googleapi.RawMessage `json:"userProvidedChartSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Chart") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Chart") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1GenerativeInsightsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1GenerativeInsightsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1GenerativeInsightsResponse: The response
// for generative insights.
type GoogleCloudContactcenterinsightsV1GenerativeInsightsResponse struct {
	// GenerativeResponses: The full list of generative responses. Each response is
	// ordered by time.
	GenerativeResponses []*GoogleCloudContactcenterinsightsV1GenerativeInsightsResponseGenerativeResponse `json:"generativeResponses,omitempty"`
	// Transcript: The transcript of the generative insights conversation.
	Transcript *GoogleCloudContactcenterinsightsV1GenerativeInsightConversationTranscript `json:"transcript,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenerativeResponses") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenerativeResponses") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1GenerativeInsightsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1GenerativeInsightsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1GenerativeInsightsResponseGenerativeRespons
// e: Wrapper for storing the generative response for a chart.
type GoogleCloudContactcenterinsightsV1GenerativeInsightsResponseGenerativeResponse struct {
	// ChartSpec: The chart spec for the data. This will be specified in the
	// vega-lite or vega format.
	ChartSpec googleapi.RawMessage `json:"chartSpec,omitempty"`
	// GeneratedSqlQuery: The generated SQL query from the LLM. Will be populated
	// during the chart building phase. The generated SQL will be cached in the
	// corresponding chart resource.
	GeneratedSqlQuery string `json:"generatedSqlQuery,omitempty"`
	// TextMessage: The text output from the LLM. Will be populated during the
	// chart building phase. For a reloaded chart, this will NOT be populated. May
	// contain THOUGHT or a FINAL response or some in-progress response.
	TextMessage *GoogleCloudContactcenterinsightsV1GenerativeInsightsResponseGenerativeResponseTextOutput `json:"textMessage,omitempty"`
	// TextOutput: The text output from the LLM. Will be populated during the chart
	// building phase. For a reloaded chart, this will NOT be populated. May
	// contain THOUGHT or a FINAL response or some in-progress response.
	TextOutput string `json:"textOutput,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChartSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChartSpec") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1GenerativeInsightsResponseGenerativeResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1GenerativeInsightsResponseGenerativeResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1GenerativeInsightsResponseGenerativeRespons
// eTextOutput: Wrapper for text output.
type GoogleCloudContactcenterinsightsV1GenerativeInsightsResponseGenerativeResponseTextOutput struct {
	// Text: The text output from the LLM.
	Text []string `json:"text,omitempty"`
	// TextType: The type of text output.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - The type is unspecified.
	//   "THOUGHT" - The text is part of LLM reasoning.
	//   "FINAL_RESPONSE" - The text is the final answer from LLM.
	//   "PROGRESS" - The text is an informational message about the agent's
	// progress, such as a tool being invoked. This is distinct from the agent's
	// internal thought process (`THOUGHT`) and the final answer to the user
	// (`FINAL_RESPONSE`). These messages provide insight into the agent's actions.
	TextType string `json:"textType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1GenerativeInsightsResponseGenerativeResponseTextOutput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1GenerativeInsightsResponseGenerativeResponseTextOutput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1HoldData: The data for a hold annotation.
type GoogleCloudContactcenterinsightsV1HoldData struct {
}

// GoogleCloudContactcenterinsightsV1ImportIssueModelMetadata: Metadata used
// for import issue model.
type GoogleCloudContactcenterinsightsV1ImportIssueModelMetadata struct {
	// CreateTime: The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original import request.
	Request *GoogleCloudContactcenterinsightsV1ImportIssueModelRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ImportIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ImportIssueModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ImportIssueModelRequest: Request to import
// an issue model.
type GoogleCloudContactcenterinsightsV1ImportIssueModelRequest struct {
	// CreateNewModel: Optional. If set to true, will create an issue model from
	// the imported file with randomly generated IDs for the issue model and
	// corresponding issues. Otherwise, replaces an existing model with the same ID
	// as the file.
	CreateNewModel bool `json:"createNewModel,omitempty"`
	// GcsSource: Google Cloud Storage source message.
	GcsSource *GoogleCloudContactcenterinsightsV1ImportIssueModelRequestGcsSource `json:"gcsSource,omitempty"`
	// Parent: Required. The parent resource of the issue model.
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateNewModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateNewModel") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ImportIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ImportIssueModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ImportIssueModelRequestGcsSource: Google
// Cloud Storage Object URI to get the issue model file from.
type GoogleCloudContactcenterinsightsV1ImportIssueModelRequestGcsSource struct {
	// ObjectUri: Required. Format: `gs:///`
	ObjectUri string `json:"objectUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ObjectUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ObjectUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ImportIssueModelRequestGcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ImportIssueModelRequestGcsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ImportIssueModelResponse: Response from
// import issue model
type GoogleCloudContactcenterinsightsV1ImportIssueModelResponse struct {
	// IssueModel: The issue model that was imported.
	IssueModel *GoogleCloudContactcenterinsightsV1IssueModel `json:"issueModel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IssueModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IssueModel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ImportIssueModelResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ImportIssueModelResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IngestConversationsMetadata: The metadata
// for an IngestConversations operation.
type GoogleCloudContactcenterinsightsV1IngestConversationsMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// IngestConversationsStats: Output only. Statistics for IngestConversations
	// operation.
	IngestConversationsStats *GoogleCloudContactcenterinsightsV1IngestConversationsMetadataIngestConversationsStats `json:"ingestConversationsStats,omitempty"`
	// PartialErrors: Output only. Partial errors during ingest operation that
	// might cause the operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: Output only. The original request for ingest.
	Request *GoogleCloudContactcenterinsightsV1IngestConversationsRequest `json:"request,omitempty"`
	// SampledConversations: Output only. Stores the conversation resources
	// produced by ingest sampling operations.
	SampledConversations []string `json:"sampledConversations,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1IngestConversationsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IngestConversationsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IngestConversationsMetadataIngestConversati
// onsStats: Statistics for IngestConversations operation.
type GoogleCloudContactcenterinsightsV1IngestConversationsMetadataIngestConversationsStats struct {
	// DuplicatesSkippedCount: Output only. The number of objects skipped because
	// another conversation with the same transcript uri had already been ingested.
	DuplicatesSkippedCount int64 `json:"duplicatesSkippedCount,omitempty"`
	// FailedIngestCount: Output only. The number of objects which were unable to
	// be ingested due to errors. The errors are populated in the partial_errors
	// field.
	FailedIngestCount int64 `json:"failedIngestCount,omitempty"`
	// ProcessedObjectCount: Output only. The number of objects processed during
	// the ingest operation.
	ProcessedObjectCount int64 `json:"processedObjectCount,omitempty"`
	// SuccessfulIngestCount: Output only. The number of new conversations added
	// during this ingest operation.
	SuccessfulIngestCount int64 `json:"successfulIngestCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DuplicatesSkippedCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DuplicatesSkippedCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1IngestConversationsMetadataIngestConversationsStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IngestConversationsMetadataIngestConversationsStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IngestConversationsRequest: The request to
// ingest conversations.
type GoogleCloudContactcenterinsightsV1IngestConversationsRequest struct {
	// ConversationConfig: Configuration that applies to all conversations.
	ConversationConfig *GoogleCloudContactcenterinsightsV1IngestConversationsRequestConversationConfig `json:"conversationConfig,omitempty"`
	// GcsSource: A cloud storage bucket source. Note that any previously ingested
	// objects from the source will be skipped to avoid duplication.
	GcsSource *GoogleCloudContactcenterinsightsV1IngestConversationsRequestGcsSource `json:"gcsSource,omitempty"`
	// Parent: Required. The parent resource for new conversations.
	Parent string `json:"parent,omitempty"`
	// RedactionConfig: Optional. DLP settings for transcript redaction. Optional,
	// will default to the config specified in Settings.
	RedactionConfig *GoogleCloudContactcenterinsightsV1RedactionConfig `json:"redactionConfig,omitempty"`
	// SampleSize: Optional. If set, this fields indicates the number of objects to
	// ingest from the Cloud Storage bucket. If empty, the entire bucket will be
	// ingested. Unless they are first deleted, conversations produced through
	// sampling won't be ingested by subsequent ingest requests.
	SampleSize int64 `json:"sampleSize,omitempty"`
	// SpeechConfig: Optional. Default Speech-to-Text configuration. Optional, will
	// default to the config specified in Settings.
	SpeechConfig *GoogleCloudContactcenterinsightsV1SpeechConfig `json:"speechConfig,omitempty"`
	// TranscriptObjectConfig: Configuration for when `source` contains
	// conversation transcripts.
	TranscriptObjectConfig *GoogleCloudContactcenterinsightsV1IngestConversationsRequestTranscriptObjectConfig `json:"transcriptObjectConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1IngestConversationsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IngestConversationsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IngestConversationsRequestConversationConfi
// g: Configuration that applies to all conversations.
type GoogleCloudContactcenterinsightsV1IngestConversationsRequestConversationConfig struct {
	// AgentChannel: Optional. Indicates which of the channels, 1 or 2, contains
	// the agent. Note that this must be set for conversations to be properly
	// displayed and analyzed.
	AgentChannel int64 `json:"agentChannel,omitempty"`
	// AgentId: Optional. An opaque, user-specified string representing a human
	// agent who handled all conversations in the import. Note that this will be
	// overridden if per-conversation metadata is provided through the
	// `metadata_bucket_uri`.
	AgentId string `json:"agentId,omitempty"`
	// CustomerChannel: Optional. Indicates which of the channels, 1 or 2, contains
	// the agent. Note that this must be set for conversations to be properly
	// displayed and analyzed.
	CustomerChannel int64 `json:"customerChannel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentChannel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentChannel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1IngestConversationsRequestConversationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IngestConversationsRequestConversationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IngestConversationsRequestGcsSource:
// Configuration for Cloud Storage bucket sources.
type GoogleCloudContactcenterinsightsV1IngestConversationsRequestGcsSource struct {
	// AudioBucketUri: Optional. The Cloud Storage path to the conversation audio
	// file. Note that: [1] Audio files will be transcribed if not already. [2]
	// Audio files and transcript files must be in separate buckets / folders. [3]
	// A source file and its corresponding audio file must share the same name to
	// be properly ingested, E.g. `gs://bucket/transcript/conversation1.json` and
	// `gs://bucket/audio/conversation1.mp3`.
	AudioBucketUri string `json:"audioBucketUri,omitempty"`
	// BucketObjectType: Optional. Specifies the type of the objects in
	// `bucket_uri`. Avoid passing this. This is inferred from the
	// `transcript_bucket_uri`, `audio_bucket_uri`.
	//
	// Possible values:
	//   "BUCKET_OBJECT_TYPE_UNSPECIFIED" - The object type is unspecified and will
	// default to `TRANSCRIPT`.
	//   "TRANSCRIPT" - The object is a transcript.
	//   "AUDIO" - The object is an audio file.
	BucketObjectType string `json:"bucketObjectType,omitempty"`
	// BucketUri: Optional. The Cloud Storage bucket containing source objects.
	// Avoid passing this. Pass this through one of `transcript_bucket_uri` or
	// `audio_bucket_uri`.
	BucketUri string `json:"bucketUri,omitempty"`
	// CustomMetadataKeys: Optional. Custom keys to extract as conversation labels
	// from metadata files in `metadata_bucket_uri`. Keys not included in this
	// field will be ignored. Note that there is a limit of 100 labels per
	// conversation.
	CustomMetadataKeys []string `json:"customMetadataKeys,omitempty"`
	// MetadataBucketUri: Optional. The Cloud Storage path to the conversation
	// metadata. Note that: [1] Metadata files are expected to be in JSON format.
	// [2] Metadata and source files (transcripts or audio) must be in separate
	// buckets / folders. [3] A source file and its corresponding metadata file
	// must share the same name to be properly ingested, E.g.
	// `gs://bucket/audio/conversation1.mp3` and
	// `gs://bucket/metadata/conversation1.json`.
	MetadataBucketUri string `json:"metadataBucketUri,omitempty"`
	// TranscriptBucketUri: Optional. The Cloud Storage path to the conversation
	// transcripts. Note that: [1] Transcript files are expected to be in JSON
	// format. [2] Transcript, audio, metadata files must be in separate buckets /
	// folders. [3] A source file and its corresponding metadata file must share
	// the same name to be properly ingested, E.g.
	// `gs://bucket/audio/conversation1.mp3` and
	// `gs://bucket/metadata/conversation1.json`.
	TranscriptBucketUri string `json:"transcriptBucketUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioBucketUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioBucketUri") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1IngestConversationsRequestGcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IngestConversationsRequestGcsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IngestConversationsRequestTranscriptObjectC
// onfig: Configuration for processing transcript objects.
type GoogleCloudContactcenterinsightsV1IngestConversationsRequestTranscriptObjectConfig struct {
	// Medium: Required. The medium transcript objects represent.
	//
	// Possible values:
	//   "MEDIUM_UNSPECIFIED" - Default value for unspecified.
	//   "PHONE_CALL" - The format for conversations that took place over the
	// phone.
	//   "CHAT" - The format for conversations that took place over chat.
	Medium string `json:"medium,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Medium") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Medium") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1IngestConversationsRequestTranscriptObjectConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IngestConversationsRequestTranscriptObjectConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IngestConversationsResponse: The response
// to an IngestConversations operation.
type GoogleCloudContactcenterinsightsV1IngestConversationsResponse struct {
}

// GoogleCloudContactcenterinsightsV1InitializeEncryptionSpecMetadata: Metadata
// for initializing a location-level encryption specification.
type GoogleCloudContactcenterinsightsV1InitializeEncryptionSpecMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// PartialErrors: Partial errors during initializing operation that might cause
	// the operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: Output only. The original request for initialization.
	Request *GoogleCloudContactcenterinsightsV1InitializeEncryptionSpecRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1InitializeEncryptionSpecMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1InitializeEncryptionSpecMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1InitializeEncryptionSpecRequest: The
// request to initialize a location-level encryption specification.
type GoogleCloudContactcenterinsightsV1InitializeEncryptionSpecRequest struct {
	// EncryptionSpec: Required. The encryption spec used for CMEK encryption. It
	// is required that the kms key is in the same region as the endpoint. The same
	// key will be used for all provisioned resources, if encryption is available.
	// If the `kms_key_name` field is left empty, no encryption will be enforced.
	EncryptionSpec *GoogleCloudContactcenterinsightsV1EncryptionSpec `json:"encryptionSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EncryptionSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EncryptionSpec") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1InitializeEncryptionSpecRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1InitializeEncryptionSpecRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1InitializeEncryptionSpecResponse: The
// response to initialize a location-level encryption specification.
type GoogleCloudContactcenterinsightsV1InitializeEncryptionSpecResponse struct {
}

// GoogleCloudContactcenterinsightsV1Intent: The data for an intent. Represents
// a detected intent in the conversation, for example MAKES_PROMISE.
type GoogleCloudContactcenterinsightsV1Intent struct {
	// DisplayName: The human-readable name of the intent.
	DisplayName string `json:"displayName,omitempty"`
	// Id: The unique identifier of the intent.
	Id string `json:"id,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1Intent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1Intent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IntentMatchData: The data for an intent
// match. Represents an intent match for a text segment in the conversation. A
// text segment can be part of a sentence, a complete sentence, or an utterance
// with multiple sentences.
type GoogleCloudContactcenterinsightsV1IntentMatchData struct {
	// IntentUniqueId: The id of the matched intent. Can be used to retrieve the
	// corresponding intent information.
	IntentUniqueId string `json:"intentUniqueId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IntentUniqueId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IntentUniqueId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1IntentMatchData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IntentMatchData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1InterruptionData: The data for an
// interruption annotation.
type GoogleCloudContactcenterinsightsV1InterruptionData struct {
}

// GoogleCloudContactcenterinsightsV1Issue: The issue resource.
type GoogleCloudContactcenterinsightsV1Issue struct {
	// CreateTime: Output only. The time at which this issue was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayDescription: Representative description of the issue.
	DisplayDescription string `json:"displayDescription,omitempty"`
	// DisplayName: The representative name for the issue.
	DisplayName string `json:"displayName,omitempty"`
	// Name: Immutable. The resource name of the issue. Format:
	// projects/{project}/locations/{location}/issueModels/{issue_model}/issues/{iss
	// ue}
	Name string `json:"name,omitempty"`
	// SampleUtterances: Output only. Resource names of the sample representative
	// utterances that match to this issue.
	SampleUtterances []string `json:"sampleUtterances,omitempty"`
	// UpdateTime: Output only. The most recent time that this issue was updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1Issue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1Issue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IssueAssignment: Information about the
// issue.
type GoogleCloudContactcenterinsightsV1IssueAssignment struct {
	// DisplayName: Immutable. Display name of the assigned issue. This field is
	// set at time of analysis and immutable since then.
	DisplayName string `json:"displayName,omitempty"`
	// Issue: Resource name of the assigned issue.
	Issue string `json:"issue,omitempty"`
	// Score: Score indicating the likelihood of the issue assignment. currently
	// bounded on [0,1].
	Score float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1IssueAssignment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IssueAssignment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1IssueAssignment) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1IssueAssignment
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudContactcenterinsightsV1IssueMatchData: The data for an issue
// match annotation.
type GoogleCloudContactcenterinsightsV1IssueMatchData struct {
	// IssueAssignment: Information about the issue's assignment.
	IssueAssignment *GoogleCloudContactcenterinsightsV1IssueAssignment `json:"issueAssignment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IssueAssignment") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IssueAssignment") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1IssueMatchData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IssueMatchData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IssueModel: The issue model resource.
type GoogleCloudContactcenterinsightsV1IssueModel struct {
	// CreateTime: Output only. The time at which this issue model was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: The representative name for the issue model.
	DisplayName string `json:"displayName,omitempty"`
	// InputDataConfig: Configs for the input data that used to create the issue
	// model.
	InputDataConfig *GoogleCloudContactcenterinsightsV1IssueModelInputDataConfig `json:"inputDataConfig,omitempty"`
	// IssueCount: Output only. Number of issues in this issue model.
	IssueCount int64 `json:"issueCount,omitempty,string"`
	// LanguageCode: Language of the model.
	LanguageCode string `json:"languageCode,omitempty"`
	// ModelType: Type of the model.
	//
	// Possible values:
	//   "MODEL_TYPE_UNSPECIFIED" - Unspecified model type.
	//   "TYPE_V1" - Type V1.
	//   "TYPE_V2" - Type V2.
	ModelType string `json:"modelType,omitempty"`
	// Name: Immutable. The resource name of the issue model. Format:
	// projects/{project}/locations/{location}/issueModels/{issue_model}
	Name string `json:"name,omitempty"`
	// State: Output only. State of the model.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified.
	//   "UNDEPLOYED" - Model is not deployed but is ready to deploy.
	//   "DEPLOYING" - Model is being deployed.
	//   "DEPLOYED" - Model is deployed and is ready to be used. A model can only
	// be used in analysis if it's in this state.
	//   "UNDEPLOYING" - Model is being undeployed.
	//   "DELETING" - Model is being deleted.
	State string `json:"state,omitempty"`
	// TrainingStats: Output only. Immutable. The issue model's label statistics on
	// its training data.
	TrainingStats *GoogleCloudContactcenterinsightsV1IssueModelLabelStats `json:"trainingStats,omitempty"`
	// UpdateTime: Output only. The most recent time at which the issue model was
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1IssueModel) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IssueModel
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IssueModelInputDataConfig: Configs for the
// input data used to create the issue model.
type GoogleCloudContactcenterinsightsV1IssueModelInputDataConfig struct {
	// Filter: A filter to reduce the conversations used for training the model to
	// a specific subset. Refer to
	// https://cloud.google.com/contact-center/insights/docs/filtering for details.
	Filter string `json:"filter,omitempty"`
	// Medium: Medium of conversations used in training data. This field is being
	// deprecated. To specify the medium to be used in training a new issue model,
	// set the `medium` field on `filter`.
	//
	// Possible values:
	//   "MEDIUM_UNSPECIFIED" - Default value for unspecified.
	//   "PHONE_CALL" - The format for conversations that took place over the
	// phone.
	//   "CHAT" - The format for conversations that took place over chat.
	Medium string `json:"medium,omitempty"`
	// TrainingConversationsCount: Output only. Number of conversations used in
	// training. Output only.
	TrainingConversationsCount int64 `json:"trainingConversationsCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1IssueModelInputDataConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IssueModelInputDataConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IssueModelLabelStats: Aggregated
// statistics about an issue model.
type GoogleCloudContactcenterinsightsV1IssueModelLabelStats struct {
	// AnalyzedConversationsCount: Number of conversations the issue model has
	// analyzed at this point in time.
	AnalyzedConversationsCount int64 `json:"analyzedConversationsCount,omitempty,string"`
	// IssueStats: Statistics on each issue. Key is the issue's resource name.
	IssueStats map[string]GoogleCloudContactcenterinsightsV1IssueModelLabelStatsIssueStats `json:"issueStats,omitempty"`
	// UnclassifiedConversationsCount: Number of analyzed conversations for which
	// no issue was applicable at this point in time.
	UnclassifiedConversationsCount int64 `json:"unclassifiedConversationsCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "AnalyzedConversationsCount")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalyzedConversationsCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1IssueModelLabelStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IssueModelLabelStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IssueModelLabelStatsIssueStats: Aggregated
// statistics about an issue.
type GoogleCloudContactcenterinsightsV1IssueModelLabelStatsIssueStats struct {
	// DisplayName: Display name of the issue.
	DisplayName string `json:"displayName,omitempty"`
	// Issue: Issue resource. Format:
	// projects/{project}/locations/{location}/issueModels/{issue_model}/issues/{iss
	// ue}
	Issue string `json:"issue,omitempty"`
	// LabeledConversationsCount: Number of conversations attached to the issue at
	// this point in time.
	LabeledConversationsCount int64 `json:"labeledConversationsCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1IssueModelLabelStatsIssueStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IssueModelLabelStatsIssueStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IssueModelResult: Issue Modeling result on
// a conversation.
type GoogleCloudContactcenterinsightsV1IssueModelResult struct {
	// IssueModel: Issue model that generates the result. Format:
	// projects/{project}/locations/{location}/issueModels/{issue_model}
	IssueModel string `json:"issueModel,omitempty"`
	// Issues: All the matched issues.
	Issues []*GoogleCloudContactcenterinsightsV1IssueAssignment `json:"issues,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IssueModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IssueModel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1IssueModelResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IssueModelResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListAllFeedbackLabelsResponse: The
// response for listing all feedback labels.
type GoogleCloudContactcenterinsightsV1ListAllFeedbackLabelsResponse struct {
	// FeedbackLabels: The feedback labels that match the request.
	FeedbackLabels []*GoogleCloudContactcenterinsightsV1FeedbackLabel `json:"feedbackLabels,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "FeedbackLabels") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FeedbackLabels") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListAllFeedbackLabelsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListAllFeedbackLabelsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListAnalysesResponse: The response to list
// analyses.
type GoogleCloudContactcenterinsightsV1ListAnalysesResponse struct {
	// Analyses: The analyses that match the request.
	Analyses []*GoogleCloudContactcenterinsightsV1Analysis `json:"analyses,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Analyses") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Analyses") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListAnalysesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListAnalysesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListAnalysisRulesResponse: The response of
// listing views.
type GoogleCloudContactcenterinsightsV1ListAnalysisRulesResponse struct {
	// AnalysisRules: The analysis_rule that match the request.
	AnalysisRules []*GoogleCloudContactcenterinsightsV1AnalysisRule `json:"analysisRules,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AnalysisRules") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalysisRules") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListAnalysisRulesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListAnalysisRulesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListAssessmentRulesResponse: The response
// of listing assessment rules.
type GoogleCloudContactcenterinsightsV1ListAssessmentRulesResponse struct {
	// AssessmentRules: The assessment rules that match the request.
	AssessmentRules []*GoogleCloudContactcenterinsightsV1AssessmentRule `json:"assessmentRules,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AssessmentRules") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AssessmentRules") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListAssessmentRulesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListAssessmentRulesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListAssessmentsResponse: The response of
// listing assessments.
type GoogleCloudContactcenterinsightsV1ListAssessmentsResponse struct {
	// Assessments: The assessments that match the request.
	Assessments []*GoogleCloudContactcenterinsightsV1Assessment `json:"assessments,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Assessments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Assessments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListAssessmentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListAssessmentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListAuthorizedViewSetsResponse: The
// response from a ListAuthorizedViewSet request.
type GoogleCloudContactcenterinsightsV1ListAuthorizedViewSetsResponse struct {
	// AuthorizedViewSets: The AuthorizedViewSets under the parent.
	AuthorizedViewSets []*GoogleCloudContactcenterinsightsV1AuthorizedViewSet `json:"authorizedViewSets,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AuthorizedViewSets") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuthorizedViewSets") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListAuthorizedViewSetsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListAuthorizedViewSetsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListAuthorizedViewsResponse: The response
// from a ListAuthorizedViews request.
type GoogleCloudContactcenterinsightsV1ListAuthorizedViewsResponse struct {
	// AuthorizedViews: The AuthorizedViews under the parent.
	AuthorizedViews []*GoogleCloudContactcenterinsightsV1AuthorizedView `json:"authorizedViews,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AuthorizedViews") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuthorizedViews") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListAuthorizedViewsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListAuthorizedViewsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListAutoLabelingRulesResponse: The
// response message for listing auto labeling rules.
type GoogleCloudContactcenterinsightsV1ListAutoLabelingRulesResponse struct {
	// AutoLabelingRules: The auto labeling rules.
	AutoLabelingRules []*GoogleCloudContactcenterinsightsV1AutoLabelingRule `json:"autoLabelingRules,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AutoLabelingRules") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoLabelingRules") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListAutoLabelingRulesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListAutoLabelingRulesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListChartsResponse: The response of
// listing charts.
type GoogleCloudContactcenterinsightsV1ListChartsResponse struct {
	// Charts: The charts under the parent.
	Charts []*GoogleCloudContactcenterinsightsV1Chart `json:"charts,omitempty"`
	// NextPageToken: The value returned by the last `ListChartsResponse`. This
	// value indicates that this is a continuation of a prior `ListCharts` call and
	// that the system should return the next page of data.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Charts") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Charts") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListChartsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListChartsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListConversationsResponse: The response of
// listing conversations.
type GoogleCloudContactcenterinsightsV1ListConversationsResponse struct {
	// Conversations: The conversations that match the request.
	Conversations []*GoogleCloudContactcenterinsightsV1Conversation `json:"conversations,omitempty"`
	// NextPageToken: A token which can be sent as `page_token` to retrieve the
	// next page. If this field is set, it means there is another page available.
	// If it is not set, it means no other pages are available.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Conversations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conversations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListConversationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListConversationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListDashboardsResponse: The response of
// listing dashboards.
type GoogleCloudContactcenterinsightsV1ListDashboardsResponse struct {
	// Dashboards: The dashboards under the parent.
	Dashboards []*GoogleCloudContactcenterinsightsV1Dashboard `json:"dashboards,omitempty"`
	// NextPageToken: The value returned by the last `ListDashboardsResponse`. This
	// value indicates that this is a continuation of a prior `ListDashboards` call
	// and that the system should return the next page of data.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Dashboards") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dashboards") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListDashboardsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListDashboardsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListDatasetsResponse: The response to list
// datasets.
type GoogleCloudContactcenterinsightsV1ListDatasetsResponse struct {
	// Datasets: The datasets that match the request.
	Datasets []*GoogleCloudContactcenterinsightsV1Dataset `json:"datasets,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Datasets") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Datasets") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListDatasetsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListDatasetsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListFeedbackLabelsResponse: The response
// for listing feedback labels.
type GoogleCloudContactcenterinsightsV1ListFeedbackLabelsResponse struct {
	// FeedbackLabels: The feedback labels that match the request.
	FeedbackLabels []*GoogleCloudContactcenterinsightsV1FeedbackLabel `json:"feedbackLabels,omitempty"`
	// NextPageToken: The next page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "FeedbackLabels") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FeedbackLabels") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListFeedbackLabelsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListFeedbackLabelsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListIssueModelsResponse: The response of
// listing issue models.
type GoogleCloudContactcenterinsightsV1ListIssueModelsResponse struct {
	// IssueModels: The issue models that match the request.
	IssueModels []*GoogleCloudContactcenterinsightsV1IssueModel `json:"issueModels,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "IssueModels") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IssueModels") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListIssueModelsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListIssueModelsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListIssuesResponse: The response of
// listing issues.
type GoogleCloudContactcenterinsightsV1ListIssuesResponse struct {
	// Issues: The issues that match the request.
	Issues []*GoogleCloudContactcenterinsightsV1Issue `json:"issues,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Issues") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Issues") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListIssuesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListIssuesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListNotesResponse: The response of listing
// notes.
type GoogleCloudContactcenterinsightsV1ListNotesResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Notes: The notes that match the request.
	Notes []*GoogleCloudContactcenterinsightsV1Note `json:"notes,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListNotesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListNotesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListPhraseMatchersResponse: The response
// of listing phrase matchers.
type GoogleCloudContactcenterinsightsV1ListPhraseMatchersResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// PhraseMatchers: The phrase matchers that match the request.
	PhraseMatchers []*GoogleCloudContactcenterinsightsV1PhraseMatcher `json:"phraseMatchers,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListPhraseMatchersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListPhraseMatchersResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListQaQuestionTagsResponse: The response
// from a ListQaQuestionTags request.
type GoogleCloudContactcenterinsightsV1ListQaQuestionTagsResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// QaQuestionTags: The parent resource of the questions.
	QaQuestionTags []*GoogleCloudContactcenterinsightsV1QaQuestionTag `json:"qaQuestionTags,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListQaQuestionTagsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListQaQuestionTagsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListQaQuestionsResponse: The response from
// a ListQaQuestions request.
type GoogleCloudContactcenterinsightsV1ListQaQuestionsResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// QaQuestions: The QaQuestions under the parent.
	QaQuestions []*GoogleCloudContactcenterinsightsV1QaQuestion `json:"qaQuestions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListQaQuestionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListQaQuestionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListQaScorecardRevisionsResponse: The
// response from a ListQaScorecardRevisions request.
type GoogleCloudContactcenterinsightsV1ListQaScorecardRevisionsResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// QaScorecardRevisions: The QaScorecards under the parent.
	QaScorecardRevisions []*GoogleCloudContactcenterinsightsV1QaScorecardRevision `json:"qaScorecardRevisions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListQaScorecardRevisionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListQaScorecardRevisionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListQaScorecardsResponse: The response
// from a ListQaScorecards request.
type GoogleCloudContactcenterinsightsV1ListQaScorecardsResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// QaScorecards: The QaScorecards under the parent.
	QaScorecards []*GoogleCloudContactcenterinsightsV1QaScorecard `json:"qaScorecards,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListQaScorecardsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListQaScorecardsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListViewsResponse: The response of listing
// views.
type GoogleCloudContactcenterinsightsV1ListViewsResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Views: The views that match the request.
	Views []*GoogleCloudContactcenterinsightsV1View `json:"views,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListViewsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListViewsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1Note: The conversation assessment note
// resource.
type GoogleCloudContactcenterinsightsV1Note struct {
	// AssessmentNote: The note is associated to the entire parent assessment.
	AssessmentNote *GoogleCloudContactcenterinsightsV1NoteAssessmentNote `json:"assessmentNote,omitempty"`
	// Content: The note content.
	Content string `json:"content,omitempty"`
	// ConversationTurnNote: The note is associated with a conversation turn.
	ConversationTurnNote *GoogleCloudContactcenterinsightsV1NoteConversationTurnNote `json:"conversationTurnNote,omitempty"`
	// CreateTime: Output only. The time at which the note was created.
	CreateTime string `json:"createTime,omitempty"`
	// Name: Identifier. The resource name of the note. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}/assessme
	// nts/{assessment}/notes/{note}
	Name string `json:"name,omitempty"`
	// NoteCreator: Output only. The user that created the note.
	NoteCreator *GoogleCloudContactcenterinsightsV1UserInfo `json:"noteCreator,omitempty"`
	// QaQuestionNote: The note is associated with a QA question in one of the
	// conversation's scorecard results.
	QaQuestionNote *GoogleCloudContactcenterinsightsV1NoteQaQuestionNote `json:"qaQuestionNote,omitempty"`
	// UpdateTime: Output only. The time at which the note was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AssessmentNote") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AssessmentNote") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1Note) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1Note
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1NoteAssessmentNote: A note about the
// entire parent assessment.
type GoogleCloudContactcenterinsightsV1NoteAssessmentNote struct {
}

// GoogleCloudContactcenterinsightsV1NoteConversationTurnNote: A note about a
// conversation turn.
type GoogleCloudContactcenterinsightsV1NoteConversationTurnNote struct {
	// TurnIndex: The conversation turn index that the note is associated with.
	TurnIndex int64 `json:"turnIndex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TurnIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TurnIndex") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1NoteConversationTurnNote) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1NoteConversationTurnNote
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1NoteQaQuestionNote: A note about a QA
// question.
type GoogleCloudContactcenterinsightsV1NoteQaQuestionNote struct {
	// QaQuestion: The question resource that the note is associated with.
	QaQuestion string `json:"qaQuestion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QaQuestion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QaQuestion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1NoteQaQuestionNote) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1NoteQaQuestionNote
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1PhraseMatchData: The data for a matched
// phrase matcher. Represents information identifying a phrase matcher for a
// given match.
type GoogleCloudContactcenterinsightsV1PhraseMatchData struct {
	// DisplayName: The human-readable name of the phrase matcher.
	DisplayName string `json:"displayName,omitempty"`
	// PhraseMatcher: The unique identifier (the resource name) of the phrase
	// matcher.
	PhraseMatcher string `json:"phraseMatcher,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1PhraseMatchData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1PhraseMatchData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1PhraseMatchRule: The data for a phrase
// match rule.
type GoogleCloudContactcenterinsightsV1PhraseMatchRule struct {
	// Config: Provides additional information about the rule that specifies how to
	// apply the rule.
	Config *GoogleCloudContactcenterinsightsV1PhraseMatchRuleConfig `json:"config,omitempty"`
	// Negated: Specifies whether the phrase must be missing from the transcript
	// segment or present in the transcript segment.
	Negated bool `json:"negated,omitempty"`
	// Query: Required. The phrase to be matched.
	Query string `json:"query,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Config") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Config") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1PhraseMatchRule) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1PhraseMatchRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1PhraseMatchRuleConfig: Configuration
// information of a phrase match rule.
type GoogleCloudContactcenterinsightsV1PhraseMatchRuleConfig struct {
	// ExactMatchConfig: The configuration for the exact match rule.
	ExactMatchConfig *GoogleCloudContactcenterinsightsV1ExactMatchConfig `json:"exactMatchConfig,omitempty"`
	// RegexMatchConfig: The configuration for the regex match rule.
	RegexMatchConfig *GoogleCloudContactcenterinsightsV1RegexMatchConfig `json:"regexMatchConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExactMatchConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExactMatchConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1PhraseMatchRuleConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1PhraseMatchRuleConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1PhraseMatchRuleGroup: A message
// representing a rule in the phrase matcher.
type GoogleCloudContactcenterinsightsV1PhraseMatchRuleGroup struct {
	// PhraseMatchRules: A list of phrase match rules that are included in this
	// group.
	PhraseMatchRules []*GoogleCloudContactcenterinsightsV1PhraseMatchRule `json:"phraseMatchRules,omitempty"`
	// Type: Required. The type of this phrase match rule group.
	//
	// Possible values:
	//   "PHRASE_MATCH_RULE_GROUP_TYPE_UNSPECIFIED" - Unspecified.
	//   "ALL_OF" - Must meet all phrase match rules or there is no match.
	//   "ANY_OF" - If any of the phrase match rules are met, there is a match.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PhraseMatchRules") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PhraseMatchRules") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1PhraseMatchRuleGroup) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1PhraseMatchRuleGroup
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1PhraseMatcher: The phrase matcher
// resource.
type GoogleCloudContactcenterinsightsV1PhraseMatcher struct {
	// ActivationUpdateTime: Output only. The most recent time at which the
	// activation status was updated.
	ActivationUpdateTime string `json:"activationUpdateTime,omitempty"`
	// Active: Applies the phrase matcher only when it is active.
	Active bool `json:"active,omitempty"`
	// DisplayName: The human-readable name of the phrase matcher.
	DisplayName string `json:"displayName,omitempty"`
	// Name: The resource name of the phrase matcher. Format:
	// projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}
	Name string `json:"name,omitempty"`
	// PhraseMatchRuleGroups: A list of phase match rule groups that are included
	// in this matcher.
	PhraseMatchRuleGroups []*GoogleCloudContactcenterinsightsV1PhraseMatchRuleGroup `json:"phraseMatchRuleGroups,omitempty"`
	// RevisionCreateTime: Output only. The timestamp of when the revision was
	// created. It is also the create time when a new matcher is added.
	RevisionCreateTime string `json:"revisionCreateTime,omitempty"`
	// RevisionId: Output only. Immutable. The revision ID of the phrase matcher. A
	// new revision is committed whenever the matcher is changed, except when it is
	// activated or deactivated. A server generated random ID will be used.
	// Example: locations/global/phraseMatchers/my-first-matcher@1234567
	RevisionId string `json:"revisionId,omitempty"`
	// RoleMatch: The role whose utterances the phrase matcher should be matched
	// against. If the role is ROLE_UNSPECIFIED it will be matched against any
	// utterances in the transcript.
	//
	// Possible values:
	//   "ROLE_UNSPECIFIED" - Participant's role is not set.
	//   "HUMAN_AGENT" - Participant is a human agent.
	//   "AUTOMATED_AGENT" - Participant is an automated agent.
	//   "END_USER" - Participant is an end user who conversed with the contact
	// center.
	//   "ANY_AGENT" - Participant is either a human or automated agent.
	RoleMatch string `json:"roleMatch,omitempty"`
	// Type: Required. The type of this phrase matcher.
	//
	// Possible values:
	//   "PHRASE_MATCHER_TYPE_UNSPECIFIED" - Unspecified.
	//   "ALL_OF" - Must meet all phrase match rule groups or there is no match.
	//   "ANY_OF" - If any of the phrase match rule groups are met, there is a
	// match.
	Type string `json:"type,omitempty"`
	// UpdateTime: Output only. The most recent time at which the phrase matcher
	// was updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// VersionTag: The customized version tag to use for the phrase matcher. If not
	// specified, it will default to `revision_id`.
	VersionTag string `json:"versionTag,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ActivationUpdateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActivationUpdateTime") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1PhraseMatcher) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1PhraseMatcher
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1PublishAssessmentRequest: The message to
// publish an assessment. Draft and appealed assessments can be published.
// Publishing simply changes the state of the assessment to published, allowing
// the console and authorized views to filter on the state.
type GoogleCloudContactcenterinsightsV1PublishAssessmentRequest struct {
}

// GoogleCloudContactcenterinsightsV1QaAnswer: An answer to a QaQuestion.
type GoogleCloudContactcenterinsightsV1QaAnswer struct {
	// AnswerSources: Lists all answer sources containing one or more answer values
	// of a specific source type, e.g., all system-generated answer sources, or all
	// manual edit answer sources.
	AnswerSources []*GoogleCloudContactcenterinsightsV1QaAnswerAnswerSource `json:"answerSources,omitempty"`
	// AnswerValue: The answer value from this source. This field is populated by
	// default, unless the question has a selection strategy configured to return
	// multiple answer values, in which case `answer_values` will be populated
	// instead.
	AnswerValue *GoogleCloudContactcenterinsightsV1QaAnswerAnswerValue `json:"answerValue,omitempty"`
	// Conversation: The conversation the answer applies to.
	Conversation string `json:"conversation,omitempty"`
	// QaQuestion: The QaQuestion answered by this answer.
	QaQuestion string `json:"qaQuestion,omitempty"`
	// QuestionBody: Question text. E.g., "Did the agent greet the customer?"
	QuestionBody string `json:"questionBody,omitempty"`
	// Tags: User-defined list of arbitrary tags. Matches the value from
	// QaScorecard.ScorecardQuestion.tags. Used for grouping/organization and for
	// weighting the score of each answer.
	Tags []string `json:"tags,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerSources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerSources") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QaAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QaAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QaAnswerAnswerSource: A question may have
// multiple answers from varying sources, one of which becomes the "main"
// answer above. AnswerSource represents each individual answer.
type GoogleCloudContactcenterinsightsV1QaAnswerAnswerSource struct {
	// AnswerValue: The answer value from this source. This field is populated by
	// default, unless the question has a selection strategy configured to return
	// multiple answer values, in which case `answer_values` will be populated
	// instead.
	AnswerValue *GoogleCloudContactcenterinsightsV1QaAnswerAnswerValue `json:"answerValue,omitempty"`
	// SourceType: What created the answer.
	//
	// Possible values:
	//   "SOURCE_TYPE_UNSPECIFIED" - Source type is unspecified.
	//   "SYSTEM_GENERATED" - Answer was system-generated; created during an
	// Insights analysis.
	//   "MANUAL_EDIT" - Answer was created by a human via manual edit.
	SourceType string `json:"sourceType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QaAnswerAnswerSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QaAnswerAnswerSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QaAnswerAnswerValue: Message for holding
// the value of a QaAnswer. QaQuestion.AnswerChoice defines the possible answer
// values for a question.
type GoogleCloudContactcenterinsightsV1QaAnswerAnswerValue struct {
	// BoolValue: Boolean value.
	BoolValue bool `json:"boolValue,omitempty"`
	// Key: A short string used as an identifier. Matches the value used in
	// QaQuestion.AnswerChoice.key.
	Key string `json:"key,omitempty"`
	// NaValue: A value of "Not Applicable (N/A)". Should only ever be `true`.
	NaValue bool `json:"naValue,omitempty"`
	// NormalizedScore: Output only. Normalized score of the questions. Calculated
	// as score / potential_score.
	NormalizedScore float64 `json:"normalizedScore,omitempty"`
	// NumValue: Numerical value.
	NumValue float64 `json:"numValue,omitempty"`
	// PotentialScore: Output only. The maximum potential score of the question.
	PotentialScore float64 `json:"potentialScore,omitempty"`
	// Score: Output only. Numerical score of the answer.
	Score float64 `json:"score,omitempty"`
	// SkipValue: Output only. A value of "Skip". If provided, this field may only
	// be set to `true`. If a question receives this answer, it will be excluded
	// from any score calculations. This would mean that the question was not
	// evaluated.
	SkipValue bool `json:"skipValue,omitempty"`
	// StrValue: String value.
	StrValue string `json:"strValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoolValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoolValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QaAnswerAnswerValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QaAnswerAnswerValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1QaAnswerAnswerValue) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1QaAnswerAnswerValue
	var s1 struct {
		NormalizedScore gensupport.JSONFloat64 `json:"normalizedScore"`
		NumValue        gensupport.JSONFloat64 `json:"numValue"`
		PotentialScore  gensupport.JSONFloat64 `json:"potentialScore"`
		Score           gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.NormalizedScore = float64(s1.NormalizedScore)
	s.NumValue = float64(s1.NumValue)
	s.PotentialScore = float64(s1.PotentialScore)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudContactcenterinsightsV1QaQuestion: A single question to be scored
// by the Insights QA feature.
type GoogleCloudContactcenterinsightsV1QaQuestion struct {
	// Abbreviation: Short, descriptive string, used in the UI where it's not
	// practical to display the full question body. E.g., "Greeting".
	Abbreviation string `json:"abbreviation,omitempty"`
	// AnswerChoices: A list of valid answers to the question, which the LLM must
	// choose from.
	AnswerChoices []*GoogleCloudContactcenterinsightsV1QaQuestionAnswerChoice `json:"answerChoices,omitempty"`
	// AnswerInstructions: Instructions describing how to determine the answer.
	AnswerInstructions string `json:"answerInstructions,omitempty"`
	// CreateTime: Output only. The time at which this question was created.
	CreateTime string `json:"createTime,omitempty"`
	// Metrics: Metrics of the underlying tuned LLM over a holdout/test set while
	// fine tuning the underlying LLM for the given question. This field will only
	// be populated if and only if the question is part of a scorecard revision
	// that has been tuned.
	Metrics *GoogleCloudContactcenterinsightsV1QaQuestionMetrics `json:"metrics,omitempty"`
	// Name: Identifier. The resource name of the question. Format:
	// projects/{project}/locations/{location}/qaScorecards/{qa_scorecard}/revisions
	// /{revision}/qaQuestions/{qa_question}
	Name string `json:"name,omitempty"`
	// Order: Defines the order of the question within its parent scorecard
	// revision.
	Order int64 `json:"order,omitempty"`
	// PredefinedQuestionConfig: The configuration of the predefined question. This
	// field will only be set if the Question Type is predefined.
	PredefinedQuestionConfig *GoogleCloudContactcenterinsightsV1QaQuestionPredefinedQuestionConfig `json:"predefinedQuestionConfig,omitempty"`
	// QaQuestionDataOptions: Options for configuring the data used to generate the
	// QA question.
	QaQuestionDataOptions *GoogleCloudContactcenterinsightsV1QaQuestionQaQuestionDataOptions `json:"qaQuestionDataOptions,omitempty"`
	// QuestionBody: Question text. E.g., "Did the agent greet the customer?"
	QuestionBody string `json:"questionBody,omitempty"`
	// QuestionType: The type of question.
	//
	// Possible values:
	//   "QA_QUESTION_TYPE_UNSPECIFIED" - The type of the question is unspecified.
	//   "CUSTOMIZABLE" - The default question type. The question is fully
	// customizable by the user.
	//   "PREDEFINED" - The question type is using a predefined model provided by
	// CCAI teams. Users are not allowed to edit the question_body, answer_choices,
	// upload feedback labels for the question nor fine-tune the question. However,
	// users may edit other fields like question tags, question order, etc.
	QuestionType string `json:"questionType,omitempty"`
	// Tags: Questions are tagged for categorization and scoring. Tags can either
	// be: - Default Tags: These are predefined categories. They are identified by
	// their string value (e.g., "BUSINESS", "COMPLIANCE", and "CUSTOMER"). -
	// Custom Tags: These are user-defined categories. They are identified by their
	// full resource name (e.g.,
	// projects/{project}/locations/{location}/qaQuestionTags/{qa_question_tag}).
	// Both default and custom tags are used to group questions and to influence
	// the scoring of each question.
	Tags []string `json:"tags,omitempty"`
	// TuningMetadata: Metadata about the tuning operation for the question.This
	// field will only be populated if and only if the question is part of a
	// scorecard revision that has been tuned.
	TuningMetadata *GoogleCloudContactcenterinsightsV1QaQuestionTuningMetadata `json:"tuningMetadata,omitempty"`
	// UpdateTime: Output only. The most recent time at which the question was
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Abbreviation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Abbreviation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QaQuestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QaQuestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QaQuestionAnswerChoice: Message
// representing a possible answer to the question.
type GoogleCloudContactcenterinsightsV1QaQuestionAnswerChoice struct {
	// BoolValue: Boolean value.
	BoolValue bool `json:"boolValue,omitempty"`
	// Key: A short string used as an identifier.
	Key string `json:"key,omitempty"`
	// NaValue: A value of "Not Applicable (N/A)". If provided, this field may only
	// be set to `true`. If a question receives this answer, it will be excluded
	// from any score calculations.
	NaValue bool `json:"naValue,omitempty"`
	// NumValue: Numerical value.
	NumValue float64 `json:"numValue,omitempty"`
	// Score: Numerical score of the answer, used for generating the overall score
	// of a QaScorecardResult. If the answer uses na_value, this field is unused.
	Score float64 `json:"score,omitempty"`
	// StrValue: String value.
	StrValue string `json:"strValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoolValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoolValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QaQuestionAnswerChoice) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QaQuestionAnswerChoice
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1QaQuestionAnswerChoice) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1QaQuestionAnswerChoice
	var s1 struct {
		NumValue gensupport.JSONFloat64 `json:"numValue"`
		Score    gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.NumValue = float64(s1.NumValue)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudContactcenterinsightsV1QaQuestionMetrics: A wrapper representing
// metrics calculated against a test-set on a LLM that was fine tuned for this
// question.
type GoogleCloudContactcenterinsightsV1QaQuestionMetrics struct {
	// Accuracy: Output only. Accuracy of the model. Measures the percentage of
	// correct answers the model gave on the test set.
	Accuracy float64 `json:"accuracy,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Accuracy") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Accuracy") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QaQuestionMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QaQuestionMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1QaQuestionMetrics) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1QaQuestionMetrics
	var s1 struct {
		Accuracy gensupport.JSONFloat64 `json:"accuracy"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Accuracy = float64(s1.Accuracy)
	return nil
}

// GoogleCloudContactcenterinsightsV1QaQuestionPredefinedQuestionConfig:
// Configuration for a predefined question. This field will only be set if the
// Question Type is predefined.
type GoogleCloudContactcenterinsightsV1QaQuestionPredefinedQuestionConfig struct {
	// Type: The type of the predefined question.
	//
	// Possible values:
	//   "PREDEFINED_QUESTION_TYPE_UNSPECIFIED" - The type of the predefined
	// question is unspecified.
	//   "CONVERSATION_OUTCOME" - A prebuilt classifier classfying the outcome of
	// the conversation. For example, if the customer issue mentioned in a
	// conversation has been resolved or not.
	//   "CONVERSATION_OUTCOME_ESCALATION_INITIATOR_ROLE" - A prebuilt classifier
	// classfying the initiator of the conversation escalation. For example, if it
	// was initiated by the customer or the agent.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Type") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Type") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QaQuestionPredefinedQuestionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QaQuestionPredefinedQuestionConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QaQuestionQaQuestionDataOptions: Options
// for configuring the data used to generate the QA question.
type GoogleCloudContactcenterinsightsV1QaQuestionQaQuestionDataOptions struct {
	// ConversationDataOptions: Options for configuring the conversation data used
	// to generate the QA question.
	ConversationDataOptions *GoogleCloudContactcenterinsightsV1ConversationDataOptions `json:"conversationDataOptions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationDataOptions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationDataOptions") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QaQuestionQaQuestionDataOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QaQuestionQaQuestionDataOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QaQuestionTag: A tag is a resource which
// aims to categorize a set of questions across multiple scorecards, e.g.,
// "Customer Satisfaction","Billing", etc.
type GoogleCloudContactcenterinsightsV1QaQuestionTag struct {
	// CreateTime: Output only. The time at which the question tag was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Required. A user-specified display name for the tag.
	DisplayName string `json:"displayName,omitempty"`
	// Name: Identifier. Resource name for the QaQuestionTag Format
	// projects/{project}/locations/{location}/qaQuestionTags/{qa_question_tag} In
	// the above format, the last segment, i.e., qa_question_tag, is a
	// server-generated ID corresponding to the tag resource.
	Name string `json:"name,omitempty"`
	// QaQuestionIds: Optional. The list of Scorecard Question IDs that the tag
	// applies to. Each QaQuestionId is represented as a full resource name
	// containing the Question ID. Lastly, Since a tag may not necessarily be
	// referenced by any Scorecard Questions, we treat this field as optional.
	QaQuestionIds []string `json:"qaQuestionIds,omitempty"`
	// UpdateTime: Output only. The most recent time at which the question tag was
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QaQuestionTag) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QaQuestionTag
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QaQuestionTuningMetadata: Metadata about
// the tuning operation for the question. Will only be set if a scorecard
// containing this question has been tuned.
type GoogleCloudContactcenterinsightsV1QaQuestionTuningMetadata struct {
	// DatasetValidationWarnings: A list of any applicable data validation warnings
	// about the question's feedback labels.
	//
	// Possible values:
	//   "DATASET_VALIDATION_WARNING_UNSPECIFIED" - Unspecified data validation
	// warning.
	//   "TOO_MANY_INVALID_FEEDBACK_LABELS" - A non-trivial percentage of the
	// feedback labels are invalid.
	//   "INSUFFICIENT_FEEDBACK_LABELS" - The quantity of valid feedback labels
	// provided is less than the recommended minimum.
	//   "INSUFFICIENT_FEEDBACK_LABELS_PER_ANSWER" - One or more of the answers
	// have less than the recommended minimum of feedback labels.
	//   "ALL_FEEDBACK_LABELS_HAVE_THE_SAME_ANSWER" - All the labels in the dataset
	// come from a single answer choice.
	DatasetValidationWarnings []string `json:"datasetValidationWarnings,omitempty"`
	// TotalValidLabelCount: Total number of valid labels provided for the question
	// at the time of tuining.
	TotalValidLabelCount int64 `json:"totalValidLabelCount,omitempty,string"`
	// TuningError: Error status of the tuning operation for the question. Will
	// only be set if the tuning operation failed.
	TuningError string `json:"tuningError,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatasetValidationWarnings")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatasetValidationWarnings") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QaQuestionTuningMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QaQuestionTuningMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QaScorecard: A QaScorecard represents a
// collection of questions to be scored during analysis.
type GoogleCloudContactcenterinsightsV1QaScorecard struct {
	// CreateTime: Output only. The time at which this scorecard was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: A text description explaining the intent of the scorecard.
	Description string `json:"description,omitempty"`
	// DisplayName: The user-specified display name of the scorecard.
	DisplayName string `json:"displayName,omitempty"`
	// IsDefault: Whether the scorecard is the default one for the project. A
	// default scorecard cannot be deleted and will always appear first in
	// scorecard selector.
	IsDefault bool `json:"isDefault,omitempty"`
	// Name: Identifier. The scorecard name. Format:
	// projects/{project}/locations/{location}/qaScorecards/{qa_scorecard}
	Name string `json:"name,omitempty"`
	// Source: Output only. The source of the scorecard.
	//
	// Possible values:
	//   "QA_SCORECARD_SOURCE_UNSPECIFIED" - The source of the scorecard is
	// unspecified. Default to QA_SCORECARD_SOURCE_CUSTOMER_DEFINED.
	//   "QA_SCORECARD_SOURCE_CUSTOMER_DEFINED" - The scorecard is a custom
	// scorecard created by the user.
	//   "QA_SCORECARD_SOURCE_DISCOVERY_ENGINE" - The scorecard is a scorecard
	// created through discovery engine deployment.
	Source string `json:"source,omitempty"`
	// UpdateTime: Output only. The most recent time at which the scorecard was
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QaScorecard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QaScorecard
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QaScorecardResult: The results of scoring
// a single conversation against a QaScorecard. Contains a collection of
// QaAnswers and aggregate score.
type GoogleCloudContactcenterinsightsV1QaScorecardResult struct {
	// AgentId: ID of the agent that handled the conversation.
	AgentId string `json:"agentId,omitempty"`
	// Conversation: The conversation scored by this result.
	Conversation string `json:"conversation,omitempty"`
	// CreateTime: Output only. The timestamp that the revision was created.
	CreateTime string `json:"createTime,omitempty"`
	// Name: Identifier. The name of the scorecard result. Format:
	// projects/{project}/locations/{location}/qaScorecardResults/{qa_scorecard_resu
	// lt}
	Name string `json:"name,omitempty"`
	// NormalizedScore: The normalized score, which is the score divided by the
	// potential score. Any manual edits are included if they exist.
	NormalizedScore float64 `json:"normalizedScore,omitempty"`
	// PotentialScore: The maximum potential overall score of the scorecard. Any
	// questions answered using `na_value` are excluded from this calculation.
	PotentialScore float64 `json:"potentialScore,omitempty"`
	// QaAnswers: Set of QaAnswers represented in the result.
	QaAnswers []*GoogleCloudContactcenterinsightsV1QaAnswer `json:"qaAnswers,omitempty"`
	// QaScorecardRevision: The QaScorecardRevision scored by this result.
	QaScorecardRevision string `json:"qaScorecardRevision,omitempty"`
	// QaTagResults: Collection of tags and their scores.
	QaTagResults []*GoogleCloudContactcenterinsightsV1QaScorecardResultQaTagResult `json:"qaTagResults,omitempty"`
	// Score: The overall numerical score of the result, incorporating any manual
	// edits if they exist.
	Score float64 `json:"score,omitempty"`
	// ScoreSources: List of all individual score sets.
	ScoreSources []*GoogleCloudContactcenterinsightsV1QaScorecardResultScoreSource `json:"scoreSources,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QaScorecardResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QaScorecardResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1QaScorecardResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1QaScorecardResult
	var s1 struct {
		NormalizedScore gensupport.JSONFloat64 `json:"normalizedScore"`
		PotentialScore  gensupport.JSONFloat64 `json:"potentialScore"`
		Score           gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.NormalizedScore = float64(s1.NormalizedScore)
	s.PotentialScore = float64(s1.PotentialScore)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudContactcenterinsightsV1QaScorecardResultQaTagResult: Tags and
// their corresponding results.
type GoogleCloudContactcenterinsightsV1QaScorecardResultQaTagResult struct {
	// NormalizedScore: The normalized score the tag applies to.
	NormalizedScore float64 `json:"normalizedScore,omitempty"`
	// PotentialScore: The potential score the tag applies to.
	PotentialScore float64 `json:"potentialScore,omitempty"`
	// Score: The score the tag applies to.
	Score float64 `json:"score,omitempty"`
	// Tag: The tag the score applies to.
	Tag string `json:"tag,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NormalizedScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NormalizedScore") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QaScorecardResultQaTagResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QaScorecardResultQaTagResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1QaScorecardResultQaTagResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1QaScorecardResultQaTagResult
	var s1 struct {
		NormalizedScore gensupport.JSONFloat64 `json:"normalizedScore"`
		PotentialScore  gensupport.JSONFloat64 `json:"potentialScore"`
		Score           gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.NormalizedScore = float64(s1.NormalizedScore)
	s.PotentialScore = float64(s1.PotentialScore)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudContactcenterinsightsV1QaScorecardResultScoreSource: A scorecard
// result may have multiple sets of scores from varying sources, one of which
// becomes the "main" answer above. A ScoreSource represents each individual
// set of scores.
type GoogleCloudContactcenterinsightsV1QaScorecardResultScoreSource struct {
	// NormalizedScore: The normalized score, which is the score divided by the
	// potential score.
	NormalizedScore float64 `json:"normalizedScore,omitempty"`
	// PotentialScore: The maximum potential overall score of the scorecard. Any
	// questions answered using `na_value` are excluded from this calculation.
	PotentialScore float64 `json:"potentialScore,omitempty"`
	// QaTagResults: Collection of tags and their scores.
	QaTagResults []*GoogleCloudContactcenterinsightsV1QaScorecardResultQaTagResult `json:"qaTagResults,omitempty"`
	// Score: The overall numerical score of the result.
	Score float64 `json:"score,omitempty"`
	// SourceType: What created the score.
	//
	// Possible values:
	//   "SOURCE_TYPE_UNSPECIFIED" - Source type is unspecified.
	//   "SYSTEM_GENERATED_ONLY" - Score is derived only from system-generated
	// answers.
	//   "INCLUDES_MANUAL_EDITS" - Score is derived from both system-generated
	// answers, and includes any manual edits if they exist.
	SourceType string `json:"sourceType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NormalizedScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NormalizedScore") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QaScorecardResultScoreSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QaScorecardResultScoreSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1QaScorecardResultScoreSource) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1QaScorecardResultScoreSource
	var s1 struct {
		NormalizedScore gensupport.JSONFloat64 `json:"normalizedScore"`
		PotentialScore  gensupport.JSONFloat64 `json:"potentialScore"`
		Score           gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.NormalizedScore = float64(s1.NormalizedScore)
	s.PotentialScore = float64(s1.PotentialScore)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudContactcenterinsightsV1QaScorecardRevision: A revision of a
// QaScorecard. Modifying published scorecard fields would invalidate existing
// scorecard results — the questions may have changed, or the score weighting
// will make existing scores impossible to understand. So changes must create a
// new revision, rather than modifying the existing resource.
type GoogleCloudContactcenterinsightsV1QaScorecardRevision struct {
	// AlternateIds: Output only. Alternative IDs for this revision of the
	// scorecard, e.g., `latest`.
	AlternateIds []string `json:"alternateIds,omitempty"`
	// CreateTime: Output only. The timestamp that the revision was created.
	CreateTime string `json:"createTime,omitempty"`
	// Name: Identifier. The name of the scorecard revision. Format:
	// projects/{project}/locations/{location}/qaScorecards/{qa_scorecard}/revisions
	// /{revision}
	Name string `json:"name,omitempty"`
	// Snapshot: The snapshot of the scorecard at the time of this revision's
	// creation.
	Snapshot *GoogleCloudContactcenterinsightsV1QaScorecard `json:"snapshot,omitempty"`
	// State: Output only. State of the scorecard revision, indicating whether it's
	// ready to be used in analysis.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified.
	//   "EDITABLE" - The scorecard revision can be edited.
	//   "TRAINING" - Scorecard model training is in progress.
	//   "TRAINING_FAILED" - Scorecard revision model training failed.
	//   "READY" - The revision can be used in analysis.
	//   "DELETING" - Scorecard is being deleted.
	//   "TRAINING_CANCELLED" - Scorecard model training was explicitly cancelled
	// by the user.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AlternateIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AlternateIds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QaScorecardRevision) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QaScorecardRevision
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QueryInterval: A time window for querying
// conversations.
type GoogleCloudContactcenterinsightsV1QueryInterval struct {
	// EndTime: Required. The end time of the time window.
	EndTime string `json:"endTime,omitempty"`
	// StartTime: Required. The start time of the time window.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QueryInterval) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QueryInterval
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QueryMetrics: Request data that use the
// existing QueryMetrics.
type GoogleCloudContactcenterinsightsV1QueryMetrics struct {
	Request googleapi.RawMessage `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Request") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Request") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QueryMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QueryMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QueryMetricsMetadata: The metadata from
// querying metrics.
type GoogleCloudContactcenterinsightsV1QueryMetricsMetadata struct {
	// ResultIsTruncated: Whether the result rows were truncated because the result
	// row size is too large to materialize.
	ResultIsTruncated bool `json:"resultIsTruncated,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ResultIsTruncated") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ResultIsTruncated") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QueryMetricsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QueryMetricsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QueryMetricsRequest: The request for
// querying metrics.
type GoogleCloudContactcenterinsightsV1QueryMetricsRequest struct {
	// Dimensions: The dimensions that determine the grouping key for the query.
	// Defaults to no dimension if this field is unspecified. If a dimension is
	// specified, its key must also be specified. Each dimension's key must be
	// unique. If a time granularity is also specified, metric values in the
	// dimension will be bucketed by this granularity. Up to one dimension is
	// supported for now.
	Dimensions []*GoogleCloudContactcenterinsightsV1Dimension `json:"dimensions,omitempty"`
	// Filter: Required. Filter to select a subset of conversations to compute the
	// metrics. Must specify a window of the conversation create time to compute
	// the metrics. The returned metrics will be from the range [DATE(starting
	// create time), DATE(ending create time)).
	Filter string `json:"filter,omitempty"`
	// MeasureMask: Measures to return. Defaults to all measures if this field is
	// unspecified. A valid mask should traverse from the `measure` field from the
	// response. For example, a path from a measure mask to get the conversation
	// count is "conversation_measure.count".
	MeasureMask string `json:"measureMask,omitempty"`
	// TimeGranularity: The time granularity of each data point in the time series.
	// Defaults to NONE if this field is unspecified.
	//
	// Possible values:
	//   "TIME_GRANULARITY_UNSPECIFIED" - The time granularity is unspecified and
	// will default to NONE.
	//   "NONE" - No time granularity. The response won't contain a time series.
	// This is the default value if no time granularity is specified.
	//   "DAILY" - Data points in the time series will aggregate at a daily
	// granularity. 1 day means [midnight to midnight).
	//   "HOURLY" - Data points in the time series will aggregate at a daily
	// granularity. 1 HOUR means [01:00 to 02:00).
	//   "PER_MINUTE" - Data points in the time series will aggregate at a daily
	// granularity. PER_MINUTE means [01:00 to 01:01).
	//   "PER_5_MINUTES" - Data points in the time series will aggregate at a 1
	// minute granularity. PER_5_MINUTES means [01:00 to 01:05).
	//   "MONTHLY" - Data points in the time series will aggregate at a monthly
	// granularity. 1 MONTH means [01st of the month to 1st of the next month).
	TimeGranularity string `json:"timeGranularity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dimensions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dimensions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QueryMetricsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QueryMetricsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QueryMetricsResponse: The response for
// querying metrics.
type GoogleCloudContactcenterinsightsV1QueryMetricsResponse struct {
	// Location: Required. The location of the data.
	// "projects/{project}/locations/{location}"
	Location string `json:"location,omitempty"`
	// MacroAverageSlice: The macro average slice contains aggregated averages
	// across all selected dimensions. i.e. if group_by agent and scorecard_id is
	// specified, this field will contain the average across all agents and all
	// scorecards. This field is only populated if the request specifies a
	// Dimension.
	MacroAverageSlice *GoogleCloudContactcenterinsightsV1QueryMetricsResponseSlice `json:"macroAverageSlice,omitempty"`
	// Slices: A slice contains a total and (if the request specified a time
	// granularity) a time series of metric values. Each slice contains a unique
	// combination of the cardinality of dimensions from the request.
	Slices []*GoogleCloudContactcenterinsightsV1QueryMetricsResponseSlice `json:"slices,omitempty"`
	// UpdateTime: The metrics last update time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Location") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Location") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QueryMetricsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QueryMetricsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QueryMetricsResponseSlice: A slice
// contains a total and (if the request specified a time granularity) a time
// series of metric values. Each slice contains a unique combination of the
// cardinality of dimensions from the request. For example, if the request
// specifies a single ISSUE dimension and it has a cardinality of 2 (i.e. the
// data used to compute the metrics has 2 issues in total), the response will
// have 2 slices: * Slice 1 -> dimensions=[Issue 1] * Slice 2 ->
// dimensions=[Issue 2]
type GoogleCloudContactcenterinsightsV1QueryMetricsResponseSlice struct {
	// Dimensions: A unique combination of dimensions that this slice represents.
	Dimensions []*GoogleCloudContactcenterinsightsV1Dimension `json:"dimensions,omitempty"`
	// TimeSeries: A time series of metric values. This is only populated if the
	// request specifies a time granularity other than NONE.
	TimeSeries *GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceTimeSeries `json:"timeSeries,omitempty"`
	// Total: The total metric value. The interval of this data point is [starting
	// create time, ending create time) from the request.
	Total *GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPoint `json:"total,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dimensions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dimensions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QueryMetricsResponseSlice) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QueryMetricsResponseSlice
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPoint: A data
// point contains the metric values mapped to an interval.
type GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPoint struct {
	// ConversationMeasure: The measure related to conversations.
	ConversationMeasure *GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversationMeasure `json:"conversationMeasure,omitempty"`
	// DialogflowInteractionMeasure: The measure related to dialogflow
	// interactions.
	DialogflowInteractionMeasure *GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointDialogflowInteractionMeasure `json:"dialogflowInteractionMeasure,omitempty"`
	// Interval: The interval that this data point represents. * If this is the
	// total data point, the interval is [starting create time, ending create time)
	// from the request. * If this a data point from the time series, the interval
	// is [time, time + time granularity from the request).
	Interval *GoogleTypeInterval `json:"interval,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationMeasure") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationMeasure") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPoint) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPoint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversat
// ionMeasure: The measure related to conversations.
type GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversationMeasure struct {
	// AaSupervisorAssignedConversationsCount: The number of conversations that
	// were assigned to an AA human supervisor.
	AaSupervisorAssignedConversationsCount int64 `json:"aaSupervisorAssignedConversationsCount,omitempty"`
	// AaSupervisorDroppedConversationsCount: The number of conversations that were
	// dropped, i.e. escalated but not assigned to an AA human supervisor.
	AaSupervisorDroppedConversationsCount int64 `json:"aaSupervisorDroppedConversationsCount,omitempty"`
	// AaSupervisorEscalatedConversationsCount: The number of conversations that
	// were escalated to an AA human supervisor for intervention.
	AaSupervisorEscalatedConversationsCount int64 `json:"aaSupervisorEscalatedConversationsCount,omitempty"`
	// AaSupervisorMonitoredConversationsCount: The number of conversations scanned
	// by the AA human supervisor.
	AaSupervisorMonitoredConversationsCount int64 `json:"aaSupervisorMonitoredConversationsCount,omitempty"`
	// AaSupervisorTransferredToHumanAgentConvCount: The number of conversations
	// transferred to a human agent.
	AaSupervisorTransferredToHumanAgentConvCount int64 `json:"aaSupervisorTransferredToHumanAgentConvCount,omitempty"`
	// AiCoachSuggestionAgentMessageTriggerCount: Count of agent messages that
	// triggered an Ai Coach Suggestion.
	AiCoachSuggestionAgentMessageTriggerCount int64 `json:"aiCoachSuggestionAgentMessageTriggerCount,omitempty"`
	// AiCoachSuggestionAgentUsageCount: Count of Ai Coach Suggestion that has been
	// used by agents.
	AiCoachSuggestionAgentUsageCount int64 `json:"aiCoachSuggestionAgentUsageCount,omitempty"`
	// AiCoachSuggestionAgentUsageRatio: Proportion of Ai Coach Suggestion that has
	// been used by agents.
	AiCoachSuggestionAgentUsageRatio float64 `json:"aiCoachSuggestionAgentUsageRatio,omitempty"`
	// AiCoachSuggestionCustomerMessageTriggerCount: Count of customer messages
	// that triggered an Ai Coach Suggestion.
	AiCoachSuggestionCustomerMessageTriggerCount int64 `json:"aiCoachSuggestionCustomerMessageTriggerCount,omitempty"`
	// AiCoachSuggestionCustomerMessageTriggerRatio: Proportion of customer
	// messages that triggered an Ai Coach Suggestion.
	AiCoachSuggestionCustomerMessageTriggerRatio float64 `json:"aiCoachSuggestionCustomerMessageTriggerRatio,omitempty"`
	// AiCoachSuggestionMessageTriggerCount: Count of end_of_utterance trigger
	// event messages that triggered an Ai Coach Suggestion.
	AiCoachSuggestionMessageTriggerCount int64 `json:"aiCoachSuggestionMessageTriggerCount,omitempty"`
	// AiCoachSuggestionMessageTriggerRatio: Proportion of end_of_utterance trigger
	// event messages that triggered an Ai Coach Suggestion.
	AiCoachSuggestionMessageTriggerRatio float64 `json:"aiCoachSuggestionMessageTriggerRatio,omitempty"`
	// AverageAgentSentimentScore: The average agent's sentiment score.
	AverageAgentSentimentScore float64 `json:"averageAgentSentimentScore,omitempty"`
	// AverageClientSentimentScore: The average client's sentiment score.
	AverageClientSentimentScore float64 `json:"averageClientSentimentScore,omitempty"`
	// AverageCustomerSatisfactionRating: The average customer satisfaction rating.
	AverageCustomerSatisfactionRating float64 `json:"averageCustomerSatisfactionRating,omitempty"`
	// AverageDuration: The average duration.
	AverageDuration string `json:"averageDuration,omitempty"`
	// AverageQaNormalizedScore: The average normalized QA score for a scorecard.
	// When computing the average across a set of conversations, if a conversation
	// has been evaluated with multiple revisions of a scorecard, only the latest
	// revision results will be used. Will exclude 0's in average calculation. Will
	// be only populated if the request specifies a dimension of QA_SCORECARD_ID.
	AverageQaNormalizedScore float64 `json:"averageQaNormalizedScore,omitempty"`
	// AverageQaQuestionNormalizedScore: Average QA normalized score averaged for
	// questions averaged across all revisions of the parent scorecard. Will be
	// only populated if the request specifies a dimension of QA_QUESTION_ID.
	AverageQaQuestionNormalizedScore float64 `json:"averageQaQuestionNormalizedScore,omitempty"`
	// AverageSilencePercentage: The average silence percentage.
	AverageSilencePercentage float64 `json:"averageSilencePercentage,omitempty"`
	// AverageSummarizationSuggestionEditDistance: Average edit distance of the
	// summarization suggestions. Edit distance (also called as levenshtein
	// distance) is calculated by summing up number of insertions, deletions and
	// substitutions required to transform the summization feedback to the original
	// summary suggestion.
	AverageSummarizationSuggestionEditDistance float64 `json:"averageSummarizationSuggestionEditDistance,omitempty"`
	// AverageSummarizationSuggestionNormalizedEditDistance: Normalized Average
	// edit distance of the summarization suggestions. Edit distance (also called
	// as levenshtein distance) is calculated by summing up number of insertions,
	// deletions and substitutions required to transform the summization feedback
	// to the original summary suggestion. Normalized edit distance is the average
	// of (edit distance / summary length).
	AverageSummarizationSuggestionNormalizedEditDistance float64 `json:"averageSummarizationSuggestionNormalizedEditDistance,omitempty"`
	// AverageTurnCount: The average turn count.
	AverageTurnCount float64 `json:"averageTurnCount,omitempty"`
	// AvgConversationClientTurnSentimentEma: The exponential moving average of the
	// sentiment score of client turns in the conversation.
	AvgConversationClientTurnSentimentEma float64 `json:"avgConversationClientTurnSentimentEma,omitempty"`
	// ContainedConversationCount: The number of conversations that were contained.
	ContainedConversationCount int64 `json:"containedConversationCount,omitempty"`
	// ContainedConversationRatio: The percentage of conversations that were
	// contained.
	ContainedConversationRatio float64 `json:"containedConversationRatio,omitempty"`
	// ConversationAiCoachSuggestionCount: Count of conversations that has Ai Coach
	// Suggestions.
	ConversationAiCoachSuggestionCount int64 `json:"conversationAiCoachSuggestionCount,omitempty"`
	// ConversationAiCoachSuggestionRatio: Proportion of conversations that has Ai
	// Coach Suggestions.
	ConversationAiCoachSuggestionRatio float64 `json:"conversationAiCoachSuggestionRatio,omitempty"`
	// ConversationCount: The conversation count.
	ConversationCount int64 `json:"conversationCount,omitempty"`
	// ConversationSuggestedSummaryRatio: Proportion of conversations that had a
	// suggested summary.
	ConversationSuggestedSummaryRatio float64 `json:"conversationSuggestedSummaryRatio,omitempty"`
	// ConversationTotalAgentMessageCount: The agent message count.
	ConversationTotalAgentMessageCount int64 `json:"conversationTotalAgentMessageCount,omitempty"`
	// ConversationTotalCustomerMessageCount: The customer message count.
	ConversationTotalCustomerMessageCount int64 `json:"conversationTotalCustomerMessageCount,omitempty"`
	// ConversationalAgentsAverageAudioInAudioOutLatency: The average latency of
	// conversational agents' audio in audio out latency per interaction. This is
	// computed as the average of the all the interactions' audio in audio out
	// latencies in a conversation and averaged across conversations.
	ConversationalAgentsAverageAudioInAudioOutLatency float64 `json:"conversationalAgentsAverageAudioInAudioOutLatency,omitempty"`
	// ConversationalAgentsAverageEndToEndLatency: The average latency of
	// conversational agents' latency per interaction. This is computed as the
	// average of the all the iteractions' end to end latencies in a conversation
	// and averaged across conversations. The e2e latency is the time between the
	// end of the user utterance and the start of the agent utterance on the
	// interaction level.
	ConversationalAgentsAverageEndToEndLatency float64 `json:"conversationalAgentsAverageEndToEndLatency,omitempty"`
	// ConversationalAgentsAverageLlmCallLatency: The average latency of
	// conversational agents' LLM call latency per interaction. This is computed as
	// the average of the all the interactions LLM call latencies in a conversation
	// and averaged across conversations.
	ConversationalAgentsAverageLlmCallLatency float64 `json:"conversationalAgentsAverageLlmCallLatency,omitempty"`
	// ConversationalAgentsAverageTtsLatency: The macro average latency of
	// conversational agents' TTS latency per interaction. This is computed as the
	// average of the all the interactions' TTS latencies in a conversation and
	// averaged across conversations.
	ConversationalAgentsAverageTtsLatency float64 `json:"conversationalAgentsAverageTtsLatency,omitempty"`
	// DialogflowAverageWebhookLatency: Average latency of dialogflow webhook
	// calls.
	DialogflowAverageWebhookLatency float64 `json:"dialogflowAverageWebhookLatency,omitempty"`
	// DialogflowConversationsEscalationCount: count of conversations that was
	// handed off from virtual agent to human agent.
	DialogflowConversationsEscalationCount float64 `json:"dialogflowConversationsEscalationCount,omitempty"`
	// DialogflowConversationsEscalationRatio: Proportion of conversations that was
	// handed off from virtual agent to human agent.
	DialogflowConversationsEscalationRatio float64 `json:"dialogflowConversationsEscalationRatio,omitempty"`
	// DialogflowInteractionsNoInputRatio: Proportion of dialogflow interactions
	// that has empty input.
	DialogflowInteractionsNoInputRatio float64 `json:"dialogflowInteractionsNoInputRatio,omitempty"`
	// DialogflowInteractionsNoMatchRatio: Proportion of dialogflow interactions
	// that has no intent match for the input.
	DialogflowInteractionsNoMatchRatio float64 `json:"dialogflowInteractionsNoMatchRatio,omitempty"`
	// DialogflowWebhookFailureRatio: Proportion of dialogflow webhook calls that
	// failed.
	DialogflowWebhookFailureRatio float64 `json:"dialogflowWebhookFailureRatio,omitempty"`
	// DialogflowWebhookTimeoutRatio: Proportion of dialogflow webhook calls that
	// timed out.
	DialogflowWebhookTimeoutRatio float64 `json:"dialogflowWebhookTimeoutRatio,omitempty"`
	// KnowledgeAssistNegativeFeedbackRatio: Proportion of knowledge assist
	// (Proactive Generative Knowledge Assist) queries that had negative feedback.
	KnowledgeAssistNegativeFeedbackRatio float64 `json:"knowledgeAssistNegativeFeedbackRatio,omitempty"`
	// KnowledgeAssistPositiveFeedbackRatio: Proportion of knowledge assist
	// (Proactive Generative Knowledge Assist) queries that had positive feedback.
	KnowledgeAssistPositiveFeedbackRatio float64 `json:"knowledgeAssistPositiveFeedbackRatio,omitempty"`
	// KnowledgeAssistResultCount: Count of knowledge assist results (Proactive
	// Generative Knowledge Assist) shown to the user.
	KnowledgeAssistResultCount int64 `json:"knowledgeAssistResultCount,omitempty"`
	// KnowledgeAssistUriClickRatio: Proportion of knowledge assist (Proactive
	// Generative Knowledge Assist) queries that had a URL clicked.
	KnowledgeAssistUriClickRatio float64 `json:"knowledgeAssistUriClickRatio,omitempty"`
	// KnowledgeSearchAgentQuerySourceRatio: Proportion of knowledge search
	// (Generative Knowledge Assist) queries made by the agent compared to the
	// total number of knowledge search queries made.
	KnowledgeSearchAgentQuerySourceRatio float64 `json:"knowledgeSearchAgentQuerySourceRatio,omitempty"`
	// KnowledgeSearchNegativeFeedbackRatio: Proportion of knowledge search
	// (Generative Knowledge Assist) queries that had negative feedback.
	KnowledgeSearchNegativeFeedbackRatio float64 `json:"knowledgeSearchNegativeFeedbackRatio,omitempty"`
	// KnowledgeSearchPositiveFeedbackRatio: Proportion of knowledge search
	// (Generative Knowledge Assist) queries that had positive feedback.
	KnowledgeSearchPositiveFeedbackRatio float64 `json:"knowledgeSearchPositiveFeedbackRatio,omitempty"`
	// KnowledgeSearchResultCount: Count of knowledge search results (Generative
	// Knowledge Assist) shown to the user.
	KnowledgeSearchResultCount int64 `json:"knowledgeSearchResultCount,omitempty"`
	// KnowledgeSearchSuggestedQuerySourceRatio: Proportion of knowledge search
	// (Generative Knowledge Assist) queries suggested compared to the total number
	// of knowledge search queries made.
	KnowledgeSearchSuggestedQuerySourceRatio float64 `json:"knowledgeSearchSuggestedQuerySourceRatio,omitempty"`
	// KnowledgeSearchUriClickRatio: Proportion of knowledge search (Generative
	// Knowledge Assist) queries that had a URL clicked.
	KnowledgeSearchUriClickRatio float64 `json:"knowledgeSearchUriClickRatio,omitempty"`
	// QaTagScores: Average QA normalized score for all the tags.
	QaTagScores []*GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversationMeasureQaTagScore `json:"qaTagScores,omitempty"`
	// SummarizationSuggestionEditRatio: Proportion of summarization suggestions
	// that were manually edited.
	SummarizationSuggestionEditRatio float64 `json:"summarizationSuggestionEditRatio,omitempty"`
	// SummarizationSuggestionResultCount: Count of summarization suggestions
	// results.
	SummarizationSuggestionResultCount int64 `json:"summarizationSuggestionResultCount,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "AaSupervisorAssignedConversationsCount") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "AaSupervisorAssignedConversationsCount") to include in API requests with
	// the JSON null value. By default, fields with empty values are omitted from
	// API requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields
	// for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversationMeasure) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversationMeasure
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversationMeasure) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversationMeasure
	var s1 struct {
		AiCoachSuggestionAgentUsageRatio                     gensupport.JSONFloat64 `json:"aiCoachSuggestionAgentUsageRatio"`
		AiCoachSuggestionCustomerMessageTriggerRatio         gensupport.JSONFloat64 `json:"aiCoachSuggestionCustomerMessageTriggerRatio"`
		AiCoachSuggestionMessageTriggerRatio                 gensupport.JSONFloat64 `json:"aiCoachSuggestionMessageTriggerRatio"`
		AverageAgentSentimentScore                           gensupport.JSONFloat64 `json:"averageAgentSentimentScore"`
		AverageClientSentimentScore                          gensupport.JSONFloat64 `json:"averageClientSentimentScore"`
		AverageCustomerSatisfactionRating                    gensupport.JSONFloat64 `json:"averageCustomerSatisfactionRating"`
		AverageQaNormalizedScore                             gensupport.JSONFloat64 `json:"averageQaNormalizedScore"`
		AverageQaQuestionNormalizedScore                     gensupport.JSONFloat64 `json:"averageQaQuestionNormalizedScore"`
		AverageSilencePercentage                             gensupport.JSONFloat64 `json:"averageSilencePercentage"`
		AverageSummarizationSuggestionEditDistance           gensupport.JSONFloat64 `json:"averageSummarizationSuggestionEditDistance"`
		AverageSummarizationSuggestionNormalizedEditDistance gensupport.JSONFloat64 `json:"averageSummarizationSuggestionNormalizedEditDistance"`
		AverageTurnCount                                     gensupport.JSONFloat64 `json:"averageTurnCount"`
		AvgConversationClientTurnSentimentEma                gensupport.JSONFloat64 `json:"avgConversationClientTurnSentimentEma"`
		ContainedConversationRatio                           gensupport.JSONFloat64 `json:"containedConversationRatio"`
		ConversationAiCoachSuggestionRatio                   gensupport.JSONFloat64 `json:"conversationAiCoachSuggestionRatio"`
		ConversationSuggestedSummaryRatio                    gensupport.JSONFloat64 `json:"conversationSuggestedSummaryRatio"`
		ConversationalAgentsAverageAudioInAudioOutLatency    gensupport.JSONFloat64 `json:"conversationalAgentsAverageAudioInAudioOutLatency"`
		ConversationalAgentsAverageEndToEndLatency           gensupport.JSONFloat64 `json:"conversationalAgentsAverageEndToEndLatency"`
		ConversationalAgentsAverageLlmCallLatency            gensupport.JSONFloat64 `json:"conversationalAgentsAverageLlmCallLatency"`
		ConversationalAgentsAverageTtsLatency                gensupport.JSONFloat64 `json:"conversationalAgentsAverageTtsLatency"`
		DialogflowAverageWebhookLatency                      gensupport.JSONFloat64 `json:"dialogflowAverageWebhookLatency"`
		DialogflowConversationsEscalationCount               gensupport.JSONFloat64 `json:"dialogflowConversationsEscalationCount"`
		DialogflowConversationsEscalationRatio               gensupport.JSONFloat64 `json:"dialogflowConversationsEscalationRatio"`
		DialogflowInteractionsNoInputRatio                   gensupport.JSONFloat64 `json:"dialogflowInteractionsNoInputRatio"`
		DialogflowInteractionsNoMatchRatio                   gensupport.JSONFloat64 `json:"dialogflowInteractionsNoMatchRatio"`
		DialogflowWebhookFailureRatio                        gensupport.JSONFloat64 `json:"dialogflowWebhookFailureRatio"`
		DialogflowWebhookTimeoutRatio                        gensupport.JSONFloat64 `json:"dialogflowWebhookTimeoutRatio"`
		KnowledgeAssistNegativeFeedbackRatio                 gensupport.JSONFloat64 `json:"knowledgeAssistNegativeFeedbackRatio"`
		KnowledgeAssistPositiveFeedbackRatio                 gensupport.JSONFloat64 `json:"knowledgeAssistPositiveFeedbackRatio"`
		KnowledgeAssistUriClickRatio                         gensupport.JSONFloat64 `json:"knowledgeAssistUriClickRatio"`
		KnowledgeSearchAgentQuerySourceRatio                 gensupport.JSONFloat64 `json:"knowledgeSearchAgentQuerySourceRatio"`
		KnowledgeSearchNegativeFeedbackRatio                 gensupport.JSONFloat64 `json:"knowledgeSearchNegativeFeedbackRatio"`
		KnowledgeSearchPositiveFeedbackRatio                 gensupport.JSONFloat64 `json:"knowledgeSearchPositiveFeedbackRatio"`
		KnowledgeSearchSuggestedQuerySourceRatio             gensupport.JSONFloat64 `json:"knowledgeSearchSuggestedQuerySourceRatio"`
		KnowledgeSearchUriClickRatio                         gensupport.JSONFloat64 `json:"knowledgeSearchUriClickRatio"`
		SummarizationSuggestionEditRatio                     gensupport.JSONFloat64 `json:"summarizationSuggestionEditRatio"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AiCoachSuggestionAgentUsageRatio = float64(s1.AiCoachSuggestionAgentUsageRatio)
	s.AiCoachSuggestionCustomerMessageTriggerRatio = float64(s1.AiCoachSuggestionCustomerMessageTriggerRatio)
	s.AiCoachSuggestionMessageTriggerRatio = float64(s1.AiCoachSuggestionMessageTriggerRatio)
	s.AverageAgentSentimentScore = float64(s1.AverageAgentSentimentScore)
	s.AverageClientSentimentScore = float64(s1.AverageClientSentimentScore)
	s.AverageCustomerSatisfactionRating = float64(s1.AverageCustomerSatisfactionRating)
	s.AverageQaNormalizedScore = float64(s1.AverageQaNormalizedScore)
	s.AverageQaQuestionNormalizedScore = float64(s1.AverageQaQuestionNormalizedScore)
	s.AverageSilencePercentage = float64(s1.AverageSilencePercentage)
	s.AverageSummarizationSuggestionEditDistance = float64(s1.AverageSummarizationSuggestionEditDistance)
	s.AverageSummarizationSuggestionNormalizedEditDistance = float64(s1.AverageSummarizationSuggestionNormalizedEditDistance)
	s.AverageTurnCount = float64(s1.AverageTurnCount)
	s.AvgConversationClientTurnSentimentEma = float64(s1.AvgConversationClientTurnSentimentEma)
	s.ContainedConversationRatio = float64(s1.ContainedConversationRatio)
	s.ConversationAiCoachSuggestionRatio = float64(s1.ConversationAiCoachSuggestionRatio)
	s.ConversationSuggestedSummaryRatio = float64(s1.ConversationSuggestedSummaryRatio)
	s.ConversationalAgentsAverageAudioInAudioOutLatency = float64(s1.ConversationalAgentsAverageAudioInAudioOutLatency)
	s.ConversationalAgentsAverageEndToEndLatency = float64(s1.ConversationalAgentsAverageEndToEndLatency)
	s.ConversationalAgentsAverageLlmCallLatency = float64(s1.ConversationalAgentsAverageLlmCallLatency)
	s.ConversationalAgentsAverageTtsLatency = float64(s1.ConversationalAgentsAverageTtsLatency)
	s.DialogflowAverageWebhookLatency = float64(s1.DialogflowAverageWebhookLatency)
	s.DialogflowConversationsEscalationCount = float64(s1.DialogflowConversationsEscalationCount)
	s.DialogflowConversationsEscalationRatio = float64(s1.DialogflowConversationsEscalationRatio)
	s.DialogflowInteractionsNoInputRatio = float64(s1.DialogflowInteractionsNoInputRatio)
	s.DialogflowInteractionsNoMatchRatio = float64(s1.DialogflowInteractionsNoMatchRatio)
	s.DialogflowWebhookFailureRatio = float64(s1.DialogflowWebhookFailureRatio)
	s.DialogflowWebhookTimeoutRatio = float64(s1.DialogflowWebhookTimeoutRatio)
	s.KnowledgeAssistNegativeFeedbackRatio = float64(s1.KnowledgeAssistNegativeFeedbackRatio)
	s.KnowledgeAssistPositiveFeedbackRatio = float64(s1.KnowledgeAssistPositiveFeedbackRatio)
	s.KnowledgeAssistUriClickRatio = float64(s1.KnowledgeAssistUriClickRatio)
	s.KnowledgeSearchAgentQuerySourceRatio = float64(s1.KnowledgeSearchAgentQuerySourceRatio)
	s.KnowledgeSearchNegativeFeedbackRatio = float64(s1.KnowledgeSearchNegativeFeedbackRatio)
	s.KnowledgeSearchPositiveFeedbackRatio = float64(s1.KnowledgeSearchPositiveFeedbackRatio)
	s.KnowledgeSearchSuggestedQuerySourceRatio = float64(s1.KnowledgeSearchSuggestedQuerySourceRatio)
	s.KnowledgeSearchUriClickRatio = float64(s1.KnowledgeSearchUriClickRatio)
	s.SummarizationSuggestionEditRatio = float64(s1.SummarizationSuggestionEditRatio)
	return nil
}

// GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversat
// ionMeasureQaTagScore: Average QA normalized score for the tag.
type GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversationMeasureQaTagScore struct {
	// AverageTagNormalizedScore: Average tag normalized score per tag.
	AverageTagNormalizedScore float64 `json:"averageTagNormalizedScore,omitempty"`
	// Tag: Tag name.
	Tag string `json:"tag,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AverageTagNormalizedScore")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AverageTagNormalizedScore") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversationMeasureQaTagScore) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversationMeasureQaTagScore
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversationMeasureQaTagScore) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversationMeasureQaTagScore
	var s1 struct {
		AverageTagNormalizedScore gensupport.JSONFloat64 `json:"averageTagNormalizedScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AverageTagNormalizedScore = float64(s1.AverageTagNormalizedScore)
	return nil
}

// GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointDialogflo
// wInteractionMeasure: The measure related to dialogflow interactions.
type GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointDialogflowInteractionMeasure struct {
	// PercentileAudioInAudioOutLatency: The percentile result for audio in audio
	// out latency in milliseconds per dialogflow interaction level.
	PercentileAudioInAudioOutLatency *GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointPercentileResult `json:"percentileAudioInAudioOutLatency,omitempty"`
	// PercentileEndToEndLatency: The percentile result for end to end chat latency
	// in milliseconds per dialogflow interaction level.
	PercentileEndToEndLatency *GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointPercentileResult `json:"percentileEndToEndLatency,omitempty"`
	// PercentileLlmCallLatency: The percentile result for LLM latency in
	// milliseconds per dialogflow interaction level.
	PercentileLlmCallLatency *GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointPercentileResult `json:"percentileLlmCallLatency,omitempty"`
	// PercentileToolUseLatency: The percentile result for tool use latency in
	// milliseconds per dialogflow interaction level.
	PercentileToolUseLatency *GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointPercentileResult `json:"percentileToolUseLatency,omitempty"`
	// PercentileTtsLatency: The percentile result for TTS latency in milliseconds
	// per dialogflow interaction level.
	PercentileTtsLatency *GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointPercentileResult `json:"percentileTtsLatency,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "PercentileAudioInAudioOutLatency") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "PercentileAudioInAudioOutLatency") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields for
	// more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointDialogflowInteractionMeasure) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointDialogflowInteractionMeasure
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointPercentil
// eResult: The percentile result. Currently supported percentiles are 50th,
// 90th, and 99th.
type GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointPercentileResult struct {
	// P50: The 50th percentile value.
	P50 float64 `json:"p50,omitempty"`
	// P90: The 90th percentile value.
	P90 float64 `json:"p90,omitempty"`
	// P99: The 99th percentile value.
	P99 float64 `json:"p99,omitempty"`
	// ForceSendFields is a list of field names (e.g. "P50") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "P50") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointPercentileResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointPercentileResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointPercentileResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointPercentileResult
	var s1 struct {
		P50 gensupport.JSONFloat64 `json:"p50"`
		P90 gensupport.JSONFloat64 `json:"p90"`
		P99 gensupport.JSONFloat64 `json:"p99"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.P50 = float64(s1.P50)
	s.P90 = float64(s1.P90)
	s.P99 = float64(s1.P99)
	return nil
}

// GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceTimeSeries: A
// time series of metric values.
type GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceTimeSeries struct {
	// DataPoints: The data points that make up the time series .
	DataPoints []*GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPoint `json:"dataPoints,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataPoints") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataPoints") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceTimeSeries) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceTimeSeries
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QueryPerformanceOverviewMetadata: The
// metadata for querying performance overview.
type GoogleCloudContactcenterinsightsV1QueryPerformanceOverviewMetadata struct {
}

// GoogleCloudContactcenterinsightsV1QueryPerformanceOverviewRequest: The
// request for summarizing performance according to different metrics for
// conversations over a specified time window.
type GoogleCloudContactcenterinsightsV1QueryPerformanceOverviewRequest struct {
	// AgentPerformanceSource: Conversations are from a single agent.
	AgentPerformanceSource *GoogleCloudContactcenterinsightsV1QueryPerformanceOverviewRequestAgentSource `json:"agentPerformanceSource,omitempty"`
	// ComparisonQueryInterval: The time window of the conversations to compare the
	// performance to.
	ComparisonQueryInterval *GoogleCloudContactcenterinsightsV1QueryInterval `json:"comparisonQueryInterval,omitempty"`
	// Filter: Optional. Filter to select a subset of conversations to compute the
	// performance overview. Supports the same filters as the filter field in
	// QueryMetricsRequest. The source and query interval/comparison query interval
	// should not be included here.
	Filter string `json:"filter,omitempty"`
	// QueryInterval: Required. The time window of the conversations to derive
	// performance stats from.
	QueryInterval *GoogleCloudContactcenterinsightsV1QueryInterval `json:"queryInterval,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentPerformanceSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentPerformanceSource") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QueryPerformanceOverviewRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QueryPerformanceOverviewRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QueryPerformanceOverviewRequestAgentSource:
//
//	The entity whose performance is being queried is a single agent.
type GoogleCloudContactcenterinsightsV1QueryPerformanceOverviewRequestAgentSource struct {
	// AgentId: Required. Agent id to query performance overview for.
	AgentId string `json:"agentId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QueryPerformanceOverviewRequestAgentSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QueryPerformanceOverviewRequestAgentSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QueryPerformanceOverviewResponse: The
// response for querying performance overview.
type GoogleCloudContactcenterinsightsV1QueryPerformanceOverviewResponse struct {
	// SummaryText: The summary text of the performance.
	SummaryText string `json:"summaryText,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SummaryText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SummaryText") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QueryPerformanceOverviewResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QueryPerformanceOverviewResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1RedactionConfig: DLP resources used for
// redaction while ingesting conversations. DLP settings are applied to
// conversations ingested from the `UploadConversation` and
// `IngestConversations` endpoints, including conversation coming from CCAI
// Platform. They are not applied to conversations ingested from the
// `CreateConversation` endpoint or the Dialogflow / Agent Assist runtime
// integrations. When using Dialogflow / Agent Assist runtime integrations,
// redaction should be performed in Dialogflow / Agent Assist.
type GoogleCloudContactcenterinsightsV1RedactionConfig struct {
	// DeidentifyTemplate: The fully-qualified DLP deidentify template resource
	// name. Format: `projects/{project}/deidentifyTemplates/{template}`
	DeidentifyTemplate string `json:"deidentifyTemplate,omitempty"`
	// InspectTemplate: The fully-qualified DLP inspect template resource name.
	// Format:
	// `projects/{project}/locations/{location}/inspectTemplates/{template}`
	InspectTemplate string `json:"inspectTemplate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeidentifyTemplate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeidentifyTemplate") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1RedactionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1RedactionConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1RegexMatchConfig: Regex match
// configuration.
type GoogleCloudContactcenterinsightsV1RegexMatchConfig struct {
}

// GoogleCloudContactcenterinsightsV1RuntimeAnnotation: An annotation that was
// generated during the customer and agent interaction.
type GoogleCloudContactcenterinsightsV1RuntimeAnnotation struct {
	// AnnotationId: The unique identifier of the annotation. Format:
	// projects/{project}/locations/{location}/conversationDatasets/{dataset}/conver
	// sationDataItems/{data_item}/conversationAnnotations/{annotation}
	AnnotationId string `json:"annotationId,omitempty"`
	// AnswerFeedback: The feedback that the customer has about the answer in
	// `data`.
	AnswerFeedback *GoogleCloudContactcenterinsightsV1AnswerFeedback `json:"answerFeedback,omitempty"`
	// ArticleSuggestion: Agent Assist Article Suggestion data.
	ArticleSuggestion *GoogleCloudContactcenterinsightsV1ArticleSuggestionData `json:"articleSuggestion,omitempty"`
	// ConversationSummarizationSuggestion: Conversation summarization suggestion
	// data.
	ConversationSummarizationSuggestion *GoogleCloudContactcenterinsightsV1ConversationSummarizationSuggestionData `json:"conversationSummarizationSuggestion,omitempty"`
	// CreateTime: The time at which this annotation was created.
	CreateTime string `json:"createTime,omitempty"`
	// DialogflowInteraction: Dialogflow interaction data.
	DialogflowInteraction *GoogleCloudContactcenterinsightsV1DialogflowInteractionData `json:"dialogflowInteraction,omitempty"`
	// EndBoundary: The boundary in the conversation where the annotation ends,
	// inclusive.
	EndBoundary *GoogleCloudContactcenterinsightsV1AnnotationBoundary `json:"endBoundary,omitempty"`
	// FaqAnswer: Agent Assist FAQ answer data.
	FaqAnswer *GoogleCloudContactcenterinsightsV1FaqAnswerData `json:"faqAnswer,omitempty"`
	// SmartComposeSuggestion: Agent Assist Smart Compose suggestion data.
	SmartComposeSuggestion *GoogleCloudContactcenterinsightsV1SmartComposeSuggestionData `json:"smartComposeSuggestion,omitempty"`
	// SmartReply: Agent Assist Smart Reply data.
	SmartReply *GoogleCloudContactcenterinsightsV1SmartReplyData `json:"smartReply,omitempty"`
	// StartBoundary: The boundary in the conversation where the annotation starts,
	// inclusive.
	StartBoundary *GoogleCloudContactcenterinsightsV1AnnotationBoundary `json:"startBoundary,omitempty"`
	// UserInput: Explicit input used for generating the answer
	UserInput *GoogleCloudContactcenterinsightsV1RuntimeAnnotationUserInput `json:"userInput,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1RuntimeAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1RuntimeAnnotation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1RuntimeAnnotationUserInput: Explicit input
// used for generating the answer
type GoogleCloudContactcenterinsightsV1RuntimeAnnotationUserInput struct {
	// GeneratorName: The resource name of associated generator. Format:
	// `projects//locations//generators/`
	GeneratorName string `json:"generatorName,omitempty"`
	// Query: Query text. Article Search uses this to store the input query used to
	// generate the search results.
	Query string `json:"query,omitempty"`
	// QuerySource: Query source for the answer.
	//
	// Possible values:
	//   "QUERY_SOURCE_UNSPECIFIED" - Unknown query source.
	//   "AGENT_QUERY" - The query is from agents.
	//   "SUGGESTED_QUERY" - The query is a query from previous suggestions, e.g.
	// from a preceding SuggestKnowledgeAssist response.
	QuerySource string `json:"querySource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GeneratorName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GeneratorName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1RuntimeAnnotationUserInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1RuntimeAnnotationUserInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1SampleConversationsMetadata: The metadata
// for an SampleConversations operation.
type GoogleCloudContactcenterinsightsV1SampleConversationsMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// PartialErrors: Output only. Partial errors during sample conversations
	// operation that might cause the operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: Output only. The original request for sample conversations to
	// dataset.
	Request *GoogleCloudContactcenterinsightsV1SampleConversationsRequest `json:"request,omitempty"`
	// SampleConversationsStats: Output only. Statistics for SampleConversations
	// operation.
	SampleConversationsStats *GoogleCloudContactcenterinsightsV1SampleConversationsMetadataSampleConversationsStats `json:"sampleConversationsStats,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1SampleConversationsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1SampleConversationsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1SampleConversationsMetadataSampleConversati
// onsStats: Statistics for SampleConversations operation.
type GoogleCloudContactcenterinsightsV1SampleConversationsMetadataSampleConversationsStats struct {
	// FailedSampleCount: Output only. The number of objects which were unable to
	// be sampled due to errors. The errors are populated in the partial_errors
	// field.
	FailedSampleCount int64 `json:"failedSampleCount,omitempty"`
	// SuccessfulSampleCount: Output only. The number of new conversations added
	// during this sample operation.
	SuccessfulSampleCount int64 `json:"successfulSampleCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FailedSampleCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FailedSampleCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1SampleConversationsMetadataSampleConversationsStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1SampleConversationsMetadataSampleConversationsStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1SampleConversationsRequest: The request to
// sample conversations to a dataset.
type GoogleCloudContactcenterinsightsV1SampleConversationsRequest struct {
	// DestinationDataset: The dataset resource to copy the sampled conversations
	// to.
	DestinationDataset *GoogleCloudContactcenterinsightsV1Dataset `json:"destinationDataset,omitempty"`
	// Parent: Required. The parent resource of the dataset.
	Parent string `json:"parent,omitempty"`
	// SampleRule: Optional. The sample rule used for sampling conversations.
	SampleRule *GoogleCloudContactcenterinsightsV1SampleRule `json:"sampleRule,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DestinationDataset") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DestinationDataset") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1SampleConversationsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1SampleConversationsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1SampleConversationsResponse: The response
// to an SampleConversations operation.
type GoogleCloudContactcenterinsightsV1SampleConversationsResponse struct {
}

// GoogleCloudContactcenterinsightsV1SampleRule: Message for sampling
// conversations.
type GoogleCloudContactcenterinsightsV1SampleRule struct {
	// ConversationFilter: To specify the filter for the conversions that should
	// apply this sample rule. An empty filter means this sample rule applies to
	// all conversations.
	ConversationFilter string `json:"conversationFilter,omitempty"`
	// Dimension: Optional. Group by dimension to sample the conversation. If no
	// dimension is provided, the sampling will be applied to the project level.
	// Current supported dimensions is 'quality_metadata.agent_info.agent_id'.
	Dimension string `json:"dimension,omitempty"`
	// SamplePercentage: Percentage of conversations that we should sample based on
	// the dimension between [0, 100].
	SamplePercentage float64 `json:"samplePercentage,omitempty"`
	// SampleRow: Number of the conversations that we should sample based on the
	// dimension.
	SampleRow int64 `json:"sampleRow,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ConversationFilter") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationFilter") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1SampleRule) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1SampleRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1SampleRule) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1SampleRule
	var s1 struct {
		SamplePercentage gensupport.JSONFloat64 `json:"samplePercentage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SamplePercentage = float64(s1.SamplePercentage)
	return nil
}

// GoogleCloudContactcenterinsightsV1ScheduleInfo: Message for schedule info.
type GoogleCloudContactcenterinsightsV1ScheduleInfo struct {
	// EndTime: End time of the schedule. If not specified, will keep scheduling
	// new pipelines for execution util the schedule is no longer active or
	// deleted.
	EndTime string `json:"endTime,omitempty"`
	// Schedule: The groc expression. Format: `every number [synchronized]` Time
	// units can be: minutes, hours Synchronized is optional and indicates that the
	// schedule should be synchronized to the start of the interval: every 5
	// minutes synchronized means 00:00, 00:05 ... Otherwise the start time is
	// random within the interval. Example: `every 5 minutes` could be 00:02,
	// 00:07, 00:12, ...
	Schedule string `json:"schedule,omitempty"`
	// StartTime: Start time of the schedule. If not specified, will start as soon
	// as the schedule is created.
	StartTime string `json:"startTime,omitempty"`
	// TimeZone: The timezone to use for the groc expression. If not specified,
	// defaults to UTC.
	TimeZone string `json:"timeZone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ScheduleInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ScheduleInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1SearchAuthorizedViewsResponse: The
// response from a ListAuthorizedViews request.
type GoogleCloudContactcenterinsightsV1SearchAuthorizedViewsResponse struct {
	// AuthorizedViews: The AuthorizedViews under the parent.
	AuthorizedViews []*GoogleCloudContactcenterinsightsV1AuthorizedView `json:"authorizedViews,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AuthorizedViews") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuthorizedViews") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1SearchAuthorizedViewsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1SearchAuthorizedViewsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1SentimentData: The data for a sentiment
// annotation.
type GoogleCloudContactcenterinsightsV1SentimentData struct {
	// Magnitude: A non-negative number from 0 to infinity which represents the
	// absolute magnitude of sentiment regardless of score.
	Magnitude float64 `json:"magnitude,omitempty"`
	// Score: The sentiment score between -1.0 (negative) and 1.0 (positive).
	Score float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Magnitude") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Magnitude") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1SentimentData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1SentimentData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1SentimentData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1SentimentData
	var s1 struct {
		Magnitude gensupport.JSONFloat64 `json:"magnitude"`
		Score     gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Magnitude = float64(s1.Magnitude)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudContactcenterinsightsV1Settings: The CCAI Insights project wide
// settings. Use these settings to configure the behavior of Insights. View
// these settings with `getsettings`
// (https://cloud.google.com/contact-center/insights/docs/reference/rest/v1/projects.locations/getSettings)
// and change the settings with `updateSettings`
// (https://cloud.google.com/contact-center/insights/docs/reference/rest/v1/projects.locations/updateSettings).
type GoogleCloudContactcenterinsightsV1Settings struct {
	// AnalysisConfig: Default analysis settings.
	AnalysisConfig *GoogleCloudContactcenterinsightsV1SettingsAnalysisConfig `json:"analysisConfig,omitempty"`
	// ConversationTtl: The default TTL for newly-created conversations. If a
	// conversation has a specified expiration, that value will be used instead.
	// Changing this value will not change the expiration of existing
	// conversations. Conversations with no expire time persist until they are
	// deleted.
	ConversationTtl string `json:"conversationTtl,omitempty"`
	// CreateTime: Output only. The time at which the settings was created.
	CreateTime string `json:"createTime,omitempty"`
	// LanguageCode: A language code to be applied to each transcript segment
	// unless the segment already specifies a language code. Language code defaults
	// to "en-US" if it is neither specified on the segment nor here.
	LanguageCode string `json:"languageCode,omitempty"`
	// Name: Immutable. The resource name of the settings resource. Format:
	// projects/{project}/locations/{location}/settings
	Name string `json:"name,omitempty"`
	// PubsubNotificationSettings: A map that maps a notification trigger to a
	// Pub/Sub topic. Each time a specified trigger occurs, Insights will notify
	// the corresponding Pub/Sub topic. Keys are notification triggers. Supported
	// keys are: * "all-triggers": Notify each time any of the supported triggers
	// occurs. * "create-analysis": Notify each time an analysis is created. *
	// "create-conversation": Notify each time a conversation is created. *
	// "export-insights-data": Notify each time an export is complete. *
	// "ingest-conversations": Notify each time an IngestConversations LRO is
	// complete. * "update-conversation": Notify each time a conversation is
	// updated via UpdateConversation. * "upload-conversation": Notify when an
	// UploadConversation LRO is complete. * "update-or-analyze-conversation":
	// Notify when an analysis for a conversation is completed or when the
	// conversation is updated. The message will contain the conversation with
	// transcript, analysis and other metadata. Values are Pub/Sub topics. The
	// format of each Pub/Sub topic is: projects/{project}/topics/{topic}
	PubsubNotificationSettings map[string]string `json:"pubsubNotificationSettings,omitempty"`
	// RedactionConfig: Default DLP redaction resources to be applied while
	// ingesting conversations. This applies to conversations ingested from the
	// `UploadConversation` and `IngestConversations` endpoints, including
	// conversations coming from CCAI Platform.
	RedactionConfig *GoogleCloudContactcenterinsightsV1RedactionConfig `json:"redactionConfig,omitempty"`
	// ScreenRecordingBucketUri: Optional. The path to a Cloud Storage bucket
	// containing conversation screen recordings. If provided, Insights will search
	// in the bucket for a screen recording file matching the conversation data
	// source object name prefix. If matches are found, these file URIs will be
	// stored in the conversation screen recordings field.
	ScreenRecordingBucketUri string `json:"screenRecordingBucketUri,omitempty"`
	// SpeechConfig: Optional. Default Speech-to-Text resources to use while
	// ingesting audio files. Optional, CCAI Insights will create a default if not
	// provided. This applies to conversations ingested from the
	// `UploadConversation` and `IngestConversations` endpoints, including
	// conversations coming from CCAI Platform.
	SpeechConfig *GoogleCloudContactcenterinsightsV1SpeechConfig `json:"speechConfig,omitempty"`
	// UpdateTime: Output only. The time at which the settings were last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AnalysisConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalysisConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1Settings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1Settings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1SettingsAnalysisConfig: Default
// configuration when creating Analyses in Insights.
type GoogleCloudContactcenterinsightsV1SettingsAnalysisConfig struct {
	// AnnotatorSelector: To select the annotators to run and the phrase matchers
	// to use (if any). If not specified, all annotators will be run.
	AnnotatorSelector *GoogleCloudContactcenterinsightsV1AnnotatorSelector `json:"annotatorSelector,omitempty"`
	// RuntimeIntegrationAnalysisPercentage: Percentage of conversations created
	// using Dialogflow runtime integration to analyze automatically, between [0,
	// 100].
	RuntimeIntegrationAnalysisPercentage float64 `json:"runtimeIntegrationAnalysisPercentage,omitempty"`
	// UploadConversationAnalysisPercentage: Percentage of conversations created
	// using the UploadConversation endpoint to analyze automatically, between [0,
	// 100].
	UploadConversationAnalysisPercentage float64 `json:"uploadConversationAnalysisPercentage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotatorSelector") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotatorSelector") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1SettingsAnalysisConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1SettingsAnalysisConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1SettingsAnalysisConfig) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1SettingsAnalysisConfig
	var s1 struct {
		RuntimeIntegrationAnalysisPercentage gensupport.JSONFloat64 `json:"runtimeIntegrationAnalysisPercentage"`
		UploadConversationAnalysisPercentage gensupport.JSONFloat64 `json:"uploadConversationAnalysisPercentage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.RuntimeIntegrationAnalysisPercentage = float64(s1.RuntimeIntegrationAnalysisPercentage)
	s.UploadConversationAnalysisPercentage = float64(s1.UploadConversationAnalysisPercentage)
	return nil
}

// GoogleCloudContactcenterinsightsV1SignedAudioUris: Signed audio URIs for a
// conversation.
type GoogleCloudContactcenterinsightsV1SignedAudioUris struct {
	// SignedDialogflowAudioUri: The signed URI for the audio from the Dialogflow
	// conversation source.
	SignedDialogflowAudioUri string `json:"signedDialogflowAudioUri,omitempty"`
	// SignedGcsAudioUri: The signed URI for the audio from the Cloud Storage
	// conversation source.
	SignedGcsAudioUri string `json:"signedGcsAudioUri,omitempty"`
	// SignedTurnLevelAudios: The signed URI for the audio corresponding to each
	// turn in the conversation.
	SignedTurnLevelAudios []*GoogleCloudContactcenterinsightsV1ConversationDataSourceTurnLevelAudio `json:"signedTurnLevelAudios,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SignedDialogflowAudioUri")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SignedDialogflowAudioUri") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1SignedAudioUris) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1SignedAudioUris
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1SilenceData: The data for a silence
// annotation.
type GoogleCloudContactcenterinsightsV1SilenceData struct {
}

// GoogleCloudContactcenterinsightsV1SmartComposeSuggestionData: Agent Assist
// Smart Compose suggestion data.
type GoogleCloudContactcenterinsightsV1SmartComposeSuggestionData struct {
	// ConfidenceScore: The system's confidence score that this suggestion is a
	// good match for this conversation, ranging from 0.0 (completely uncertain) to
	// 1.0 (completely certain).
	ConfidenceScore float64 `json:"confidenceScore,omitempty"`
	// Metadata: Map that contains metadata about the Smart Compose suggestion and
	// the document from which it originates.
	Metadata map[string]string `json:"metadata,omitempty"`
	// QueryRecord: The name of the answer record. Format:
	// projects/{project}/locations/{location}/answerRecords/{answer_record}
	QueryRecord string `json:"queryRecord,omitempty"`
	// Suggestion: The content of the suggestion.
	Suggestion string `json:"suggestion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfidenceScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfidenceScore") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1SmartComposeSuggestionData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1SmartComposeSuggestionData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1SmartComposeSuggestionData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1SmartComposeSuggestionData
	var s1 struct {
		ConfidenceScore gensupport.JSONFloat64 `json:"confidenceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceScore = float64(s1.ConfidenceScore)
	return nil
}

// GoogleCloudContactcenterinsightsV1SmartReplyData: Agent Assist Smart Reply
// data.
type GoogleCloudContactcenterinsightsV1SmartReplyData struct {
	// ConfidenceScore: The system's confidence score that this reply is a good
	// match for this conversation, ranging from 0.0 (completely uncertain) to 1.0
	// (completely certain).
	ConfidenceScore float64 `json:"confidenceScore,omitempty"`
	// Metadata: Map that contains metadata about the Smart Reply and the document
	// from which it originates.
	Metadata map[string]string `json:"metadata,omitempty"`
	// QueryRecord: The name of the answer record. Format:
	// projects/{project}/locations/{location}/answerRecords/{answer_record}
	QueryRecord string `json:"queryRecord,omitempty"`
	// Reply: The content of the reply.
	Reply string `json:"reply,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfidenceScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfidenceScore") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1SmartReplyData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1SmartReplyData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1SmartReplyData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1SmartReplyData
	var s1 struct {
		ConfidenceScore gensupport.JSONFloat64 `json:"confidenceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceScore = float64(s1.ConfidenceScore)
	return nil
}

// GoogleCloudContactcenterinsightsV1SpeechConfig: Speech-to-Text
// configuration. Speech-to-Text settings are applied to conversations ingested
// from the `UploadConversation` and `IngestConversations` endpoints, including
// conversation coming from CCAI Platform. They are not applied to
// conversations ingested from the `CreateConversation` endpoint.
type GoogleCloudContactcenterinsightsV1SpeechConfig struct {
	// DisableWordTimeOffsets: Whether to disable word time offsets. If true, the
	// `enable_word_time_offsets` field in the recognition config will be set to
	// false.
	DisableWordTimeOffsets bool `json:"disableWordTimeOffsets,omitempty"`
	// SpeechRecognizer: The fully-qualified Speech Recognizer resource name.
	// Format: `projects/{project_id}/locations/{location}/recognizer/{recognizer}`
	SpeechRecognizer string `json:"speechRecognizer,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisableWordTimeOffsets") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisableWordTimeOffsets") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1SpeechConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1SpeechConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1TestAutoLabelingRuleRequest: The request
// message for testing auto labeling rules.
type GoogleCloudContactcenterinsightsV1TestAutoLabelingRuleRequest struct {
	// AutoLabelingRule: Required. The auto labeling rule to test.
	AutoLabelingRule *GoogleCloudContactcenterinsightsV1AutoLabelingRule `json:"autoLabelingRule,omitempty"`
	// Conversation: Required. Conversation data to test rules against.
	Conversation *GoogleCloudContactcenterinsightsV1Conversation `json:"conversation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutoLabelingRule") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoLabelingRule") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1TestAutoLabelingRuleRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1TestAutoLabelingRuleRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1TestAutoLabelingRuleResponse: The response
// message for testing auto labeling rules.
type GoogleCloudContactcenterinsightsV1TestAutoLabelingRuleResponse struct {
	// LabelResult: The result of the test auto labeling rule.
	LabelResult string `json:"labelResult,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "LabelResult") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LabelResult") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1TestAutoLabelingRuleResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1TestAutoLabelingRuleResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1TestCorrelationConfigMetadata: Metadata
// for testing correlation config.
type GoogleCloudContactcenterinsightsV1TestCorrelationConfigMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// Dataset: The dataset used for sampling conversations.
	Dataset string `json:"dataset,omitempty"`
	// Stats: The statistics for the operation.
	Stats *GoogleCloudContactcenterinsightsV1TestCorrelationConfigMetadataFullConversationCorrelationStats `json:"stats,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1TestCorrelationConfigMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1TestCorrelationConfigMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1TestCorrelationConfigMetadataFullConversati
// onCorrelationStats: Statistics for TestCorrelationConfig operation.
type GoogleCloudContactcenterinsightsV1TestCorrelationConfigMetadataFullConversationCorrelationStats struct {
	// ConversationCorrelationErrors: A list of errors that occurred during
	// correlation, one for each conversation that failed.
	ConversationCorrelationErrors []*GoogleCloudContactcenterinsightsV1TestCorrelationConfigMetadataFullConversationCorrelationStatsConversationCorrelationError `json:"conversationCorrelationErrors,omitempty"`
	// CorrelatedConversationsCount: The number of conversations correlated.
	CorrelatedConversationsCount int64 `json:"correlatedConversationsCount,omitempty"`
	// FailedConversationsCount: The number of conversations that failed
	// correlation.
	FailedConversationsCount int64 `json:"failedConversationsCount,omitempty"`
	// PartialErrors: Partial errors during test correlation config operation that
	// might cause the operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// SampledConversationsCount: The number of conversations sampled.
	SampledConversationsCount int64 `json:"sampledConversationsCount,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "ConversationCorrelationErrors") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationCorrelationErrors")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1TestCorrelationConfigMetadataFullConversationCorrelationStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1TestCorrelationConfigMetadataFullConversationCorrelationStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1TestCorrelationConfigMetadataFullConversati
// onCorrelationStatsConversationCorrelationError: An error that occurred
// during correlation for a specific conversation.
type GoogleCloudContactcenterinsightsV1TestCorrelationConfigMetadataFullConversationCorrelationStatsConversationCorrelationError struct {
	// Conversation: The conversation resource name that had an error during
	// correlation.
	Conversation string `json:"conversation,omitempty"`
	// Status: The error status.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conversation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conversation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1TestCorrelationConfigMetadataFullConversationCorrelationStatsConversationCorrelationError) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1TestCorrelationConfigMetadataFullConversationCorrelationStatsConversationCorrelationError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1TestCorrelationConfigRequest: The request
// to test correlation config.
type GoogleCloudContactcenterinsightsV1TestCorrelationConfigRequest struct {
	// Conversations: Optional. A list of conversations to test against.
	Conversations *GoogleCloudContactcenterinsightsV1TestCorrelationConfigRequestConversations `json:"conversations,omitempty"`
	// CorrelationConfig: Required. The correlation config to test.
	CorrelationConfig *GoogleCloudContactcenterinsightsV1CorrelationConfig `json:"correlationConfig,omitempty"`
	// Filter: Optional. Filter to select conversations to test correlation
	// against. Conversations matching this filter will be sampled based on start
	// time. The most recent `max_sample_count` conversations will be selected. If
	// no conversations match the filter, the request will fail with an
	// `INVALID_ARGUMENT` error.
	Filter string `json:"filter,omitempty"`
	// MaxSampleCount: Optional. The maximum number of conversations to sample when
	// using the `filter`. If not set, defaults to 1000. Values greater than 1000
	// are coerced to 1000. This field is ignored if `conversations` is provided.
	MaxSampleCount int64 `json:"maxSampleCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conversations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conversations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1TestCorrelationConfigRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1TestCorrelationConfigRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1TestCorrelationConfigRequestConversations:
// Wrapper for a list of conversations.
type GoogleCloudContactcenterinsightsV1TestCorrelationConfigRequestConversations struct {
	// Conversations: Optional. The conversations.
	Conversations []*GoogleCloudContactcenterinsightsV1Conversation `json:"conversations,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conversations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conversations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1TestCorrelationConfigRequestConversations) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1TestCorrelationConfigRequestConversations
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1TestCorrelationConfigResponse: The
// response of testing correlation config.
type GoogleCloudContactcenterinsightsV1TestCorrelationConfigResponse struct {
	// DetailedResults: Results for the DETAILED_SYNC execution mode.
	DetailedResults *GoogleCloudContactcenterinsightsV1TestCorrelationConfigResponseDetailedCorrelationResults `json:"detailedResults,omitempty"`
	// PartialErrors: Partial errors during test correlation config operation that
	// might cause the operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DetailedResults") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DetailedResults") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1TestCorrelationConfigResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1TestCorrelationConfigResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1TestCorrelationConfigResponseDetailedCorrel
// ationResults: Wrapper for detailed, step-by-step results.
type GoogleCloudContactcenterinsightsV1TestCorrelationConfigResponseDetailedCorrelationResults struct {
	// ConstraintResults: A list of constraint evaluation results for each pair of
	// conversations.
	ConstraintResults []*GoogleCloudContactcenterinsightsV1ConstraintEvaluationResult `json:"constraintResults,omitempty"`
	// JoinKeyResults: A list of join key correlation results for each conversation
	// tested.
	JoinKeyResults []*GoogleCloudContactcenterinsightsV1ConversationCorrelationResult `json:"joinKeyResults,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConstraintResults") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConstraintResults") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1TestCorrelationConfigResponseDetailedCorrelationResults) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1TestCorrelationConfigResponseDetailedCorrelationResults
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1TuneQaScorecardRevisionRequest: Request
// for TuneQaScorecardRevision endpoint.
type GoogleCloudContactcenterinsightsV1TuneQaScorecardRevisionRequest struct {
	// Filter: Required. Filter for selecting the feedback labels that needs to be
	// used for training. This filter can be used to limit the feedback labels used
	// for tuning to a feedback labels created or updated for a specific
	// time-window etc.
	Filter string `json:"filter,omitempty"`
	// ValidateOnly: Optional. Run in validate only mode, no fine tuning will
	// actually run. Data quality validations like training data distributions will
	// run. Even when set to false, the data quality validations will still run but
	// once the validations complete we will proceed with the fine tune, if
	// applicable.
	ValidateOnly bool `json:"validateOnly,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1TuneQaScorecardRevisionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1TuneQaScorecardRevisionRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1UndeployIssueModelMetadata: Metadata for
// undeploying an issue model.
type GoogleCloudContactcenterinsightsV1UndeployIssueModelMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original request for undeployment.
	Request *GoogleCloudContactcenterinsightsV1UndeployIssueModelRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1UndeployIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1UndeployIssueModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1UndeployIssueModelRequest: The request to
// undeploy an issue model.
type GoogleCloudContactcenterinsightsV1UndeployIssueModelRequest struct {
	// Name: Required. The issue model to undeploy.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1UndeployIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1UndeployIssueModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1UndeployIssueModelResponse: The response
// to undeploy an issue model.
type GoogleCloudContactcenterinsightsV1UndeployIssueModelResponse struct {
}

// GoogleCloudContactcenterinsightsV1UndeployQaScorecardRevisionRequest: The
// request to undeploy a QaScorecardRevision
type GoogleCloudContactcenterinsightsV1UndeployQaScorecardRevisionRequest struct {
}

// GoogleCloudContactcenterinsightsV1UpdateQaQuestionTagMetadata: The metadata
// for updating a QaQuestionTag Resource.
type GoogleCloudContactcenterinsightsV1UpdateQaQuestionTagMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: Output only. The original request.
	Request *GoogleCloudContactcenterinsightsV1UpdateQaQuestionTagRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1UpdateQaQuestionTagMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1UpdateQaQuestionTagMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1UpdateQaQuestionTagRequest: The request
// for updating a QaQuestionTag.
type GoogleCloudContactcenterinsightsV1UpdateQaQuestionTagRequest struct {
	// QaQuestionTag: Required. The QaQuestionTag to update.
	QaQuestionTag *GoogleCloudContactcenterinsightsV1QaQuestionTag `json:"qaQuestionTag,omitempty"`
	// UpdateMask: Optional. The list of fields to be updated. All possible fields
	// can be updated by passing `*`, or a subset of the following updateable
	// fields can be provided: * `qa_question_tag_name` - the name of the tag *
	// `qa_question_ids` - the list of questions the tag applies to
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QaQuestionTag") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QaQuestionTag") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1UpdateQaQuestionTagRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1UpdateQaQuestionTagRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1UploadConversationMetadata: The metadata
// for an `UploadConversation` operation.
type GoogleCloudContactcenterinsightsV1UploadConversationMetadata struct {
	// AnalysisOperation: Output only. The operation name for a successfully
	// created analysis operation, if any.
	AnalysisOperation string `json:"analysisOperation,omitempty"`
	// AppliedRedactionConfig: Output only. The redaction config applied to the
	// uploaded conversation.
	AppliedRedactionConfig *GoogleCloudContactcenterinsightsV1RedactionConfig `json:"appliedRedactionConfig,omitempty"`
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: Output only. The original request.
	Request *GoogleCloudContactcenterinsightsV1UploadConversationRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnalysisOperation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalysisOperation") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1UploadConversationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1UploadConversationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1UploadConversationRequest: Request to
// upload a conversation.
type GoogleCloudContactcenterinsightsV1UploadConversationRequest struct {
	// Conversation: Required. The conversation resource to create.
	Conversation *GoogleCloudContactcenterinsightsV1Conversation `json:"conversation,omitempty"`
	// ConversationId: Optional. A unique ID for the new conversation. This ID will
	// become the final component of the conversation's resource name. If no ID is
	// specified, a server-generated ID will be used. This value should be 4-64
	// characters and must match the regular expression `^[a-z0-9-]{4,64}$`. Valid
	// characters are `a-z-`
	ConversationId string `json:"conversationId,omitempty"`
	// Parent: Required. The parent resource of the conversation.
	Parent string `json:"parent,omitempty"`
	// RedactionConfig: Optional. DLP settings for transcript redaction. Will
	// default to the config specified in Settings.
	RedactionConfig *GoogleCloudContactcenterinsightsV1RedactionConfig `json:"redactionConfig,omitempty"`
	// SpeechConfig: Optional. Speech-to-Text configuration. Will default to the
	// config specified in Settings.
	SpeechConfig *GoogleCloudContactcenterinsightsV1SpeechConfig `json:"speechConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conversation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conversation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1UploadConversationRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1UploadConversationRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1UserInfo: Information about a user.
type GoogleCloudContactcenterinsightsV1UserInfo struct {
	// Username: The user's username.
	Username string `json:"username,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Username") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Username") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1UserInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1UserInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1View: The View resource.
type GoogleCloudContactcenterinsightsV1View struct {
	// CreateTime: Output only. The time at which this view was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: The human-readable display name of the view.
	DisplayName string `json:"displayName,omitempty"`
	// Name: Immutable. The resource name of the view. Format:
	// projects/{project}/locations/{location}/views/{view}
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. The most recent time at which the view was updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// Value: A filter to reduce conversation results to a specific subset. Refer
	// to https://cloud.google.com/contact-center/insights/docs/filtering for
	// details.
	Value string `json:"value,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1View) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1View
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1Widget: Represents a dashboard element,
// could be a nested Container or Chart.
type GoogleCloudContactcenterinsightsV1Widget struct {
	// Chart: A chart widget.
	Chart *GoogleCloudContactcenterinsightsV1Chart `json:"chart,omitempty"`
	// ChartReference: A reference to a chart widget. Format:
	// projects/{project}/locations/{location}/dashboards/{dashboard}/charts/{chart}
	ChartReference string `json:"chartReference,omitempty"`
	// Container: A container widget.
	Container *GoogleCloudContactcenterinsightsV1Container `json:"container,omitempty"`
	// Filter: Filter applied to all charts in the container. Should support scope
	// later.
	Filter string `json:"filter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Chart") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Chart") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1Widget) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1Widget
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1Analysis: The analysis resource.
type GoogleCloudContactcenterinsightsV1alpha1Analysis struct {
	// AnalysisResult: Output only. The result of the analysis, which is populated
	// when the analysis finishes.
	AnalysisResult *GoogleCloudContactcenterinsightsV1alpha1AnalysisResult `json:"analysisResult,omitempty"`
	// AnnotatorSelector: To select the annotators to run and the phrase matchers
	// to use (if any). If not specified, all annotators will be run.
	AnnotatorSelector *GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelector `json:"annotatorSelector,omitempty"`
	// CreateTime: Output only. The time at which the analysis was created, which
	// occurs when the long-running operation completes.
	CreateTime string `json:"createTime,omitempty"`
	// Name: Immutable. The resource name of the analysis. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}/analyses
	// /{analysis}
	Name string `json:"name,omitempty"`
	// RequestTime: Output only. The time at which the analysis was requested.
	RequestTime string `json:"requestTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnalysisResult") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalysisResult") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1Analysis) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1Analysis
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1AnalysisResult: The result of an
// analysis.
type GoogleCloudContactcenterinsightsV1alpha1AnalysisResult struct {
	// CallAnalysisMetadata: Call-specific metadata created by the analysis.
	CallAnalysisMetadata *GoogleCloudContactcenterinsightsV1alpha1AnalysisResultCallAnalysisMetadata `json:"callAnalysisMetadata,omitempty"`
	// EndTime: The time at which the analysis ended.
	EndTime string `json:"endTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CallAnalysisMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CallAnalysisMetadata") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1AnalysisResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1AnalysisResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1AnalysisResultCallAnalysisMetadata:
// Call-specific metadata created during analysis.
type GoogleCloudContactcenterinsightsV1alpha1AnalysisResultCallAnalysisMetadata struct {
	// Annotations: A list of call annotations that apply to this call.
	Annotations []*GoogleCloudContactcenterinsightsV1alpha1CallAnnotation `json:"annotations,omitempty"`
	// Entities: All the entities in the call.
	Entities map[string]GoogleCloudContactcenterinsightsV1alpha1Entity `json:"entities,omitempty"`
	// Intents: All the matched intents in the call.
	Intents map[string]GoogleCloudContactcenterinsightsV1alpha1Intent `json:"intents,omitempty"`
	// IssueModelResult: Overall conversation-level issue modeling result.
	IssueModelResult *GoogleCloudContactcenterinsightsV1alpha1IssueModelResult `json:"issueModelResult,omitempty"`
	// PhraseMatchers: All the matched phrase matchers in the call.
	PhraseMatchers map[string]GoogleCloudContactcenterinsightsV1alpha1PhraseMatchData `json:"phraseMatchers,omitempty"`
	// QaScorecardResults: Results of scoring QaScorecards.
	QaScorecardResults []*GoogleCloudContactcenterinsightsV1alpha1QaScorecardResult `json:"qaScorecardResults,omitempty"`
	// Sentiments: Overall conversation-level sentiment for each channel of the
	// call.
	Sentiments []*GoogleCloudContactcenterinsightsV1alpha1ConversationLevelSentiment `json:"sentiments,omitempty"`
	// Silence: Overall conversation-level silence during the call.
	Silence *GoogleCloudContactcenterinsightsV1alpha1ConversationLevelSilence `json:"silence,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1AnalysisResultCallAnalysisMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1AnalysisResultCallAnalysisMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1AnnotationBoundary: A point in a
// conversation that marks the start or the end of an annotation.
type GoogleCloudContactcenterinsightsV1alpha1AnnotationBoundary struct {
	// TranscriptIndex: The index in the sequence of transcribed pieces of the
	// conversation where the boundary is located. This index starts at zero.
	TranscriptIndex int64 `json:"transcriptIndex,omitempty"`
	// WordIndex: The word index of this boundary with respect to the first word in
	// the transcript piece. This index starts at zero.
	WordIndex int64 `json:"wordIndex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TranscriptIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TranscriptIndex") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1AnnotationBoundary) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1AnnotationBoundary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelector: Selector of all
// available annotators and phrase matchers to run.
type GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelector struct {
	// IssueModels: The issue model to run. If not provided, the most recently
	// deployed topic model will be used. The provided issue model will only be
	// used for inference if the issue model is deployed and if
	// run_issue_model_annotator is set to true. If more than one issue model is
	// provided, only the first provided issue model will be used for inference.
	IssueModels []string `json:"issueModels,omitempty"`
	// PhraseMatchers: The list of phrase matchers to run. If not provided, all
	// active phrase matchers will be used. If inactive phrase matchers are
	// provided, they will not be used. Phrase matchers will be run only if
	// run_phrase_matcher_annotator is set to true. Format:
	// projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}
	PhraseMatchers []string `json:"phraseMatchers,omitempty"`
	// QaConfig: Configuration for the QA annotator.
	QaConfig *GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorQaConfig `json:"qaConfig,omitempty"`
	// RunEntityAnnotator: Whether to run the entity annotator.
	RunEntityAnnotator bool `json:"runEntityAnnotator,omitempty"`
	// RunIntentAnnotator: Whether to run the intent annotator.
	RunIntentAnnotator bool `json:"runIntentAnnotator,omitempty"`
	// RunInterruptionAnnotator: Whether to run the interruption annotator.
	RunInterruptionAnnotator bool `json:"runInterruptionAnnotator,omitempty"`
	// RunIssueModelAnnotator: Whether to run the issue model annotator. A model
	// should have already been deployed for this to take effect.
	RunIssueModelAnnotator bool `json:"runIssueModelAnnotator,omitempty"`
	// RunPhraseMatcherAnnotator: Whether to run the active phrase matcher
	// annotator(s).
	RunPhraseMatcherAnnotator bool `json:"runPhraseMatcherAnnotator,omitempty"`
	// RunQaAnnotator: Whether to run the QA annotator.
	RunQaAnnotator bool `json:"runQaAnnotator,omitempty"`
	// RunSentimentAnnotator: Whether to run the sentiment annotator.
	RunSentimentAnnotator bool `json:"runSentimentAnnotator,omitempty"`
	// RunSilenceAnnotator: Whether to run the silence annotator.
	RunSilenceAnnotator bool `json:"runSilenceAnnotator,omitempty"`
	// RunSummarizationAnnotator: Whether to run the summarization annotator.
	RunSummarizationAnnotator bool `json:"runSummarizationAnnotator,omitempty"`
	// SummarizationConfig: Configuration for the summarization annotator.
	SummarizationConfig *GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorSummarizationConfig `json:"summarizationConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IssueModels") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IssueModels") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelector) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelector
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorQaConfig:
// Configuration for the QA feature.
type GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorQaConfig struct {
	// ScorecardList: A manual list of scorecards to score.
	ScorecardList *GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorQaConfigScorecardList `json:"scorecardList,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ScorecardList") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ScorecardList") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorQaConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorQaConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorQaConfigScorecardLis
// t: Container for a list of scorecards.
type GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorQaConfigScorecardList struct {
	// QaScorecardRevisions: List of QaScorecardRevisions.
	QaScorecardRevisions []string `json:"qaScorecardRevisions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QaScorecardRevisions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QaScorecardRevisions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorQaConfigScorecardList) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorQaConfigScorecardList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorSummarizationConfig:
//
//	Configuration for summarization.
type GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorSummarizationConfig struct {
	// ConversationProfile: Resource name of the Dialogflow conversation profile.
	// Format:
	// projects/{project}/locations/{location}/conversationProfiles/{conversation_pr
	// ofile}
	ConversationProfile string `json:"conversationProfile,omitempty"`
	// Generator: The resource name of the existing created generator. Format:
	// projects//locations//generators/
	Generator string `json:"generator,omitempty"`
	// SummarizationModel: Default summarization model to be used.
	//
	// Possible values:
	//   "SUMMARIZATION_MODEL_UNSPECIFIED" - Unspecified summarization model.
	//   "BASELINE_MODEL" - The CCAI baseline model. This model is deprecated and
	// will be removed in the future. We recommend using `generator` instead.
	//   "BASELINE_MODEL_V2_0" - The CCAI baseline model, V2.0. This model is
	// deprecated and will be removed in the future. We recommend using `generator`
	// instead.
	SummarizationModel string `json:"summarizationModel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationProfile") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationProfile") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorSummarizationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorSummarizationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1AnswerFeedback: The feedback that
// the customer has about a certain answer in the conversation.
type GoogleCloudContactcenterinsightsV1alpha1AnswerFeedback struct {
	// Clicked: Indicates whether an answer or item was clicked by the human agent.
	Clicked bool `json:"clicked,omitempty"`
	// CorrectnessLevel: The correctness level of an answer.
	//
	// Possible values:
	//   "CORRECTNESS_LEVEL_UNSPECIFIED" - Correctness level unspecified.
	//   "NOT_CORRECT" - Answer is totally wrong.
	//   "PARTIALLY_CORRECT" - Answer is partially correct.
	//   "FULLY_CORRECT" - Answer is fully correct.
	CorrectnessLevel string `json:"correctnessLevel,omitempty"`
	// Displayed: Indicates whether an answer or item was displayed to the human
	// agent in the agent desktop UI.
	Displayed bool `json:"displayed,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Clicked") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Clicked") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1AnswerFeedback) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1AnswerFeedback
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ArticleSuggestionData: Agent Assist
// Article Suggestion data.
type GoogleCloudContactcenterinsightsV1alpha1ArticleSuggestionData struct {
	// ConfidenceScore: The system's confidence score that this article is a good
	// match for this conversation, ranging from 0.0 (completely uncertain) to 1.0
	// (completely certain).
	ConfidenceScore float64 `json:"confidenceScore,omitempty"`
	// Metadata: Map that contains metadata about the Article Suggestion and the
	// document that it originates from.
	Metadata map[string]string `json:"metadata,omitempty"`
	// QueryRecord: The name of the answer record. Format:
	// projects/{project}/locations/{location}/answerRecords/{answer_record}
	QueryRecord string `json:"queryRecord,omitempty"`
	// Source: The knowledge document that this answer was extracted from. Format:
	// projects/{project}/knowledgeBases/{knowledge_base}/documents/{document}
	Source string `json:"source,omitempty"`
	// Title: Article title.
	Title string `json:"title,omitempty"`
	// Uri: Article URI.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfidenceScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfidenceScore") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ArticleSuggestionData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ArticleSuggestionData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1ArticleSuggestionData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ArticleSuggestionData
	var s1 struct {
		ConfidenceScore gensupport.JSONFloat64 `json:"confidenceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceScore = float64(s1.ConfidenceScore)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsMetadata:
// The metadata for a bulk analyze conversations operation.
type GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsMetadata struct {
	// CompletedAnalysesCount: The number of requested analyses that have completed
	// successfully so far.
	CompletedAnalysesCount int64 `json:"completedAnalysesCount,omitempty"`
	// CreateTime: The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// FailedAnalysesCount: The number of requested analyses that have failed so
	// far.
	FailedAnalysesCount int64 `json:"failedAnalysesCount,omitempty"`
	// PartialErrors: Output only. Partial errors during bulk analyze operation
	// that might cause the operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: The original request for bulk analyze.
	Request *GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsRequest `json:"request,omitempty"`
	// TotalRequestedAnalysesCount: Total number of analyses requested. Computed by
	// the number of conversations returned by `filter` multiplied by
	// `analysis_percentage` in the request.
	TotalRequestedAnalysesCount int64 `json:"totalRequestedAnalysesCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompletedAnalysesCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompletedAnalysesCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsRequest: The
// request to analyze conversations in bulk.
type GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsRequest struct {
	// AnalysisPercentage: Required. Percentage of selected conversation to
	// analyze, between [0, 100].
	AnalysisPercentage float64 `json:"analysisPercentage,omitempty"`
	// AnnotatorSelector: To select the annotators to run and the phrase matchers
	// to use (if any). If not specified, all annotators will be run.
	AnnotatorSelector *GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelector `json:"annotatorSelector,omitempty"`
	// Filter: Required. Filter used to select the subset of conversations to
	// analyze.
	Filter string `json:"filter,omitempty"`
	// Parent: Required. The parent resource to create analyses in.
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnalysisPercentage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalysisPercentage") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsRequest) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsRequest
	var s1 struct {
		AnalysisPercentage gensupport.JSONFloat64 `json:"analysisPercentage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AnalysisPercentage = float64(s1.AnalysisPercentage)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsResponse:
// The response for a bulk analyze conversations operation.
type GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsResponse struct {
	// FailedAnalysisCount: Count of failed analyses.
	FailedAnalysisCount int64 `json:"failedAnalysisCount,omitempty"`
	// SuccessfulAnalysisCount: Count of successful analyses.
	SuccessfulAnalysisCount int64 `json:"successfulAnalysisCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FailedAnalysisCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FailedAnalysisCount") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1BulkDeleteConversationsMetadata: The
// metadata for a bulk delete conversations operation.
type GoogleCloudContactcenterinsightsV1alpha1BulkDeleteConversationsMetadata struct {
	// CreateTime: The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// PartialErrors: Partial errors during bulk delete conversations operation
	// that might cause the operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: The original request for bulk delete.
	Request *GoogleCloudContactcenterinsightsV1alpha1BulkDeleteConversationsRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1BulkDeleteConversationsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1BulkDeleteConversationsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1BulkDeleteConversationsRequest: The
// request to delete conversations in bulk.
type GoogleCloudContactcenterinsightsV1alpha1BulkDeleteConversationsRequest struct {
	// Filter: Filter used to select the subset of conversations to delete.
	Filter string `json:"filter,omitempty"`
	// Force: If set to true, all of this conversation's analyses will also be
	// deleted. Otherwise, the request will only succeed if the conversation has no
	// analyses.
	Force bool `json:"force,omitempty"`
	// MaxDeleteCount: Maximum number of conversations to delete.
	MaxDeleteCount int64 `json:"maxDeleteCount,omitempty"`
	// Parent: Required. The parent resource to delete conversations from. Format:
	// projects/{project}/locations/{location}
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1BulkDeleteConversationsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1BulkDeleteConversationsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1BulkDeleteConversationsResponse: The
// response for a bulk delete conversations operation.
type GoogleCloudContactcenterinsightsV1alpha1BulkDeleteConversationsResponse struct {
}

// GoogleCloudContactcenterinsightsV1alpha1BulkDeleteFeedbackLabelsMetadata:
// Metadata for the BulkDeleteFeedbackLabels endpoint.
type GoogleCloudContactcenterinsightsV1alpha1BulkDeleteFeedbackLabelsMetadata struct {
	// PartialErrors: Partial errors during deletion operation that might cause the
	// operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: Output only. The original request for delete.
	Request *GoogleCloudContactcenterinsightsV1alpha1BulkDeleteFeedbackLabelsRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PartialErrors") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PartialErrors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1BulkDeleteFeedbackLabelsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1BulkDeleteFeedbackLabelsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1BulkDeleteFeedbackLabelsRequest:
// Request for the BulkDeleteFeedbackLabels endpoint.
type GoogleCloudContactcenterinsightsV1alpha1BulkDeleteFeedbackLabelsRequest struct {
	// Filter: Optional. A filter to reduce results to a specific subset. Supports
	// disjunctions (OR) and conjunctions (AND). Supported fields: *
	// `issue_model_id` * `qa_question_id` * `qa_scorecard_id` * `min_create_time`
	// * `max_create_time` * `min_update_time` * `max_update_time` *
	// `feedback_label_type`: QUALITY_AI, TOPIC_MODELING
	Filter string `json:"filter,omitempty"`
	// Parent: Required. The parent resource for new feedback labels.
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1BulkDeleteFeedbackLabelsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1BulkDeleteFeedbackLabelsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1BulkDeleteFeedbackLabelsResponse:
// Response for the BulkDeleteFeedbackLabels endpoint.
type GoogleCloudContactcenterinsightsV1alpha1BulkDeleteFeedbackLabelsResponse struct {
}

// GoogleCloudContactcenterinsightsV1alpha1CallAnnotation: A piece of metadata
// that applies to a window of a call.
type GoogleCloudContactcenterinsightsV1alpha1CallAnnotation struct {
	// AnnotationEndBoundary: The boundary in the conversation where the annotation
	// ends, inclusive.
	AnnotationEndBoundary *GoogleCloudContactcenterinsightsV1alpha1AnnotationBoundary `json:"annotationEndBoundary,omitempty"`
	// AnnotationStartBoundary: The boundary in the conversation where the
	// annotation starts, inclusive.
	AnnotationStartBoundary *GoogleCloudContactcenterinsightsV1alpha1AnnotationBoundary `json:"annotationStartBoundary,omitempty"`
	// ChannelTag: The channel of the audio where the annotation occurs. For
	// single-channel audio, this field is not populated.
	ChannelTag int64 `json:"channelTag,omitempty"`
	// EntityMentionData: Data specifying an entity mention.
	EntityMentionData *GoogleCloudContactcenterinsightsV1alpha1EntityMentionData `json:"entityMentionData,omitempty"`
	// HoldData: Data specifying a hold.
	HoldData *GoogleCloudContactcenterinsightsV1alpha1HoldData `json:"holdData,omitempty"`
	// IntentMatchData: Data specifying an intent match.
	IntentMatchData *GoogleCloudContactcenterinsightsV1alpha1IntentMatchData `json:"intentMatchData,omitempty"`
	// InterruptionData: Data specifying an interruption.
	InterruptionData *GoogleCloudContactcenterinsightsV1alpha1InterruptionData `json:"interruptionData,omitempty"`
	// IssueMatchData: Data specifying an issue match.
	IssueMatchData *GoogleCloudContactcenterinsightsV1alpha1IssueMatchData `json:"issueMatchData,omitempty"`
	// PhraseMatchData: Data specifying a phrase match.
	PhraseMatchData *GoogleCloudContactcenterinsightsV1alpha1PhraseMatchData `json:"phraseMatchData,omitempty"`
	// SentimentData: Data specifying sentiment.
	SentimentData *GoogleCloudContactcenterinsightsV1alpha1SentimentData `json:"sentimentData,omitempty"`
	// SilenceData: Data specifying silence.
	SilenceData *GoogleCloudContactcenterinsightsV1alpha1SilenceData `json:"silenceData,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationEndBoundary") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationEndBoundary") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1CallAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1CallAnnotation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ConstraintEvaluationResult: The
// result of testing a constraint expression on a pair of conversations.
type GoogleCloudContactcenterinsightsV1alpha1ConstraintEvaluationResult struct {
	// ConversationA: The first conversation resource name.
	ConversationA string `json:"conversationA,omitempty"`
	// ConversationB: The second conversation resource name.
	ConversationB string `json:"conversationB,omitempty"`
	// RuleConstraintResults: The results for each applicable constraint rule.
	RuleConstraintResults []*GoogleCloudContactcenterinsightsV1alpha1ConstraintEvaluationResultRuleConstraintResult `json:"ruleConstraintResults,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationA") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationA") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ConstraintEvaluationResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConstraintEvaluationResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ConstraintEvaluationResultRuleConstra
// intResult: The result of a single constraint rule on the pair of
// conversations.
type GoogleCloudContactcenterinsightsV1alpha1ConstraintEvaluationResultRuleConstraintResult struct {
	// ConstraintMet: Whether the constraint expression evaluated to true for (A,
	// B) or (B, A).
	ConstraintMet bool `json:"constraintMet,omitempty"`
	// Error: The error status if the constraint expression failed to evaluate.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// RuleId: The rule ID.
	RuleId string `json:"ruleId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConstraintMet") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConstraintMet") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ConstraintEvaluationResultRuleConstraintResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConstraintEvaluationResultRuleConstraintResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1Conversation: The conversation
// resource.
type GoogleCloudContactcenterinsightsV1alpha1Conversation struct {
	// AgentId: An opaque, user-specified string representing the human agent who
	// handled the conversation.
	AgentId string `json:"agentId,omitempty"`
	// CallMetadata: Call-specific metadata.
	CallMetadata *GoogleCloudContactcenterinsightsV1alpha1ConversationCallMetadata `json:"callMetadata,omitempty"`
	// CorrelationInfo: Output only. Info for correlating across conversations.
	CorrelationInfo *GoogleCloudContactcenterinsightsV1alpha1ConversationCorrelationInfo `json:"correlationInfo,omitempty"`
	// CreateTime: Output only. The time at which the conversation was created.
	CreateTime string `json:"createTime,omitempty"`
	// DataSource: The source of the audio and transcription for the conversation.
	DataSource *GoogleCloudContactcenterinsightsV1alpha1ConversationDataSource `json:"dataSource,omitempty"`
	// DialogflowIntents: Output only. All the matched Dialogflow intents in the
	// call. The key corresponds to a Dialogflow intent, format:
	// projects/{project}/agent/{agent}/intents/{intent}
	DialogflowIntents map[string]GoogleCloudContactcenterinsightsV1alpha1DialogflowIntent `json:"dialogflowIntents,omitempty"`
	// Duration: Output only. The duration of the conversation.
	Duration string `json:"duration,omitempty"`
	// ExpireTime: The time at which this conversation should expire. After this
	// time, the conversation data and any associated analyses will be deleted.
	ExpireTime string `json:"expireTime,omitempty"`
	// Labels: A map for the user to specify any custom fields. A maximum of 100
	// labels per conversation is allowed, with a maximum of 256 characters per
	// entry.
	Labels map[string]string `json:"labels,omitempty"`
	// LanguageCode: A user-specified language code for the conversation.
	LanguageCode string `json:"languageCode,omitempty"`
	// LatestAnalysis: Output only. The conversation's latest analysis, if one
	// exists.
	LatestAnalysis *GoogleCloudContactcenterinsightsV1alpha1Analysis `json:"latestAnalysis,omitempty"`
	// LatestSummary: Output only. Latest summary of the conversation.
	LatestSummary *GoogleCloudContactcenterinsightsV1alpha1ConversationSummarizationSuggestionData `json:"latestSummary,omitempty"`
	// Medium: Immutable. The conversation medium.
	//
	// Possible values:
	//   "MEDIUM_UNSPECIFIED" - Default value for unspecified.
	//   "PHONE_CALL" - The format for conversations that took place over the
	// phone.
	//   "CHAT" - The format for conversations that took place over chat.
	Medium string `json:"medium,omitempty"`
	// MetadataJson: Input only. JSON metadata encoded as a string. This field is
	// primarily used by Insights integrations with various telephony systems and
	// must be in one of Insight's supported formats.
	MetadataJson string `json:"metadataJson,omitempty"`
	// Name: Immutable. The resource name of the conversation. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}
	Name string `json:"name,omitempty"`
	// ObfuscatedUserId: Obfuscated user ID which the customer sent to us.
	ObfuscatedUserId string `json:"obfuscatedUserId,omitempty"`
	// QualityMetadata: Conversation metadata related to quality management.
	QualityMetadata *GoogleCloudContactcenterinsightsV1alpha1ConversationQualityMetadata `json:"qualityMetadata,omitempty"`
	// RuntimeAnnotations: Output only. The annotations that were generated during
	// the customer and agent interaction.
	RuntimeAnnotations []*GoogleCloudContactcenterinsightsV1alpha1RuntimeAnnotation `json:"runtimeAnnotations,omitempty"`
	// StartTime: The time at which the conversation started.
	StartTime string `json:"startTime,omitempty"`
	// Transcript: Output only. The conversation transcript.
	Transcript *GoogleCloudContactcenterinsightsV1alpha1ConversationTranscript `json:"transcript,omitempty"`
	// Ttl: Input only. The TTL for this resource. If specified, then this TTL will
	// be used to calculate the expire time.
	Ttl string `json:"ttl,omitempty"`
	// TurnCount: Output only. The number of turns in the conversation.
	TurnCount int64 `json:"turnCount,omitempty"`
	// UpdateTime: Output only. The most recent time at which the conversation was
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1Conversation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1Conversation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ConversationCallMetadata:
// Call-specific metadata.
type GoogleCloudContactcenterinsightsV1alpha1ConversationCallMetadata struct {
	// AgentChannel: The audio channel that contains the agent.
	AgentChannel int64 `json:"agentChannel,omitempty"`
	// CustomerChannel: The audio channel that contains the customer.
	CustomerChannel int64 `json:"customerChannel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentChannel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentChannel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ConversationCallMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationCallMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ConversationCorrelationInfo: Info
// for correlating across conversations.
type GoogleCloudContactcenterinsightsV1alpha1ConversationCorrelationInfo struct {
	// CorrelationTypes: Output only. The correlation types of this conversation. A
	// single conversation can have multiple correlation types. For example a
	// conversation that only has a single segment is both a SEGMENT and a
	// FULL_CONVERSATION.
	//
	// Possible values:
	//   "CORRELATION_TYPE_UNSPECIFIED" - Default value for unspecified.
	//   "SEGMENT" - This conversation represents a segment of a full conversation.
	// The lowest level of granularity.
	//   "PARTIAL" - This conversation represents a partial conversation of
	// potentially multiple segments but is not a full conversation.
	//   "FULL" - This conversation represents a full conversation of potentially
	// multiple segments.
	//   "SYNTHETIC" - This conversation represents a synthetic conversation.
	CorrelationTypes []string `json:"correlationTypes,omitempty"`
	// FullConversationCorrelationId: Output only. The full conversation
	// correlation id this conversation is a segment of.
	FullConversationCorrelationId string `json:"fullConversationCorrelationId,omitempty"`
	// MergedFullConversationCorrelationId: Output only. The full conversation
	// correlation id this conversation is a merged conversation of.
	MergedFullConversationCorrelationId string `json:"mergedFullConversationCorrelationId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CorrelationTypes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CorrelationTypes") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ConversationCorrelationInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationCorrelationInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ConversationCorrelationResult: The
// result of testing correlation config on a single conversation.
type GoogleCloudContactcenterinsightsV1alpha1ConversationCorrelationResult struct {
	// Conversation: The conversation resource name.
	Conversation string `json:"conversation,omitempty"`
	// RuleResults: The results for each correlation rule.
	RuleResults []*GoogleCloudContactcenterinsightsV1alpha1ConversationCorrelationResultRuleCorrelationResult `json:"ruleResults,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conversation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conversation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ConversationCorrelationResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationCorrelationResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ConversationCorrelationResultRuleCorr
// elationResult: The result of a single correlation rule.
type GoogleCloudContactcenterinsightsV1alpha1ConversationCorrelationResultRuleCorrelationResult struct {
	// CorrelationId: The correlation ID generated by the join key expression.
	CorrelationId string `json:"correlationId,omitempty"`
	// Error: The error status if the join key expression failed to evaluate.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// RuleId: The rule ID.
	RuleId string `json:"ruleId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CorrelationId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CorrelationId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ConversationCorrelationResultRuleCorrelationResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationCorrelationResultRuleCorrelationResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ConversationDataSource: The
// conversation source, which is a combination of transcript and audio.
type GoogleCloudContactcenterinsightsV1alpha1ConversationDataSource struct {
	// DialogflowSource: The source when the conversation comes from Dialogflow.
	DialogflowSource *GoogleCloudContactcenterinsightsV1alpha1DialogflowSource `json:"dialogflowSource,omitempty"`
	// GcsSource: A Cloud Storage location specification for the audio and
	// transcript.
	GcsSource *GoogleCloudContactcenterinsightsV1alpha1GcsSource `json:"gcsSource,omitempty"`
	// MetadataUri: Cloud Storage URI that points to a file that contains the
	// conversation metadata.
	MetadataUri string `json:"metadataUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DialogflowSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DialogflowSource") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ConversationDataSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationDataSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ConversationLevelSentiment: One
// channel of conversation-level sentiment data.
type GoogleCloudContactcenterinsightsV1alpha1ConversationLevelSentiment struct {
	// ChannelTag: The channel of the audio that the data applies to.
	ChannelTag int64 `json:"channelTag,omitempty"`
	// SentimentData: Data specifying sentiment.
	SentimentData *GoogleCloudContactcenterinsightsV1alpha1SentimentData `json:"sentimentData,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChannelTag") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChannelTag") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ConversationLevelSentiment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationLevelSentiment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ConversationLevelSilence:
// Conversation-level silence data.
type GoogleCloudContactcenterinsightsV1alpha1ConversationLevelSilence struct {
	// SilenceDuration: Amount of time calculated to be in silence.
	SilenceDuration string `json:"silenceDuration,omitempty"`
	// SilencePercentage: Percentage of the total conversation spent in silence.
	SilencePercentage float64 `json:"silencePercentage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SilenceDuration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SilenceDuration") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ConversationLevelSilence) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationLevelSilence
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1ConversationLevelSilence) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationLevelSilence
	var s1 struct {
		SilencePercentage gensupport.JSONFloat64 `json:"silencePercentage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SilencePercentage = float64(s1.SilencePercentage)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1ConversationParticipant: The call
// participant speaking for a given utterance.
type GoogleCloudContactcenterinsightsV1alpha1ConversationParticipant struct {
	// DialogflowParticipant: Deprecated. Use `dialogflow_participant_name`
	// instead. The name of the Dialogflow participant. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}/particip
	// ants/{participant}
	DialogflowParticipant string `json:"dialogflowParticipant,omitempty"`
	// DialogflowParticipantName: The name of the participant provided by
	// Dialogflow. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}/particip
	// ants/{participant}
	DialogflowParticipantName string `json:"dialogflowParticipantName,omitempty"`
	// ObfuscatedExternalUserId: Obfuscated user ID from Dialogflow.
	ObfuscatedExternalUserId string `json:"obfuscatedExternalUserId,omitempty"`
	// Role: The role of the participant.
	//
	// Possible values:
	//   "ROLE_UNSPECIFIED" - Participant's role is not set.
	//   "HUMAN_AGENT" - Participant is a human agent.
	//   "AUTOMATED_AGENT" - Participant is an automated agent.
	//   "END_USER" - Participant is an end user who conversed with the contact
	// center.
	//   "ANY_AGENT" - Participant is either a human or automated agent.
	Role string `json:"role,omitempty"`
	// UserId: A user-specified ID representing the participant.
	UserId string `json:"userId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DialogflowParticipant") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DialogflowParticipant") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ConversationParticipant) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationParticipant
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ConversationQualityMetadata:
// Conversation metadata related to quality management.
type GoogleCloudContactcenterinsightsV1alpha1ConversationQualityMetadata struct {
	// AgentInfo: Information about agents involved in the call.
	AgentInfo []*GoogleCloudContactcenterinsightsV1alpha1ConversationQualityMetadataAgentInfo `json:"agentInfo,omitempty"`
	// CustomerSatisfactionRating: An arbitrary integer value indicating the
	// customer's satisfaction rating.
	CustomerSatisfactionRating int64 `json:"customerSatisfactionRating,omitempty"`
	// FeedbackLabels: Input only. The feedback labels associated with the
	// conversation.
	FeedbackLabels []*GoogleCloudContactcenterinsightsV1alpha1FeedbackLabel `json:"feedbackLabels,omitempty"`
	// MenuPath: An arbitrary string value specifying the menu path the customer
	// took.
	MenuPath string `json:"menuPath,omitempty"`
	// WaitDuration: The amount of time the customer waited to connect with an
	// agent.
	WaitDuration string `json:"waitDuration,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ConversationQualityMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationQualityMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ConversationQualityMetadataAgentInfo:
//
//	Information about an agent involved in the conversation.
type GoogleCloudContactcenterinsightsV1alpha1ConversationQualityMetadataAgentInfo struct {
	// AgentId: A user-specified string representing the agent.
	AgentId string `json:"agentId,omitempty"`
	// AgentType: The agent type, e.g. HUMAN_AGENT.
	//
	// Possible values:
	//   "ROLE_UNSPECIFIED" - Participant's role is not set.
	//   "HUMAN_AGENT" - Participant is a human agent.
	//   "AUTOMATED_AGENT" - Participant is an automated agent.
	//   "END_USER" - Participant is an end user who conversed with the contact
	// center.
	//   "ANY_AGENT" - Participant is either a human or automated agent.
	AgentType string `json:"agentType,omitempty"`
	// DeploymentDisplayName: The agent's deployment display name. Only applicable
	// to automated agents.
	DeploymentDisplayName string `json:"deploymentDisplayName,omitempty"`
	// DeploymentId: The agent's deployment ID. Only applicable to automated
	// agents.
	DeploymentId string `json:"deploymentId,omitempty"`
	// DisplayName: The agent's name.
	DisplayName string `json:"displayName,omitempty"`
	// DispositionCode: A user-provided string indicating the outcome of the
	// agent's segment of the call.
	DispositionCode string `json:"dispositionCode,omitempty"`
	// Location: The agent's location.
	Location string `json:"location,omitempty"`
	// Team: A user-specified string representing the agent's team. Deprecated in
	// favor of the `teams` field.
	Team string `json:"team,omitempty"`
	// Teams: User-specified strings representing the agent's teams.
	Teams []string `json:"teams,omitempty"`
	// VersionDisplayName: The agent's version display name. Only applicable to
	// automated agents.
	VersionDisplayName string `json:"versionDisplayName,omitempty"`
	// VersionId: The agent's version ID. Only applicable to automated agents.
	VersionId string `json:"versionId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ConversationQualityMetadataAgentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationQualityMetadataAgentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ConversationSummarizationSuggestionDa
// ta: Conversation summarization suggestion data.
type GoogleCloudContactcenterinsightsV1alpha1ConversationSummarizationSuggestionData struct {
	// AnswerRecord: The name of the answer record. Format:
	// projects/{project}/locations/{location}/answerRecords/{answer_record}
	AnswerRecord string `json:"answerRecord,omitempty"`
	// Confidence: The confidence score of the summarization.
	Confidence float64 `json:"confidence,omitempty"`
	// ConversationModel: The name of the model that generates this summary.
	// Format:
	// projects/{project}/locations/{location}/conversationModels/{conversation_mode
	// l}
	ConversationModel string `json:"conversationModel,omitempty"`
	// GeneratorId: Agent Assist generator ID.
	GeneratorId string `json:"generatorId,omitempty"`
	// Metadata: A map that contains metadata about the summarization and the
	// document from which it originates.
	Metadata map[string]string `json:"metadata,omitempty"`
	// Text: The summarization content that is concatenated into one string.
	Text string `json:"text,omitempty"`
	// TextSections: The summarization content that is divided into sections. The
	// key is the section's name and the value is the section's content. There is
	// no specific format for the key or value.
	TextSections map[string]string `json:"textSections,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ConversationSummarizationSuggestionData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationSummarizationSuggestionData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1ConversationSummarizationSuggestionData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationSummarizationSuggestionData
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1ConversationTranscript: A message
// representing the transcript of a conversation.
type GoogleCloudContactcenterinsightsV1alpha1ConversationTranscript struct {
	// TranscriptSegments: A list of sequential transcript segments that comprise
	// the conversation.
	TranscriptSegments []*GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegment `json:"transcriptSegments,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TranscriptSegments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TranscriptSegments") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ConversationTranscript) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationTranscript
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegme
// nt: A segment of a full transcript.
type GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegment struct {
	// ChannelTag: For conversations derived from multi-channel audio, this is the
	// channel number corresponding to the audio from that channel. For
	// audioChannelCount = N, its output values can range from '1' to 'N'. A
	// channel tag of 0 indicates that the audio is mono.
	ChannelTag int64 `json:"channelTag,omitempty"`
	// Confidence: A confidence estimate between 0.0 and 1.0 of the fidelity of
	// this segment. A default value of 0.0 indicates that the value is unset.
	Confidence float64 `json:"confidence,omitempty"`
	// DialogflowSegmentMetadata: CCAI metadata relating to the current transcript
	// segment.
	DialogflowSegmentMetadata *GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegmentDialogflowSegmentMetadata `json:"dialogflowSegmentMetadata,omitempty"`
	// LanguageCode: The language code of this segment as a BCP-47
	// (https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag. Example:
	// "en-US".
	LanguageCode string `json:"languageCode,omitempty"`
	// MessageTime: The time that the message occurred, if provided.
	MessageTime string `json:"messageTime,omitempty"`
	// SegmentParticipant: The participant of this segment.
	SegmentParticipant *GoogleCloudContactcenterinsightsV1alpha1ConversationParticipant `json:"segmentParticipant,omitempty"`
	// Sentiment: The sentiment for this transcript segment.
	Sentiment *GoogleCloudContactcenterinsightsV1alpha1SentimentData `json:"sentiment,omitempty"`
	// Text: The text of this segment.
	Text string `json:"text,omitempty"`
	// Words: A list of the word-specific information for each word in the segment.
	Words []*GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegmentWordInfo `json:"words,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChannelTag") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChannelTag") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegment) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegment
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegme
// ntDialogflowSegmentMetadata: Metadata from Dialogflow relating to the
// current transcript segment.
type GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegmentDialogflowSegmentMetadata struct {
	// SmartReplyAllowlistCovered: Whether the transcript segment was covered under
	// the configured smart reply allowlist in Agent Assist.
	SmartReplyAllowlistCovered bool `json:"smartReplyAllowlistCovered,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SmartReplyAllowlistCovered")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SmartReplyAllowlistCovered") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegmentDialogflowSegmentMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegmentDialogflowSegmentMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegme
// ntWordInfo: Word-level info for words in a transcript.
type GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegmentWordInfo struct {
	// Confidence: A confidence estimate between 0.0 and 1.0 of the fidelity of
	// this word. A default value of 0.0 indicates that the value is unset.
	Confidence float64 `json:"confidence,omitempty"`
	// EndOffset: Time offset of the end of this word relative to the beginning of
	// the total conversation.
	EndOffset string `json:"endOffset,omitempty"`
	// StartOffset: Time offset of the start of this word relative to the beginning
	// of the total conversation.
	StartOffset string `json:"startOffset,omitempty"`
	// Word: The word itself. Includes punctuation marks that surround the word.
	Word string `json:"word,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegmentWordInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegmentWordInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegmentWordInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegmentWordInfo
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1CreateAnalysisOperationMetadata:
// Metadata for a create analysis operation.
type GoogleCloudContactcenterinsightsV1alpha1CreateAnalysisOperationMetadata struct {
	// AnnotatorSelector: Output only. The annotator selector used for the analysis
	// (if any).
	AnnotatorSelector *GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelector `json:"annotatorSelector,omitempty"`
	// Conversation: Output only. The Conversation that this Analysis Operation
	// belongs to.
	Conversation string `json:"conversation,omitempty"`
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotatorSelector") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotatorSelector") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1CreateAnalysisOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1CreateAnalysisOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1CreateIssueMetadata: Metadata for
// creating an issue.
type GoogleCloudContactcenterinsightsV1alpha1CreateIssueMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original request for creation.
	Request *GoogleCloudContactcenterinsightsV1alpha1CreateIssueRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1CreateIssueMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1CreateIssueMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1CreateIssueModelMetadata: Metadata
// for creating an issue model.
type GoogleCloudContactcenterinsightsV1alpha1CreateIssueModelMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original request for creation.
	Request *GoogleCloudContactcenterinsightsV1alpha1CreateIssueModelRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1CreateIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1CreateIssueModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1CreateIssueModelRequest: The request
// to create an issue model.
type GoogleCloudContactcenterinsightsV1alpha1CreateIssueModelRequest struct {
	// IssueModel: Required. The issue model to create.
	IssueModel *GoogleCloudContactcenterinsightsV1alpha1IssueModel `json:"issueModel,omitempty"`
	// Parent: Required. The parent resource of the issue model.
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IssueModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IssueModel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1CreateIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1CreateIssueModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1CreateIssueRequest: The request to
// create an issue.
type GoogleCloudContactcenterinsightsV1alpha1CreateIssueRequest struct {
	// Issue: Required. The values for the new issue.
	Issue *GoogleCloudContactcenterinsightsV1alpha1Issue `json:"issue,omitempty"`
	// Parent: Required. The parent resource of the issue.
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Issue") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Issue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1CreateIssueRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1CreateIssueRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1Dataset: Dataset resource represents
// a collection of conversations that may be bounded (Static Dataset, e.g.
// golden dataset for training), or unbounded (Dynamic Dataset, e.g. live
// traffic, or agent training traffic)
type GoogleCloudContactcenterinsightsV1alpha1Dataset struct {
	// CreateTime: Output only. Dataset create time.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Dataset description.
	Description string `json:"description,omitempty"`
	// DisplayName: Display name for the dataaset
	DisplayName string `json:"displayName,omitempty"`
	// Name: Immutable. Identifier. Resource name of the dataset. Format:
	// projects/{project}/locations/{location}/datasets/{dataset}
	Name string `json:"name,omitempty"`
	// Ttl: Optional. Option TTL for the dataset.
	Ttl string `json:"ttl,omitempty"`
	// Type: Dataset usage type.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Default value for unspecified.
	//   "EVAL" - For evals only.
	//   "LIVE" - Dataset with new conversations coming in regularly (Insights
	// legacy conversations and AI trainer)
	Type string `json:"type,omitempty"`
	// UpdateTime: Output only. Dataset update time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1Dataset) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1Dataset
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DeleteIssueModelMetadata: Metadata
// for deleting an issue model.
type GoogleCloudContactcenterinsightsV1alpha1DeleteIssueModelMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original request for deletion.
	Request *GoogleCloudContactcenterinsightsV1alpha1DeleteIssueModelRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1DeleteIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DeleteIssueModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DeleteIssueModelRequest: The request
// to delete an issue model.
type GoogleCloudContactcenterinsightsV1alpha1DeleteIssueModelRequest struct {
	// Name: Required. The name of the issue model to delete.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1DeleteIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DeleteIssueModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DeleteQaQuestionTagMetadata: The
// metadata for deleting a QaQuestionTag Resource.
type GoogleCloudContactcenterinsightsV1alpha1DeleteQaQuestionTagMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: Output only. The original request.
	Request *GoogleCloudContactcenterinsightsV1alpha1DeleteQaQuestionTagRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1DeleteQaQuestionTagMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DeleteQaQuestionTagMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DeleteQaQuestionTagRequest: The
// request for deleting a QaQuestionTag.
type GoogleCloudContactcenterinsightsV1alpha1DeleteQaQuestionTagRequest struct {
	// Name: Required. The name of the QaQuestionTag to delete.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1DeleteQaQuestionTagRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DeleteQaQuestionTagRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelMetadata: Metadata
// for deploying an issue model.
type GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original request for deployment.
	Request *GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelRequest: The request
// to deploy an issue model.
type GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelRequest struct {
	// Name: Required. The issue model to deploy.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelResponse: The
// response to deploy an issue model.
type GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelResponse struct {
}

// GoogleCloudContactcenterinsightsV1alpha1DialogflowIntent: The data for a
// Dialogflow intent. Represents a detected intent in the conversation, e.g.
// MAKES_PROMISE.
type GoogleCloudContactcenterinsightsV1alpha1DialogflowIntent struct {
	// DisplayName: The human-readable name of the intent.
	DisplayName string `json:"displayName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1DialogflowIntent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DialogflowIntent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DialogflowInteractionData:
// Dialogflow interaction data.
type GoogleCloudContactcenterinsightsV1alpha1DialogflowInteractionData struct {
	// Confidence: The confidence of the match ranging from 0.0 (completely
	// uncertain) to 1.0 (completely certain).
	Confidence float64 `json:"confidence,omitempty"`
	// DialogflowIntentId: The Dialogflow intent resource path. Format:
	// projects/{project}/agent/{agent}/intents/{intent}
	DialogflowIntentId string `json:"dialogflowIntentId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1DialogflowInteractionData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DialogflowInteractionData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1DialogflowInteractionData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DialogflowInteractionData
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1DialogflowSource: A Dialogflow
// source of conversation data.
type GoogleCloudContactcenterinsightsV1alpha1DialogflowSource struct {
	// AudioUri: Cloud Storage URI that points to a file that contains the
	// conversation audio.
	AudioUri string `json:"audioUri,omitempty"`
	// DialogflowConversation: Output only. The name of the Dialogflow conversation
	// that this conversation resource is derived from. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}
	DialogflowConversation string `json:"dialogflowConversation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1DialogflowSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DialogflowSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1Dimension: A dimension determines
// the grouping key for the query. In SQL terms, these would be part of both
// the "SELECT" and "GROUP BY" clauses.
type GoogleCloudContactcenterinsightsV1alpha1Dimension struct {
	// AgentDimensionMetadata: Output only. Metadata about the agent dimension.
	AgentDimensionMetadata *GoogleCloudContactcenterinsightsV1alpha1DimensionAgentDimensionMetadata `json:"agentDimensionMetadata,omitempty"`
	// ClientSentimentCategoryDimensionMetadata: Output only. Metadata about the
	// client sentiment category dimension.
	ClientSentimentCategoryDimensionMetadata *GoogleCloudContactcenterinsightsV1alpha1DimensionClientSentimentCategoryDimensionMetadata `json:"clientSentimentCategoryDimensionMetadata,omitempty"`
	// ConversationProfileDimensionMetadata: Output only. Metadata about the
	// conversation profile dimension.
	ConversationProfileDimensionMetadata *GoogleCloudContactcenterinsightsV1alpha1DimensionConversationProfileDimensionMetadata `json:"conversationProfileDimensionMetadata,omitempty"`
	// ConversationalAgentsPlaybookDimensionMetadata: Output only. Metadata about
	// the Conversational Agents playbook dimension.
	ConversationalAgentsPlaybookDimensionMetadata *GoogleCloudContactcenterinsightsV1alpha1DimensionConversationalAgentsPlaybookDimensionMetadata `json:"conversationalAgentsPlaybookDimensionMetadata,omitempty"`
	// ConversationalAgentsToolDimensionMetadata: Output only. Metadata about the
	// Conversational Agents tool dimension.
	ConversationalAgentsToolDimensionMetadata *GoogleCloudContactcenterinsightsV1alpha1DimensionConversationalAgentsToolDimensionMetadata `json:"conversationalAgentsToolDimensionMetadata,omitempty"`
	// DimensionKey: The key of the dimension.
	//
	// Possible values:
	//   "DIMENSION_KEY_UNSPECIFIED" - The key of the dimension is unspecified.
	//   "ISSUE" - The dimension is keyed by issues.
	//   "ISSUE_NAME" - The dimension is keyed by issue names.
	//   "AGENT" - The dimension is keyed by agents.
	//   "AGENT_TEAM" - The dimension is keyed by agent teams.
	//   "QA_QUESTION_ID" - The dimension is keyed by QaQuestionIds. Note that: We
	// only group by the QuestionId and not the revision-id of the scorecard this
	// question is a part of. This allows for showing stats for the same question
	// across different scorecard revisions.
	//   "QA_QUESTION_ANSWER_VALUE" - The dimension is keyed by
	// QaQuestionIds-Answer value pairs. Note that: We only group by the QuestionId
	// and not the revision-id of the scorecard this question is a part of. This
	// allows for showing distribution of answers per question across different
	// scorecard revisions.
	//   "QA_SCORECARD_ID" - The dimension is keyed by QaScorecardIds. Note that:
	// We only group by the ScorecardId and not the revision-id of the scorecard.
	// This allows for showing stats for the same scorecard across different
	// revisions. This metric is mostly only useful if querying the average
	// normalized score per scorecard.
	//   "CONVERSATION_PROFILE_ID" - The dimension is keyed by the conversation
	// profile ID.
	//   "MEDIUM" - The dimension is keyed by the conversation medium.
	//   "CONVERSATIONAL_AGENTS_PLAYBOOK_ID" - The dimension is keyed by the
	// Conversational Agents playbook ID.
	//   "CONVERSATIONAL_AGENTS_PLAYBOOK_NAME" - The dimension is keyed by the
	// Conversational Agents playbook display name.
	//   "CONVERSATIONAL_AGENTS_TOOL_ID" - The dimension is keyed by the
	// Conversational Agents tool ID.
	//   "CONVERSATIONAL_AGENTS_TOOL_NAME" - The dimension is keyed by the
	// Conversational Agents tool display name.
	//   "CLIENT_SENTIMENT_CATEGORY" - The dimension is keyed by the client
	// sentiment category.
	//   "AGENT_VERSION_ID" - The dimension is keyed by the agent version ID.
	//   "AGENT_DEPLOYMENT_ID" - The dimension is keyed by the agent deployment ID.
	//   "AGENT_ASSIST_SUPERVISOR_ID" - The dimension is keyed by the supervisor ID
	// of the assigned human supervisor for virtual agents.
	//   "LABEL_KEY" - The dimension is keyed by label keys.
	//   "LABEL_VALUE" - The dimension is keyed by label values.
	//   "LABEL_KEY_AND_VALUE" - The dimension is keyed by label key-value pairs.
	DimensionKey string `json:"dimensionKey,omitempty"`
	// IssueDimensionMetadata: Output only. Metadata about the issue dimension.
	IssueDimensionMetadata *GoogleCloudContactcenterinsightsV1alpha1DimensionIssueDimensionMetadata `json:"issueDimensionMetadata,omitempty"`
	// LabelDimensionMetadata: Output only. Metadata about conversation labels.
	LabelDimensionMetadata *GoogleCloudContactcenterinsightsV1alpha1DimensionLabelDimensionMetadata `json:"labelDimensionMetadata,omitempty"`
	// MediumDimensionMetadata: Output only. Metadata about the conversation medium
	// dimension.
	MediumDimensionMetadata *GoogleCloudContactcenterinsightsV1alpha1DimensionMediumDimensionMetadata `json:"mediumDimensionMetadata,omitempty"`
	// QaQuestionAnswerDimensionMetadata: Output only. Metadata about the QA
	// question-answer dimension.
	QaQuestionAnswerDimensionMetadata *GoogleCloudContactcenterinsightsV1alpha1DimensionQaQuestionAnswerDimensionMetadata `json:"qaQuestionAnswerDimensionMetadata,omitempty"`
	// QaQuestionDimensionMetadata: Output only. Metadata about the QA question
	// dimension.
	QaQuestionDimensionMetadata *GoogleCloudContactcenterinsightsV1alpha1DimensionQaQuestionDimensionMetadata `json:"qaQuestionDimensionMetadata,omitempty"`
	// QaScorecardDimensionMetadata: Output only. Metadata about the QA scorecard
	// dimension.
	QaScorecardDimensionMetadata *GoogleCloudContactcenterinsightsV1alpha1DimensionQaScorecardDimensionMetadata `json:"qaScorecardDimensionMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentDimensionMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentDimensionMetadata") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1Dimension) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1Dimension
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DimensionAgentDimensionMetadata:
// Metadata about the agent dimension.
type GoogleCloudContactcenterinsightsV1alpha1DimensionAgentDimensionMetadata struct {
	// AgentDeploymentDisplayName: Optional. The agent's deployment display name.
	// Only applicable to automated agents. This will be populated for
	// AGENT_DEPLOYMENT_ID dimensions.
	AgentDeploymentDisplayName string `json:"agentDeploymentDisplayName,omitempty"`
	// AgentDeploymentId: Optional. The agent's deployment ID. Only applicable to
	// automated agents. This will be populated for AGENT and AGENT_DEPLOYMENT_ID
	// dimensions.
	AgentDeploymentId string `json:"agentDeploymentId,omitempty"`
	// AgentDisplayName: Optional. The agent's name This will be populated for
	// AGENT, AGENT_TEAM, AGENT_VERSION_ID, and AGENT_DEPLOYMENT_ID dimensions.
	AgentDisplayName string `json:"agentDisplayName,omitempty"`
	// AgentId: Optional. A user-specified string representing the agent. This will
	// be populated for AGENT, AGENT_TEAM, AGENT_VERSION_ID, and
	// AGENT_DEPLOYMENT_ID dimensions.
	AgentId string `json:"agentId,omitempty"`
	// AgentTeam: Optional. A user-specified string representing the agent's team.
	AgentTeam string `json:"agentTeam,omitempty"`
	// AgentVersionDisplayName: Optional. The agent's version display name. Only
	// applicable to automated agents. This will be populated for AGENT_VERSION_ID,
	// and AGENT_DEPLOYMENT_ID dimensions.
	AgentVersionDisplayName string `json:"agentVersionDisplayName,omitempty"`
	// AgentVersionId: Optional. The agent's version ID. Only applicable to
	// automated agents. This will be populated for AGENT_VERSION_ID, and
	// AGENT_DEPLOYMENT_ID dimensions.
	AgentVersionId string `json:"agentVersionId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentDeploymentDisplayName")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentDeploymentDisplayName") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1DimensionAgentDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DimensionAgentDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DimensionClientSentimentCategoryDimen
// sionMetadata: Metadata about the client sentiment category dimension.
type GoogleCloudContactcenterinsightsV1alpha1DimensionClientSentimentCategoryDimensionMetadata struct {
	// SentimentCategory: Optional. The client sentiment category.
	SentimentCategory string `json:"sentimentCategory,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SentimentCategory") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SentimentCategory") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1DimensionClientSentimentCategoryDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DimensionClientSentimentCategoryDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DimensionConversationProfileDimension
// Metadata: Metadata about the conversation profile dimension.
type GoogleCloudContactcenterinsightsV1alpha1DimensionConversationProfileDimensionMetadata struct {
	// ConversationProfileId: Optional. The conversation profile ID.
	ConversationProfileId string `json:"conversationProfileId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationProfileId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationProfileId") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1DimensionConversationProfileDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DimensionConversationProfileDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DimensionConversationalAgentsPlaybook
// DimensionMetadata: Metadata about the Conversational Agents playbook
// dimension.
type GoogleCloudContactcenterinsightsV1alpha1DimensionConversationalAgentsPlaybookDimensionMetadata struct {
	// PlaybookDisplayName: Optional. The dialogflow playbook display name.
	PlaybookDisplayName string `json:"playbookDisplayName,omitempty"`
	// PlaybookId: Optional. The dialogflow playbook ID.
	PlaybookId string `json:"playbookId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PlaybookDisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PlaybookDisplayName") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1DimensionConversationalAgentsPlaybookDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DimensionConversationalAgentsPlaybookDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DimensionConversationalAgentsToolDime
// nsionMetadata: Metadata about the Conversational Agents tool dimension.
type GoogleCloudContactcenterinsightsV1alpha1DimensionConversationalAgentsToolDimensionMetadata struct {
	// ToolDisplayName: Optional. The dialogflow tool display name.
	ToolDisplayName string `json:"toolDisplayName,omitempty"`
	// ToolId: Optional. The dialogflow tool ID.
	ToolId string `json:"toolId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ToolDisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ToolDisplayName") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1DimensionConversationalAgentsToolDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DimensionConversationalAgentsToolDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DimensionIssueDimensionMetadata:
// Metadata about the issue dimension.
type GoogleCloudContactcenterinsightsV1alpha1DimensionIssueDimensionMetadata struct {
	// IssueDisplayName: The issue display name.
	IssueDisplayName string `json:"issueDisplayName,omitempty"`
	// IssueId: The issue ID.
	IssueId string `json:"issueId,omitempty"`
	// IssueModelId: The parent issue model ID.
	IssueModelId string `json:"issueModelId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IssueDisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IssueDisplayName") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1DimensionIssueDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DimensionIssueDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DimensionLabelDimensionMetadata:
// Metadata about conversation labels.
type GoogleCloudContactcenterinsightsV1alpha1DimensionLabelDimensionMetadata struct {
	// LabelKey: Optional. The label key.
	LabelKey string `json:"labelKey,omitempty"`
	// LabelValue: Optional. The label value.
	LabelValue string `json:"labelValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LabelKey") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LabelKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1DimensionLabelDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DimensionLabelDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DimensionMediumDimensionMetadata:
// Metadata about the conversation medium dimension.
type GoogleCloudContactcenterinsightsV1alpha1DimensionMediumDimensionMetadata struct {
	// Medium: Optional. The conversation medium. Currently supports : PHONE_CALL,
	// CHAT.
	Medium string `json:"medium,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Medium") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Medium") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1DimensionMediumDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DimensionMediumDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DimensionQaQuestionAnswerDimensionMet
// adata: Metadata about the QA question-answer dimension. This is useful for
// showing the answer distribution for questions for a given scorecard.
type GoogleCloudContactcenterinsightsV1alpha1DimensionQaQuestionAnswerDimensionMetadata struct {
	// AnswerValue: Optional. The full body of the question.
	AnswerValue string `json:"answerValue,omitempty"`
	// QaQuestionId: Optional. The QA question ID.
	QaQuestionId string `json:"qaQuestionId,omitempty"`
	// QaScorecardId: Optional. The QA scorecard ID.
	QaScorecardId string `json:"qaScorecardId,omitempty"`
	// QuestionBody: Optional. The full body of the question.
	QuestionBody string `json:"questionBody,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1DimensionQaQuestionAnswerDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DimensionQaQuestionAnswerDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DimensionQaQuestionDimensionMetadata:
//
//	Metadata about the QA question dimension.
type GoogleCloudContactcenterinsightsV1alpha1DimensionQaQuestionDimensionMetadata struct {
	// QaQuestionId: Optional. The QA question ID.
	QaQuestionId string `json:"qaQuestionId,omitempty"`
	// QaScorecardId: Optional. The QA scorecard ID.
	QaScorecardId string `json:"qaScorecardId,omitempty"`
	// QuestionBody: Optional. The full body of the question.
	QuestionBody string `json:"questionBody,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QaQuestionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QaQuestionId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1DimensionQaQuestionDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DimensionQaQuestionDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DimensionQaScorecardDimensionMetadata
// : Metadata about the QA scorecard dimension.
type GoogleCloudContactcenterinsightsV1alpha1DimensionQaScorecardDimensionMetadata struct {
	// QaScorecardId: Optional. The QA scorecard ID.
	QaScorecardId string `json:"qaScorecardId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QaScorecardId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QaScorecardId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1DimensionQaScorecardDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DimensionQaScorecardDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1EncryptionSpec: A customer-managed
// encryption key specification that can be applied to all created resources
// (e.g. `Conversation`).
type GoogleCloudContactcenterinsightsV1alpha1EncryptionSpec struct {
	// KmsKey: Required. The name of customer-managed encryption key that is used
	// to secure a resource and its sub-resources. If empty, the resource is
	// secured by our default encryption key. Only the key in the same location as
	// this resource is allowed to be used for encryption. Format:
	// `projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{key}`
	KmsKey string `json:"kmsKey,omitempty"`
	// Name: Immutable. The resource name of the encryption key specification
	// resource. Format: projects/{project}/locations/{location}/encryptionSpec
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "KmsKey") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "KmsKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1EncryptionSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1EncryptionSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1Entity: The data for an entity
// annotation. Represents a phrase in the conversation that is a known entity,
// such as a person, an organization, or location.
type GoogleCloudContactcenterinsightsV1alpha1Entity struct {
	// DisplayName: The representative name for the entity.
	DisplayName string `json:"displayName,omitempty"`
	// Metadata: Metadata associated with the entity. For most entity types, the
	// metadata is a Wikipedia URL (`wikipedia_url`) and Knowledge Graph MID
	// (`mid`), if they are available. For the metadata associated with other
	// entity types, see the Type table below.
	Metadata map[string]string `json:"metadata,omitempty"`
	// Salience: The salience score associated with the entity in the [0, 1.0]
	// range. The salience score for an entity provides information about the
	// importance or centrality of that entity to the entire document text. Scores
	// closer to 0 are less salient, while scores closer to 1.0 are highly salient.
	Salience float64 `json:"salience,omitempty"`
	// Sentiment: The aggregate sentiment expressed for this entity in the
	// conversation.
	Sentiment *GoogleCloudContactcenterinsightsV1alpha1SentimentData `json:"sentiment,omitempty"`
	// Type: The entity type.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unspecified.
	//   "PERSON" - Person.
	//   "LOCATION" - Location.
	//   "ORGANIZATION" - Organization.
	//   "EVENT" - Event.
	//   "WORK_OF_ART" - Artwork.
	//   "CONSUMER_GOOD" - Consumer product.
	//   "OTHER" - Other types of entities.
	//   "PHONE_NUMBER" - Phone number. The metadata lists the phone number
	// (formatted according to local convention), plus whichever additional
	// elements appear in the text: * `number` - The actual number, broken down
	// into sections according to local convention. * `national_prefix` - Country
	// code, if detected. * `area_code` - Region or area code, if detected. *
	// `extension` - Phone extension (to be dialed after connection), if detected.
	//   "ADDRESS" - Address. The metadata identifies the street number and
	// locality plus whichever additional elements appear in the text: *
	// `street_number` - Street number. * `locality` - City or town. *
	// `street_name` - Street/route name, if detected. * `postal_code` - Postal
	// code, if detected. * `country` - Country, if detected. * `broad_region` -
	// Administrative area, such as the state, if detected. * `narrow_region` -
	// Smaller administrative area, such as county, if detected. * `sublocality` -
	// Used in Asian addresses to demark a district within a city, if detected.
	//   "DATE" - Date. The metadata identifies the components of the date: *
	// `year` - Four digit year, if detected. * `month` - Two digit month number,
	// if detected. * `day` - Two digit day number, if detected.
	//   "NUMBER" - Number. The metadata is the number itself.
	//   "PRICE" - Price. The metadata identifies the `value` and `currency`.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1Entity) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1Entity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1Entity) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1Entity
	var s1 struct {
		Salience gensupport.JSONFloat64 `json:"salience"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Salience = float64(s1.Salience)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1EntityMentionData: The data for an
// entity mention annotation. This represents a mention of an `Entity` in the
// conversation.
type GoogleCloudContactcenterinsightsV1alpha1EntityMentionData struct {
	// EntityUniqueId: The key of this entity in conversation entities. Can be used
	// to retrieve the exact `Entity` this mention is attached to.
	EntityUniqueId string `json:"entityUniqueId,omitempty"`
	// Sentiment: Sentiment expressed for this mention of the entity.
	Sentiment *GoogleCloudContactcenterinsightsV1alpha1SentimentData `json:"sentiment,omitempty"`
	// Type: The type of the entity mention.
	//
	// Possible values:
	//   "MENTION_TYPE_UNSPECIFIED" - Unspecified.
	//   "PROPER" - Proper noun.
	//   "COMMON" - Common noun (or noun compound).
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityUniqueId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityUniqueId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1EntityMentionData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1EntityMentionData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataMetadata: Metadata
// for an export insights operation.
type GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataMetadata struct {
	// CompletedExportCount: The number of conversations that were exported
	// successfully.
	CompletedExportCount int64 `json:"completedExportCount,omitempty"`
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// FailedExportCount: The number of conversations that failed to be exported.
	FailedExportCount int64 `json:"failedExportCount,omitempty"`
	// PartialErrors: Partial errors during export operation that might cause the
	// operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: The original request for export.
	Request *GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompletedExportCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompletedExportCount") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataRequest: The
// request to export insights.
type GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataRequest struct {
	// BigQueryDestination: Specified if sink is a BigQuery table.
	BigQueryDestination *GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataRequestBigQueryDestination `json:"bigQueryDestination,omitempty"`
	// ExportSchemaVersion: Optional. Version of the export schema.
	//
	// Possible values:
	//   "EXPORT_SCHEMA_VERSION_UNSPECIFIED" - Unspecified. Defaults to EXPORT_V3.
	//   "EXPORT_V1" - Export schema version 1.
	//   "EXPORT_V2" - Export schema version 2.
	//   "EXPORT_V3" - Export schema version 3.
	//   "EXPORT_V4" - Export schema version 4.
	//   "EXPORT_V5" - Export schema version 5.
	//   "EXPORT_V6" - Export schema version 6.
	//   "EXPORT_V7" - Export schema version 7.
	//   "EXPORT_V8" - Export schema version 8.
	//   "EXPORT_V9" - Export schema version 9.
	//   "EXPORT_V10" - Export schema version 10.
	//   "EXPORT_V11" - Export schema version 11.
	//   "EXPORT_V12" - Export schema version 12.
	//   "EXPORT_V13" - Export schema version 13.
	//   "EXPORT_V14" - Export schema version 14.
	//   "EXPORT_V15" - Export schema version 15.
	//   "EXPORT_V16" - Export schema version 16.
	//   "EXPORT_V17" - Export schema version 17.
	//   "EXPORT_VERSION_LATEST_AVAILABLE" - Export schema version latest
	// available.
	ExportSchemaVersion string `json:"exportSchemaVersion,omitempty"`
	// Filter: A filter to reduce results to a specific subset. Useful for
	// exporting conversations with specific properties.
	Filter string `json:"filter,omitempty"`
	// KmsKey: A fully qualified KMS key name for BigQuery tables protected by
	// CMEK. Format:
	// projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}/c
	// ryptoKeyVersions/{version}
	KmsKey string `json:"kmsKey,omitempty"`
	// Parent: Required. The parent resource to export data from.
	Parent string `json:"parent,omitempty"`
	// WriteDisposition: Options for what to do if the destination table already
	// exists.
	//
	// Possible values:
	//   "WRITE_DISPOSITION_UNSPECIFIED" - Write disposition is not specified.
	// Defaults to WRITE_TRUNCATE.
	//   "WRITE_TRUNCATE" - If the table already exists, BigQuery will overwrite
	// the table data and use the schema from the load.
	//   "WRITE_APPEND" - If the table already exists, BigQuery will append data to
	// the table.
	WriteDisposition string `json:"writeDisposition,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigQueryDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigQueryDestination") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataRequestBigQueryDest
// ination: A BigQuery Table Reference.
type GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataRequestBigQueryDestination struct {
	// Dataset: Required. The name of the BigQuery dataset that the snapshot result
	// should be exported to. If this dataset does not exist, the export call
	// returns an INVALID_ARGUMENT error.
	Dataset string `json:"dataset,omitempty"`
	// ProjectId: A project ID or number. If specified, then export will attempt to
	// write data to this project instead of the resource project. Otherwise, the
	// resource project will be used.
	ProjectId string `json:"projectId,omitempty"`
	// Table: The BigQuery table name to which the insights data should be written.
	// If this table does not exist, the export call returns an INVALID_ARGUMENT
	// error.
	Table string `json:"table,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dataset") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dataset") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataRequestBigQueryDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataRequestBigQueryDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataResponse: Response
// for an export insights operation.
type GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataResponse struct {
}

// GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelMetadata: Metadata
// used for export issue model.
type GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelMetadata struct {
	// CreateTime: The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original export request.
	Request *GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelRequest: Request to
// export an issue model.
type GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelRequest struct {
	// GcsDestination: Google Cloud Storage URI to export the issue model to.
	GcsDestination *GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelRequestGcsDestination `json:"gcsDestination,omitempty"`
	// Name: Required. The issue model to export.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsDestination") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelRequestGcsDestination
// : Google Cloud Storage Object URI to save the issue model to.
type GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelRequestGcsDestination struct {
	// ObjectUri: Required. Format: `gs:///`
	ObjectUri string `json:"objectUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ObjectUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ObjectUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelRequestGcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelRequestGcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelResponse: Response
// from export issue model
type GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelResponse struct {
}

// GoogleCloudContactcenterinsightsV1alpha1FaqAnswerData: Agent Assist
// frequently-asked-question answer data.
type GoogleCloudContactcenterinsightsV1alpha1FaqAnswerData struct {
	// Answer: The piece of text from the `source` knowledge base document.
	Answer string `json:"answer,omitempty"`
	// ConfidenceScore: The system's confidence score that this answer is a good
	// match for this conversation, ranging from 0.0 (completely uncertain) to 1.0
	// (completely certain).
	ConfidenceScore float64 `json:"confidenceScore,omitempty"`
	// Metadata: Map that contains metadata about the FAQ answer and the document
	// that it originates from.
	Metadata map[string]string `json:"metadata,omitempty"`
	// QueryRecord: The name of the answer record. Format:
	// projects/{project}/locations/{location}/answerRecords/{answer_record}
	QueryRecord string `json:"queryRecord,omitempty"`
	// Question: The corresponding FAQ question.
	Question string `json:"question,omitempty"`
	// Source: The knowledge document that this answer was extracted from. Format:
	// projects/{project}/knowledgeBases/{knowledge_base}/documents/{document}.
	Source string `json:"source,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Answer") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Answer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1FaqAnswerData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1FaqAnswerData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1FaqAnswerData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1FaqAnswerData
	var s1 struct {
		ConfidenceScore gensupport.JSONFloat64 `json:"confidenceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceScore = float64(s1.ConfidenceScore)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1FeedbackLabel: Represents a
// conversation, resource, and label provided by the user. Can take the form of
// a string label or a QaAnswer label. QaAnswer labels are used for Quality AI
// example conversations. String labels are used for Topic Modeling.
// AgentAssistSummary labels are used for Agent Assist Summarization.
type GoogleCloudContactcenterinsightsV1alpha1FeedbackLabel struct {
	// CreateTime: Output only. Create time of the label.
	CreateTime string `json:"createTime,omitempty"`
	// Label: String label used for Topic Modeling.
	Label string `json:"label,omitempty"`
	// LabeledResource: Name of the resource to be labeled. Supported resources
	// are: *
	// `projects/{project}/locations/{location}/qaScorecards/{scorecard}/revisions/{
	// revision}/qaQuestions/{question}` *
	// `projects/{project}/locations/{location}/issueModels/{issue_model}` *
	// `projects/{project}/locations/{location}/generators/{generator_id}`
	LabeledResource string `json:"labeledResource,omitempty"`
	// Name: Immutable. Resource name of the FeedbackLabel. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}/feedback
	// Labels/{feedback_label}
	Name string `json:"name,omitempty"`
	// QaAnswerLabel: QaAnswer label used for Quality AI example conversations.
	QaAnswerLabel *GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerValue `json:"qaAnswerLabel,omitempty"`
	// UpdateTime: Output only. Update time of the label.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1FeedbackLabel) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1FeedbackLabel
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1GcsSource: A Cloud Storage source of
// conversation data.
type GoogleCloudContactcenterinsightsV1alpha1GcsSource struct {
	// AudioUri: Cloud Storage URI that points to a file that contains the
	// conversation audio.
	AudioUri string `json:"audioUri,omitempty"`
	// TranscriptUri: Immutable. Cloud Storage URI that points to a file that
	// contains the conversation transcript.
	TranscriptUri string `json:"transcriptUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1GcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1GcsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightConversationTranscri
// pt: The conversation transcript for the chart.
type GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightConversationTranscript struct {
	// ConversationId: The conversation id of the chart.
	ConversationId string `json:"conversationId,omitempty"`
	// CreateTime: Output only. The create time of the conversation.
	CreateTime string `json:"createTime,omitempty"`
	// Messages: Ordered list of messages, including user inputs and system
	// responses.
	Messages []*GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightConversationTranscriptMessage `json:"messages,omitempty"`
	// UpdateTime: Output only. The update time of the conversation.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightConversationTranscript) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightConversationTranscript
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightConversationTranscri
// ptMessage: The message in the conversation.
type GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightConversationTranscriptMessage struct {
	// CreateTime: Output only. For user messages, this is the time at which the
	// system received the message. For system messages, this is the time at which
	// the system generated the message.
	CreateTime string `json:"createTime,omitempty"`
	// MessageId: The message id of the message.
	MessageId string `json:"messageId,omitempty"`
	// SystemMessageWrapper: A wrapper for system messages per turn.
	SystemMessageWrapper *GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightConversationTranscriptMessageSystemMessages `json:"systemMessageWrapper,omitempty"`
	// UserMessage: A message from the user that is interacting with the system.
	UserMessage *GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightConversationTranscriptMessageUserMessage `json:"userMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightConversationTranscriptMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightConversationTranscriptMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightConversationTranscri
// ptMessageSystemMessage: A message from the system in response to the user.
// This message can also be a message from the user as historical context for
// multiturn conversations with the system.
type GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightConversationTranscriptMessageSystemMessage struct {
	// ChartSpec: Chart spec from LLM
	ChartSpec googleapi.RawMessage `json:"chartSpec,omitempty"`
	// GeneratedSqlQuery: Raw SQL from LLM, before templatization
	GeneratedSqlQuery string `json:"generatedSqlQuery,omitempty"`
	// TextMessage: A direct natural language response to the user message.
	TextMessage *GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightConversationTranscriptMessageSystemMessageTextOutput `json:"textMessage,omitempty"`
	// UserProvidedChartSpec: Optional. User provided chart spec
	UserProvidedChartSpec googleapi.RawMessage `json:"userProvidedChartSpec,omitempty"`
	// UserProvidedSqlQuery: Optional. User provided SQL query
	UserProvidedSqlQuery string `json:"userProvidedSqlQuery,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChartSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChartSpec") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightConversationTranscriptMessageSystemMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightConversationTranscriptMessageSystemMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightConversationTranscri
// ptMessageSystemMessageTextOutput: A text output message from the system.
type GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightConversationTranscriptMessageSystemMessageTextOutput struct {
	// Text: The parts of the message.
	Text []string `json:"text,omitempty"`
	// TextType: The type of the text message.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - The default text type.
	//   "THOUGHT" - The text is a thinking plan generated by the thinking tool.
	//   "FINAL_RESPONSE" - The text is a final response to the user question.
	//   "PROGRESS" - The text is an informational message about the agent's
	// progress, such as a tool being invoked. This is distinct from the agent's
	// internal thought process (`THOUGHT`) and the final answer to the user
	// (`FINAL_RESPONSE`). These messages provide insight into the agent's actions.
	TextType string `json:"textType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightConversationTranscriptMessageSystemMessageTextOutput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightConversationTranscriptMessageSystemMessageTextOutput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightConversationTranscri
// ptMessageSystemMessages: A wrapper for system messages per turn.
type GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightConversationTranscriptMessageSystemMessages struct {
	// SystemMessages: A message from the system in response to the user.
	SystemMessages []*GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightConversationTranscriptMessageSystemMessage `json:"systemMessages,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SystemMessages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SystemMessages") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightConversationTranscriptMessageSystemMessages) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightConversationTranscriptMessageSystemMessages
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightConversationTranscri
// ptMessageUserMessage: The user message.
type GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightConversationTranscriptMessageUserMessage struct {
	// Text: A message from the user that is interacting with the system.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightConversationTranscriptMessageUserMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightConversationTranscriptMessageUserMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightsMetadata: The
// metadata for generative insights.
type GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightsMetadata struct {
	// ErrorMessages: The error message when the generative insights request fails.
	ErrorMessages []*GoogleRpcStatus `json:"errorMessages,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorMessages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorMessages") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightsResponse: The
// response for generative insights.
type GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightsResponse struct {
	// GenerativeResponses: The full list of generative responses. Each response is
	// ordered by time.
	GenerativeResponses []*GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightsResponseGenerativeResponse `json:"generativeResponses,omitempty"`
	// Transcript: The transcript of the generative insights conversation.
	Transcript *GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightConversationTranscript `json:"transcript,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenerativeResponses") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenerativeResponses") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightsResponseGenerativeR
// esponse: Wrapper for storing the generative response for a chart.
type GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightsResponseGenerativeResponse struct {
	// ChartSpec: The chart spec for the data. This will be specified in the
	// vega-lite or vega format.
	ChartSpec googleapi.RawMessage `json:"chartSpec,omitempty"`
	// GeneratedSqlQuery: The generated SQL query from the LLM. Will be populated
	// during the chart building phase. The generated SQL will be cached in the
	// corresponding chart resource.
	GeneratedSqlQuery string `json:"generatedSqlQuery,omitempty"`
	// TextMessage: The text output from the LLM. Will be populated during the
	// chart building phase. For a reloaded chart, this will NOT be populated. May
	// contain THOUGHT or a FINAL response or some in-progress response.
	TextMessage *GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightsResponseGenerativeResponseTextOutput `json:"textMessage,omitempty"`
	// TextOutput: The text output from the LLM. Will be populated during the chart
	// building phase. For a reloaded chart, this will NOT be populated. May
	// contain THOUGHT or a FINAL response or some in-progress response.
	TextOutput string `json:"textOutput,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChartSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChartSpec") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightsResponseGenerativeResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightsResponseGenerativeResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightsResponseGenerativeR
// esponseTextOutput: Wrapper for text output.
type GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightsResponseGenerativeResponseTextOutput struct {
	// Text: The text output from the LLM.
	Text []string `json:"text,omitempty"`
	// TextType: The type of text output.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - The type is unspecified.
	//   "THOUGHT" - The text is part of LLM reasoning.
	//   "FINAL_RESPONSE" - The text is the final answer from LLM.
	//   "PROGRESS" - The text is an informational message about the agent's
	// progress, such as a tool being invoked. This is distinct from the agent's
	// internal thought process (`THOUGHT`) and the final answer to the user
	// (`FINAL_RESPONSE`). These messages provide insight into the agent's actions.
	TextType string `json:"textType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightsResponseGenerativeResponseTextOutput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1GenerativeInsightsResponseGenerativeResponseTextOutput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1HoldData: The data for a hold
// annotation.
type GoogleCloudContactcenterinsightsV1alpha1HoldData struct {
}

// GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelMetadata: Metadata
// used for import issue model.
type GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelMetadata struct {
	// CreateTime: The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original import request.
	Request *GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelRequest: Request to
// import an issue model.
type GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelRequest struct {
	// CreateNewModel: Optional. If set to true, will create an issue model from
	// the imported file with randomly generated IDs for the issue model and
	// corresponding issues. Otherwise, replaces an existing model with the same ID
	// as the file.
	CreateNewModel bool `json:"createNewModel,omitempty"`
	// GcsSource: Google Cloud Storage source message.
	GcsSource *GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelRequestGcsSource `json:"gcsSource,omitempty"`
	// Parent: Required. The parent resource of the issue model.
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateNewModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateNewModel") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelRequestGcsSource:
// Google Cloud Storage Object URI to get the issue model file from.
type GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelRequestGcsSource struct {
	// ObjectUri: Required. Format: `gs:///`
	ObjectUri string `json:"objectUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ObjectUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ObjectUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelRequestGcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelRequestGcsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelResponse: Response
// from import issue model
type GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelResponse struct {
	// IssueModel: The issue model that was imported.
	IssueModel *GoogleCloudContactcenterinsightsV1alpha1IssueModel `json:"issueModel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IssueModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IssueModel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1IngestConversationsMetadata: The
// metadata for an IngestConversations operation.
type GoogleCloudContactcenterinsightsV1alpha1IngestConversationsMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// IngestConversationsStats: Output only. Statistics for IngestConversations
	// operation.
	IngestConversationsStats *GoogleCloudContactcenterinsightsV1alpha1IngestConversationsMetadataIngestConversationsStats `json:"ingestConversationsStats,omitempty"`
	// PartialErrors: Output only. Partial errors during ingest operation that
	// might cause the operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: Output only. The original request for ingest.
	Request *GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequest `json:"request,omitempty"`
	// SampledConversations: Output only. Stores the conversation resources
	// produced by ingest sampling operations.
	SampledConversations []string `json:"sampledConversations,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1IngestConversationsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IngestConversationsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1IngestConversationsMetadataIngestConv
// ersationsStats: Statistics for IngestConversations operation.
type GoogleCloudContactcenterinsightsV1alpha1IngestConversationsMetadataIngestConversationsStats struct {
	// DuplicatesSkippedCount: Output only. The number of objects skipped because
	// another conversation with the same transcript uri had already been ingested.
	DuplicatesSkippedCount int64 `json:"duplicatesSkippedCount,omitempty"`
	// FailedIngestCount: Output only. The number of objects which were unable to
	// be ingested due to errors. The errors are populated in the partial_errors
	// field.
	FailedIngestCount int64 `json:"failedIngestCount,omitempty"`
	// ProcessedObjectCount: Output only. The number of objects processed during
	// the ingest operation.
	ProcessedObjectCount int64 `json:"processedObjectCount,omitempty"`
	// SuccessfulIngestCount: Output only. The number of new conversations added
	// during this ingest operation.
	SuccessfulIngestCount int64 `json:"successfulIngestCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DuplicatesSkippedCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DuplicatesSkippedCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1IngestConversationsMetadataIngestConversationsStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IngestConversationsMetadataIngestConversationsStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequest: The
// request to ingest conversations.
type GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequest struct {
	// ConversationConfig: Configuration that applies to all conversations.
	ConversationConfig *GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestConversationConfig `json:"conversationConfig,omitempty"`
	// GcsSource: A cloud storage bucket source. Note that any previously ingested
	// objects from the source will be skipped to avoid duplication.
	GcsSource *GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestGcsSource `json:"gcsSource,omitempty"`
	// Parent: Required. The parent resource for new conversations.
	Parent string `json:"parent,omitempty"`
	// RedactionConfig: Optional. DLP settings for transcript redaction. Optional,
	// will default to the config specified in Settings.
	RedactionConfig *GoogleCloudContactcenterinsightsV1alpha1RedactionConfig `json:"redactionConfig,omitempty"`
	// SampleSize: Optional. If set, this fields indicates the number of objects to
	// ingest from the Cloud Storage bucket. If empty, the entire bucket will be
	// ingested. Unless they are first deleted, conversations produced through
	// sampling won't be ingested by subsequent ingest requests.
	SampleSize int64 `json:"sampleSize,omitempty"`
	// SpeechConfig: Optional. Default Speech-to-Text configuration. Optional, will
	// default to the config specified in Settings.
	SpeechConfig *GoogleCloudContactcenterinsightsV1alpha1SpeechConfig `json:"speechConfig,omitempty"`
	// TranscriptObjectConfig: Configuration for when `source` contains
	// conversation transcripts.
	TranscriptObjectConfig *GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestTranscriptObjectConfig `json:"transcriptObjectConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestConversatio
// nConfig: Configuration that applies to all conversations.
type GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestConversationConfig struct {
	// AgentChannel: Optional. Indicates which of the channels, 1 or 2, contains
	// the agent. Note that this must be set for conversations to be properly
	// displayed and analyzed.
	AgentChannel int64 `json:"agentChannel,omitempty"`
	// AgentId: Optional. An opaque, user-specified string representing a human
	// agent who handled all conversations in the import. Note that this will be
	// overridden if per-conversation metadata is provided through the
	// `metadata_bucket_uri`.
	AgentId string `json:"agentId,omitempty"`
	// CustomerChannel: Optional. Indicates which of the channels, 1 or 2, contains
	// the agent. Note that this must be set for conversations to be properly
	// displayed and analyzed.
	CustomerChannel int64 `json:"customerChannel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentChannel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentChannel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestConversationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestConversationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestGcsSource:
// Configuration for Cloud Storage bucket sources.
type GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestGcsSource struct {
	// AudioBucketUri: Optional. The Cloud Storage path to the conversation audio
	// file. Note that: [1] Audio files will be transcribed if not already. [2]
	// Audio files and transcript files must be in separate buckets / folders. [3]
	// A source file and its corresponding audio file must share the same name to
	// be properly ingested, E.g. `gs://bucket/transcript/conversation1.json` and
	// `gs://bucket/audio/conversation1.mp3`.
	AudioBucketUri string `json:"audioBucketUri,omitempty"`
	// BucketObjectType: Optional. Specifies the type of the objects in
	// `bucket_uri`. Avoid passing this. This is inferred from the
	// `transcript_bucket_uri`, `audio_bucket_uri`.
	//
	// Possible values:
	//   "BUCKET_OBJECT_TYPE_UNSPECIFIED" - The object type is unspecified and will
	// default to `TRANSCRIPT`.
	//   "TRANSCRIPT" - The object is a transcript.
	//   "AUDIO" - The object is an audio file.
	BucketObjectType string `json:"bucketObjectType,omitempty"`
	// BucketUri: Optional. The Cloud Storage bucket containing source objects.
	// Avoid passing this. Pass this through one of `transcript_bucket_uri` or
	// `audio_bucket_uri`.
	BucketUri string `json:"bucketUri,omitempty"`
	// CustomMetadataKeys: Optional. Custom keys to extract as conversation labels
	// from metadata files in `metadata_bucket_uri`. Keys not included in this
	// field will be ignored. Note that there is a limit of 100 labels per
	// conversation.
	CustomMetadataKeys []string `json:"customMetadataKeys,omitempty"`
	// MetadataBucketUri: Optional. The Cloud Storage path to the conversation
	// metadata. Note that: [1] Metadata files are expected to be in JSON format.
	// [2] Metadata and source files (transcripts or audio) must be in separate
	// buckets / folders. [3] A source file and its corresponding metadata file
	// must share the same name to be properly ingested, E.g.
	// `gs://bucket/audio/conversation1.mp3` and
	// `gs://bucket/metadata/conversation1.json`.
	MetadataBucketUri string `json:"metadataBucketUri,omitempty"`
	// TranscriptBucketUri: Optional. The Cloud Storage path to the conversation
	// transcripts. Note that: [1] Transcript files are expected to be in JSON
	// format. [2] Transcript, audio, metadata files must be in separate buckets /
	// folders. [3] A source file and its corresponding metadata file must share
	// the same name to be properly ingested, E.g.
	// `gs://bucket/audio/conversation1.mp3` and
	// `gs://bucket/metadata/conversation1.json`.
	TranscriptBucketUri string `json:"transcriptBucketUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioBucketUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioBucketUri") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestGcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestGcsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestTranscriptO
// bjectConfig: Configuration for processing transcript objects.
type GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestTranscriptObjectConfig struct {
	// Medium: Required. The medium transcript objects represent.
	//
	// Possible values:
	//   "MEDIUM_UNSPECIFIED" - Default value for unspecified.
	//   "PHONE_CALL" - The format for conversations that took place over the
	// phone.
	//   "CHAT" - The format for conversations that took place over chat.
	Medium string `json:"medium,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Medium") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Medium") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestTranscriptObjectConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestTranscriptObjectConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1IngestConversationsResponse: The
// response to an IngestConversations operation.
type GoogleCloudContactcenterinsightsV1alpha1IngestConversationsResponse struct {
}

// GoogleCloudContactcenterinsightsV1alpha1InitializeEncryptionSpecMetadata:
// Metadata for initializing a location-level encryption specification.
type GoogleCloudContactcenterinsightsV1alpha1InitializeEncryptionSpecMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// PartialErrors: Partial errors during initializing operation that might cause
	// the operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: Output only. The original request for initialization.
	Request *GoogleCloudContactcenterinsightsV1alpha1InitializeEncryptionSpecRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1InitializeEncryptionSpecMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1InitializeEncryptionSpecMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1InitializeEncryptionSpecRequest: The
// request to initialize a location-level encryption specification.
type GoogleCloudContactcenterinsightsV1alpha1InitializeEncryptionSpecRequest struct {
	// EncryptionSpec: Required. The encryption spec used for CMEK encryption. It
	// is required that the kms key is in the same region as the endpoint. The same
	// key will be used for all provisioned resources, if encryption is available.
	// If the `kms_key_name` field is left empty, no encryption will be enforced.
	EncryptionSpec *GoogleCloudContactcenterinsightsV1alpha1EncryptionSpec `json:"encryptionSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EncryptionSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EncryptionSpec") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1InitializeEncryptionSpecRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1InitializeEncryptionSpecRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1InitializeEncryptionSpecResponse:
// The response to initialize a location-level encryption specification.
type GoogleCloudContactcenterinsightsV1alpha1InitializeEncryptionSpecResponse struct {
}

// GoogleCloudContactcenterinsightsV1alpha1Intent: The data for an intent.
// Represents a detected intent in the conversation, for example MAKES_PROMISE.
type GoogleCloudContactcenterinsightsV1alpha1Intent struct {
	// DisplayName: The human-readable name of the intent.
	DisplayName string `json:"displayName,omitempty"`
	// Id: The unique identifier of the intent.
	Id string `json:"id,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1Intent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1Intent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1IntentMatchData: The data for an
// intent match. Represents an intent match for a text segment in the
// conversation. A text segment can be part of a sentence, a complete sentence,
// or an utterance with multiple sentences.
type GoogleCloudContactcenterinsightsV1alpha1IntentMatchData struct {
	// IntentUniqueId: The id of the matched intent. Can be used to retrieve the
	// corresponding intent information.
	IntentUniqueId string `json:"intentUniqueId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IntentUniqueId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IntentUniqueId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1IntentMatchData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IntentMatchData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1InterruptionData: The data for an
// interruption annotation.
type GoogleCloudContactcenterinsightsV1alpha1InterruptionData struct {
}

// GoogleCloudContactcenterinsightsV1alpha1Issue: The issue resource.
type GoogleCloudContactcenterinsightsV1alpha1Issue struct {
	// CreateTime: Output only. The time at which this issue was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayDescription: Representative description of the issue.
	DisplayDescription string `json:"displayDescription,omitempty"`
	// DisplayName: The representative name for the issue.
	DisplayName string `json:"displayName,omitempty"`
	// Name: Immutable. The resource name of the issue. Format:
	// projects/{project}/locations/{location}/issueModels/{issue_model}/issues/{iss
	// ue}
	Name string `json:"name,omitempty"`
	// SampleUtterances: Output only. Resource names of the sample representative
	// utterances that match to this issue.
	SampleUtterances []string `json:"sampleUtterances,omitempty"`
	// UpdateTime: Output only. The most recent time that this issue was updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1Issue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1Issue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1IssueAssignment: Information about
// the issue.
type GoogleCloudContactcenterinsightsV1alpha1IssueAssignment struct {
	// DisplayName: Immutable. Display name of the assigned issue. This field is
	// set at time of analysis and immutable since then.
	DisplayName string `json:"displayName,omitempty"`
	// Issue: Resource name of the assigned issue.
	Issue string `json:"issue,omitempty"`
	// Score: Score indicating the likelihood of the issue assignment. currently
	// bounded on [0,1].
	Score float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1IssueAssignment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IssueAssignment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1IssueAssignment) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IssueAssignment
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1IssueMatchData: The data for an
// issue match annotation.
type GoogleCloudContactcenterinsightsV1alpha1IssueMatchData struct {
	// IssueAssignment: Information about the issue's assignment.
	IssueAssignment *GoogleCloudContactcenterinsightsV1alpha1IssueAssignment `json:"issueAssignment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IssueAssignment") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IssueAssignment") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1IssueMatchData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IssueMatchData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1IssueModel: The issue model
// resource.
type GoogleCloudContactcenterinsightsV1alpha1IssueModel struct {
	// CreateTime: Output only. The time at which this issue model was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: The representative name for the issue model.
	DisplayName string `json:"displayName,omitempty"`
	// InputDataConfig: Configs for the input data that used to create the issue
	// model.
	InputDataConfig *GoogleCloudContactcenterinsightsV1alpha1IssueModelInputDataConfig `json:"inputDataConfig,omitempty"`
	// IssueCount: Output only. Number of issues in this issue model.
	IssueCount int64 `json:"issueCount,omitempty,string"`
	// LanguageCode: Language of the model.
	LanguageCode string `json:"languageCode,omitempty"`
	// ModelType: Type of the model.
	//
	// Possible values:
	//   "MODEL_TYPE_UNSPECIFIED" - Unspecified model type.
	//   "TYPE_V1" - Type V1.
	//   "TYPE_V2" - Type V2.
	ModelType string `json:"modelType,omitempty"`
	// Name: Immutable. The resource name of the issue model. Format:
	// projects/{project}/locations/{location}/issueModels/{issue_model}
	Name string `json:"name,omitempty"`
	// State: Output only. State of the model.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified.
	//   "UNDEPLOYED" - Model is not deployed but is ready to deploy.
	//   "DEPLOYING" - Model is being deployed.
	//   "DEPLOYED" - Model is deployed and is ready to be used. A model can only
	// be used in analysis if it's in this state.
	//   "UNDEPLOYING" - Model is being undeployed.
	//   "DELETING" - Model is being deleted.
	State string `json:"state,omitempty"`
	// TrainingStats: Output only. Immutable. The issue model's label statistics on
	// its training data.
	TrainingStats *GoogleCloudContactcenterinsightsV1alpha1IssueModelLabelStats `json:"trainingStats,omitempty"`
	// UpdateTime: Output only. The most recent time at which the issue model was
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1IssueModel) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IssueModel
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1IssueModelInputDataConfig: Configs
// for the input data used to create the issue model.
type GoogleCloudContactcenterinsightsV1alpha1IssueModelInputDataConfig struct {
	// Filter: A filter to reduce the conversations used for training the model to
	// a specific subset. Refer to
	// https://cloud.google.com/contact-center/insights/docs/filtering for details.
	Filter string `json:"filter,omitempty"`
	// Medium: Medium of conversations used in training data. This field is being
	// deprecated. To specify the medium to be used in training a new issue model,
	// set the `medium` field on `filter`.
	//
	// Possible values:
	//   "MEDIUM_UNSPECIFIED" - Default value for unspecified.
	//   "PHONE_CALL" - The format for conversations that took place over the
	// phone.
	//   "CHAT" - The format for conversations that took place over chat.
	Medium string `json:"medium,omitempty"`
	// TrainingConversationsCount: Output only. Number of conversations used in
	// training. Output only.
	TrainingConversationsCount int64 `json:"trainingConversationsCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1IssueModelInputDataConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IssueModelInputDataConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1IssueModelLabelStats: Aggregated
// statistics about an issue model.
type GoogleCloudContactcenterinsightsV1alpha1IssueModelLabelStats struct {
	// AnalyzedConversationsCount: Number of conversations the issue model has
	// analyzed at this point in time.
	AnalyzedConversationsCount int64 `json:"analyzedConversationsCount,omitempty,string"`
	// IssueStats: Statistics on each issue. Key is the issue's resource name.
	IssueStats map[string]GoogleCloudContactcenterinsightsV1alpha1IssueModelLabelStatsIssueStats `json:"issueStats,omitempty"`
	// UnclassifiedConversationsCount: Number of analyzed conversations for which
	// no issue was applicable at this point in time.
	UnclassifiedConversationsCount int64 `json:"unclassifiedConversationsCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "AnalyzedConversationsCount")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalyzedConversationsCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1IssueModelLabelStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IssueModelLabelStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1IssueModelLabelStatsIssueStats:
// Aggregated statistics about an issue.
type GoogleCloudContactcenterinsightsV1alpha1IssueModelLabelStatsIssueStats struct {
	// DisplayName: Display name of the issue.
	DisplayName string `json:"displayName,omitempty"`
	// Issue: Issue resource. Format:
	// projects/{project}/locations/{location}/issueModels/{issue_model}/issues/{iss
	// ue}
	Issue string `json:"issue,omitempty"`
	// LabeledConversationsCount: Number of conversations attached to the issue at
	// this point in time.
	LabeledConversationsCount int64 `json:"labeledConversationsCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1IssueModelLabelStatsIssueStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IssueModelLabelStatsIssueStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1IssueModelResult: Issue Modeling
// result on a conversation.
type GoogleCloudContactcenterinsightsV1alpha1IssueModelResult struct {
	// IssueModel: Issue model that generates the result. Format:
	// projects/{project}/locations/{location}/issueModels/{issue_model}
	IssueModel string `json:"issueModel,omitempty"`
	// Issues: All the matched issues.
	Issues []*GoogleCloudContactcenterinsightsV1alpha1IssueAssignment `json:"issues,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IssueModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IssueModel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1IssueModelResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IssueModelResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ListAllFeedbackLabelsResponse: The
// response for listing all feedback labels.
type GoogleCloudContactcenterinsightsV1alpha1ListAllFeedbackLabelsResponse struct {
	// FeedbackLabels: The feedback labels that match the request.
	FeedbackLabels []*GoogleCloudContactcenterinsightsV1alpha1FeedbackLabel `json:"feedbackLabels,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FeedbackLabels") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FeedbackLabels") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ListAllFeedbackLabelsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ListAllFeedbackLabelsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ListFeedbackLabelsResponse: The
// response for listing feedback labels.
type GoogleCloudContactcenterinsightsV1alpha1ListFeedbackLabelsResponse struct {
	// FeedbackLabels: The feedback labels that match the request.
	FeedbackLabels []*GoogleCloudContactcenterinsightsV1alpha1FeedbackLabel `json:"feedbackLabels,omitempty"`
	// NextPageToken: The next page token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FeedbackLabels") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FeedbackLabels") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ListFeedbackLabelsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ListFeedbackLabelsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1PhraseMatchData: The data for a
// matched phrase matcher. Represents information identifying a phrase matcher
// for a given match.
type GoogleCloudContactcenterinsightsV1alpha1PhraseMatchData struct {
	// DisplayName: The human-readable name of the phrase matcher.
	DisplayName string `json:"displayName,omitempty"`
	// PhraseMatcher: The unique identifier (the resource name) of the phrase
	// matcher.
	PhraseMatcher string `json:"phraseMatcher,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1PhraseMatchData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1PhraseMatchData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1QaAnswer: An answer to a QaQuestion.
type GoogleCloudContactcenterinsightsV1alpha1QaAnswer struct {
	// AnswerSources: Lists all answer sources containing one or more answer values
	// of a specific source type, e.g., all system-generated answer sources, or all
	// manual edit answer sources.
	AnswerSources []*GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerSource `json:"answerSources,omitempty"`
	// AnswerValue: The answer value from this source. This field is populated by
	// default, unless the question has a selection strategy configured to return
	// multiple answer values, in which case `answer_values` will be populated
	// instead.
	AnswerValue *GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerValue `json:"answerValue,omitempty"`
	// Conversation: The conversation the answer applies to.
	Conversation string `json:"conversation,omitempty"`
	// QaQuestion: The QaQuestion answered by this answer.
	QaQuestion string `json:"qaQuestion,omitempty"`
	// QuestionBody: Question text. E.g., "Did the agent greet the customer?"
	QuestionBody string `json:"questionBody,omitempty"`
	// Tags: User-defined list of arbitrary tags. Matches the value from
	// QaScorecard.ScorecardQuestion.tags. Used for grouping/organization and for
	// weighting the score of each answer.
	Tags []string `json:"tags,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerSources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerSources") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1QaAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QaAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerSource: A question may
// have multiple answers from varying sources, one of which becomes the "main"
// answer above. AnswerSource represents each individual answer.
type GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerSource struct {
	// AnswerValue: The answer value from this source. This field is populated by
	// default, unless the question has a selection strategy configured to return
	// multiple answer values, in which case `answer_values` will be populated
	// instead.
	AnswerValue *GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerValue `json:"answerValue,omitempty"`
	// SourceType: What created the answer.
	//
	// Possible values:
	//   "SOURCE_TYPE_UNSPECIFIED" - Source type is unspecified.
	//   "SYSTEM_GENERATED" - Answer was system-generated; created during an
	// Insights analysis.
	//   "MANUAL_EDIT" - Answer was created by a human via manual edit.
	SourceType string `json:"sourceType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerValue: Message for
// holding the value of a QaAnswer. QaQuestion.AnswerChoice defines the
// possible answer values for a question.
type GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerValue struct {
	// BoolValue: Boolean value.
	BoolValue bool `json:"boolValue,omitempty"`
	// Key: A short string used as an identifier. Matches the value used in
	// QaQuestion.AnswerChoice.key.
	Key string `json:"key,omitempty"`
	// NaValue: A value of "Not Applicable (N/A)". Should only ever be `true`.
	NaValue bool `json:"naValue,omitempty"`
	// NormalizedScore: Output only. Normalized score of the questions. Calculated
	// as score / potential_score.
	NormalizedScore float64 `json:"normalizedScore,omitempty"`
	// NumValue: Numerical value.
	NumValue float64 `json:"numValue,omitempty"`
	// PotentialScore: Output only. The maximum potential score of the question.
	PotentialScore float64 `json:"potentialScore,omitempty"`
	// Score: Output only. Numerical score of the answer.
	Score float64 `json:"score,omitempty"`
	// SkipValue: Output only. A value of "Skip". If provided, this field may only
	// be set to `true`. If a question receives this answer, it will be excluded
	// from any score calculations. This would mean that the question was not
	// evaluated.
	SkipValue bool `json:"skipValue,omitempty"`
	// StrValue: String value.
	StrValue string `json:"strValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoolValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoolValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerValue) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerValue
	var s1 struct {
		NormalizedScore gensupport.JSONFloat64 `json:"normalizedScore"`
		NumValue        gensupport.JSONFloat64 `json:"numValue"`
		PotentialScore  gensupport.JSONFloat64 `json:"potentialScore"`
		Score           gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.NormalizedScore = float64(s1.NormalizedScore)
	s.NumValue = float64(s1.NumValue)
	s.PotentialScore = float64(s1.PotentialScore)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1QaQuestionTag: A tag is a resource
// which aims to categorize a set of questions across multiple scorecards,
// e.g., "Customer Satisfaction","Billing", etc.
type GoogleCloudContactcenterinsightsV1alpha1QaQuestionTag struct {
	// CreateTime: Output only. The time at which the question tag was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Required. A user-specified display name for the tag.
	DisplayName string `json:"displayName,omitempty"`
	// Name: Identifier. Resource name for the QaQuestionTag Format
	// projects/{project}/locations/{location}/qaQuestionTags/{qa_question_tag} In
	// the above format, the last segment, i.e., qa_question_tag, is a
	// server-generated ID corresponding to the tag resource.
	Name string `json:"name,omitempty"`
	// QaQuestionIds: Optional. The list of Scorecard Question IDs that the tag
	// applies to. Each QaQuestionId is represented as a full resource name
	// containing the Question ID. Lastly, Since a tag may not necessarily be
	// referenced by any Scorecard Questions, we treat this field as optional.
	QaQuestionIds []string `json:"qaQuestionIds,omitempty"`
	// UpdateTime: Output only. The most recent time at which the question tag was
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1QaQuestionTag) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QaQuestionTag
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1QaScorecardResult: The results of
// scoring a single conversation against a QaScorecard. Contains a collection
// of QaAnswers and aggregate score.
type GoogleCloudContactcenterinsightsV1alpha1QaScorecardResult struct {
	// AgentId: ID of the agent that handled the conversation.
	AgentId string `json:"agentId,omitempty"`
	// Conversation: The conversation scored by this result.
	Conversation string `json:"conversation,omitempty"`
	// CreateTime: Output only. The timestamp that the revision was created.
	CreateTime string `json:"createTime,omitempty"`
	// Name: Identifier. The name of the scorecard result. Format:
	// projects/{project}/locations/{location}/qaScorecardResults/{qa_scorecard_resu
	// lt}
	Name string `json:"name,omitempty"`
	// NormalizedScore: The normalized score, which is the score divided by the
	// potential score. Any manual edits are included if they exist.
	NormalizedScore float64 `json:"normalizedScore,omitempty"`
	// PotentialScore: The maximum potential overall score of the scorecard. Any
	// questions answered using `na_value` are excluded from this calculation.
	PotentialScore float64 `json:"potentialScore,omitempty"`
	// QaAnswers: Set of QaAnswers represented in the result.
	QaAnswers []*GoogleCloudContactcenterinsightsV1alpha1QaAnswer `json:"qaAnswers,omitempty"`
	// QaScorecardRevision: The QaScorecardRevision scored by this result.
	QaScorecardRevision string `json:"qaScorecardRevision,omitempty"`
	// QaTagResults: Collection of tags and their scores.
	QaTagResults []*GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultQaTagResult `json:"qaTagResults,omitempty"`
	// Score: The overall numerical score of the result, incorporating any manual
	// edits if they exist.
	Score float64 `json:"score,omitempty"`
	// ScoreSources: List of all individual score sets.
	ScoreSources []*GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultScoreSource `json:"scoreSources,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1QaScorecardResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QaScorecardResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1QaScorecardResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QaScorecardResult
	var s1 struct {
		NormalizedScore gensupport.JSONFloat64 `json:"normalizedScore"`
		PotentialScore  gensupport.JSONFloat64 `json:"potentialScore"`
		Score           gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.NormalizedScore = float64(s1.NormalizedScore)
	s.PotentialScore = float64(s1.PotentialScore)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultQaTagResult: Tags
// and their corresponding results.
type GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultQaTagResult struct {
	// NormalizedScore: The normalized score the tag applies to.
	NormalizedScore float64 `json:"normalizedScore,omitempty"`
	// PotentialScore: The potential score the tag applies to.
	PotentialScore float64 `json:"potentialScore,omitempty"`
	// Score: The score the tag applies to.
	Score float64 `json:"score,omitempty"`
	// Tag: The tag the score applies to.
	Tag string `json:"tag,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NormalizedScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NormalizedScore") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultQaTagResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultQaTagResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultQaTagResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultQaTagResult
	var s1 struct {
		NormalizedScore gensupport.JSONFloat64 `json:"normalizedScore"`
		PotentialScore  gensupport.JSONFloat64 `json:"potentialScore"`
		Score           gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.NormalizedScore = float64(s1.NormalizedScore)
	s.PotentialScore = float64(s1.PotentialScore)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultScoreSource: A
// scorecard result may have multiple sets of scores from varying sources, one
// of which becomes the "main" answer above. A ScoreSource represents each
// individual set of scores.
type GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultScoreSource struct {
	// NormalizedScore: The normalized score, which is the score divided by the
	// potential score.
	NormalizedScore float64 `json:"normalizedScore,omitempty"`
	// PotentialScore: The maximum potential overall score of the scorecard. Any
	// questions answered using `na_value` are excluded from this calculation.
	PotentialScore float64 `json:"potentialScore,omitempty"`
	// QaTagResults: Collection of tags and their scores.
	QaTagResults []*GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultQaTagResult `json:"qaTagResults,omitempty"`
	// Score: The overall numerical score of the result.
	Score float64 `json:"score,omitempty"`
	// SourceType: What created the score.
	//
	// Possible values:
	//   "SOURCE_TYPE_UNSPECIFIED" - Source type is unspecified.
	//   "SYSTEM_GENERATED_ONLY" - Score is derived only from system-generated
	// answers.
	//   "INCLUDES_MANUAL_EDITS" - Score is derived from both system-generated
	// answers, and includes any manual edits if they exist.
	SourceType string `json:"sourceType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NormalizedScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NormalizedScore") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultScoreSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultScoreSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultScoreSource) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultScoreSource
	var s1 struct {
		NormalizedScore gensupport.JSONFloat64 `json:"normalizedScore"`
		PotentialScore  gensupport.JSONFloat64 `json:"potentialScore"`
		Score           gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.NormalizedScore = float64(s1.NormalizedScore)
	s.PotentialScore = float64(s1.PotentialScore)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1QueryMetricsMetadata: The metadata
// from querying metrics.
type GoogleCloudContactcenterinsightsV1alpha1QueryMetricsMetadata struct {
	// ResultIsTruncated: Whether the result rows were truncated because the result
	// row size is too large to materialize.
	ResultIsTruncated bool `json:"resultIsTruncated,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ResultIsTruncated") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ResultIsTruncated") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1QueryMetricsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QueryMetricsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponse: The response
// for querying metrics.
type GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponse struct {
	// Location: Required. The location of the data.
	// "projects/{project}/locations/{location}"
	Location string `json:"location,omitempty"`
	// MacroAverageSlice: The macro average slice contains aggregated averages
	// across all selected dimensions. i.e. if group_by agent and scorecard_id is
	// specified, this field will contain the average across all agents and all
	// scorecards. This field is only populated if the request specifies a
	// Dimension.
	MacroAverageSlice *GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSlice `json:"macroAverageSlice,omitempty"`
	// Slices: A slice contains a total and (if the request specified a time
	// granularity) a time series of metric values. Each slice contains a unique
	// combination of the cardinality of dimensions from the request.
	Slices []*GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSlice `json:"slices,omitempty"`
	// UpdateTime: The metrics last update time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Location") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Location") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSlice: A slice
// contains a total and (if the request specified a time granularity) a time
// series of metric values. Each slice contains a unique combination of the
// cardinality of dimensions from the request. For example, if the request
// specifies a single ISSUE dimension and it has a cardinality of 2 (i.e. the
// data used to compute the metrics has 2 issues in total), the response will
// have 2 slices: * Slice 1 -> dimensions=[Issue 1] * Slice 2 ->
// dimensions=[Issue 2]
type GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSlice struct {
	// Dimensions: A unique combination of dimensions that this slice represents.
	Dimensions []*GoogleCloudContactcenterinsightsV1alpha1Dimension `json:"dimensions,omitempty"`
	// TimeSeries: A time series of metric values. This is only populated if the
	// request specifies a time granularity other than NONE.
	TimeSeries *GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceTimeSeries `json:"timeSeries,omitempty"`
	// Total: The total metric value. The interval of this data point is [starting
	// create time, ending create time) from the request.
	Total *GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPoint `json:"total,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dimensions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dimensions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSlice) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSlice
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPoint:
// A data point contains the metric values mapped to an interval.
type GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPoint struct {
	// ConversationMeasure: The measure related to conversations.
	ConversationMeasure *GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointConversationMeasure `json:"conversationMeasure,omitempty"`
	// DialogflowInteractionMeasure: The measure related to dialogflow
	// interactions.
	DialogflowInteractionMeasure *GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointDialogflowInteractionMeasure `json:"dialogflowInteractionMeasure,omitempty"`
	// Interval: The interval that this data point represents. * If this is the
	// total data point, the interval is [starting create time, ending create time)
	// from the request. * If this a data point from the time series, the interval
	// is [time, time + time granularity from the request).
	Interval *GoogleTypeInterval `json:"interval,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationMeasure") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationMeasure") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPoint) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPoint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointCon
// versationMeasure: The measure related to conversations.
type GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointConversationMeasure struct {
	// AaSupervisorAssignedConversationsCount: The number of conversations that
	// were assigned to an AA human supervisor.
	AaSupervisorAssignedConversationsCount int64 `json:"aaSupervisorAssignedConversationsCount,omitempty"`
	// AaSupervisorDroppedConversationsCount: The number of conversations that were
	// dropped, i.e. escalated but not assigned to an AA human supervisor.
	AaSupervisorDroppedConversationsCount int64 `json:"aaSupervisorDroppedConversationsCount,omitempty"`
	// AaSupervisorEscalatedConversationsCount: The number of conversations that
	// were escalated to an AA human supervisor for intervention.
	AaSupervisorEscalatedConversationsCount int64 `json:"aaSupervisorEscalatedConversationsCount,omitempty"`
	// AaSupervisorMonitoredConversationsCount: The number of conversations scanned
	// by the AA human supervisor.
	AaSupervisorMonitoredConversationsCount int64 `json:"aaSupervisorMonitoredConversationsCount,omitempty"`
	// AaSupervisorTransferredToHumanAgentConvCount: The number of conversations
	// transferred to a human agent.
	AaSupervisorTransferredToHumanAgentConvCount int64 `json:"aaSupervisorTransferredToHumanAgentConvCount,omitempty"`
	// AiCoachSuggestionAgentMessageTriggerCount: Count of agent messages that
	// triggered an Ai Coach Suggestion.
	AiCoachSuggestionAgentMessageTriggerCount int64 `json:"aiCoachSuggestionAgentMessageTriggerCount,omitempty"`
	// AiCoachSuggestionAgentUsageCount: Count of Ai Coach Suggestion that has been
	// used by agents.
	AiCoachSuggestionAgentUsageCount int64 `json:"aiCoachSuggestionAgentUsageCount,omitempty"`
	// AiCoachSuggestionAgentUsageRatio: Proportion of Ai Coach Suggestion that has
	// been used by agents.
	AiCoachSuggestionAgentUsageRatio float64 `json:"aiCoachSuggestionAgentUsageRatio,omitempty"`
	// AiCoachSuggestionCustomerMessageTriggerCount: Count of customer messages
	// that triggered an Ai Coach Suggestion.
	AiCoachSuggestionCustomerMessageTriggerCount int64 `json:"aiCoachSuggestionCustomerMessageTriggerCount,omitempty"`
	// AiCoachSuggestionCustomerMessageTriggerRatio: Proportion of customer
	// messages that triggered an Ai Coach Suggestion.
	AiCoachSuggestionCustomerMessageTriggerRatio float64 `json:"aiCoachSuggestionCustomerMessageTriggerRatio,omitempty"`
	// AiCoachSuggestionMessageTriggerCount: Count of end_of_utterance trigger
	// event messages that triggered an Ai Coach Suggestion.
	AiCoachSuggestionMessageTriggerCount int64 `json:"aiCoachSuggestionMessageTriggerCount,omitempty"`
	// AiCoachSuggestionMessageTriggerRatio: Proportion of end_of_utterance trigger
	// event messages that triggered an Ai Coach Suggestion.
	AiCoachSuggestionMessageTriggerRatio float64 `json:"aiCoachSuggestionMessageTriggerRatio,omitempty"`
	// AverageAgentSentimentScore: The average agent's sentiment score.
	AverageAgentSentimentScore float64 `json:"averageAgentSentimentScore,omitempty"`
	// AverageClientSentimentScore: The average client's sentiment score.
	AverageClientSentimentScore float64 `json:"averageClientSentimentScore,omitempty"`
	// AverageCustomerSatisfactionRating: The average customer satisfaction rating.
	AverageCustomerSatisfactionRating float64 `json:"averageCustomerSatisfactionRating,omitempty"`
	// AverageDuration: The average duration.
	AverageDuration string `json:"averageDuration,omitempty"`
	// AverageQaNormalizedScore: The average normalized QA score for a scorecard.
	// When computing the average across a set of conversations, if a conversation
	// has been evaluated with multiple revisions of a scorecard, only the latest
	// revision results will be used. Will exclude 0's in average calculation. Will
	// be only populated if the request specifies a dimension of QA_SCORECARD_ID.
	AverageQaNormalizedScore float64 `json:"averageQaNormalizedScore,omitempty"`
	// AverageQaQuestionNormalizedScore: Average QA normalized score averaged for
	// questions averaged across all revisions of the parent scorecard. Will be
	// only populated if the request specifies a dimension of QA_QUESTION_ID.
	AverageQaQuestionNormalizedScore float64 `json:"averageQaQuestionNormalizedScore,omitempty"`
	// AverageSilencePercentage: The average silence percentage.
	AverageSilencePercentage float64 `json:"averageSilencePercentage,omitempty"`
	// AverageSummarizationSuggestionEditDistance: Average edit distance of the
	// summarization suggestions. Edit distance (also called as levenshtein
	// distance) is calculated by summing up number of insertions, deletions and
	// substitutions required to transform the summization feedback to the original
	// summary suggestion.
	AverageSummarizationSuggestionEditDistance float64 `json:"averageSummarizationSuggestionEditDistance,omitempty"`
	// AverageSummarizationSuggestionNormalizedEditDistance: Normalized Average
	// edit distance of the summarization suggestions. Edit distance (also called
	// as levenshtein distance) is calculated by summing up number of insertions,
	// deletions and substitutions required to transform the summization feedback
	// to the original summary suggestion. Normalized edit distance is the average
	// of (edit distance / summary length).
	AverageSummarizationSuggestionNormalizedEditDistance float64 `json:"averageSummarizationSuggestionNormalizedEditDistance,omitempty"`
	// AverageTurnCount: The average turn count.
	AverageTurnCount float64 `json:"averageTurnCount,omitempty"`
	// AvgConversationClientTurnSentimentEma: The exponential moving average of the
	// sentiment score of client turns in the conversation.
	AvgConversationClientTurnSentimentEma float64 `json:"avgConversationClientTurnSentimentEma,omitempty"`
	// ContainedConversationCount: The number of conversations that were contained.
	ContainedConversationCount int64 `json:"containedConversationCount,omitempty"`
	// ContainedConversationRatio: The percentage of conversations that were
	// contained.
	ContainedConversationRatio float64 `json:"containedConversationRatio,omitempty"`
	// ConversationAiCoachSuggestionCount: Count of conversations that has Ai Coach
	// Suggestions.
	ConversationAiCoachSuggestionCount int64 `json:"conversationAiCoachSuggestionCount,omitempty"`
	// ConversationAiCoachSuggestionRatio: Proportion of conversations that has Ai
	// Coach Suggestions.
	ConversationAiCoachSuggestionRatio float64 `json:"conversationAiCoachSuggestionRatio,omitempty"`
	// ConversationCount: The conversation count.
	ConversationCount int64 `json:"conversationCount,omitempty"`
	// ConversationSuggestedSummaryRatio: Proportion of conversations that had a
	// suggested summary.
	ConversationSuggestedSummaryRatio float64 `json:"conversationSuggestedSummaryRatio,omitempty"`
	// ConversationTotalAgentMessageCount: The agent message count.
	ConversationTotalAgentMessageCount int64 `json:"conversationTotalAgentMessageCount,omitempty"`
	// ConversationTotalCustomerMessageCount: The customer message count.
	ConversationTotalCustomerMessageCount int64 `json:"conversationTotalCustomerMessageCount,omitempty"`
	// ConversationalAgentsAverageAudioInAudioOutLatency: The average latency of
	// conversational agents' audio in audio out latency per interaction. This is
	// computed as the average of the all the interactions' audio in audio out
	// latencies in a conversation and averaged across conversations.
	ConversationalAgentsAverageAudioInAudioOutLatency float64 `json:"conversationalAgentsAverageAudioInAudioOutLatency,omitempty"`
	// ConversationalAgentsAverageEndToEndLatency: The average latency of
	// conversational agents' latency per interaction. This is computed as the
	// average of the all the iteractions' end to end latencies in a conversation
	// and averaged across conversations. The e2e latency is the time between the
	// end of the user utterance and the start of the agent utterance on the
	// interaction level.
	ConversationalAgentsAverageEndToEndLatency float64 `json:"conversationalAgentsAverageEndToEndLatency,omitempty"`
	// ConversationalAgentsAverageLlmCallLatency: The average latency of
	// conversational agents' LLM call latency per interaction. This is computed as
	// the average of the all the interactions LLM call latencies in a conversation
	// and averaged across conversations.
	ConversationalAgentsAverageLlmCallLatency float64 `json:"conversationalAgentsAverageLlmCallLatency,omitempty"`
	// ConversationalAgentsAverageTtsLatency: The macro average latency of
	// conversational agents' TTS latency per interaction. This is computed as the
	// average of the all the interactions' TTS latencies in a conversation and
	// averaged across conversations.
	ConversationalAgentsAverageTtsLatency float64 `json:"conversationalAgentsAverageTtsLatency,omitempty"`
	// DialogflowAverageWebhookLatency: Average latency of dialogflow webhook
	// calls.
	DialogflowAverageWebhookLatency float64 `json:"dialogflowAverageWebhookLatency,omitempty"`
	// DialogflowConversationsEscalationCount: count of conversations that was
	// handed off from virtual agent to human agent.
	DialogflowConversationsEscalationCount float64 `json:"dialogflowConversationsEscalationCount,omitempty"`
	// DialogflowConversationsEscalationRatio: Proportion of conversations that was
	// handed off from virtual agent to human agent.
	DialogflowConversationsEscalationRatio float64 `json:"dialogflowConversationsEscalationRatio,omitempty"`
	// DialogflowInteractionsNoInputRatio: Proportion of dialogflow interactions
	// that has empty input.
	DialogflowInteractionsNoInputRatio float64 `json:"dialogflowInteractionsNoInputRatio,omitempty"`
	// DialogflowInteractionsNoMatchRatio: Proportion of dialogflow interactions
	// that has no intent match for the input.
	DialogflowInteractionsNoMatchRatio float64 `json:"dialogflowInteractionsNoMatchRatio,omitempty"`
	// DialogflowWebhookFailureRatio: Proportion of dialogflow webhook calls that
	// failed.
	DialogflowWebhookFailureRatio float64 `json:"dialogflowWebhookFailureRatio,omitempty"`
	// DialogflowWebhookTimeoutRatio: Proportion of dialogflow webhook calls that
	// timed out.
	DialogflowWebhookTimeoutRatio float64 `json:"dialogflowWebhookTimeoutRatio,omitempty"`
	// KnowledgeAssistNegativeFeedbackRatio: Proportion of knowledge assist
	// (Proactive Generative Knowledge Assist) queries that had negative feedback.
	KnowledgeAssistNegativeFeedbackRatio float64 `json:"knowledgeAssistNegativeFeedbackRatio,omitempty"`
	// KnowledgeAssistPositiveFeedbackRatio: Proportion of knowledge assist
	// (Proactive Generative Knowledge Assist) queries that had positive feedback.
	KnowledgeAssistPositiveFeedbackRatio float64 `json:"knowledgeAssistPositiveFeedbackRatio,omitempty"`
	// KnowledgeAssistResultCount: Count of knowledge assist results (Proactive
	// Generative Knowledge Assist) shown to the user.
	KnowledgeAssistResultCount int64 `json:"knowledgeAssistResultCount,omitempty"`
	// KnowledgeAssistUriClickRatio: Proportion of knowledge assist (Proactive
	// Generative Knowledge Assist) queries that had a URL clicked.
	KnowledgeAssistUriClickRatio float64 `json:"knowledgeAssistUriClickRatio,omitempty"`
	// KnowledgeSearchAgentQuerySourceRatio: Proportion of knowledge search
	// (Generative Knowledge Assist) queries made by the agent compared to the
	// total number of knowledge search queries made.
	KnowledgeSearchAgentQuerySourceRatio float64 `json:"knowledgeSearchAgentQuerySourceRatio,omitempty"`
	// KnowledgeSearchNegativeFeedbackRatio: Proportion of knowledge search
	// (Generative Knowledge Assist) queries that had negative feedback.
	KnowledgeSearchNegativeFeedbackRatio float64 `json:"knowledgeSearchNegativeFeedbackRatio,omitempty"`
	// KnowledgeSearchPositiveFeedbackRatio: Proportion of knowledge search
	// (Generative Knowledge Assist) queries that had positive feedback.
	KnowledgeSearchPositiveFeedbackRatio float64 `json:"knowledgeSearchPositiveFeedbackRatio,omitempty"`
	// KnowledgeSearchResultCount: Count of knowledge search results (Generative
	// Knowledge Assist) shown to the user.
	KnowledgeSearchResultCount int64 `json:"knowledgeSearchResultCount,omitempty"`
	// KnowledgeSearchSuggestedQuerySourceRatio: Proportion of knowledge search
	// (Generative Knowledge Assist) queries suggested compared to the total number
	// of knowledge search queries made.
	KnowledgeSearchSuggestedQuerySourceRatio float64 `json:"knowledgeSearchSuggestedQuerySourceRatio,omitempty"`
	// KnowledgeSearchUriClickRatio: Proportion of knowledge search (Generative
	// Knowledge Assist) queries that had a URL clicked.
	KnowledgeSearchUriClickRatio float64 `json:"knowledgeSearchUriClickRatio,omitempty"`
	// QaTagScores: Average QA normalized score for all the tags.
	QaTagScores []*GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointConversationMeasureQaTagScore `json:"qaTagScores,omitempty"`
	// SummarizationSuggestionEditRatio: Proportion of summarization suggestions
	// that were manually edited.
	SummarizationSuggestionEditRatio float64 `json:"summarizationSuggestionEditRatio,omitempty"`
	// SummarizationSuggestionResultCount: Count of summarization suggestions
	// results.
	SummarizationSuggestionResultCount int64 `json:"summarizationSuggestionResultCount,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "AaSupervisorAssignedConversationsCount") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "AaSupervisorAssignedConversationsCount") to include in API requests with
	// the JSON null value. By default, fields with empty values are omitted from
	// API requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields
	// for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointConversationMeasure) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointConversationMeasure
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointConversationMeasure) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointConversationMeasure
	var s1 struct {
		AiCoachSuggestionAgentUsageRatio                     gensupport.JSONFloat64 `json:"aiCoachSuggestionAgentUsageRatio"`
		AiCoachSuggestionCustomerMessageTriggerRatio         gensupport.JSONFloat64 `json:"aiCoachSuggestionCustomerMessageTriggerRatio"`
		AiCoachSuggestionMessageTriggerRatio                 gensupport.JSONFloat64 `json:"aiCoachSuggestionMessageTriggerRatio"`
		AverageAgentSentimentScore                           gensupport.JSONFloat64 `json:"averageAgentSentimentScore"`
		AverageClientSentimentScore                          gensupport.JSONFloat64 `json:"averageClientSentimentScore"`
		AverageCustomerSatisfactionRating                    gensupport.JSONFloat64 `json:"averageCustomerSatisfactionRating"`
		AverageQaNormalizedScore                             gensupport.JSONFloat64 `json:"averageQaNormalizedScore"`
		AverageQaQuestionNormalizedScore                     gensupport.JSONFloat64 `json:"averageQaQuestionNormalizedScore"`
		AverageSilencePercentage                             gensupport.JSONFloat64 `json:"averageSilencePercentage"`
		AverageSummarizationSuggestionEditDistance           gensupport.JSONFloat64 `json:"averageSummarizationSuggestionEditDistance"`
		AverageSummarizationSuggestionNormalizedEditDistance gensupport.JSONFloat64 `json:"averageSummarizationSuggestionNormalizedEditDistance"`
		AverageTurnCount                                     gensupport.JSONFloat64 `json:"averageTurnCount"`
		AvgConversationClientTurnSentimentEma                gensupport.JSONFloat64 `json:"avgConversationClientTurnSentimentEma"`
		ContainedConversationRatio                           gensupport.JSONFloat64 `json:"containedConversationRatio"`
		ConversationAiCoachSuggestionRatio                   gensupport.JSONFloat64 `json:"conversationAiCoachSuggestionRatio"`
		ConversationSuggestedSummaryRatio                    gensupport.JSONFloat64 `json:"conversationSuggestedSummaryRatio"`
		ConversationalAgentsAverageAudioInAudioOutLatency    gensupport.JSONFloat64 `json:"conversationalAgentsAverageAudioInAudioOutLatency"`
		ConversationalAgentsAverageEndToEndLatency           gensupport.JSONFloat64 `json:"conversationalAgentsAverageEndToEndLatency"`
		ConversationalAgentsAverageLlmCallLatency            gensupport.JSONFloat64 `json:"conversationalAgentsAverageLlmCallLatency"`
		ConversationalAgentsAverageTtsLatency                gensupport.JSONFloat64 `json:"conversationalAgentsAverageTtsLatency"`
		DialogflowAverageWebhookLatency                      gensupport.JSONFloat64 `json:"dialogflowAverageWebhookLatency"`
		DialogflowConversationsEscalationCount               gensupport.JSONFloat64 `json:"dialogflowConversationsEscalationCount"`
		DialogflowConversationsEscalationRatio               gensupport.JSONFloat64 `json:"dialogflowConversationsEscalationRatio"`
		DialogflowInteractionsNoInputRatio                   gensupport.JSONFloat64 `json:"dialogflowInteractionsNoInputRatio"`
		DialogflowInteractionsNoMatchRatio                   gensupport.JSONFloat64 `json:"dialogflowInteractionsNoMatchRatio"`
		DialogflowWebhookFailureRatio                        gensupport.JSONFloat64 `json:"dialogflowWebhookFailureRatio"`
		DialogflowWebhookTimeoutRatio                        gensupport.JSONFloat64 `json:"dialogflowWebhookTimeoutRatio"`
		KnowledgeAssistNegativeFeedbackRatio                 gensupport.JSONFloat64 `json:"knowledgeAssistNegativeFeedbackRatio"`
		KnowledgeAssistPositiveFeedbackRatio                 gensupport.JSONFloat64 `json:"knowledgeAssistPositiveFeedbackRatio"`
		KnowledgeAssistUriClickRatio                         gensupport.JSONFloat64 `json:"knowledgeAssistUriClickRatio"`
		KnowledgeSearchAgentQuerySourceRatio                 gensupport.JSONFloat64 `json:"knowledgeSearchAgentQuerySourceRatio"`
		KnowledgeSearchNegativeFeedbackRatio                 gensupport.JSONFloat64 `json:"knowledgeSearchNegativeFeedbackRatio"`
		KnowledgeSearchPositiveFeedbackRatio                 gensupport.JSONFloat64 `json:"knowledgeSearchPositiveFeedbackRatio"`
		KnowledgeSearchSuggestedQuerySourceRatio             gensupport.JSONFloat64 `json:"knowledgeSearchSuggestedQuerySourceRatio"`
		KnowledgeSearchUriClickRatio                         gensupport.JSONFloat64 `json:"knowledgeSearchUriClickRatio"`
		SummarizationSuggestionEditRatio                     gensupport.JSONFloat64 `json:"summarizationSuggestionEditRatio"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AiCoachSuggestionAgentUsageRatio = float64(s1.AiCoachSuggestionAgentUsageRatio)
	s.AiCoachSuggestionCustomerMessageTriggerRatio = float64(s1.AiCoachSuggestionCustomerMessageTriggerRatio)
	s.AiCoachSuggestionMessageTriggerRatio = float64(s1.AiCoachSuggestionMessageTriggerRatio)
	s.AverageAgentSentimentScore = float64(s1.AverageAgentSentimentScore)
	s.AverageClientSentimentScore = float64(s1.AverageClientSentimentScore)
	s.AverageCustomerSatisfactionRating = float64(s1.AverageCustomerSatisfactionRating)
	s.AverageQaNormalizedScore = float64(s1.AverageQaNormalizedScore)
	s.AverageQaQuestionNormalizedScore = float64(s1.AverageQaQuestionNormalizedScore)
	s.AverageSilencePercentage = float64(s1.AverageSilencePercentage)
	s.AverageSummarizationSuggestionEditDistance = float64(s1.AverageSummarizationSuggestionEditDistance)
	s.AverageSummarizationSuggestionNormalizedEditDistance = float64(s1.AverageSummarizationSuggestionNormalizedEditDistance)
	s.AverageTurnCount = float64(s1.AverageTurnCount)
	s.AvgConversationClientTurnSentimentEma = float64(s1.AvgConversationClientTurnSentimentEma)
	s.ContainedConversationRatio = float64(s1.ContainedConversationRatio)
	s.ConversationAiCoachSuggestionRatio = float64(s1.ConversationAiCoachSuggestionRatio)
	s.ConversationSuggestedSummaryRatio = float64(s1.ConversationSuggestedSummaryRatio)
	s.ConversationalAgentsAverageAudioInAudioOutLatency = float64(s1.ConversationalAgentsAverageAudioInAudioOutLatency)
	s.ConversationalAgentsAverageEndToEndLatency = float64(s1.ConversationalAgentsAverageEndToEndLatency)
	s.ConversationalAgentsAverageLlmCallLatency = float64(s1.ConversationalAgentsAverageLlmCallLatency)
	s.ConversationalAgentsAverageTtsLatency = float64(s1.ConversationalAgentsAverageTtsLatency)
	s.DialogflowAverageWebhookLatency = float64(s1.DialogflowAverageWebhookLatency)
	s.DialogflowConversationsEscalationCount = float64(s1.DialogflowConversationsEscalationCount)
	s.DialogflowConversationsEscalationRatio = float64(s1.DialogflowConversationsEscalationRatio)
	s.DialogflowInteractionsNoInputRatio = float64(s1.DialogflowInteractionsNoInputRatio)
	s.DialogflowInteractionsNoMatchRatio = float64(s1.DialogflowInteractionsNoMatchRatio)
	s.DialogflowWebhookFailureRatio = float64(s1.DialogflowWebhookFailureRatio)
	s.DialogflowWebhookTimeoutRatio = float64(s1.DialogflowWebhookTimeoutRatio)
	s.KnowledgeAssistNegativeFeedbackRatio = float64(s1.KnowledgeAssistNegativeFeedbackRatio)
	s.KnowledgeAssistPositiveFeedbackRatio = float64(s1.KnowledgeAssistPositiveFeedbackRatio)
	s.KnowledgeAssistUriClickRatio = float64(s1.KnowledgeAssistUriClickRatio)
	s.KnowledgeSearchAgentQuerySourceRatio = float64(s1.KnowledgeSearchAgentQuerySourceRatio)
	s.KnowledgeSearchNegativeFeedbackRatio = float64(s1.KnowledgeSearchNegativeFeedbackRatio)
	s.KnowledgeSearchPositiveFeedbackRatio = float64(s1.KnowledgeSearchPositiveFeedbackRatio)
	s.KnowledgeSearchSuggestedQuerySourceRatio = float64(s1.KnowledgeSearchSuggestedQuerySourceRatio)
	s.KnowledgeSearchUriClickRatio = float64(s1.KnowledgeSearchUriClickRatio)
	s.SummarizationSuggestionEditRatio = float64(s1.SummarizationSuggestionEditRatio)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointCon
// versationMeasureQaTagScore: Average QA normalized score for the tag.
type GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointConversationMeasureQaTagScore struct {
	// AverageTagNormalizedScore: Average tag normalized score per tag.
	AverageTagNormalizedScore float64 `json:"averageTagNormalizedScore,omitempty"`
	// Tag: Tag name.
	Tag string `json:"tag,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AverageTagNormalizedScore")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AverageTagNormalizedScore") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointConversationMeasureQaTagScore) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointConversationMeasureQaTagScore
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointConversationMeasureQaTagScore) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointConversationMeasureQaTagScore
	var s1 struct {
		AverageTagNormalizedScore gensupport.JSONFloat64 `json:"averageTagNormalizedScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AverageTagNormalizedScore = float64(s1.AverageTagNormalizedScore)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointDia
// logflowInteractionMeasure: The measure related to dialogflow interactions.
type GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointDialogflowInteractionMeasure struct {
	// PercentileAudioInAudioOutLatency: The percentile result for audio in audio
	// out latency in milliseconds per dialogflow interaction level.
	PercentileAudioInAudioOutLatency *GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointPercentileResult `json:"percentileAudioInAudioOutLatency,omitempty"`
	// PercentileEndToEndLatency: The percentile result for end to end chat latency
	// in milliseconds per dialogflow interaction level.
	PercentileEndToEndLatency *GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointPercentileResult `json:"percentileEndToEndLatency,omitempty"`
	// PercentileLlmCallLatency: The percentile result for LLM latency in
	// milliseconds per dialogflow interaction level.
	PercentileLlmCallLatency *GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointPercentileResult `json:"percentileLlmCallLatency,omitempty"`
	// PercentileToolUseLatency: The percentile result for tool use latency in
	// milliseconds per dialogflow interaction level.
	PercentileToolUseLatency *GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointPercentileResult `json:"percentileToolUseLatency,omitempty"`
	// PercentileTtsLatency: The percentile result for TTS latency in milliseconds
	// per dialogflow interaction level.
	PercentileTtsLatency *GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointPercentileResult `json:"percentileTtsLatency,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "PercentileAudioInAudioOutLatency") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "PercentileAudioInAudioOutLatency") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields for
	// more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointDialogflowInteractionMeasure) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointDialogflowInteractionMeasure
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointPer
// centileResult: The percentile result. Currently supported percentiles are
// 50th, 90th, and 99th.
type GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointPercentileResult struct {
	// P50: The 50th percentile value.
	P50 float64 `json:"p50,omitempty"`
	// P90: The 90th percentile value.
	P90 float64 `json:"p90,omitempty"`
	// P99: The 99th percentile value.
	P99 float64 `json:"p99,omitempty"`
	// ForceSendFields is a list of field names (e.g. "P50") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "P50") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointPercentileResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointPercentileResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointPercentileResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointPercentileResult
	var s1 struct {
		P50 gensupport.JSONFloat64 `json:"p50"`
		P90 gensupport.JSONFloat64 `json:"p90"`
		P99 gensupport.JSONFloat64 `json:"p99"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.P50 = float64(s1.P50)
	s.P90 = float64(s1.P90)
	s.P99 = float64(s1.P99)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceTimeSeries:
// A time series of metric values.
type GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceTimeSeries struct {
	// DataPoints: The data points that make up the time series .
	DataPoints []*GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPoint `json:"dataPoints,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataPoints") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataPoints") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceTimeSeries) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceTimeSeries
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1QueryPerformanceOverviewMetadata:
// The metadata for querying performance overview.
type GoogleCloudContactcenterinsightsV1alpha1QueryPerformanceOverviewMetadata struct {
}

// GoogleCloudContactcenterinsightsV1alpha1QueryPerformanceOverviewResponse:
// The response for querying performance overview.
type GoogleCloudContactcenterinsightsV1alpha1QueryPerformanceOverviewResponse struct {
	// SummaryText: The summary text of the performance.
	SummaryText string `json:"summaryText,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SummaryText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SummaryText") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1QueryPerformanceOverviewResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QueryPerformanceOverviewResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1RedactionConfig: DLP resources used
// for redaction while ingesting conversations. DLP settings are applied to
// conversations ingested from the `UploadConversation` and
// `IngestConversations` endpoints, including conversation coming from CCAI
// Platform. They are not applied to conversations ingested from the
// `CreateConversation` endpoint or the Dialogflow / Agent Assist runtime
// integrations. When using Dialogflow / Agent Assist runtime integrations,
// redaction should be performed in Dialogflow / Agent Assist.
type GoogleCloudContactcenterinsightsV1alpha1RedactionConfig struct {
	// DeidentifyTemplate: The fully-qualified DLP deidentify template resource
	// name. Format: `projects/{project}/deidentifyTemplates/{template}`
	DeidentifyTemplate string `json:"deidentifyTemplate,omitempty"`
	// InspectTemplate: The fully-qualified DLP inspect template resource name.
	// Format:
	// `projects/{project}/locations/{location}/inspectTemplates/{template}`
	InspectTemplate string `json:"inspectTemplate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeidentifyTemplate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeidentifyTemplate") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1RedactionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1RedactionConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1RuntimeAnnotation: An annotation
// that was generated during the customer and agent interaction.
type GoogleCloudContactcenterinsightsV1alpha1RuntimeAnnotation struct {
	// AnnotationId: The unique identifier of the annotation. Format:
	// projects/{project}/locations/{location}/conversationDatasets/{dataset}/conver
	// sationDataItems/{data_item}/conversationAnnotations/{annotation}
	AnnotationId string `json:"annotationId,omitempty"`
	// AnswerFeedback: The feedback that the customer has about the answer in
	// `data`.
	AnswerFeedback *GoogleCloudContactcenterinsightsV1alpha1AnswerFeedback `json:"answerFeedback,omitempty"`
	// ArticleSuggestion: Agent Assist Article Suggestion data.
	ArticleSuggestion *GoogleCloudContactcenterinsightsV1alpha1ArticleSuggestionData `json:"articleSuggestion,omitempty"`
	// ConversationSummarizationSuggestion: Conversation summarization suggestion
	// data.
	ConversationSummarizationSuggestion *GoogleCloudContactcenterinsightsV1alpha1ConversationSummarizationSuggestionData `json:"conversationSummarizationSuggestion,omitempty"`
	// CreateTime: The time at which this annotation was created.
	CreateTime string `json:"createTime,omitempty"`
	// DialogflowInteraction: Dialogflow interaction data.
	DialogflowInteraction *GoogleCloudContactcenterinsightsV1alpha1DialogflowInteractionData `json:"dialogflowInteraction,omitempty"`
	// EndBoundary: The boundary in the conversation where the annotation ends,
	// inclusive.
	EndBoundary *GoogleCloudContactcenterinsightsV1alpha1AnnotationBoundary `json:"endBoundary,omitempty"`
	// FaqAnswer: Agent Assist FAQ answer data.
	FaqAnswer *GoogleCloudContactcenterinsightsV1alpha1FaqAnswerData `json:"faqAnswer,omitempty"`
	// SmartComposeSuggestion: Agent Assist Smart Compose suggestion data.
	SmartComposeSuggestion *GoogleCloudContactcenterinsightsV1alpha1SmartComposeSuggestionData `json:"smartComposeSuggestion,omitempty"`
	// SmartReply: Agent Assist Smart Reply data.
	SmartReply *GoogleCloudContactcenterinsightsV1alpha1SmartReplyData `json:"smartReply,omitempty"`
	// StartBoundary: The boundary in the conversation where the annotation starts,
	// inclusive.
	StartBoundary *GoogleCloudContactcenterinsightsV1alpha1AnnotationBoundary `json:"startBoundary,omitempty"`
	// UserInput: Explicit input used for generating the answer
	UserInput *GoogleCloudContactcenterinsightsV1alpha1RuntimeAnnotationUserInput `json:"userInput,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1RuntimeAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1RuntimeAnnotation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1RuntimeAnnotationUserInput: Explicit
// input used for generating the answer
type GoogleCloudContactcenterinsightsV1alpha1RuntimeAnnotationUserInput struct {
	// GeneratorName: The resource name of associated generator. Format:
	// `projects//locations//generators/`
	GeneratorName string `json:"generatorName,omitempty"`
	// Query: Query text. Article Search uses this to store the input query used to
	// generate the search results.
	Query string `json:"query,omitempty"`
	// QuerySource: Query source for the answer.
	//
	// Possible values:
	//   "QUERY_SOURCE_UNSPECIFIED" - Unknown query source.
	//   "AGENT_QUERY" - The query is from agents.
	//   "SUGGESTED_QUERY" - The query is a query from previous suggestions, e.g.
	// from a preceding SuggestKnowledgeAssist response.
	QuerySource string `json:"querySource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GeneratorName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GeneratorName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1RuntimeAnnotationUserInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1RuntimeAnnotationUserInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1SampleConversationsMetadata: The
// metadata for an SampleConversations operation.
type GoogleCloudContactcenterinsightsV1alpha1SampleConversationsMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// PartialErrors: Output only. Partial errors during sample conversations
	// operation that might cause the operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: Output only. The original request for sample conversations to
	// dataset.
	Request *GoogleCloudContactcenterinsightsV1alpha1SampleConversationsRequest `json:"request,omitempty"`
	// SampleConversationsStats: Output only. Statistics for SampleConversations
	// operation.
	SampleConversationsStats *GoogleCloudContactcenterinsightsV1alpha1SampleConversationsMetadataSampleConversationsStats `json:"sampleConversationsStats,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1SampleConversationsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1SampleConversationsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1SampleConversationsMetadataSampleConv
// ersationsStats: Statistics for SampleConversations operation.
type GoogleCloudContactcenterinsightsV1alpha1SampleConversationsMetadataSampleConversationsStats struct {
	// FailedSampleCount: Output only. The number of objects which were unable to
	// be sampled due to errors. The errors are populated in the partial_errors
	// field.
	FailedSampleCount int64 `json:"failedSampleCount,omitempty"`
	// SuccessfulSampleCount: Output only. The number of new conversations added
	// during this sample operation.
	SuccessfulSampleCount int64 `json:"successfulSampleCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FailedSampleCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FailedSampleCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1SampleConversationsMetadataSampleConversationsStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1SampleConversationsMetadataSampleConversationsStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1SampleConversationsRequest: The
// request to sample conversations to a dataset.
type GoogleCloudContactcenterinsightsV1alpha1SampleConversationsRequest struct {
	// DestinationDataset: The dataset resource to copy the sampled conversations
	// to.
	DestinationDataset *GoogleCloudContactcenterinsightsV1alpha1Dataset `json:"destinationDataset,omitempty"`
	// Parent: Required. The parent resource of the dataset.
	Parent string `json:"parent,omitempty"`
	// SampleRule: Optional. The sample rule used for sampling conversations.
	SampleRule *GoogleCloudContactcenterinsightsV1alpha1SampleRule `json:"sampleRule,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DestinationDataset") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DestinationDataset") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1SampleConversationsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1SampleConversationsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1SampleConversationsResponse: The
// response to an SampleConversations operation.
type GoogleCloudContactcenterinsightsV1alpha1SampleConversationsResponse struct {
}

// GoogleCloudContactcenterinsightsV1alpha1SampleRule: Message for sampling
// conversations.
type GoogleCloudContactcenterinsightsV1alpha1SampleRule struct {
	// ConversationFilter: To specify the filter for the conversions that should
	// apply this sample rule. An empty filter means this sample rule applies to
	// all conversations.
	ConversationFilter string `json:"conversationFilter,omitempty"`
	// Dimension: Optional. Group by dimension to sample the conversation. If no
	// dimension is provided, the sampling will be applied to the project level.
	// Current supported dimensions is 'quality_metadata.agent_info.agent_id'.
	Dimension string `json:"dimension,omitempty"`
	// SamplePercentage: Percentage of conversations that we should sample based on
	// the dimension between [0, 100].
	SamplePercentage float64 `json:"samplePercentage,omitempty"`
	// SampleRow: Number of the conversations that we should sample based on the
	// dimension.
	SampleRow int64 `json:"sampleRow,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ConversationFilter") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationFilter") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1SampleRule) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1SampleRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1SampleRule) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1SampleRule
	var s1 struct {
		SamplePercentage gensupport.JSONFloat64 `json:"samplePercentage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SamplePercentage = float64(s1.SamplePercentage)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1SentimentData: The data for a
// sentiment annotation.
type GoogleCloudContactcenterinsightsV1alpha1SentimentData struct {
	// Magnitude: A non-negative number from 0 to infinity which represents the
	// absolute magnitude of sentiment regardless of score.
	Magnitude float64 `json:"magnitude,omitempty"`
	// Score: The sentiment score between -1.0 (negative) and 1.0 (positive).
	Score float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Magnitude") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Magnitude") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1SentimentData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1SentimentData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1SentimentData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1SentimentData
	var s1 struct {
		Magnitude gensupport.JSONFloat64 `json:"magnitude"`
		Score     gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Magnitude = float64(s1.Magnitude)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1SilenceData: The data for a silence
// annotation.
type GoogleCloudContactcenterinsightsV1alpha1SilenceData struct {
}

// GoogleCloudContactcenterinsightsV1alpha1SmartComposeSuggestionData: Agent
// Assist Smart Compose suggestion data.
type GoogleCloudContactcenterinsightsV1alpha1SmartComposeSuggestionData struct {
	// ConfidenceScore: The system's confidence score that this suggestion is a
	// good match for this conversation, ranging from 0.0 (completely uncertain) to
	// 1.0 (completely certain).
	ConfidenceScore float64 `json:"confidenceScore,omitempty"`
	// Metadata: Map that contains metadata about the Smart Compose suggestion and
	// the document from which it originates.
	Metadata map[string]string `json:"metadata,omitempty"`
	// QueryRecord: The name of the answer record. Format:
	// projects/{project}/locations/{location}/answerRecords/{answer_record}
	QueryRecord string `json:"queryRecord,omitempty"`
	// Suggestion: The content of the suggestion.
	Suggestion string `json:"suggestion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfidenceScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfidenceScore") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1SmartComposeSuggestionData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1SmartComposeSuggestionData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1SmartComposeSuggestionData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1SmartComposeSuggestionData
	var s1 struct {
		ConfidenceScore gensupport.JSONFloat64 `json:"confidenceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceScore = float64(s1.ConfidenceScore)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1SmartReplyData: Agent Assist Smart
// Reply data.
type GoogleCloudContactcenterinsightsV1alpha1SmartReplyData struct {
	// ConfidenceScore: The system's confidence score that this reply is a good
	// match for this conversation, ranging from 0.0 (completely uncertain) to 1.0
	// (completely certain).
	ConfidenceScore float64 `json:"confidenceScore,omitempty"`
	// Metadata: Map that contains metadata about the Smart Reply and the document
	// from which it originates.
	Metadata map[string]string `json:"metadata,omitempty"`
	// QueryRecord: The name of the answer record. Format:
	// projects/{project}/locations/{location}/answerRecords/{answer_record}
	QueryRecord string `json:"queryRecord,omitempty"`
	// Reply: The content of the reply.
	Reply string `json:"reply,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfidenceScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfidenceScore") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1SmartReplyData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1SmartReplyData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1SmartReplyData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1SmartReplyData
	var s1 struct {
		ConfidenceScore gensupport.JSONFloat64 `json:"confidenceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceScore = float64(s1.ConfidenceScore)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1SpeechConfig: Speech-to-Text
// configuration. Speech-to-Text settings are applied to conversations ingested
// from the `UploadConversation` and `IngestConversations` endpoints, including
// conversation coming from CCAI Platform. They are not applied to
// conversations ingested from the `CreateConversation` endpoint.
type GoogleCloudContactcenterinsightsV1alpha1SpeechConfig struct {
	// DisableWordTimeOffsets: Whether to disable word time offsets. If true, the
	// `enable_word_time_offsets` field in the recognition config will be set to
	// false.
	DisableWordTimeOffsets bool `json:"disableWordTimeOffsets,omitempty"`
	// SpeechRecognizer: The fully-qualified Speech Recognizer resource name.
	// Format: `projects/{project_id}/locations/{location}/recognizer/{recognizer}`
	SpeechRecognizer string `json:"speechRecognizer,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisableWordTimeOffsets") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisableWordTimeOffsets") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1SpeechConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1SpeechConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1TestCorrelationConfigMetadata:
// Metadata for testing correlation config.
type GoogleCloudContactcenterinsightsV1alpha1TestCorrelationConfigMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// Dataset: The dataset used for sampling conversations.
	Dataset string `json:"dataset,omitempty"`
	// Stats: The statistics for the operation.
	Stats *GoogleCloudContactcenterinsightsV1alpha1TestCorrelationConfigMetadataFullConversationCorrelationStats `json:"stats,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1TestCorrelationConfigMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1TestCorrelationConfigMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1TestCorrelationConfigMetadataFullConv
// ersationCorrelationStats: Statistics for TestCorrelationConfig operation.
type GoogleCloudContactcenterinsightsV1alpha1TestCorrelationConfigMetadataFullConversationCorrelationStats struct {
	// ConversationCorrelationErrors: A list of errors that occurred during
	// correlation, one for each conversation that failed.
	ConversationCorrelationErrors []*GoogleCloudContactcenterinsightsV1alpha1TestCorrelationConfigMetadataFullConversationCorrelationStatsConversationCorrelationError `json:"conversationCorrelationErrors,omitempty"`
	// CorrelatedConversationsCount: The number of conversations correlated.
	CorrelatedConversationsCount int64 `json:"correlatedConversationsCount,omitempty"`
	// FailedConversationsCount: The number of conversations that failed
	// correlation.
	FailedConversationsCount int64 `json:"failedConversationsCount,omitempty"`
	// PartialErrors: Partial errors during test correlation config operation that
	// might cause the operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// SampledConversationsCount: The number of conversations sampled.
	SampledConversationsCount int64 `json:"sampledConversationsCount,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "ConversationCorrelationErrors") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationCorrelationErrors")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1TestCorrelationConfigMetadataFullConversationCorrelationStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1TestCorrelationConfigMetadataFullConversationCorrelationStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1TestCorrelationConfigMetadataFullConv
// ersationCorrelationStatsConversationCorrelationError: An error that occurred
// during correlation for a specific conversation.
type GoogleCloudContactcenterinsightsV1alpha1TestCorrelationConfigMetadataFullConversationCorrelationStatsConversationCorrelationError struct {
	// Conversation: The conversation resource name that had an error during
	// correlation.
	Conversation string `json:"conversation,omitempty"`
	// Status: The error status.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conversation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conversation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1TestCorrelationConfigMetadataFullConversationCorrelationStatsConversationCorrelationError) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1TestCorrelationConfigMetadataFullConversationCorrelationStatsConversationCorrelationError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1TestCorrelationConfigResponse: The
// response of testing correlation config.
type GoogleCloudContactcenterinsightsV1alpha1TestCorrelationConfigResponse struct {
	// DetailedResults: Results for the DETAILED_SYNC execution mode.
	DetailedResults *GoogleCloudContactcenterinsightsV1alpha1TestCorrelationConfigResponseDetailedCorrelationResults `json:"detailedResults,omitempty"`
	// PartialErrors: Partial errors during test correlation config operation that
	// might cause the operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DetailedResults") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DetailedResults") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1TestCorrelationConfigResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1TestCorrelationConfigResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1TestCorrelationConfigResponseDetailed
// CorrelationResults: Wrapper for detailed, step-by-step results.
type GoogleCloudContactcenterinsightsV1alpha1TestCorrelationConfigResponseDetailedCorrelationResults struct {
	// ConstraintResults: A list of constraint evaluation results for each pair of
	// conversations.
	ConstraintResults []*GoogleCloudContactcenterinsightsV1alpha1ConstraintEvaluationResult `json:"constraintResults,omitempty"`
	// JoinKeyResults: A list of join key correlation results for each conversation
	// tested.
	JoinKeyResults []*GoogleCloudContactcenterinsightsV1alpha1ConversationCorrelationResult `json:"joinKeyResults,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConstraintResults") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConstraintResults") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1TestCorrelationConfigResponseDetailedCorrelationResults) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1TestCorrelationConfigResponseDetailedCorrelationResults
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelMetadata: Metadata
// for undeploying an issue model.
type GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original request for undeployment.
	Request *GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelRequest: The
// request to undeploy an issue model.
type GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelRequest struct {
	// Name: Required. The issue model to undeploy.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelResponse: The
// response to undeploy an issue model.
type GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelResponse struct {
}

// GoogleCloudContactcenterinsightsV1alpha1UpdateQaQuestionTagMetadata: The
// metadata for updating a QaQuestionTag Resource.
type GoogleCloudContactcenterinsightsV1alpha1UpdateQaQuestionTagMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: Output only. The original request.
	Request *GoogleCloudContactcenterinsightsV1alpha1UpdateQaQuestionTagRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1UpdateQaQuestionTagMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1UpdateQaQuestionTagMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1UpdateQaQuestionTagRequest: The
// request for updating a QaQuestionTag.
type GoogleCloudContactcenterinsightsV1alpha1UpdateQaQuestionTagRequest struct {
	// QaQuestionTag: Required. The QaQuestionTag to update.
	QaQuestionTag *GoogleCloudContactcenterinsightsV1alpha1QaQuestionTag `json:"qaQuestionTag,omitempty"`
	// UpdateMask: Optional. The list of fields to be updated. All possible fields
	// can be updated by passing `*`, or a subset of the following updateable
	// fields can be provided: * `qa_question_tag_name` - the name of the tag *
	// `qa_question_ids` - the list of questions the tag applies to
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QaQuestionTag") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QaQuestionTag") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1UpdateQaQuestionTagRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1UpdateQaQuestionTagRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1UploadConversationMetadata: The
// metadata for an `UploadConversation` operation.
type GoogleCloudContactcenterinsightsV1alpha1UploadConversationMetadata struct {
	// AnalysisOperation: Output only. The operation name for a successfully
	// created analysis operation, if any.
	AnalysisOperation string `json:"analysisOperation,omitempty"`
	// AppliedRedactionConfig: Output only. The redaction config applied to the
	// uploaded conversation.
	AppliedRedactionConfig *GoogleCloudContactcenterinsightsV1alpha1RedactionConfig `json:"appliedRedactionConfig,omitempty"`
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: Output only. The original request.
	Request *GoogleCloudContactcenterinsightsV1alpha1UploadConversationRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnalysisOperation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalysisOperation") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1UploadConversationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1UploadConversationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1UploadConversationRequest: Request
// to upload a conversation.
type GoogleCloudContactcenterinsightsV1alpha1UploadConversationRequest struct {
	// Conversation: Required. The conversation resource to create.
	Conversation *GoogleCloudContactcenterinsightsV1alpha1Conversation `json:"conversation,omitempty"`
	// ConversationId: Optional. A unique ID for the new conversation. This ID will
	// become the final component of the conversation's resource name. If no ID is
	// specified, a server-generated ID will be used. This value should be 4-64
	// characters and must match the regular expression `^[a-z0-9-]{4,64}$`. Valid
	// characters are `a-z-`
	ConversationId string `json:"conversationId,omitempty"`
	// Parent: Required. The parent resource of the conversation.
	Parent string `json:"parent,omitempty"`
	// RedactionConfig: Optional. DLP settings for transcript redaction. Will
	// default to the config specified in Settings.
	RedactionConfig *GoogleCloudContactcenterinsightsV1alpha1RedactionConfig `json:"redactionConfig,omitempty"`
	// SpeechConfig: Optional. Speech-to-Text configuration. Will default to the
	// config specified in Settings.
	SpeechConfig *GoogleCloudContactcenterinsightsV1alpha1SpeechConfig `json:"speechConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conversation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conversation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1UploadConversationRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1UploadConversationRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainAnalysis: The analysis resource.
type GoogleCloudContactcenterinsightsV1mainAnalysis struct {
	// AnalysisResult: Output only. The result of the analysis, which is populated
	// when the analysis finishes.
	AnalysisResult *GoogleCloudContactcenterinsightsV1mainAnalysisResult `json:"analysisResult,omitempty"`
	// AnnotatorSelector: To select the annotators to run and the phrase matchers
	// to use (if any). If not specified, all annotators will be run.
	AnnotatorSelector *GoogleCloudContactcenterinsightsV1mainAnnotatorSelector `json:"annotatorSelector,omitempty"`
	// CreateTime: Output only. The time at which the analysis was created, which
	// occurs when the long-running operation completes.
	CreateTime string `json:"createTime,omitempty"`
	// Name: Immutable. The resource name of the analysis. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}/analyses
	// /{analysis}
	Name string `json:"name,omitempty"`
	// RequestTime: Output only. The time at which the analysis was requested.
	RequestTime string `json:"requestTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnalysisResult") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalysisResult") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainAnalysis) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainAnalysis
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainAnalysisResult: The result of an
// analysis.
type GoogleCloudContactcenterinsightsV1mainAnalysisResult struct {
	// CallAnalysisMetadata: Call-specific metadata created by the analysis.
	CallAnalysisMetadata *GoogleCloudContactcenterinsightsV1mainAnalysisResultCallAnalysisMetadata `json:"callAnalysisMetadata,omitempty"`
	// EndTime: The time at which the analysis ended.
	EndTime string `json:"endTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CallAnalysisMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CallAnalysisMetadata") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainAnalysisResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainAnalysisResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainAnalysisResultCallAnalysisMetadata:
// Call-specific metadata created during analysis.
type GoogleCloudContactcenterinsightsV1mainAnalysisResultCallAnalysisMetadata struct {
	// Annotations: A list of call annotations that apply to this call.
	Annotations []*GoogleCloudContactcenterinsightsV1mainCallAnnotation `json:"annotations,omitempty"`
	// Entities: All the entities in the call.
	Entities map[string]GoogleCloudContactcenterinsightsV1mainEntity `json:"entities,omitempty"`
	// Intents: All the matched intents in the call.
	Intents map[string]GoogleCloudContactcenterinsightsV1mainIntent `json:"intents,omitempty"`
	// IssueModelResult: Overall conversation-level issue modeling result.
	IssueModelResult *GoogleCloudContactcenterinsightsV1mainIssueModelResult `json:"issueModelResult,omitempty"`
	// PhraseMatchers: All the matched phrase matchers in the call.
	PhraseMatchers map[string]GoogleCloudContactcenterinsightsV1mainPhraseMatchData `json:"phraseMatchers,omitempty"`
	// QaScorecardResults: Results of scoring QaScorecards.
	QaScorecardResults []*GoogleCloudContactcenterinsightsV1mainQaScorecardResult `json:"qaScorecardResults,omitempty"`
	// Sentiments: Overall conversation-level sentiment for each channel of the
	// call.
	Sentiments []*GoogleCloudContactcenterinsightsV1mainConversationLevelSentiment `json:"sentiments,omitempty"`
	// Silence: Overall conversation-level silence during the call.
	Silence *GoogleCloudContactcenterinsightsV1mainConversationLevelSilence `json:"silence,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainAnalysisResultCallAnalysisMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainAnalysisResultCallAnalysisMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainAnnotationBoundary: A point in a
// conversation that marks the start or the end of an annotation.
type GoogleCloudContactcenterinsightsV1mainAnnotationBoundary struct {
	// TranscriptIndex: The index in the sequence of transcribed pieces of the
	// conversation where the boundary is located. This index starts at zero.
	TranscriptIndex int64 `json:"transcriptIndex,omitempty"`
	// WordIndex: The word index of this boundary with respect to the first word in
	// the transcript piece. This index starts at zero.
	WordIndex int64 `json:"wordIndex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TranscriptIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TranscriptIndex") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainAnnotationBoundary) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainAnnotationBoundary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainAnnotatorSelector: Selector of all
// available annotators and phrase matchers to run.
type GoogleCloudContactcenterinsightsV1mainAnnotatorSelector struct {
	// IssueModels: The issue model to run. If not provided, the most recently
	// deployed topic model will be used. The provided issue model will only be
	// used for inference if the issue model is deployed and if
	// run_issue_model_annotator is set to true. If more than one issue model is
	// provided, only the first provided issue model will be used for inference.
	IssueModels []string `json:"issueModels,omitempty"`
	// PhraseMatchers: The list of phrase matchers to run. If not provided, all
	// active phrase matchers will be used. If inactive phrase matchers are
	// provided, they will not be used. Phrase matchers will be run only if
	// run_phrase_matcher_annotator is set to true. Format:
	// projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}
	PhraseMatchers []string `json:"phraseMatchers,omitempty"`
	// QaConfig: Configuration for the QA annotator.
	QaConfig *GoogleCloudContactcenterinsightsV1mainAnnotatorSelectorQaConfig `json:"qaConfig,omitempty"`
	// RunEntityAnnotator: Whether to run the entity annotator.
	RunEntityAnnotator bool `json:"runEntityAnnotator,omitempty"`
	// RunIntentAnnotator: Whether to run the intent annotator.
	RunIntentAnnotator bool `json:"runIntentAnnotator,omitempty"`
	// RunInterruptionAnnotator: Whether to run the interruption annotator.
	RunInterruptionAnnotator bool `json:"runInterruptionAnnotator,omitempty"`
	// RunIssueModelAnnotator: Whether to run the issue model annotator. A model
	// should have already been deployed for this to take effect.
	RunIssueModelAnnotator bool `json:"runIssueModelAnnotator,omitempty"`
	// RunPhraseMatcherAnnotator: Whether to run the active phrase matcher
	// annotator(s).
	RunPhraseMatcherAnnotator bool `json:"runPhraseMatcherAnnotator,omitempty"`
	// RunQaAnnotator: Whether to run the QA annotator.
	RunQaAnnotator bool `json:"runQaAnnotator,omitempty"`
	// RunSentimentAnnotator: Whether to run the sentiment annotator.
	RunSentimentAnnotator bool `json:"runSentimentAnnotator,omitempty"`
	// RunSilenceAnnotator: Whether to run the silence annotator.
	RunSilenceAnnotator bool `json:"runSilenceAnnotator,omitempty"`
	// RunSummarizationAnnotator: Whether to run the summarization annotator.
	RunSummarizationAnnotator bool `json:"runSummarizationAnnotator,omitempty"`
	// SummarizationConfig: Configuration for the summarization annotator.
	SummarizationConfig *GoogleCloudContactcenterinsightsV1mainAnnotatorSelectorSummarizationConfig `json:"summarizationConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IssueModels") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IssueModels") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainAnnotatorSelector) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainAnnotatorSelector
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainAnnotatorSelectorQaConfig:
// Configuration for the QA feature.
type GoogleCloudContactcenterinsightsV1mainAnnotatorSelectorQaConfig struct {
	// ScorecardList: A manual list of scorecards to score.
	ScorecardList *GoogleCloudContactcenterinsightsV1mainAnnotatorSelectorQaConfigScorecardList `json:"scorecardList,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ScorecardList") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ScorecardList") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainAnnotatorSelectorQaConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainAnnotatorSelectorQaConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainAnnotatorSelectorQaConfigScorecardList:
//
//	Container for a list of scorecards.
type GoogleCloudContactcenterinsightsV1mainAnnotatorSelectorQaConfigScorecardList struct {
	// QaScorecardRevisions: List of QaScorecardRevisions.
	QaScorecardRevisions []string `json:"qaScorecardRevisions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QaScorecardRevisions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QaScorecardRevisions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainAnnotatorSelectorQaConfigScorecardList) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainAnnotatorSelectorQaConfigScorecardList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainAnnotatorSelectorSummarizationConfig:
// Configuration for summarization.
type GoogleCloudContactcenterinsightsV1mainAnnotatorSelectorSummarizationConfig struct {
	// ConversationProfile: Resource name of the Dialogflow conversation profile.
	// Format:
	// projects/{project}/locations/{location}/conversationProfiles/{conversation_pr
	// ofile}
	ConversationProfile string `json:"conversationProfile,omitempty"`
	// Generator: The resource name of the existing created generator. Format:
	// projects//locations//generators/
	Generator string `json:"generator,omitempty"`
	// SummarizationModel: Default summarization model to be used.
	//
	// Possible values:
	//   "SUMMARIZATION_MODEL_UNSPECIFIED" - Unspecified summarization model.
	//   "BASELINE_MODEL" - The CCAI baseline model. This model is deprecated and
	// will be removed in the future. We recommend using `generator` instead.
	//   "BASELINE_MODEL_V2_0" - The CCAI baseline model, V2.0. This model is
	// deprecated and will be removed in the future. We recommend using `generator`
	// instead.
	SummarizationModel string `json:"summarizationModel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationProfile") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationProfile") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainAnnotatorSelectorSummarizationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainAnnotatorSelectorSummarizationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainAnswerFeedback: The feedback that the
// customer has about a certain answer in the conversation.
type GoogleCloudContactcenterinsightsV1mainAnswerFeedback struct {
	// Clicked: Indicates whether an answer or item was clicked by the human agent.
	Clicked bool `json:"clicked,omitempty"`
	// CorrectnessLevel: The correctness level of an answer.
	//
	// Possible values:
	//   "CORRECTNESS_LEVEL_UNSPECIFIED" - Correctness level unspecified.
	//   "NOT_CORRECT" - Answer is totally wrong.
	//   "PARTIALLY_CORRECT" - Answer is partially correct.
	//   "FULLY_CORRECT" - Answer is fully correct.
	CorrectnessLevel string `json:"correctnessLevel,omitempty"`
	// Displayed: Indicates whether an answer or item was displayed to the human
	// agent in the agent desktop UI.
	Displayed bool `json:"displayed,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Clicked") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Clicked") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainAnswerFeedback) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainAnswerFeedback
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainArticleSuggestionData: Agent Assist
// Article Suggestion data.
type GoogleCloudContactcenterinsightsV1mainArticleSuggestionData struct {
	// ConfidenceScore: The system's confidence score that this article is a good
	// match for this conversation, ranging from 0.0 (completely uncertain) to 1.0
	// (completely certain).
	ConfidenceScore float64 `json:"confidenceScore,omitempty"`
	// Metadata: Map that contains metadata about the Article Suggestion and the
	// document that it originates from.
	Metadata map[string]string `json:"metadata,omitempty"`
	// QueryRecord: The name of the answer record. Format:
	// projects/{project}/locations/{location}/answerRecords/{answer_record}
	QueryRecord string `json:"queryRecord,omitempty"`
	// Source: The knowledge document that this answer was extracted from. Format:
	// projects/{project}/knowledgeBases/{knowledge_base}/documents/{document}
	Source string `json:"source,omitempty"`
	// Title: Article title.
	Title string `json:"title,omitempty"`
	// Uri: Article URI.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfidenceScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfidenceScore") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainArticleSuggestionData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainArticleSuggestionData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1mainArticleSuggestionData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1mainArticleSuggestionData
	var s1 struct {
		ConfidenceScore gensupport.JSONFloat64 `json:"confidenceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceScore = float64(s1.ConfidenceScore)
	return nil
}

// GoogleCloudContactcenterinsightsV1mainBulkAnalyzeConversationsMetadata: The
// metadata for a bulk analyze conversations operation.
type GoogleCloudContactcenterinsightsV1mainBulkAnalyzeConversationsMetadata struct {
	// CompletedAnalysesCount: The number of requested analyses that have completed
	// successfully so far.
	CompletedAnalysesCount int64 `json:"completedAnalysesCount,omitempty"`
	// CreateTime: The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// FailedAnalysesCount: The number of requested analyses that have failed so
	// far.
	FailedAnalysesCount int64 `json:"failedAnalysesCount,omitempty"`
	// PartialErrors: Output only. Partial errors during bulk analyze operation
	// that might cause the operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: The original request for bulk analyze.
	Request *GoogleCloudContactcenterinsightsV1mainBulkAnalyzeConversationsRequest `json:"request,omitempty"`
	// TotalRequestedAnalysesCount: Total number of analyses requested. Computed by
	// the number of conversations returned by `filter` multiplied by
	// `analysis_percentage` in the request.
	TotalRequestedAnalysesCount int64 `json:"totalRequestedAnalysesCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompletedAnalysesCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompletedAnalysesCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainBulkAnalyzeConversationsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainBulkAnalyzeConversationsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainBulkAnalyzeConversationsRequest: The
// request to analyze conversations in bulk.
type GoogleCloudContactcenterinsightsV1mainBulkAnalyzeConversationsRequest struct {
	// AnalysisPercentage: Required. Percentage of selected conversation to
	// analyze, between [0, 100].
	AnalysisPercentage float64 `json:"analysisPercentage,omitempty"`
	// AnnotatorSelector: To select the annotators to run and the phrase matchers
	// to use (if any). If not specified, all annotators will be run.
	AnnotatorSelector *GoogleCloudContactcenterinsightsV1mainAnnotatorSelector `json:"annotatorSelector,omitempty"`
	// Filter: Required. Filter used to select the subset of conversations to
	// analyze.
	Filter string `json:"filter,omitempty"`
	// Parent: Required. The parent resource to create analyses in.
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnalysisPercentage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalysisPercentage") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainBulkAnalyzeConversationsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainBulkAnalyzeConversationsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1mainBulkAnalyzeConversationsRequest) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1mainBulkAnalyzeConversationsRequest
	var s1 struct {
		AnalysisPercentage gensupport.JSONFloat64 `json:"analysisPercentage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AnalysisPercentage = float64(s1.AnalysisPercentage)
	return nil
}

// GoogleCloudContactcenterinsightsV1mainBulkAnalyzeConversationsResponse: The
// response for a bulk analyze conversations operation.
type GoogleCloudContactcenterinsightsV1mainBulkAnalyzeConversationsResponse struct {
	// FailedAnalysisCount: Count of failed analyses.
	FailedAnalysisCount int64 `json:"failedAnalysisCount,omitempty"`
	// SuccessfulAnalysisCount: Count of successful analyses.
	SuccessfulAnalysisCount int64 `json:"successfulAnalysisCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FailedAnalysisCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FailedAnalysisCount") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainBulkAnalyzeConversationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainBulkAnalyzeConversationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainBulkDeleteConversationsMetadata: The
// metadata for a bulk delete conversations operation.
type GoogleCloudContactcenterinsightsV1mainBulkDeleteConversationsMetadata struct {
	// CreateTime: The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// PartialErrors: Partial errors during bulk delete conversations operation
	// that might cause the operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: The original request for bulk delete.
	Request *GoogleCloudContactcenterinsightsV1mainBulkDeleteConversationsRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainBulkDeleteConversationsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainBulkDeleteConversationsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainBulkDeleteConversationsRequest: The
// request to delete conversations in bulk.
type GoogleCloudContactcenterinsightsV1mainBulkDeleteConversationsRequest struct {
	// Filter: Filter used to select the subset of conversations to delete.
	Filter string `json:"filter,omitempty"`
	// Force: If set to true, all of this conversation's analyses will also be
	// deleted. Otherwise, the request will only succeed if the conversation has no
	// analyses.
	Force bool `json:"force,omitempty"`
	// MaxDeleteCount: Maximum number of conversations to delete.
	MaxDeleteCount int64 `json:"maxDeleteCount,omitempty"`
	// Parent: Required. The parent resource to delete conversations from. Format:
	// projects/{project}/locations/{location}
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainBulkDeleteConversationsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainBulkDeleteConversationsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainBulkDeleteConversationsResponse: The
// response for a bulk delete conversations operation.
type GoogleCloudContactcenterinsightsV1mainBulkDeleteConversationsResponse struct {
}

// GoogleCloudContactcenterinsightsV1mainBulkDeleteFeedbackLabelsMetadata:
// Metadata for the BulkDeleteFeedbackLabels endpoint.
type GoogleCloudContactcenterinsightsV1mainBulkDeleteFeedbackLabelsMetadata struct {
	// PartialErrors: Partial errors during deletion operation that might cause the
	// operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: Output only. The original request for delete.
	Request *GoogleCloudContactcenterinsightsV1mainBulkDeleteFeedbackLabelsRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PartialErrors") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PartialErrors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainBulkDeleteFeedbackLabelsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainBulkDeleteFeedbackLabelsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainBulkDeleteFeedbackLabelsRequest:
// Request for the BulkDeleteFeedbackLabels endpoint.
type GoogleCloudContactcenterinsightsV1mainBulkDeleteFeedbackLabelsRequest struct {
	// Filter: Optional. A filter to reduce results to a specific subset. Supports
	// disjunctions (OR) and conjunctions (AND). Supported fields: *
	// `issue_model_id` * `qa_question_id` * `qa_scorecard_id` * `min_create_time`
	// * `max_create_time` * `min_update_time` * `max_update_time` *
	// `feedback_label_type`: QUALITY_AI, TOPIC_MODELING
	Filter string `json:"filter,omitempty"`
	// Parent: Required. The parent resource for new feedback labels.
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainBulkDeleteFeedbackLabelsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainBulkDeleteFeedbackLabelsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainBulkDeleteFeedbackLabelsResponse:
// Response for the BulkDeleteFeedbackLabels endpoint.
type GoogleCloudContactcenterinsightsV1mainBulkDeleteFeedbackLabelsResponse struct {
}

// GoogleCloudContactcenterinsightsV1mainBulkDownloadFeedbackLabelsMetadata:
// Metadata for the BulkDownloadFeedbackLabel endpoint.
type GoogleCloudContactcenterinsightsV1mainBulkDownloadFeedbackLabelsMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// DownloadStats: Output only. Statistics for BulkDownloadFeedbackLabels
	// operation.
	DownloadStats *GoogleCloudContactcenterinsightsV1mainBulkDownloadFeedbackLabelsMetadataDownloadStats `json:"downloadStats,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// PartialErrors: Partial errors during ingest operation that might cause the
	// operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: Output only. The original request for download.
	Request *GoogleCloudContactcenterinsightsV1mainBulkDownloadFeedbackLabelsRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainBulkDownloadFeedbackLabelsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainBulkDownloadFeedbackLabelsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainBulkDownloadFeedbackLabelsMetadataDownl
// oadStats: Statistics for BulkDownloadFeedbackLabels operation.
type GoogleCloudContactcenterinsightsV1mainBulkDownloadFeedbackLabelsMetadataDownloadStats struct {
	// FileNames: Output only. Full name of the files written to Cloud storage.
	FileNames []string `json:"fileNames,omitempty"`
	// ProcessedObjectCount: The number of objects processed during the download
	// operation.
	ProcessedObjectCount int64 `json:"processedObjectCount,omitempty"`
	// SuccessfulDownloadCount: The number of new feedback labels downloaded during
	// this operation. Different from "processed" because some labels might not be
	// downloaded because an error.
	SuccessfulDownloadCount int64 `json:"successfulDownloadCount,omitempty"`
	// TotalFilesWritten: Total number of files written to the provided Cloud
	// Storage bucket.
	TotalFilesWritten int64 `json:"totalFilesWritten,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FileNames") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FileNames") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainBulkDownloadFeedbackLabelsMetadataDownloadStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainBulkDownloadFeedbackLabelsMetadataDownloadStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainBulkDownloadFeedbackLabelsRequest:
// Request for the BulkDownloadFeedbackLabel endpoint.
type GoogleCloudContactcenterinsightsV1mainBulkDownloadFeedbackLabelsRequest struct {
	// ConversationFilter: Optional. Filter parent conversations to download
	// feedback labels for. When specified, the feedback labels will be downloaded
	// for the conversations that match the filter. If `template_qa_scorecard_id`
	// is set, all the conversations that match the filter will be paired with the
	// questions under the scorecard for labeling.
	ConversationFilter string `json:"conversationFilter,omitempty"`
	// FeedbackLabelType: Optional. The type of feedback labels that will be
	// downloaded.
	//
	// Possible values:
	//   "FEEDBACK_LABEL_TYPE_UNSPECIFIED" - Unspecified format
	//   "QUALITY_AI" - Downloaded file will contain all Quality AI labels from the
	// latest scorecard revision.
	//   "TOPIC_MODELING" - Downloaded file will contain only Topic Modeling
	// labels.
	//   "AGENT_ASSIST_SUMMARY" - Agent Assist Summarization labels.
	FeedbackLabelType string `json:"feedbackLabelType,omitempty"`
	// Filter: Optional. A filter to reduce results to a specific subset. Supports
	// disjunctions (OR) and conjunctions (AND). Supported fields: *
	// `issue_model_id` * `qa_question_id` * `qa_scorecard_id` * `min_create_time`
	// * `max_create_time` * `min_update_time` * `max_update_time` *
	// `feedback_label_type`: QUALITY_AI, TOPIC_MODELING
	Filter string `json:"filter,omitempty"`
	// GcsDestination: A cloud storage bucket destination.
	GcsDestination *GoogleCloudContactcenterinsightsV1mainBulkDownloadFeedbackLabelsRequestGcsDestination `json:"gcsDestination,omitempty"`
	// MaxDownloadCount: Optional. Limits the maximum number of feedback labels
	// that will be downloaded. The first `N` feedback labels will be downloaded.
	MaxDownloadCount int64 `json:"maxDownloadCount,omitempty"`
	// Parent: Required. The parent resource for new feedback labels.
	Parent string `json:"parent,omitempty"`
	// SheetsDestination: A sheets document destination.
	SheetsDestination *GoogleCloudContactcenterinsightsV1mainBulkDownloadFeedbackLabelsRequestSheetsDestination `json:"sheetsDestination,omitempty"`
	// TemplateQaScorecardId: Optional. If set, a template for labeling
	// conversations and scorecard questions will be created from the
	// conversation_filter and the questions under the scorecard(s). The feedback
	// label `filter` will be ignored.
	TemplateQaScorecardId []string `json:"templateQaScorecardId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationFilter") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationFilter") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainBulkDownloadFeedbackLabelsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainBulkDownloadFeedbackLabelsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainBulkDownloadFeedbackLabelsRequestGcsDes
// tination: Google Cloud Storage Object details to write the feedback labels
// to.
type GoogleCloudContactcenterinsightsV1mainBulkDownloadFeedbackLabelsRequestGcsDestination struct {
	// AddWhitespace: Optional. Add whitespace to the JSON file. Makes easier to
	// read, but increases file size. Only applicable for JSON format.
	AddWhitespace bool `json:"addWhitespace,omitempty"`
	// AlwaysPrintEmptyFields: Optional. Always print fields with no presence. This
	// is useful for printing fields that are not set, like implicit 0 value or
	// empty lists/maps. Only applicable for JSON format.
	AlwaysPrintEmptyFields bool `json:"alwaysPrintEmptyFields,omitempty"`
	// Format: Required. File format in which the labels will be exported.
	//
	// Possible values:
	//   "FORMAT_UNSPECIFIED" - Unspecified format.
	//   "CSV" - CSV format. 1,000 labels are stored per CSV file by default.
	//   "JSON" - JSON format. 1 label stored per JSON file by default.
	Format string `json:"format,omitempty"`
	// ObjectUri: Required. The Google Cloud Storage URI to write the feedback
	// labels to. The file name will be used as a prefix for the files written to
	// the bucket if the output needs to be split across multiple files, otherwise
	// it will be used as is. The file extension will be appended to the file name
	// based on the format selected. E.g. `gs://bucket_name/object_uri_prefix`
	ObjectUri string `json:"objectUri,omitempty"`
	// RecordsPerFileCount: Optional. The number of records per file. Applicable
	// for either format.
	RecordsPerFileCount int64 `json:"recordsPerFileCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "AddWhitespace") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AddWhitespace") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainBulkDownloadFeedbackLabelsRequestGcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainBulkDownloadFeedbackLabelsRequestGcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainBulkDownloadFeedbackLabelsRequestSheets
// Destination: Google Sheets document details to write the feedback labels to.
type GoogleCloudContactcenterinsightsV1mainBulkDownloadFeedbackLabelsRequestSheetsDestination struct {
	// SheetTitle: Optional. The title of the new sheet to write the feedback
	// labels to.
	SheetTitle string `json:"sheetTitle,omitempty"`
	// SpreadsheetUri: Required. The Google Sheets document to write the feedback
	// labels to. Retrieved from Google Sheets URI. E.g.
	// `https://docs.google.com/spreadsheets/d/1234567890` The spreadsheet must be
	// shared with the Insights P4SA. The spreadsheet ID written to will be
	// returned as `file_names` in the BulkDownloadFeedbackLabelsMetadata.
	SpreadsheetUri string `json:"spreadsheetUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SheetTitle") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SheetTitle") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainBulkDownloadFeedbackLabelsRequestSheetsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainBulkDownloadFeedbackLabelsRequestSheetsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainBulkDownloadFeedbackLabelsResponse:
// Response for the BulkDownloadFeedbackLabel endpoint.
type GoogleCloudContactcenterinsightsV1mainBulkDownloadFeedbackLabelsResponse struct {
}

// GoogleCloudContactcenterinsightsV1mainCallAnnotation: A piece of metadata
// that applies to a window of a call.
type GoogleCloudContactcenterinsightsV1mainCallAnnotation struct {
	// AnnotationEndBoundary: The boundary in the conversation where the annotation
	// ends, inclusive.
	AnnotationEndBoundary *GoogleCloudContactcenterinsightsV1mainAnnotationBoundary `json:"annotationEndBoundary,omitempty"`
	// AnnotationStartBoundary: The boundary in the conversation where the
	// annotation starts, inclusive.
	AnnotationStartBoundary *GoogleCloudContactcenterinsightsV1mainAnnotationBoundary `json:"annotationStartBoundary,omitempty"`
	// ChannelTag: The channel of the audio where the annotation occurs. For
	// single-channel audio, this field is not populated.
	ChannelTag int64 `json:"channelTag,omitempty"`
	// EntityMentionData: Data specifying an entity mention.
	EntityMentionData *GoogleCloudContactcenterinsightsV1mainEntityMentionData `json:"entityMentionData,omitempty"`
	// HoldData: Data specifying a hold.
	HoldData *GoogleCloudContactcenterinsightsV1mainHoldData `json:"holdData,omitempty"`
	// IntentMatchData: Data specifying an intent match.
	IntentMatchData *GoogleCloudContactcenterinsightsV1mainIntentMatchData `json:"intentMatchData,omitempty"`
	// InterruptionData: Data specifying an interruption.
	InterruptionData *GoogleCloudContactcenterinsightsV1mainInterruptionData `json:"interruptionData,omitempty"`
	// IssueMatchData: Data specifying an issue match.
	IssueMatchData *GoogleCloudContactcenterinsightsV1mainIssueMatchData `json:"issueMatchData,omitempty"`
	// PhraseMatchData: Data specifying a phrase match.
	PhraseMatchData *GoogleCloudContactcenterinsightsV1mainPhraseMatchData `json:"phraseMatchData,omitempty"`
	// SentimentData: Data specifying sentiment.
	SentimentData *GoogleCloudContactcenterinsightsV1mainSentimentData `json:"sentimentData,omitempty"`
	// SilenceData: Data specifying silence.
	SilenceData *GoogleCloudContactcenterinsightsV1mainSilenceData `json:"silenceData,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationEndBoundary") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationEndBoundary") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainCallAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainCallAnnotation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainConstraintEvaluationResult: The result
// of testing a constraint expression on a pair of conversations.
type GoogleCloudContactcenterinsightsV1mainConstraintEvaluationResult struct {
	// ConversationA: The first conversation resource name.
	ConversationA string `json:"conversationA,omitempty"`
	// ConversationB: The second conversation resource name.
	ConversationB string `json:"conversationB,omitempty"`
	// RuleConstraintResults: The results for each applicable constraint rule.
	RuleConstraintResults []*GoogleCloudContactcenterinsightsV1mainConstraintEvaluationResultRuleConstraintResult `json:"ruleConstraintResults,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationA") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationA") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainConstraintEvaluationResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainConstraintEvaluationResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainConstraintEvaluationResultRuleConstrain
// tResult: The result of a single constraint rule on the pair of
// conversations.
type GoogleCloudContactcenterinsightsV1mainConstraintEvaluationResultRuleConstraintResult struct {
	// ConstraintMet: Whether the constraint expression evaluated to true for (A,
	// B) or (B, A).
	ConstraintMet bool `json:"constraintMet,omitempty"`
	// Error: The error status if the constraint expression failed to evaluate.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// RuleId: The rule ID.
	RuleId string `json:"ruleId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConstraintMet") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConstraintMet") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainConstraintEvaluationResultRuleConstraintResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainConstraintEvaluationResultRuleConstraintResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainConversation: The conversation
// resource.
type GoogleCloudContactcenterinsightsV1mainConversation struct {
	// AgentId: An opaque, user-specified string representing the human agent who
	// handled the conversation.
	AgentId string `json:"agentId,omitempty"`
	// CallMetadata: Call-specific metadata.
	CallMetadata *GoogleCloudContactcenterinsightsV1mainConversationCallMetadata `json:"callMetadata,omitempty"`
	// CorrelationInfo: Output only. Info for correlating across conversations.
	CorrelationInfo *GoogleCloudContactcenterinsightsV1mainConversationCorrelationInfo `json:"correlationInfo,omitempty"`
	// CreateTime: Output only. The time at which the conversation was created.
	CreateTime string `json:"createTime,omitempty"`
	// DataSource: The source of the audio and transcription for the conversation.
	DataSource *GoogleCloudContactcenterinsightsV1mainConversationDataSource `json:"dataSource,omitempty"`
	// DialogflowIntents: Output only. All the matched Dialogflow intents in the
	// call. The key corresponds to a Dialogflow intent, format:
	// projects/{project}/agent/{agent}/intents/{intent}
	DialogflowIntents map[string]GoogleCloudContactcenterinsightsV1mainDialogflowIntent `json:"dialogflowIntents,omitempty"`
	// Duration: Output only. The duration of the conversation.
	Duration string `json:"duration,omitempty"`
	// ExpireTime: The time at which this conversation should expire. After this
	// time, the conversation data and any associated analyses will be deleted.
	ExpireTime string `json:"expireTime,omitempty"`
	// Labels: A map for the user to specify any custom fields. A maximum of 100
	// labels per conversation is allowed, with a maximum of 256 characters per
	// entry.
	Labels map[string]string `json:"labels,omitempty"`
	// LanguageCode: A user-specified language code for the conversation.
	LanguageCode string `json:"languageCode,omitempty"`
	// LatestAnalysis: Output only. The conversation's latest analysis, if one
	// exists.
	LatestAnalysis *GoogleCloudContactcenterinsightsV1mainAnalysis `json:"latestAnalysis,omitempty"`
	// LatestSummary: Output only. Latest summary of the conversation.
	LatestSummary *GoogleCloudContactcenterinsightsV1mainConversationSummarizationSuggestionData `json:"latestSummary,omitempty"`
	// Medium: Immutable. The conversation medium.
	//
	// Possible values:
	//   "MEDIUM_UNSPECIFIED" - Default value for unspecified.
	//   "PHONE_CALL" - The format for conversations that took place over the
	// phone.
	//   "CHAT" - The format for conversations that took place over chat.
	Medium string `json:"medium,omitempty"`
	// MetadataJson: Input only. JSON metadata encoded as a string. This field is
	// primarily used by Insights integrations with various telephony systems and
	// must be in one of Insight's supported formats.
	MetadataJson string `json:"metadataJson,omitempty"`
	// Name: Immutable. The resource name of the conversation. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}
	Name string `json:"name,omitempty"`
	// ObfuscatedUserId: Obfuscated user ID which the customer sent to us.
	ObfuscatedUserId string `json:"obfuscatedUserId,omitempty"`
	// QualityMetadata: Conversation metadata related to quality management.
	QualityMetadata *GoogleCloudContactcenterinsightsV1mainConversationQualityMetadata `json:"qualityMetadata,omitempty"`
	// RuntimeAnnotations: Output only. The annotations that were generated during
	// the customer and agent interaction.
	RuntimeAnnotations []*GoogleCloudContactcenterinsightsV1mainRuntimeAnnotation `json:"runtimeAnnotations,omitempty"`
	// StartTime: The time at which the conversation started.
	StartTime string `json:"startTime,omitempty"`
	// Transcript: Output only. The conversation transcript.
	Transcript *GoogleCloudContactcenterinsightsV1mainConversationTranscript `json:"transcript,omitempty"`
	// Ttl: Input only. The TTL for this resource. If specified, then this TTL will
	// be used to calculate the expire time.
	Ttl string `json:"ttl,omitempty"`
	// TurnCount: Output only. The number of turns in the conversation.
	TurnCount int64 `json:"turnCount,omitempty"`
	// UpdateTime: Output only. The most recent time at which the conversation was
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainConversation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainConversation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainConversationCallMetadata:
// Call-specific metadata.
type GoogleCloudContactcenterinsightsV1mainConversationCallMetadata struct {
	// AgentChannel: The audio channel that contains the agent.
	AgentChannel int64 `json:"agentChannel,omitempty"`
	// CustomerChannel: The audio channel that contains the customer.
	CustomerChannel int64 `json:"customerChannel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentChannel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentChannel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainConversationCallMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainConversationCallMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainConversationCorrelationInfo: Info for
// correlating across conversations.
type GoogleCloudContactcenterinsightsV1mainConversationCorrelationInfo struct {
	// CorrelationTypes: Output only. The correlation types of this conversation. A
	// single conversation can have multiple correlation types. For example a
	// conversation that only has a single segment is both a SEGMENT and a
	// FULL_CONVERSATION.
	//
	// Possible values:
	//   "CORRELATION_TYPE_UNSPECIFIED" - Default value for unspecified.
	//   "SEGMENT" - This conversation represents a segment of a full conversation.
	// The lowest level of granularity.
	//   "PARTIAL" - This conversation represents a partial conversation of
	// potentially multiple segments but is not a full conversation.
	//   "FULL" - This conversation represents a full conversation of potentially
	// multiple segments.
	//   "SYNTHETIC" - This conversation represents a synthetic conversation.
	CorrelationTypes []string `json:"correlationTypes,omitempty"`
	// FullConversationCorrelationId: Output only. The full conversation
	// correlation id this conversation is a segment of.
	FullConversationCorrelationId string `json:"fullConversationCorrelationId,omitempty"`
	// MergedFullConversationCorrelationId: Output only. The full conversation
	// correlation id this conversation is a merged conversation of.
	MergedFullConversationCorrelationId string `json:"mergedFullConversationCorrelationId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CorrelationTypes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CorrelationTypes") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainConversationCorrelationInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainConversationCorrelationInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainConversationCorrelationResult: The
// result of testing correlation config on a single conversation.
type GoogleCloudContactcenterinsightsV1mainConversationCorrelationResult struct {
	// Conversation: The conversation resource name.
	Conversation string `json:"conversation,omitempty"`
	// RuleResults: The results for each correlation rule.
	RuleResults []*GoogleCloudContactcenterinsightsV1mainConversationCorrelationResultRuleCorrelationResult `json:"ruleResults,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conversation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conversation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainConversationCorrelationResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainConversationCorrelationResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainConversationCorrelationResultRuleCorrel
// ationResult: The result of a single correlation rule.
type GoogleCloudContactcenterinsightsV1mainConversationCorrelationResultRuleCorrelationResult struct {
	// CorrelationId: The correlation ID generated by the join key expression.
	CorrelationId string `json:"correlationId,omitempty"`
	// Error: The error status if the join key expression failed to evaluate.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// RuleId: The rule ID.
	RuleId string `json:"ruleId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CorrelationId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CorrelationId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainConversationCorrelationResultRuleCorrelationResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainConversationCorrelationResultRuleCorrelationResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainConversationDataSource: The
// conversation source, which is a combination of transcript and audio.
type GoogleCloudContactcenterinsightsV1mainConversationDataSource struct {
	// DialogflowSource: The source when the conversation comes from Dialogflow.
	DialogflowSource *GoogleCloudContactcenterinsightsV1mainDialogflowSource `json:"dialogflowSource,omitempty"`
	// GcsSource: A Cloud Storage location specification for the audio and
	// transcript.
	GcsSource *GoogleCloudContactcenterinsightsV1mainGcsSource `json:"gcsSource,omitempty"`
	// MetadataUri: Cloud Storage URI that points to a file that contains the
	// conversation metadata.
	MetadataUri string `json:"metadataUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DialogflowSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DialogflowSource") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainConversationDataSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainConversationDataSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainConversationLevelSentiment: One
// channel of conversation-level sentiment data.
type GoogleCloudContactcenterinsightsV1mainConversationLevelSentiment struct {
	// ChannelTag: The channel of the audio that the data applies to.
	ChannelTag int64 `json:"channelTag,omitempty"`
	// SentimentData: Data specifying sentiment.
	SentimentData *GoogleCloudContactcenterinsightsV1mainSentimentData `json:"sentimentData,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChannelTag") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChannelTag") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainConversationLevelSentiment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainConversationLevelSentiment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainConversationLevelSilence:
// Conversation-level silence data.
type GoogleCloudContactcenterinsightsV1mainConversationLevelSilence struct {
	// SilenceDuration: Amount of time calculated to be in silence.
	SilenceDuration string `json:"silenceDuration,omitempty"`
	// SilencePercentage: Percentage of the total conversation spent in silence.
	SilencePercentage float64 `json:"silencePercentage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SilenceDuration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SilenceDuration") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainConversationLevelSilence) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainConversationLevelSilence
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1mainConversationLevelSilence) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1mainConversationLevelSilence
	var s1 struct {
		SilencePercentage gensupport.JSONFloat64 `json:"silencePercentage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SilencePercentage = float64(s1.SilencePercentage)
	return nil
}

// GoogleCloudContactcenterinsightsV1mainConversationParticipant: The call
// participant speaking for a given utterance.
type GoogleCloudContactcenterinsightsV1mainConversationParticipant struct {
	// DialogflowParticipant: Deprecated. Use `dialogflow_participant_name`
	// instead. The name of the Dialogflow participant. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}/particip
	// ants/{participant}
	DialogflowParticipant string `json:"dialogflowParticipant,omitempty"`
	// DialogflowParticipantName: The name of the participant provided by
	// Dialogflow. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}/particip
	// ants/{participant}
	DialogflowParticipantName string `json:"dialogflowParticipantName,omitempty"`
	// ObfuscatedExternalUserId: Obfuscated user ID from Dialogflow.
	ObfuscatedExternalUserId string `json:"obfuscatedExternalUserId,omitempty"`
	// Role: The role of the participant.
	//
	// Possible values:
	//   "ROLE_UNSPECIFIED" - Participant's role is not set.
	//   "HUMAN_AGENT" - Participant is a human agent.
	//   "AUTOMATED_AGENT" - Participant is an automated agent.
	//   "END_USER" - Participant is an end user who conversed with the contact
	// center.
	//   "ANY_AGENT" - Participant is either a human or automated agent.
	Role string `json:"role,omitempty"`
	// UserId: A user-specified ID representing the participant.
	UserId string `json:"userId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DialogflowParticipant") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DialogflowParticipant") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainConversationParticipant) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainConversationParticipant
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainConversationQualityMetadata:
// Conversation metadata related to quality management.
type GoogleCloudContactcenterinsightsV1mainConversationQualityMetadata struct {
	// AgentInfo: Information about agents involved in the call.
	AgentInfo []*GoogleCloudContactcenterinsightsV1mainConversationQualityMetadataAgentInfo `json:"agentInfo,omitempty"`
	// CustomerSatisfactionRating: An arbitrary integer value indicating the
	// customer's satisfaction rating.
	CustomerSatisfactionRating int64 `json:"customerSatisfactionRating,omitempty"`
	// FeedbackLabels: Input only. The feedback labels associated with the
	// conversation.
	FeedbackLabels []*GoogleCloudContactcenterinsightsV1mainFeedbackLabel `json:"feedbackLabels,omitempty"`
	// MenuPath: An arbitrary string value specifying the menu path the customer
	// took.
	MenuPath string `json:"menuPath,omitempty"`
	// WaitDuration: The amount of time the customer waited to connect with an
	// agent.
	WaitDuration string `json:"waitDuration,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainConversationQualityMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainConversationQualityMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainConversationQualityMetadataAgentInfo:
// Information about an agent involved in the conversation.
type GoogleCloudContactcenterinsightsV1mainConversationQualityMetadataAgentInfo struct {
	// AgentId: A user-specified string representing the agent.
	AgentId string `json:"agentId,omitempty"`
	// AgentType: The agent type, e.g. HUMAN_AGENT.
	//
	// Possible values:
	//   "ROLE_UNSPECIFIED" - Participant's role is not set.
	//   "HUMAN_AGENT" - Participant is a human agent.
	//   "AUTOMATED_AGENT" - Participant is an automated agent.
	//   "END_USER" - Participant is an end user who conversed with the contact
	// center.
	//   "ANY_AGENT" - Participant is either a human or automated agent.
	AgentType string `json:"agentType,omitempty"`
	// DeploymentDisplayName: The agent's deployment display name. Only applicable
	// to automated agents.
	DeploymentDisplayName string `json:"deploymentDisplayName,omitempty"`
	// DeploymentId: The agent's deployment ID. Only applicable to automated
	// agents.
	DeploymentId string `json:"deploymentId,omitempty"`
	// DisplayName: The agent's name.
	DisplayName string `json:"displayName,omitempty"`
	// DispositionCode: A user-provided string indicating the outcome of the
	// agent's segment of the call.
	DispositionCode string `json:"dispositionCode,omitempty"`
	// Location: The agent's location.
	Location string `json:"location,omitempty"`
	// Team: A user-specified string representing the agent's team. Deprecated in
	// favor of the `teams` field.
	Team string `json:"team,omitempty"`
	// Teams: User-specified strings representing the agent's teams.
	Teams []string `json:"teams,omitempty"`
	// VersionDisplayName: The agent's version display name. Only applicable to
	// automated agents.
	VersionDisplayName string `json:"versionDisplayName,omitempty"`
	// VersionId: The agent's version ID. Only applicable to automated agents.
	VersionId string `json:"versionId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainConversationQualityMetadataAgentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainConversationQualityMetadataAgentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainConversationSummarizationSuggestionData
// : Conversation summarization suggestion data.
type GoogleCloudContactcenterinsightsV1mainConversationSummarizationSuggestionData struct {
	// AnswerRecord: The name of the answer record. Format:
	// projects/{project}/locations/{location}/answerRecords/{answer_record}
	AnswerRecord string `json:"answerRecord,omitempty"`
	// Confidence: The confidence score of the summarization.
	Confidence float64 `json:"confidence,omitempty"`
	// ConversationModel: The name of the model that generates this summary.
	// Format:
	// projects/{project}/locations/{location}/conversationModels/{conversation_mode
	// l}
	ConversationModel string `json:"conversationModel,omitempty"`
	// GeneratorId: Agent Assist generator ID.
	GeneratorId string `json:"generatorId,omitempty"`
	// Metadata: A map that contains metadata about the summarization and the
	// document from which it originates.
	Metadata map[string]string `json:"metadata,omitempty"`
	// Text: The summarization content that is concatenated into one string.
	Text string `json:"text,omitempty"`
	// TextSections: The summarization content that is divided into sections. The
	// key is the section's name and the value is the section's content. There is
	// no specific format for the key or value.
	TextSections map[string]string `json:"textSections,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainConversationSummarizationSuggestionData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainConversationSummarizationSuggestionData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1mainConversationSummarizationSuggestionData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1mainConversationSummarizationSuggestionData
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudContactcenterinsightsV1mainConversationTranscript: A message
// representing the transcript of a conversation.
type GoogleCloudContactcenterinsightsV1mainConversationTranscript struct {
	// TranscriptSegments: A list of sequential transcript segments that comprise
	// the conversation.
	TranscriptSegments []*GoogleCloudContactcenterinsightsV1mainConversationTranscriptTranscriptSegment `json:"transcriptSegments,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TranscriptSegments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TranscriptSegments") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainConversationTranscript) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainConversationTranscript
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainConversationTranscriptTranscriptSegment
// : A segment of a full transcript.
type GoogleCloudContactcenterinsightsV1mainConversationTranscriptTranscriptSegment struct {
	// ChannelTag: For conversations derived from multi-channel audio, this is the
	// channel number corresponding to the audio from that channel. For
	// audioChannelCount = N, its output values can range from '1' to 'N'. A
	// channel tag of 0 indicates that the audio is mono.
	ChannelTag int64 `json:"channelTag,omitempty"`
	// Confidence: A confidence estimate between 0.0 and 1.0 of the fidelity of
	// this segment. A default value of 0.0 indicates that the value is unset.
	Confidence float64 `json:"confidence,omitempty"`
	// DialogflowSegmentMetadata: CCAI metadata relating to the current transcript
	// segment.
	DialogflowSegmentMetadata *GoogleCloudContactcenterinsightsV1mainConversationTranscriptTranscriptSegmentDialogflowSegmentMetadata `json:"dialogflowSegmentMetadata,omitempty"`
	// LanguageCode: The language code of this segment as a BCP-47
	// (https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag. Example:
	// "en-US".
	LanguageCode string `json:"languageCode,omitempty"`
	// MessageTime: The time that the message occurred, if provided.
	MessageTime string `json:"messageTime,omitempty"`
	// SegmentParticipant: The participant of this segment.
	SegmentParticipant *GoogleCloudContactcenterinsightsV1mainConversationParticipant `json:"segmentParticipant,omitempty"`
	// Sentiment: The sentiment for this transcript segment.
	Sentiment *GoogleCloudContactcenterinsightsV1mainSentimentData `json:"sentiment,omitempty"`
	// Text: The text of this segment.
	Text string `json:"text,omitempty"`
	// Words: A list of the word-specific information for each word in the segment.
	Words []*GoogleCloudContactcenterinsightsV1mainConversationTranscriptTranscriptSegmentWordInfo `json:"words,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChannelTag") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChannelTag") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainConversationTranscriptTranscriptSegment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainConversationTranscriptTranscriptSegment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1mainConversationTranscriptTranscriptSegment) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1mainConversationTranscriptTranscriptSegment
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudContactcenterinsightsV1mainConversationTranscriptTranscriptSegment
// DialogflowSegmentMetadata: Metadata from Dialogflow relating to the current
// transcript segment.
type GoogleCloudContactcenterinsightsV1mainConversationTranscriptTranscriptSegmentDialogflowSegmentMetadata struct {
	// SmartReplyAllowlistCovered: Whether the transcript segment was covered under
	// the configured smart reply allowlist in Agent Assist.
	SmartReplyAllowlistCovered bool `json:"smartReplyAllowlistCovered,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SmartReplyAllowlistCovered")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SmartReplyAllowlistCovered") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainConversationTranscriptTranscriptSegmentDialogflowSegmentMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainConversationTranscriptTranscriptSegmentDialogflowSegmentMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainConversationTranscriptTranscriptSegment
// WordInfo: Word-level info for words in a transcript.
type GoogleCloudContactcenterinsightsV1mainConversationTranscriptTranscriptSegmentWordInfo struct {
	// Confidence: A confidence estimate between 0.0 and 1.0 of the fidelity of
	// this word. A default value of 0.0 indicates that the value is unset.
	Confidence float64 `json:"confidence,omitempty"`
	// EndOffset: Time offset of the end of this word relative to the beginning of
	// the total conversation.
	EndOffset string `json:"endOffset,omitempty"`
	// StartOffset: Time offset of the start of this word relative to the beginning
	// of the total conversation.
	StartOffset string `json:"startOffset,omitempty"`
	// Word: The word itself. Includes punctuation marks that surround the word.
	Word string `json:"word,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainConversationTranscriptTranscriptSegmentWordInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainConversationTranscriptTranscriptSegmentWordInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1mainConversationTranscriptTranscriptSegmentWordInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1mainConversationTranscriptTranscriptSegmentWordInfo
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudContactcenterinsightsV1mainCreateAnalysisOperationMetadata:
// Metadata for a create analysis operation.
type GoogleCloudContactcenterinsightsV1mainCreateAnalysisOperationMetadata struct {
	// AnnotatorSelector: Output only. The annotator selector used for the analysis
	// (if any).
	AnnotatorSelector *GoogleCloudContactcenterinsightsV1mainAnnotatorSelector `json:"annotatorSelector,omitempty"`
	// Conversation: Output only. The Conversation that this Analysis Operation
	// belongs to.
	Conversation string `json:"conversation,omitempty"`
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotatorSelector") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotatorSelector") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainCreateAnalysisOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainCreateAnalysisOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainCreateIssueMetadata: Metadata for
// creating an issue.
type GoogleCloudContactcenterinsightsV1mainCreateIssueMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original request for creation.
	Request *GoogleCloudContactcenterinsightsV1mainCreateIssueRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainCreateIssueMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainCreateIssueMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainCreateIssueModelMetadata: Metadata for
// creating an issue model.
type GoogleCloudContactcenterinsightsV1mainCreateIssueModelMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original request for creation.
	Request *GoogleCloudContactcenterinsightsV1mainCreateIssueModelRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainCreateIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainCreateIssueModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainCreateIssueModelRequest: The request
// to create an issue model.
type GoogleCloudContactcenterinsightsV1mainCreateIssueModelRequest struct {
	// IssueModel: Required. The issue model to create.
	IssueModel *GoogleCloudContactcenterinsightsV1mainIssueModel `json:"issueModel,omitempty"`
	// Parent: Required. The parent resource of the issue model.
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IssueModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IssueModel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainCreateIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainCreateIssueModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainCreateIssueRequest: The request to
// create an issue.
type GoogleCloudContactcenterinsightsV1mainCreateIssueRequest struct {
	// Issue: Required. The values for the new issue.
	Issue *GoogleCloudContactcenterinsightsV1mainIssue `json:"issue,omitempty"`
	// Parent: Required. The parent resource of the issue.
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Issue") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Issue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainCreateIssueRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainCreateIssueRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainDataset: Dataset resource represents a
// collection of conversations that may be bounded (Static Dataset, e.g. golden
// dataset for training), or unbounded (Dynamic Dataset, e.g. live traffic, or
// agent training traffic)
type GoogleCloudContactcenterinsightsV1mainDataset struct {
	// CreateTime: Output only. Dataset create time.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Dataset description.
	Description string `json:"description,omitempty"`
	// DisplayName: Display name for the dataaset
	DisplayName string `json:"displayName,omitempty"`
	// Name: Immutable. Identifier. Resource name of the dataset. Format:
	// projects/{project}/locations/{location}/datasets/{dataset}
	Name string `json:"name,omitempty"`
	// Ttl: Optional. Option TTL for the dataset.
	Ttl string `json:"ttl,omitempty"`
	// Type: Dataset usage type.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Default value for unspecified.
	//   "EVAL" - For evals only.
	//   "LIVE" - Dataset with new conversations coming in regularly (Insights
	// legacy conversations and AI trainer)
	Type string `json:"type,omitempty"`
	// UpdateTime: Output only. Dataset update time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainDataset) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainDataset
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainDeleteIssueModelMetadata: Metadata for
// deleting an issue model.
type GoogleCloudContactcenterinsightsV1mainDeleteIssueModelMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original request for deletion.
	Request *GoogleCloudContactcenterinsightsV1mainDeleteIssueModelRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainDeleteIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainDeleteIssueModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainDeleteIssueModelRequest: The request
// to delete an issue model.
type GoogleCloudContactcenterinsightsV1mainDeleteIssueModelRequest struct {
	// Name: Required. The name of the issue model to delete.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainDeleteIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainDeleteIssueModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainDeleteQaQuestionTagMetadata: The
// metadata for deleting a QaQuestionTag Resource.
type GoogleCloudContactcenterinsightsV1mainDeleteQaQuestionTagMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: Output only. The original request.
	Request *GoogleCloudContactcenterinsightsV1mainDeleteQaQuestionTagRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainDeleteQaQuestionTagMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainDeleteQaQuestionTagMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainDeleteQaQuestionTagRequest: The
// request for deleting a QaQuestionTag.
type GoogleCloudContactcenterinsightsV1mainDeleteQaQuestionTagRequest struct {
	// Name: Required. The name of the QaQuestionTag to delete.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainDeleteQaQuestionTagRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainDeleteQaQuestionTagRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainDeployIssueModelMetadata: Metadata for
// deploying an issue model.
type GoogleCloudContactcenterinsightsV1mainDeployIssueModelMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original request for deployment.
	Request *GoogleCloudContactcenterinsightsV1mainDeployIssueModelRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainDeployIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainDeployIssueModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainDeployIssueModelRequest: The request
// to deploy an issue model.
type GoogleCloudContactcenterinsightsV1mainDeployIssueModelRequest struct {
	// Name: Required. The issue model to deploy.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainDeployIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainDeployIssueModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainDeployIssueModelResponse: The response
// to deploy an issue model.
type GoogleCloudContactcenterinsightsV1mainDeployIssueModelResponse struct {
}

// GoogleCloudContactcenterinsightsV1mainDialogflowIntent: The data for a
// Dialogflow intent. Represents a detected intent in the conversation, e.g.
// MAKES_PROMISE.
type GoogleCloudContactcenterinsightsV1mainDialogflowIntent struct {
	// DisplayName: The human-readable name of the intent.
	DisplayName string `json:"displayName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainDialogflowIntent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainDialogflowIntent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainDialogflowInteractionData: Dialogflow
// interaction data.
type GoogleCloudContactcenterinsightsV1mainDialogflowInteractionData struct {
	// Confidence: The confidence of the match ranging from 0.0 (completely
	// uncertain) to 1.0 (completely certain).
	Confidence float64 `json:"confidence,omitempty"`
	// DialogflowIntentId: The Dialogflow intent resource path. Format:
	// projects/{project}/agent/{agent}/intents/{intent}
	DialogflowIntentId string `json:"dialogflowIntentId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainDialogflowInteractionData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainDialogflowInteractionData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1mainDialogflowInteractionData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1mainDialogflowInteractionData
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudContactcenterinsightsV1mainDialogflowSource: A Dialogflow source
// of conversation data.
type GoogleCloudContactcenterinsightsV1mainDialogflowSource struct {
	// AudioUri: Cloud Storage URI that points to a file that contains the
	// conversation audio.
	AudioUri string `json:"audioUri,omitempty"`
	// DialogflowConversation: Output only. The name of the Dialogflow conversation
	// that this conversation resource is derived from. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}
	DialogflowConversation string `json:"dialogflowConversation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainDialogflowSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainDialogflowSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainDimension: A dimension determines the
// grouping key for the query. In SQL terms, these would be part of both the
// "SELECT" and "GROUP BY" clauses.
type GoogleCloudContactcenterinsightsV1mainDimension struct {
	// AgentDimensionMetadata: Output only. Metadata about the agent dimension.
	AgentDimensionMetadata *GoogleCloudContactcenterinsightsV1mainDimensionAgentDimensionMetadata `json:"agentDimensionMetadata,omitempty"`
	// ClientSentimentCategoryDimensionMetadata: Output only. Metadata about the
	// client sentiment category dimension.
	ClientSentimentCategoryDimensionMetadata *GoogleCloudContactcenterinsightsV1mainDimensionClientSentimentCategoryDimensionMetadata `json:"clientSentimentCategoryDimensionMetadata,omitempty"`
	// ConversationProfileDimensionMetadata: Output only. Metadata about the
	// conversation profile dimension.
	ConversationProfileDimensionMetadata *GoogleCloudContactcenterinsightsV1mainDimensionConversationProfileDimensionMetadata `json:"conversationProfileDimensionMetadata,omitempty"`
	// ConversationalAgentsPlaybookDimensionMetadata: Output only. Metadata about
	// the Conversational Agents playbook dimension.
	ConversationalAgentsPlaybookDimensionMetadata *GoogleCloudContactcenterinsightsV1mainDimensionConversationalAgentsPlaybookDimensionMetadata `json:"conversationalAgentsPlaybookDimensionMetadata,omitempty"`
	// ConversationalAgentsToolDimensionMetadata: Output only. Metadata about the
	// Conversational Agents tool dimension.
	ConversationalAgentsToolDimensionMetadata *GoogleCloudContactcenterinsightsV1mainDimensionConversationalAgentsToolDimensionMetadata `json:"conversationalAgentsToolDimensionMetadata,omitempty"`
	// DimensionKey: The key of the dimension.
	//
	// Possible values:
	//   "DIMENSION_KEY_UNSPECIFIED" - The key of the dimension is unspecified.
	//   "ISSUE" - The dimension is keyed by issues.
	//   "ISSUE_NAME" - The dimension is keyed by issue names.
	//   "AGENT" - The dimension is keyed by agents.
	//   "AGENT_TEAM" - The dimension is keyed by agent teams.
	//   "QA_QUESTION_ID" - The dimension is keyed by QaQuestionIds. Note that: We
	// only group by the QuestionId and not the revision-id of the scorecard this
	// question is a part of. This allows for showing stats for the same question
	// across different scorecard revisions.
	//   "QA_QUESTION_ANSWER_VALUE" - The dimension is keyed by
	// QaQuestionIds-Answer value pairs. Note that: We only group by the QuestionId
	// and not the revision-id of the scorecard this question is a part of. This
	// allows for showing distribution of answers per question across different
	// scorecard revisions.
	//   "QA_SCORECARD_ID" - The dimension is keyed by QaScorecardIds. Note that:
	// We only group by the ScorecardId and not the revision-id of the scorecard.
	// This allows for showing stats for the same scorecard across different
	// revisions. This metric is mostly only useful if querying the average
	// normalized score per scorecard.
	//   "CONVERSATION_PROFILE_ID" - The dimension is keyed by the conversation
	// profile ID.
	//   "MEDIUM" - The dimension is keyed by the conversation medium.
	//   "CONVERSATIONAL_AGENTS_PLAYBOOK_ID" - The dimension is keyed by the
	// Conversational Agents playbook ID.
	//   "CONVERSATIONAL_AGENTS_PLAYBOOK_NAME" - The dimension is keyed by the
	// Conversational Agents playbook display name.
	//   "CONVERSATIONAL_AGENTS_TOOL_ID" - The dimension is keyed by the
	// Conversational Agents tool ID.
	//   "CONVERSATIONAL_AGENTS_TOOL_NAME" - The dimension is keyed by the
	// Conversational Agents tool display name.
	//   "CLIENT_SENTIMENT_CATEGORY" - The dimension is keyed by the client
	// sentiment category.
	//   "AGENT_VERSION_ID" - The dimension is keyed by the agent version ID.
	//   "AGENT_DEPLOYMENT_ID" - The dimension is keyed by the agent deployment ID.
	//   "AGENT_ASSIST_SUPERVISOR_ID" - The dimension is keyed by the supervisor ID
	// of the assigned human supervisor for virtual agents.
	//   "LABEL_KEY" - The dimension is keyed by label keys.
	//   "LABEL_VALUE" - The dimension is keyed by label values.
	//   "LABEL_KEY_AND_VALUE" - The dimension is keyed by label key-value pairs.
	DimensionKey string `json:"dimensionKey,omitempty"`
	// IssueDimensionMetadata: Output only. Metadata about the issue dimension.
	IssueDimensionMetadata *GoogleCloudContactcenterinsightsV1mainDimensionIssueDimensionMetadata `json:"issueDimensionMetadata,omitempty"`
	// LabelDimensionMetadata: Output only. Metadata about conversation labels.
	LabelDimensionMetadata *GoogleCloudContactcenterinsightsV1mainDimensionLabelDimensionMetadata `json:"labelDimensionMetadata,omitempty"`
	// MediumDimensionMetadata: Output only. Metadata about the conversation medium
	// dimension.
	MediumDimensionMetadata *GoogleCloudContactcenterinsightsV1mainDimensionMediumDimensionMetadata `json:"mediumDimensionMetadata,omitempty"`
	// QaQuestionAnswerDimensionMetadata: Output only. Metadata about the QA
	// question-answer dimension.
	QaQuestionAnswerDimensionMetadata *GoogleCloudContactcenterinsightsV1mainDimensionQaQuestionAnswerDimensionMetadata `json:"qaQuestionAnswerDimensionMetadata,omitempty"`
	// QaQuestionDimensionMetadata: Output only. Metadata about the QA question
	// dimension.
	QaQuestionDimensionMetadata *GoogleCloudContactcenterinsightsV1mainDimensionQaQuestionDimensionMetadata `json:"qaQuestionDimensionMetadata,omitempty"`
	// QaScorecardDimensionMetadata: Output only. Metadata about the QA scorecard
	// dimension.
	QaScorecardDimensionMetadata *GoogleCloudContactcenterinsightsV1mainDimensionQaScorecardDimensionMetadata `json:"qaScorecardDimensionMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentDimensionMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentDimensionMetadata") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainDimension) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainDimension
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainDimensionAgentDimensionMetadata:
// Metadata about the agent dimension.
type GoogleCloudContactcenterinsightsV1mainDimensionAgentDimensionMetadata struct {
	// AgentDeploymentDisplayName: Optional. The agent's deployment display name.
	// Only applicable to automated agents. This will be populated for
	// AGENT_DEPLOYMENT_ID dimensions.
	AgentDeploymentDisplayName string `json:"agentDeploymentDisplayName,omitempty"`
	// AgentDeploymentId: Optional. The agent's deployment ID. Only applicable to
	// automated agents. This will be populated for AGENT and AGENT_DEPLOYMENT_ID
	// dimensions.
	AgentDeploymentId string `json:"agentDeploymentId,omitempty"`
	// AgentDisplayName: Optional. The agent's name This will be populated for
	// AGENT, AGENT_TEAM, AGENT_VERSION_ID, and AGENT_DEPLOYMENT_ID dimensions.
	AgentDisplayName string `json:"agentDisplayName,omitempty"`
	// AgentId: Optional. A user-specified string representing the agent. This will
	// be populated for AGENT, AGENT_TEAM, AGENT_VERSION_ID, and
	// AGENT_DEPLOYMENT_ID dimensions.
	AgentId string `json:"agentId,omitempty"`
	// AgentTeam: Optional. A user-specified string representing the agent's team.
	AgentTeam string `json:"agentTeam,omitempty"`
	// AgentVersionDisplayName: Optional. The agent's version display name. Only
	// applicable to automated agents. This will be populated for AGENT_VERSION_ID,
	// and AGENT_DEPLOYMENT_ID dimensions.
	AgentVersionDisplayName string `json:"agentVersionDisplayName,omitempty"`
	// AgentVersionId: Optional. The agent's version ID. Only applicable to
	// automated agents. This will be populated for AGENT_VERSION_ID, and
	// AGENT_DEPLOYMENT_ID dimensions.
	AgentVersionId string `json:"agentVersionId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentDeploymentDisplayName")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentDeploymentDisplayName") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainDimensionAgentDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainDimensionAgentDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainDimensionClientSentimentCategoryDimensi
// onMetadata: Metadata about the client sentiment category dimension.
type GoogleCloudContactcenterinsightsV1mainDimensionClientSentimentCategoryDimensionMetadata struct {
	// SentimentCategory: Optional. The client sentiment category.
	SentimentCategory string `json:"sentimentCategory,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SentimentCategory") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SentimentCategory") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainDimensionClientSentimentCategoryDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainDimensionClientSentimentCategoryDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainDimensionConversationProfileDimensionMe
// tadata: Metadata about the conversation profile dimension.
type GoogleCloudContactcenterinsightsV1mainDimensionConversationProfileDimensionMetadata struct {
	// ConversationProfileId: Optional. The conversation profile ID.
	ConversationProfileId string `json:"conversationProfileId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationProfileId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationProfileId") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainDimensionConversationProfileDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainDimensionConversationProfileDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainDimensionConversationalAgentsPlaybookDi
// mensionMetadata: Metadata about the Conversational Agents playbook
// dimension.
type GoogleCloudContactcenterinsightsV1mainDimensionConversationalAgentsPlaybookDimensionMetadata struct {
	// PlaybookDisplayName: Optional. The dialogflow playbook display name.
	PlaybookDisplayName string `json:"playbookDisplayName,omitempty"`
	// PlaybookId: Optional. The dialogflow playbook ID.
	PlaybookId string `json:"playbookId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PlaybookDisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PlaybookDisplayName") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainDimensionConversationalAgentsPlaybookDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainDimensionConversationalAgentsPlaybookDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainDimensionConversationalAgentsToolDimens
// ionMetadata: Metadata about the Conversational Agents tool dimension.
type GoogleCloudContactcenterinsightsV1mainDimensionConversationalAgentsToolDimensionMetadata struct {
	// ToolDisplayName: Optional. The dialogflow tool display name.
	ToolDisplayName string `json:"toolDisplayName,omitempty"`
	// ToolId: Optional. The dialogflow tool ID.
	ToolId string `json:"toolId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ToolDisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ToolDisplayName") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainDimensionConversationalAgentsToolDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainDimensionConversationalAgentsToolDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainDimensionIssueDimensionMetadata:
// Metadata about the issue dimension.
type GoogleCloudContactcenterinsightsV1mainDimensionIssueDimensionMetadata struct {
	// IssueDisplayName: The issue display name.
	IssueDisplayName string `json:"issueDisplayName,omitempty"`
	// IssueId: The issue ID.
	IssueId string `json:"issueId,omitempty"`
	// IssueModelId: The parent issue model ID.
	IssueModelId string `json:"issueModelId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IssueDisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IssueDisplayName") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainDimensionIssueDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainDimensionIssueDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainDimensionLabelDimensionMetadata:
// Metadata about conversation labels.
type GoogleCloudContactcenterinsightsV1mainDimensionLabelDimensionMetadata struct {
	// LabelKey: Optional. The label key.
	LabelKey string `json:"labelKey,omitempty"`
	// LabelValue: Optional. The label value.
	LabelValue string `json:"labelValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LabelKey") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LabelKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainDimensionLabelDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainDimensionLabelDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainDimensionMediumDimensionMetadata:
// Metadata about the conversation medium dimension.
type GoogleCloudContactcenterinsightsV1mainDimensionMediumDimensionMetadata struct {
	// Medium: Optional. The conversation medium. Currently supports : PHONE_CALL,
	// CHAT.
	Medium string `json:"medium,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Medium") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Medium") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainDimensionMediumDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainDimensionMediumDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainDimensionQaQuestionAnswerDimensionMetad
// ata: Metadata about the QA question-answer dimension. This is useful for
// showing the answer distribution for questions for a given scorecard.
type GoogleCloudContactcenterinsightsV1mainDimensionQaQuestionAnswerDimensionMetadata struct {
	// AnswerValue: Optional. The full body of the question.
	AnswerValue string `json:"answerValue,omitempty"`
	// QaQuestionId: Optional. The QA question ID.
	QaQuestionId string `json:"qaQuestionId,omitempty"`
	// QaScorecardId: Optional. The QA scorecard ID.
	QaScorecardId string `json:"qaScorecardId,omitempty"`
	// QuestionBody: Optional. The full body of the question.
	QuestionBody string `json:"questionBody,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainDimensionQaQuestionAnswerDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainDimensionQaQuestionAnswerDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainDimensionQaQuestionDimensionMetadata:
// Metadata about the QA question dimension.
type GoogleCloudContactcenterinsightsV1mainDimensionQaQuestionDimensionMetadata struct {
	// QaQuestionId: Optional. The QA question ID.
	QaQuestionId string `json:"qaQuestionId,omitempty"`
	// QaScorecardId: Optional. The QA scorecard ID.
	QaScorecardId string `json:"qaScorecardId,omitempty"`
	// QuestionBody: Optional. The full body of the question.
	QuestionBody string `json:"questionBody,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QaQuestionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QaQuestionId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainDimensionQaQuestionDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainDimensionQaQuestionDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainDimensionQaScorecardDimensionMetadata:
// Metadata about the QA scorecard dimension.
type GoogleCloudContactcenterinsightsV1mainDimensionQaScorecardDimensionMetadata struct {
	// QaScorecardId: Optional. The QA scorecard ID.
	QaScorecardId string `json:"qaScorecardId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QaScorecardId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QaScorecardId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainDimensionQaScorecardDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainDimensionQaScorecardDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainEncryptionSpec: A customer-managed
// encryption key specification that can be applied to all created resources
// (e.g. `Conversation`).
type GoogleCloudContactcenterinsightsV1mainEncryptionSpec struct {
	// KmsKey: Required. The name of customer-managed encryption key that is used
	// to secure a resource and its sub-resources. If empty, the resource is
	// secured by our default encryption key. Only the key in the same location as
	// this resource is allowed to be used for encryption. Format:
	// `projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{key}`
	KmsKey string `json:"kmsKey,omitempty"`
	// Name: Immutable. The resource name of the encryption key specification
	// resource. Format: projects/{project}/locations/{location}/encryptionSpec
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "KmsKey") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "KmsKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainEncryptionSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainEncryptionSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainEntity: The data for an entity
// annotation. Represents a phrase in the conversation that is a known entity,
// such as a person, an organization, or location.
type GoogleCloudContactcenterinsightsV1mainEntity struct {
	// DisplayName: The representative name for the entity.
	DisplayName string `json:"displayName,omitempty"`
	// Metadata: Metadata associated with the entity. For most entity types, the
	// metadata is a Wikipedia URL (`wikipedia_url`) and Knowledge Graph MID
	// (`mid`), if they are available. For the metadata associated with other
	// entity types, see the Type table below.
	Metadata map[string]string `json:"metadata,omitempty"`
	// Salience: The salience score associated with the entity in the [0, 1.0]
	// range. The salience score for an entity provides information about the
	// importance or centrality of that entity to the entire document text. Scores
	// closer to 0 are less salient, while scores closer to 1.0 are highly salient.
	Salience float64 `json:"salience,omitempty"`
	// Sentiment: The aggregate sentiment expressed for this entity in the
	// conversation.
	Sentiment *GoogleCloudContactcenterinsightsV1mainSentimentData `json:"sentiment,omitempty"`
	// Type: The entity type.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unspecified.
	//   "PERSON" - Person.
	//   "LOCATION" - Location.
	//   "ORGANIZATION" - Organization.
	//   "EVENT" - Event.
	//   "WORK_OF_ART" - Artwork.
	//   "CONSUMER_GOOD" - Consumer product.
	//   "OTHER" - Other types of entities.
	//   "PHONE_NUMBER" - Phone number. The metadata lists the phone number
	// (formatted according to local convention), plus whichever additional
	// elements appear in the text: * `number` - The actual number, broken down
	// into sections according to local convention. * `national_prefix` - Country
	// code, if detected. * `area_code` - Region or area code, if detected. *
	// `extension` - Phone extension (to be dialed after connection), if detected.
	//   "ADDRESS" - Address. The metadata identifies the street number and
	// locality plus whichever additional elements appear in the text: *
	// `street_number` - Street number. * `locality` - City or town. *
	// `street_name` - Street/route name, if detected. * `postal_code` - Postal
	// code, if detected. * `country` - Country, if detected. * `broad_region` -
	// Administrative area, such as the state, if detected. * `narrow_region` -
	// Smaller administrative area, such as county, if detected. * `sublocality` -
	// Used in Asian addresses to demark a district within a city, if detected.
	//   "DATE" - Date. The metadata identifies the components of the date: *
	// `year` - Four digit year, if detected. * `month` - Two digit month number,
	// if detected. * `day` - Two digit day number, if detected.
	//   "NUMBER" - Number. The metadata is the number itself.
	//   "PRICE" - Price. The metadata identifies the `value` and `currency`.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainEntity) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainEntity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1mainEntity) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1mainEntity
	var s1 struct {
		Salience gensupport.JSONFloat64 `json:"salience"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Salience = float64(s1.Salience)
	return nil
}

// GoogleCloudContactcenterinsightsV1mainEntityMentionData: The data for an
// entity mention annotation. This represents a mention of an `Entity` in the
// conversation.
type GoogleCloudContactcenterinsightsV1mainEntityMentionData struct {
	// EntityUniqueId: The key of this entity in conversation entities. Can be used
	// to retrieve the exact `Entity` this mention is attached to.
	EntityUniqueId string `json:"entityUniqueId,omitempty"`
	// Sentiment: Sentiment expressed for this mention of the entity.
	Sentiment *GoogleCloudContactcenterinsightsV1mainSentimentData `json:"sentiment,omitempty"`
	// Type: The type of the entity mention.
	//
	// Possible values:
	//   "MENTION_TYPE_UNSPECIFIED" - Unspecified.
	//   "PROPER" - Proper noun.
	//   "COMMON" - Common noun (or noun compound).
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityUniqueId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityUniqueId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainEntityMentionData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainEntityMentionData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainExportInsightsDataMetadata: Metadata
// for an export insights operation.
type GoogleCloudContactcenterinsightsV1mainExportInsightsDataMetadata struct {
	// CompletedExportCount: The number of conversations that were exported
	// successfully.
	CompletedExportCount int64 `json:"completedExportCount,omitempty"`
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// FailedExportCount: The number of conversations that failed to be exported.
	FailedExportCount int64 `json:"failedExportCount,omitempty"`
	// PartialErrors: Partial errors during export operation that might cause the
	// operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: The original request for export.
	Request *GoogleCloudContactcenterinsightsV1mainExportInsightsDataRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompletedExportCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompletedExportCount") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainExportInsightsDataMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainExportInsightsDataMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainExportInsightsDataRequest: The request
// to export insights.
type GoogleCloudContactcenterinsightsV1mainExportInsightsDataRequest struct {
	// BigQueryDestination: Specified if sink is a BigQuery table.
	BigQueryDestination *GoogleCloudContactcenterinsightsV1mainExportInsightsDataRequestBigQueryDestination `json:"bigQueryDestination,omitempty"`
	// ExportSchemaVersion: Optional. Version of the export schema.
	//
	// Possible values:
	//   "EXPORT_SCHEMA_VERSION_UNSPECIFIED" - Unspecified. Defaults to EXPORT_V3.
	//   "EXPORT_V1" - Export schema version 1.
	//   "EXPORT_V2" - Export schema version 2.
	//   "EXPORT_V3" - Export schema version 3.
	//   "EXPORT_V4" - Export schema version 4.
	//   "EXPORT_V5" - Export schema version 5.
	//   "EXPORT_V6" - Export schema version 6.
	//   "EXPORT_V7" - Export schema version 7.
	//   "EXPORT_V8" - Export schema version 8.
	//   "EXPORT_V9" - Export schema version 9.
	//   "EXPORT_V10" - Export schema version 10.
	//   "EXPORT_V11" - Export schema version 11.
	//   "EXPORT_V12" - Export schema version 12.
	//   "EXPORT_V13" - Export schema version 13.
	//   "EXPORT_V14" - Export schema version 14.
	//   "EXPORT_V15" - Export schema version 15.
	//   "EXPORT_V16" - Export schema version 16.
	//   "EXPORT_V17" - Export schema version 17.
	//   "EXPORT_VERSION_LATEST_AVAILABLE" - Export schema version latest
	// available.
	ExportSchemaVersion string `json:"exportSchemaVersion,omitempty"`
	// Filter: A filter to reduce results to a specific subset. Useful for
	// exporting conversations with specific properties.
	Filter string `json:"filter,omitempty"`
	// KmsKey: A fully qualified KMS key name for BigQuery tables protected by
	// CMEK. Format:
	// projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}/c
	// ryptoKeyVersions/{version}
	KmsKey string `json:"kmsKey,omitempty"`
	// Parent: Required. The parent resource to export data from.
	Parent string `json:"parent,omitempty"`
	// WriteDisposition: Options for what to do if the destination table already
	// exists.
	//
	// Possible values:
	//   "WRITE_DISPOSITION_UNSPECIFIED" - Write disposition is not specified.
	// Defaults to WRITE_TRUNCATE.
	//   "WRITE_TRUNCATE" - If the table already exists, BigQuery will overwrite
	// the table data and use the schema from the load.
	//   "WRITE_APPEND" - If the table already exists, BigQuery will append data to
	// the table.
	WriteDisposition string `json:"writeDisposition,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigQueryDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigQueryDestination") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainExportInsightsDataRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainExportInsightsDataRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainExportInsightsDataRequestBigQueryDestin
// ation: A BigQuery Table Reference.
type GoogleCloudContactcenterinsightsV1mainExportInsightsDataRequestBigQueryDestination struct {
	// Dataset: Required. The name of the BigQuery dataset that the snapshot result
	// should be exported to. If this dataset does not exist, the export call
	// returns an INVALID_ARGUMENT error.
	Dataset string `json:"dataset,omitempty"`
	// ProjectId: A project ID or number. If specified, then export will attempt to
	// write data to this project instead of the resource project. Otherwise, the
	// resource project will be used.
	ProjectId string `json:"projectId,omitempty"`
	// Table: The BigQuery table name to which the insights data should be written.
	// If this table does not exist, the export call returns an INVALID_ARGUMENT
	// error.
	Table string `json:"table,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dataset") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dataset") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainExportInsightsDataRequestBigQueryDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainExportInsightsDataRequestBigQueryDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainExportInsightsDataResponse: Response
// for an export insights operation.
type GoogleCloudContactcenterinsightsV1mainExportInsightsDataResponse struct {
}

// GoogleCloudContactcenterinsightsV1mainExportIssueModelMetadata: Metadata
// used for export issue model.
type GoogleCloudContactcenterinsightsV1mainExportIssueModelMetadata struct {
	// CreateTime: The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original export request.
	Request *GoogleCloudContactcenterinsightsV1mainExportIssueModelRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainExportIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainExportIssueModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainExportIssueModelRequest: Request to
// export an issue model.
type GoogleCloudContactcenterinsightsV1mainExportIssueModelRequest struct {
	// GcsDestination: Google Cloud Storage URI to export the issue model to.
	GcsDestination *GoogleCloudContactcenterinsightsV1mainExportIssueModelRequestGcsDestination `json:"gcsDestination,omitempty"`
	// Name: Required. The issue model to export.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsDestination") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainExportIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainExportIssueModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainExportIssueModelRequestGcsDestination:
// Google Cloud Storage Object URI to save the issue model to.
type GoogleCloudContactcenterinsightsV1mainExportIssueModelRequestGcsDestination struct {
	// ObjectUri: Required. Format: `gs:///`
	ObjectUri string `json:"objectUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ObjectUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ObjectUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainExportIssueModelRequestGcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainExportIssueModelRequestGcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainExportIssueModelResponse: Response
// from export issue model
type GoogleCloudContactcenterinsightsV1mainExportIssueModelResponse struct {
}

// GoogleCloudContactcenterinsightsV1mainFaqAnswerData: Agent Assist
// frequently-asked-question answer data.
type GoogleCloudContactcenterinsightsV1mainFaqAnswerData struct {
	// Answer: The piece of text from the `source` knowledge base document.
	Answer string `json:"answer,omitempty"`
	// ConfidenceScore: The system's confidence score that this answer is a good
	// match for this conversation, ranging from 0.0 (completely uncertain) to 1.0
	// (completely certain).
	ConfidenceScore float64 `json:"confidenceScore,omitempty"`
	// Metadata: Map that contains metadata about the FAQ answer and the document
	// that it originates from.
	Metadata map[string]string `json:"metadata,omitempty"`
	// QueryRecord: The name of the answer record. Format:
	// projects/{project}/locations/{location}/answerRecords/{answer_record}
	QueryRecord string `json:"queryRecord,omitempty"`
	// Question: The corresponding FAQ question.
	Question string `json:"question,omitempty"`
	// Source: The knowledge document that this answer was extracted from. Format:
	// projects/{project}/knowledgeBases/{knowledge_base}/documents/{document}.
	Source string `json:"source,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Answer") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Answer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainFaqAnswerData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainFaqAnswerData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1mainFaqAnswerData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1mainFaqAnswerData
	var s1 struct {
		ConfidenceScore gensupport.JSONFloat64 `json:"confidenceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceScore = float64(s1.ConfidenceScore)
	return nil
}

// GoogleCloudContactcenterinsightsV1mainFeedbackLabel: Represents a
// conversation, resource, and label provided by the user. Can take the form of
// a string label or a QaAnswer label. QaAnswer labels are used for Quality AI
// example conversations. String labels are used for Topic Modeling.
// AgentAssistSummary labels are used for Agent Assist Summarization.
type GoogleCloudContactcenterinsightsV1mainFeedbackLabel struct {
	// CreateTime: Output only. Create time of the label.
	CreateTime string `json:"createTime,omitempty"`
	// Label: String label used for Topic Modeling.
	Label string `json:"label,omitempty"`
	// LabeledResource: Name of the resource to be labeled. Supported resources
	// are: *
	// `projects/{project}/locations/{location}/qaScorecards/{scorecard}/revisions/{
	// revision}/qaQuestions/{question}` *
	// `projects/{project}/locations/{location}/issueModels/{issue_model}` *
	// `projects/{project}/locations/{location}/generators/{generator_id}`
	LabeledResource string `json:"labeledResource,omitempty"`
	// Name: Immutable. Resource name of the FeedbackLabel. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}/feedback
	// Labels/{feedback_label}
	Name string `json:"name,omitempty"`
	// QaAnswerLabel: QaAnswer label used for Quality AI example conversations.
	QaAnswerLabel *GoogleCloudContactcenterinsightsV1mainQaAnswerAnswerValue `json:"qaAnswerLabel,omitempty"`
	// UpdateTime: Output only. Update time of the label.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainFeedbackLabel) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainFeedbackLabel
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainGcsSource: A Cloud Storage source of
// conversation data.
type GoogleCloudContactcenterinsightsV1mainGcsSource struct {
	// AudioUri: Cloud Storage URI that points to a file that contains the
	// conversation audio.
	AudioUri string `json:"audioUri,omitempty"`
	// TranscriptUri: Immutable. Cloud Storage URI that points to a file that
	// contains the conversation transcript.
	TranscriptUri string `json:"transcriptUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainGcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainGcsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainGenerativeInsightConversationTranscript
// : The conversation transcript for the chart.
type GoogleCloudContactcenterinsightsV1mainGenerativeInsightConversationTranscript struct {
	// ConversationId: The conversation id of the chart.
	ConversationId string `json:"conversationId,omitempty"`
	// CreateTime: Output only. The create time of the conversation.
	CreateTime string `json:"createTime,omitempty"`
	// Messages: Ordered list of messages, including user inputs and system
	// responses.
	Messages []*GoogleCloudContactcenterinsightsV1mainGenerativeInsightConversationTranscriptMessage `json:"messages,omitempty"`
	// UpdateTime: Output only. The update time of the conversation.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainGenerativeInsightConversationTranscript) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainGenerativeInsightConversationTranscript
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainGenerativeInsightConversationTranscript
// Message: The message in the conversation.
type GoogleCloudContactcenterinsightsV1mainGenerativeInsightConversationTranscriptMessage struct {
	// CreateTime: Output only. For user messages, this is the time at which the
	// system received the message. For system messages, this is the time at which
	// the system generated the message.
	CreateTime string `json:"createTime,omitempty"`
	// MessageId: The message id of the message.
	MessageId string `json:"messageId,omitempty"`
	// SystemMessageWrapper: A wrapper for system messages per turn.
	SystemMessageWrapper *GoogleCloudContactcenterinsightsV1mainGenerativeInsightConversationTranscriptMessageSystemMessages `json:"systemMessageWrapper,omitempty"`
	// UserMessage: A message from the user that is interacting with the system.
	UserMessage *GoogleCloudContactcenterinsightsV1mainGenerativeInsightConversationTranscriptMessageUserMessage `json:"userMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainGenerativeInsightConversationTranscriptMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainGenerativeInsightConversationTranscriptMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainGenerativeInsightConversationTranscript
// MessageSystemMessage: A message from the system in response to the user.
// This message can also be a message from the user as historical context for
// multiturn conversations with the system.
type GoogleCloudContactcenterinsightsV1mainGenerativeInsightConversationTranscriptMessageSystemMessage struct {
	// ChartSpec: Chart spec from LLM
	ChartSpec googleapi.RawMessage `json:"chartSpec,omitempty"`
	// GeneratedSqlQuery: Raw SQL from LLM, before templatization
	GeneratedSqlQuery string `json:"generatedSqlQuery,omitempty"`
	// TextMessage: A direct natural language response to the user message.
	TextMessage *GoogleCloudContactcenterinsightsV1mainGenerativeInsightConversationTranscriptMessageSystemMessageTextOutput `json:"textMessage,omitempty"`
	// UserProvidedChartSpec: Optional. User provided chart spec
	UserProvidedChartSpec googleapi.RawMessage `json:"userProvidedChartSpec,omitempty"`
	// UserProvidedSqlQuery: Optional. User provided SQL query
	UserProvidedSqlQuery string `json:"userProvidedSqlQuery,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChartSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChartSpec") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainGenerativeInsightConversationTranscriptMessageSystemMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainGenerativeInsightConversationTranscriptMessageSystemMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainGenerativeInsightConversationTranscript
// MessageSystemMessageTextOutput: A text output message from the system.
type GoogleCloudContactcenterinsightsV1mainGenerativeInsightConversationTranscriptMessageSystemMessageTextOutput struct {
	// Text: The parts of the message.
	Text []string `json:"text,omitempty"`
	// TextType: The type of the text message.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - The default text type.
	//   "THOUGHT" - The text is a thinking plan generated by the thinking tool.
	//   "FINAL_RESPONSE" - The text is a final response to the user question.
	//   "PROGRESS" - The text is an informational message about the agent's
	// progress, such as a tool being invoked. This is distinct from the agent's
	// internal thought process (`THOUGHT`) and the final answer to the user
	// (`FINAL_RESPONSE`). These messages provide insight into the agent's actions.
	TextType string `json:"textType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainGenerativeInsightConversationTranscriptMessageSystemMessageTextOutput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainGenerativeInsightConversationTranscriptMessageSystemMessageTextOutput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainGenerativeInsightConversationTranscript
// MessageSystemMessages: A wrapper for system messages per turn.
type GoogleCloudContactcenterinsightsV1mainGenerativeInsightConversationTranscriptMessageSystemMessages struct {
	// SystemMessages: A message from the system in response to the user.
	SystemMessages []*GoogleCloudContactcenterinsightsV1mainGenerativeInsightConversationTranscriptMessageSystemMessage `json:"systemMessages,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SystemMessages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SystemMessages") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainGenerativeInsightConversationTranscriptMessageSystemMessages) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainGenerativeInsightConversationTranscriptMessageSystemMessages
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainGenerativeInsightConversationTranscript
// MessageUserMessage: The user message.
type GoogleCloudContactcenterinsightsV1mainGenerativeInsightConversationTranscriptMessageUserMessage struct {
	// Text: A message from the user that is interacting with the system.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainGenerativeInsightConversationTranscriptMessageUserMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainGenerativeInsightConversationTranscriptMessageUserMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainGenerativeInsightsMetadata: The
// metadata for generative insights.
type GoogleCloudContactcenterinsightsV1mainGenerativeInsightsMetadata struct {
	// ErrorMessages: The error message when the generative insights request fails.
	ErrorMessages []*GoogleRpcStatus `json:"errorMessages,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorMessages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorMessages") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainGenerativeInsightsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainGenerativeInsightsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainGenerativeInsightsResponse: The
// response for generative insights.
type GoogleCloudContactcenterinsightsV1mainGenerativeInsightsResponse struct {
	// GenerativeResponses: The full list of generative responses. Each response is
	// ordered by time.
	GenerativeResponses []*GoogleCloudContactcenterinsightsV1mainGenerativeInsightsResponseGenerativeResponse `json:"generativeResponses,omitempty"`
	// Transcript: The transcript of the generative insights conversation.
	Transcript *GoogleCloudContactcenterinsightsV1mainGenerativeInsightConversationTranscript `json:"transcript,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenerativeResponses") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenerativeResponses") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainGenerativeInsightsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainGenerativeInsightsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainGenerativeInsightsResponseGenerativeRes
// ponse: Wrapper for storing the generative response for a chart.
type GoogleCloudContactcenterinsightsV1mainGenerativeInsightsResponseGenerativeResponse struct {
	// ChartSpec: The chart spec for the data. This will be specified in the
	// vega-lite or vega format.
	ChartSpec googleapi.RawMessage `json:"chartSpec,omitempty"`
	// GeneratedSqlQuery: The generated SQL query from the LLM. Will be populated
	// during the chart building phase. The generated SQL will be cached in the
	// corresponding chart resource.
	GeneratedSqlQuery string `json:"generatedSqlQuery,omitempty"`
	// TextMessage: The text output from the LLM. Will be populated during the
	// chart building phase. For a reloaded chart, this will NOT be populated. May
	// contain THOUGHT or a FINAL response or some in-progress response.
	TextMessage *GoogleCloudContactcenterinsightsV1mainGenerativeInsightsResponseGenerativeResponseTextOutput `json:"textMessage,omitempty"`
	// TextOutput: The text output from the LLM. Will be populated during the chart
	// building phase. For a reloaded chart, this will NOT be populated. May
	// contain THOUGHT or a FINAL response or some in-progress response.
	TextOutput string `json:"textOutput,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChartSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChartSpec") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainGenerativeInsightsResponseGenerativeResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainGenerativeInsightsResponseGenerativeResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainGenerativeInsightsResponseGenerativeRes
// ponseTextOutput: Wrapper for text output.
type GoogleCloudContactcenterinsightsV1mainGenerativeInsightsResponseGenerativeResponseTextOutput struct {
	// Text: The text output from the LLM.
	Text []string `json:"text,omitempty"`
	// TextType: The type of text output.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - The type is unspecified.
	//   "THOUGHT" - The text is part of LLM reasoning.
	//   "FINAL_RESPONSE" - The text is the final answer from LLM.
	//   "PROGRESS" - The text is an informational message about the agent's
	// progress, such as a tool being invoked. This is distinct from the agent's
	// internal thought process (`THOUGHT`) and the final answer to the user
	// (`FINAL_RESPONSE`). These messages provide insight into the agent's actions.
	TextType string `json:"textType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainGenerativeInsightsResponseGenerativeResponseTextOutput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainGenerativeInsightsResponseGenerativeResponseTextOutput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainHoldData: The data for a hold
// annotation.
type GoogleCloudContactcenterinsightsV1mainHoldData struct {
}

// GoogleCloudContactcenterinsightsV1mainImportIssueModelMetadata: Metadata
// used for import issue model.
type GoogleCloudContactcenterinsightsV1mainImportIssueModelMetadata struct {
	// CreateTime: The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original import request.
	Request *GoogleCloudContactcenterinsightsV1mainImportIssueModelRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainImportIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainImportIssueModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainImportIssueModelRequest: Request to
// import an issue model.
type GoogleCloudContactcenterinsightsV1mainImportIssueModelRequest struct {
	// CreateNewModel: Optional. If set to true, will create an issue model from
	// the imported file with randomly generated IDs for the issue model and
	// corresponding issues. Otherwise, replaces an existing model with the same ID
	// as the file.
	CreateNewModel bool `json:"createNewModel,omitempty"`
	// GcsSource: Google Cloud Storage source message.
	GcsSource *GoogleCloudContactcenterinsightsV1mainImportIssueModelRequestGcsSource `json:"gcsSource,omitempty"`
	// Parent: Required. The parent resource of the issue model.
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateNewModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateNewModel") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainImportIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainImportIssueModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainImportIssueModelRequestGcsSource:
// Google Cloud Storage Object URI to get the issue model file from.
type GoogleCloudContactcenterinsightsV1mainImportIssueModelRequestGcsSource struct {
	// ObjectUri: Required. Format: `gs:///`
	ObjectUri string `json:"objectUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ObjectUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ObjectUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainImportIssueModelRequestGcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainImportIssueModelRequestGcsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainImportIssueModelResponse: Response
// from import issue model
type GoogleCloudContactcenterinsightsV1mainImportIssueModelResponse struct {
	// IssueModel: The issue model that was imported.
	IssueModel *GoogleCloudContactcenterinsightsV1mainIssueModel `json:"issueModel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IssueModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IssueModel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainImportIssueModelResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainImportIssueModelResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainIngestConversationsMetadata: The
// metadata for an IngestConversations operation.
type GoogleCloudContactcenterinsightsV1mainIngestConversationsMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// IngestConversationsStats: Output only. Statistics for IngestConversations
	// operation.
	IngestConversationsStats *GoogleCloudContactcenterinsightsV1mainIngestConversationsMetadataIngestConversationsStats `json:"ingestConversationsStats,omitempty"`
	// PartialErrors: Output only. Partial errors during ingest operation that
	// might cause the operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: Output only. The original request for ingest.
	Request *GoogleCloudContactcenterinsightsV1mainIngestConversationsRequest `json:"request,omitempty"`
	// SampledConversations: Output only. Stores the conversation resources
	// produced by ingest sampling operations.
	SampledConversations []string `json:"sampledConversations,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainIngestConversationsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainIngestConversationsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainIngestConversationsMetadataIngestConver
// sationsStats: Statistics for IngestConversations operation.
type GoogleCloudContactcenterinsightsV1mainIngestConversationsMetadataIngestConversationsStats struct {
	// DuplicatesSkippedCount: Output only. The number of objects skipped because
	// another conversation with the same transcript uri had already been ingested.
	DuplicatesSkippedCount int64 `json:"duplicatesSkippedCount,omitempty"`
	// FailedIngestCount: Output only. The number of objects which were unable to
	// be ingested due to errors. The errors are populated in the partial_errors
	// field.
	FailedIngestCount int64 `json:"failedIngestCount,omitempty"`
	// ProcessedObjectCount: Output only. The number of objects processed during
	// the ingest operation.
	ProcessedObjectCount int64 `json:"processedObjectCount,omitempty"`
	// SuccessfulIngestCount: Output only. The number of new conversations added
	// during this ingest operation.
	SuccessfulIngestCount int64 `json:"successfulIngestCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DuplicatesSkippedCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DuplicatesSkippedCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainIngestConversationsMetadataIngestConversationsStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainIngestConversationsMetadataIngestConversationsStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainIngestConversationsRequest: The
// request to ingest conversations.
type GoogleCloudContactcenterinsightsV1mainIngestConversationsRequest struct {
	// ConversationConfig: Configuration that applies to all conversations.
	ConversationConfig *GoogleCloudContactcenterinsightsV1mainIngestConversationsRequestConversationConfig `json:"conversationConfig,omitempty"`
	// GcsSource: A cloud storage bucket source. Note that any previously ingested
	// objects from the source will be skipped to avoid duplication.
	GcsSource *GoogleCloudContactcenterinsightsV1mainIngestConversationsRequestGcsSource `json:"gcsSource,omitempty"`
	// Parent: Required. The parent resource for new conversations.
	Parent string `json:"parent,omitempty"`
	// RedactionConfig: Optional. DLP settings for transcript redaction. Optional,
	// will default to the config specified in Settings.
	RedactionConfig *GoogleCloudContactcenterinsightsV1mainRedactionConfig `json:"redactionConfig,omitempty"`
	// SampleSize: Optional. If set, this fields indicates the number of objects to
	// ingest from the Cloud Storage bucket. If empty, the entire bucket will be
	// ingested. Unless they are first deleted, conversations produced through
	// sampling won't be ingested by subsequent ingest requests.
	SampleSize int64 `json:"sampleSize,omitempty"`
	// SpeechConfig: Optional. Default Speech-to-Text configuration. Optional, will
	// default to the config specified in Settings.
	SpeechConfig *GoogleCloudContactcenterinsightsV1mainSpeechConfig `json:"speechConfig,omitempty"`
	// TranscriptObjectConfig: Configuration for when `source` contains
	// conversation transcripts.
	TranscriptObjectConfig *GoogleCloudContactcenterinsightsV1mainIngestConversationsRequestTranscriptObjectConfig `json:"transcriptObjectConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainIngestConversationsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainIngestConversationsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainIngestConversationsRequestConversationC
// onfig: Configuration that applies to all conversations.
type GoogleCloudContactcenterinsightsV1mainIngestConversationsRequestConversationConfig struct {
	// AgentChannel: Optional. Indicates which of the channels, 1 or 2, contains
	// the agent. Note that this must be set for conversations to be properly
	// displayed and analyzed.
	AgentChannel int64 `json:"agentChannel,omitempty"`
	// AgentId: Optional. An opaque, user-specified string representing a human
	// agent who handled all conversations in the import. Note that this will be
	// overridden if per-conversation metadata is provided through the
	// `metadata_bucket_uri`.
	AgentId string `json:"agentId,omitempty"`
	// CustomerChannel: Optional. Indicates which of the channels, 1 or 2, contains
	// the agent. Note that this must be set for conversations to be properly
	// displayed and analyzed.
	CustomerChannel int64 `json:"customerChannel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentChannel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentChannel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainIngestConversationsRequestConversationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainIngestConversationsRequestConversationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainIngestConversationsRequestGcsSource:
// Configuration for Cloud Storage bucket sources.
type GoogleCloudContactcenterinsightsV1mainIngestConversationsRequestGcsSource struct {
	// AudioBucketUri: Optional. The Cloud Storage path to the conversation audio
	// file. Note that: [1] Audio files will be transcribed if not already. [2]
	// Audio files and transcript files must be in separate buckets / folders. [3]
	// A source file and its corresponding audio file must share the same name to
	// be properly ingested, E.g. `gs://bucket/transcript/conversation1.json` and
	// `gs://bucket/audio/conversation1.mp3`.
	AudioBucketUri string `json:"audioBucketUri,omitempty"`
	// BucketObjectType: Optional. Specifies the type of the objects in
	// `bucket_uri`. Avoid passing this. This is inferred from the
	// `transcript_bucket_uri`, `audio_bucket_uri`.
	//
	// Possible values:
	//   "BUCKET_OBJECT_TYPE_UNSPECIFIED" - The object type is unspecified and will
	// default to `TRANSCRIPT`.
	//   "TRANSCRIPT" - The object is a transcript.
	//   "AUDIO" - The object is an audio file.
	BucketObjectType string `json:"bucketObjectType,omitempty"`
	// BucketUri: Optional. The Cloud Storage bucket containing source objects.
	// Avoid passing this. Pass this through one of `transcript_bucket_uri` or
	// `audio_bucket_uri`.
	BucketUri string `json:"bucketUri,omitempty"`
	// CustomMetadataKeys: Optional. Custom keys to extract as conversation labels
	// from metadata files in `metadata_bucket_uri`. Keys not included in this
	// field will be ignored. Note that there is a limit of 100 labels per
	// conversation.
	CustomMetadataKeys []string `json:"customMetadataKeys,omitempty"`
	// MetadataBucketUri: Optional. The Cloud Storage path to the conversation
	// metadata. Note that: [1] Metadata files are expected to be in JSON format.
	// [2] Metadata and source files (transcripts or audio) must be in separate
	// buckets / folders. [3] A source file and its corresponding metadata file
	// must share the same name to be properly ingested, E.g.
	// `gs://bucket/audio/conversation1.mp3` and
	// `gs://bucket/metadata/conversation1.json`.
	MetadataBucketUri string `json:"metadataBucketUri,omitempty"`
	// TranscriptBucketUri: Optional. The Cloud Storage path to the conversation
	// transcripts. Note that: [1] Transcript files are expected to be in JSON
	// format. [2] Transcript, audio, metadata files must be in separate buckets /
	// folders. [3] A source file and its corresponding metadata file must share
	// the same name to be properly ingested, E.g.
	// `gs://bucket/audio/conversation1.mp3` and
	// `gs://bucket/metadata/conversation1.json`.
	TranscriptBucketUri string `json:"transcriptBucketUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioBucketUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioBucketUri") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainIngestConversationsRequestGcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1mainIngestConversationsRequestGcsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1mainIngestConversationsRequestTranscriptObj
// ectConfig: Configuration for processing transcript objects.
type GoogleCloudContactcenterinsightsV1mainIngestConversationsRequestTranscriptObjectConfig struct {
	// Medium: Required. The medium transcript objects represent.
	//
	// Possible values:
	//   "MEDIUM_UNSPECIFIED" - Default value for unspecified.
	//   "PHONE_CALL" - The format for conversations that took place over the
	// phone.
	//   "CHAT" - The format for conversations that took place over chat.
	Medium string `json:"medium,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Medium") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Medium") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1mainIngestConversationsRequestTranscriptObjectConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1main