// Copyright 2026 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package ces provides access to the Gemini Enterprise for Customer Experience API.
//
// For product documentation, see: https://cloud.google.com/customer-engagement-ai/conversational-agents/ps/reference
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/ces/v1"
//	...
//	ctx := context.Background()
//	cesService, err := ces.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate.
// To restrict scopes, use [google.golang.org/api/option.WithScopes]:
//
//	cesService, err := ces.NewService(ctx, option.WithScopes(ces.CloudPlatformScope))
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	cesService, err := ces.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	cesService, err := ces.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package ces // import "google.golang.org/api/ces/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "ces:v1"
const apiName = "ces"
const apiVersion = "v1"
const basePath = "https://ces.googleapis.com/"
const basePathTemplate = "https://ces.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://ces.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// Create, update, delete, and manage your Next Gen Agents
	CesScope = "https://www.googleapis.com/auth/ces"

	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/ces",
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Projects = NewProjectsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.Apps = NewProjectsLocationsAppsService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	Apps *ProjectsLocationsAppsService

	Operations *ProjectsLocationsOperationsService
}

func NewProjectsLocationsAppsService(s *Service) *ProjectsLocationsAppsService {
	rs := &ProjectsLocationsAppsService{s: s}
	rs.Agents = NewProjectsLocationsAppsAgentsService(s)
	rs.Changelogs = NewProjectsLocationsAppsChangelogsService(s)
	rs.Conversations = NewProjectsLocationsAppsConversationsService(s)
	rs.Deployments = NewProjectsLocationsAppsDeploymentsService(s)
	rs.Examples = NewProjectsLocationsAppsExamplesService(s)
	rs.Guardrails = NewProjectsLocationsAppsGuardrailsService(s)
	rs.Sessions = NewProjectsLocationsAppsSessionsService(s)
	rs.Tools = NewProjectsLocationsAppsToolsService(s)
	rs.Toolsets = NewProjectsLocationsAppsToolsetsService(s)
	rs.Versions = NewProjectsLocationsAppsVersionsService(s)
	return rs
}

type ProjectsLocationsAppsService struct {
	s *Service

	Agents *ProjectsLocationsAppsAgentsService

	Changelogs *ProjectsLocationsAppsChangelogsService

	Conversations *ProjectsLocationsAppsConversationsService

	Deployments *ProjectsLocationsAppsDeploymentsService

	Examples *ProjectsLocationsAppsExamplesService

	Guardrails *ProjectsLocationsAppsGuardrailsService

	Sessions *ProjectsLocationsAppsSessionsService

	Tools *ProjectsLocationsAppsToolsService

	Toolsets *ProjectsLocationsAppsToolsetsService

	Versions *ProjectsLocationsAppsVersionsService
}

func NewProjectsLocationsAppsAgentsService(s *Service) *ProjectsLocationsAppsAgentsService {
	rs := &ProjectsLocationsAppsAgentsService{s: s}
	return rs
}

type ProjectsLocationsAppsAgentsService struct {
	s *Service
}

func NewProjectsLocationsAppsChangelogsService(s *Service) *ProjectsLocationsAppsChangelogsService {
	rs := &ProjectsLocationsAppsChangelogsService{s: s}
	return rs
}

type ProjectsLocationsAppsChangelogsService struct {
	s *Service
}

func NewProjectsLocationsAppsConversationsService(s *Service) *ProjectsLocationsAppsConversationsService {
	rs := &ProjectsLocationsAppsConversationsService{s: s}
	return rs
}

type ProjectsLocationsAppsConversationsService struct {
	s *Service
}

func NewProjectsLocationsAppsDeploymentsService(s *Service) *ProjectsLocationsAppsDeploymentsService {
	rs := &ProjectsLocationsAppsDeploymentsService{s: s}
	return rs
}

type ProjectsLocationsAppsDeploymentsService struct {
	s *Service
}

func NewProjectsLocationsAppsExamplesService(s *Service) *ProjectsLocationsAppsExamplesService {
	rs := &ProjectsLocationsAppsExamplesService{s: s}
	return rs
}

type ProjectsLocationsAppsExamplesService struct {
	s *Service
}

func NewProjectsLocationsAppsGuardrailsService(s *Service) *ProjectsLocationsAppsGuardrailsService {
	rs := &ProjectsLocationsAppsGuardrailsService{s: s}
	return rs
}

type ProjectsLocationsAppsGuardrailsService struct {
	s *Service
}

func NewProjectsLocationsAppsSessionsService(s *Service) *ProjectsLocationsAppsSessionsService {
	rs := &ProjectsLocationsAppsSessionsService{s: s}
	return rs
}

type ProjectsLocationsAppsSessionsService struct {
	s *Service
}

func NewProjectsLocationsAppsToolsService(s *Service) *ProjectsLocationsAppsToolsService {
	rs := &ProjectsLocationsAppsToolsService{s: s}
	return rs
}

type ProjectsLocationsAppsToolsService struct {
	s *Service
}

func NewProjectsLocationsAppsToolsetsService(s *Service) *ProjectsLocationsAppsToolsetsService {
	rs := &ProjectsLocationsAppsToolsetsService{s: s}
	return rs
}

type ProjectsLocationsAppsToolsetsService struct {
	s *Service
}

func NewProjectsLocationsAppsVersionsService(s *Service) *ProjectsLocationsAppsVersionsService {
	rs := &ProjectsLocationsAppsVersionsService{s: s}
	return rs
}

type ProjectsLocationsAppsVersionsService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

// Action: Configuration of an Action for the tool to use. Note: This can be
// either an Action or an Operation. See
// https://cloud.google.com/integration-connectors/docs/entities-operation-action
// for details.
type Action struct {
	// ConnectionActionId: ID of a Connection action for the tool to use.
	ConnectionActionId string `json:"connectionActionId,omitempty"`
	// EntityOperation: Entity operation configuration for the tool to use.
	EntityOperation *ActionEntityOperation `json:"entityOperation,omitempty"`
	// InputFields: Optional. Entity fields to use as inputs for the operation. If
	// no fields are specified, all fields of the Entity will be used.
	InputFields []string `json:"inputFields,omitempty"`
	// OutputFields: Optional. Entity fields to return from the operation. If no
	// fields are specified, all fields of the Entity will be returned.
	OutputFields []string `json:"outputFields,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConnectionActionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConnectionActionId") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Action) MarshalJSON() ([]byte, error) {
	type NoMethod Action
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ActionEntityOperation: Entity CRUD operation specification.
type ActionEntityOperation struct {
	// EntityId: Required. ID of the entity.
	EntityId string `json:"entityId,omitempty"`
	// Operation: Required. Operation to perform on the entity.
	//
	// Possible values:
	//   "OPERATION_TYPE_UNSPECIFIED" - Operation type unspecified. Invalid,
	// ConnectorTool create/update will fail.
	//   "LIST" - List operation.
	//   "GET" - Get operation.
	//   "CREATE" - Create operation.
	//   "UPDATE" - Update operation.
	//   "DELETE" - Delete operation.
	Operation string `json:"operation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ActionEntityOperation) MarshalJSON() ([]byte, error) {
	type NoMethod ActionEntityOperation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Agent: An agent acts as the fundamental building block that provides
// instructions to the Large Language Model (LLM) for executing specific tasks.
type Agent struct {
	// AfterAgentCallbacks: Optional. The callbacks to execute after the agent is
	// called. The provided callbacks are executed sequentially in the exact order
	// they are given in the list. If a callback returns an overridden response,
	// execution stops and any remaining callbacks are skipped.
	AfterAgentCallbacks []*Callback `json:"afterAgentCallbacks,omitempty"`
	// AfterModelCallbacks: Optional. The callbacks to execute after the model is
	// called. If there are multiple calls to the model, the callback will be
	// executed multiple times. The provided callbacks are executed sequentially in
	// the exact order they are given in the list. If a callback returns an
	// overridden response, execution stops and any remaining callbacks are
	// skipped.
	AfterModelCallbacks []*Callback `json:"afterModelCallbacks,omitempty"`
	// AfterToolCallbacks: Optional. The callbacks to execute after the tool is
	// invoked. If there are multiple tool invocations, the callback will be
	// executed multiple times. The provided callbacks are executed sequentially in
	// the exact order they are given in the list. If a callback returns an
	// overridden response, execution stops and any remaining callbacks are
	// skipped.
	AfterToolCallbacks []*Callback `json:"afterToolCallbacks,omitempty"`
	// BeforeAgentCallbacks: Optional. The callbacks to execute before the agent is
	// called. The provided callbacks are executed sequentially in the exact order
	// they are given in the list. If a callback returns an overridden response,
	// execution stops and any remaining callbacks are skipped.
	BeforeAgentCallbacks []*Callback `json:"beforeAgentCallbacks,omitempty"`
	// BeforeModelCallbacks: Optional. The callbacks to execute before the model is
	// called. If there are multiple calls to the model, the callback will be
	// executed multiple times. The provided callbacks are executed sequentially in
	// the exact order they are given in the list. If a callback returns an
	// overridden response, execution stops and any remaining callbacks are
	// skipped.
	BeforeModelCallbacks []*Callback `json:"beforeModelCallbacks,omitempty"`
	// BeforeToolCallbacks: Optional. The callbacks to execute before the tool is
	// invoked. If there are multiple tool invocations, the callback will be
	// executed multiple times. The provided callbacks are executed sequentially in
	// the exact order they are given in the list. If a callback returns an
	// overridden response, execution stops and any remaining callbacks are
	// skipped.
	BeforeToolCallbacks []*Callback `json:"beforeToolCallbacks,omitempty"`
	// ChildAgents: Optional. List of child agents in the agent tree. Format:
	// `projects/{project}/locations/{location}/apps/{app}/agents/{agent}`
	ChildAgents []string `json:"childAgents,omitempty"`
	// CreateTime: Output only. Timestamp when the agent was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. Human-readable description of the agent.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. Display name of the agent.
	DisplayName string `json:"displayName,omitempty"`
	// Etag: Etag used to ensure the object hasn't changed during a
	// read-modify-write operation. If the etag is empty, the update will overwrite
	// any concurrent changes.
	Etag string `json:"etag,omitempty"`
	// GeneratedSummary: Output only. If the agent is generated by the LLM
	// assistant, this field contains a descriptive summary of the generation.
	GeneratedSummary string `json:"generatedSummary,omitempty"`
	// Guardrails: Optional. List of guardrails for the agent. Format:
	// `projects/{project}/locations/{location}/apps/{app}/guardrails/{guardrail}`
	Guardrails []string `json:"guardrails,omitempty"`
	// Instruction: Optional. Instructions for the LLM model to guide the agent's
	// behavior.
	Instruction string `json:"instruction,omitempty"`
	// LlmAgent: Optional. The default agent type.
	LlmAgent *AgentLlmAgent `json:"llmAgent,omitempty"`
	// ModelSettings: Optional. Configurations for the LLM model.
	ModelSettings *ModelSettings `json:"modelSettings,omitempty"`
	// Name: Identifier. The unique identifier of the agent. Format:
	// `projects/{project}/locations/{location}/apps/{app}/agents/{agent}`
	Name string `json:"name,omitempty"`
	// RemoteDialogflowAgent: Optional. The remote Dialogflow
	// (https://cloud.google.com/dialogflow/cx/docs/concept/console-conversational-agents)
	// agent to be used for the agent execution. If this field is set, all other
	// agent level properties will be ignored. Note: If the Dialogflow agent is in
	// a different project from the app, you should grant `roles/dialogflow.client`
	// to the CES service agent `service-@gcp-sa-ces.iam.gserviceaccount.com`.
	RemoteDialogflowAgent *AgentRemoteDialogflowAgent `json:"remoteDialogflowAgent,omitempty"`
	// Tools: Optional. List of available tools for the agent. Format:
	// `projects/{project}/locations/{location}/apps/{app}/tools/{tool}`
	Tools []string `json:"tools,omitempty"`
	// Toolsets: Optional. List of toolsets for the agent.
	Toolsets []*AgentAgentToolset `json:"toolsets,omitempty"`
	// TransferRules: Optional. Agent transfer rules. If multiple rules match, the
	// first one in the list will be used.
	TransferRules []*TransferRule `json:"transferRules,omitempty"`
	// UpdateTime: Output only. Timestamp when the agent was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AfterAgentCallbacks") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AfterAgentCallbacks") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Agent) MarshalJSON() ([]byte, error) {
	type NoMethod Agent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AgentAgentToolset: A toolset with a selection of its tools.
type AgentAgentToolset struct {
	// ToolIds: Optional. The tools IDs to filter the toolset.
	ToolIds []string `json:"toolIds,omitempty"`
	// Toolset: Required. The resource name of the toolset. Format:
	// `projects/{project}/locations/{location}/apps/{app}/toolsets/{toolset}`
	Toolset string `json:"toolset,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ToolIds") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ToolIds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AgentAgentToolset) MarshalJSON() ([]byte, error) {
	type NoMethod AgentAgentToolset
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AgentLlmAgent: Default agent type. The agent uses instructions and callbacks
// specified in the agent to perform the task using a large language model.
type AgentLlmAgent struct {
}

// AgentRemoteDialogflowAgent: The agent which will transfer execution to a
// remote Dialogflow CX
// (https://docs.cloud.google.com/dialogflow/cx/docs/concept/agent) agent. The
// Dialogflow agent will process subsequent user queries until the session ends
// or flow ends, and the control is transferred back to the parent CES agent.
type AgentRemoteDialogflowAgent struct {
	// Agent: Required. The Dialogflow
	// (https://docs.cloud.google.com/dialogflow/cx/docs/concept/agent) agent
	// resource name. Format:
	// `projects/{project}/locations/{location}/agents/{agent}`
	Agent string `json:"agent,omitempty"`
	// EnvironmentId: Optional. The environment ID of the Dialogflow agent to be
	// used for the agent execution. If not specified, the draft environment will
	// be used.
	EnvironmentId string `json:"environmentId,omitempty"`
	// FlowId: Optional. The flow ID of the flow in the Dialogflow agent.
	FlowId string `json:"flowId,omitempty"`
	// InputVariableMapping: Optional. The mapping of the app variables names to
	// the Dialogflow session parameters names to be sent to the Dialogflow agent
	// as input.
	InputVariableMapping map[string]string `json:"inputVariableMapping,omitempty"`
	// OutputVariableMapping: Optional. The mapping of the Dialogflow session
	// parameters names to the app variables names to be sent back to the CES agent
	// after the Dialogflow agent execution ends.
	OutputVariableMapping map[string]string `json:"outputVariableMapping,omitempty"`
	// RespectResponseInterruptionSettings: Optional. Indicates whether to respect
	// the message-level interruption settings configured in the Dialogflow agent.
	// * If false: all response messages from the Dialogflow agent follow the
	// app-level barge-in settings. * If true: only response messages with
	// `allow_playback_interruption`
	// (https://docs.cloud.google.com/dialogflow/cx/docs/reference/rpc/google.cloud.dialogflow.cx.v3#text)
	// set to true will be interruptable, all other messages follow the app-level
	// barge-in settings.
	RespectResponseInterruptionSettings bool `json:"respectResponseInterruptionSettings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Agent") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Agent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AgentRemoteDialogflowAgent) MarshalJSON() ([]byte, error) {
	type NoMethod AgentRemoteDialogflowAgent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AgentTransfer: Represents an event indicating the transfer of a conversation
// to a different agent.
type AgentTransfer struct {
	// DisplayName: Output only. Display name of the agent.
	DisplayName string `json:"displayName,omitempty"`
	// TargetAgent: Required. The agent to which the conversation is being
	// transferred. The agent will handle the conversation from this point forward.
	// Format: `projects/{project}/locations/{location}/apps/{app}/agents/{agent}`
	TargetAgent string `json:"targetAgent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AgentTransfer) MarshalJSON() ([]byte, error) {
	type NoMethod AgentTransfer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AmbientSoundConfig: Configuration for the ambient sound to be played with
// the synthesized agent response, to enhance the naturalness of the
// conversation.
type AmbientSoundConfig struct {
	// GcsUri: Optional. Ambient noise as a mono-channel, 16kHz WAV file stored in
	// Cloud Storage (https://cloud.google.com/storage). Note: Please make sure the
	// CES service agent `service-@gcp-sa-ces.iam.gserviceaccount.com` has
	// `storage.objects.get` permission to the Cloud Storage object.
	GcsUri string `json:"gcsUri,omitempty"`
	// PrebuiltAmbientNoise: Optional. Deprecated: `prebuilt_ambient_noise` is
	// deprecated in favor of `prebuilt_ambient_sound`.
	//
	// Possible values:
	//   "PREBUILT_AMBIENT_NOISE_UNSPECIFIED" - Not specified.
	//   "RETAIL_STORE" - Ambient noise of a retail store.
	//   "CONVENTION_HALL" - Ambient noise of a convention hall.
	//   "OUTDOOR" - Ambient noise of a street.
	PrebuiltAmbientNoise string `json:"prebuiltAmbientNoise,omitempty"`
	// PrebuiltAmbientSound: Optional. Name of the prebuilt ambient sound. Valid
	// values are: - "coffee_shop" - "keyboard" - "keypad" - "hum" - "office_1" -
	// "office_2" - "office_3" - "room_1" - "room_2" - "room_3" - "room_4" -
	// "room_5" - "air_conditioner"
	PrebuiltAmbientSound string `json:"prebuiltAmbientSound,omitempty"`
	// VolumeGainDb: Optional. Volume gain (in dB) of the normal native volume
	// supported by ambient noise, in the range [-96.0, 16.0]. If unset, or set to
	// a value of 0.0 (dB), will play at normal native signal amplitude. A value of
	// -6.0 (dB) will play at approximately half the amplitude of the normal native
	// signal amplitude. A value of +6.0 (dB) will play at approximately twice the
	// amplitude of the normal native signal amplitude. We strongly recommend not
	// to exceed +10 (dB) as there's usually no effective increase in loudness for
	// any value greater than that.
	VolumeGainDb float64 `json:"volumeGainDb,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsUri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AmbientSoundConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AmbientSoundConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *AmbientSoundConfig) UnmarshalJSON(data []byte) error {
	type NoMethod AmbientSoundConfig
	var s1 struct {
		VolumeGainDb gensupport.JSONFloat64 `json:"volumeGainDb"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.VolumeGainDb = float64(s1.VolumeGainDb)
	return nil
}

// ApiAuthentication: Authentication information required for API calls.
type ApiAuthentication struct {
	// ApiKeyConfig: Optional. Config for API key auth.
	ApiKeyConfig *ApiKeyConfig `json:"apiKeyConfig,omitempty"`
	// BearerTokenConfig: Optional. Config for bearer token auth.
	BearerTokenConfig *BearerTokenConfig `json:"bearerTokenConfig,omitempty"`
	// OauthConfig: Optional. Config for OAuth.
	OauthConfig *OAuthConfig `json:"oauthConfig,omitempty"`
	// ServiceAccountAuthConfig: Optional. Config for service account
	// authentication.
	ServiceAccountAuthConfig *ServiceAccountAuthConfig `json:"serviceAccountAuthConfig,omitempty"`
	// ServiceAgentIdTokenAuthConfig: Optional. Config for ID token auth generated
	// from CES service agent.
	ServiceAgentIdTokenAuthConfig *ServiceAgentIdTokenAuthConfig `json:"serviceAgentIdTokenAuthConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiKeyConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiKeyConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ApiAuthentication) MarshalJSON() ([]byte, error) {
	type NoMethod ApiAuthentication
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ApiKeyConfig: Configurations for authentication with API key.
type ApiKeyConfig struct {
	// ApiKeySecretVersion: Required. The name of the SecretManager secret version
	// resource storing the API key. Format:
	// `projects/{project}/secrets/{secret}/versions/{version}` Note: You should
	// grant `roles/secretmanager.secretAccessor` role to the CES service agent
	// `service-@gcp-sa-ces.iam.gserviceaccount.com`.
	ApiKeySecretVersion string `json:"apiKeySecretVersion,omitempty"`
	// KeyName: Required. The parameter name or the header name of the API key.
	// E.g., If the API request is "https://example.com/act?X-Api-Key=",
	// "X-Api-Key" would be the parameter name.
	KeyName string `json:"keyName,omitempty"`
	// RequestLocation: Required. Key location in the request.
	//
	// Possible values:
	//   "REQUEST_LOCATION_UNSPECIFIED" - Unspecified. This value should not be
	// unused.
	//   "HEADER" - Represents the key in http header.
	//   "QUERY_STRING" - Represents the key in query string.
	RequestLocation string `json:"requestLocation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiKeySecretVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiKeySecretVersion") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ApiKeyConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ApiKeyConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// App: An app serves as a top-level container for a group of agents, including
// the root agent and its sub-agents, along with their associated
// configurations. These agents work together to achieve specific goals within
// the app's context.
type App struct {
	// AudioProcessingConfig: Optional. Audio processing configuration of the app.
	AudioProcessingConfig *AudioProcessingConfig `json:"audioProcessingConfig,omitempty"`
	// ClientCertificateSettings: Optional. The default client certificate settings
	// for the app.
	ClientCertificateSettings *ClientCertificateSettings `json:"clientCertificateSettings,omitempty"`
	// CreateTime: Output only. Timestamp when the app was created.
	CreateTime string `json:"createTime,omitempty"`
	// DataStoreSettings: Optional. The data store settings for the app.
	DataStoreSettings *DataStoreSettings `json:"dataStoreSettings,omitempty"`
	// DefaultChannelProfile: Optional. The default channel profile used by the
	// app.
	DefaultChannelProfile *ChannelProfile `json:"defaultChannelProfile,omitempty"`
	// DeploymentCount: Output only. Number of deployments in the app.
	DeploymentCount int64 `json:"deploymentCount,omitempty"`
	// Description: Optional. Human-readable description of the app.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. Display name of the app.
	DisplayName string `json:"displayName,omitempty"`
	// Etag: Output only. Etag used to ensure the object hasn't changed during a
	// read-modify-write operation. If the etag is empty, the update will overwrite
	// any concurrent changes.
	Etag string `json:"etag,omitempty"`
	// EvaluationMetricsThresholds: Optional. The evaluation thresholds for the
	// app.
	EvaluationMetricsThresholds *EvaluationMetricsThresholds `json:"evaluationMetricsThresholds,omitempty"`
	// GlobalInstruction: Optional. Instructions for all the agents in the app. You
	// can use this instruction to set up a stable identity or personality across
	// all the agents.
	GlobalInstruction string `json:"globalInstruction,omitempty"`
	// Guardrails: Optional. List of guardrails for the app. Format:
	// `projects/{project}/locations/{location}/apps/{app}/guardrails/{guardrail}`
	Guardrails []string `json:"guardrails,omitempty"`
	// LanguageSettings: Optional. Language settings of the app.
	LanguageSettings *LanguageSettings `json:"languageSettings,omitempty"`
	// Locked: Optional. Indicates whether the app is locked for changes. If the
	// app is locked, modifications to the app resources will be rejected.
	Locked bool `json:"locked,omitempty"`
	// LoggingSettings: Optional. Logging settings of the app.
	LoggingSettings *LoggingSettings `json:"loggingSettings,omitempty"`
	// Metadata: Optional. Metadata about the app. This field can be used to store
	// additional information relevant to the app's details or intended usages.
	Metadata map[string]string `json:"metadata,omitempty"`
	// ModelSettings: Optional. The default LLM model settings for the app.
	// Individual resources (e.g. agents, guardrails) can override these
	// configurations as needed.
	ModelSettings *ModelSettings `json:"modelSettings,omitempty"`
	// Name: Identifier. The unique identifier of the app. Format:
	// `projects/{project}/locations/{location}/apps/{app}`
	Name string `json:"name,omitempty"`
	// Pinned: Optional. Whether the app is pinned in the app list.
	Pinned bool `json:"pinned,omitempty"`
	// PredefinedVariableDeclarations: Output only. The declarations of predefined
	// variables for the app.
	PredefinedVariableDeclarations []*AppVariableDeclaration `json:"predefinedVariableDeclarations,omitempty"`
	// RootAgent: Optional. The root agent is the entry point of the app. Format:
	// `projects/{project}/locations/{location}/apps/{app}/agents/{agent}`
	RootAgent string `json:"rootAgent,omitempty"`
	// TimeZoneSettings: Optional. TimeZone settings of the app.
	TimeZoneSettings *TimeZoneSettings `json:"timeZoneSettings,omitempty"`
	// ToolExecutionMode: Optional. The tool execution mode for the app. If not
	// provided, will default to PARALLEL.
	//
	// Possible values:
	//   "TOOL_EXECUTION_MODE_UNSPECIFIED" - Unspecified tool execution mode.
	// Default to PARALLEL.
	//   "PARALLEL" - If there are multiple tools being selected, they will be
	// executed in parallel, with the same
	// [ToolContext](https://google.github.io/adk-docs/context/#the-different-types-
	// of-context).
	//   "SEQUENTIAL" - If there are multiple tools being selected, they will be
	// executed sequentially. The next tool will only be executed after the
	// previous tool completes and it can see updated
	// [ToolContext](https://google.github.io/adk-docs/context/#the-different-types-
	// of-context) from the previous tool.
	ToolExecutionMode string `json:"toolExecutionMode,omitempty"`
	// UpdateTime: Output only. Timestamp when the app was last updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// VariableDeclarations: Optional. The declarations of the variables.
	VariableDeclarations []*AppVariableDeclaration `json:"variableDeclarations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AudioProcessingConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioProcessingConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s App) MarshalJSON() ([]byte, error) {
	type NoMethod App
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AppSnapshot: A snapshot of the app.
type AppSnapshot struct {
	// Agents: Optional. List of agents in the app.
	Agents []*Agent `json:"agents,omitempty"`
	// App: Optional. The basic settings for the app.
	App *App `json:"app,omitempty"`
	// Examples: Optional. List of examples in the app.
	Examples []*Example `json:"examples,omitempty"`
	// Guardrails: Optional. List of guardrails in the app.
	Guardrails []*Guardrail `json:"guardrails,omitempty"`
	// Tools: Optional. List of tools in the app.
	Tools []*Tool `json:"tools,omitempty"`
	// Toolsets: Optional. List of toolsets in the app.
	Toolsets []*Toolset `json:"toolsets,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Agents") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Agents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AppSnapshot) MarshalJSON() ([]byte, error) {
	type NoMethod AppSnapshot
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AppVariableDeclaration: Defines the structure and metadata for a variable.
type AppVariableDeclaration struct {
	// Description: Required. The description of the variable.
	Description string `json:"description,omitempty"`
	// Name: Required. The name of the variable. The name must start with a letter
	// or underscore and contain only letters, numbers, or underscores.
	Name string `json:"name,omitempty"`
	// Schema: Required. The schema of the variable.
	Schema *Schema `json:"schema,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AppVariableDeclaration) MarshalJSON() ([]byte, error) {
	type NoMethod AppVariableDeclaration
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AppVersion: In Customer Engagement Suite (CES), an app version is a snapshot
// of the app at a specific point in time. It is immutable and cannot be
// modified once created.
type AppVersion struct {
	// CreateTime: Output only. Timestamp when the app version was created.
	CreateTime string `json:"createTime,omitempty"`
	// Creator: Output only. Email of the user who created the app version.
	Creator string `json:"creator,omitempty"`
	// Description: Optional. The description of the app version.
	Description string `json:"description,omitempty"`
	// DisplayName: Optional. The display name of the app version.
	DisplayName string `json:"displayName,omitempty"`
	// Etag: Output only. Etag used to ensure the object hasn't changed during a
	// read-modify-write operation. If the etag is empty, the update will overwrite
	// any concurrent changes.
	Etag string `json:"etag,omitempty"`
	// Name: Identifier. The unique identifier of the app version. Format:
	// `projects/{project}/locations/{location}/apps/{app}/versions/{version}`
	Name string `json:"name,omitempty"`
	// Snapshot: Output only. The snapshot of the app when the version is created.
	Snapshot *AppSnapshot `json:"snapshot,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AppVersion) MarshalJSON() ([]byte, error) {
	type NoMethod AppVersion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AudioProcessingConfig: Configuration for how the input and output audio
// should be processed and delivered.
type AudioProcessingConfig struct {
	// AmbientSoundConfig: Optional. Configuration for the ambient sound to be
	// played with the synthesized agent response, to enhance the naturalness of
	// the conversation.
	AmbientSoundConfig *AmbientSoundConfig `json:"ambientSoundConfig,omitempty"`
	// BargeInConfig: Optional. Configures the agent behavior for the user barge-in
	// activities.
	BargeInConfig *BargeInConfig `json:"bargeInConfig,omitempty"`
	// InactivityTimeout: Optional. The duration of user inactivity (no speech or
	// interaction) before the agent prompts the user for reengagement. If not set,
	// the agent will not prompt the user for reengagement.
	InactivityTimeout string `json:"inactivityTimeout,omitempty"`
	// SynthesizeSpeechConfigs: Optional. Configuration of how the agent response
	// should be synthesized, mapping from the language code to
	// SynthesizeSpeechConfig. If the configuration for the specified language code
	// is not found, the configuration for the root language code will be used. For
	// example, if the map contains "en-us" and "en", and the specified language
	// code is "en-gb", then "en" configuration will be used. Note: Language code
	// is case-insensitive.
	SynthesizeSpeechConfigs map[string]SynthesizeSpeechConfig `json:"synthesizeSpeechConfigs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AmbientSoundConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AmbientSoundConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AudioProcessingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AudioProcessingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AudioRecordingConfig: Configuration for how the audio interactions should be
// recorded.
type AudioRecordingConfig struct {
	// GcsBucket: Optional. The Cloud Storage (https://cloud.google.com/storage)
	// bucket to store the session audio recordings. The URI must start with
	// "gs://". Please choose a bucket location that meets your data residency
	// requirements. Note: If the Cloud Storage bucket is in a different project
	// from the app, you should grant `storage.objects.create` permission to the
	// CES service agent `service-@gcp-sa-ces.iam.gserviceaccount.com`.
	GcsBucket string `json:"gcsBucket,omitempty"`
	// GcsPathPrefix: Optional. The Cloud Storage path prefix for audio recordings.
	// This prefix can include the following placeholders, which will be
	// dynamically substituted at serving time: - $project: project ID - $location:
	// app location - $app: app ID - $date: session date in YYYY-MM-DD format -
	// $session: session ID If the path prefix is not specified, the default prefix
	// `$project/$location/$app/$date/$session/` will be used.
	GcsPathPrefix string `json:"gcsPathPrefix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsBucket") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsBucket") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AudioRecordingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AudioRecordingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BargeInConfig: Configuration for how the user barge-in activities should be
// handled.
type BargeInConfig struct {
	// BargeInAwareness: Optional. If enabled, the agent will adapt its next
	// response based on the assumption that the user hasn't heard the full
	// preceding agent message. This should not be used in scenarios where agent
	// responses are displayed visually.
	BargeInAwareness bool `json:"bargeInAwareness,omitempty"`
	// DisableBargeIn: Optional. Disables user barge-in while the agent is
	// speaking. If true, user input during agent response playback will be
	// ignored. Deprecated: `disable_barge_in` is deprecated in favor of
	// `disable_barge_in_control` in ChannelProfile.
	DisableBargeIn bool `json:"disableBargeIn,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BargeInAwareness") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BargeInAwareness") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BargeInConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BargeInConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BatchDeleteConversationsRequest: Request message for
// AgentService.BatchDeleteConversations.
type BatchDeleteConversationsRequest struct {
	// Conversations: Required. The resource names of the conversations to delete.
	Conversations []string `json:"conversations,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conversations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conversations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BatchDeleteConversationsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod BatchDeleteConversationsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BearerTokenConfig: Configurations for authentication with a bearer token.
type BearerTokenConfig struct {
	// Token: Required. The bearer token. Must be in the format
	// `$context.variables.`.
	Token string `json:"token,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Token") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Token") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BearerTokenConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BearerTokenConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BigQueryExportSettings: Settings to describe the BigQuery export behaviors
// for the app.
type BigQueryExportSettings struct {
	// Dataset: Optional. The BigQuery dataset to export the data to.
	Dataset string `json:"dataset,omitempty"`
	// Enabled: Optional. Indicates whether the BigQuery export is enabled.
	Enabled bool `json:"enabled,omitempty"`
	// Project: Optional. The project ID of the BigQuery dataset to export the data
	// to. Note: If the BigQuery dataset is in a different project from the app,
	// you should grant `roles/bigquery.admin` role to the CES service agent
	// `service-@gcp-sa-ces.iam.gserviceaccount.com`.
	Project string `json:"project,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dataset") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dataset") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BigQueryExportSettings) MarshalJSON() ([]byte, error) {
	type NoMethod BigQueryExportSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Blob: Represents a blob input or output in the conversation.
type Blob struct {
	// Data: Required. Raw bytes of the blob.
	Data string `json:"data,omitempty"`
	// MimeType: Required. The IANA standard MIME type of the source data.
	MimeType string `json:"mimeType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Data") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Data") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Blob) MarshalJSON() ([]byte, error) {
	type NoMethod Blob
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Callback: A callback defines the custom logic to be executed at various
// stages of agent interaction.
type Callback struct {
	// Description: Optional. Human-readable description of the callback.
	Description string `json:"description,omitempty"`
	// Disabled: Optional. Whether the callback is disabled. Disabled callbacks are
	// ignored by the agent.
	Disabled bool `json:"disabled,omitempty"`
	// ProactiveExecutionEnabled: Optional. If enabled, the callback will also be
	// executed on intermediate model outputs. This setting only affects after
	// model callback. **ENABLE WITH CAUTION**. Typically after model callback only
	// needs to be executed after receiving all model responses. Enabling proactive
	// execution may have negative implication on the execution cost and latency,
	// and should only be enabled in rare situations.
	ProactiveExecutionEnabled bool `json:"proactiveExecutionEnabled,omitempty"`
	// PythonCode: Required. The python code to execute for the callback.
	PythonCode string `json:"pythonCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Callback) MarshalJSON() ([]byte, error) {
	type NoMethod Callback
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CancelOperationRequest: The request message for Operations.CancelOperation.
type CancelOperationRequest struct {
}

// Changelog: Changelogs represent a change made to the app or to an resource
// within the app.
type Changelog struct {
	// Action: Output only. The action that was performed on the resource.
	Action string `json:"action,omitempty"`
	// Author: Output only. Email address of the change author.
	Author string `json:"author,omitempty"`
	// CreateTime: Output only. The time when the change was made.
	CreateTime string `json:"createTime,omitempty"`
	// DependentResources: Output only. The dependent resources that were changed.
	DependentResources []googleapi.RawMessage `json:"dependentResources,omitempty"`
	// Description: Output only. Description of the change. which typically
	// captures the changed fields in the resource.
	Description string `json:"description,omitempty"`
	// DisplayName: Output only. Display name of the change. It typically should be
	// the display name of the resource that was changed.
	DisplayName string `json:"displayName,omitempty"`
	// Name: Identifier. The unique identifier of the changelog. Format:
	// `projects/{project}/locations/{location}/apps/{app}/changelogs/{changelog}`
	Name string `json:"name,omitempty"`
	// NewResource: Output only. The new resource after the change.
	NewResource googleapi.RawMessage `json:"newResource,omitempty"`
	// OriginalResource: Output only. The original resource before the change.
	OriginalResource googleapi.RawMessage `json:"originalResource,omitempty"`
	// Resource: Output only. The resource that was changed.
	Resource string `json:"resource,omitempty"`
	// ResourceType: Output only. The type of the resource that was changed.
	ResourceType string `json:"resourceType,omitempty"`
	// SequenceNumber: Output only. The monotonically increasing sequence number of
	// the changelog.
	SequenceNumber int64 `json:"sequenceNumber,omitempty,string"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Changelog) MarshalJSON() ([]byte, error) {
	type NoMethod Changelog
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ChannelProfile: A ChannelProfile configures the agent's behavior for a
// specific communication channel, such as web UI or telephony.
type ChannelProfile struct {
	// ChannelType: Optional. The type of the channel profile.
	//
	// Possible values:
	//   "UNKNOWN" - Unknown channel type.
	//   "WEB_UI" - Web UI channel.
	//   "API" - API channel.
	//   "TWILIO" - Twilio channel.
	//   "GOOGLE_TELEPHONY_PLATFORM" - Google Telephony Platform channel.
	//   "CONTACT_CENTER_AS_A_SERVICE" - Contact Center as a Service (CCaaS)
	// channel.
	//   "FIVE9" - Five9 channel.
	ChannelType string `json:"channelType,omitempty"`
	// DisableBargeInControl: Optional. Whether to disable user barge-in control in
	// the conversation. - **true**: User interruptions are disabled while the
	// agent is speaking. - **false**: The agent retains automatic control over
	// when the user can interrupt.
	DisableBargeInControl bool `json:"disableBargeInControl,omitempty"`
	// DisableDtmf: Optional. Whether to disable DTMF (dual-tone multi-frequency).
	DisableDtmf bool `json:"disableDtmf,omitempty"`
	// NoiseSuppressionLevel: Optional. The noise suppression level of the channel
	// profile. Available values are "low", "moderate", "high", "very_high".
	NoiseSuppressionLevel string `json:"noiseSuppressionLevel,omitempty"`
	// PersonaProperty: Optional. The persona property of the channel profile.
	PersonaProperty *ChannelProfilePersonaProperty `json:"personaProperty,omitempty"`
	// ProfileId: Optional. The unique identifier of the channel profile.
	ProfileId string `json:"profileId,omitempty"`
	// WebWidgetConfig: Optional. The configuration for the web widget.
	WebWidgetConfig *ChannelProfileWebWidgetConfig `json:"webWidgetConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChannelType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChannelType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ChannelProfile) MarshalJSON() ([]byte, error) {
	type NoMethod ChannelProfile
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ChannelProfilePersonaProperty: Represents the persona property of a channel.
type ChannelProfilePersonaProperty struct {
	// Persona: Optional. The persona of the channel.
	//
	// Possible values:
	//   "UNKNOWN" - UNKNOWN persona.
	//   "CONCISE" - The agent keeps the responses concise and to the point
	//   "CHATTY" - The agent provides additional context, explanations, and
	// details
	Persona string `json:"persona,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Persona") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Persona") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ChannelProfilePersonaProperty) MarshalJSON() ([]byte, error) {
	type NoMethod ChannelProfilePersonaProperty
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ChannelProfileWebWidgetConfig: Message for configuration for the web widget.
type ChannelProfileWebWidgetConfig struct {
	// Modality: Optional. The modality of the web widget.
	//
	// Possible values:
	//   "MODALITY_UNSPECIFIED" - Unknown modality.
	//   "CHAT_AND_VOICE" - Widget supports both chat and voice input.
	//   "VOICE_ONLY" - Widget supports only voice input.
	//   "CHAT_ONLY" - Widget supports only chat input.
	Modality string `json:"modality,omitempty"`
	// SecuritySettings: Optional. The security settings of the web widget.
	SecuritySettings *ChannelProfileWebWidgetConfigSecuritySettings `json:"securitySettings,omitempty"`
	// Theme: Optional. The theme of the web widget.
	//
	// Possible values:
	//   "THEME_UNSPECIFIED" - Unknown theme.
	//   "LIGHT" - Light theme.
	//   "DARK" - Dark theme.
	Theme string `json:"theme,omitempty"`
	// WebWidgetTitle: Optional. The title of the web widget.
	WebWidgetTitle string `json:"webWidgetTitle,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Modality") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Modality") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ChannelProfileWebWidgetConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ChannelProfileWebWidgetConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ChannelProfileWebWidgetConfigSecuritySettings: Security settings for the web
// widget.
type ChannelProfileWebWidgetConfigSecuritySettings struct {
	// AllowedOrigins: Optional. The origins that are allowed to host the web
	// widget. An origin is defined by RFC 6454. If empty, all origins are allowed.
	// A maximum of 100 origins is allowed. Example: "https://example.com"
	AllowedOrigins []string `json:"allowedOrigins,omitempty"`
	// EnableOriginCheck: Optional. Indicates whether origin check for the web
	// widget is enabled. If `true`, the web widget will check the origin of the
	// website that loads the web widget and only allow it to be loaded in the same
	// origin or any of the allowed origins.
	EnableOriginCheck bool `json:"enableOriginCheck,omitempty"`
	// EnablePublicAccess: Optional. Indicates whether public access to the web
	// widget is enabled. If `true`, the web widget will be publicly accessible. If
	// `false`, the web widget must be integrated with your own authentication and
	// authorization system to return valid credentials for accessing the CES
	// agent.
	EnablePublicAccess bool `json:"enablePublicAccess,omitempty"`
	// EnableRecaptcha: Optional. Indicates whether reCAPTCHA verification for the
	// web widget is enabled.
	EnableRecaptcha bool `json:"enableRecaptcha,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowedOrigins") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowedOrigins") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ChannelProfileWebWidgetConfigSecuritySettings) MarshalJSON() ([]byte, error) {
	type NoMethod ChannelProfileWebWidgetConfigSecuritySettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Chunk: A chunk of content within a message.
type Chunk struct {
	// AgentTransfer: Optional. Agent transfer event.
	AgentTransfer *AgentTransfer `json:"agentTransfer,omitempty"`
	// DefaultVariables: A struct represents default variables at the start of the
	// conversation, keyed by variable names.
	DefaultVariables googleapi.RawMessage `json:"defaultVariables,omitempty"`
	// Image: Optional. Image data.
	Image *Image `json:"image,omitempty"`
	// Payload: Optional. Custom payload data.
	Payload googleapi.RawMessage `json:"payload,omitempty"`
	// Text: Optional. Text data.
	Text string `json:"text,omitempty"`
	// ToolCall: Optional. Tool execution request.
	ToolCall *ToolCall `json:"toolCall,omitempty"`
	// ToolResponse: Optional. Tool execution response.
	ToolResponse *ToolResponse `json:"toolResponse,omitempty"`
	// Transcript: Optional. Transcript associated with the audio.
	Transcript string `json:"transcript,omitempty"`
	// UpdatedVariables: A struct represents variables that were updated in the
	// conversation, keyed by variable names.
	UpdatedVariables googleapi.RawMessage `json:"updatedVariables,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentTransfer") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentTransfer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Chunk) MarshalJSON() ([]byte, error) {
	type NoMethod Chunk
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Citations: Citations associated with the agent response.
type Citations struct {
	// CitedChunks: List of cited pieces of information.
	CitedChunks []*CitationsCitedChunk `json:"citedChunks,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CitedChunks") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CitedChunks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Citations) MarshalJSON() ([]byte, error) {
	type NoMethod Citations
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CitationsCitedChunk: Piece of cited information.
type CitationsCitedChunk struct {
	// Text: Text used for citaiton.
	Text string `json:"text,omitempty"`
	// Title: Title of the cited document.
	Title string `json:"title,omitempty"`
	// Uri: URI used for citation.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CitationsCitedChunk) MarshalJSON() ([]byte, error) {
	type NoMethod CitationsCitedChunk
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ClientCertificateSettings: Settings for custom client certificates.
type ClientCertificateSettings struct {
	// Passphrase: Optional. The name of the SecretManager secret version resource
	// storing the passphrase to decrypt the private key. Should be left unset if
	// the private key is not encrypted. Format:
	// `projects/{project}/secrets/{secret}/versions/{version}`
	Passphrase string `json:"passphrase,omitempty"`
	// PrivateKey: Required. The name of the SecretManager secret version resource
	// storing the private key encoded in PEM format. Format:
	// `projects/{project}/secrets/{secret}/versions/{version}`
	PrivateKey string `json:"privateKey,omitempty"`
	// TlsCertificate: Required. The TLS certificate encoded in PEM format. This
	// string must include the begin header and end footer lines.
	TlsCertificate string `json:"tlsCertificate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Passphrase") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Passphrase") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ClientCertificateSettings) MarshalJSON() ([]byte, error) {
	type NoMethod ClientCertificateSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ClientFunction: Represents a client-side function that the agent can invoke.
// When the tool is chosen by the agent, control is handed off to the client.
// The client is responsible for executing the function and returning the
// result as a ToolResponse to continue the interaction with the agent.
type ClientFunction struct {
	// Description: Optional. The function description.
	Description string `json:"description,omitempty"`
	// Name: Required. The function name.
	Name string `json:"name,omitempty"`
	// Parameters: Optional. The schema of the function parameters.
	Parameters *Schema `json:"parameters,omitempty"`
	// Response: Optional. The schema of the function response.
	Response *Schema `json:"response,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ClientFunction) MarshalJSON() ([]byte, error) {
	type NoMethod ClientFunction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CloudLoggingSettings: Settings to describe the Cloud Logging behaviors for
// the app.
type CloudLoggingSettings struct {
	// EnableCloudLogging: Optional. Whether to enable Cloud Logging for the
	// sessions.
	EnableCloudLogging bool `json:"enableCloudLogging,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableCloudLogging") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableCloudLogging") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudLoggingSettings) MarshalJSON() ([]byte, error) {
	type NoMethod CloudLoggingSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CodeBlock: A code block to be executed instead of a real tool call.
type CodeBlock struct {
	// PythonCode: Required. Python code which will be invoked in tool fake mode.
	// Expected Python function signature - To catch all tool calls: def
	// fake_tool_call(tool: Tool, input: dict[str, Any], callback_context:
	// CallbackContext) -> Optional[dict[str, Any]]: To catch a specific tool call:
	// def fake_{tool_id}(tool: Tool, input: dict[str, Any], callback_context:
	// CallbackContext) -> Optional[dict[str, Any]]: If the function returns None,
	// the real tool will be invoked instead.
	PythonCode string `json:"pythonCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PythonCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PythonCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CodeBlock) MarshalJSON() ([]byte, error) {
	type NoMethod CodeBlock
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConnectorTool: A ConnectorTool allows connections to different integrations.
// See: https://cloud.google.com/integration-connectors/docs/overview.
type ConnectorTool struct {
	// Action: Required. Action for the tool to use.
	Action *Action `json:"action,omitempty"`
	// AuthConfig: Optional. Configures how authentication is handled in
	// Integration Connectors. By default, an admin authentication is passed in the
	// Integration Connectors API requests. You can override it with a different
	// end-user authentication config. **Note**: The Connection must have
	// authentication override enabled in order to specify an EUC configuration
	// here - otherwise, the ConnectorTool creation will fail. See
	// https://cloud.google.com/application-integration/docs/configure-connectors-task#configure-authentication-override
	// for details.
	AuthConfig *EndUserAuthConfig `json:"authConfig,omitempty"`
	// Connection: Required. The full resource name of the referenced Integration
	// Connectors Connection. Format:
	// `projects/{project}/locations/{location}/connections/{connection}`
	Connection string `json:"connection,omitempty"`
	// Description: Optional. The description of the tool that can be used by the
	// Agent to decide whether to call this ConnectorTool.
	Description string `json:"description,omitempty"`
	// Name: Optional. The name of the tool that can be used by the Agent to decide
	// whether to call this ConnectorTool.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConnectorTool) MarshalJSON() ([]byte, error) {
	type NoMethod ConnectorTool
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConnectorToolset: A toolset that generates tools from an Integration
// Connectors Connection.
type ConnectorToolset struct {
	// AuthConfig: Optional. Configures how authentication is handled in
	// Integration Connectors. By default, an admin authentication is passed in the
	// Integration Connectors API requests. You can override it with a different
	// end-user authentication config. **Note**: The Connection must have
	// authentication override enabled in order to specify an EUC configuration
	// here - otherwise, the Toolset creation will fail. See:
	// https://cloud.google.com/application-integration/docs/configure-connectors-task#configure-authentication-override
	AuthConfig *EndUserAuthConfig `json:"authConfig,omitempty"`
	// Connection: Required. The full resource name of the referenced Integration
	// Connectors Connection. Format:
	// `projects/{project}/locations/{location}/connections/{connection}`
	Connection string `json:"connection,omitempty"`
	// ConnectorActions: Required. The list of connector actions/entity operations
	// to generate tools for.
	ConnectorActions []*Action `json:"connectorActions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AuthConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuthConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConnectorToolset) MarshalJSON() ([]byte, error) {
	type NoMethod ConnectorToolset
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Conversation: A conversation represents an interaction between an end user
// and the CES app.
type Conversation struct {
	// AppVersion: Output only. The version of the app used for processing the
	// conversation. Format:
	// `projects/{project}/locations/{location}/apps/{app}/versions/{version}`
	AppVersion string `json:"appVersion,omitempty"`
	// ChannelType: DEPRECATED. Please use input_types instead.
	//
	// Possible values:
	//   "CHANNEL_TYPE_UNSPECIFIED" - Unspecified channel type.
	//   "TEXT" - The conversation only contains text messages between the end user
	// and the agent.
	//   "AUDIO" - The conversation contains audio messages between the end user
	// and the agent.
	//   "MULTIMODAL" - The conversation multi-modal messages (e.g. image) between
	// the end user and the agent.
	ChannelType string `json:"channelType,omitempty"`
	// Deployment: Output only. The deployment of the app used for processing the
	// conversation. Format:
	// `projects/{project}/locations/{location}/apps/{app}/deployments/{deployment}`
	Deployment string `json:"deployment,omitempty"`
	// EndTime: Output only. Timestamp when the conversation was completed.
	EndTime string `json:"endTime,omitempty"`
	// EntryAgent: Output only. The agent that initially handles the conversation.
	// If not specified, the conversation is handled by the root agent. Format:
	// `projects/{project}/locations/{location}/apps/{app}/agents/{agent}`
	EntryAgent string `json:"entryAgent,omitempty"`
	// InputTypes: Output only. The input types of the conversation.
	//
	// Possible values:
	//   "INPUT_TYPE_UNSPECIFIED" - Unspecified input type.
	//   "INPUT_TYPE_TEXT" - The input message is text.
	//   "INPUT_TYPE_AUDIO" - The input message is audio.
	//   "INPUT_TYPE_IMAGE" - The input message is image.
	//   "INPUT_TYPE_BLOB" - The input message is blob file.
	//   "INPUT_TYPE_TOOL_RESPONSE" - The input message is client function tool
	// response.
	//   "INPUT_TYPE_VARIABLES" - The input message are variables.
	InputTypes []string `json:"inputTypes,omitempty"`
	// LanguageCode: Output only. The language code of the conversation.
	LanguageCode string `json:"languageCode,omitempty"`
	// Messages: Deprecated. Use turns instead.
	Messages []*Message `json:"messages,omitempty"`
	// Name: Identifier. The unique identifier of the conversation. Format:
	// `projects/{project}/locations/{location}/apps/{app}/conversations/{conversati
	// on}`
	Name string `json:"name,omitempty"`
	// Source: Output only. Indicate the source of the conversation.
	//
	// Possible values:
	//   "SOURCE_UNSPECIFIED" - Unspecified source.
	//   "LIVE" - The conversation is from the live end user.
	//   "SIMULATOR" - The conversation is from the simulator.
	//   "EVAL" - The conversation is from the evaluation.
	Source string `json:"source,omitempty"`
	// StartTime: Output only. Timestamp when the conversation was created.
	StartTime string `json:"startTime,omitempty"`
	// TurnCount: Output only. The number of turns in the conversation.
	TurnCount int64 `json:"turnCount,omitempty"`
	// Turns: Required. The turns in the conversation.
	Turns []*ConversationTurn `json:"turns,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AppVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AppVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Conversation) MarshalJSON() ([]byte, error) {
	type NoMethod Conversation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConversationLoggingSettings: Settings to describe the conversation logging
// behaviors for the app.
type ConversationLoggingSettings struct {
	// DisableConversationLogging: Optional. Whether to disable conversation
	// logging for the sessions.
	DisableConversationLogging bool `json:"disableConversationLogging,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisableConversationLogging")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisableConversationLogging") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConversationLoggingSettings) MarshalJSON() ([]byte, error) {
	type NoMethod ConversationLoggingSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConversationTurn: All information about a single turn in the conversation.
type ConversationTurn struct {
	// Messages: Optional. List of messages in the conversation turn, including
	// user input, agent responses and intermediate events during the processing.
	Messages []*Message `json:"messages,omitempty"`
	// RootSpan: Optional. The root span of the action processing.
	RootSpan *Span `json:"rootSpan,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Messages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Messages") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConversationTurn) MarshalJSON() ([]byte, error) {
	type NoMethod ConversationTurn
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DataStore: A DataStore resource in Vertex AI Search.
type DataStore struct {
	// ConnectorConfig: Output only. The connector config for the data store
	// connection.
	ConnectorConfig *DataStoreConnectorConfig `json:"connectorConfig,omitempty"`
	// CreateTime: Output only. Timestamp when the data store was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Output only. The display name of the data store.
	DisplayName string `json:"displayName,omitempty"`
	// DocumentProcessingMode: Output only. The document processing mode for the
	// data store connection. Only set for PUBLIC_WEB and UNSTRUCTURED data stores.
	//
	// Possible values:
	//   "DOCUMENT_PROCESSING_MODE_UNSPECIFIED" - Not specified.
	//   "DOCUMENTS" - Documents are processed as documents.
	//   "CHUNKS" - Documents are converted to chunks.
	DocumentProcessingMode string `json:"documentProcessingMode,omitempty"`
	// Name: Required. Full resource name of the DataStore. Format:
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/
	// {dataStore}`
	Name string `json:"name,omitempty"`
	// Type: Output only. The type of the data store. This field is readonly and
	// populated by the server.
	//
	// Possible values:
	//   "DATA_STORE_TYPE_UNSPECIFIED" - Not specified. This value indicates that
	// the data store type is not specified, so it will not be used during search.
	//   "PUBLIC_WEB" - A data store that contains public web content.
	//   "UNSTRUCTURED" - A data store that contains unstructured private data.
	//   "FAQ" - A data store that contains structured data used as FAQ.
	//   "CONNECTOR" - A data store that is a connector to a first-party or a
	// third-party service.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConnectorConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConnectorConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DataStore) MarshalJSON() ([]byte, error) {
	type NoMethod DataStore
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DataStoreConnectorConfig: The connector config for the data store
// connection.
type DataStoreConnectorConfig struct {
	// Collection: Resource name of the collection the data store belongs to.
	Collection string `json:"collection,omitempty"`
	// CollectionDisplayName: Display name of the collection the data store belongs
	// to.
	CollectionDisplayName string `json:"collectionDisplayName,omitempty"`
	// DataSource: The name of the data source. Example: `salesforce`, `jira`,
	// `confluence`, `bigquery`.
	DataSource string `json:"dataSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Collection") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Collection") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DataStoreConnectorConfig) MarshalJSON() ([]byte, error) {
	type NoMethod DataStoreConnectorConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DataStoreSettings: Data store related settings for the app.
type DataStoreSettings struct {
	// Engines: Output only. The engines for the app.
	Engines []*DataStoreSettingsEngine `json:"engines,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Engines") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Engines") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DataStoreSettings) MarshalJSON() ([]byte, error) {
	type NoMethod DataStoreSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DataStoreSettingsEngine: An engine to which the data stores are connected.
// See Vertex AI Search:
// https://cloud.google.com/generative-ai-app-builder/docs/enterprise-search-introduction.
type DataStoreSettingsEngine struct {
	// Name: Output only. The resource name of the engine. Format:
	// `projects/{project}/locations/{location}/collections/{collection}/engines/{en
	// gine}`
	Name string `json:"name,omitempty"`
	// Type: Output only. The type of the engine.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unspecified engine type.
	//   "ENGINE_TYPE_SEARCH" - The SOLUTION_TYPE_SEARCH engine for the app. All
	// connector data stores added to the app will be added to this engine.
	//   "ENGINE_TYPE_CHAT" - Chat engine type. The SOLUTION_TYPE_CHAT engine for
	// the app. All connector data stores added to the app will be added to this
	// engine.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DataStoreSettingsEngine) MarshalJSON() ([]byte, error) {
	type NoMethod DataStoreSettingsEngine
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DataStoreTool: Tool to retrieve from Vertex AI Search datastore or engine
// for grounding. Accepts either a datastore or an engine, but not both. See
// Vertex AI Search:
// https://cloud.google.com/generative-ai-app-builder/docs/enterprise-search-introduction.
type DataStoreTool struct {
	// BoostSpecs: Optional. Boost specification to boost certain documents.
	BoostSpecs []*DataStoreToolBoostSpecs `json:"boostSpecs,omitempty"`
	// DataStoreSource: Optional. Search within a single specific DataStore.
	DataStoreSource *DataStoreToolDataStoreSource `json:"dataStoreSource,omitempty"`
	// Description: Optional. The tool description.
	Description string `json:"description,omitempty"`
	// EngineSource: Optional. Search within an Engine (potentially across multiple
	// DataStores).
	EngineSource *DataStoreToolEngineSource `json:"engineSource,omitempty"`
	// FilterParameterBehavior: Optional. The filter parameter behavior.
	//
	// Possible values:
	//   "FILTER_PARAMETER_BEHAVIOR_UNSPECIFIED" - Default filter behavior. Include
	// filter parameter for connector datastores. For the rest of the datastore
	// types, the filter input parameter is omitted.
	//   "ALWAYS_INCLUDE" - Always include filter parameter for all datastore
	// types.
	//   "NEVER_INCLUDE" - The filter parameter is never included in the list of
	// tool parameters, regardless of the datastore type.
	FilterParameterBehavior string `json:"filterParameterBehavior,omitempty"`
	// ModalityConfigs: Optional. The modality configs for the data store.
	ModalityConfigs []*DataStoreToolModalityConfig `json:"modalityConfigs,omitempty"`
	// Name: Required. The data store tool name.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoostSpecs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoostSpecs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DataStoreTool) MarshalJSON() ([]byte, error) {
	type NoMethod DataStoreTool
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DataStoreToolBoostSpec: Boost specification to boost certain documents.
type DataStoreToolBoostSpec struct {
	// ConditionBoostSpecs: Required. A list of boosting specifications.
	ConditionBoostSpecs []*DataStoreToolBoostSpecConditionBoostSpec `json:"conditionBoostSpecs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConditionBoostSpecs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConditionBoostSpecs") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DataStoreToolBoostSpec) MarshalJSON() ([]byte, error) {
	type NoMethod DataStoreToolBoostSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DataStoreToolBoostSpecConditionBoostSpec: Boost specification for a
// condition.
type DataStoreToolBoostSpecConditionBoostSpec struct {
	// Boost: Optional. Strength of the boost, which should be in [-1, 1]. Negative
	// boost means demotion. Default is 0.0. Setting to 1.0 gives the suggestions a
	// big promotion. However, it does not necessarily mean that the top result
	// will be a boosted suggestion. Setting to -1.0 gives the suggestions a big
	// demotion. However, other suggestions that are relevant might still be shown.
	// Setting to 0.0 means no boost applied. The boosting condition is ignored.
	Boost float64 `json:"boost,omitempty"`
	// BoostControlSpec: Optional. Complex specification for custom ranking based
	// on customer defined attribute value.
	BoostControlSpec *DataStoreToolBoostSpecConditionBoostSpecBoostControlSpec `json:"boostControlSpec,omitempty"`
	// Condition: Required. An expression which specifies a boost condition. The
	// syntax is the same as filter expression syntax. Currently, the only
	// supported condition is a list of BCP-47 lang codes. Example: To boost
	// suggestions in languages en or fr: (lang_code: ANY("en", "fr"))
	Condition string `json:"condition,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Boost") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Boost") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DataStoreToolBoostSpecConditionBoostSpec) MarshalJSON() ([]byte, error) {
	type NoMethod DataStoreToolBoostSpecConditionBoostSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *DataStoreToolBoostSpecConditionBoostSpec) UnmarshalJSON(data []byte) error {
	type NoMethod DataStoreToolBoostSpecConditionBoostSpec
	var s1 struct {
		Boost gensupport.JSONFloat64 `json:"boost"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Boost = float64(s1.Boost)
	return nil
}

// DataStoreToolBoostSpecConditionBoostSpecBoostControlSpec: Specification for
// custom ranking based on customer specified attribute value. It provides more
// controls for customized ranking than the simple (condition, boost)
// combination above.
type DataStoreToolBoostSpecConditionBoostSpecBoostControlSpec struct {
	// AttributeType: Optional. The attribute type to be used to determine the
	// boost amount. The attribute value can be derived from the field value of the
	// specified field_name. In the case of numerical it is straightforward i.e.
	// attribute_value = numerical_field_value. In the case of freshness however,
	// attribute_value = (time.now() - datetime_field_value).
	//
	// Possible values:
	//   "ATTRIBUTE_TYPE_UNSPECIFIED" - Unspecified AttributeType.
	//   "NUMERICAL" - The value of the numerical field will be used to dynamically
	// update the boost amount. In this case, the attribute_value (the x value) of
	// the control point will be the actual value of the numerical field for which
	// the boost_amount is specified.
	//   "FRESHNESS" - For the freshness use case the attribute value will be the
	// duration between the current time and the date in the datetime field
	// specified. The value must be formatted as an XSD `dayTimeDuration` value (a
	// restricted subset of an ISO 8601 duration value). The pattern for this is:
	// `nDnM]`. E.g. `5D`, `3DT12H30M`, `T24H`.
	AttributeType string `json:"attributeType,omitempty"`
	// ControlPoints: Optional. The control points used to define the curve. The
	// monotonic function (defined through the interpolation_type above) passes
	// through the control points listed here.
	ControlPoints []*DataStoreToolBoostSpecConditionBoostSpecBoostControlSpecControlPoint `json:"controlPoints,omitempty"`
	// FieldName: Optional. The name of the field whose value will be used to
	// determine the boost amount.
	FieldName string `json:"fieldName,omitempty"`
	// InterpolationType: Optional. The interpolation type to be applied to connect
	// the control points listed below.
	//
	// Possible values:
	//   "INTERPOLATION_TYPE_UNSPECIFIED" - Interpolation type is unspecified. In
	// this case, it defaults to Linear.
	//   "LINEAR" - Piecewise linear interpolation will be applied.
	InterpolationType string `json:"interpolationType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AttributeType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttributeType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DataStoreToolBoostSpecConditionBoostSpecBoostControlSpec) MarshalJSON() ([]byte, error) {
	type NoMethod DataStoreToolBoostSpecConditionBoostSpecBoostControlSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DataStoreToolBoostSpecConditionBoostSpecBoostControlSpecControlPoint: The
// control points used to define the curve. The curve defined through these
// control points can only be monotonically increasing or decreasing(constant
// values are acceptable).
type DataStoreToolBoostSpecConditionBoostSpecBoostControlSpecControlPoint struct {
	// AttributeValue: Optional. Can be one of: 1. The numerical field value. 2.
	// The duration spec for freshness: The value must be formatted as an XSD
	// `dayTimeDuration` value (a restricted subset of an ISO 8601 duration value).
	// The pattern for this is: `nDnM]`.
	AttributeValue string `json:"attributeValue,omitempty"`
	// BoostAmount: Optional. The value between -1 to 1 by which to boost the score
	// if the attribute_value evaluates to the value specified above.
	BoostAmount float64 `json:"boostAmount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AttributeValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttributeValue") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DataStoreToolBoostSpecConditionBoostSpecBoostControlSpecControlPoint) MarshalJSON() ([]byte, error) {
	type NoMethod DataStoreToolBoostSpecConditionBoostSpecBoostControlSpecControlPoint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *DataStoreToolBoostSpecConditionBoostSpecBoostControlSpecControlPoint) UnmarshalJSON(data []byte) error {
	type NoMethod DataStoreToolBoostSpecConditionBoostSpecBoostControlSpecControlPoint
	var s1 struct {
		BoostAmount gensupport.JSONFloat64 `json:"boostAmount"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.BoostAmount = float64(s1.BoostAmount)
	return nil
}

// DataStoreToolBoostSpecs: Boost specifications to boost certain documents.
// For more information, please refer to
// https://cloud.google.com/generative-ai-app-builder/docs/boosting.
type DataStoreToolBoostSpecs struct {
	// DataStores: Required. The Data Store where the boosting configuration is
	// applied. Full resource name of DataStore, such as
	// projects/{project}/locations/{location}/collections/{collection}/dataStores/{
	// dataStore}.
	DataStores []string `json:"dataStores,omitempty"`
	// Spec: Required. A list of boosting specifications.
	Spec []*DataStoreToolBoostSpec `json:"spec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStores") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStores") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DataStoreToolBoostSpecs) MarshalJSON() ([]byte, error) {
	type NoMethod DataStoreToolBoostSpecs
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DataStoreToolDataStoreSource: Configuration for searching within a specific
// DataStore.
type DataStoreToolDataStoreSource struct {
	// DataStore: Optional. The data store.
	DataStore *DataStore `json:"dataStore,omitempty"`
	// Filter: Optional. Filter specification for the DataStore. See:
	// https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata
	Filter string `json:"filter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DataStoreToolDataStoreSource) MarshalJSON() ([]byte, error) {
	type NoMethod DataStoreToolDataStoreSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DataStoreToolEngineSource: Configuration for searching within an Engine,
// potentially targeting specific DataStores.
type DataStoreToolEngineSource struct {
	// DataStoreSources: Optional. Use to target specific DataStores within the
	// Engine. If empty, the search applies to all DataStores associated with the
	// Engine.
	DataStoreSources []*DataStoreToolDataStoreSource `json:"dataStoreSources,omitempty"`
	// Engine: Required. Full resource name of the Engine. Format:
	// `projects/{project}/locations/{location}/collections/{collection}/engines/{en
	// gine}`
	Engine string `json:"engine,omitempty"`
	// Filter: Optional. A filter applied to the search across the Engine. Not
	// relevant and not used if 'data_store_sources' is provided. See:
	// https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata
	Filter string `json:"filter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStoreSources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStoreSources") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DataStoreToolEngineSource) MarshalJSON() ([]byte, error) {
	type NoMethod DataStoreToolEngineSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DataStoreToolGroundingConfig: Grounding configuration.
type DataStoreToolGroundingConfig struct {
	// Disabled: Optional. Whether grounding is disabled.
	Disabled bool `json:"disabled,omitempty"`
	// GroundingLevel: Optional. The groundedness threshold of the answer based on
	// the retrieved sources. The value has a configurable range of [1, 5]. The
	// level is used to threshold the groundedness of the answer, meaning that all
	// responses with a groundedness score below the threshold will fall back to
	// returning relevant snippets only. For example, a level of 3 means that the
	// groundedness score must be 3 or higher for the response to be returned.
	GroundingLevel float64 `json:"groundingLevel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Disabled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Disabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DataStoreToolGroundingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod DataStoreToolGroundingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *DataStoreToolGroundingConfig) UnmarshalJSON(data []byte) error {
	type NoMethod DataStoreToolGroundingConfig
	var s1 struct {
		GroundingLevel gensupport.JSONFloat64 `json:"groundingLevel"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.GroundingLevel = float64(s1.GroundingLevel)
	return nil
}

// DataStoreToolModalityConfig: If specified, will apply the given
// configuration for the specified modality.
type DataStoreToolModalityConfig struct {
	// GroundingConfig: Optional. The grounding configuration.
	GroundingConfig *DataStoreToolGroundingConfig `json:"groundingConfig,omitempty"`
	// ModalityType: Required. The modality type.
	//
	// Possible values:
	//   "MODALITY_TYPE_UNSPECIFIED" - Unspecified modality type.
	//   "TEXT" - Text modality.
	//   "AUDIO" - Audio modality.
	ModalityType string `json:"modalityType,omitempty"`
	// RewriterConfig: Optional. The rewriter config.
	RewriterConfig *DataStoreToolRewriterConfig `json:"rewriterConfig,omitempty"`
	// SummarizationConfig: Optional. The summarization config.
	SummarizationConfig *DataStoreToolSummarizationConfig `json:"summarizationConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GroundingConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GroundingConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DataStoreToolModalityConfig) MarshalJSON() ([]byte, error) {
	type NoMethod DataStoreToolModalityConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DataStoreToolRewriterConfig: Rewriter configuration.
type DataStoreToolRewriterConfig struct {
	// Disabled: Optional. Whether the rewriter is disabled.
	Disabled bool `json:"disabled,omitempty"`
	// ModelSettings: Required. Configurations for the LLM model.
	ModelSettings *ModelSettings `json:"modelSettings,omitempty"`
	// Prompt: Optional. The prompt definition. If not set, default prompt will be
	// used.
	Prompt string `json:"prompt,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Disabled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Disabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DataStoreToolRewriterConfig) MarshalJSON() ([]byte, error) {
	type NoMethod DataStoreToolRewriterConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DataStoreToolSummarizationConfig: Summarization configuration.
type DataStoreToolSummarizationConfig struct {
	// Disabled: Optional. Whether summarization is disabled.
	Disabled bool `json:"disabled,omitempty"`
	// ModelSettings: Optional. Configurations for the LLM model.
	ModelSettings *ModelSettings `json:"modelSettings,omitempty"`
	// Prompt: Optional. The prompt definition. If not set, default prompt will be
	// used.
	Prompt string `json:"prompt,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Disabled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Disabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DataStoreToolSummarizationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod DataStoreToolSummarizationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Deployment: A deployment represents an immutable, queryable version of the
// app. It is used to deploy an app version with a specific channel profile.
type Deployment struct {
	// AppVersion: Required. The resource name of the app version to deploy.
	// Format:
	// projects/{project}/locations/{location}/apps/{app}/versions/{version}
	AppVersion string `json:"appVersion,omitempty"`
	// ChannelProfile: Required. The channel profile used in the deployment.
	ChannelProfile *ChannelProfile `json:"channelProfile,omitempty"`
	// CreateTime: Output only. Timestamp when this deployment was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Required. Display name of the deployment.
	DisplayName string `json:"displayName,omitempty"`
	// Etag: Output only. Etag used to ensure the object hasn't changed during a
	// read-modify-write operation. If the etag is empty, the update will overwrite
	// any concurrent changes.
	Etag string `json:"etag,omitempty"`
	// Name: Identifier. The resource name of the deployment. Format:
	// projects/{project}/locations/{location}/apps/{app}/deployments/{deployment}
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. Timestamp when this deployment was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AppVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AppVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Deployment) MarshalJSON() ([]byte, error) {
	type NoMethod Deployment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use it as
// the request or the response type of an API method. For instance: service Foo
// { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// EndSession: Indicates the session has terminated, due to either successful
// completion (e.g. user says "Good bye!" ) or an agent escalation. The agent
// will not process any further inputs after session is terminated and the
// client should half-close and disconnect after receiving all remaining
// responses from the agent.
type EndSession struct {
	// Metadata: Optional. Provides additional information about the end session
	// signal, such as the reason for ending the session.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EndSession) MarshalJSON() ([]byte, error) {
	type NoMethod EndSession
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EndUserAuthConfig: End-user authentication configuration used for Connection
// calls. The field values must be the names of context variables in the format
// `$context.variables.`.
type EndUserAuthConfig struct {
	// Oauth2AuthCodeConfig: Oauth 2.0 Authorization Code authentication.
	Oauth2AuthCodeConfig *EndUserAuthConfigOauth2AuthCodeConfig `json:"oauth2AuthCodeConfig,omitempty"`
	// Oauth2JwtBearerConfig: JWT Profile Oauth 2.0 Authorization Grant
	// authentication.
	Oauth2JwtBearerConfig *EndUserAuthConfigOauth2JwtBearerConfig `json:"oauth2JwtBearerConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Oauth2AuthCodeConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Oauth2AuthCodeConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EndUserAuthConfig) MarshalJSON() ([]byte, error) {
	type NoMethod EndUserAuthConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EndUserAuthConfigOauth2AuthCodeConfig: Oauth 2.0 Authorization Code
// authentication configuration.
type EndUserAuthConfigOauth2AuthCodeConfig struct {
	// OauthToken: Required. Oauth token parameter name to pass through. Must be in
	// the format `$context.variables.`.
	OauthToken string `json:"oauthToken,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OauthToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OauthToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EndUserAuthConfigOauth2AuthCodeConfig) MarshalJSON() ([]byte, error) {
	type NoMethod EndUserAuthConfigOauth2AuthCodeConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EndUserAuthConfigOauth2JwtBearerConfig: JWT Profile Oauth 2.0 Authorization
// Grant authentication configuration.
type EndUserAuthConfigOauth2JwtBearerConfig struct {
	// ClientKey: Required. Client parameter name to pass through. Must be in the
	// format `$context.variables.`.
	ClientKey string `json:"clientKey,omitempty"`
	// Issuer: Required. Issuer parameter name to pass through. Must be in the
	// format `$context.variables.`.
	Issuer string `json:"issuer,omitempty"`
	// Subject: Required. Subject parameter name to pass through. Must be in the
	// format `$context.variables.`.
	Subject string `json:"subject,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClientKey") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClientKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EndUserAuthConfigOauth2JwtBearerConfig) MarshalJSON() ([]byte, error) {
	type NoMethod EndUserAuthConfigOauth2JwtBearerConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EvaluationMetricsThresholds: Threshold settings for metrics in an
// Evaluation.
type EvaluationMetricsThresholds struct {
	// GoldenEvaluationMetricsThresholds: Optional. The golden evaluation metrics
	// thresholds.
	GoldenEvaluationMetricsThresholds *EvaluationMetricsThresholdsGoldenEvaluationMetricsThresholds `json:"goldenEvaluationMetricsThresholds,omitempty"`
	// GoldenHallucinationMetricBehavior: Optional. The hallucination metric
	// behavior for golden evaluations.
	//
	// Possible values:
	//   "HALLUCINATION_METRIC_BEHAVIOR_UNSPECIFIED" - Unspecified hallucination
	// metric behavior.
	//   "DISABLED" - Disable hallucination metric.
	//   "ENABLED" - Enable hallucination metric.
	GoldenHallucinationMetricBehavior string `json:"goldenHallucinationMetricBehavior,omitempty"`
	// HallucinationMetricBehavior: Optional. Deprecated: Use
	// `golden_hallucination_metric_behavior` instead. The hallucination metric
	// behavior is currently used for golden evaluations.
	//
	// Possible values:
	//   "HALLUCINATION_METRIC_BEHAVIOR_UNSPECIFIED" - Unspecified hallucination
	// metric behavior.
	//   "DISABLED" - Disable hallucination metric.
	//   "ENABLED" - Enable hallucination metric.
	HallucinationMetricBehavior string `json:"hallucinationMetricBehavior,omitempty"`
	// ScenarioHallucinationMetricBehavior: Optional. The hallucination metric
	// behavior for scenario evaluations.
	//
	// Possible values:
	//   "HALLUCINATION_METRIC_BEHAVIOR_UNSPECIFIED" - Unspecified hallucination
	// metric behavior.
	//   "DISABLED" - Disable hallucination metric.
	//   "ENABLED" - Enable hallucination metric.
	ScenarioHallucinationMetricBehavior string `json:"scenarioHallucinationMetricBehavior,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "GoldenEvaluationMetricsThresholds") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "GoldenEvaluationMetricsThresholds") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields for
	// more details.
	NullFields []string `json:"-"`
}

func (s EvaluationMetricsThresholds) MarshalJSON() ([]byte, error) {
	type NoMethod EvaluationMetricsThresholds
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EvaluationMetricsThresholdsGoldenEvaluationMetricsThresholds: Settings for
// golden evaluations.
type EvaluationMetricsThresholdsGoldenEvaluationMetricsThresholds struct {
	// ExpectationLevelMetricsThresholds: Optional. The expectation level metrics
	// thresholds.
	ExpectationLevelMetricsThresholds *EvaluationMetricsThresholdsGoldenEvaluationMetricsThresholdsExpectationLevelMetricsThresholds `json:"expectationLevelMetricsThresholds,omitempty"`
	// TurnLevelMetricsThresholds: Optional. The turn level metrics thresholds.
	TurnLevelMetricsThresholds *EvaluationMetricsThresholdsGoldenEvaluationMetricsThresholdsTurnLevelMetricsThresholds `json:"turnLevelMetricsThresholds,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "ExpectationLevelMetricsThresholds") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "ExpectationLevelMetricsThresholds") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields for
	// more details.
	NullFields []string `json:"-"`
}

func (s EvaluationMetricsThresholdsGoldenEvaluationMetricsThresholds) MarshalJSON() ([]byte, error) {
	type NoMethod EvaluationMetricsThresholdsGoldenEvaluationMetricsThresholds
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EvaluationMetricsThresholdsGoldenEvaluationMetricsThresholdsExpectationLevelM
// etricsThresholds: Expectation level metrics thresholds.
type EvaluationMetricsThresholdsGoldenEvaluationMetricsThresholdsExpectationLevelMetricsThresholds struct {
	// ToolInvocationParameterCorrectnessThreshold: Optional. The success threshold
	// for individual tool invocation parameter correctness. Must be a float
	// between 0 and 1. Default is 1.0.
	ToolInvocationParameterCorrectnessThreshold float64 `json:"toolInvocationParameterCorrectnessThreshold,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "ToolInvocationParameterCorrectnessThreshold") to unconditionally include in
	// API requests. By default, fields with empty or default values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "ToolInvocationParameterCorrectnessThreshold") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EvaluationMetricsThresholdsGoldenEvaluationMetricsThresholdsExpectationLevelMetricsThresholds) MarshalJSON() ([]byte, error) {
	type NoMethod EvaluationMetricsThresholdsGoldenEvaluationMetricsThresholdsExpectationLevelMetricsThresholds
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *EvaluationMetricsThresholdsGoldenEvaluationMetricsThresholdsExpectationLevelMetricsThresholds) UnmarshalJSON(data []byte) error {
	type NoMethod EvaluationMetricsThresholdsGoldenEvaluationMetricsThresholdsExpectationLevelMetricsThresholds
	var s1 struct {
		ToolInvocationParameterCorrectnessThreshold gensupport.JSONFloat64 `json:"toolInvocationParameterCorrectnessThreshold"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ToolInvocationParameterCorrectnessThreshold = float64(s1.ToolInvocationParameterCorrectnessThreshold)
	return nil
}

// EvaluationMetricsThresholdsGoldenEvaluationMetricsThresholdsTurnLevelMetricsT
// hresholds: Turn level metrics thresholds.
type EvaluationMetricsThresholdsGoldenEvaluationMetricsThresholdsTurnLevelMetricsThresholds struct {
	// OverallToolInvocationCorrectnessThreshold: Optional. The success threshold
	// for overall tool invocation correctness. Must be a float between 0 and 1.
	// Default is 1.0.
	OverallToolInvocationCorrectnessThreshold float64 `json:"overallToolInvocationCorrectnessThreshold,omitempty"`
	// SemanticSimilarityChannel: Optional. The semantic similarity channel to use
	// for evaluation.
	//
	// Possible values:
	//   "SEMANTIC_SIMILARITY_CHANNEL_UNSPECIFIED" - Metric unspecified. Defaults
	// to TEXT.
	//   "TEXT" - Use text semantic similarity.
	//   "AUDIO" - Use audio semantic similarity.
	SemanticSimilarityChannel string `json:"semanticSimilarityChannel,omitempty"`
	// SemanticSimilaritySuccessThreshold: Optional. The success threshold for
	// semantic similarity. Must be an integer between 0 and 4. Default is >= 3.
	SemanticSimilaritySuccessThreshold int64 `json:"semanticSimilaritySuccessThreshold,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "OverallToolInvocationCorrectnessThreshold") to unconditionally include in
	// API requests. By default, fields with empty or default values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "OverallToolInvocationCorrectnessThreshold") to include in API requests with
	// the JSON null value. By default, fields with empty values are omitted from
	// API requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields
	// for more details.
	NullFields []string `json:"-"`
}

func (s EvaluationMetricsThresholdsGoldenEvaluationMetricsThresholdsTurnLevelMetricsThresholds) MarshalJSON() ([]byte, error) {
	type NoMethod EvaluationMetricsThresholdsGoldenEvaluationMetricsThresholdsTurnLevelMetricsThresholds
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *EvaluationMetricsThresholdsGoldenEvaluationMetricsThresholdsTurnLevelMetricsThresholds) UnmarshalJSON(data []byte) error {
	type NoMethod EvaluationMetricsThresholdsGoldenEvaluationMetricsThresholdsTurnLevelMetricsThresholds
	var s1 struct {
		OverallToolInvocationCorrectnessThreshold gensupport.JSONFloat64 `json:"overallToolInvocationCorrectnessThreshold"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.OverallToolInvocationCorrectnessThreshold = float64(s1.OverallToolInvocationCorrectnessThreshold)
	return nil
}

// Event: Event input.
type Event struct {
	// Event: Required. The name of the event.
	Event string `json:"event,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Event") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Event") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Event) MarshalJSON() ([]byte, error) {
	type NoMethod Event
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Example: An example represents a sample conversation between the user and
// the agent(s).
type Example struct {
	// CreateTime: Output only. Timestamp when the example was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. Human-readable description of the example.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. Display name of the example.
	DisplayName string `json:"displayName,omitempty"`
	// EntryAgent: Optional. The agent that initially handles the conversation. If
	// not specified, the example represents a conversation that is handled by the
	// root agent. Format:
	// `projects/{project}/locations/{location}/apps/{app}/agents/{agent}`
	EntryAgent string `json:"entryAgent,omitempty"`
	// Etag: Etag used to ensure the object hasn't changed during a
	// read-modify-write operation. If the etag is empty, the update will overwrite
	// any concurrent changes.
	Etag string `json:"etag,omitempty"`
	// Invalid: Output only. The example may become invalid if referencing
	// resources are deleted. Invalid examples will not be used as few-shot
	// examples.
	Invalid bool `json:"invalid,omitempty"`
	// Messages: Optional. The collection of messages that make up the
	// conversation.
	Messages []*Message `json:"messages,omitempty"`
	// Name: Identifier. The unique identifier of the example. Format:
	// `projects/{project}/locations/{location}/apps/{app}/examples/{example}`
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. Timestamp when the example was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Example) MarshalJSON() ([]byte, error) {
	type NoMethod Example
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExecuteToolRequest: Request message for ToolService.ExecuteTool.
type ExecuteToolRequest struct {
	// Args: Optional. The input parameters and values for the tool in JSON object
	// format.
	Args googleapi.RawMessage `json:"args,omitempty"`
	// Tool: Optional. The name of the tool to execute. Format:
	// projects/{project}/locations/{location}/apps/{app}/tools/{tool}
	Tool string `json:"tool,omitempty"`
	// ToolsetTool: Optional. The toolset tool to execute. Only one tool should
	// match the predicate from the toolset. Otherwise, an error will be returned.
	ToolsetTool *ToolsetTool `json:"toolsetTool,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Args") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Args") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExecuteToolRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ExecuteToolRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExecuteToolResponse: Response message for ToolService.ExecuteTool.
type ExecuteToolResponse struct {
	// Response: Required. The tool execution result in JSON object format. Use
	// "output" key to specify tool response and "error" key to specify error
	// details (if any). If "output" and "error" keys are not specified, then whole
	// "response" is treated as tool execution result.
	Response googleapi.RawMessage `json:"response,omitempty"`
	// Tool: The name of the tool that got executed. Format:
	// `projects/{project}/locations/{location}/apps/{app}/tools/{tool}`
	Tool string `json:"tool,omitempty"`
	// ToolsetTool: The toolset tool that got executed.
	ToolsetTool *ToolsetTool `json:"toolsetTool,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Response") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Response") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExecuteToolResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ExecuteToolResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExportAppRequest: Request message for AgentService.ExportApp.
type ExportAppRequest struct {
	// ExportFormat: Required. The format to export the app in.
	//
	// Possible values:
	//   "EXPORT_FORMAT_UNSPECIFIED" - The export format is unspecified.
	//   "JSON" - The export format is JSON.
	//   "YAML" - The export format is YAML.
	ExportFormat string `json:"exportFormat,omitempty"`
	// GcsUri: Optional. The Google Cloud Storage
	// (https://cloud.google.com/storage/docs/) URI to which to export the app. The
	// format of this URI must be `gs:///`. The exported app archive will be
	// written directly to the specified GCS object.
	GcsUri string `json:"gcsUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExportFormat") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExportFormat") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExportAppRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ExportAppRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExportAppResponse: Response message for AgentService.ExportApp.
type ExportAppResponse struct {
	// AppContent: App folder compressed as a zip file.
	AppContent string `json:"appContent,omitempty"`
	// AppUri: The Google Cloud Storage (https://cloud.google.com/storage/docs/)
	// URI to which the app was exported.
	AppUri string `json:"appUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AppContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AppContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExportAppResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ExportAppResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExpressionCondition: Expression condition based on session state.
type ExpressionCondition struct {
	// Expression: Required. The string representation of cloud.api.Expression
	// condition.
	Expression string `json:"expression,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Expression") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Expression") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExpressionCondition) MarshalJSON() ([]byte, error) {
	type NoMethod ExpressionCondition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FileSearchTool: The file search tool allows the agent to search across the
// files uploaded by the app/agent developer. It has presets to give relatively
// good quality search over the uploaded files and summarization of the
// retrieved results.
type FileSearchTool struct {
	// CorpusType: Optional. The type of the corpus. Default is FULLY_MANAGED.
	//
	// Possible values:
	//   "CORPUS_TYPE_UNSPECIFIED" - Unspecified corpus type.
	//   "USER_OWNED" - The corpus is created and owned by the user.
	//   "FULLY_MANAGED" - The corpus is created by the agent.
	CorpusType string `json:"corpusType,omitempty"`
	// Description: Optional. The tool description.
	Description string `json:"description,omitempty"`
	// FileCorpus: Optional. The corpus where files are stored. Format:
	// projects/{project}/locations/{location}/ragCorpora/{rag_corpus}
	FileCorpus string `json:"fileCorpus,omitempty"`
	// Name: Required. The tool name.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CorpusType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CorpusType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FileSearchTool) MarshalJSON() ([]byte, error) {
	type NoMethod FileSearchTool
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GenerateChatTokenRequest: Request message for
// WidgetService.GenerateChatToken.
type GenerateChatTokenRequest struct {
	// Deployment: Required. The deployment of the app to use for the session.
	// Format:
	// projects/{project}/locations/{location}/apps/{app}/deployments/{deployment}
	Deployment string `json:"deployment,omitempty"`
	// RecaptchaToken: Optional. The reCAPTCHA token generated by the client-side
	// chat widget.
	RecaptchaToken string `json:"recaptchaToken,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Deployment") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Deployment") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GenerateChatTokenRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GenerateChatTokenRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GenerateChatTokenResponse: Response message for
// WidgetService.GenerateChatToken.
type GenerateChatTokenResponse struct {
	// ChatToken: The session scoped token for chat widget to authenticate with
	// Session APIs.
	ChatToken string `json:"chatToken,omitempty"`
	// ExpireTime: The time at which the chat token expires.
	ExpireTime string `json:"expireTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ChatToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChatToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GenerateChatTokenResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GenerateChatTokenResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleSearchSuggestions: Search suggestions from Google Search Tool.
type GoogleSearchSuggestions struct {
	// Htmls: Compliant HTML and CSS styling for search suggestions. The provided
	// HTML and CSS automatically adapts to your device settings, displaying in
	// either light or dark mode indicated by `@media(prefers-color-scheme)`.
	Htmls []string `json:"htmls,omitempty"`
	// WebSearchQueries: List of queries used to perform the google search along
	// with the search result URIs forming the search suggestions.
	WebSearchQueries []*WebSearchQuery `json:"webSearchQueries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Htmls") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Htmls") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleSearchSuggestions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleSearchSuggestions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleSearchTool: Represents a tool to perform Google web searches for
// grounding. See
// https://cloud.google.com/customer-engagement-ai/conversational-agents/ps/tool#google-search.
type GoogleSearchTool struct {
	// ContextUrls: Optional. Content will be fetched directly from these URLs for
	// context and grounding. Example: "https://example.com/path.html". A maximum
	// of 20 URLs are allowed.
	ContextUrls []string `json:"contextUrls,omitempty"`
	// Description: Optional. Description of the tool's purpose.
	Description string `json:"description,omitempty"`
	// ExcludeDomains: Optional. List of domains to be excluded from the search
	// results. Example: "example.com". A maximum of 2000 domains can be excluded.
	ExcludeDomains []string `json:"excludeDomains,omitempty"`
	// Name: Required. The name of the tool.
	Name string `json:"name,omitempty"`
	// PreferredDomains: Optional. Specifies domains to restrict search results to.
	// Example: "example.com", "another.site". A maximum of 20 domains can be
	// specified.
	PreferredDomains []string `json:"preferredDomains,omitempty"`
	// PromptConfig: Optional. Prompt instructions passed to planner on how the
	// search results should be processed for text and voice.
	PromptConfig *GoogleSearchToolPromptConfig `json:"promptConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContextUrls") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextUrls") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleSearchTool) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleSearchTool
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleSearchToolPromptConfig: Prompt settings used by the model when
// processing or summarizing the google search results.
type GoogleSearchToolPromptConfig struct {
	// TextPrompt: Optional. Defines the prompt used for the system instructions
	// when interacting with the agent in chat conversations. If not set, default
	// prompt will be used.
	TextPrompt string `json:"textPrompt,omitempty"`
	// VoicePrompt: Optional. Defines the prompt used for the system instructions
	// when interacting with the agent in voice conversations. If not set, default
	// prompt will be used.
	VoicePrompt string `json:"voicePrompt,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TextPrompt") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TextPrompt") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleSearchToolPromptConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleSearchToolPromptConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Guardrail: Guardrail contains a list of checks and balances to keep the
// agents safe and secure.
type Guardrail struct {
	// Action: Optional. Action to take when the guardrail is triggered.
	Action *TriggerAction `json:"action,omitempty"`
	// CodeCallback: Optional. Guardrail that potentially blocks the conversation
	// based on the result of the callback execution.
	CodeCallback *GuardrailCodeCallback `json:"codeCallback,omitempty"`
	// ContentFilter: Optional. Guardrail that bans certain content from being used
	// in the conversation.
	ContentFilter *GuardrailContentFilter `json:"contentFilter,omitempty"`
	// CreateTime: Output only. Timestamp when the guardrail was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. Description of the guardrail.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. Display name of the guardrail.
	DisplayName string `json:"displayName,omitempty"`
	// Enabled: Optional. Whether the guardrail is enabled.
	Enabled bool `json:"enabled,omitempty"`
	// Etag: Etag used to ensure the object hasn't changed during a
	// read-modify-write operation. If the etag is empty, the update will overwrite
	// any concurrent changes.
	Etag string `json:"etag,omitempty"`
	// LlmPolicy: Optional. Guardrail that blocks the conversation if the LLM
	// response is considered violating the policy based on the LLM classification.
	LlmPolicy *GuardrailLlmPolicy `json:"llmPolicy,omitempty"`
	// LlmPromptSecurity: Optional. Guardrail that blocks the conversation if the
	// prompt is considered unsafe based on the LLM classification.
	LlmPromptSecurity *GuardrailLlmPromptSecurity `json:"llmPromptSecurity,omitempty"`
	// ModelSafety: Optional. Guardrail that blocks the conversation if the LLM
	// response is considered unsafe based on the model safety settings.
	ModelSafety *GuardrailModelSafety `json:"modelSafety,omitempty"`
	// Name: Identifier. The unique identifier of the guardrail. Format:
	// `projects/{project}/locations/{location}/apps/{app}/guardrails/{guardrail}`
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. Timestamp when the guardrail was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Guardrail) MarshalJSON() ([]byte, error) {
	type NoMethod Guardrail
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GuardrailCodeCallback: Guardrail that blocks the conversation based on the
// code callbacks provided.
type GuardrailCodeCallback struct {
	// AfterAgentCallback: Optional. The callback to execute after the agent is
	// called. Each callback function is expected to return a structure (e.g., a
	// dict or object) containing at least: - 'decision': Either 'OK' or 'TRIGGER'.
	// - 'reason': A string explaining the decision. A 'TRIGGER' decision may halt
	// further processing.
	AfterAgentCallback *Callback `json:"afterAgentCallback,omitempty"`
	// AfterModelCallback: Optional. The callback to execute after the model is
	// called. If there are multiple calls to the model, the callback will be
	// executed multiple times. Each callback function is expected to return a
	// structure (e.g., a dict or object) containing at least: - 'decision': Either
	// 'OK' or 'TRIGGER'. - 'reason': A string explaining the decision. A 'TRIGGER'
	// decision may halt further processing.
	AfterModelCallback *Callback `json:"afterModelCallback,omitempty"`
	// BeforeAgentCallback: Optional. The callback to execute before the agent is
	// called. Each callback function is expected to return a structure (e.g., a
	// dict or object) containing at least: - 'decision': Either 'OK' or 'TRIGGER'.
	// - 'reason': A string explaining the decision. A 'TRIGGER' decision may halt
	// further processing.
	BeforeAgentCallback *Callback `json:"beforeAgentCallback,omitempty"`
	// BeforeModelCallback: Optional. The callback to execute before the model is
	// called. If there are multiple calls to the model, the callback will be
	// executed multiple times. Each callback function is expected to return a
	// structure (e.g., a dict or object) containing at least: - 'decision': Either
	// 'OK' or 'TRIGGER'. - 'reason': A string explaining the decision. A 'TRIGGER'
	// decision may halt further processing.
	BeforeModelCallback *Callback `json:"beforeModelCallback,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AfterAgentCallback") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AfterAgentCallback") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GuardrailCodeCallback) MarshalJSON() ([]byte, error) {
	type NoMethod GuardrailCodeCallback
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GuardrailContentFilter: Guardrail that bans certain content from being used
// in the conversation.
type GuardrailContentFilter struct {
	// BannedContents: Optional. List of banned phrases. Applies to both user
	// inputs and agent responses.
	BannedContents []string `json:"bannedContents,omitempty"`
	// BannedContentsInAgentResponse: Optional. List of banned phrases. Applies
	// only to agent responses.
	BannedContentsInAgentResponse []string `json:"bannedContentsInAgentResponse,omitempty"`
	// BannedContentsInUserInput: Optional. List of banned phrases. Applies only to
	// user inputs.
	BannedContentsInUserInput []string `json:"bannedContentsInUserInput,omitempty"`
	// DisregardDiacritics: Optional. If true, diacritics are ignored during
	// matching.
	DisregardDiacritics bool `json:"disregardDiacritics,omitempty"`
	// MatchType: Required. Match type for the content filter.
	//
	// Possible values:
	//   "MATCH_TYPE_UNSPECIFIED" - Match type is not specified.
	//   "SIMPLE_STRING_MATCH" - Content is matched for substrings character by
	// character.
	//   "WORD_BOUNDARY_STRING_MATCH" - Content only matches if the pattern found
	// in the text is surrounded by word delimiters. Banned phrases can also
	// contain word delimiters.
	//   "REGEXP_MATCH" - Content is matched using regular expression syntax.
	MatchType string `json:"matchType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BannedContents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BannedContents") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GuardrailContentFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GuardrailContentFilter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GuardrailLlmPolicy: Guardrail that blocks the conversation if the LLM
// response is considered violating the policy based on the LLM classification.
type GuardrailLlmPolicy struct {
	// AllowShortUtterance: Optional. By default, the LLM policy check is bypassed
	// for short utterances. Enabling this setting applies the policy check to all
	// utterances, including those that would normally be skipped.
	AllowShortUtterance bool `json:"allowShortUtterance,omitempty"`
	// FailOpen: Optional. If an error occurs during the policy check, fail open
	// and do not trigger the guardrail.
	FailOpen bool `json:"failOpen,omitempty"`
	// MaxConversationMessages: Optional. When checking this policy, consider the
	// last 'n' messages in the conversation. When not set a default value of 10
	// will be used.
	MaxConversationMessages int64 `json:"maxConversationMessages,omitempty"`
	// ModelSettings: Optional. Model settings.
	ModelSettings *ModelSettings `json:"modelSettings,omitempty"`
	// PolicyScope: Required. Defines when to apply the policy check during the
	// conversation. If set to `POLICY_SCOPE_UNSPECIFIED`, the policy will be
	// applied to the user input. When applying the policy to the agent response,
	// additional latency will be introduced before the agent can respond.
	//
	// Possible values:
	//   "POLICY_SCOPE_UNSPECIFIED" - Policy scope is not specified.
	//   "USER_QUERY" - Policy check is triggered on user input.
	//   "AGENT_RESPONSE" - Policy check is triggered on agent response. Applying
	// this policy scope will introduce additional latency before the agent can
	// respond.
	//   "USER_QUERY_AND_AGENT_RESPONSE" - Policy check is triggered on both user
	// input and agent response. Applying this policy scope will introduce
	// additional latency before the agent can respond.
	PolicyScope string `json:"policyScope,omitempty"`
	// Prompt: Required. Policy prompt.
	Prompt string `json:"prompt,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowShortUtterance") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowShortUtterance") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GuardrailLlmPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod GuardrailLlmPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GuardrailLlmPromptSecurity: Guardrail that blocks the conversation if the
// input is considered unsafe based on the LLM classification.
type GuardrailLlmPromptSecurity struct {
	// CustomPolicy: Optional. Use a user-defined LlmPolicy to configure the
	// security guardrail.
	CustomPolicy *GuardrailLlmPolicy `json:"customPolicy,omitempty"`
	// DefaultSettings: Optional. Use the system's predefined default security
	// settings. To select this mode, include an empty 'default_settings' message
	// in the request. The 'default_prompt_template' field within will be populated
	// by the server in the response.
	DefaultSettings *GuardrailLlmPromptSecurityDefaultSecuritySettings `json:"defaultSettings,omitempty"`
	// FailOpen: Optional. Determines the behavior when the guardrail encounters an
	// LLM error. - If true: the guardrail is bypassed. - If false (default): the
	// guardrail triggers/blocks. Note: If a custom policy is provided, this field
	// is ignored in favor of the policy's 'fail_open' configuration.
	FailOpen bool `json:"failOpen,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CustomPolicy") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CustomPolicy") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GuardrailLlmPromptSecurity) MarshalJSON() ([]byte, error) {
	type NoMethod GuardrailLlmPromptSecurity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GuardrailLlmPromptSecurityDefaultSecuritySettings: Configuration for default
// system security settings.
type GuardrailLlmPromptSecurityDefaultSecuritySettings struct {
	// DefaultPromptTemplate: Output only. The default prompt template used by the
	// system. This field is for display purposes to show the user what prompt the
	// system uses by default. It is OUTPUT_ONLY.
	DefaultPromptTemplate string `json:"defaultPromptTemplate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DefaultPromptTemplate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DefaultPromptTemplate") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GuardrailLlmPromptSecurityDefaultSecuritySettings) MarshalJSON() ([]byte, error) {
	type NoMethod GuardrailLlmPromptSecurityDefaultSecuritySettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GuardrailModelSafety: Model safety settings overrides. When this is set, it
// will override the default settings and trigger the guardrail if the response
// is considered unsafe.
type GuardrailModelSafety struct {
	// SafetySettings: Required. List of safety settings.
	SafetySettings []*GuardrailModelSafetySafetySetting `json:"safetySettings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SafetySettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SafetySettings") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GuardrailModelSafety) MarshalJSON() ([]byte, error) {
	type NoMethod GuardrailModelSafety
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GuardrailModelSafetySafetySetting: Safety setting.
type GuardrailModelSafetySafetySetting struct {
	// Category: Required. The harm category.
	//
	// Possible values:
	//   "HARM_CATEGORY_UNSPECIFIED" - The harm category is unspecified.
	//   "HARM_CATEGORY_HATE_SPEECH" - The harm category is hate speech.
	//   "HARM_CATEGORY_DANGEROUS_CONTENT" - The harm category is dangerous
	// content.
	//   "HARM_CATEGORY_HARASSMENT" - The harm category is harassment.
	//   "HARM_CATEGORY_SEXUALLY_EXPLICIT" - The harm category is sexually explicit
	// content.
	Category string `json:"category,omitempty"`
	// Threshold: Required. The harm block threshold.
	//
	// Possible values:
	//   "HARM_BLOCK_THRESHOLD_UNSPECIFIED" - Unspecified harm block threshold.
	//   "BLOCK_LOW_AND_ABOVE" - Block low threshold and above (i.e. block more).
	//   "BLOCK_MEDIUM_AND_ABOVE" - Block medium threshold and above.
	//   "BLOCK_ONLY_HIGH" - Block only high threshold (i.e. block less).
	//   "BLOCK_NONE" - Block none.
	//   "OFF" - Turn off the safety filter.
	Threshold string `json:"threshold,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Category") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Category") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GuardrailModelSafetySafetySetting) MarshalJSON() ([]byte, error) {
	type NoMethod GuardrailModelSafetySafetySetting
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Image: Represents an image input or output in the conversation.
type Image struct {
	// Data: Required. Raw bytes of the image.
	Data string `json:"data,omitempty"`
	// MimeType: Required. The IANA standard MIME type of the source data.
	// Supported image types includes: * image/png * image/jpeg * image/webp
	MimeType string `json:"mimeType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Data") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Data") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Image) MarshalJSON() ([]byte, error) {
	type NoMethod Image
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ImportAppRequest: Request message for AgentService.ImportApp.
type ImportAppRequest struct {
	// AppContent: Raw bytes representing the compressed zip file with the app
	// folder structure.
	AppContent string `json:"appContent,omitempty"`
	// AppId: Optional. The ID to use for the imported app. * If not specified, a
	// unique ID will be automatically assigned for the app. * Otherwise, the
	// imported app will use this ID as the final component of its resource name.
	// If an app with the same ID already exists at the specified location in the
	// project, the content of the existing app will be replaced.
	AppId string `json:"appId,omitempty"`
	// DisplayName: Optional. The display name of the app to import. * If the app
	// is created on import, and the display name is specified, the imported app
	// will use this display name. If a conflict is detected with an existing app,
	// a timestamp will be appended to the display name to make it unique. * If the
	// app is a reimport, this field should not be set. Providing a display name
	// during reimport will result in an INVALID_ARGUMENT error.
	DisplayName string `json:"displayName,omitempty"`
	// GcsUri: The Google Cloud Storage (https://cloud.google.com/storage/docs/)
	// URI from which to import app. The format of this URI must be `gs:///`.
	GcsUri string `json:"gcsUri,omitempty"`
	// IgnoreAppLock: Optional. Flag for overriding the app lock during import. If
	// set to true, the import process will ignore the app lock.
	IgnoreAppLock bool `json:"ignoreAppLock,omitempty"`
	// ImportOptions: Optional. Options governing the import process for the app.
	ImportOptions *ImportAppRequestImportOptions `json:"importOptions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AppContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AppContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ImportAppRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ImportAppRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ImportAppRequestImportOptions: Configuration options for the app import
// process. These options control how the import behaves, particularly when
// conflicts arise with existing app data.
type ImportAppRequestImportOptions struct {
	// ConflictResolutionStrategy: Optional. The strategy to use when resolving
	// conflicts during import.
	//
	// Possible values:
	//   "CONFLICT_RESOLUTION_STRATEGY_UNSPECIFIED" - The conflict resolution
	// strategy is unspecified.
	//   "REPLACE" - Replace existing data with imported data. If an app with the
	// same `app_id` already exists, its content will be updated based on the
	// imported app. - Resources (App, Agents, Tools, Examples, Guardrails,
	// Toolsets) in the imported app that have the same display name as existing
	// resources will overwrite the existing ones. - Imported resources with new
	// display names will be created. - Existing resources that do not have a
	// matching display name in the imported app will remain untouched.
	//   "OVERWRITE" - Overwrite existing data with imported data. If an app with
	// the same `app_id` already exists, its content will be overwritten with the
	// imported app. - Existing resources (Agents, Tools, Examples, Guardrails,
	// Toolsets) in the app will be deleted. - Imported resources will be created
	// as new resources.
	ConflictResolutionStrategy string `json:"conflictResolutionStrategy,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConflictResolutionStrategy")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConflictResolutionStrategy") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ImportAppRequestImportOptions) MarshalJSON() ([]byte, error) {
	type NoMethod ImportAppRequestImportOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ImportAppResponse: Response message for AgentService.ImportApp.
type ImportAppResponse struct {
	// Name: The resource name of the app that was imported.
	Name string `json:"name,omitempty"`
	// Warnings: Warning messages generated during the import process. If errors
	// occur for specific resources, they will not be included in the imported app
	// and the error will be mentioned here.
	Warnings []string `json:"warnings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ImportAppResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ImportAppResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InputAudioConfig: InputAudioConfig configures how the CES agent should
// interpret the incoming audio data.
type InputAudioConfig struct {
	// AudioEncoding: Required. The encoding of the input audio data.
	//
	// Possible values:
	//   "AUDIO_ENCODING_UNSPECIFIED" - Unspecified audio encoding.
	//   "LINEAR16" - 16-bit linear PCM audio encoding.
	//   "MULAW" - 8-bit samples that compand 14-bit audio samples using G.711
	// PCMU/mu-law.
	//   "ALAW" - 8-bit samples that compand 14-bit audio samples using G.711
	// PCMU/A-law.
	AudioEncoding string `json:"audioEncoding,omitempty"`
	// NoiseSuppressionLevel: Optional. Whether to enable noise suppression on the
	// input audio. Available values are "low", "moderate", "high", "very_high".
	NoiseSuppressionLevel string `json:"noiseSuppressionLevel,omitempty"`
	// SampleRateHertz: Required. The sample rate (in Hertz) of the input audio
	// data.
	SampleRateHertz int64 `json:"sampleRateHertz,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioEncoding") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioEncoding") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InputAudioConfig) MarshalJSON() ([]byte, error) {
	type NoMethod InputAudioConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LanguageSettings: Language settings of the app.
type LanguageSettings struct {
	// DefaultLanguageCode: Optional. The default language code of the app.
	DefaultLanguageCode string `json:"defaultLanguageCode,omitempty"`
	// EnableMultilingualSupport: Optional. Enables multilingual support. If true,
	// agents in the app will use pre-built instructions to improve handling of
	// multilingual input.
	EnableMultilingualSupport bool `json:"enableMultilingualSupport,omitempty"`
	// FallbackAction: Optional. The action to perform when an agent receives input
	// in an unsupported language. This can be a predefined action or a custom tool
	// call. Valid values are: - A tool's full resource name, which triggers a
	// specific tool execution. - A predefined system action, such as "escalate" or
	// "exit", which triggers an EndSession signal with corresponding metadata to
	// terminate the conversation.
	FallbackAction string `json:"fallbackAction,omitempty"`
	// SupportedLanguageCodes: Optional. List of languages codes supported by the
	// app, in addition to the `default_language_code`.
	SupportedLanguageCodes []string `json:"supportedLanguageCodes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DefaultLanguageCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DefaultLanguageCode") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LanguageSettings) MarshalJSON() ([]byte, error) {
	type NoMethod LanguageSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListAgentsResponse: Response message for AgentService.ListAgents.
type ListAgentsResponse struct {
	// Agents: The list of agents.
	Agents []*Agent `json:"agents,omitempty"`
	// NextPageToken: A token that can be sent as ListAgentsRequest.page_token to
	// retrieve the next page. Absence of this field indicates there are no
	// subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Agents") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Agents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListAgentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAgentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListAppVersionsResponse: Response message for AgentService.ListAppVersions.
type ListAppVersionsResponse struct {
	// AppVersions: The list of app versions.
	AppVersions []*AppVersion `json:"appVersions,omitempty"`
	// NextPageToken: A token that can be sent as ListAppVersionsRequest.page_token
	// to retrieve the next page. Absence of this field indicates there are no
	// subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AppVersions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AppVersions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListAppVersionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAppVersionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListAppsResponse: Response message for AgentService.ListApps.
type ListAppsResponse struct {
	// Apps: The list of apps.
	Apps []*App `json:"apps,omitempty"`
	// NextPageToken: A token that can be sent as ListAppsRequest.page_token to
	// retrieve the next page. Absence of this field indicates there are no
	// subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Unordered list. Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Apps") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Apps") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListAppsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAppsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListChangelogsResponse: Response message for AgentService.ListChangelogs.
type ListChangelogsResponse struct {
	// Changelogs: The list of changelogs.
	Changelogs []*Changelog `json:"changelogs,omitempty"`
	// NextPageToken: A token that can be sent as ListChangelogsRequest.page_token
	// to retrieve the next page. Absence of this field indicates there are no
	// subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Changelogs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Changelogs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListChangelogsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListChangelogsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListConversationsResponse: Response message for
// AgentService.ListConversations.
type ListConversationsResponse struct {
	// Conversations: The list of conversations.
	Conversations []*Conversation `json:"conversations,omitempty"`
	// NextPageToken: A token that can be sent as
	// ListConversationsRequest.page_token to retrieve the next page. Absence of
	// this field indicates there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Conversations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conversations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListConversationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListConversationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListDeploymentsResponse: Response message for AgentService.ListDeployments.
type ListDeploymentsResponse struct {
	// Deployments: The list of deployments.
	Deployments []*Deployment `json:"deployments,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Deployments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Deployments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListDeploymentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListDeploymentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListExamplesResponse: Response message for AgentService.ListExamples.
type ListExamplesResponse struct {
	// Examples: The list of examples.
	Examples []*Example `json:"examples,omitempty"`
	// NextPageToken: A token that can be sent as ListExamplesRequest.page_token to
	// retrieve the next page. Absence of this field indicates there are no
	// subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Examples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Examples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListExamplesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListExamplesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListGuardrailsResponse: Response message for AgentService.ListGuardrails.
type ListGuardrailsResponse struct {
	// Guardrails: The list of guardrails.
	Guardrails []*Guardrail `json:"guardrails,omitempty"`
	// NextPageToken: A token that can be sent as ListGuardrailsRequest.page_token
	// to retrieve the next page. Absence of this field indicates there are no
	// subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Guardrails") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Guardrails") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListGuardrailsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListGuardrailsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListLocationsResponse: The response message for Locations.ListLocations.
type ListLocationsResponse struct {
	// Locations: A list of locations that matches the specified filter in the
	// request.
	Locations []*Location `json:"locations,omitempty"`
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Locations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Locations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListLocationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListLocationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListOperationsResponse: The response message for Operations.ListOperations.
type ListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Operations: A list of operations that matches the specified filter in the
	// request.
	Operations []*Operation `json:"operations,omitempty"`
	// Unreachable: Unordered list. Unreachable resources. Populated when the
	// request sets `ListOperationsRequest.return_partial_success` and reads across
	// collections. For example, when attempting to list all resources across all
	// supported locations.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListOperationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListToolsResponse: Response message for AgentService.ListTools.
type ListToolsResponse struct {
	// NextPageToken: A token that can be sent as ListToolsRequest.page_token to
	// retrieve the next page. Absence of this field indicates there are no
	// subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Tools: The list of tools.
	Tools []*Tool `json:"tools,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListToolsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListToolsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListToolsetsResponse: Response message for AgentService.ListToolsets.
type ListToolsetsResponse struct {
	// NextPageToken: A token that can be sent as ListToolsetsRequest.page_token to
	// retrieve the next page. Absence of this field indicates there are no
	// subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Toolsets: The list of toolsets.
	Toolsets []*Toolset `json:"toolsets,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListToolsetsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListToolsetsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Location: A resource that represents a Google Cloud location.
type Location struct {
	// DisplayName: The friendly name for this location, typically a nearby city
	// name. For example, "Tokyo".
	DisplayName string `json:"displayName,omitempty"`
	// Labels: Cross-service attributes for the location. For example
	// {"cloud.googleapis.com/region": "us-east1"}
	Labels map[string]string `json:"labels,omitempty"`
	// LocationId: The canonical id for this location. For example: "us-east1".
	LocationId string `json:"locationId,omitempty"`
	// Metadata: Service-specific metadata. For example the available capacity at
	// the given location.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: Resource name for the location, which may vary between
	// implementations. For example:
	// "projects/example-project/locations/us-east1"
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Location) MarshalJSON() ([]byte, error) {
	type NoMethod Location
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LoggingSettings: Settings to describe the logging behaviors for the app.
type LoggingSettings struct {
	// AudioRecordingConfig: Optional. Configuration for how audio interactions
	// should be recorded.
	AudioRecordingConfig *AudioRecordingConfig `json:"audioRecordingConfig,omitempty"`
	// BigqueryExportSettings: Optional. Settings to describe the BigQuery export
	// behaviors for the app. The conversation data will be exported to BigQuery
	// tables if it is enabled.
	BigqueryExportSettings *BigQueryExportSettings `json:"bigqueryExportSettings,omitempty"`
	// CloudLoggingSettings: Optional. Settings to describe the Cloud Logging
	// behaviors for the app.
	CloudLoggingSettings *CloudLoggingSettings `json:"cloudLoggingSettings,omitempty"`
	// ConversationLoggingSettings: Optional. Settings to describe the conversation
	// logging behaviors for the app.
	ConversationLoggingSettings *ConversationLoggingSettings `json:"conversationLoggingSettings,omitempty"`
	// EvaluationAudioRecordingConfig: Optional. Configuration for how audio
	// interactions should be recorded for the evaluation. By default, audio
	// recording is not enabled for evaluation sessions.
	EvaluationAudioRecordingConfig *AudioRecordingConfig `json:"evaluationAudioRecordingConfig,omitempty"`
	// MetricAnalysisSettings: Optional. Settings to describe the conversation data
	// collection behaviors for the LLM analysis pipeline for the app.
	MetricAnalysisSettings *MetricAnalysisSettings `json:"metricAnalysisSettings,omitempty"`
	// RedactionConfig: Optional. Configuration for how sensitive data should be
	// redacted.
	RedactionConfig *RedactionConfig `json:"redactionConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioRecordingConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioRecordingConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LoggingSettings) MarshalJSON() ([]byte, error) {
	type NoMethod LoggingSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// McpTool: An MCP tool. See
// https://modelcontextprotocol.io/specification/2025-06-18/server/tools for
// more details.
type McpTool struct {
	// ApiAuthentication: Optional. Authentication information required to execute
	// the tool against the MCP server. For bearer token authentication, the token
	// applies only to tool execution, not to listing tools. This requires that
	// tools can be listed without authentication.
	ApiAuthentication *ApiAuthentication `json:"apiAuthentication,omitempty"`
	// Description: Optional. The description of the MCP tool.
	Description string `json:"description,omitempty"`
	// InputSchema: Optional. The schema of the input arguments of the MCP tool.
	InputSchema *Schema `json:"inputSchema,omitempty"`
	// Name: Required. The name of the MCP tool.
	Name string `json:"name,omitempty"`
	// OutputSchema: Optional. The schema of the output arguments of the MCP tool.
	OutputSchema *Schema `json:"outputSchema,omitempty"`
	// ServerAddress: Required. The server address of the MCP server, e.g.,
	// "https://example.com/mcp/". If the server is built with the MCP SDK, the url
	// should be suffixed with "/mcp/". Only Streamable HTTP transport based
	// servers are supported. This is the same as the server_address in the
	// McpToolset. See
	// https://modelcontextprotocol.io/specification/2025-03-26/basic/transports#streamable-http
	// for more details.
	ServerAddress string `json:"serverAddress,omitempty"`
	// ServiceDirectoryConfig: Optional. Service Directory configuration for
	// VPC-SC, used to resolve service names within a perimeter.
	ServiceDirectoryConfig *ServiceDirectoryConfig `json:"serviceDirectoryConfig,omitempty"`
	// TlsConfig: Optional. The TLS configuration. Includes the custom server
	// certificates that the client should trust.
	TlsConfig *TlsConfig `json:"tlsConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiAuthentication") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiAuthentication") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s McpTool) MarshalJSON() ([]byte, error) {
	type NoMethod McpTool
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// McpToolset: A toolset that contains a list of tools that are offered by the
// MCP server.
type McpToolset struct {
	// ApiAuthentication: Optional. Authentication information required to access
	// tools and execute a tool against the MCP server. For bearer token
	// authentication, the token applies only to tool execution, not to listing
	// tools. This requires that tools can be listed without authentication.
	ApiAuthentication *ApiAuthentication `json:"apiAuthentication,omitempty"`
	// ServerAddress: Required. The address of the MCP server, for example,
	// "https://example.com/mcp/". If the server is built with the MCP SDK, the url
	// should be suffixed with "/mcp/". Only Streamable HTTP transport based
	// servers are supported. See
	// https://modelcontextprotocol.io/specification/2025-03-26/basic/transports#streamable-http
	// for more details.
	ServerAddress string `json:"serverAddress,omitempty"`
	// ServiceDirectoryConfig: Optional. Service Directory configuration for
	// VPC-SC, used to resolve service names within a perimeter.
	ServiceDirectoryConfig *ServiceDirectoryConfig `json:"serviceDirectoryConfig,omitempty"`
	// TlsConfig: Optional. The TLS configuration. Includes the custom server
	// certificates that the client should trust.
	TlsConfig *TlsConfig `json:"tlsConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiAuthentication") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiAuthentication") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s McpToolset) MarshalJSON() ([]byte, error) {
	type NoMethod McpToolset
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Message: A message within a conversation.
type Message struct {
	// Chunks: Optional. Content of the message as a series of chunks.
	Chunks []*Chunk `json:"chunks,omitempty"`
	// EventTime: Optional. Timestamp when the message was sent or received. Should
	// not be used if the message is part of an example.
	EventTime string `json:"eventTime,omitempty"`
	// Role: Optional. The role within the conversation, e.g., user, agent.
	Role string `json:"role,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Chunks") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Chunks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Message) MarshalJSON() ([]byte, error) {
	type NoMethod Message
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MetricAnalysisSettings: Settings to describe the conversation data
// collection behaviors for LLM analysis metrics pipeline.
type MetricAnalysisSettings struct {
	// LlmMetricsOptedOut: Optional. Whether to collect conversation data for llm
	// analysis metrics. If true, conversation data will not be collected for llm
	// analysis metrics; otherwise, conversation data will be collected.
	LlmMetricsOptedOut bool `json:"llmMetricsOptedOut,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LlmMetricsOptedOut") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LlmMetricsOptedOut") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MetricAnalysisSettings) MarshalJSON() ([]byte, error) {
	type NoMethod MetricAnalysisSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ModelSettings: Model settings contains various configurations for the LLM
// model.
type ModelSettings struct {
	// Model: Optional. The LLM model that the agent should use. If not set, the
	// agent will inherit the model from its parent agent.
	Model string `json:"model,omitempty"`
	// Temperature: Optional. If set, this temperature will be used for the LLM
	// model. Temperature controls the randomness of the model's responses. Lower
	// temperatures produce responses that are more predictable. Higher
	// temperatures produce responses that are more creative.
	Temperature float64 `json:"temperature,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Model") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Model") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ModelSettings) MarshalJSON() ([]byte, error) {
	type NoMethod ModelSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *ModelSettings) UnmarshalJSON(data []byte) error {
	type NoMethod ModelSettings
	var s1 struct {
		Temperature gensupport.JSONFloat64 `json:"temperature"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Temperature = float64(s1.Temperature)
	return nil
}

// OAuthConfig: Configurations for authentication with OAuth.
type OAuthConfig struct {
	// ClientId: Required. The client ID from the OAuth provider.
	ClientId string `json:"clientId,omitempty"`
	// ClientSecretVersion: Required. The name of the SecretManager secret version
	// resource storing the client secret. Format:
	// `projects/{project}/secrets/{secret}/versions/{version}` Note: You should
	// grant `roles/secretmanager.secretAccessor` role to the CES service agent
	// `service-@gcp-sa-ces.iam.gserviceaccount.com`.
	ClientSecretVersion string `json:"clientSecretVersion,omitempty"`
	// OauthGrantType: Required. OAuth grant types.
	//
	// Possible values:
	//   "OAUTH_GRANT_TYPE_UNSPECIFIED" - Unspecified. Defaults to
	// CLIENT_CREDENTIAL.
	//   "CLIENT_CREDENTIAL" - Represents the [client credential
	// flow](https://oauth.net/2/grant-types/client-credentials).
	OauthGrantType string `json:"oauthGrantType,omitempty"`
	// Scopes: Optional. The OAuth scopes to grant.
	Scopes []string `json:"scopes,omitempty"`
	// TokenEndpoint: Required. The token endpoint in the OAuth provider to
	// exchange for an access token.
	TokenEndpoint string `json:"tokenEndpoint,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClientId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClientId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OAuthConfig) MarshalJSON() ([]byte, error) {
	type NoMethod OAuthConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Omnichannel: Represents an Omnichannel resource.
type Omnichannel struct {
	// CreateTime: Output only. Timestamp when the omnichannel resource was
	// created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. Human-readable description of the omnichannel
	// resource.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. Display name of the omnichannel resource.
	DisplayName string `json:"displayName,omitempty"`
	// Etag: Output only. Etag used to ensure the object hasn't changed during a
	// read-modify-write operation.
	Etag string `json:"etag,omitempty"`
	// IntegrationConfig: Optional. The integration config for the omnichannel
	// resource.
	IntegrationConfig *OmnichannelIntegrationConfig `json:"integrationConfig,omitempty"`
	// Name: Identifier. The unique identifier of the omnichannel resource. Format:
	// `projects/{project}/locations/{location}/omnichannels/{omnichannel}`
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. Timestamp when the omnichannel resource was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Omnichannel) MarshalJSON() ([]byte, error) {
	type NoMethod Omnichannel
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OmnichannelIntegrationConfig: OmnichannelIntegrationConfig contains all App
// integration configs.
type OmnichannelIntegrationConfig struct {
	// ChannelConfigs: Optional. Various of configuration for handling App events.
	ChannelConfigs map[string]OmnichannelIntegrationConfigChannelConfig `json:"channelConfigs,omitempty"`
	// RoutingConfigs: Optional. The key of routing_configs is a key of
	// `app_configs`, value is a `RoutingConfig`, which contains subscriber's key.
	RoutingConfigs map[string]OmnichannelIntegrationConfigRoutingConfig `json:"routingConfigs,omitempty"`
	// SubscriberConfigs: Optional. Various of subscribers configs.
	SubscriberConfigs map[string]OmnichannelIntegrationConfigSubscriberConfig `json:"subscriberConfigs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChannelConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChannelConfigs") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OmnichannelIntegrationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod OmnichannelIntegrationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OmnichannelIntegrationConfigCesAppConfig: Configs for CES app.
type OmnichannelIntegrationConfigCesAppConfig struct {
	// App: The unique identifier of the CES app. Format:
	// `projects/{project}/locations/{location}/apps/{app}`
	App string `json:"app,omitempty"`
	// ForceSendFields is a list of field names (e.g. "App") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "App") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OmnichannelIntegrationConfigCesAppConfig) MarshalJSON() ([]byte, error) {
	type NoMethod OmnichannelIntegrationConfigCesAppConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OmnichannelIntegrationConfigChannelConfig: ChannelConfig contains config for
// various of app integration.
type OmnichannelIntegrationConfigChannelConfig struct {
	// WhatsappConfig: WhatsApp config.
	WhatsappConfig *OmnichannelIntegrationConfigWhatsappConfig `json:"whatsappConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "WhatsappConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "WhatsappConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OmnichannelIntegrationConfigChannelConfig) MarshalJSON() ([]byte, error) {
	type NoMethod OmnichannelIntegrationConfigChannelConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OmnichannelIntegrationConfigRoutingConfig: Routing config specify how/who to
// route app events to a subscriber.
type OmnichannelIntegrationConfigRoutingConfig struct {
	// SubscriberKey: The key of the subscriber.
	SubscriberKey string `json:"subscriberKey,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SubscriberKey") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SubscriberKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OmnichannelIntegrationConfigRoutingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod OmnichannelIntegrationConfigRoutingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OmnichannelIntegrationConfigSubscriberConfig: Configs of subscribers.
type OmnichannelIntegrationConfigSubscriberConfig struct {
	// CesAppConfig: Ces app config.
	CesAppConfig *OmnichannelIntegrationConfigCesAppConfig `json:"cesAppConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CesAppConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CesAppConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OmnichannelIntegrationConfigSubscriberConfig) MarshalJSON() ([]byte, error) {
	type NoMethod OmnichannelIntegrationConfigSubscriberConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OmnichannelIntegrationConfigWhatsappConfig: How Omnichannel should
// receive/reply events from WhatsApp.
type OmnichannelIntegrationConfigWhatsappConfig struct {
	// MetaBusinessPortfolioId: The Meta Business Portfolio (MBP) ID.
	// https://www.facebook.com/business/help/1710077379203657
	MetaBusinessPortfolioId string `json:"metaBusinessPortfolioId,omitempty"`
	// PhoneNumber: The phone number used for sending/receiving messages.
	PhoneNumber string `json:"phoneNumber,omitempty"`
	// PhoneNumberId: The Phone Number ID associated with the WhatsApp Business
	// Account.
	PhoneNumberId string `json:"phoneNumberId,omitempty"`
	// WebhookVerifyToken: The verify token configured in the Meta App Dashboard
	// for webhook verification.
	WebhookVerifyToken string `json:"webhookVerifyToken,omitempty"`
	// WhatsappBusinessAccountId: The customer's WhatsApp Business Account (WABA)
	// ID.
	WhatsappBusinessAccountId string `json:"whatsappBusinessAccountId,omitempty"`
	// WhatsappBusinessToken: The access token for authenticating API calls to the
	// WhatsApp Cloud API.
	// https://developers.facebook.com/docs/whatsapp/business-management-api/get-started/#business-integration-system-user-access-tokens
	WhatsappBusinessToken string `json:"whatsappBusinessToken,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MetaBusinessPortfolioId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MetaBusinessPortfolioId") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OmnichannelIntegrationConfigWhatsappConfig) MarshalJSON() ([]byte, error) {
	type NoMethod OmnichannelIntegrationConfigWhatsappConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OmnichannelOperationMetadata: Represents the metadata of the long-running
// operation.
type OmnichannelOperationMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// RequestedCancellation: Output only. Identifies whether the user has
	// requested cancellation of the operation.
	RequestedCancellation bool `json:"requestedCancellation,omitempty"`
	// StatusMessage: Output only. Human-readable status of the operation, if any.
	StatusMessage string `json:"statusMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OmnichannelOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod OmnichannelOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OpenApiTool: A remote API tool defined by an OpenAPI schema.
type OpenApiTool struct {
	// ApiAuthentication: Optional. Authentication information required by the API.
	ApiAuthentication *ApiAuthentication `json:"apiAuthentication,omitempty"`
	// Description: Optional. The description of the tool. If not provided, the
	// description of the tool will be derived from the OpenAPI schema, from
	// `operation.description` or `operation.summary`.
	Description string `json:"description,omitempty"`
	// IgnoreUnknownFields: Optional. If true, the agent will ignore unknown fields
	// in the API response.
	IgnoreUnknownFields bool `json:"ignoreUnknownFields,omitempty"`
	// Name: Optional. The name of the tool. If not provided, the name of the tool
	// will be derived from the OpenAPI schema, from `operation.operationId`.
	Name string `json:"name,omitempty"`
	// OpenApiSchema: Required. The OpenAPI schema in JSON or YAML format.
	OpenApiSchema string `json:"openApiSchema,omitempty"`
	// ServiceDirectoryConfig: Optional. Service Directory configuration.
	ServiceDirectoryConfig *ServiceDirectoryConfig `json:"serviceDirectoryConfig,omitempty"`
	// TlsConfig: Optional. The TLS configuration. Includes the custom server
	// certificates that the client will trust.
	TlsConfig *TlsConfig `json:"tlsConfig,omitempty"`
	// Url: Optional. The server URL of the Open API schema. This field is only set
	// in tools in the environment dependencies during the export process if the
	// schema contains a server url. During the import process, if this url is
	// present in the environment dependencies and the schema has the $env_var
	// placeholder, it will replace the placeholder in the schema.
	Url string `json:"url,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiAuthentication") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiAuthentication") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OpenApiTool) MarshalJSON() ([]byte, error) {
	type NoMethod OpenApiTool
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OpenApiToolset: A toolset that contains a list of tools that are defined by
// an OpenAPI schema.
type OpenApiToolset struct {
	// ApiAuthentication: Optional. Authentication information required by the API.
	ApiAuthentication *ApiAuthentication `json:"apiAuthentication,omitempty"`
	// IgnoreUnknownFields: Optional. If true, the agent will ignore unknown fields
	// in the API response for all operations defined in the OpenAPI schema.
	IgnoreUnknownFields bool `json:"ignoreUnknownFields,omitempty"`
	// OpenApiSchema: Required. The OpenAPI schema of the toolset.
	OpenApiSchema string `json:"openApiSchema,omitempty"`
	// ServiceDirectoryConfig: Optional. Service Directory configuration.
	ServiceDirectoryConfig *ServiceDirectoryConfig `json:"serviceDirectoryConfig,omitempty"`
	// TlsConfig: Optional. The TLS configuration. Includes the custom server
	// certificates
	TlsConfig *TlsConfig `json:"tlsConfig,omitempty"`
	// Url: Optional. The server URL of the Open API schema. This field is only set
	// in toolsets in the environment dependencies during the export process if the
	// schema contains a server url. During the import process, if this url is
	// present in the environment dependencies and the schema has the $env_var
	// placeholder, it will replace the placeholder in the schema.
	Url string `json:"url,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiAuthentication") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiAuthentication") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OpenApiToolset) MarshalJSON() ([]byte, error) {
	type NoMethod OpenApiToolset
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Operation: This resource represents a long-running operation that is the
// result of a network API call.
type Operation struct {
	// Done: If the value is `false`, it means the operation is still in progress.
	// If `true`, the operation is completed, and either `error` or `response` is
	// available.
	Done bool `json:"done,omitempty"`
	// Error: The error result of the operation in case of failure or cancellation.
	Error *Status `json:"error,omitempty"`
	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as create
	// time. Some services might not provide such metadata. Any method that returns
	// a long-running operation should document the metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: The server-assigned name, which is only unique within the same service
	// that originally returns it. If you use the default HTTP mapping, the `name`
	// should be a resource name ending with `operations/{unique_id}`.
	Name string `json:"name,omitempty"`
	// Response: The normal, successful response of the operation. If the original
	// method returns no data on success, such as `Delete`, the response is
	// `google.protobuf.Empty`. If the original method is standard
	// `Get`/`Create`/`Update`, the response should be the resource. For other
	// methods, the response should have the type `XxxResponse`, where `Xxx` is the
	// original method name. For example, if the original method name is
	// `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Operation) MarshalJSON() ([]byte, error) {
	type NoMethod Operation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OperationMetadata: Represents the metadata of the long-running operation.
type OperationMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// RequestedCancellation: Output only. Identifies whether the user has
	// requested cancellation of the operation. Operations that have been cancelled
	// successfully have google.longrunning.Operation.error value with a
	// google.rpc.Status.code of `1`, corresponding to `Code.CANCELLED`.
	RequestedCancellation bool `json:"requestedCancellation,omitempty"`
	// StatusMessage: Output only. Human-readable status of the operation, if any.
	StatusMessage string `json:"statusMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod OperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OutputAudioConfig: OutputAudioConfig configures how the CES agent should
// synthesize outgoing audio responses.
type OutputAudioConfig struct {
	// AudioEncoding: Required. The encoding of the output audio data.
	//
	// Possible values:
	//   "AUDIO_ENCODING_UNSPECIFIED" - Unspecified audio encoding.
	//   "LINEAR16" - 16-bit linear PCM audio encoding.
	//   "MULAW" - 8-bit samples that compand 14-bit audio samples using G.711
	// PCMU/mu-law.
	//   "ALAW" - 8-bit samples that compand 14-bit audio samples using G.711
	// PCMU/A-law.
	AudioEncoding string `json:"audioEncoding,omitempty"`
	// SampleRateHertz: Required. The sample rate (in Hertz) of the output audio
	// data.
	SampleRateHertz int64 `json:"sampleRateHertz,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioEncoding") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioEncoding") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OutputAudioConfig) MarshalJSON() ([]byte, error) {
	type NoMethod OutputAudioConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PythonCodeCondition: Python code block to evaluate the condition.
type PythonCodeCondition struct {
	// PythonCode: Required. The python code to execute.
	PythonCode string `json:"pythonCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PythonCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PythonCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PythonCodeCondition) MarshalJSON() ([]byte, error) {
	type NoMethod PythonCodeCondition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PythonFunction: A Python function tool.
type PythonFunction struct {
	// Description: Output only. The description of the Python function, parsed
	// from the python code's docstring.
	Description string `json:"description,omitempty"`
	// Name: Optional. The name of the Python function to execute. Must match a
	// Python function name defined in the python code. Case sensitive. If the name
	// is not provided, the first function defined in the python code will be used.
	Name string `json:"name,omitempty"`
	// PythonCode: Optional. The Python code to execute for the tool.
	PythonCode string `json:"pythonCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PythonFunction) MarshalJSON() ([]byte, error) {
	type NoMethod PythonFunction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RedactionConfig: Configuration to instruct how sensitive data should be
// handled.
type RedactionConfig struct {
	// DeidentifyTemplate: Optional. DLP (https://cloud.google.com/dlp/docs)
	// deidentify template name to instruct on how to de-identify content. Format:
	// `projects/{project}/locations/{location}/deidentifyTemplates/{deidentify_temp
	// late}`
	DeidentifyTemplate string `json:"deidentifyTemplate,omitempty"`
	// EnableRedaction: Optional. If true, redaction will be applied in various
	// logging scenarios, including conversation history, Cloud Logging and audio
	// recording.
	EnableRedaction bool `json:"enableRedaction,omitempty"`
	// InspectTemplate: Optional. DLP (https://cloud.google.com/dlp/docs) inspect
	// template name to configure detection of sensitive data types. Format:
	// `projects/{project}/locations/{location}/inspectTemplates/{inspect_template}`
	InspectTemplate string `json:"inspectTemplate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeidentifyTemplate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeidentifyTemplate") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RedactionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod RedactionConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RestoreAppVersionRequest: Request message for AgentService.RestoreAppVersion
type RestoreAppVersionRequest struct {
}

// RetrieveToolSchemaRequest: Request message for
// ToolService.RetrieveToolSchema.
type RetrieveToolSchemaRequest struct {
	// Tool: Optional. The name of the tool to retrieve the schema for. Format:
	// projects/{project}/locations/{location}/apps/{app}/tools/{tool}
	Tool string `json:"tool,omitempty"`
	// ToolsetTool: Optional. The toolset tool to retrieve the schema for. Only one
	// tool should match the predicate from the toolset. Otherwise, an error will
	// be returned.
	ToolsetTool *ToolsetTool `json:"toolsetTool,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Tool") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Tool") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RetrieveToolSchemaRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RetrieveToolSchemaRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RetrieveToolSchemaResponse: Response message for
// ToolService.RetrieveToolSchema.
type RetrieveToolSchemaResponse struct {
	// InputSchema: Required. The schema of the tool input parameters.
	InputSchema *Schema `json:"inputSchema,omitempty"`
	// OutputSchema: Required. The schema of the tool output parameters.
	OutputSchema *Schema `json:"outputSchema,omitempty"`
	// Tool: The name of the tool that the schema is for. Format:
	// `projects/{project}/locations/{location}/apps/{app}/tools/{tool}`
	Tool string `json:"tool,omitempty"`
	// ToolsetTool: The toolset tool that the schema is for.
	ToolsetTool *ToolsetTool `json:"toolsetTool,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "InputSchema") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InputSchema") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RetrieveToolSchemaResponse) MarshalJSON() ([]byte, error) {
	type NoMethod RetrieveToolSchemaResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RetrieveToolsRequest: Request message for ToolService.RetrieveTools.
type RetrieveToolsRequest struct {
	// ToolIds: Optional. The identifiers of the tools to retrieve from the
	// toolset. If empty, all tools in the toolset will be returned.
	ToolIds []string `json:"toolIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ToolIds") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ToolIds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RetrieveToolsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RetrieveToolsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RetrieveToolsResponse: Response message for ToolService.RetrieveTools.
type RetrieveToolsResponse struct {
	// Tools: Required. The list of tools that are included in the specified
	// toolset.
	Tools []*Tool `json:"tools,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Tools") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Tools") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RetrieveToolsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod RetrieveToolsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RunSessionRequest: Request message for SessionService.RunSession.
type RunSessionRequest struct {
	// Config: Required. The configuration for the session.
	Config *SessionConfig `json:"config,omitempty"`
	// Inputs: Required. Inputs for the session.
	Inputs []*SessionInput `json:"inputs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Config") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Config") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RunSessionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RunSessionRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RunSessionResponse: Response message for SessionService.RunSession.
type RunSessionResponse struct {
	// Outputs: Outputs for the session.
	Outputs []*SessionOutput `json:"outputs,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Outputs") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Outputs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RunSessionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod RunSessionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Schema: Represents a select subset of an OpenAPI 3.0 schema object.
type Schema struct {
	// AdditionalProperties: Optional. Can either be a boolean or an object,
	// controls the presence of additional properties.
	AdditionalProperties *Schema `json:"additionalProperties,omitempty"`
	// AnyOf: Optional. The value should be validated against any (one or more) of
	// the subschemas in the list.
	AnyOf []*Schema `json:"anyOf,omitempty"`
	// Default: Optional. Default value of the data.
	Default interface{} `json:"default,omitempty"`
	// Defs: Optional. A map of definitions for use by `ref`. Only allowed at the
	// root of the schema.
	Defs map[string]Schema `json:"defs,omitempty"`
	// Description: Optional. The description of the data.
	Description string `json:"description,omitempty"`
	// Enum: Optional. Possible values of the element of primitive type with enum
	// format. Examples: 1. We can define direction as : {type:STRING, format:enum,
	// enum:["EAST", NORTH", "SOUTH", "WEST"]} 2. We can define apartment number as
	// : {type:INTEGER, format:enum, enum:["101", "201", "301"]}
	Enum []string `json:"enum,omitempty"`
	// Items: Optional. Schema of the elements of Type.ARRAY.
	Items *Schema `json:"items,omitempty"`
	// MaxItems: Optional. Maximum number of the elements for Type.ARRAY.
	MaxItems int64 `json:"maxItems,omitempty,string"`
	// Maximum: Optional. Maximum value for Type.INTEGER and Type.NUMBER.
	Maximum float64 `json:"maximum,omitempty"`
	// MinItems: Optional. Minimum number of the elements for Type.ARRAY.
	MinItems int64 `json:"minItems,omitempty,string"`
	// Minimum: Optional. Minimum value for Type.INTEGER and Type.NUMBER.
	Minimum float64 `json:"minimum,omitempty"`
	// Nullable: Optional. Indicates if the value may be null.
	Nullable bool `json:"nullable,omitempty"`
	// PrefixItems: Optional. Schemas of initial elements of Type.ARRAY.
	PrefixItems []*Schema `json:"prefixItems,omitempty"`
	// Properties: Optional. Properties of Type.OBJECT.
	Properties map[string]Schema `json:"properties,omitempty"`
	// Ref: Optional. Allows indirect references between schema nodes. The value
	// should be a valid reference to a child of the root `defs`. For example, the
	// following schema defines a reference to a schema node named "Pet": type:
	// object properties: pet: ref: #/defs/Pet defs: Pet: type: object properties:
	// name: type: string The value of the "pet" property is a reference to the
	// schema node named "Pet". See details in
	// https://json-schema.org/understanding-json-schema/structuring.
	Ref string `json:"ref,omitempty"`
	// Required: Optional. Required properties of Type.OBJECT.
	Required []string `json:"required,omitempty"`
	// Title: Optional. The title of the schema.
	Title string `json:"title,omitempty"`
	// Type: Required. The type of the data.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Type unspecified.
	//   "STRING" - String type.
	//   "INTEGER" - Integer type.
	//   "NUMBER" - Number type.
	//   "BOOLEAN" - Boolean type.
	//   "OBJECT" - Object type.
	//   "ARRAY" - Array type.
	Type string `json:"type,omitempty"`
	// UniqueItems: Optional. Indicate the items in the array must be unique. Only
	// applies to TYPE.ARRAY.
	UniqueItems bool `json:"uniqueItems,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdditionalProperties") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalProperties") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Schema) MarshalJSON() ([]byte, error) {
	type NoMethod Schema
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *Schema) UnmarshalJSON(data []byte) error {
	type NoMethod Schema
	var s1 struct {
		Maximum gensupport.JSONFloat64 `json:"maximum"`
		Minimum gensupport.JSONFloat64 `json:"minimum"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Maximum = float64(s1.Maximum)
	s.Minimum = float64(s1.Minimum)
	return nil
}

// ServiceAccountAuthConfig: Configurations for authentication using a custom
// service account.
type ServiceAccountAuthConfig struct {
	// Scopes: Optional. The OAuth scopes to grant. If not specified, the default
	// scope `https://www.googleapis.com/auth/cloud-platform` is used.
	Scopes []string `json:"scopes,omitempty"`
	// ServiceAccount: Required. The email address of the service account used for
	// authentication. CES uses this service account to exchange an access token
	// and the access token is then sent in the `Authorization` header of the
	// request. The service account must have the
	// `roles/iam.serviceAccountTokenCreator` role granted to the CES service agent
	// `service-@gcp-sa-ces.iam.gserviceaccount.com`.
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Scopes") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Scopes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ServiceAccountAuthConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ServiceAccountAuthConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ServiceAgentIdTokenAuthConfig: Configurations for authentication with ID
// token (https://cloud.google.com/docs/authentication/token-types#id)
// generated from service agent.
type ServiceAgentIdTokenAuthConfig struct {
}

// ServiceDirectoryConfig: Configuration for tools using Service Directory.
type ServiceDirectoryConfig struct {
	// Service: Required. The name of Service Directory
	// (https://cloud.google.com/service-directory) service. Format:
	// `projects/{project}/locations/{location}/namespaces/{namespace}/services/{ser
	// vice}`. Location of the service directory must be the same as the location
	// of the app.
	Service string `json:"service,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Service") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Service") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ServiceDirectoryConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ServiceDirectoryConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SessionConfig: The configuration for the session.
type SessionConfig struct {
	// Deployment: Optional. The deployment of the app to use for the session.
	// Format:
	// `projects/{project}/locations/{location}/apps/{app}/deployments/{deployment}`
	Deployment string `json:"deployment,omitempty"`
	// EntryAgent: Optional. The entry agent to handle the session. If not
	// specified, the session will be handled by the root agent of the app. Format:
	// `projects/{project}/locations/{location}/agents/{agent}`
	EntryAgent string `json:"entryAgent,omitempty"`
	// HistoricalContexts: Optional. The historical context of the session,
	// including user inputs, agent responses, and other messages. Typically, CES
	// agent would manage session automatically so client doesn't need to
	// explicitly populate this field. However, client can optionally override the
	// historical contexts to force the session start from certain state.
	HistoricalContexts []*Message `json:"historicalContexts,omitempty"`
	// InputAudioConfig: Optional. Configuration for processing the input audio.
	InputAudioConfig *InputAudioConfig `json:"inputAudioConfig,omitempty"`
	// OutputAudioConfig: Optional. Configuration for generating the output audio.
	OutputAudioConfig *OutputAudioConfig `json:"outputAudioConfig,omitempty"`
	// RemoteDialogflowQueryParameters: Optional. QueryParameters
	// (https://cloud.google.com/dialogflow/cx/docs/reference/rpc/google.cloud.dialogflow.cx.v3#queryparameters)
	// to send to the remote Dialogflow
	// (https://cloud.google.com/dialogflow/cx/docs/concept/console-conversational-agents)
	// agent when the session control is transferred to the remote agent.
	RemoteDialogflowQueryParameters *SessionConfigRemoteDialogflowQueryParameters `json:"remoteDialogflowQueryParameters,omitempty"`
	// TimeZone: Optional. The time zone of the user. If provided, the agent will
	// use the time zone for date and time related variables. Otherwise, the agent
	// will use the time zone specified in the App.time_zone_settings. The format
	// is the IANA Time Zone Database time zone, e.g. "America/Los_Angeles".
	TimeZone string `json:"timeZone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Deployment") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Deployment") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SessionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod SessionConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SessionConfigRemoteDialogflowQueryParameters: QueryParameters
// (https://cloud.google.com/dialogflow/cx/docs/reference/rpc/google.cloud.dialogflow.cx.v3#queryparameters)
// to send to the remote Dialogflow
// (https://cloud.google.com/dialogflow/cx/docs/concept/console-conversational-agents)
// agent when the session control is transferred to the remote agent.
type SessionConfigRemoteDialogflowQueryParameters struct {
	// EndUserMetadata: Optional. The end user metadata to be sent in
	// QueryParameters
	// (https://cloud.google.com/dialogflow/cx/docs/reference/rpc/google.cloud.dialogflow.cx.v3#queryparameters).
	EndUserMetadata googleapi.RawMessage `json:"endUserMetadata,omitempty"`
	// Payload: Optional. The payload to be sent in QueryParameters
	// (https://cloud.google.com/dialogflow/cx/docs/reference/rpc/google.cloud.dialogflow.cx.v3#queryparameters).
	Payload googleapi.RawMessage `json:"payload,omitempty"`
	// WebhookHeaders: Optional. The HTTP headers to be sent as webhook_headers in
	// QueryParameters
	// (https://cloud.google.com/dialogflow/cx/docs/reference/rpc/google.cloud.dialogflow.cx.v3#queryparameters).
	WebhookHeaders map[string]string `json:"webhookHeaders,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndUserMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndUserMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SessionConfigRemoteDialogflowQueryParameters) MarshalJSON() ([]byte, error) {
	type NoMethod SessionConfigRemoteDialogflowQueryParameters
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SessionInput: Input for the session.
type SessionInput struct {
	// Audio: Optional. Audio data from the end user.
	Audio string `json:"audio,omitempty"`
	// Blob: Optional. Blob data from the end user.
	Blob *Blob `json:"blob,omitempty"`
	// Dtmf: Optional. DTMF digits from the end user.
	Dtmf string `json:"dtmf,omitempty"`
	// Event: Optional. Event input.
	Event *Event `json:"event,omitempty"`
	// Image: Optional. Image data from the end user.
	Image *Image `json:"image,omitempty"`
	// Text: Optional. Text data from the end user.
	Text string `json:"text,omitempty"`
	// ToolResponses: Optional. Execution results for the tool calls from the
	// client.
	ToolResponses *ToolResponses `json:"toolResponses,omitempty"`
	// Variables: Optional. Contextual variables for the session, keyed by name.
	// Only variables declared in the app will be used by the CES agent.
	// Unrecognized variables will still be sent to the Dialogflow agent as
	// additional session parameters.
	Variables googleapi.RawMessage `json:"variables,omitempty"`
	// WillContinue: Optional. A flag to indicate if the current message is a
	// fragment of a larger input in the bidi streaming session. When `true`, the
	// agent will defer processing until a subsequent message with `will_continue`
	// set to `false` is received. Note: This flag has no effect on audio and DTMF
	// inputs, which are always processed in real-time.
	WillContinue bool `json:"willContinue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Audio") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Audio") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SessionInput) MarshalJSON() ([]byte, error) {
	type NoMethod SessionInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SessionOutput: Output for the session.
type SessionOutput struct {
	// Audio: Output audio from the CES agent.
	Audio string `json:"audio,omitempty"`
	// Citations: Citations that provide the source information for the agent's
	// generated text.
	Citations *Citations `json:"citations,omitempty"`
	// DiagnosticInfo: Optional. Diagnostic information contains execution details
	// during the processing of the input. Only populated in the last SessionOutput
	// (with `turn_completed=true`) for each turn.
	DiagnosticInfo *SessionOutputDiagnosticInfo `json:"diagnosticInfo,omitempty"`
	// EndSession: Indicates the session has ended.
	EndSession *EndSession `json:"endSession,omitempty"`
	// GoogleSearchSuggestions: The suggestions returned from Google Search as a
	// result of invoking the GoogleSearchTool.
	GoogleSearchSuggestions *GoogleSearchSuggestions `json:"googleSearchSuggestions,omitempty"`
	// Payload: Custom payload with structured output from the CES agent.
	Payload googleapi.RawMessage `json:"payload,omitempty"`
	// Text: Output text from the CES agent.
	Text string `json:"text,omitempty"`
	// ToolCalls: Request for the client to execute the tools.
	ToolCalls *ToolCalls `json:"toolCalls,omitempty"`
	// TurnCompleted: If true, the CES agent has detected the end of the current
	// conversation turn and will provide no further output for this turn.
	TurnCompleted bool `json:"turnCompleted,omitempty"`
	// TurnIndex: Indicates the sequential order of conversation turn to which this
	// output belongs to, starting from 1.
	TurnIndex int64 `json:"turnIndex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Audio") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Audio") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SessionOutput) MarshalJSON() ([]byte, error) {
	type NoMethod SessionOutput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SessionOutputDiagnosticInfo: Contains execution details during the
// processing.
type SessionOutputDiagnosticInfo struct {
	// Messages: List of the messages that happened during the processing.
	Messages []*Message `json:"messages,omitempty"`
	// RootSpan: A trace of the entire request processing, represented as a root
	// span. This span can contain nested child spans for specific operations.
	RootSpan *Span `json:"rootSpan,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Messages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Messages") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SessionOutputDiagnosticInfo) MarshalJSON() ([]byte, error) {
	type NoMethod SessionOutputDiagnosticInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Span: A span is a unit of work or a single operation during the request
// processing.
type Span struct {
	// Attributes: Output only. Key-value attributes associated with the span.
	Attributes googleapi.RawMessage `json:"attributes,omitempty"`
	// ChildSpans: Output only. The child spans that are nested under this span.
	ChildSpans []*Span `json:"childSpans,omitempty"`
	// Duration: Output only. The duration of the span.
	Duration string `json:"duration,omitempty"`
	// EndTime: Output only. The end time of the span.
	EndTime string `json:"endTime,omitempty"`
	// Name: Output only. The name of the span.
	Name string `json:"name,omitempty"`
	// StartTime: Output only. The start time of the span.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Attributes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Attributes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Span) MarshalJSON() ([]byte, error) {
	type NoMethod Span
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Status: The `Status` type defines a logical error model that is suitable for
// different programming environments, including REST APIs and RPC APIs. It is
// used by gRPC (https://github.com/grpc). Each `Status` message contains three
// pieces of data: error code, error message, and error details. You can find
// out more about this error model and how to work with it in the API Design
// Guide (https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SynthesizeSpeechConfig: Configuration for how the agent response should be
// synthesized.
type SynthesizeSpeechConfig struct {
	// SpeakingRate: Optional. The speaking rate/speed in the range [0.25, 2.0].
	// 1.0 is the normal native speed supported by the specific voice. 2.0 is twice
	// as fast, and 0.5 is half as fast. Values outside of the range [0.25, 2.0]
	// will return an error.
	SpeakingRate float64 `json:"speakingRate,omitempty"`
	// Voice: Optional. The name of the voice. If not set, the service will choose
	// a voice based on the other parameters such as language_code. For the list of
	// available voices, please refer to Supported voices and languages
	// (https://cloud.google.com/text-to-speech/docs/voices) from Cloud
	// Text-to-Speech.
	Voice string `json:"voice,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SpeakingRate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SpeakingRate") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SynthesizeSpeechConfig) MarshalJSON() ([]byte, error) {
	type NoMethod SynthesizeSpeechConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *SynthesizeSpeechConfig) UnmarshalJSON(data []byte) error {
	type NoMethod SynthesizeSpeechConfig
	var s1 struct {
		SpeakingRate gensupport.JSONFloat64 `json:"speakingRate"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SpeakingRate = float64(s1.SpeakingRate)
	return nil
}

// SystemTool: Pre-defined system tool.
type SystemTool struct {
	// Description: Output only. The description of the system tool.
	Description string `json:"description,omitempty"`
	// Name: Required. The name of the system tool.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SystemTool) MarshalJSON() ([]byte, error) {
	type NoMethod SystemTool
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TimeZoneSettings: TimeZone settings of the app.
type TimeZoneSettings struct {
	// TimeZone: Optional. The time zone of the app from the time zone database
	// (https://www.iana.org/time-zones), e.g., America/Los_Angeles, Europe/Paris.
	TimeZone string `json:"timeZone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TimeZone") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TimeZone") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TimeZoneSettings) MarshalJSON() ([]byte, error) {
	type NoMethod TimeZoneSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TlsConfig: The TLS configuration.
type TlsConfig struct {
	// CaCerts: Required. Specifies a list of allowed custom CA certificates for
	// HTTPS verification.
	CaCerts []*TlsConfigCaCert `json:"caCerts,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CaCerts") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CaCerts") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TlsConfig) MarshalJSON() ([]byte, error) {
	type NoMethod TlsConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TlsConfigCaCert: The CA certificate.
type TlsConfigCaCert struct {
	// Cert: Required. The allowed custom CA certificates (in DER format) for HTTPS
	// verification. This overrides the default SSL trust store. If this is empty
	// or unspecified, CES will use Google's default trust store to verify
	// certificates. N.B. Make sure the HTTPS server certificates are signed with
	// "subject alt name". For instance a certificate can be self-signed using the
	// following command, openssl x509 -req -days 200 -in example.com.csr \
	// -signkey example.com.key \ -out example.com.crt \ -extfile <(printf
	// "\nsubjectAltName='DNS:www.example.com'")
	Cert string `json:"cert,omitempty"`
	// DisplayName: Required. The name of the allowed custom CA certificates. This
	// can be used to disambiguate the custom CA certificates.
	DisplayName string `json:"displayName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cert") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cert") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TlsConfigCaCert) MarshalJSON() ([]byte, error) {
	type NoMethod TlsConfigCaCert
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Tool: A tool represents an action that the CES agent can take to achieve
// certain goals.
type Tool struct {
	// ClientFunction: Optional. The client function.
	ClientFunction *ClientFunction `json:"clientFunction,omitempty"`
	// ConnectorTool: Optional. The Integration Connector tool.
	ConnectorTool *ConnectorTool `json:"connectorTool,omitempty"`
	// CreateTime: Output only. Timestamp when the tool was created.
	CreateTime string `json:"createTime,omitempty"`
	// DataStoreTool: Optional. The data store tool.
	DataStoreTool *DataStoreTool `json:"dataStoreTool,omitempty"`
	// DisplayName: Output only. The display name of the tool, derived based on the
	// tool's type. For example, display name of a ClientFunction is derived from
	// its `name` property.
	DisplayName string `json:"displayName,omitempty"`
	// Etag: Etag used to ensure the object hasn't changed during a
	// read-modify-write operation. If the etag is empty, the update will overwrite
	// any concurrent changes.
	Etag string `json:"etag,omitempty"`
	// ExecutionType: Optional. The execution type of the tool.
	//
	// Possible values:
	//   "EXECUTION_TYPE_UNSPECIFIED" - The execution type is unspecified. Defaults
	// to `SYNCHRONOUS` if unspecified.
	//   "SYNCHRONOUS" - The tool is executed synchronously. The session is blocked
	// until the tool returns.
	//   "ASYNCHRONOUS" - The tool is executed asynchronously. The session will
	// continue while the tool is executing.
	ExecutionType string `json:"executionType,omitempty"`
	// FileSearchTool: Optional. The file search tool.
	FileSearchTool *FileSearchTool `json:"fileSearchTool,omitempty"`
	// GeneratedSummary: Output only. If the tool is generated by the LLM
	// assistant, this field contains a descriptive summary of the generation.
	GeneratedSummary string `json:"generatedSummary,omitempty"`
	// GoogleSearchTool: Optional. The google search tool.
	GoogleSearchTool *GoogleSearchTool `json:"googleSearchTool,omitempty"`
	// McpTool: Optional. The MCP tool. An MCP tool cannot be created or updated
	// directly and is managed by the MCP toolset.
	McpTool *McpTool `json:"mcpTool,omitempty"`
	// Name: Identifier. The unique identifier of the tool. Format: -
	// `projects/{project}/locations/{location}/apps/{app}/tools/{tool}` for ##
	// standalone tools.
	// `projects/{project}/locations/{location}/apps/{app}/toolsets/{toolset}/tools/
	// {tool}` for tools retrieved from a toolset. These tools are dynamic and
	// output-only, they cannot be referenced directly where a tool is expected.
	Name string `json:"name,omitempty"`
	// OpenApiTool: Optional. The open API tool.
	OpenApiTool *OpenApiTool `json:"openApiTool,omitempty"`
	// PythonFunction: Optional. The python function tool.
	PythonFunction *PythonFunction `json:"pythonFunction,omitempty"`
	// SystemTool: Optional. The system tool.
	SystemTool *SystemTool `json:"systemTool,omitempty"`
	// ToolFakeConfig: Optional. Configuration for tool behavior in fake mode.
	ToolFakeConfig *ToolFakeConfig `json:"toolFakeConfig,omitempty"`
	// UpdateTime: Output only. Timestamp when the tool was last updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// WidgetTool: Optional. The widget tool.
	WidgetTool *WidgetTool `json:"widgetTool,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ClientFunction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClientFunction") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Tool) MarshalJSON() ([]byte, error) {
	type NoMethod Tool
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ToolCall: Request for the client or the agent to execute the specified tool.
type ToolCall struct {
	// Args: Optional. The input parameters and values for the tool in JSON object
	// format.
	Args googleapi.RawMessage `json:"args,omitempty"`
	// DisplayName: Output only. Display name of the tool.
	DisplayName string `json:"displayName,omitempty"`
	// Id: Optional. The unique identifier of the tool call. If populated, the
	// client should return the execution result with the matching ID in
	// ToolResponse.
	Id string `json:"id,omitempty"`
	// Tool: Optional. The name of the tool to execute. Format:
	// `projects/{project}/locations/{location}/apps/{app}/tools/{tool}`
	Tool string `json:"tool,omitempty"`
	// ToolsetTool: Optional. The toolset tool to execute.
	ToolsetTool *ToolsetTool `json:"toolsetTool,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Args") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Args") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ToolCall) MarshalJSON() ([]byte, error) {
	type NoMethod ToolCall
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ToolCalls: Request for the client to execute the tools and return the
// execution results before continuing the session.
type ToolCalls struct {
	// ToolCalls: Optional. The list of tool calls to execute.
	ToolCalls []*ToolCall `json:"toolCalls,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ToolCalls") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ToolCalls") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ToolCalls) MarshalJSON() ([]byte, error) {
	type NoMethod ToolCalls
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ToolFakeConfig: Configuration for tool behavior in fake mode.
type ToolFakeConfig struct {
	// CodeBlock: Optional. Code block which will be executed instead of a real
	// tool call.
	CodeBlock *CodeBlock `json:"codeBlock,omitempty"`
	// EnableFakeMode: Optional. Whether the tool is using fake mode.
	EnableFakeMode bool `json:"enableFakeMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CodeBlock") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CodeBlock") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ToolFakeConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ToolFakeConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ToolResponse: The execution result of a specific tool from the client or the
// agent.
type ToolResponse struct {
	// DisplayName: Output only. Display name of the tool.
	DisplayName string `json:"displayName,omitempty"`
	// Id: Optional. The matching ID of the tool call the response is for.
	Id string `json:"id,omitempty"`
	// Response: Required. The tool execution result in JSON object format. Use
	// "output" key to specify tool response and "error" key to specify error
	// details (if any). If "output" and "error" keys are not specified, then whole
	// "response" is treated as tool execution result.
	Response googleapi.RawMessage `json:"response,omitempty"`
	// Tool: Optional. The name of the tool to execute. Format:
	// `projects/{project}/locations/{location}/apps/{app}/tools/{tool}`
	Tool string `json:"tool,omitempty"`
	// ToolsetTool: Optional. The toolset tool that got executed.
	ToolsetTool *ToolsetTool `json:"toolsetTool,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ToolResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ToolResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ToolResponses: Execution results for the requested tool calls from the
// client.
type ToolResponses struct {
	// ToolResponses: Optional. The list of tool execution results.
	ToolResponses []*ToolResponse `json:"toolResponses,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ToolResponses") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ToolResponses") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ToolResponses) MarshalJSON() ([]byte, error) {
	type NoMethod ToolResponses
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Toolset: A toolset represents a group of dynamically managed tools that can
// be used by the agent.
type Toolset struct {
	// ConnectorToolset: Optional. A toolset that generates tools from an
	// Integration Connectors Connection.
	ConnectorToolset *ConnectorToolset `json:"connectorToolset,omitempty"`
	// CreateTime: Output only. Timestamp when the toolset was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. The description of the toolset.
	Description string `json:"description,omitempty"`
	// DisplayName: Optional. The display name of the toolset. Must be unique
	// within the same app.
	DisplayName string `json:"displayName,omitempty"`
	// Etag: ETag used to ensure the object hasn't changed during a
	// read-modify-write operation. If the etag is empty, the update will overwrite
	// any concurrent changes.
	Etag string `json:"etag,omitempty"`
	// ExecutionType: Optional. The execution type of the tools in the toolset.
	//
	// Possible values:
	//   "EXECUTION_TYPE_UNSPECIFIED" - The execution type is unspecified. Defaults
	// to `SYNCHRONOUS` if unspecified.
	//   "SYNCHRONOUS" - The tool is executed synchronously. The session is blocked
	// until the tool returns.
	//   "ASYNCHRONOUS" - The tool is executed asynchronously. The session will
	// continue while the tool is executing.
	ExecutionType string `json:"executionType,omitempty"`
	// McpToolset: Optional. A toolset that contains a list of tools that are
	// offered by the MCP server.
	McpToolset *McpToolset `json:"mcpToolset,omitempty"`
	// Name: Identifier. The unique identifier of the toolset. Format:
	// `projects/{project}/locations/{location}/apps/{app}/toolsets/{toolset}`
	Name string `json:"name,omitempty"`
	// OpenApiToolset: Optional. A toolset that contains a list of tools that are
	// defined by an OpenAPI schema.
	OpenApiToolset *OpenApiToolset `json:"openApiToolset,omitempty"`
	// ToolFakeConfig: Optional. Configuration for tools behavior in fake mode.
	ToolFakeConfig *ToolFakeConfig `json:"toolFakeConfig,omitempty"`
	// UpdateTime: Output only. Timestamp when the toolset was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ConnectorToolset") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConnectorToolset") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Toolset) MarshalJSON() ([]byte, error) {
	type NoMethod Toolset
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ToolsetTool: A tool that is created from a toolset.
type ToolsetTool struct {
	// ToolId: Optional. The tool ID to filter the tools to retrieve the schema
	// for.
	ToolId string `json:"toolId,omitempty"`
	// Toolset: Required. The resource name of the Toolset from which this tool is
	// derived. Format:
	// `projects/{project}/locations/{location}/apps/{app}/toolsets/{toolset}`
	Toolset string `json:"toolset,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ToolId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ToolId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ToolsetTool) MarshalJSON() ([]byte, error) {
	type NoMethod ToolsetTool
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TransferRule: Rule for transferring to a specific agent.
type TransferRule struct {
	// ChildAgent: Required. The resource name of the child agent the rule applies
	// to. Format:
	// `projects/{project}/locations/{location}/apps/{app}/agents/{agent}`
	ChildAgent string `json:"childAgent,omitempty"`
	// DeterministicTransfer: Optional. A rule that immediately transfers to the
	// target agent when the condition is met.
	DeterministicTransfer *TransferRuleDeterministicTransfer `json:"deterministicTransfer,omitempty"`
	// Direction: Required. The direction of the transfer.
	//
	// Possible values:
	//   "DIRECTION_UNSPECIFIED" - Unspecified direction.
	//   "PARENT_TO_CHILD" - Transfer from the parent agent to the child agent.
	//   "CHILD_TO_PARENT" - Transfer from the child agent to the parent agent.
	Direction string `json:"direction,omitempty"`
	// DisablePlannerTransfer: Optional. Rule that prevents the planner from
	// transferring to the target agent.
	DisablePlannerTransfer *TransferRuleDisablePlannerTransfer `json:"disablePlannerTransfer,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChildAgent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChildAgent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TransferRule) MarshalJSON() ([]byte, error) {
	type NoMethod TransferRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TransferRuleDeterministicTransfer: Deterministic transfer rule. When the
// condition evaluates to true, the transfer occurs.
type TransferRuleDeterministicTransfer struct {
	// ExpressionCondition: Optional. A rule that evaluates a session state
	// condition. If the condition evaluates to true, the transfer occurs.
	ExpressionCondition *ExpressionCondition `json:"expressionCondition,omitempty"`
	// PythonCodeCondition: Optional. A rule that uses Python code block to
	// evaluate the conditions. If the condition evaluates to true, the transfer
	// occurs.
	PythonCodeCondition *PythonCodeCondition `json:"pythonCodeCondition,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExpressionCondition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExpressionCondition") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TransferRuleDeterministicTransfer) MarshalJSON() ([]byte, error) {
	type NoMethod TransferRuleDeterministicTransfer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TransferRuleDisablePlannerTransfer: A rule that prevents the planner from
// transferring to the target agent.
type TransferRuleDisablePlannerTransfer struct {
	// ExpressionCondition: Required. If the condition evaluates to true, planner
	// will not be allowed to transfer to the target agent.
	ExpressionCondition *ExpressionCondition `json:"expressionCondition,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExpressionCondition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExpressionCondition") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TransferRuleDisablePlannerTransfer) MarshalJSON() ([]byte, error) {
	type NoMethod TransferRuleDisablePlannerTransfer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TriggerAction: Action that is taken when a certain precondition is met.
type TriggerAction struct {
	// GenerativeAnswer: Optional. Respond with a generative answer.
	GenerativeAnswer *TriggerActionGenerativeAnswer `json:"generativeAnswer,omitempty"`
	// RespondImmediately: Optional. Immediately respond with a preconfigured
	// response.
	RespondImmediately *TriggerActionRespondImmediately `json:"respondImmediately,omitempty"`
	// TransferAgent: Optional. Transfer the conversation to a different agent.
	TransferAgent *TriggerActionTransferAgent `json:"transferAgent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenerativeAnswer") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenerativeAnswer") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TriggerAction) MarshalJSON() ([]byte, error) {
	type NoMethod TriggerAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TriggerActionGenerativeAnswer: The agent will immediately respond with a
// generative answer.
type TriggerActionGenerativeAnswer struct {
	// Prompt: Required. The prompt to use for the generative answer.
	Prompt string `json:"prompt,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Prompt") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Prompt") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TriggerActionGenerativeAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod TriggerActionGenerativeAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TriggerActionRespondImmediately: The agent will immediately respond with a
// preconfigured response.
type TriggerActionRespondImmediately struct {
	// Responses: Required. The canned responses for the agent to choose from. The
	// response is chosen randomly.
	Responses []*TriggerActionResponse `json:"responses,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Responses") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Responses") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TriggerActionRespondImmediately) MarshalJSON() ([]byte, error) {
	type NoMethod TriggerActionRespondImmediately
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TriggerActionResponse: Represents a response from the agent.
type TriggerActionResponse struct {
	// Disabled: Optional. Whether the response is disabled. Disabled responses are
	// not used by the agent.
	Disabled bool `json:"disabled,omitempty"`
	// Text: Required. Text for the agent to respond with.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Disabled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Disabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TriggerActionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod TriggerActionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TriggerActionTransferAgent: The agent will transfer the conversation to a
// different agent.
type TriggerActionTransferAgent struct {
	// Agent: Required. The name of the agent to transfer the conversation to. The
	// agent must be in the same app as the current agent. Format:
	// `projects/{project}/locations/{location}/apps/{app}/agents/{agent}`
	Agent string `json:"agent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Agent") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Agent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TriggerActionTransferAgent) MarshalJSON() ([]byte, error) {
	type NoMethod TriggerActionTransferAgent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WebSearchQuery: Represents a single web search query and its associated
// search uri.
type WebSearchQuery struct {
	// Query: The search query text.
	Query string `json:"query,omitempty"`
	// Uri: The URI to the Google Search results page for the query.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Query") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Query") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WebSearchQuery) MarshalJSON() ([]byte, error) {
	type NoMethod WebSearchQuery
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WidgetTool: Represents a widget tool that the agent can invoke. When the
// tool is chosen by the agent, agent will return the widget to the client. The
// client is responsible for processing the widget and generating the next user
// query to continue the interaction with the agent.
type WidgetTool struct {
	// Description: Optional. The description of the widget tool.
	Description string `json:"description,omitempty"`
	// Name: Required. The display name of the widget tool.
	Name string `json:"name,omitempty"`
	// Parameters: Optional. The input parameters of the widget tool.
	Parameters *Schema `json:"parameters,omitempty"`
	// WidgetType: Optional. The type of the widget tool. If not specified, the
	// default type will be CUSTOMIZED.
	//
	// Possible values:
	//   "WIDGET_TYPE_UNSPECIFIED" - Unspecified widget type.
	//   "CUSTOM" - Custom widget type.
	//   "PRODUCT_CAROUSEL" - Product carousel widget.
	//   "PRODUCT_DETAILS" - Product details widget.
	//   "QUICK_ACTIONS" - Quick actions widget.
	//   "PRODUCT_COMPARISON" - Product comparison widget.
	//   "ADVANCED_PRODUCT_DETAILS" - Advanced product details widget.
	//   "SHORT_FORM" - Short form widget.
	//   "OVERALL_SATISFACTION" - Overall satisfaction widget.
	//   "ORDER_SUMMARY" - Order summary widget.
	//   "APPOINTMENT_DETAILS" - Appointment details widget.
	WidgetType string `json:"widgetType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WidgetTool) MarshalJSON() ([]byte, error) {
	type NoMethod WidgetTool
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProjectsLocationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a location.
//
// - name: Resource name for the location.
func (r *ProjectsLocationsService) Get(name string) *ProjectsLocationsGetCall {
	c := &ProjectsLocationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGetCall) Context(ctx context.Context) *ProjectsLocationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Location.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGetCall) Do(opts ...googleapi.CallOption) (*Location, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Location{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists information about the supported locations for this service. This
// method can be called in two ways: * **List all public locations:** Use the
// path `GET /v1/locations`. * **List project-visible locations:** Use the path
// `GET /v1/projects/{project_id}/locations`. This may include public locations
// as well as private or other locations specifically visible to the project.
//
// - name: The resource that owns the locations collection, if applicable.
func (r *ProjectsLocationsService) List(name string) *ProjectsLocationsListCall {
	c := &ProjectsLocationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ExtraLocationTypes sets the optional parameter "extraLocationTypes": Do not
// use this field. It is unsupported and is ignored unless explicitly
// documented otherwise. This is primarily for internal usage.
func (c *ProjectsLocationsListCall) ExtraLocationTypes(extraLocationTypes ...string) *ProjectsLocationsListCall {
	c.urlParams_.SetMulti("extraLocationTypes", append([]string{}, extraLocationTypes...))
	return c
}

// Filter sets the optional parameter "filter": A filter to narrow down results
// to a preferred subset. The filtering language accepts strings like
// "displayName=tokyo", and is documented in more detail in AIP-160
// (https://google.aip.dev/160).
func (c *ProjectsLocationsListCall) Filter(filter string) *ProjectsLocationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return. If not set, the service selects a default.
func (c *ProjectsLocationsListCall) PageSize(pageSize int64) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from the `next_page_token` field in the response. Send that page token to
// receive the subsequent page.
func (c *ProjectsLocationsListCall) PageToken(pageToken string) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsListCall) Context(ctx context.Context) *ProjectsLocationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/locations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListLocationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsListCall) Do(opts ...googleapi.CallOption) (*ListLocationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListLocationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsListCall) Pages(ctx context.Context, f func(*ListLocationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAppsCreateCall struct {
	s          *Service
	parent     string
	app        *App
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new app in the given project and location.
//
// - parent: The resource name of the location to create an app in.
func (r *ProjectsLocationsAppsService) Create(parent string, app *App) *ProjectsLocationsAppsCreateCall {
	c := &ProjectsLocationsAppsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.app = app
	return c
}

// AppId sets the optional parameter "appId": The ID to use for the app, which
// will become the final component of the app's resource name. If not provided,
// a unique ID will be automatically assigned for the app.
func (c *ProjectsLocationsAppsCreateCall) AppId(appId string) *ProjectsLocationsAppsCreateCall {
	c.urlParams_.Set("appId", appId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsCreateCall) Context(ctx context.Context) *ProjectsLocationsAppsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.app)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/apps")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAppsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAppsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified app.
//
// - name: The resource name of the app to delete.
func (r *ProjectsLocationsAppsService) Delete(name string) *ProjectsLocationsAppsDeleteCall {
	c := &ProjectsLocationsAppsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": The current etag of the app. If an
// etag is not provided, the deletion will overwrite any concurrent changes. If
// an etag is provided and does not match the current etag of the app, deletion
// will be blocked and an ABORTED error will be returned.
func (c *ProjectsLocationsAppsDeleteCall) Etag(etag string) *ProjectsLocationsAppsDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsDeleteCall) Context(ctx context.Context) *ProjectsLocationsAppsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAppsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAppsExecuteToolCall struct {
	s                  *Service
	parent             string
	executetoolrequest *ExecuteToolRequest
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// ExecuteTool: Executes the given tool with the given arguments.
//
//   - parent: The resource name of the app which the tool/toolset belongs to.
//     Format: `projects/{project}/locations/{location}/apps/{app}`.
func (r *ProjectsLocationsAppsService) ExecuteTool(parent string, executetoolrequest *ExecuteToolRequest) *ProjectsLocationsAppsExecuteToolCall {
	c := &ProjectsLocationsAppsExecuteToolCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.executetoolrequest = executetoolrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsExecuteToolCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsExecuteToolCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsExecuteToolCall) Context(ctx context.Context) *ProjectsLocationsAppsExecuteToolCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsExecuteToolCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsExecuteToolCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.executetoolrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}:executeTool")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.executeTool", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.executeTool" call.
// Any non-2xx status code is an error. Response headers are in either
// *ExecuteToolResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAppsExecuteToolCall) Do(opts ...googleapi.CallOption) (*ExecuteToolResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ExecuteToolResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.executeTool", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAppsExportAppCall struct {
	s                *Service
	name             string
	exportapprequest *ExportAppRequest
	urlParams_       gensupport.URLParams
	ctx_             context.Context
	header_          http.Header
}

// ExportApp: Exports the specified app.
//
// - name: The resource name of the app to export.
func (r *ProjectsLocationsAppsService) ExportApp(name string, exportapprequest *ExportAppRequest) *ProjectsLocationsAppsExportAppCall {
	c := &ProjectsLocationsAppsExportAppCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.exportapprequest = exportapprequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsExportAppCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsExportAppCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsExportAppCall) Context(ctx context.Context) *ProjectsLocationsAppsExportAppCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsExportAppCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsExportAppCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.exportapprequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:exportApp")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.exportApp", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.exportApp" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAppsExportAppCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.exportApp", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAppsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of the specified app.
//
// - name: The resource name of the app to retrieve.
func (r *ProjectsLocationsAppsService) Get(name string) *ProjectsLocationsAppsGetCall {
	c := &ProjectsLocationsAppsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAppsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsAppsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsGetCall) Context(ctx context.Context) *ProjectsLocationsAppsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *App.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAppsGetCall) Do(opts ...googleapi.CallOption) (*App, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &App{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAppsImportAppCall struct {
	s                *Service
	parent           string
	importapprequest *ImportAppRequest
	urlParams_       gensupport.URLParams
	ctx_             context.Context
	header_          http.Header
}

// ImportApp: Imports the specified app.
//
// - parent: The parent resource name with the location of the app to import.
func (r *ProjectsLocationsAppsService) ImportApp(parent string, importapprequest *ImportAppRequest) *ProjectsLocationsAppsImportAppCall {
	c := &ProjectsLocationsAppsImportAppCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.importapprequest = importapprequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsImportAppCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsImportAppCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsImportAppCall) Context(ctx context.Context) *ProjectsLocationsAppsImportAppCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsImportAppCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsImportAppCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.importapprequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/apps:importApp")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.importApp", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.importApp" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAppsImportAppCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.importApp", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAppsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists apps in the given project and location.
//
// - parent: The resource name of the location to list apps from.
func (r *ProjectsLocationsAppsService) List(parent string) *ProjectsLocationsAppsListCall {
	c := &ProjectsLocationsAppsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter to be applied when
// listing the apps. See https://google.aip.dev/160 for more details.
func (c *ProjectsLocationsAppsListCall) Filter(filter string) *ProjectsLocationsAppsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Field to sort by. Only "name"
// and "create_time" is supported. See https://google.aip.dev/132#ordering for
// more details.
func (c *ProjectsLocationsAppsListCall) OrderBy(orderBy string) *ProjectsLocationsAppsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. Server
// may return fewer items than requested. If unspecified, server will pick an
// appropriate default.
func (c *ProjectsLocationsAppsListCall) PageSize(pageSize int64) *ProjectsLocationsAppsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The next_page_token value
// returned from a previous list AgentService.ListApps call.
func (c *ProjectsLocationsAppsListCall) PageToken(pageToken string) *ProjectsLocationsAppsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAppsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAppsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsListCall) Context(ctx context.Context) *ProjectsLocationsAppsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/apps")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAppsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAppsListCall) Do(opts ...googleapi.CallOption) (*ListAppsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAppsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAppsListCall) Pages(ctx context.Context, f func(*ListAppsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAppsPatchCall struct {
	s          *Service
	nameid     string
	app        *App
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the specified app.
//
//   - name: Identifier. The unique identifier of the app. Format:
//     `projects/{project}/locations/{location}/apps/{app}`.
func (r *ProjectsLocationsAppsService) Patch(nameid string, app *App) *ProjectsLocationsAppsPatchCall {
	c := &ProjectsLocationsAppsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	c.app = app
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask is used to
// control which fields get updated. If the mask is not present, all fields
// will be updated.
func (c *ProjectsLocationsAppsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsAppsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsPatchCall) Context(ctx context.Context) *ProjectsLocationsAppsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.app)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *App.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAppsPatchCall) Do(opts ...googleapi.CallOption) (*App, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &App{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAppsRetrieveToolSchemaCall struct {
	s                         *Service
	parent                    string
	retrievetoolschemarequest *RetrieveToolSchemaRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// RetrieveToolSchema: Retrieve the schema of the given tool. The schema is
// computed on the fly for the given instance of the tool.
//
//   - parent: The resource name of the app which the tool/toolset belongs to.
//     Format: `projects/{project}/locations/{location}/apps/{app}`.
func (r *ProjectsLocationsAppsService) RetrieveToolSchema(parent string, retrievetoolschemarequest *RetrieveToolSchemaRequest) *ProjectsLocationsAppsRetrieveToolSchemaCall {
	c := &ProjectsLocationsAppsRetrieveToolSchemaCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.retrievetoolschemarequest = retrievetoolschemarequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsRetrieveToolSchemaCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsRetrieveToolSchemaCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsRetrieveToolSchemaCall) Context(ctx context.Context) *ProjectsLocationsAppsRetrieveToolSchemaCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsRetrieveToolSchemaCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsRetrieveToolSchemaCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.retrievetoolschemarequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}:retrieveToolSchema")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.retrieveToolSchema", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.retrieveToolSchema" call.
// Any non-2xx status code is an error. Response headers are in either
// *RetrieveToolSchemaResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAppsRetrieveToolSchemaCall) Do(opts ...googleapi.CallOption) (*RetrieveToolSchemaResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RetrieveToolSchemaResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.retrieveToolSchema", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAppsAgentsCreateCall struct {
	s          *Service
	parent     string
	agent      *Agent
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new agent in the given app.
//
// - parent: The resource name of the app to create an agent in.
func (r *ProjectsLocationsAppsAgentsService) Create(parent string, agent *Agent) *ProjectsLocationsAppsAgentsCreateCall {
	c := &ProjectsLocationsAppsAgentsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.agent = agent
	return c
}

// AgentId sets the optional parameter "agentId": The ID to use for the agent,
// which will become the final component of the agent's resource name. If not
// provided, a unique ID will be automatically assigned for the agent.
func (c *ProjectsLocationsAppsAgentsCreateCall) AgentId(agentId string) *ProjectsLocationsAppsAgentsCreateCall {
	c.urlParams_.Set("agentId", agentId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsAgentsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsAgentsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsAgentsCreateCall) Context(ctx context.Context) *ProjectsLocationsAppsAgentsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsAgentsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsAgentsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.agent)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/agents")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.agents.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.agents.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Agent.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAppsAgentsCreateCall) Do(opts ...googleapi.CallOption) (*Agent, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Agent{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.agents.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAppsAgentsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified agent.
//
// - name: The resource name of the agent to delete.
func (r *ProjectsLocationsAppsAgentsService) Delete(name string) *ProjectsLocationsAppsAgentsDeleteCall {
	c := &ProjectsLocationsAppsAgentsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": The current etag of the agent. If
// an etag is not provided, the deletion will overwrite any concurrent changes.
// If an etag is provided and does not match the current etag of the agent,
// deletion will be blocked and an ABORTED error will be returned.
func (c *ProjectsLocationsAppsAgentsDeleteCall) Etag(etag string) *ProjectsLocationsAppsAgentsDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// Force sets the optional parameter "force": Indicates whether to forcefully
// delete the agent, even if it is still referenced by other
// app/agents/examples. * If `force = false`, the deletion fails if other
// agents/examples reference it. * If `force = true`, delete the agent and
// remove it from all referencing apps/agents/examples.
func (c *ProjectsLocationsAppsAgentsDeleteCall) Force(force bool) *ProjectsLocationsAppsAgentsDeleteCall {
	c.urlParams_.Set("force", fmt.Sprint(force))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsAgentsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsAgentsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsAgentsDeleteCall) Context(ctx context.Context) *ProjectsLocationsAppsAgentsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsAgentsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsAgentsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.agents.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.agents.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAppsAgentsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.agents.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAppsAgentsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of the specified agent.
//
// - name: The resource name of the agent to retrieve.
func (r *ProjectsLocationsAppsAgentsService) Get(name string) *ProjectsLocationsAppsAgentsGetCall {
	c := &ProjectsLocationsAppsAgentsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsAgentsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsAgentsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAppsAgentsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsAppsAgentsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsAgentsGetCall) Context(ctx context.Context) *ProjectsLocationsAppsAgentsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsAgentsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsAgentsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.agents.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.agents.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Agent.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAppsAgentsGetCall) Do(opts ...googleapi.CallOption) (*Agent, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Agent{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.agents.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAppsAgentsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists agents in the given app.
//
// - parent: The resource name of the app to list agents from.
func (r *ProjectsLocationsAppsAgentsService) List(parent string) *ProjectsLocationsAppsAgentsListCall {
	c := &ProjectsLocationsAppsAgentsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter to be applied when
// listing the agents. See https://google.aip.dev/160 for more details.
func (c *ProjectsLocationsAppsAgentsListCall) Filter(filter string) *ProjectsLocationsAppsAgentsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Field to sort by. Only "name"
// and "create_time" is supported. See https://google.aip.dev/132#ordering for
// more details.
func (c *ProjectsLocationsAppsAgentsListCall) OrderBy(orderBy string) *ProjectsLocationsAppsAgentsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. Server
// may return fewer items than requested. If unspecified, server will pick an
// appropriate default.
func (c *ProjectsLocationsAppsAgentsListCall) PageSize(pageSize int64) *ProjectsLocationsAppsAgentsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The next_page_token value
// returned from a previous list AgentService.ListAgents call.
func (c *ProjectsLocationsAppsAgentsListCall) PageToken(pageToken string) *ProjectsLocationsAppsAgentsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsAgentsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsAgentsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAppsAgentsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAppsAgentsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsAgentsListCall) Context(ctx context.Context) *ProjectsLocationsAppsAgentsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsAgentsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsAgentsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/agents")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.agents.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.agents.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAgentsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAppsAgentsListCall) Do(opts ...googleapi.CallOption) (*ListAgentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAgentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.agents.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAppsAgentsListCall) Pages(ctx context.Context, f func(*ListAgentsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAppsAgentsPatchCall struct {
	s          *Service
	nameid     string
	agent      *Agent
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the specified agent.
//
//   - name: Identifier. The unique identifier of the agent. Format:
//     `projects/{project}/locations/{location}/apps/{app}/agents/{agent}`.
func (r *ProjectsLocationsAppsAgentsService) Patch(nameid string, agent *Agent) *ProjectsLocationsAppsAgentsPatchCall {
	c := &ProjectsLocationsAppsAgentsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	c.agent = agent
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask is used to
// control which fields get updated. If the mask is not present, all fields
// will be updated.
func (c *ProjectsLocationsAppsAgentsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsAppsAgentsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsAgentsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsAgentsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsAgentsPatchCall) Context(ctx context.Context) *ProjectsLocationsAppsAgentsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsAgentsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsAgentsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.agent)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.agents.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.agents.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Agent.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAppsAgentsPatchCall) Do(opts ...googleapi.CallOption) (*Agent, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Agent{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.agents.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAppsChangelogsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the specified changelog.
//
// - name: The resource name of the changelog to retrieve.
func (r *ProjectsLocationsAppsChangelogsService) Get(name string) *ProjectsLocationsAppsChangelogsGetCall {
	c := &ProjectsLocationsAppsChangelogsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsChangelogsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsChangelogsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAppsChangelogsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsAppsChangelogsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsChangelogsGetCall) Context(ctx context.Context) *ProjectsLocationsAppsChangelogsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsChangelogsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsChangelogsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.changelogs.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.changelogs.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Changelog.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAppsChangelogsGetCall) Do(opts ...googleapi.CallOption) (*Changelog, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Changelog{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.changelogs.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAppsChangelogsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the changelogs of the specified app.
//
// - parent: The resource name of the app to list changelogs from.
func (r *ProjectsLocationsAppsChangelogsService) List(parent string) *ProjectsLocationsAppsChangelogsListCall {
	c := &ProjectsLocationsAppsChangelogsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter to be applied when
// listing the changelogs. See https://google.aip.dev/160 for more details. The
// filter string can be used to filter by `action`, `resource_type`,
// `resource_name`, `author`, and `create_time`. The `:` comparator can be used
// for case-insensitive partial matching on string fields, while `=` performs
// an exact case-sensitive match. Examples: * `action:update` (case-insensitive
// partial match) * `action="Create" (case-sensitive exact match) *
// `resource_type:agent` * `resource_name:my-agent` * `author:me@example.com` *
// `create_time > "2025-01-01T00:00:00Z" * `create_time <=
// "2025-01-01T00:00:00Z" AND resource_type:tool`
func (c *ProjectsLocationsAppsChangelogsListCall) Filter(filter string) *ProjectsLocationsAppsChangelogsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Field to sort by. Only "name"
// and "create_time" is supported. See https://google.aip.dev/132#ordering for
// more details.
func (c *ProjectsLocationsAppsChangelogsListCall) OrderBy(orderBy string) *ProjectsLocationsAppsChangelogsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. Server
// may return fewer items than requested. If unspecified, server will pick an
// appropriate default.
func (c *ProjectsLocationsAppsChangelogsListCall) PageSize(pageSize int64) *ProjectsLocationsAppsChangelogsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The next_page_token value
// returned from a previous list AgentService.ListChangelogs call.
func (c *ProjectsLocationsAppsChangelogsListCall) PageToken(pageToken string) *ProjectsLocationsAppsChangelogsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsChangelogsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsChangelogsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAppsChangelogsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAppsChangelogsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsChangelogsListCall) Context(ctx context.Context) *ProjectsLocationsAppsChangelogsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsChangelogsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsChangelogsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/changelogs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.changelogs.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.changelogs.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListChangelogsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAppsChangelogsListCall) Do(opts ...googleapi.CallOption) (*ListChangelogsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListChangelogsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.changelogs.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAppsChangelogsListCall) Pages(ctx context.Context, f func(*ListChangelogsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAppsConversationsBatchDeleteCall struct {
	s                               *Service
	parent                          string
	batchdeleteconversationsrequest *BatchDeleteConversationsRequest
	urlParams_                      gensupport.URLParams
	ctx_                            context.Context
	header_                         http.Header
}

// BatchDelete: Batch deletes the specified conversations.
//
//   - parent: The resource name of the app to delete conversations from. Format:
//     `projects/{project}/locations/{location}/apps/{app}`.
func (r *ProjectsLocationsAppsConversationsService) BatchDelete(parent string, batchdeleteconversationsrequest *BatchDeleteConversationsRequest) *ProjectsLocationsAppsConversationsBatchDeleteCall {
	c := &ProjectsLocationsAppsConversationsBatchDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.batchdeleteconversationsrequest = batchdeleteconversationsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsConversationsBatchDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsConversationsBatchDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsConversationsBatchDeleteCall) Context(ctx context.Context) *ProjectsLocationsAppsConversationsBatchDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsConversationsBatchDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsConversationsBatchDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.batchdeleteconversationsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/conversations:batchDelete")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.conversations.batchDelete", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.conversations.batchDelete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAppsConversationsBatchDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.conversations.batchDelete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAppsConversationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified conversation.
//
// - name: The resource name of the conversation to delete.
func (r *ProjectsLocationsAppsConversationsService) Delete(name string) *ProjectsLocationsAppsConversationsDeleteCall {
	c := &ProjectsLocationsAppsConversationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Source sets the optional parameter "source": Indicate the source of the
// conversation. If not set, Source.Live will be applied by default.
//
// Possible values:
//
//	"SOURCE_UNSPECIFIED" - Unspecified source.
//	"LIVE" - The conversation is from the live end user.
//	"SIMULATOR" - The conversation is from the simulator.
//	"EVAL" - The conversation is from the evaluation.
func (c *ProjectsLocationsAppsConversationsDeleteCall) Source(source string) *ProjectsLocationsAppsConversationsDeleteCall {
	c.urlParams_.Set("source", source)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsConversationsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsConversationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsConversationsDeleteCall) Context(ctx context.Context) *ProjectsLocationsAppsConversationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsConversationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsConversationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.conversations.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.conversations.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAppsConversationsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.conversations.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAppsConversationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of the specified conversation.
//
// - name: The resource name of the conversation to retrieve.
func (r *ProjectsLocationsAppsConversationsService) Get(name string) *ProjectsLocationsAppsConversationsGetCall {
	c := &ProjectsLocationsAppsConversationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Source sets the optional parameter "source": Indicate the source of the
// conversation. If not set, all source will be searched.
//
// Possible values:
//
//	"SOURCE_UNSPECIFIED" - Unspecified source.
//	"LIVE" - The conversation is from the live end user.
//	"SIMULATOR" - The conversation is from the simulator.
//	"EVAL" - The conversation is from the evaluation.
func (c *ProjectsLocationsAppsConversationsGetCall) Source(source string) *ProjectsLocationsAppsConversationsGetCall {
	c.urlParams_.Set("source", source)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsConversationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsConversationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAppsConversationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsAppsConversationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsConversationsGetCall) Context(ctx context.Context) *ProjectsLocationsAppsConversationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsConversationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsConversationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.conversations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.conversations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Conversation.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAppsConversationsGetCall) Do(opts ...googleapi.CallOption) (*Conversation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Conversation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.conversations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAppsConversationsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists conversations in the given app.
//
// - parent: The resource name of the app to list conversations from.
func (r *ProjectsLocationsAppsConversationsService) List(parent string) *ProjectsLocationsAppsConversationsListCall {
	c := &ProjectsLocationsAppsConversationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter to be applied when
// listing the conversations. See https://google.aip.dev/160 for more details.
func (c *ProjectsLocationsAppsConversationsListCall) Filter(filter string) *ProjectsLocationsAppsConversationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. Server
// may return fewer items than requested. If unspecified, server will pick an
// appropriate default.
func (c *ProjectsLocationsAppsConversationsListCall) PageSize(pageSize int64) *ProjectsLocationsAppsConversationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The next_page_token value
// returned from a previous list AgentService.ListConversations call.
func (c *ProjectsLocationsAppsConversationsListCall) PageToken(pageToken string) *ProjectsLocationsAppsConversationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Source sets the optional parameter "source": Indicate the source of the
// conversation. If not set, Source.Live will be applied by default. Will be
// deprecated in favor of `sources` field.
//
// Possible values:
//
//	"SOURCE_UNSPECIFIED" - Unspecified source.
//	"LIVE" - The conversation is from the live end user.
//	"SIMULATOR" - The conversation is from the simulator.
//	"EVAL" - The conversation is from the evaluation.
func (c *ProjectsLocationsAppsConversationsListCall) Source(source string) *ProjectsLocationsAppsConversationsListCall {
	c.urlParams_.Set("source", source)
	return c
}

// Sources sets the optional parameter "sources": Indicate the sources of the
// conversations. If not set, all available sources will be applied by default.
//
// Possible values:
//
//	"SOURCE_UNSPECIFIED" - Unspecified source.
//	"LIVE" - The conversation is from the live end user.
//	"SIMULATOR" - The conversation is from the simulator.
//	"EVAL" - The conversation is from the evaluation.
func (c *ProjectsLocationsAppsConversationsListCall) Sources(sources ...string) *ProjectsLocationsAppsConversationsListCall {
	c.urlParams_.SetMulti("sources", append([]string{}, sources...))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsConversationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsConversationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAppsConversationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAppsConversationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsConversationsListCall) Context(ctx context.Context) *ProjectsLocationsAppsConversationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsConversationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsConversationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/conversations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.conversations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.conversations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListConversationsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAppsConversationsListCall) Do(opts ...googleapi.CallOption) (*ListConversationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListConversationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.conversations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAppsConversationsListCall) Pages(ctx context.Context, f func(*ListConversationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAppsDeploymentsCreateCall struct {
	s          *Service
	parent     string
	deployment *Deployment
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new deployment in the given app.
//
//   - parent: The parent app. Format:
//     `projects/{project}/locations/{location}/apps/{app}`.
func (r *ProjectsLocationsAppsDeploymentsService) Create(parent string, deployment *Deployment) *ProjectsLocationsAppsDeploymentsCreateCall {
	c := &ProjectsLocationsAppsDeploymentsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.deployment = deployment
	return c
}

// DeploymentId sets the optional parameter "deploymentId": The ID to use for
// the deployment, which will become the final component of the deployment's
// resource name. If not provided, a unique ID will be automatically assigned
// for the deployment.
func (c *ProjectsLocationsAppsDeploymentsCreateCall) DeploymentId(deploymentId string) *ProjectsLocationsAppsDeploymentsCreateCall {
	c.urlParams_.Set("deploymentId", deploymentId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsDeploymentsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsDeploymentsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsDeploymentsCreateCall) Context(ctx context.Context) *ProjectsLocationsAppsDeploymentsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsDeploymentsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsDeploymentsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.deployment)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/deployments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.deployments.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.deployments.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Deployment.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAppsDeploymentsCreateCall) Do(opts ...googleapi.CallOption) (*Deployment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Deployment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.deployments.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAppsDeploymentsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified deployment.
//
//   - name: The name of the deployment to delete. Format:
//     `projects/{project}/locations/{location}/apps/{app}/deployments/{deployment
//     }`.
func (r *ProjectsLocationsAppsDeploymentsService) Delete(name string) *ProjectsLocationsAppsDeploymentsDeleteCall {
	c := &ProjectsLocationsAppsDeploymentsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": The etag of the deployment. If an
// etag is provided and does not match the current etag of the deployment,
// deletion will be blocked and an ABORTED error will be returned.
func (c *ProjectsLocationsAppsDeploymentsDeleteCall) Etag(etag string) *ProjectsLocationsAppsDeploymentsDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsDeploymentsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsDeploymentsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsDeploymentsDeleteCall) Context(ctx context.Context) *ProjectsLocationsAppsDeploymentsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsDeploymentsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsDeploymentsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.deployments.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.deployments.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAppsDeploymentsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.deployments.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAppsDeploymentsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of the specified deployment.
//
//   - name: The name of the deployment. Format:
//     `projects/{project}/locations/{location}/apps/{app}/deployments/{deployment
//     }`.
func (r *ProjectsLocationsAppsDeploymentsService) Get(name string) *ProjectsLocationsAppsDeploymentsGetCall {
	c := &ProjectsLocationsAppsDeploymentsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsDeploymentsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsDeploymentsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAppsDeploymentsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsAppsDeploymentsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsDeploymentsGetCall) Context(ctx context.Context) *ProjectsLocationsAppsDeploymentsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsDeploymentsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsDeploymentsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.deployments.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.deployments.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Deployment.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAppsDeploymentsGetCall) Do(opts ...googleapi.CallOption) (*Deployment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Deployment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.deployments.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAppsDeploymentsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists deployments in the given app.
//
//   - parent: The parent app. Format:
//     `projects/{project}/locations/{location}/apps/{app}`.
func (r *ProjectsLocationsAppsDeploymentsService) List(parent string) *ProjectsLocationsAppsDeploymentsListCall {
	c := &ProjectsLocationsAppsDeploymentsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// OrderBy sets the optional parameter "orderBy": Field to sort by. Only "name"
// and "create_time" is supported. See https://google.aip.dev/132#ordering for
// more details.
func (c *ProjectsLocationsAppsDeploymentsListCall) OrderBy(orderBy string) *ProjectsLocationsAppsDeploymentsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// deployments to return. The service may return fewer than this value. If
// unspecified, at most 50 deployments will be returned. The maximum value is
// 1000; values above 1000 will be coerced to 1000.
func (c *ProjectsLocationsAppsDeploymentsListCall) PageSize(pageSize int64) *ProjectsLocationsAppsDeploymentsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListDeployments` call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// `ListDeployments` must match the call that provided the page token.
func (c *ProjectsLocationsAppsDeploymentsListCall) PageToken(pageToken string) *ProjectsLocationsAppsDeploymentsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsDeploymentsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsDeploymentsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAppsDeploymentsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAppsDeploymentsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsDeploymentsListCall) Context(ctx context.Context) *ProjectsLocationsAppsDeploymentsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsDeploymentsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsDeploymentsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/deployments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.deployments.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.deployments.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListDeploymentsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAppsDeploymentsListCall) Do(opts ...googleapi.CallOption) (*ListDeploymentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListDeploymentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.deployments.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAppsDeploymentsListCall) Pages(ctx context.Context, f func(*ListDeploymentsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAppsDeploymentsPatchCall struct {
	s          *Service
	name       string
	deployment *Deployment
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the specified deployment.
//
//   - name: Identifier. The resource name of the deployment. Format:
//     projects/{project}/locations/{location}/apps/{app}/deployments/{deployment}.
func (r *ProjectsLocationsAppsDeploymentsService) Patch(name string, deployment *Deployment) *ProjectsLocationsAppsDeploymentsPatchCall {
	c := &ProjectsLocationsAppsDeploymentsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.deployment = deployment
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of fields to
// update.
func (c *ProjectsLocationsAppsDeploymentsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsAppsDeploymentsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsDeploymentsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsDeploymentsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsDeploymentsPatchCall) Context(ctx context.Context) *ProjectsLocationsAppsDeploymentsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsDeploymentsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsDeploymentsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.deployment)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.deployments.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.deployments.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Deployment.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAppsDeploymentsPatchCall) Do(opts ...googleapi.CallOption) (*Deployment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Deployment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.deployments.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAppsExamplesCreateCall struct {
	s          *Service
	parent     string
	example    *Example
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new example in the given app.
//
// - parent: The resource name of the app to create an example in.
func (r *ProjectsLocationsAppsExamplesService) Create(parent string, example *Example) *ProjectsLocationsAppsExamplesCreateCall {
	c := &ProjectsLocationsAppsExamplesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.example = example
	return c
}

// ExampleId sets the optional parameter "exampleId": The ID to use for the
// example, which will become the final component of the example's resource
// name. If not provided, a unique ID will be automatically assigned for the
// example.
func (c *ProjectsLocationsAppsExamplesCreateCall) ExampleId(exampleId string) *ProjectsLocationsAppsExamplesCreateCall {
	c.urlParams_.Set("exampleId", exampleId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsExamplesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsExamplesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsExamplesCreateCall) Context(ctx context.Context) *ProjectsLocationsAppsExamplesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsExamplesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsExamplesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.example)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/examples")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.examples.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.examples.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Example.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAppsExamplesCreateCall) Do(opts ...googleapi.CallOption) (*Example, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Example{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.examples.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAppsExamplesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified example.
//
// - name: The resource name of the example to delete.
func (r *ProjectsLocationsAppsExamplesService) Delete(name string) *ProjectsLocationsAppsExamplesDeleteCall {
	c := &ProjectsLocationsAppsExamplesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": The current etag of the example. If
// an etag is not provided, the deletion will overwrite any concurrent changes.
// If an etag is provided and does not match the current etag of the example,
// deletion will be blocked and an ABORTED error will be returned.
func (c *ProjectsLocationsAppsExamplesDeleteCall) Etag(etag string) *ProjectsLocationsAppsExamplesDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsExamplesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsExamplesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsExamplesDeleteCall) Context(ctx context.Context) *ProjectsLocationsAppsExamplesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsExamplesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsExamplesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.examples.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.examples.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAppsExamplesDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.examples.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAppsExamplesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of the specified example.
//
// - name: The resource name of the example to retrieve.
func (r *ProjectsLocationsAppsExamplesService) Get(name string) *ProjectsLocationsAppsExamplesGetCall {
	c := &ProjectsLocationsAppsExamplesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsExamplesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsExamplesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAppsExamplesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsAppsExamplesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsExamplesGetCall) Context(ctx context.Context) *ProjectsLocationsAppsExamplesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsExamplesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsExamplesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.examples.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.examples.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Example.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAppsExamplesGetCall) Do(opts ...googleapi.CallOption) (*Example, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Example{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.examples.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAppsExamplesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists examples in the given app.
//
// - parent: The resource name of the app to list examples from.
func (r *ProjectsLocationsAppsExamplesService) List(parent string) *ProjectsLocationsAppsExamplesListCall {
	c := &ProjectsLocationsAppsExamplesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter to be applied when
// listing the examples. See https://google.aip.dev/160 for more details.
func (c *ProjectsLocationsAppsExamplesListCall) Filter(filter string) *ProjectsLocationsAppsExamplesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Field to sort by. Only "name"
// and "create_time" is supported. See https://google.aip.dev/132#ordering for
// more details.
func (c *ProjectsLocationsAppsExamplesListCall) OrderBy(orderBy string) *ProjectsLocationsAppsExamplesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. Server
// may return fewer items than requested. If unspecified, server will pick an
// appropriate default.
func (c *ProjectsLocationsAppsExamplesListCall) PageSize(pageSize int64) *ProjectsLocationsAppsExamplesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The next_page_token value
// returned from a previous list AgentService.ListExamples call.
func (c *ProjectsLocationsAppsExamplesListCall) PageToken(pageToken string) *ProjectsLocationsAppsExamplesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsExamplesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsExamplesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAppsExamplesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAppsExamplesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsExamplesListCall) Context(ctx context.Context) *ProjectsLocationsAppsExamplesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsExamplesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsExamplesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/examples")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.examples.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.examples.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListExamplesResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAppsExamplesListCall) Do(opts ...googleapi.CallOption) (*ListExamplesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListExamplesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.examples.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAppsExamplesListCall) Pages(ctx context.Context, f func(*ListExamplesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAppsExamplesPatchCall struct {
	s          *Service
	nameid     string
	example    *Example
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the specified example.
//
//   - name: Identifier. The unique identifier of the example. Format:
//     `projects/{project}/locations/{location}/apps/{app}/examples/{example}`.
func (r *ProjectsLocationsAppsExamplesService) Patch(nameid string, example *Example) *ProjectsLocationsAppsExamplesPatchCall {
	c := &ProjectsLocationsAppsExamplesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	c.example = example
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask is used to
// control which fields get updated. If the mask is not present, all fields
// will be updated.
func (c *ProjectsLocationsAppsExamplesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsAppsExamplesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsExamplesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsExamplesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsExamplesPatchCall) Context(ctx context.Context) *ProjectsLocationsAppsExamplesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsExamplesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsExamplesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.example)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.examples.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.examples.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Example.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAppsExamplesPatchCall) Do(opts ...googleapi.CallOption) (*Example, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Example{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.examples.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAppsGuardrailsCreateCall struct {
	s          *Service
	parent     string
	guardrail  *Guardrail
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new guardrail in the given app.
//
// - parent: The resource name of the app to create a guardrail in.
func (r *ProjectsLocationsAppsGuardrailsService) Create(parent string, guardrail *Guardrail) *ProjectsLocationsAppsGuardrailsCreateCall {
	c := &ProjectsLocationsAppsGuardrailsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.guardrail = guardrail
	return c
}

// GuardrailId sets the optional parameter "guardrailId": The ID to use for the
// guardrail, which will become the final component of the guardrail's resource
// name. If not provided, a unique ID will be automatically assigned for the
// guardrail.
func (c *ProjectsLocationsAppsGuardrailsCreateCall) GuardrailId(guardrailId string) *ProjectsLocationsAppsGuardrailsCreateCall {
	c.urlParams_.Set("guardrailId", guardrailId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsGuardrailsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsGuardrailsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsGuardrailsCreateCall) Context(ctx context.Context) *ProjectsLocationsAppsGuardrailsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsGuardrailsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsGuardrailsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.guardrail)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/guardrails")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.guardrails.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.guardrails.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Guardrail.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAppsGuardrailsCreateCall) Do(opts ...googleapi.CallOption) (*Guardrail, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Guardrail{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.guardrails.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAppsGuardrailsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified guardrail.
//
// - name: The resource name of the guardrail to delete.
func (r *ProjectsLocationsAppsGuardrailsService) Delete(name string) *ProjectsLocationsAppsGuardrailsDeleteCall {
	c := &ProjectsLocationsAppsGuardrailsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": The current etag of the guardrail.
// If an etag is not provided, the deletion will overwrite any concurrent
// changes. If an etag is provided and does not match the current etag of the
// guardrail, deletion will be blocked and an ABORTED error will be returned.
func (c *ProjectsLocationsAppsGuardrailsDeleteCall) Etag(etag string) *ProjectsLocationsAppsGuardrailsDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// Force sets the optional parameter "force": Indicates whether to forcefully
// delete the guardrail, even if it is still referenced by app/agents. * If
// `force = false`, the deletion fails if any apps/agents still reference the
// guardrail. * If `force = true`, all existing references from apps/agents
// will be removed and the guardrail will be deleted.
func (c *ProjectsLocationsAppsGuardrailsDeleteCall) Force(force bool) *ProjectsLocationsAppsGuardrailsDeleteCall {
	c.urlParams_.Set("force", fmt.Sprint(force))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsGuardrailsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsGuardrailsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsGuardrailsDeleteCall) Context(ctx context.Context) *ProjectsLocationsAppsGuardrailsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsGuardrailsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsGuardrailsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.guardrails.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.guardrails.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAppsGuardrailsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.guardrails.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAppsGuardrailsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of the specified guardrail.
//
// - name: The resource name of the guardrail to retrieve.
func (r *ProjectsLocationsAppsGuardrailsService) Get(name string) *ProjectsLocationsAppsGuardrailsGetCall {
	c := &ProjectsLocationsAppsGuardrailsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsGuardrailsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsGuardrailsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAppsGuardrailsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsAppsGuardrailsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsGuardrailsGetCall) Context(ctx context.Context) *ProjectsLocationsAppsGuardrailsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsGuardrailsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsGuardrailsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.guardrails.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.guardrails.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Guardrail.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAppsGuardrailsGetCall) Do(opts ...googleapi.CallOption) (*Guardrail, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Guardrail{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.guardrails.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAppsGuardrailsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists guardrails in the given app.
//
// - parent: The resource name of the app to list guardrails from.
func (r *ProjectsLocationsAppsGuardrailsService) List(parent string) *ProjectsLocationsAppsGuardrailsListCall {
	c := &ProjectsLocationsAppsGuardrailsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter to be applied when
// listing the guardrails. See https://google.aip.dev/160 for more details.
func (c *ProjectsLocationsAppsGuardrailsListCall) Filter(filter string) *ProjectsLocationsAppsGuardrailsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Field to sort by. Only "name"
// and "create_time" is supported. See https://google.aip.dev/132#ordering for
// more details.
func (c *ProjectsLocationsAppsGuardrailsListCall) OrderBy(orderBy string) *ProjectsLocationsAppsGuardrailsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. Server
// may return fewer items than requested. If unspecified, server will pick an
// appropriate default.
func (c *ProjectsLocationsAppsGuardrailsListCall) PageSize(pageSize int64) *ProjectsLocationsAppsGuardrailsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The next_page_token value
// returned from a previous list AgentService.ListGuardrails call.
func (c *ProjectsLocationsAppsGuardrailsListCall) PageToken(pageToken string) *ProjectsLocationsAppsGuardrailsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsGuardrailsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsGuardrailsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAppsGuardrailsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAppsGuardrailsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsGuardrailsListCall) Context(ctx context.Context) *ProjectsLocationsAppsGuardrailsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsGuardrailsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsGuardrailsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/guardrails")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.guardrails.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.guardrails.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListGuardrailsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAppsGuardrailsListCall) Do(opts ...googleapi.CallOption) (*ListGuardrailsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListGuardrailsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.guardrails.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAppsGuardrailsListCall) Pages(ctx context.Context, f func(*ListGuardrailsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAppsGuardrailsPatchCall struct {
	s          *Service
	nameid     string
	guardrail  *Guardrail
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the specified guardrail.
//
//   - name: Identifier. The unique identifier of the guardrail. Format:
//     `projects/{project}/locations/{location}/apps/{app}/guardrails/{guardrail}`.
func (r *ProjectsLocationsAppsGuardrailsService) Patch(nameid string, guardrail *Guardrail) *ProjectsLocationsAppsGuardrailsPatchCall {
	c := &ProjectsLocationsAppsGuardrailsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	c.guardrail = guardrail
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask is used to
// control which fields get updated. If the mask is not present, all fields
// will be updated.
func (c *ProjectsLocationsAppsGuardrailsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsAppsGuardrailsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsGuardrailsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsGuardrailsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsGuardrailsPatchCall) Context(ctx context.Context) *ProjectsLocationsAppsGuardrailsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsGuardrailsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsGuardrailsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.guardrail)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.guardrails.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.guardrails.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Guardrail.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAppsGuardrailsPatchCall) Do(opts ...googleapi.CallOption) (*Guardrail, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Guardrail{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.guardrails.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAppsSessionsGenerateChatTokenCall struct {
	s                        *Service
	name                     string
	generatechattokenrequest *GenerateChatTokenRequest
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// GenerateChatToken: Generates a session scoped token for chat widget to
// authenticate with Session APIs.
//
//   - name: The session name to generate the chat token for. Format:
//     projects/{project}/locations/{location}/apps/{app}/sessions/{session}.
func (r *ProjectsLocationsAppsSessionsService) GenerateChatToken(name string, generatechattokenrequest *GenerateChatTokenRequest) *ProjectsLocationsAppsSessionsGenerateChatTokenCall {
	c := &ProjectsLocationsAppsSessionsGenerateChatTokenCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.generatechattokenrequest = generatechattokenrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsSessionsGenerateChatTokenCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsSessionsGenerateChatTokenCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsSessionsGenerateChatTokenCall) Context(ctx context.Context) *ProjectsLocationsAppsSessionsGenerateChatTokenCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsSessionsGenerateChatTokenCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsSessionsGenerateChatTokenCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.generatechattokenrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:generateChatToken")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.sessions.generateChatToken", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.sessions.generateChatToken" call.
// Any non-2xx status code is an error. Response headers are in either
// *GenerateChatTokenResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAppsSessionsGenerateChatTokenCall) Do(opts ...googleapi.CallOption) (*GenerateChatTokenResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GenerateChatTokenResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.sessions.generateChatToken", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAppsSessionsRunSessionCall struct {
	s                 *Service
	sessionid         string
	runsessionrequest *RunSessionRequest
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// RunSession: Initiates a single turn interaction with the CES agent within a
// session.
//
//   - session: The unique identifier of the session. Format:
//     `projects/{project}/locations/{location}/apps/{app}/sessions/{session}`.
func (r *ProjectsLocationsAppsSessionsService) RunSession(sessionid string, runsessionrequest *RunSessionRequest) *ProjectsLocationsAppsSessionsRunSessionCall {
	c := &ProjectsLocationsAppsSessionsRunSessionCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.sessionid = sessionid
	c.runsessionrequest = runsessionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsSessionsRunSessionCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsSessionsRunSessionCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsSessionsRunSessionCall) Context(ctx context.Context) *ProjectsLocationsAppsSessionsRunSessionCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsSessionsRunSessionCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsSessionsRunSessionCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.runsessionrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+session}:runSession")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"session": c.sessionid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.sessions.runSession", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.sessions.runSession" call.
// Any non-2xx status code is an error. Response headers are in either
// *RunSessionResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAppsSessionsRunSessionCall) Do(opts ...googleapi.CallOption) (*RunSessionResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RunSessionResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.sessions.runSession", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAppsToolsCreateCall struct {
	s          *Service
	parent     string
	tool       *Tool
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new tool in the given app.
//
// - parent: The resource name of the app to create a tool in.
func (r *ProjectsLocationsAppsToolsService) Create(parent string, tool *Tool) *ProjectsLocationsAppsToolsCreateCall {
	c := &ProjectsLocationsAppsToolsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.tool = tool
	return c
}

// ToolId sets the optional parameter "toolId": The ID to use for the tool,
// which will become the final component of the tool's resource name. If not
// provided, a unique ID will be automatically assigned for the tool.
func (c *ProjectsLocationsAppsToolsCreateCall) ToolId(toolId string) *ProjectsLocationsAppsToolsCreateCall {
	c.urlParams_.Set("toolId", toolId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsToolsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsToolsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsToolsCreateCall) Context(ctx context.Context) *ProjectsLocationsAppsToolsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsToolsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsToolsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.tool)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/tools")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.tools.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.tools.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Tool.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAppsToolsCreateCall) Do(opts ...googleapi.CallOption) (*Tool, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Tool{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.tools.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAppsToolsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified tool.
//
// - name: The resource name of the tool to delete.
func (r *ProjectsLocationsAppsToolsService) Delete(name string) *ProjectsLocationsAppsToolsDeleteCall {
	c := &ProjectsLocationsAppsToolsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": The current etag of the tool. If an
// etag is not provided, the deletion will overwrite any concurrent changes. If
// an etag is provided and does not match the current etag of the tool,
// deletion will be blocked and an ABORTED error will be returned.
func (c *ProjectsLocationsAppsToolsDeleteCall) Etag(etag string) *ProjectsLocationsAppsToolsDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// Force sets the optional parameter "force": Indicates whether to forcefully
// delete the tool, even if it is still referenced by agents/examples. * If
// `force = false`, the deletion will fail if any agents still reference the
// tool. * If `force = true`, all existing references from agents will be
// removed and the tool will be deleted.
func (c *ProjectsLocationsAppsToolsDeleteCall) Force(force bool) *ProjectsLocationsAppsToolsDeleteCall {
	c.urlParams_.Set("force", fmt.Sprint(force))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsToolsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsToolsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsToolsDeleteCall) Context(ctx context.Context) *ProjectsLocationsAppsToolsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsToolsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsToolsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.tools.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.tools.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAppsToolsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.tools.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAppsToolsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of the specified tool.
//
// - name: The resource name of the tool to retrieve.
func (r *ProjectsLocationsAppsToolsService) Get(name string) *ProjectsLocationsAppsToolsGetCall {
	c := &ProjectsLocationsAppsToolsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsToolsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsToolsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAppsToolsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsAppsToolsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsToolsGetCall) Context(ctx context.Context) *ProjectsLocationsAppsToolsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsToolsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsToolsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.tools.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.tools.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Tool.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAppsToolsGetCall) Do(opts ...googleapi.CallOption) (*Tool, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Tool{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.tools.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAppsToolsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists tools in the given app.
//
// - parent: The resource name of the app to list tools from.
func (r *ProjectsLocationsAppsToolsService) List(parent string) *ProjectsLocationsAppsToolsListCall {
	c := &ProjectsLocationsAppsToolsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter to be applied when
// listing the tools. Use "include_system_tools=true" to include system tools
// in the response. See https://google.aip.dev/160 for more details.
func (c *ProjectsLocationsAppsToolsListCall) Filter(filter string) *ProjectsLocationsAppsToolsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Field to sort by. Only "name"
// and "create_time" is supported. See https://google.aip.dev/132#ordering for
// more details.
func (c *ProjectsLocationsAppsToolsListCall) OrderBy(orderBy string) *ProjectsLocationsAppsToolsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. Server
// may return fewer items than requested. If unspecified, server will pick an
// appropriate default.
func (c *ProjectsLocationsAppsToolsListCall) PageSize(pageSize int64) *ProjectsLocationsAppsToolsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The next_page_token value
// returned from a previous list AgentService.ListTools call.
func (c *ProjectsLocationsAppsToolsListCall) PageToken(pageToken string) *ProjectsLocationsAppsToolsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsToolsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsToolsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAppsToolsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAppsToolsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsToolsListCall) Context(ctx context.Context) *ProjectsLocationsAppsToolsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsToolsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsToolsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/tools")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.tools.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.tools.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListToolsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAppsToolsListCall) Do(opts ...googleapi.CallOption) (*ListToolsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListToolsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.tools.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAppsToolsListCall) Pages(ctx context.Context, f func(*ListToolsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAppsToolsPatchCall struct {
	s          *Service
	nameid     string
	tool       *Tool
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the specified tool.
//
//   - name: Identifier. The unique identifier of the tool. Format: -
//     `projects/{project}/locations/{location}/apps/{app}/tools/{tool}` for ##
//     standalone tools.
//     `projects/{project}/locations/{location}/apps/{app}/toolsets/{toolset}/tool
//     s/{tool}` for tools retrieved from a toolset. These tools are dynamic and
//     output-only, they cannot be referenced directly where a tool is expected.
func (r *ProjectsLocationsAppsToolsService) Patch(nameid string, tool *Tool) *ProjectsLocationsAppsToolsPatchCall {
	c := &ProjectsLocationsAppsToolsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	c.tool = tool
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask is used to
// control which fields get updated. If the mask is not present, all fields
// will be updated.
func (c *ProjectsLocationsAppsToolsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsAppsToolsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsToolsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsToolsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsToolsPatchCall) Context(ctx context.Context) *ProjectsLocationsAppsToolsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsToolsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsToolsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.tool)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.tools.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.tools.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Tool.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAppsToolsPatchCall) Do(opts ...googleapi.CallOption) (*Tool, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Tool{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.tools.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAppsToolsetsCreateCall struct {
	s          *Service
	parent     string
	toolset    *Toolset
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new toolset in the given app.
//
// - parent: The resource name of the app to create a toolset in.
func (r *ProjectsLocationsAppsToolsetsService) Create(parent string, toolset *Toolset) *ProjectsLocationsAppsToolsetsCreateCall {
	c := &ProjectsLocationsAppsToolsetsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.toolset = toolset
	return c
}

// ToolsetId sets the optional parameter "toolsetId": The ID to use for the
// toolset, which will become the final component of the toolset's resource
// name. If not provided, a unique ID will be automatically assigned for the
// toolset.
func (c *ProjectsLocationsAppsToolsetsCreateCall) ToolsetId(toolsetId string) *ProjectsLocationsAppsToolsetsCreateCall {
	c.urlParams_.Set("toolsetId", toolsetId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsToolsetsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsToolsetsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsToolsetsCreateCall) Context(ctx context.Context) *ProjectsLocationsAppsToolsetsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsToolsetsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsToolsetsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.toolset)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/toolsets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.toolsets.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.toolsets.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Toolset.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAppsToolsetsCreateCall) Do(opts ...googleapi.CallOption) (*Toolset, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Toolset{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.toolsets.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAppsToolsetsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified toolset.
//
// - name: The resource name of the toolset to delete.
func (r *ProjectsLocationsAppsToolsetsService) Delete(name string) *ProjectsLocationsAppsToolsetsDeleteCall {
	c := &ProjectsLocationsAppsToolsetsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": The current etag of the toolset. If
// an etag is not provided, the deletion will overwrite any concurrent changes.
// If an etag is provided and does not match the current etag of the toolset,
// deletion will be blocked and an ABORTED error will be returned.
func (c *ProjectsLocationsAppsToolsetsDeleteCall) Etag(etag string) *ProjectsLocationsAppsToolsetsDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// Force sets the optional parameter "force": Indicates whether to forcefully
// delete the toolset, even if it is still referenced by app/agents. * If
// `force = false`, the deletion fails if any agents still reference the
// toolset. * If `force = true`, all existing references from agents will be
// removed and the toolset will be deleted.
func (c *ProjectsLocationsAppsToolsetsDeleteCall) Force(force bool) *ProjectsLocationsAppsToolsetsDeleteCall {
	c.urlParams_.Set("force", fmt.Sprint(force))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsToolsetsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsToolsetsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsToolsetsDeleteCall) Context(ctx context.Context) *ProjectsLocationsAppsToolsetsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsToolsetsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsToolsetsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.toolsets.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.toolsets.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAppsToolsetsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.toolsets.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAppsToolsetsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of the specified toolset.
//
// - name: The resource name of the toolset to retrieve.
func (r *ProjectsLocationsAppsToolsetsService) Get(name string) *ProjectsLocationsAppsToolsetsGetCall {
	c := &ProjectsLocationsAppsToolsetsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsToolsetsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsToolsetsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAppsToolsetsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsAppsToolsetsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsToolsetsGetCall) Context(ctx context.Context) *ProjectsLocationsAppsToolsetsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsToolsetsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsToolsetsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.toolsets.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.toolsets.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Toolset.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAppsToolsetsGetCall) Do(opts ...googleapi.CallOption) (*Toolset, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Toolset{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.toolsets.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAppsToolsetsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists toolsets in the given app.
//
// - parent: The resource name of the app to list toolsets from.
func (r *ProjectsLocationsAppsToolsetsService) List(parent string) *ProjectsLocationsAppsToolsetsListCall {
	c := &ProjectsLocationsAppsToolsetsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter to be applied when
// listing the toolsets. See https://google.aip.dev/160 for more details.
func (c *ProjectsLocationsAppsToolsetsListCall) Filter(filter string) *ProjectsLocationsAppsToolsetsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Field to sort by. Only "name"
// and "create_time" is supported. See https://google.aip.dev/132#ordering for
// more details.
func (c *ProjectsLocationsAppsToolsetsListCall) OrderBy(orderBy string) *ProjectsLocationsAppsToolsetsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. Server
// may return fewer items than requested. If unspecified, server will pick an
// appropriate default.
func (c *ProjectsLocationsAppsToolsetsListCall) PageSize(pageSize int64) *ProjectsLocationsAppsToolsetsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The next_page_token value
// returned from a previous list AgentService.ListToolsets call.
func (c *ProjectsLocationsAppsToolsetsListCall) PageToken(pageToken string) *ProjectsLocationsAppsToolsetsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsToolsetsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsToolsetsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAppsToolsetsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAppsToolsetsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsToolsetsListCall) Context(ctx context.Context) *ProjectsLocationsAppsToolsetsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsToolsetsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsToolsetsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/toolsets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.toolsets.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.toolsets.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListToolsetsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAppsToolsetsListCall) Do(opts ...googleapi.CallOption) (*ListToolsetsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListToolsetsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.toolsets.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAppsToolsetsListCall) Pages(ctx context.Context, f func(*ListToolsetsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAppsToolsetsPatchCall struct {
	s          *Service
	nameid     string
	toolset    *Toolset
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the specified toolset.
//
//   - name: Identifier. The unique identifier of the toolset. Format:
//     `projects/{project}/locations/{location}/apps/{app}/toolsets/{toolset}`.
func (r *ProjectsLocationsAppsToolsetsService) Patch(nameid string, toolset *Toolset) *ProjectsLocationsAppsToolsetsPatchCall {
	c := &ProjectsLocationsAppsToolsetsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	c.toolset = toolset
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask is used to
// control which fields get updated. If the mask is not present, all fields
// will be updated.
func (c *ProjectsLocationsAppsToolsetsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsAppsToolsetsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsToolsetsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsToolsetsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsToolsetsPatchCall) Context(ctx context.Context) *ProjectsLocationsAppsToolsetsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsToolsetsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsToolsetsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.toolset)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.toolsets.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.toolsets.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Toolset.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAppsToolsetsPatchCall) Do(opts ...googleapi.CallOption) (*Toolset, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Toolset{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.toolsets.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAppsToolsetsRetrieveToolsCall struct {
	s                    *Service
	toolset              string
	retrievetoolsrequest *RetrieveToolsRequest
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// RetrieveTools: Retrieve the list of tools included in the specified toolset.
//
//   - toolset: The name of the toolset to retrieve the tools for. Format:
//     `projects/{project}/locations/{location}/apps/{app}/toolsets/{toolset}`.
func (r *ProjectsLocationsAppsToolsetsService) RetrieveTools(toolset string, retrievetoolsrequest *RetrieveToolsRequest) *ProjectsLocationsAppsToolsetsRetrieveToolsCall {
	c := &ProjectsLocationsAppsToolsetsRetrieveToolsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.toolset = toolset
	c.retrievetoolsrequest = retrievetoolsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsToolsetsRetrieveToolsCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsToolsetsRetrieveToolsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsToolsetsRetrieveToolsCall) Context(ctx context.Context) *ProjectsLocationsAppsToolsetsRetrieveToolsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsToolsetsRetrieveToolsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsToolsetsRetrieveToolsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.retrievetoolsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+toolset}:retrieveTools")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"toolset": c.toolset,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.toolsets.retrieveTools", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.toolsets.retrieveTools" call.
// Any non-2xx status code is an error. Response headers are in either
// *RetrieveToolsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAppsToolsetsRetrieveToolsCall) Do(opts ...googleapi.CallOption) (*RetrieveToolsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RetrieveToolsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.toolsets.retrieveTools", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAppsVersionsCreateCall struct {
	s          *Service
	parent     string
	appversion *AppVersion
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new app version in the given app.
//
// - parent: The resource name of the app to create an app version in.
func (r *ProjectsLocationsAppsVersionsService) Create(parent string, appversion *AppVersion) *ProjectsLocationsAppsVersionsCreateCall {
	c := &ProjectsLocationsAppsVersionsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.appversion = appversion
	return c
}

// AppVersionId sets the optional parameter "appVersionId": The ID to use for
// the app version, which will become the final component of the app version's
// resource name. If not provided, a unique ID will be automatically assigned
// for the app version.
func (c *ProjectsLocationsAppsVersionsCreateCall) AppVersionId(appVersionId string) *ProjectsLocationsAppsVersionsCreateCall {
	c.urlParams_.Set("appVersionId", appVersionId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsVersionsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsVersionsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsVersionsCreateCall) Context(ctx context.Context) *ProjectsLocationsAppsVersionsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsVersionsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsVersionsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.appversion)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/versions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.versions.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.versions.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *AppVersion.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAppsVersionsCreateCall) Do(opts ...googleapi.CallOption) (*AppVersion, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AppVersion{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.versions.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAppsVersionsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified app version.
//
// - name: The resource name of the app version to delete.
func (r *ProjectsLocationsAppsVersionsService) Delete(name string) *ProjectsLocationsAppsVersionsDeleteCall {
	c := &ProjectsLocationsAppsVersionsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": The current etag of the app
// version. If an etag is not provided, the deletion will overwrite any
// concurrent changes. If an etag is provided and does not match the current
// etag of the app version, deletion will be blocked and an ABORTED error will
// be returned.
func (c *ProjectsLocationsAppsVersionsDeleteCall) Etag(etag string) *ProjectsLocationsAppsVersionsDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsVersionsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsVersionsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsVersionsDeleteCall) Context(ctx context.Context) *ProjectsLocationsAppsVersionsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsVersionsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsVersionsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.versions.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.versions.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAppsVersionsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.versions.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAppsVersionsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of the specified app version.
//
// - name: The resource name of the app version to retrieve.
func (r *ProjectsLocationsAppsVersionsService) Get(name string) *ProjectsLocationsAppsVersionsGetCall {
	c := &ProjectsLocationsAppsVersionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsVersionsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsVersionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAppsVersionsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsAppsVersionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsVersionsGetCall) Context(ctx context.Context) *ProjectsLocationsAppsVersionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsVersionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsVersionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.versions.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.versions.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *AppVersion.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAppsVersionsGetCall) Do(opts ...googleapi.CallOption) (*AppVersion, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AppVersion{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.versions.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAppsVersionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all app versions in the given app.
//
// - parent: The resource name of the app to list app versions from.
func (r *ProjectsLocationsAppsVersionsService) List(parent string) *ProjectsLocationsAppsVersionsListCall {
	c := &ProjectsLocationsAppsVersionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter to be applied when
// listing the app versions. See https://google.aip.dev/160 for more details.
func (c *ProjectsLocationsAppsVersionsListCall) Filter(filter string) *ProjectsLocationsAppsVersionsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Field to sort by. Only "name"
// and "create_time" is supported. See https://google.aip.dev/132#ordering for
// more details.
func (c *ProjectsLocationsAppsVersionsListCall) OrderBy(orderBy string) *ProjectsLocationsAppsVersionsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. Server
// may return fewer items than requested. If unspecified, server will pick an
// appropriate default.
func (c *ProjectsLocationsAppsVersionsListCall) PageSize(pageSize int64) *ProjectsLocationsAppsVersionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The next_page_token value
// returned from a previous list AgentService.ListAppVersions call.
func (c *ProjectsLocationsAppsVersionsListCall) PageToken(pageToken string) *ProjectsLocationsAppsVersionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsVersionsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsVersionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAppsVersionsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAppsVersionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsVersionsListCall) Context(ctx context.Context) *ProjectsLocationsAppsVersionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsVersionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsVersionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/versions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.versions.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.versions.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAppVersionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAppsVersionsListCall) Do(opts ...googleapi.CallOption) (*ListAppVersionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAppVersionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.versions.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAppsVersionsListCall) Pages(ctx context.Context, f func(*ListAppVersionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAppsVersionsRestoreCall struct {
	s                        *Service
	name                     string
	restoreappversionrequest *RestoreAppVersionRequest
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// Restore: Restores the specified app version. This will create a new app
// version from the current draft app and overwrite the current draft with the
// specified app version.
//
// - name: The resource name of the app version to restore.
func (r *ProjectsLocationsAppsVersionsService) Restore(name string, restoreappversionrequest *RestoreAppVersionRequest) *ProjectsLocationsAppsVersionsRestoreCall {
	c := &ProjectsLocationsAppsVersionsRestoreCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.restoreappversionrequest = restoreappversionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAppsVersionsRestoreCall) Fields(s ...googleapi.Field) *ProjectsLocationsAppsVersionsRestoreCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAppsVersionsRestoreCall) Context(ctx context.Context) *ProjectsLocationsAppsVersionsRestoreCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAppsVersionsRestoreCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAppsVersionsRestoreCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.restoreappversionrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:restore")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.versions.restore", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.apps.versions.restore" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAppsVersionsRestoreCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.apps.versions.restore", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsCancelCall struct {
	s                      *Service
	name                   string
	canceloperationrequest *CancelOperationRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Cancel: Starts asynchronous cancellation on a long-running operation. The
// server makes a best effort to cancel the operation, but success is not
// guaranteed. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or
// other methods to check whether the cancellation succeeded or whether the
// operation completed despite cancellation. On successful cancellation, the
// operation is not deleted; instead, it becomes an operation with an
// Operation.error value with a google.rpc.Status.code of `1`, corresponding to
// `Code.CANCELLED`.
//
// - name: The name of the operation resource to be cancelled.
func (r *ProjectsLocationsOperationsService) Cancel(name string, canceloperationrequest *CancelOperationRequest) *ProjectsLocationsOperationsCancelCall {
	c := &ProjectsLocationsOperationsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.canceloperationrequest = canceloperationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsCancelCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsCancelCall) Context(ctx context.Context) *ProjectsLocationsOperationsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.canceloperationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.operations.cancel", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.operations.cancel" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsCancelCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.operations.cancel", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a long-running operation. This method indicates that the
// client is no longer interested in the operation result. It does not cancel
// the operation. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`.
//
// - name: The name of the operation resource to be deleted.
func (r *ProjectsLocationsOperationsService) Delete(name string) *ProjectsLocationsOperationsDeleteCall {
	c := &ProjectsLocationsOperationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsDeleteCall) Context(ctx context.Context) *ProjectsLocationsOperationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.operations.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.operations.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.operations.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsOperationsService) Get(name string) *ProjectsLocationsOperationsGetCall {
	c := &ProjectsLocationsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsGetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the request. If
// the server doesn't support this method, it returns `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsOperationsService) List(name string) *ProjectsLocationsOperationsListCall {
	c := &ProjectsLocationsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list filter.
func (c *ProjectsLocationsOperationsListCall) Filter(filter string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list page
// size.
func (c *ProjectsLocationsOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list page
// token.
func (c *ProjectsLocationsOperationsListCall) PageToken(pageToken string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// When set to `true`, operations that are reachable are returned as normal,
// and those that are unreachable are returned in the
// ListOperationsResponse.unreachable field. This can only be `true` when
// reading across collections. For example, when `parent` is set to
// "projects/example/locations/-". This field is not supported by default and
// will result in an `UNIMPLEMENTED` error if set unless explicitly documented
// otherwise in service or product specific documentation.
func (c *ProjectsLocationsOperationsListCall) ReturnPartialSuccess(returnPartialSuccess bool) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsListCall) Context(ctx context.Context) *ProjectsLocationsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ces.projects.locations.operations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ces.projects.locations.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListOperationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsOperationsListCall) Do(opts ...googleapi.CallOption) (*ListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ces.projects.locations.operations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsOperationsListCall) Pages(ctx context.Context, f func(*ListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
