package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

type Malware struct {

	// 恶意软件名称，最大64个字符。
	Name string `json:"name"`

	// 恶意软件sha256
	Sha256 *string `json:"sha256,omitempty"`

	// 恶意软件类型，遵循STIX规范： adware、backdoor、bot、bootkit、ddos、downloader、dropper、exploit-kit、keylogger、ransomware、remote-access-trojan、resource-exploitation、rogue-security-software、rootkit、screen-capture、spyware、trojan、unknown、virus、webshell、wiper、worm
	Type string `json:"type"`

	// 恶意软件在系统中的路径，最大512个字符。
	Path *string `json:"path,omitempty"`

	// 恶意软件状态，取值范围：OBSERVED、REMOVAL_FAILED、REMOVED。
	State *string `json:"state,omitempty"`

	Properties *MalwareProperties `json:"properties,omitempty"`
}

func (o Malware) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "Malware struct{}"
	}

	return strings.Join([]string{"Malware", string(data)}, " ")
}
