//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package matrixpilot

import (
	"fmt"
	"strconv"
)

// Action required when performing CMD_PREFLIGHT_STORAGE
type MAV_PREFLIGHT_STORAGE_ACTION uint64

const (
	// Read all parameters from storage
	MAV_PFS_CMD_READ_ALL MAV_PREFLIGHT_STORAGE_ACTION = 0
	// Write all parameters to storage
	MAV_PFS_CMD_WRITE_ALL MAV_PREFLIGHT_STORAGE_ACTION = 1
	// Clear all  parameters in storage
	MAV_PFS_CMD_CLEAR_ALL MAV_PREFLIGHT_STORAGE_ACTION = 2
	// Read specific parameters from storage
	MAV_PFS_CMD_READ_SPECIFIC MAV_PREFLIGHT_STORAGE_ACTION = 3
	// Write specific parameters to storage
	MAV_PFS_CMD_WRITE_SPECIFIC MAV_PREFLIGHT_STORAGE_ACTION = 4
	// Clear specific parameters in storage
	MAV_PFS_CMD_CLEAR_SPECIFIC MAV_PREFLIGHT_STORAGE_ACTION = 5
	// do nothing
	MAV_PFS_CMD_DO_NOTHING MAV_PREFLIGHT_STORAGE_ACTION = 6
)

var value_to_label_MAV_PREFLIGHT_STORAGE_ACTION = map[MAV_PREFLIGHT_STORAGE_ACTION]string{
	MAV_PFS_CMD_READ_ALL:       "MAV_PFS_CMD_READ_ALL",
	MAV_PFS_CMD_WRITE_ALL:      "MAV_PFS_CMD_WRITE_ALL",
	MAV_PFS_CMD_CLEAR_ALL:      "MAV_PFS_CMD_CLEAR_ALL",
	MAV_PFS_CMD_READ_SPECIFIC:  "MAV_PFS_CMD_READ_SPECIFIC",
	MAV_PFS_CMD_WRITE_SPECIFIC: "MAV_PFS_CMD_WRITE_SPECIFIC",
	MAV_PFS_CMD_CLEAR_SPECIFIC: "MAV_PFS_CMD_CLEAR_SPECIFIC",
	MAV_PFS_CMD_DO_NOTHING:     "MAV_PFS_CMD_DO_NOTHING",
}

var label_to_value_MAV_PREFLIGHT_STORAGE_ACTION = map[string]MAV_PREFLIGHT_STORAGE_ACTION{
	"MAV_PFS_CMD_READ_ALL":       MAV_PFS_CMD_READ_ALL,
	"MAV_PFS_CMD_WRITE_ALL":      MAV_PFS_CMD_WRITE_ALL,
	"MAV_PFS_CMD_CLEAR_ALL":      MAV_PFS_CMD_CLEAR_ALL,
	"MAV_PFS_CMD_READ_SPECIFIC":  MAV_PFS_CMD_READ_SPECIFIC,
	"MAV_PFS_CMD_WRITE_SPECIFIC": MAV_PFS_CMD_WRITE_SPECIFIC,
	"MAV_PFS_CMD_CLEAR_SPECIFIC": MAV_PFS_CMD_CLEAR_SPECIFIC,
	"MAV_PFS_CMD_DO_NOTHING":     MAV_PFS_CMD_DO_NOTHING,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e MAV_PREFLIGHT_STORAGE_ACTION) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_MAV_PREFLIGHT_STORAGE_ACTION[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *MAV_PREFLIGHT_STORAGE_ACTION) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_MAV_PREFLIGHT_STORAGE_ACTION[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = MAV_PREFLIGHT_STORAGE_ACTION(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e MAV_PREFLIGHT_STORAGE_ACTION) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
