//autogenerated:yes
//nolint:revive,misspell,govet,lll
package common

// Parameter set/get error. Returned from a MAVLink node in response to an error in the parameter protocol, for example failing to set a parameter because it does not exist.
type MessageParamError struct {
	// System ID
	TargetSystem uint8
	// Component ID
	TargetComponent uint8
	// Parameter id. Terminated by NULL if the length is less than 16 human-readable chars and WITHOUT null termination (NULL) byte if the length is exactly 16 chars - applications have to provide 16+1 bytes storage if the ID is stored as string
	ParamId string `mavlen:"16"`
	// Parameter index. Will be -1 if the param ID field should be used as an identifier (else the param id will be ignored)
	ParamIndex int16
	// Error being returned to client.
	Error MAV_PARAM_ERROR `mavenum:"uint8"`
}

// GetID implements the message.Message interface.
func (*MessageParamError) GetID() uint32 {
	return 345
}
