//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
)

// The ROI (region of interest) for the vehicle. This can be
// be used by the vehicle for camera/vehicle attitude alignment (see
// MAV_CMD_NAV_ROI).
type MAV_ROI uint64

const (
	// No region of interest.
	MAV_ROI_NONE MAV_ROI = 0
	// Point toward next waypoint, with optional pitch/roll/yaw offset.
	MAV_ROI_WPNEXT MAV_ROI = 1
	// Point toward given waypoint.
	MAV_ROI_WPINDEX MAV_ROI = 2
	// Point toward fixed location.
	MAV_ROI_LOCATION MAV_ROI = 3
	// Point toward of given id.
	MAV_ROI_TARGET MAV_ROI = 4
)

var value_to_label_MAV_ROI = map[MAV_ROI]string{
	MAV_ROI_NONE:     "MAV_ROI_NONE",
	MAV_ROI_WPNEXT:   "MAV_ROI_WPNEXT",
	MAV_ROI_WPINDEX:  "MAV_ROI_WPINDEX",
	MAV_ROI_LOCATION: "MAV_ROI_LOCATION",
	MAV_ROI_TARGET:   "MAV_ROI_TARGET",
}

var label_to_value_MAV_ROI = map[string]MAV_ROI{
	"MAV_ROI_NONE":     MAV_ROI_NONE,
	"MAV_ROI_WPNEXT":   MAV_ROI_WPNEXT,
	"MAV_ROI_WPINDEX":  MAV_ROI_WPINDEX,
	"MAV_ROI_LOCATION": MAV_ROI_LOCATION,
	"MAV_ROI_TARGET":   MAV_ROI_TARGET,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e MAV_ROI) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_MAV_ROI[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *MAV_ROI) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_MAV_ROI[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = MAV_ROI(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e MAV_ROI) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
