//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
)

// Possible actions an aircraft can take to avoid a collision.
type MAV_COLLISION_ACTION uint64

const (
	// Ignore any potential collisions
	MAV_COLLISION_ACTION_NONE MAV_COLLISION_ACTION = 0
	// Report potential collision
	MAV_COLLISION_ACTION_REPORT MAV_COLLISION_ACTION = 1
	// Ascend or Descend to avoid threat
	MAV_COLLISION_ACTION_ASCEND_OR_DESCEND MAV_COLLISION_ACTION = 2
	// Move horizontally to avoid threat
	MAV_COLLISION_ACTION_MOVE_HORIZONTALLY MAV_COLLISION_ACTION = 3
	// Aircraft to move perpendicular to the collision's velocity vector
	MAV_COLLISION_ACTION_MOVE_PERPENDICULAR MAV_COLLISION_ACTION = 4
	// Aircraft to fly directly back to its launch point
	MAV_COLLISION_ACTION_RTL MAV_COLLISION_ACTION = 5
	// Aircraft to stop in place
	MAV_COLLISION_ACTION_HOVER MAV_COLLISION_ACTION = 6
)

var value_to_label_MAV_COLLISION_ACTION = map[MAV_COLLISION_ACTION]string{
	MAV_COLLISION_ACTION_NONE:               "MAV_COLLISION_ACTION_NONE",
	MAV_COLLISION_ACTION_REPORT:             "MAV_COLLISION_ACTION_REPORT",
	MAV_COLLISION_ACTION_ASCEND_OR_DESCEND:  "MAV_COLLISION_ACTION_ASCEND_OR_DESCEND",
	MAV_COLLISION_ACTION_MOVE_HORIZONTALLY:  "MAV_COLLISION_ACTION_MOVE_HORIZONTALLY",
	MAV_COLLISION_ACTION_MOVE_PERPENDICULAR: "MAV_COLLISION_ACTION_MOVE_PERPENDICULAR",
	MAV_COLLISION_ACTION_RTL:                "MAV_COLLISION_ACTION_RTL",
	MAV_COLLISION_ACTION_HOVER:              "MAV_COLLISION_ACTION_HOVER",
}

var label_to_value_MAV_COLLISION_ACTION = map[string]MAV_COLLISION_ACTION{
	"MAV_COLLISION_ACTION_NONE":               MAV_COLLISION_ACTION_NONE,
	"MAV_COLLISION_ACTION_REPORT":             MAV_COLLISION_ACTION_REPORT,
	"MAV_COLLISION_ACTION_ASCEND_OR_DESCEND":  MAV_COLLISION_ACTION_ASCEND_OR_DESCEND,
	"MAV_COLLISION_ACTION_MOVE_HORIZONTALLY":  MAV_COLLISION_ACTION_MOVE_HORIZONTALLY,
	"MAV_COLLISION_ACTION_MOVE_PERPENDICULAR": MAV_COLLISION_ACTION_MOVE_PERPENDICULAR,
	"MAV_COLLISION_ACTION_RTL":                MAV_COLLISION_ACTION_RTL,
	"MAV_COLLISION_ACTION_HOVER":              MAV_COLLISION_ACTION_HOVER,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e MAV_COLLISION_ACTION) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_MAV_COLLISION_ACTION[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *MAV_COLLISION_ACTION) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_MAV_COLLISION_ACTION[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = MAV_COLLISION_ACTION(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e MAV_COLLISION_ACTION) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
