//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
	"strings"
)

// Gimbal manager high level capability flags (bitmap). The first 16 bits are identical to the GIMBAL_DEVICE_CAP_FLAGS. However, the gimbal manager does not need to copy the flags from the gimbal but can also enhance the capabilities and thus add flags.
type GIMBAL_MANAGER_CAP_FLAGS uint64

const (
	// Based on GIMBAL_DEVICE_CAP_FLAGS_HAS_RETRACT.
	GIMBAL_MANAGER_CAP_FLAGS_HAS_RETRACT GIMBAL_MANAGER_CAP_FLAGS = 1
	// Based on GIMBAL_DEVICE_CAP_FLAGS_HAS_NEUTRAL.
	GIMBAL_MANAGER_CAP_FLAGS_HAS_NEUTRAL GIMBAL_MANAGER_CAP_FLAGS = 2
	// Based on GIMBAL_DEVICE_CAP_FLAGS_HAS_ROLL_AXIS.
	GIMBAL_MANAGER_CAP_FLAGS_HAS_ROLL_AXIS GIMBAL_MANAGER_CAP_FLAGS = 4
	// Based on GIMBAL_DEVICE_CAP_FLAGS_HAS_ROLL_FOLLOW.
	GIMBAL_MANAGER_CAP_FLAGS_HAS_ROLL_FOLLOW GIMBAL_MANAGER_CAP_FLAGS = 8
	// Based on GIMBAL_DEVICE_CAP_FLAGS_HAS_ROLL_LOCK.
	GIMBAL_MANAGER_CAP_FLAGS_HAS_ROLL_LOCK GIMBAL_MANAGER_CAP_FLAGS = 16
	// Based on GIMBAL_DEVICE_CAP_FLAGS_HAS_PITCH_AXIS.
	GIMBAL_MANAGER_CAP_FLAGS_HAS_PITCH_AXIS GIMBAL_MANAGER_CAP_FLAGS = 32
	// Based on GIMBAL_DEVICE_CAP_FLAGS_HAS_PITCH_FOLLOW.
	GIMBAL_MANAGER_CAP_FLAGS_HAS_PITCH_FOLLOW GIMBAL_MANAGER_CAP_FLAGS = 64
	// Based on GIMBAL_DEVICE_CAP_FLAGS_HAS_PITCH_LOCK.
	GIMBAL_MANAGER_CAP_FLAGS_HAS_PITCH_LOCK GIMBAL_MANAGER_CAP_FLAGS = 128
	// Based on GIMBAL_DEVICE_CAP_FLAGS_HAS_YAW_AXIS.
	GIMBAL_MANAGER_CAP_FLAGS_HAS_YAW_AXIS GIMBAL_MANAGER_CAP_FLAGS = 256
	// Based on GIMBAL_DEVICE_CAP_FLAGS_HAS_YAW_FOLLOW.
	GIMBAL_MANAGER_CAP_FLAGS_HAS_YAW_FOLLOW GIMBAL_MANAGER_CAP_FLAGS = 512
	// Based on GIMBAL_DEVICE_CAP_FLAGS_HAS_YAW_LOCK.
	GIMBAL_MANAGER_CAP_FLAGS_HAS_YAW_LOCK GIMBAL_MANAGER_CAP_FLAGS = 1024
	// Based on GIMBAL_DEVICE_CAP_FLAGS_SUPPORTS_INFINITE_YAW.
	GIMBAL_MANAGER_CAP_FLAGS_SUPPORTS_INFINITE_YAW GIMBAL_MANAGER_CAP_FLAGS = 2048
	// Based on GIMBAL_DEVICE_CAP_FLAGS_SUPPORTS_YAW_IN_EARTH_FRAME.
	GIMBAL_MANAGER_CAP_FLAGS_SUPPORTS_YAW_IN_EARTH_FRAME GIMBAL_MANAGER_CAP_FLAGS = 4096
	// Based on GIMBAL_DEVICE_CAP_FLAGS_HAS_RC_INPUTS.
	GIMBAL_MANAGER_CAP_FLAGS_HAS_RC_INPUTS GIMBAL_MANAGER_CAP_FLAGS = 8192
	// Gimbal manager supports to point to a local position.
	GIMBAL_MANAGER_CAP_FLAGS_CAN_POINT_LOCATION_LOCAL GIMBAL_MANAGER_CAP_FLAGS = 65536
	// Gimbal manager supports to point to a global latitude, longitude, altitude position.
	GIMBAL_MANAGER_CAP_FLAGS_CAN_POINT_LOCATION_GLOBAL GIMBAL_MANAGER_CAP_FLAGS = 131072
)

var values_GIMBAL_MANAGER_CAP_FLAGS = []GIMBAL_MANAGER_CAP_FLAGS{
	GIMBAL_MANAGER_CAP_FLAGS_HAS_RETRACT,
	GIMBAL_MANAGER_CAP_FLAGS_HAS_NEUTRAL,
	GIMBAL_MANAGER_CAP_FLAGS_HAS_ROLL_AXIS,
	GIMBAL_MANAGER_CAP_FLAGS_HAS_ROLL_FOLLOW,
	GIMBAL_MANAGER_CAP_FLAGS_HAS_ROLL_LOCK,
	GIMBAL_MANAGER_CAP_FLAGS_HAS_PITCH_AXIS,
	GIMBAL_MANAGER_CAP_FLAGS_HAS_PITCH_FOLLOW,
	GIMBAL_MANAGER_CAP_FLAGS_HAS_PITCH_LOCK,
	GIMBAL_MANAGER_CAP_FLAGS_HAS_YAW_AXIS,
	GIMBAL_MANAGER_CAP_FLAGS_HAS_YAW_FOLLOW,
	GIMBAL_MANAGER_CAP_FLAGS_HAS_YAW_LOCK,
	GIMBAL_MANAGER_CAP_FLAGS_SUPPORTS_INFINITE_YAW,
	GIMBAL_MANAGER_CAP_FLAGS_SUPPORTS_YAW_IN_EARTH_FRAME,
	GIMBAL_MANAGER_CAP_FLAGS_HAS_RC_INPUTS,
	GIMBAL_MANAGER_CAP_FLAGS_CAN_POINT_LOCATION_LOCAL,
	GIMBAL_MANAGER_CAP_FLAGS_CAN_POINT_LOCATION_GLOBAL,
}

var value_to_label_GIMBAL_MANAGER_CAP_FLAGS = map[GIMBAL_MANAGER_CAP_FLAGS]string{
	GIMBAL_MANAGER_CAP_FLAGS_HAS_RETRACT:                 "GIMBAL_MANAGER_CAP_FLAGS_HAS_RETRACT",
	GIMBAL_MANAGER_CAP_FLAGS_HAS_NEUTRAL:                 "GIMBAL_MANAGER_CAP_FLAGS_HAS_NEUTRAL",
	GIMBAL_MANAGER_CAP_FLAGS_HAS_ROLL_AXIS:               "GIMBAL_MANAGER_CAP_FLAGS_HAS_ROLL_AXIS",
	GIMBAL_MANAGER_CAP_FLAGS_HAS_ROLL_FOLLOW:             "GIMBAL_MANAGER_CAP_FLAGS_HAS_ROLL_FOLLOW",
	GIMBAL_MANAGER_CAP_FLAGS_HAS_ROLL_LOCK:               "GIMBAL_MANAGER_CAP_FLAGS_HAS_ROLL_LOCK",
	GIMBAL_MANAGER_CAP_FLAGS_HAS_PITCH_AXIS:              "GIMBAL_MANAGER_CAP_FLAGS_HAS_PITCH_AXIS",
	GIMBAL_MANAGER_CAP_FLAGS_HAS_PITCH_FOLLOW:            "GIMBAL_MANAGER_CAP_FLAGS_HAS_PITCH_FOLLOW",
	GIMBAL_MANAGER_CAP_FLAGS_HAS_PITCH_LOCK:              "GIMBAL_MANAGER_CAP_FLAGS_HAS_PITCH_LOCK",
	GIMBAL_MANAGER_CAP_FLAGS_HAS_YAW_AXIS:                "GIMBAL_MANAGER_CAP_FLAGS_HAS_YAW_AXIS",
	GIMBAL_MANAGER_CAP_FLAGS_HAS_YAW_FOLLOW:              "GIMBAL_MANAGER_CAP_FLAGS_HAS_YAW_FOLLOW",
	GIMBAL_MANAGER_CAP_FLAGS_HAS_YAW_LOCK:                "GIMBAL_MANAGER_CAP_FLAGS_HAS_YAW_LOCK",
	GIMBAL_MANAGER_CAP_FLAGS_SUPPORTS_INFINITE_YAW:       "GIMBAL_MANAGER_CAP_FLAGS_SUPPORTS_INFINITE_YAW",
	GIMBAL_MANAGER_CAP_FLAGS_SUPPORTS_YAW_IN_EARTH_FRAME: "GIMBAL_MANAGER_CAP_FLAGS_SUPPORTS_YAW_IN_EARTH_FRAME",
	GIMBAL_MANAGER_CAP_FLAGS_HAS_RC_INPUTS:               "GIMBAL_MANAGER_CAP_FLAGS_HAS_RC_INPUTS",
	GIMBAL_MANAGER_CAP_FLAGS_CAN_POINT_LOCATION_LOCAL:    "GIMBAL_MANAGER_CAP_FLAGS_CAN_POINT_LOCATION_LOCAL",
	GIMBAL_MANAGER_CAP_FLAGS_CAN_POINT_LOCATION_GLOBAL:   "GIMBAL_MANAGER_CAP_FLAGS_CAN_POINT_LOCATION_GLOBAL",
}

var label_to_value_GIMBAL_MANAGER_CAP_FLAGS = map[string]GIMBAL_MANAGER_CAP_FLAGS{
	"GIMBAL_MANAGER_CAP_FLAGS_HAS_RETRACT":                 GIMBAL_MANAGER_CAP_FLAGS_HAS_RETRACT,
	"GIMBAL_MANAGER_CAP_FLAGS_HAS_NEUTRAL":                 GIMBAL_MANAGER_CAP_FLAGS_HAS_NEUTRAL,
	"GIMBAL_MANAGER_CAP_FLAGS_HAS_ROLL_AXIS":               GIMBAL_MANAGER_CAP_FLAGS_HAS_ROLL_AXIS,
	"GIMBAL_MANAGER_CAP_FLAGS_HAS_ROLL_FOLLOW":             GIMBAL_MANAGER_CAP_FLAGS_HAS_ROLL_FOLLOW,
	"GIMBAL_MANAGER_CAP_FLAGS_HAS_ROLL_LOCK":               GIMBAL_MANAGER_CAP_FLAGS_HAS_ROLL_LOCK,
	"GIMBAL_MANAGER_CAP_FLAGS_HAS_PITCH_AXIS":              GIMBAL_MANAGER_CAP_FLAGS_HAS_PITCH_AXIS,
	"GIMBAL_MANAGER_CAP_FLAGS_HAS_PITCH_FOLLOW":            GIMBAL_MANAGER_CAP_FLAGS_HAS_PITCH_FOLLOW,
	"GIMBAL_MANAGER_CAP_FLAGS_HAS_PITCH_LOCK":              GIMBAL_MANAGER_CAP_FLAGS_HAS_PITCH_LOCK,
	"GIMBAL_MANAGER_CAP_FLAGS_HAS_YAW_AXIS":                GIMBAL_MANAGER_CAP_FLAGS_HAS_YAW_AXIS,
	"GIMBAL_MANAGER_CAP_FLAGS_HAS_YAW_FOLLOW":              GIMBAL_MANAGER_CAP_FLAGS_HAS_YAW_FOLLOW,
	"GIMBAL_MANAGER_CAP_FLAGS_HAS_YAW_LOCK":                GIMBAL_MANAGER_CAP_FLAGS_HAS_YAW_LOCK,
	"GIMBAL_MANAGER_CAP_FLAGS_SUPPORTS_INFINITE_YAW":       GIMBAL_MANAGER_CAP_FLAGS_SUPPORTS_INFINITE_YAW,
	"GIMBAL_MANAGER_CAP_FLAGS_SUPPORTS_YAW_IN_EARTH_FRAME": GIMBAL_MANAGER_CAP_FLAGS_SUPPORTS_YAW_IN_EARTH_FRAME,
	"GIMBAL_MANAGER_CAP_FLAGS_HAS_RC_INPUTS":               GIMBAL_MANAGER_CAP_FLAGS_HAS_RC_INPUTS,
	"GIMBAL_MANAGER_CAP_FLAGS_CAN_POINT_LOCATION_LOCAL":    GIMBAL_MANAGER_CAP_FLAGS_CAN_POINT_LOCATION_LOCAL,
	"GIMBAL_MANAGER_CAP_FLAGS_CAN_POINT_LOCATION_GLOBAL":   GIMBAL_MANAGER_CAP_FLAGS_CAN_POINT_LOCATION_GLOBAL,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e GIMBAL_MANAGER_CAP_FLAGS) MarshalText() ([]byte, error) {
	if e == 0 {
		return []byte("0"), nil
	}
	var names []string
	for _, val := range values_GIMBAL_MANAGER_CAP_FLAGS {
		if e&val == val {
			names = append(names, value_to_label_GIMBAL_MANAGER_CAP_FLAGS[val])
		}
	}
	return []byte(strings.Join(names, " | ")), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *GIMBAL_MANAGER_CAP_FLAGS) UnmarshalText(text []byte) error {
	labels := strings.Split(string(text), " | ")
	var mask GIMBAL_MANAGER_CAP_FLAGS
	for _, label := range labels {
		if value, ok := label_to_value_GIMBAL_MANAGER_CAP_FLAGS[label]; ok {
			mask |= value
		} else if value, err := strconv.Atoi(label); err == nil {
			mask |= GIMBAL_MANAGER_CAP_FLAGS(value)
		} else {
			return fmt.Errorf("invalid label '%s'", label)
		}
	}
	*e = mask
	return nil
}

// String implements the fmt.Stringer interface.
func (e GIMBAL_MANAGER_CAP_FLAGS) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
