//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package ardupilotmega

import (
	"fmt"
	"strconv"
)

type GIMBAL_AXIS_CALIBRATION_REQUIRED uint64

const (
	// Whether or not this axis requires calibration is unknown at this time.
	GIMBAL_AXIS_CALIBRATION_REQUIRED_UNKNOWN GIMBAL_AXIS_CALIBRATION_REQUIRED = 0
	// This axis requires calibration.
	GIMBAL_AXIS_CALIBRATION_REQUIRED_TRUE GIMBAL_AXIS_CALIBRATION_REQUIRED = 1
	// This axis does not require calibration.
	GIMBAL_AXIS_CALIBRATION_REQUIRED_FALSE GIMBAL_AXIS_CALIBRATION_REQUIRED = 2
)

var value_to_label_GIMBAL_AXIS_CALIBRATION_REQUIRED = map[GIMBAL_AXIS_CALIBRATION_REQUIRED]string{
	GIMBAL_AXIS_CALIBRATION_REQUIRED_UNKNOWN: "GIMBAL_AXIS_CALIBRATION_REQUIRED_UNKNOWN",
	GIMBAL_AXIS_CALIBRATION_REQUIRED_TRUE:    "GIMBAL_AXIS_CALIBRATION_REQUIRED_TRUE",
	GIMBAL_AXIS_CALIBRATION_REQUIRED_FALSE:   "GIMBAL_AXIS_CALIBRATION_REQUIRED_FALSE",
}

var label_to_value_GIMBAL_AXIS_CALIBRATION_REQUIRED = map[string]GIMBAL_AXIS_CALIBRATION_REQUIRED{
	"GIMBAL_AXIS_CALIBRATION_REQUIRED_UNKNOWN": GIMBAL_AXIS_CALIBRATION_REQUIRED_UNKNOWN,
	"GIMBAL_AXIS_CALIBRATION_REQUIRED_TRUE":    GIMBAL_AXIS_CALIBRATION_REQUIRED_TRUE,
	"GIMBAL_AXIS_CALIBRATION_REQUIRED_FALSE":   GIMBAL_AXIS_CALIBRATION_REQUIRED_FALSE,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e GIMBAL_AXIS_CALIBRATION_REQUIRED) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_GIMBAL_AXIS_CALIBRATION_REQUIRED[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *GIMBAL_AXIS_CALIBRATION_REQUIRED) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_GIMBAL_AXIS_CALIBRATION_REQUIRED[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = GIMBAL_AXIS_CALIBRATION_REQUIRED(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e GIMBAL_AXIS_CALIBRATION_REQUIRED) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
