package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"errors"
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/converter"

	"strings"
)

// CreateKeypairResp SSH密钥对信息详情
type CreateKeypairResp struct {

	// SSH密钥对的名称
	Name *string `json:"name,omitempty"`

	// SSH密钥对的类型。ssh或x509。
	Type *CreateKeypairRespType `json:"type,omitempty"`

	// SSH密钥对对应的publicKey信息
	PublicKey *string `json:"public_key,omitempty"`

	// SSH密钥对对应的privateKey信息 - 创建SSH密钥对时，响应中包括private_key的信息。 - 导入SSH密钥对时，响应中不包括private_key的信息。
	PrivateKey *string `json:"private_key,omitempty"`

	// SSH密钥对应指纹信息
	Fingerprint *string `json:"fingerprint,omitempty"`

	// SSH密钥对所属的用户信息
	UserId *string `json:"user_id,omitempty"`
}

func (o CreateKeypairResp) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "CreateKeypairResp struct{}"
	}

	return strings.Join([]string{"CreateKeypairResp", string(data)}, " ")
}

type CreateKeypairRespType struct {
	value string
}

type CreateKeypairRespTypeEnum struct {
	SSH  CreateKeypairRespType
	X509 CreateKeypairRespType
}

func GetCreateKeypairRespTypeEnum() CreateKeypairRespTypeEnum {
	return CreateKeypairRespTypeEnum{
		SSH: CreateKeypairRespType{
			value: "ssh",
		},
		X509: CreateKeypairRespType{
			value: "x509",
		},
	}
}

func (c CreateKeypairRespType) Value() string {
	return c.value
}

func (c CreateKeypairRespType) MarshalJSON() ([]byte, error) {
	return utils.Marshal(c.value)
}

func (c *CreateKeypairRespType) UnmarshalJSON(b []byte) error {
	myConverter := converter.StringConverterFactory("string")
	if myConverter == nil {
		return errors.New("unsupported StringConverter type: string")
	}

	interf, err := myConverter.CovertStringToInterface(strings.Trim(string(b[:]), "\""))
	if err != nil {
		return err
	}

	if val, ok := interf.(string); ok {
		c.value = val
		return nil
	} else {
		return errors.New("convert enum data to string error")
	}
}
