package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

// CreateTagResponse Response Object
type CreateTagResponse struct {

	// 标签标识
	Id *int64 `json:"id,omitempty"`

	// 标签名称
	TagName *string `json:"tag_name,omitempty"`

	// 标签状态，0未使用，1使用中。
	Status         *int32 `json:"status,omitempty"`
	HttpStatusCode int    `json:"-"`
}

func (o CreateTagResponse) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "CreateTagResponse struct{}"
	}

	return strings.Join([]string{"CreateTagResponse", string(data)}, " ")
}
