/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.util;

import java.io.InputStream;
import java.io.RandomAccessFile;

public final class RandomAccessFileInputStream
extends InputStream {
    public int filePosition;
    public final RandomAccessFile raf;

    public RandomAccessFileInputStream(RandomAccessFile randomAccessFile, int n) {
        this.filePosition = n;
        this.raf = randomAccessFile;
    }

    @Override
    public final int read() {
        RandomAccessFileInputStream randomAccessFileInputStream = this;
        randomAccessFileInputStream.raf.seek(this.filePosition);
        ++randomAccessFileInputStream.filePosition;
        return randomAccessFileInputStream.raf.read();
    }

    @Override
    public final int read(byte[] byArray) {
        RandomAccessFileInputStream randomAccessFileInputStream = this;
        randomAccessFileInputStream.raf.seek(this.filePosition);
        int n = randomAccessFileInputStream.raf.read(byArray);
        this.filePosition += n;
        return n;
    }

    @Override
    public final int read(byte[] byArray, int n, int n2) {
        RandomAccessFileInputStream randomAccessFileInputStream = this;
        randomAccessFileInputStream.raf.seek(this.filePosition);
        int n3 = randomAccessFileInputStream.raf.read(byArray, n, n2);
        this.filePosition += n3;
        return n3;
    }

    @Override
    public final long skip(long l) {
        int n = Math.min((int)l, this.available());
        this.filePosition += n;
        return n;
    }

    @Override
    public final int available() {
        return (int)this.raf.length() - this.filePosition;
    }

    @Override
    public final boolean markSupported() {
        return false;
    }
}

